/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.codegen.testmodel;

import io.vertx.codegen.testmodel.AbstractHandlerUserType;
import io.vertx.codegen.testmodel.ConcreteHandlerUserType;
import io.vertx.codegen.testmodel.ConcreteHandlerUserTypeExtension;
import io.vertx.codegen.testmodel.GenericRefedInterface;
import io.vertx.codegen.testmodel.GenericRefedInterfaceImpl;
import io.vertx.codegen.testmodel.RefedInterface1;
import io.vertx.codegen.testmodel.RefedInterface1Impl;
import io.vertx.codegen.testmodel.RefedInterface2;
import io.vertx.codegen.testmodel.RefedInterface2Impl;
import io.vertx.codegen.testmodel.TestDataObject;
import io.vertx.codegen.testmodel.TestEnum;
import io.vertx.codegen.testmodel.TestGenEnum;
import io.vertx.codegen.testmodel.TestInterface;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.VertxException;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import java.util.Arrays;
import java.util.List;
import org.junit.Assert;

public class TestInterfaceImpl
implements TestInterface {
    private static <T> T assertInstanceOf(Class<T> expectedType, Object obj) {
        if (expectedType.isInstance(obj)) {
            return expectedType.cast(obj);
        }
        throw new AssertionError((Object)("Was expecting " + obj + " to be an instance of " + expectedType));
    }

    @Override
    public void methodWithBasicParams(byte b, short s, int i, long l, float f, double d, boolean bool, char ch, String str) {
        Assert.assertEquals((long)123L, (long)b);
        Assert.assertEquals((long)12345L, (long)s);
        Assert.assertEquals((long)1234567L, (long)i);
        Assert.assertEquals((long)1265615234L, (long)l);
        Assert.assertEquals((float)12.345f, (float)f, (float)0.0f);
        Assert.assertEquals((double)12.34566, (double)d, (double)0.0);
        Assert.assertTrue((boolean)bool);
        Assert.assertEquals((long)88L, (long)ch);
        Assert.assertEquals((Object)"foobar", (Object)str);
    }

    @Override
    public void methodWithBasicBoxedParams(Byte b, Short s, Integer i, Long l, Float f, Double d, Boolean bool, Character ch) {
        Assert.assertEquals((long)123L, (long)b.byteValue());
        Assert.assertEquals((long)12345L, (long)s.shortValue());
        Assert.assertEquals((long)1234567L, (long)i.intValue());
        Assert.assertEquals((long)1265615234L, (long)l);
        Assert.assertEquals((float)12.345f, (float)f.floatValue(), (float)0.0f);
        Assert.assertEquals((double)12.34566, (double)d, (double)0.0);
        Assert.assertTrue((boolean)bool);
        Assert.assertEquals((long)88L, (long)ch.charValue());
    }

    @Override
    public void methodWithHandlerBasicTypes(Handler<Byte> byteHandler, Handler<Short> shortHandler, Handler<Integer> intHandler, Handler<Long> longHandler, Handler<Float> floatHandler, Handler<Double> doubleHandler, Handler<Boolean> booleanHandler, Handler<Character> charHandler, Handler<String> stringHandler) {
        byteHandler.handle((Object)123);
        shortHandler.handle((Object)12345);
        intHandler.handle((Object)1234567);
        longHandler.handle((Object)1265615234L);
        floatHandler.handle((Object)Float.valueOf(12.345f));
        doubleHandler.handle((Object)12.34566);
        booleanHandler.handle((Object)true);
        charHandler.handle((Object)Character.valueOf('X'));
        stringHandler.handle((Object)"quux!");
    }

    @Override
    public Handler<String> methodWithHandlerStringReturn(String expected) {
        return event -> Assert.assertEquals((Object)expected, (Object)event);
    }

    @Override
    public <T> Handler<T> methodWithHandlerGenericReturn(Handler<T> handler) {
        return arg_0 -> handler.handle(arg_0);
    }

    @Override
    public Handler<RefedInterface1> methodWithHandlerVertxGenReturn(String expected) {
        return event -> Assert.assertEquals((Object)expected, (Object)event.getString());
    }

    @Override
    public void methodWithHandlerAsyncResultByte(boolean sendFailure, Handler<AsyncResult<Byte>> handler) {
        if (sendFailure) {
            Exception e = new Exception("foobar!");
            handler.handle((Object)Future.failedFuture((Throwable)e));
        } else {
            handler.handle((Object)Future.succeededFuture((Object)123));
        }
    }

    @Override
    public void methodWithHandlerAsyncResultShort(boolean sendFailure, Handler<AsyncResult<Short>> handler) {
        if (sendFailure) {
            Exception e = new Exception("foobar!");
            handler.handle((Object)Future.failedFuture((Throwable)e));
        } else {
            handler.handle((Object)Future.succeededFuture((Object)12345));
        }
    }

    @Override
    public void methodWithHandlerAsyncResultInteger(boolean sendFailure, Handler<AsyncResult<Integer>> handler) {
        if (sendFailure) {
            Exception e = new Exception("foobar!");
            handler.handle((Object)Future.failedFuture((Throwable)e));
        } else {
            handler.handle((Object)Future.succeededFuture((Object)1234567));
        }
    }

    @Override
    public void methodWithHandlerAsyncResultLong(boolean sendFailure, Handler<AsyncResult<Long>> handler) {
        if (sendFailure) {
            Exception e = new Exception("foobar!");
            handler.handle((Object)Future.failedFuture((Throwable)e));
        } else {
            handler.handle((Object)Future.succeededFuture((Object)1265615234L));
        }
    }

    @Override
    public void methodWithHandlerAsyncResultFloat(boolean sendFailure, Handler<AsyncResult<Float>> handler) {
        if (sendFailure) {
            Exception e = new Exception("foobar!");
            handler.handle((Object)Future.failedFuture((Throwable)e));
        } else {
            handler.handle((Object)Future.succeededFuture((Object)Float.valueOf(12.345f)));
        }
    }

    @Override
    public void methodWithHandlerAsyncResultDouble(boolean sendFailure, Handler<AsyncResult<Double>> handler) {
        if (sendFailure) {
            Exception e = new Exception("foobar!");
            handler.handle((Object)Future.failedFuture((Throwable)e));
        } else {
            handler.handle((Object)Future.succeededFuture((Object)12.34566));
        }
    }

    @Override
    public void methodWithHandlerAsyncResultBoolean(boolean sendFailure, Handler<AsyncResult<Boolean>> handler) {
        if (sendFailure) {
            Exception e = new Exception("foobar!");
            handler.handle((Object)Future.failedFuture((Throwable)e));
        } else {
            handler.handle((Object)Future.succeededFuture((Object)true));
        }
    }

    @Override
    public void methodWithHandlerAsyncResultCharacter(boolean sendFailure, Handler<AsyncResult<Character>> handler) {
        if (sendFailure) {
            Exception e = new Exception("foobar!");
            handler.handle((Object)Future.failedFuture((Throwable)e));
        } else {
            handler.handle((Object)Future.succeededFuture((Object)Character.valueOf('X')));
        }
    }

    @Override
    public void methodWithHandlerAsyncResultString(boolean sendFailure, Handler<AsyncResult<String>> handler) {
        if (sendFailure) {
            Exception e = new Exception("foobar!");
            handler.handle((Object)Future.failedFuture((Throwable)e));
        } else {
            handler.handle((Object)Future.succeededFuture((Object)"quux!"));
        }
    }

    @Override
    public void methodWithHandlerAsyncResultDataObject(boolean sendFailure, Handler<AsyncResult<TestDataObject>> handler) {
        if (sendFailure) {
            Exception e = new Exception("foobar!");
            handler.handle((Object)Future.failedFuture((Throwable)e));
        } else {
            handler.handle((Object)Future.succeededFuture((Object)new TestDataObject().setFoo("foo").setBar(123)));
        }
    }

    @Override
    public Handler<AsyncResult<String>> methodWithHandlerAsyncResultStringReturn(String expected, boolean fail) {
        return ar -> {
            if (!fail) {
                Assert.assertTrue((boolean)ar.succeeded());
                Assert.assertEquals((Object)expected, (Object)ar.result());
            } else {
                Assert.assertEquals((Object)false, (Object)ar.succeeded());
                Assert.assertEquals((Object)expected, (Object)ar.cause().getMessage());
            }
        };
    }

    @Override
    public <T> Handler<AsyncResult<T>> methodWithHandlerAsyncResultGenericReturn(Handler<AsyncResult<T>> handler) {
        return arg_0 -> handler.handle(arg_0);
    }

    @Override
    public Handler<AsyncResult<RefedInterface1>> methodWithHandlerAsyncResultVertxGenReturn(String expected, boolean fail) {
        return ar -> {
            if (!fail) {
                Assert.assertTrue((boolean)ar.succeeded());
                Assert.assertEquals((Object)expected, (Object)((RefedInterface1)ar.result()).getString());
            } else {
                Assert.assertEquals((Object)false, (Object)ar.succeeded());
                Assert.assertEquals((Object)expected, (Object)ar.cause().getMessage());
            }
        };
    }

    @Override
    public void methodWithUserTypes(RefedInterface1 refed) {
        Assert.assertEquals((Object)"aardvarks", (Object)refed.getString());
    }

    @Override
    public void methodWithObjectParam(String str, Object obj) {
        switch (str) {
            case "null": {
                Assert.assertNull((Object)obj);
                break;
            }
            case "string": {
                Assert.assertTrue((boolean)(obj instanceof String));
                String s = (String)obj;
                Assert.assertEquals((Object)"wibble", (Object)s);
                break;
            }
            case "true": {
                Assert.assertTrue((boolean)(obj instanceof Boolean));
                Boolean t = (Boolean)obj;
                Assert.assertEquals((Object)true, (Object)t);
                break;
            }
            case "false": {
                Assert.assertTrue((boolean)(obj instanceof Boolean));
                Boolean f = (Boolean)obj;
                Assert.assertEquals((Object)false, (Object)f);
                break;
            }
            case "long": {
                Assert.assertTrue((boolean)(obj instanceof Number));
                Number l = (Number)obj;
                Assert.assertEquals((long)123L, (long)l.longValue());
                break;
            }
            case "double": {
                Assert.assertTrue((boolean)(obj instanceof Number));
                Number n = (Number)obj;
                Assert.assertEquals((double)123.456, (double)n.doubleValue(), (double)0.0);
                break;
            }
            case "JsonObject": {
                Assert.assertTrue((boolean)(obj instanceof JsonObject));
                JsonObject jsonObject = (JsonObject)obj;
                Assert.assertEquals((Object)"hello", (Object)jsonObject.getString("foo"));
                Assert.assertEquals((long)123L, (long)jsonObject.getInteger("bar").intValue());
                break;
            }
            case "JsonArray": {
                Assert.assertTrue((boolean)(obj instanceof JsonArray));
                JsonArray arr = (JsonArray)obj;
                Assert.assertEquals((long)3L, (long)arr.size());
                Assert.assertEquals((Object)"foo", (Object)arr.getString(0));
                Assert.assertEquals((Object)"bar", (Object)arr.getString(1));
                Assert.assertEquals((Object)"wib", (Object)arr.getString(2));
                break;
            }
            default: {
                Assert.fail((String)"invalid type");
            }
        }
    }

    @Override
    public void methodWithDataObjectParam(TestDataObject dataObject) {
        Assert.assertEquals((Object)"hello", (Object)dataObject.getFoo());
        Assert.assertEquals((long)123L, (long)dataObject.getBar());
        Assert.assertEquals((double)1.23, (double)dataObject.getWibble(), (double)0.0);
    }

    @Override
    public void methodWithHandlerUserTypes(Handler<RefedInterface1> handler) {
        RefedInterface1Impl refed = new RefedInterface1Impl();
        refed.setString("echidnas");
        handler.handle((Object)refed);
    }

    @Override
    public void methodWithHandlerAsyncResultUserTypes(Handler<AsyncResult<RefedInterface1>> handler) {
        RefedInterface1Impl refed = new RefedInterface1Impl();
        refed.setString("cheetahs");
        handler.handle((Object)Future.succeededFuture((Object)refed));
    }

    @Override
    public void methodWithConcreteHandlerUserTypeSubtype(ConcreteHandlerUserType handler) {
        RefedInterface1Impl refed = new RefedInterface1Impl();
        refed.setString("echidnas");
        handler.handle(refed);
    }

    @Override
    public void methodWithAbstractHandlerUserTypeSubtype(AbstractHandlerUserType handler) {
        RefedInterface1Impl refed = new RefedInterface1Impl();
        refed.setString("echidnas");
        handler.handle(refed);
    }

    @Override
    public void methodWithConcreteHandlerUserTypeSubtypeExtension(ConcreteHandlerUserTypeExtension handler) {
        RefedInterface1Impl refed = new RefedInterface1Impl();
        refed.setString("echidnas");
        handler.handle(refed);
    }

    @Override
    public void methodWithHandlerVoid(Handler<Void> handler) {
        handler.handle(null);
    }

    @Override
    public void methodWithHandlerAsyncResultVoid(boolean sendFailure, Handler<AsyncResult<Void>> handler) {
        if (sendFailure) {
            handler.handle((Object)Future.failedFuture((Throwable)new VertxException("foo!")));
        } else {
            handler.handle((Object)Future.succeededFuture((Object)null));
        }
    }

    @Override
    public void methodWithHandlerThrowable(Handler<Throwable> handler) {
        handler.handle((Object)new VertxException("cheese!"));
    }

    @Override
    public void methodWithHandlerDataObject(Handler<TestDataObject> handler) {
        handler.handle((Object)this.methodWithDataObjectReturn());
    }

    @Override
    public <U> void methodWithHandlerGenericUserType(U value, Handler<GenericRefedInterface<U>> handler) {
        handler.handle(this.methodWithGenericUserTypeReturn(value));
    }

    @Override
    public <U> void methodWithHandlerAsyncResultGenericUserType(U value, Handler<AsyncResult<GenericRefedInterface<U>>> handler) {
        handler.handle((Object)Future.succeededFuture(this.methodWithGenericUserTypeReturn(value)));
    }

    @Override
    public <U> GenericRefedInterface<U> methodWithGenericUserTypeReturn(U value) {
        GenericRefedInterfaceImpl<U> userObj = new GenericRefedInterfaceImpl<U>();
        userObj.setValue(value);
        return userObj;
    }

    @Override
    public byte methodWithByteReturn() {
        return 123;
    }

    @Override
    public short methodWithShortReturn() {
        return 12345;
    }

    @Override
    public int methodWithIntReturn() {
        return 12345464;
    }

    @Override
    public long methodWithLongReturn() {
        return 65675123L;
    }

    @Override
    public float methodWithFloatReturn() {
        return 1.23f;
    }

    @Override
    public double methodWithDoubleReturn() {
        return 3.34535;
    }

    @Override
    public boolean methodWithBooleanReturn() {
        return true;
    }

    @Override
    public char methodWithCharReturn() {
        return 'Y';
    }

    @Override
    public String methodWithStringReturn() {
        return "orangutan";
    }

    @Override
    public RefedInterface1 methodWithVertxGenReturn() {
        RefedInterface1Impl refed = new RefedInterface1Impl();
        refed.setString("chaffinch");
        return refed;
    }

    @Override
    public RefedInterface1 methodWithVertxGenNullReturn() {
        return null;
    }

    @Override
    public RefedInterface2 methodWithAbstractVertxGenReturn() {
        RefedInterface2Impl refed = new RefedInterface2Impl();
        refed.setString("abstractchaffinch");
        return refed;
    }

    @Override
    public TestDataObject methodWithDataObjectReturn() {
        return new TestDataObject().setFoo("foo").setBar(123);
    }

    @Override
    public TestDataObject methodWithDataObjectNullReturn() {
        return null;
    }

    @Override
    public String overloadedMethod(String str, RefedInterface1 refed) {
        Assert.assertEquals((Object)"cat", (Object)str);
        Assert.assertEquals((Object)"dog", (Object)refed.getString());
        return "meth1";
    }

    @Override
    public String overloadedMethod(String str, RefedInterface1 refed, long period, Handler<String> handler) {
        Assert.assertEquals((Object)"cat", (Object)str);
        Assert.assertEquals((Object)"dog", (Object)refed.getString());
        Assert.assertEquals((long)12345L, (long)period);
        Assert.assertNotNull(handler);
        handler.handle((Object)"giraffe");
        return "meth2";
    }

    @Override
    public String overloadedMethod(String str, Handler<String> handler) {
        Assert.assertEquals((Object)"cat", (Object)str);
        Assert.assertNotNull(handler);
        handler.handle((Object)"giraffe");
        return "meth3";
    }

    @Override
    public String overloadedMethod(String str, RefedInterface1 refed, Handler<String> handler) {
        Assert.assertEquals((Object)"cat", (Object)str);
        Assert.assertEquals((Object)"dog", (Object)refed.getString());
        Assert.assertNotNull(handler);
        handler.handle((Object)"giraffe");
        return "meth4";
    }

    @Override
    public void superMethodWithBasicParams(byte b, short s, int i, long l, float f, double d, boolean bool, char ch, String str) {
        Assert.assertEquals((long)123L, (long)b);
        Assert.assertEquals((long)12345L, (long)s);
        Assert.assertEquals((long)1234567L, (long)i);
        Assert.assertEquals((long)1265615234L, (long)l);
        Assert.assertEquals((float)12.345f, (float)f, (float)0.0f);
        Assert.assertEquals((double)12.34566, (double)d, (double)0.0);
        Assert.assertTrue((boolean)bool);
        Assert.assertEquals((long)88L, (long)ch);
        Assert.assertEquals((Object)"foobar", (Object)str);
    }

    @Override
    public void otherSuperMethodWithBasicParams(byte b, short s, int i, long l, float f, double d, boolean bool, char ch, String str) {
        this.superMethodWithBasicParams(b, s, i, l, f, d, bool, ch, str);
    }

    @Override
    public <U> U methodWithGenericReturn(String type) {
        switch (type) {
            case "Boolean": {
                return (U)Boolean.valueOf(true);
            }
            case "Byte": {
                return (U)Byte.valueOf((byte)123);
            }
            case "Short": {
                return (U)Short.valueOf((short)12345);
            }
            case "Integer": {
                return (U)Integer.valueOf(1234567);
            }
            case "Long": {
                return (U)Long.valueOf(1265615234L);
            }
            case "Float": {
                return (U)Float.valueOf(12.345f);
            }
            case "Double": {
                return (U)Double.valueOf(12.34566);
            }
            case "Character": {
                return (U)Character.valueOf('x');
            }
            case "String": {
                return (U)"foo";
            }
            case "Ref": {
                return (U)new RefedInterface1Impl().setString("bar");
            }
            case "JsonObject": {
                return (U)new JsonObject().put("foo", "hello").put("bar", Integer.valueOf(123));
            }
            case "JsonObjectLong": {
                return (U)new JsonObject().put("foo", "hello").put("bar", Long.valueOf(123L));
            }
            case "JsonObjectComplex": {
                return (U)new JsonObject().put("outer", new JsonObject().put("foo", "hello")).put("bar", new JsonArray().add("this").add("that"));
            }
            case "JsonArray": {
                return (U)new JsonArray().add("foo").add("bar").add("wib");
            }
        }
        throw new AssertionError((Object)("Unexpected " + type));
    }

    @Override
    public <U> void methodWithGenericParam(String type, U u) {
        U expected = this.methodWithGenericReturn(type);
        Assert.assertEquals(expected.getClass(), u.getClass());
        Assert.assertEquals(expected, u);
    }

    @Override
    public <U> void methodWithGenericHandler(String type, Handler<U> handler) {
        U value = this.methodWithGenericReturn(type);
        handler.handle(value);
    }

    @Override
    public <U> void methodWithGenericHandlerAsyncResult(String type, Handler<AsyncResult<U>> asyncResultHandler) {
        U value = this.methodWithGenericReturn(type);
        asyncResultHandler.handle((Object)Future.succeededFuture(value));
    }

    @Override
    public TestInterface fluentMethod(String str) {
        Assert.assertEquals((Object)"bar", (Object)str);
        return this;
    }

    @Override
    public RefedInterface1 methodWithCachedReturn(String foo) {
        RefedInterface1Impl refed = new RefedInterface1Impl();
        refed.setString(foo);
        return refed;
    }

    @Override
    public int methodWithCachedReturnPrimitive(int arg) {
        return arg;
    }

    @Override
    public List<RefedInterface1> methodWithCachedListReturn() {
        return Arrays.asList(new RefedInterface1Impl().setString("foo"), new RefedInterface1Impl().setString("bar"));
    }

    @Override
    public JsonObject methodWithJsonObjectReturn() {
        return new JsonObject().put("cheese", "stilton");
    }

    @Override
    public JsonObject methodWithNullJsonObjectReturn() {
        return null;
    }

    @Override
    public JsonObject methodWithComplexJsonObjectReturn() {
        return new JsonObject().put("outer", new JsonObject().put("socks", "tartan")).put("list", new JsonArray().add("yellow").add("blue"));
    }

    @Override
    public JsonArray methodWithJsonArrayReturn() {
        return new JsonArray().add("socks").add("shoes");
    }

    @Override
    public JsonArray methodWithNullJsonArrayReturn() {
        return null;
    }

    @Override
    public JsonArray methodWithComplexJsonArrayReturn() {
        return new JsonArray().add(new JsonObject().put("foo", "hello")).add(new JsonObject().put("bar", "bye"));
    }

    @Override
    public void methodWithJsonParams(JsonObject jsonObject, JsonArray jsonArray) {
        Assert.assertNotNull((Object)jsonObject);
        Assert.assertNotNull((Object)jsonArray);
        Assert.assertEquals((Object)"lion", (Object)jsonObject.getString("cat"));
        Assert.assertEquals((Object)"cheddar", (Object)jsonObject.getString("cheese"));
        Assert.assertEquals((Object)"house", (Object)jsonArray.getString(0));
        Assert.assertEquals((Object)"spider", (Object)jsonArray.getString(1));
    }

    @Override
    public void methodWithNullJsonParams(JsonObject jsonObject, JsonArray jsonArray) {
        Assert.assertNull((Object)jsonObject);
        Assert.assertNull((Object)jsonArray);
    }

    @Override
    public void methodWithHandlerJson(Handler<JsonObject> jsonObjectHandler, Handler<JsonArray> jsonArrayHandler) {
        Assert.assertNotNull(jsonObjectHandler);
        Assert.assertNotNull(jsonArrayHandler);
        jsonObjectHandler.handle((Object)new JsonObject().put("cheese", "stilton"));
        jsonArrayHandler.handle((Object)new JsonArray().add("socks").add("shoes"));
    }

    @Override
    public void methodWithHandlerComplexJson(Handler<JsonObject> jsonObjectHandler, Handler<JsonArray> jsonArrayHandler) {
        Assert.assertNotNull(jsonObjectHandler);
        Assert.assertNotNull(jsonArrayHandler);
        jsonObjectHandler.handle((Object)new JsonObject().put("outer", new JsonObject().put("socks", "tartan")).put("list", new JsonArray().add("yellow").add("blue")));
        jsonArrayHandler.handle((Object)new JsonArray().add(new JsonArray().add(new JsonObject().put("foo", "hello"))).add(new JsonArray().add(new JsonObject().put("bar", "bye"))));
    }

    @Override
    public void methodWithHandlerAsyncResultJsonObject(Handler<AsyncResult<JsonObject>> handler) {
        Assert.assertNotNull(handler);
        handler.handle((Object)Future.succeededFuture((Object)new JsonObject().put("cheese", "stilton")));
    }

    @Override
    public void methodWithHandlerAsyncResultNullJsonObject(Handler<AsyncResult<JsonObject>> handler) {
        Assert.assertNotNull(handler);
        handler.handle((Object)Future.succeededFuture(null));
    }

    @Override
    public void methodWithHandlerAsyncResultComplexJsonObject(Handler<AsyncResult<JsonObject>> handler) {
        Assert.assertNotNull(handler);
        handler.handle((Object)Future.succeededFuture((Object)new JsonObject().put("outer", new JsonObject().put("socks", "tartan")).put("list", new JsonArray().add("yellow").add("blue"))));
    }

    @Override
    public void methodWithHandlerAsyncResultJsonArray(Handler<AsyncResult<JsonArray>> handler) {
        Assert.assertNotNull(handler);
        handler.handle((Object)Future.succeededFuture((Object)new JsonArray().add("socks").add("shoes")));
    }

    @Override
    public void methodWithHandlerAsyncResultNullJsonArray(Handler<AsyncResult<JsonArray>> handler) {
        Assert.assertNotNull(handler);
        handler.handle((Object)Future.succeededFuture(null));
    }

    @Override
    public void methodWithHandlerAsyncResultComplexJsonArray(Handler<AsyncResult<JsonArray>> handler) {
        Assert.assertNotNull(handler);
        handler.handle((Object)Future.succeededFuture((Object)new JsonArray().add(new JsonObject().put("foo", "hello")).add(new JsonObject().put("bar", "bye"))));
    }

    @Override
    public String methodWithEnumParam(String strVal, TestEnum weirdo) {
        return strVal + (Object)((Object)weirdo);
    }

    @Override
    public TestEnum methodWithEnumReturn(String strVal) {
        return TestEnum.valueOf(strVal);
    }

    @Override
    public String methodWithGenEnumParam(String strVal, TestGenEnum weirdo) {
        return strVal + (Object)((Object)weirdo);
    }

    @Override
    public TestGenEnum methodWithGenEnumReturn(String strVal) {
        return TestGenEnum.valueOf(strVal);
    }

    @Override
    public Throwable methodWithThrowableReturn(String strVal) {
        return new Exception(strVal);
    }

    @Override
    public String methodWithThrowableParam(Throwable t) {
        return t.getMessage();
    }

    @Override
    public int superMethodOverloadedBySubclass(String s) {
        return 1;
    }

    @Override
    public int superMethodOverloadedBySubclass() {
        return 0;
    }
}

