/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.rx.java.test;

import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.rx.java.RxHelper;
import io.vertx.test.core.VertxTestBase;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.junit.Test;
import rx.Emitter;
import rx.Observable;
import rx.Single;
import rx.SingleEmitter;
import rx.Subscriber;
import rx.internal.operators.OnSubscribeCreate;
import rx.internal.operators.SingleFromEmitter;

public class SubscriberTest
extends VertxTestBase {
    private static SingleEmitter<String> subscribeToSingle(Subscriber<String> subscriber) {
        AtomicReference emitter = new AtomicReference();
        Single single = Single.create((Single.OnSubscribe)new SingleFromEmitter(emitter::set));
        single.subscribe(subscriber);
        return (SingleEmitter)emitter.get();
    }

    private static Emitter<String> subscribe(Subscriber<String> subscriber) {
        AtomicReference emitter = new AtomicReference();
        Observable observable = Observable.create((Observable.OnSubscribe)new OnSubscribeCreate(emitter::set, Emitter.BackpressureMode.BUFFER));
        observable.subscribe(subscriber);
        return (Emitter)emitter.get();
    }

    @Test
    public void testSingleFutureSubscriptionSuccess() {
        ArrayList<Object> results = new ArrayList<Object>();
        Subscriber sub = RxHelper.toSubscriber(SubscriberTest.handler(results));
        SingleEmitter<String> emitter = SubscriberTest.subscribeToSingle((Subscriber<String>)sub);
        this.assertEquals(Collections.emptyList(), results);
        emitter.onSuccess((Object)"the-value-1");
        this.assertEquals(Collections.singletonList("the-value-1"), results);
        emitter.onSuccess((Object)"the-value-2");
        this.assertEquals(Collections.singletonList("the-value-1"), results);
    }

    @Test
    public void testSingleFutureSubscriptionError() {
        ArrayList<Object> results = new ArrayList<Object>();
        Subscriber sub = RxHelper.toSubscriber(SubscriberTest.handler(results));
        SingleEmitter<String> emitter = SubscriberTest.subscribeToSingle((Subscriber<String>)sub);
        this.assertEquals(Collections.emptyList(), results);
        Throwable cause = new Throwable();
        emitter.onError(cause);
        this.assertEquals(Collections.singletonList(cause), results);
        emitter.onSuccess((Object)"the-value");
        this.assertEquals(Collections.singletonList(cause), results);
    }

    @Test
    public void testObservableFutureSubscriptionCompletedWithNoItems() {
        ArrayList<Object> results = new ArrayList<Object>();
        Subscriber sub = RxHelper.toSubscriber(SubscriberTest.handler(results));
        Emitter<String> emitter = SubscriberTest.subscribe((Subscriber<String>)sub);
        this.assertEquals(Collections.emptyList(), results);
        emitter.onCompleted();
        this.assertEquals(Collections.singletonList(null), results);
        emitter.onNext((Object)"the-value-1");
        this.assertEquals(Collections.singletonList(null), results);
    }

    @Test
    public void testObservableFutureSubscriptionCompletedWithItem() {
        ArrayList<Object> results = new ArrayList<Object>();
        Subscriber sub = RxHelper.toSubscriber(SubscriberTest.handler(results));
        Emitter<String> emitter = SubscriberTest.subscribe((Subscriber<String>)sub);
        this.assertEquals(Collections.emptyList(), results);
        emitter.onNext((Object)"the-value-1");
        this.assertEquals(Collections.singletonList("the-value-1"), results);
        emitter.onCompleted();
        emitter.onNext((Object)"the-value-1");
        this.assertEquals(Collections.singletonList("the-value-1"), results);
    }

    @Test
    public void testObservableFutureSubscriptionCompletedWithItems() {
        ArrayList<Object> results = new ArrayList<Object>();
        Subscriber sub = RxHelper.toSubscriber(SubscriberTest.handler(results));
        Emitter<String> emitter = SubscriberTest.subscribe((Subscriber<String>)sub);
        this.assertEquals(Collections.emptyList(), results);
        emitter.onNext((Object)"the-value-1");
        this.assertEquals(Collections.singletonList("the-value-1"), results);
        emitter.onNext((Object)"the-value-2");
        this.assertEquals(Collections.singletonList("the-value-1"), results);
    }

    @Test
    public void testObservableFutureSubscriptionError() {
        ArrayList<Object> results = new ArrayList<Object>();
        Subscriber sub = RxHelper.toSubscriber(SubscriberTest.handler(results));
        Emitter<String> emitter = SubscriberTest.subscribe((Subscriber<String>)sub);
        this.assertEquals(Collections.emptyList(), results);
        Throwable cause = new Throwable();
        emitter.onError(cause);
        this.assertEquals(Collections.singletonList(cause), results);
        emitter.onNext((Object)"the-value");
        this.assertEquals(Collections.singletonList(cause), results);
    }

    private static <T> Handler<AsyncResult<T>> handler(List<Object> list) {
        return ar -> {
            if (ar.succeeded()) {
                list.add(ar.result());
            } else {
                list.add(ar.cause());
            }
        };
    }
}

