/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.rx.java.test.gen;

import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import org.junit.Assert;

public class AsyncResultChecker {
    public int count = 0;

    public <E> Handler<E> expectedResult(E expected) {
        return this.resultHandler(actual -> Assert.assertEquals((Object)expected, (Object)actual));
    }

    public <E> Handler<E> resultHandler(final Handler<E> expected) {
        return new Handler<E>(){

            public void handle(E event) {
                expected.handle(event);
                ++AsyncResultChecker.this.count;
            }
        };
    }

    public <E> Handler<AsyncResult<E>> asyncExpectedResult(E expected) {
        return this.asyncResultHandler(e -> Assert.assertEquals((Object)expected, (Object)e));
    }

    public <R> Handler<AsyncResult<R>> asyncResultHandler(final Handler<R> f) {
        return new Handler<AsyncResult<R>>(){

            public void handle(AsyncResult<R> event) {
                Assert.assertTrue((boolean)event.succeeded());
                Assert.assertFalse((boolean)event.failed());
                f.handle(event.result());
                ++AsyncResultChecker.this.count;
            }
        };
    }

    public <R> Handler<AsyncResult<R>> failureAsserter(final String expectedMsg) {
        return new Handler<AsyncResult<R>>(){

            public void handle(AsyncResult<R> event) {
                AsyncResultChecker.this.assertAsyncFailure(expectedMsg, event);
            }
        };
    }

    public <T> void assertAsyncFailure(String expectedMsg, AsyncResult<T> result) {
        Assert.assertNull((Object)result.result());
        Assert.assertFalse((boolean)result.succeeded());
        Assert.assertTrue((boolean)result.failed());
        Assert.assertEquals((Object)expectedMsg, (Object)result.cause().getMessage());
        ++this.count;
    }
}

