/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.rx.java.test.gen;

import io.vertx.codegen.testmodel.CollectionTCKImpl;
import io.vertx.codegen.testmodel.RefedInterface1Impl;
import io.vertx.codegen.testmodel.TestDataObject;
import io.vertx.codegen.testmodel.TestEnum;
import io.vertx.core.Handler;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.rx.java.test.gen.ApiTCKTest;
import io.vertx.rx.java.test.gen.AsyncResultChecker;
import io.vertx.rxjava.codegen.testmodel.CollectionTCK;
import io.vertx.rxjava.codegen.testmodel.RefedInterface1;
import io.vertx.rxjava.codegen.testmodel.RefedInterface2;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.junit.Assert;
import org.junit.Test;

public class CollectionTCKTest {
    final CollectionTCK obj = new CollectionTCK(new CollectionTCKImpl());

    @Test
    public void testMethodWithHandlerListAndSet() {
        AsyncResultChecker checker = new AsyncResultChecker();
        this.obj.methodWithHandlerListAndSet(checker.expectedResult(Arrays.asList("foo", "bar", "wibble")), checker.expectedResult(Arrays.asList(5, 12, 100)), checker.expectedResult(new HashSet<String>(Arrays.asList("foo", "bar", "wibble"))), checker.expectedResult(new HashSet<Integer>(Arrays.asList(5, 12, 100))));
        Assert.assertEquals((long)4L, (long)checker.count);
    }

    @Test
    public void testMethodWithHandlerAsyncResultListAndSet() {
        AsyncResultChecker checker = new AsyncResultChecker();
        this.obj.methodWithHandlerAsyncResultListString(checker.asyncExpectedResult(Arrays.asList("foo", "bar", "wibble")));
        this.obj.methodWithHandlerAsyncResultListInteger(checker.asyncExpectedResult(Arrays.asList(5, 12, 100)));
        this.obj.methodWithHandlerAsyncResultSetString(checker.asyncExpectedResult(new HashSet<String>(Arrays.asList("foo", "bar", "wibble"))));
        this.obj.methodWithHandlerAsyncResultSetInteger(checker.asyncExpectedResult(new HashSet<Integer>(Arrays.asList(5, 12, 100))));
        Assert.assertEquals((long)4L, (long)checker.count);
    }

    @Test
    public void testMethodWithFutureListAndSet() throws Exception {
        Assert.assertEquals(Arrays.asList("foo", "bar", "wibble"), ApiTCKTest.get(this.obj.methodWithHandlerAsyncResultListStringObservable()));
        Assert.assertEquals(Arrays.asList(5, 12, 100), ApiTCKTest.get(this.obj.methodWithHandlerAsyncResultListIntegerObservable()));
        Assert.assertEquals(new HashSet<String>(Arrays.asList("foo", "bar", "wibble")), ApiTCKTest.get(this.obj.methodWithHandlerAsyncResultSetStringObservable()));
        Assert.assertEquals(new HashSet<Integer>(Arrays.asList(5, 12, 100)), ApiTCKTest.get(this.obj.methodWithHandlerAsyncResultSetIntegerObservable()));
    }

    @Test
    public void testMethodWithHandlerListVertxGen() {
        AsyncResultChecker checker = new AsyncResultChecker();
        this.obj.methodWithHandlerListVertxGen(checker.resultHandler(it -> Assert.assertEquals(Arrays.asList("foo", "bar"), it.stream().map(RefedInterface1::getString).collect(Collectors.toList()))));
        Assert.assertEquals((long)1L, (long)checker.count);
    }

    @Test
    public void testMethodWithHandlerListAbstractVertxGen() {
        AsyncResultChecker checker = new AsyncResultChecker();
        this.obj.methodWithHandlerListAbstractVertxGen(checker.resultHandler(it -> Assert.assertEquals(Arrays.asList("abstractfoo", "abstractbar"), it.stream().map(RefedInterface2::getString).collect(Collectors.toList()))));
        Assert.assertEquals((long)1L, (long)checker.count);
    }

    @Test
    public void testMethodWithHandlerAsyncResultListVertxGen() {
        AsyncResultChecker checker = new AsyncResultChecker();
        this.obj.methodWithHandlerAsyncResultListVertxGen(checker.asyncResultHandler(event -> {
            Assert.assertEquals((long)2L, (long)event.size());
            Assert.assertEquals((Object)"foo", (Object)((RefedInterface1)event.get(0)).getString());
            Assert.assertEquals((Object)"bar", (Object)((RefedInterface1)event.get(1)).getString());
        }));
        Assert.assertEquals((long)1L, (long)checker.count);
    }

    @Test
    public void testMethodWithHandlerAsyncResultListAbstractVertxGen() {
        AsyncResultChecker checker = new AsyncResultChecker();
        this.obj.methodWithHandlerAsyncResultListAbstractVertxGen(checker.asyncResultHandler(event -> {
            Assert.assertEquals((long)2L, (long)event.size());
            Assert.assertEquals((Object)"abstractfoo", (Object)((RefedInterface2)event.get(0)).getString());
            Assert.assertEquals((Object)"abstractbar", (Object)((RefedInterface2)event.get(1)).getString());
        }));
        Assert.assertEquals((long)1L, (long)checker.count);
    }

    @Test
    public void testMethodWithFutureListVertxGen() throws Exception {
        List<RefedInterface1> result = ApiTCKTest.get(this.obj.methodWithHandlerAsyncResultListVertxGenObservable());
        Assert.assertEquals((long)2L, (long)result.size());
        Assert.assertEquals((Object)"foo", (Object)result.get(0).getString());
        Assert.assertEquals((Object)"bar", (Object)result.get(1).getString());
    }

    @Test
    public void testMethodWithHandlerSetVertxGen() {
        AsyncResultChecker checker = new AsyncResultChecker();
        this.obj.methodWithHandlerSetVertxGen(checker.resultHandler(event -> {
            List list = event.stream().map(it -> it.getString()).collect(Collectors.toList());
            Collections.sort(list);
            Assert.assertEquals(Arrays.asList("bar", "foo"), list);
        }));
        Assert.assertEquals((long)1L, (long)checker.count);
    }

    @Test
    public void testMethodWithHandlerSetAbstractVertxGen() {
        AsyncResultChecker checker = new AsyncResultChecker();
        this.obj.methodWithHandlerSetAbstractVertxGen(checker.resultHandler(event -> {
            List list = event.stream().map(it -> it.getString()).collect(Collectors.toList());
            Collections.sort(list);
            Assert.assertEquals(Arrays.asList("abstractbar", "abstractfoo"), list);
        }));
        Assert.assertEquals((long)1L, (long)checker.count);
    }

    @Test
    public void testMethodWithHandlerAsyncResultSetVertxGen() {
        AsyncResultChecker checker = new AsyncResultChecker();
        this.obj.methodWithHandlerAsyncResultSetVertxGen(checker.asyncResultHandler(event -> {
            List list = event.stream().map(RefedInterface1::getString).collect(Collectors.toList());
            Collections.sort(list);
            Assert.assertEquals(Arrays.asList("bar", "foo"), list);
        }));
        Assert.assertEquals((long)1L, (long)checker.count);
    }

    @Test
    public void testMethodWithHandlerAsyncResultSetAbstractVertxGen() {
        AsyncResultChecker checker = new AsyncResultChecker();
        this.obj.methodWithHandlerAsyncResultSetAbstractVertxGen(checker.asyncResultHandler(event -> {
            List list = event.stream().map(RefedInterface2::getString).collect(Collectors.toList());
            Collections.sort(list);
            Assert.assertEquals(Arrays.asList("abstractbar", "abstractfoo"), list);
        }));
        Assert.assertEquals((long)1L, (long)checker.count);
    }

    @Test
    public void testMethodWithFutureSetVertxGen() throws Exception {
        Set<RefedInterface1> result = ApiTCKTest.get(this.obj.methodWithHandlerAsyncResultSetVertxGenObservable());
        List list = result.stream().map(RefedInterface1::getString).collect(Collectors.toList());
        Collections.sort(list);
        Assert.assertEquals(Arrays.asList("bar", "foo"), list);
    }

    @Test
    public void testMethodWithHandlerListJsonObject() {
        AsyncResultChecker checker = new AsyncResultChecker();
        this.obj.methodWithHandlerListJsonObject(checker.expectedResult(Arrays.asList(new JsonObject().put("cheese", "stilton"), new JsonObject().put("socks", "tartan"))));
        Assert.assertEquals((long)1L, (long)checker.count);
    }

    @Test
    public void testMethodWithHandlerAsyncResultListJsonObject() {
        AsyncResultChecker checker = new AsyncResultChecker();
        this.obj.methodWithHandlerAsyncResultListJsonObject(checker.asyncExpectedResult(Arrays.asList(new JsonObject().put("cheese", "stilton"), new JsonObject().put("socks", "tartan"))));
        Assert.assertEquals((long)1L, (long)checker.count);
    }

    @Test
    public void testMethodWithFutureListJsonObject() throws Exception {
        List<JsonObject> result = ApiTCKTest.get(this.obj.methodWithHandlerAsyncResultListJsonObjectObservable());
        Assert.assertEquals(Arrays.asList(new JsonObject().put("cheese", "stilton"), new JsonObject().put("socks", "tartan")), result);
    }

    @Test
    public void testMethodWithHandlerSetJsonObject() {
        AsyncResultChecker checker = new AsyncResultChecker();
        this.obj.methodWithHandlerSetJsonObject(checker.resultHandler(r -> Assert.assertEquals(Arrays.asList(new JsonObject().put("cheese", "stilton"), new JsonObject().put("socks", "tartan")), new ArrayList(r))));
        Assert.assertEquals((long)1L, (long)checker.count);
    }

    @Test
    public void testMethodWithHandlerAsyncResultSetJsonObject() {
        AsyncResultChecker checker = new AsyncResultChecker();
        this.obj.methodWithHandlerAsyncResultSetJsonObject(checker.asyncResultHandler(it -> Assert.assertEquals(Arrays.asList(new JsonObject().put("cheese", "stilton"), new JsonObject().put("socks", "tartan")), new ArrayList(it))));
        Assert.assertEquals((long)1L, (long)checker.count);
    }

    @Test
    public void testMethodWithFutureSetJsonObject() throws Exception {
        Set<JsonObject> result = ApiTCKTest.get(this.obj.methodWithHandlerAsyncResultSetJsonObjectObservable());
        Assert.assertEquals(Arrays.asList(new JsonObject().put("cheese", "stilton"), new JsonObject().put("socks", "tartan")), new ArrayList<JsonObject>(result));
    }

    @Test
    public void testMethodWithHandlerListJsonArray() {
        AsyncResultChecker checker = new AsyncResultChecker();
        this.obj.methodWithHandlerListJsonArray(checker.expectedResult(Arrays.asList(new JsonArray().add("green").add("blue"), new JsonArray().add("yellow").add("purple"))));
        Assert.assertEquals((long)1L, (long)checker.count);
    }

    @Test
    public void testMethodWithHandlerAsyncResultListJsonArray() {
        AsyncResultChecker checker = new AsyncResultChecker();
        this.obj.methodWithHandlerAsyncResultListJsonArray(checker.asyncExpectedResult(Arrays.asList(new JsonArray().add("green").add("blue"), new JsonArray().add("yellow").add("purple"))));
        Assert.assertEquals((long)1L, (long)checker.count);
    }

    @Test
    public void testMethodWithFutureListJsonArray() throws Exception {
        List<JsonArray> result = ApiTCKTest.get(this.obj.methodWithHandlerAsyncResultListJsonArrayObservable());
        Assert.assertEquals(result, Arrays.asList(new JsonArray().add("green").add("blue"), new JsonArray().add("yellow").add("purple")));
    }

    @Test
    public void testMethodWithHandlerSetJsonArray() {
        AsyncResultChecker checker = new AsyncResultChecker();
        this.obj.methodWithHandlerSetJsonArray(checker.resultHandler(it -> Assert.assertEquals(Arrays.asList(new JsonArray().add("green").add("blue"), new JsonArray().add("yellow").add("purple")), new ArrayList(it))));
        Assert.assertEquals((long)1L, (long)checker.count);
    }

    @Test
    public void testMethodWithHandlerAsyncResultSetJsonArray() {
        AsyncResultChecker checker = new AsyncResultChecker();
        this.obj.methodWithHandlerAsyncResultSetJsonArray(checker.asyncResultHandler(it -> Assert.assertEquals(Arrays.asList(new JsonArray().add("green").add("blue"), new JsonArray().add("yellow").add("purple")), new ArrayList(it))));
        Assert.assertEquals((long)1L, (long)checker.count);
    }

    @Test
    public void testMethodWithFutureSetJsonArray() throws Exception {
        Set<JsonArray> result = ApiTCKTest.get(this.obj.methodWithHandlerAsyncResultSetJsonArrayObservable());
        Assert.assertEquals(Arrays.asList(new JsonArray().add("green").add("blue"), new JsonArray().add("yellow").add("purple")), new ArrayList<JsonArray>(result));
    }

    @Test
    public void testMethodWithHandlerListDataObject() throws Exception {
        AsyncResultChecker checker = new AsyncResultChecker();
        this.obj.methodWithHandlerListDataObject(checker.resultHandler(list -> {
            Assert.assertEquals((long)2L, (long)list.size());
            Assert.assertEquals((Object)"String 1", (Object)((TestDataObject)list.get(0)).getFoo());
            Assert.assertEquals((long)1L, (long)((TestDataObject)list.get(0)).getBar());
            Assert.assertEquals((double)1.1, (double)((TestDataObject)list.get(0)).getWibble(), (double)0.0);
            Assert.assertEquals((Object)"String 2", (Object)((TestDataObject)list.get(1)).getFoo());
            Assert.assertEquals((long)2L, (long)((TestDataObject)list.get(1)).getBar());
            Assert.assertEquals((double)2.2, (double)((TestDataObject)list.get(1)).getWibble(), (double)0.0);
        }));
        Assert.assertEquals((long)1L, (long)checker.count);
    }

    @Test
    public void testMethodWithHandlerSetDataObject() throws Exception {
        AsyncResultChecker checker = new AsyncResultChecker();
        this.obj.methodWithHandlerSetDataObject(checker.resultHandler(set -> {
            ArrayList list = new ArrayList(set);
            Collections.sort(list, (c1, c2) -> Integer.valueOf(c1.getBar()).compareTo(c2.getBar()));
            Assert.assertEquals((Object)"String 1", (Object)((TestDataObject)list.get(0)).getFoo());
            Assert.assertEquals((long)1L, (long)((TestDataObject)list.get(0)).getBar());
            Assert.assertEquals((double)1.1, (double)((TestDataObject)list.get(0)).getWibble(), (double)0.0);
            Assert.assertEquals((Object)"String 2", (Object)((TestDataObject)list.get(1)).getFoo());
            Assert.assertEquals((long)2L, (long)((TestDataObject)list.get(1)).getBar());
            Assert.assertEquals((double)2.2, (double)((TestDataObject)list.get(1)).getWibble(), (double)0.0);
        }));
        Assert.assertEquals((long)1L, (long)checker.count);
    }

    @Test
    public void testMethodWithHandlerAsyncResultListDataObject() throws Exception {
        AsyncResultChecker checker = new AsyncResultChecker();
        this.obj.methodWithHandlerAsyncResultListDataObject(checker.asyncResultHandler(list -> {
            Assert.assertEquals((long)2L, (long)list.size());
            Assert.assertEquals((Object)"String 1", (Object)((TestDataObject)list.get(0)).getFoo());
            Assert.assertEquals((long)1L, (long)((TestDataObject)list.get(0)).getBar());
            Assert.assertEquals((double)1.1, (double)((TestDataObject)list.get(0)).getWibble(), (double)0.0);
            Assert.assertEquals((Object)"String 2", (Object)((TestDataObject)list.get(1)).getFoo());
            Assert.assertEquals((long)2L, (long)((TestDataObject)list.get(1)).getBar());
            Assert.assertEquals((double)2.2, (double)((TestDataObject)list.get(1)).getWibble(), (double)0.0);
        }));
        Assert.assertEquals((long)1L, (long)checker.count);
    }

    @Test
    public void testMethodWithHandlerAsyncResultSetDataObject() throws Exception {
        AsyncResultChecker checker = new AsyncResultChecker();
        this.obj.methodWithHandlerAsyncResultSetDataObject(checker.asyncResultHandler(set -> {
            ArrayList list = new ArrayList(set);
            Collections.sort(list, (c1, c2) -> Integer.valueOf(c1.getBar()).compareTo(c2.getBar()));
            Assert.assertEquals((Object)"String 1", (Object)((TestDataObject)list.get(0)).getFoo());
            Assert.assertEquals((long)1L, (long)((TestDataObject)list.get(0)).getBar());
            Assert.assertEquals((double)1.1, (double)((TestDataObject)list.get(0)).getWibble(), (double)0.0);
            Assert.assertEquals((Object)"String 2", (Object)((TestDataObject)list.get(1)).getFoo());
            Assert.assertEquals((long)2L, (long)((TestDataObject)list.get(1)).getBar());
            Assert.assertEquals((double)2.2, (double)((TestDataObject)list.get(1)).getWibble(), (double)0.0);
        }));
        Assert.assertEquals((long)1L, (long)checker.count);
    }

    @Test
    public void testMethodWithHandlerListEnum() {
        AsyncResultChecker checker = new AsyncResultChecker();
        this.obj.methodWithHandlerListEnum(checker.expectedResult(Arrays.asList(TestEnum.TIM, TestEnum.JULIEN)));
        Assert.assertEquals((long)1L, (long)checker.count);
    }

    @Test
    public void testMethodWithHandlerSetEnum() {
        AsyncResultChecker checker = new AsyncResultChecker();
        this.obj.methodWithHandlerSetEnum(checker.expectedResult(ApiTCKTest.set(TestEnum.TIM, TestEnum.JULIEN)));
        Assert.assertEquals((long)1L, (long)checker.count);
    }

    @Test
    public void testMethodWithHandlerListAsyncResultEnum() {
        AsyncResultChecker checker = new AsyncResultChecker();
        this.obj.methodWithHandlerAsyncResultListEnum(checker.asyncExpectedResult(Arrays.asList(TestEnum.TIM, TestEnum.JULIEN)));
        Assert.assertEquals((long)1L, (long)checker.count);
    }

    @Test
    public void testMethodWithHandlerAsyncResultSetEnum() {
        AsyncResultChecker checker = new AsyncResultChecker();
        this.obj.methodWithHandlerAsyncResultSetEnum(checker.asyncExpectedResult(ApiTCKTest.set(TestEnum.TIM, TestEnum.JULIEN)));
        Assert.assertEquals((long)1L, (long)checker.count);
    }

    @Test
    public void testMethodListParams() {
        RefedInterface1 refed1 = new RefedInterface1(new RefedInterface1Impl());
        refed1.setString("foo");
        RefedInterface1 refed2 = new RefedInterface1(new RefedInterface1Impl());
        refed2.setString("bar");
        this.obj.methodWithListParams(Arrays.asList("foo", "bar"), Arrays.asList((byte)2, (byte)3), Arrays.asList((short)12, (short)13), Arrays.asList(1234, 1345), Arrays.asList(123L, 456L), Arrays.asList(new JsonObject().put("foo", "bar"), new JsonObject().put("eek", "wibble")), Arrays.asList(new JsonArray().add("foo"), new JsonArray().add("blah")), Arrays.asList(refed1, refed2), Arrays.asList(new TestDataObject().setFoo("String 1").setBar(1).setWibble(1.1), new TestDataObject().setFoo("String 2").setBar(2).setWibble(2.2)), Arrays.asList(TestEnum.JULIEN, TestEnum.TIM), Arrays.asList("foo", 4, 3.4, true, new JsonObject().put("wibble", "eek"), new JsonArray().add("one").add(Integer.valueOf(2))));
    }

    @Test
    public void testMethodSetParams() {
        RefedInterface1 refed1 = new RefedInterface1(new RefedInterface1Impl());
        refed1.setString("foo");
        RefedInterface1 refed2 = new RefedInterface1(new RefedInterface1Impl());
        refed2.setString("bar");
        this.obj.methodWithSetParams(ApiTCKTest.set("foo", "bar"), ApiTCKTest.set((byte)2, (byte)3), ApiTCKTest.set((short)12, (short)13), ApiTCKTest.set(1234, 1345), ApiTCKTest.set(123L, 456L), ApiTCKTest.set(new JsonObject().put("foo", "bar"), new JsonObject().put("eek", "wibble")), ApiTCKTest.set(new JsonArray().add("foo"), new JsonArray().add("blah")), ApiTCKTest.set(refed1, refed2), ApiTCKTest.set(new TestDataObject().setFoo("String 1").setBar(1).setWibble(1.1), new TestDataObject().setFoo("String 2").setBar(2).setWibble(2.2)), ApiTCKTest.set(TestEnum.TIM, TestEnum.JULIEN), ApiTCKTest.set("foo", 4, 3.4, true, new JsonObject().put("wibble", "eek"), new JsonArray().add("one").add(Integer.valueOf(2))));
    }

    @Test
    public void testMethodMapParams() {
        RefedInterface1 refed1 = new RefedInterface1(new RefedInterface1Impl());
        refed1.setString("foo");
        RefedInterface1 refed2 = new RefedInterface1(new RefedInterface1Impl());
        refed2.setString("bar");
        HashMap<String, Object> m = new HashMap<String, Object>();
        m.put("string", "foo");
        m.put("integer", 4);
        m.put("float", 3.4);
        m.put("boolean", true);
        m.put("object", new JsonObject().put("wibble", "eek"));
        m.put("array", new JsonArray().add("one").add(Integer.valueOf(2)));
        this.obj.methodWithMapParams(ApiTCKTest.map("foo", "bar", "eek", "wibble"), ApiTCKTest.map("foo", (byte)2, "eek", (byte)3), ApiTCKTest.map("foo", (short)12, "eek", (short)13), ApiTCKTest.map("foo", 1234, "eek", 1345), ApiTCKTest.map("foo", 123L, "eek", 456L), ApiTCKTest.map("foo", new JsonObject().put("foo", "bar"), "eek", new JsonObject().put("eek", "wibble")), ApiTCKTest.map("foo", new JsonArray().add("foo"), "eek", new JsonArray().add("blah")), ApiTCKTest.map("foo", refed1, "eek", refed2), m);
    }

    @Test
    public void testListStringReturn() {
        Assert.assertEquals(Arrays.asList("foo", "bar", "wibble"), this.obj.methodWithListStringReturn());
    }

    @Test
    public void testListLongReturn() {
        Assert.assertEquals(ApiTCKTest.list(123L, 456L), this.obj.methodWithListLongReturn());
    }

    @Test
    public void testListJsonObjectReturn() {
        List<JsonObject> list = this.obj.methodWithListJsonObjectReturn();
        Assert.assertEquals((long)2L, (long)list.size());
        JsonObject json1 = list.get(0);
        Assert.assertEquals((Object)"bar", (Object)json1.getValue("foo"));
        JsonObject json2 = list.get(1);
        Assert.assertEquals((Object)"eek", (Object)json2.getValue("blah"));
    }

    @Test
    public void testListJsonArrayReturn() {
        List<JsonArray> list = this.obj.methodWithListJsonArrayReturn();
        Assert.assertEquals((long)2L, (long)list.size());
        JsonArray json1 = list.get(0);
        Assert.assertEquals((Object)"foo", (Object)json1.getValue(0));
        JsonArray json2 = list.get(1);
        Assert.assertEquals((Object)"blah", (Object)json2.getValue(0));
    }

    @Test
    public void testListVertxGenReturn() {
        List<RefedInterface1> list = this.obj.methodWithListVertxGenReturn();
        Assert.assertEquals((long)2L, (long)list.size());
        RefedInterface1 refed1 = list.get(0);
        RefedInterface1 refed2 = list.get(1);
        Assert.assertEquals((Object)"foo", (Object)refed1.getString());
        Assert.assertEquals((Object)"bar", (Object)refed2.getString());
    }

    @Test
    public void testListDataObjectReturn() {
        List<TestDataObject> list = this.obj.methodWithListDataObjectReturn();
        Assert.assertEquals((long)2L, (long)list.size());
        Assert.assertEquals((Object)"String 1", (Object)list.get(0).getFoo());
        Assert.assertEquals((long)1L, (long)list.get(0).getBar());
        Assert.assertEquals((double)1.1, (double)list.get(0).getWibble(), (double)0.0);
        Assert.assertEquals((Object)"String 2", (Object)list.get(1).getFoo());
        Assert.assertEquals((long)2L, (long)list.get(1).getBar());
        Assert.assertEquals((double)2.2, (double)list.get(1).getWibble(), (double)0.0);
    }

    @Test
    public void testSetStringReturn() {
        Assert.assertEquals(new HashSet<String>(Arrays.asList("foo", "bar", "wibble")), this.obj.methodWithSetStringReturn());
    }

    @Test
    public void testSetLongReturn() {
        Assert.assertEquals(ApiTCKTest.set(123L, 456L), this.obj.methodWithSetLongReturn());
    }

    @Test
    public void testSetJsonObjectReturn() {
        Set<JsonObject> set = this.obj.methodWithSetJsonObjectReturn();
        Assert.assertEquals((long)2L, (long)set.size());
        JsonObject json1 = new JsonObject();
        json1.put("foo", "bar");
        Assert.assertTrue((boolean)set.contains(json1));
        JsonObject json2 = new JsonObject();
        json2.put("blah", "eek");
        Assert.assertTrue((boolean)set.contains(json2));
    }

    @Test
    public void testSetJsonArrayReturn() {
        Set<JsonArray> set = this.obj.methodWithSetJsonArrayReturn();
        Assert.assertEquals((long)2L, (long)set.size());
        JsonArray json1 = new JsonArray();
        json1.add("foo");
        Assert.assertTrue((boolean)set.contains(json1));
        JsonArray json2 = new JsonArray();
        json2.add("blah");
        Assert.assertTrue((boolean)set.contains(json2));
    }

    @Test
    public void testSetVertxGenReturn() {
        Set<RefedInterface1> set = this.obj.methodWithSetVertxGenReturn();
        Assert.assertEquals((long)2L, (long)set.size());
        RefedInterface1 refed1 = new RefedInterface1(new RefedInterface1Impl());
        refed1.setString("foo");
        RefedInterface1 refed2 = new RefedInterface1(new RefedInterface1Impl());
        refed2.setString("bar");
        ArrayList<RefedInterface1> list = new ArrayList<RefedInterface1>(set);
        Assert.assertTrue((((RefedInterface1)list.get(0)).getString().equals("foo") && ((RefedInterface1)list.get(1)).getString().equals("bar") || ((RefedInterface1)list.get(0)).getString().equals("bar") && ((RefedInterface1)list.get(1)).getString().equals("foo") ? 1 : 0) != 0);
    }

    @Test
    public void testSetDataObjectReturn() {
        Set<TestDataObject> set = this.obj.methodWithSetDataObjectReturn();
        ArrayList<TestDataObject> list = new ArrayList<TestDataObject>(set);
        Collections.sort(list, (c1, c2) -> Integer.valueOf(c1.getBar()).compareTo(c2.getBar()));
        Assert.assertEquals((Object)"String 1", (Object)((TestDataObject)list.get(0)).getFoo());
        Assert.assertEquals((long)1L, (long)((TestDataObject)list.get(0)).getBar());
        Assert.assertEquals((double)1.1, (double)((TestDataObject)list.get(0)).getWibble(), (double)0.0);
        Assert.assertEquals((Object)"String 2", (Object)((TestDataObject)list.get(1)).getFoo());
        Assert.assertEquals((long)2L, (long)((TestDataObject)list.get(1)).getBar());
        Assert.assertEquals((double)2.2, (double)((TestDataObject)list.get(1)).getWibble(), (double)0.0);
    }

    @Test
    public void testMapStringReturn() {
        Map<String, String> map = this.obj.methodWithMapStringReturn((Handler<String>)((Handler)s -> {}));
        Assert.assertEquals((Object)"bar", (Object)map.get("foo"));
    }

    @Test
    public void testMapLongReturn() {
        Map<String, Long> map = this.obj.methodWithMapLongReturn((Handler<String>)((Handler)s -> {}));
        Assert.assertEquals((long)123L, (long)map.get("foo"));
    }

    @Test
    public void testMapJsonObjectReturn() {
        Map<String, JsonObject> map = this.obj.methodWithMapJsonObjectReturn((Handler<String>)((Handler)s -> {}));
        JsonObject m = map.get("foo");
        Assert.assertEquals((Object)"eek", (Object)m.getValue("wibble"));
    }

    @Test
    public void testMapJsonArrayReturn() {
        Map<String, JsonArray> map = this.obj.methodWithMapJsonArrayReturn((Handler<String>)((Handler)s -> {}));
        JsonArray m = map.get("foo");
        Assert.assertEquals((Object)"wibble", (Object)m.getValue(0));
    }

    @Test
    public void testMapObjectReturn() {
        Map<String, Object> map = this.obj.methodWithMapObjectReturn((Handler<String>)((Handler)s -> {}));
        Assert.assertEquals((Object)"foo", (Object)map.get("string"));
        Assert.assertEquals((Object)4, (Object)map.get("integer"));
        Assert.assertEquals((Object)Float.valueOf(3.4f), (Object)map.get("float"));
        Assert.assertEquals((Object)true, (Object)map.get("boolean"));
        Assert.assertEquals((Object)new JsonObject().put("wibble", "eek"), (Object)map.get("object"));
        Assert.assertEquals((Object)new JsonArray().add("one").add(Integer.valueOf(2)), (Object)map.get("array"));
    }

    @Test
    public void testListEnumReturn() {
        Assert.assertEquals(Arrays.asList(TestEnum.JULIEN, TestEnum.TIM), this.obj.methodWithListEnumReturn());
    }

    @Test
    public void testListObjectReturn() {
        List<Object> list = this.obj.methodWithListObjectReturn();
        Assert.assertEquals((Object)"foo", (Object)list.get(0));
        Assert.assertEquals((Object)4, (Object)list.get(1));
        Assert.assertEquals((Object)Float.valueOf(3.4f), (Object)list.get(2));
        Assert.assertEquals((Object)true, (Object)list.get(3));
        Assert.assertEquals((Object)new JsonObject().put("wibble", "eek"), (Object)list.get(4));
        Assert.assertEquals((Object)new JsonArray().add("one").add(Integer.valueOf(2)), (Object)list.get(5));
    }

    @Test
    public void testsetEnumReturn() {
        Assert.assertEquals(ApiTCKTest.set(TestEnum.JULIEN, TestEnum.TIM), this.obj.methodWithSetEnumReturn());
    }

    @Test
    public void testSetObjectReturn() {
        ArrayList<Object> list = new ArrayList<Object>(this.obj.methodWithSetObjectReturn());
        Assert.assertEquals((Object)"foo", list.get(0));
        Assert.assertEquals((Object)4, list.get(1));
        Assert.assertEquals((Object)Float.valueOf(3.4f), list.get(2));
        Assert.assertEquals((Object)true, list.get(3));
        Assert.assertEquals((Object)new JsonObject().put("wibble", "eek"), list.get(4));
        Assert.assertEquals((Object)new JsonArray().add("one").add(Integer.valueOf(2)), list.get(5));
    }
}

