/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.rx.java.test.gen;

import io.vertx.codegen.testmodel.FunctionParamTCKImpl;
import io.vertx.codegen.testmodel.RefedInterface1Impl;
import io.vertx.codegen.testmodel.TestDataObject;
import io.vertx.codegen.testmodel.TestEnum;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.rxjava.codegen.testmodel.FunctionParamTCK;
import io.vertx.rxjava.codegen.testmodel.RefedInterface1;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;

public class FunctionParamTCKTest {
    final FunctionParamTCK obj = new FunctionParamTCK(new FunctionParamTCKImpl());

    @Test
    public void testBasicParam() {
        List<String> ret = this.obj.methodWithBasicParam(arg -> {
            Assert.assertEquals((Object)100, (Object)arg);
            return "ok0";
        }, arg -> {
            Assert.assertEquals((Object)1000, (Object)arg);
            return "ok1";
        }, arg -> {
            Assert.assertEquals((Object)100000, (Object)arg);
            return "ok2";
        }, arg -> {
            Assert.assertEquals((Object)10000000000L, (Object)arg);
            return "ok3";
        }, arg -> {
            Assert.assertEquals((Object)Float.valueOf(3.5f), (Object)arg);
            return "ok4";
        }, arg -> {
            Assert.assertEquals((Object)0.01, (Object)arg);
            return "ok5";
        }, arg -> {
            Assert.assertEquals((Object)true, (Object)arg);
            return "ok6";
        }, arg -> {
            Assert.assertEquals((Object)Character.valueOf('F'), (Object)arg);
            return "ok7";
        }, arg -> {
            Assert.assertEquals((Object)"wibble", (Object)arg);
            return "ok8";
        });
        Assert.assertEquals(Arrays.asList("ok0", "ok1", "ok2", "ok3", "ok4", "ok5", "ok6", "ok7", "ok8"), ret);
    }

    @Test
    public void testJsonParam() {
        List<String> ret = this.obj.methodWithJsonParam(it -> {
            Assert.assertEquals((Object)new JsonObject().put("one", Integer.valueOf(1)).put("two", Integer.valueOf(2)).put("three", Integer.valueOf(3)), (Object)it);
            return "ok0";
        }, it -> {
            Assert.assertEquals((Object)new JsonArray().add("one").add("two").add("three"), (Object)it);
            return "ok1";
        });
        Assert.assertEquals(Arrays.asList("ok0", "ok1"), ret);
    }

    @Test
    public void testVoidParam() {
        Assert.assertEquals((Object)"ok", (Object)this.obj.methodWithVoidParam(it -> {
            Assert.assertEquals(null, (Object)it);
            return "ok";
        }));
    }

    @Test
    public void testUserTypeParam() {
        RefedInterface1 refed = new RefedInterface1(new RefedInterface1Impl());
        Assert.assertEquals((Object)"ok", (Object)this.obj.methodWithUserTypeParam(refed, it -> {
            it.setString("foobarjuu");
            Assert.assertEquals((Object)"foobarjuu", (Object)it.getString());
            return "ok";
        }));
    }

    @Test
    public void testObjectParam() {
        Assert.assertEquals((Object)"ok", (Object)this.obj.methodWithObjectParam(123, it -> {
            Assert.assertEquals((Object)123, (Object)it);
            return "ok";
        }));
        Assert.assertEquals((Object)"ok", (Object)this.obj.methodWithObjectParam("the-string-arg", it -> {
            Assert.assertEquals((Object)"the-string-arg", (Object)it);
            return "ok";
        }));
    }

    @Test
    public void testDataObjectParam() {
        Assert.assertEquals((Object)"ok", (Object)this.obj.methodWithDataObjectParam(it -> {
            Assert.assertEquals((Object)"foo_value", (Object)it.getFoo());
            Assert.assertEquals((long)3L, (long)it.getBar());
            Assert.assertEquals((double)0.01, (double)it.getWibble(), (double)0.0);
            return "ok";
        }));
    }

    @Test
    public void testEnumParam() {
        Assert.assertEquals((Object)"ok", (Object)this.obj.methodWithEnumParam(it -> {
            Assert.assertEquals((Object)((Object)TestEnum.TIM), (Object)it);
            return "ok";
        }));
    }

    @Test
    public void testListParam() {
        Assert.assertEquals((Object)"ok", (Object)this.obj.methodWithListParam(it -> {
            Assert.assertEquals(Arrays.asList("one", "two", "three"), (Object)it);
            return "ok";
        }));
    }

    @Test
    public void testSetParam() {
        Assert.assertEquals((Object)"ok", (Object)this.obj.methodWithSetParam(it -> {
            Assert.assertEquals(new HashSet<String>(Arrays.asList("one", "two", "three")), (Object)it);
            return "ok";
        }));
    }

    @Test
    public void testMapParam() {
        Assert.assertEquals((Object)"ok", (Object)this.obj.methodWithMapParam(it -> {
            HashMap<String, String> expected = new HashMap<String, String>();
            expected.put("one", "one");
            expected.put("two", "two");
            expected.put("three", "three");
            Assert.assertEquals(expected, (Object)it);
            return "ok";
        }));
    }

    @Test
    public void testGenericParam() {
        Assert.assertEquals((Object)"ok", (Object)this.obj.methodWithGenericParam(123, it -> {
            Assert.assertEquals((Object)123, (Object)it);
            return "ok";
        }));
        Assert.assertEquals((Object)"ok", (Object)this.obj.methodWithGenericParam("the-string-arg", it -> {
            Assert.assertEquals((Object)"the-string-arg", (Object)it);
            return "ok";
        }));
    }

    @Test
    public void testGenericUserTypeParam() {
        Assert.assertEquals((Object)"ok", (Object)this.obj.methodWithGenericUserTypeParam(123, it -> {
            Assert.assertEquals((Object)123, it.getValue());
            return "ok";
        }));
        Assert.assertEquals((Object)"ok", (Object)this.obj.methodWithGenericUserTypeParam("the-string-arg", it -> {
            Assert.assertEquals((Object)"the-string-arg", it.getValue());
            return "ok";
        }));
    }

    @Test
    public void testNullableListParam() {
        Assert.assertEquals((Object)"ok", (Object)this.obj.methodWithNullableListParam(it -> {
            Assert.assertEquals(null, (Object)it);
            return "ok";
        }));
    }

    @Test
    public void testBasicReturn() {
        Assert.assertEquals((Object)"ok", (Object)this.obj.methodWithBasicReturn(it -> (byte)10, it -> (short)1000, it -> 100000, it -> 10000000000L, it -> Float.valueOf(0.01f), it -> 1.0E-5, it -> true, it -> Character.valueOf('C'), it -> "the-return"));
    }

    @Test
    public void testJsonReturn() {
        Assert.assertEquals((Object)"ok", (Object)this.obj.methodWithJsonReturn(it -> new JsonObject().put("foo", "foo_value").put("bar", Integer.valueOf(10)).put("wibble", Double.valueOf(0.1)), it -> new JsonArray(Arrays.asList("one", "two", "three"))));
    }

    @Test
    public void testObjectReturn() {
        Assert.assertEquals((Object)"ok", (Object)this.obj.methodWithObjectReturn(it -> {
            switch (it) {
                case 0: {
                    return "the-string";
                }
                case 1: {
                    return 123;
                }
                case 2: {
                    return true;
                }
                case 3: {
                    return new JsonObject().put("foo", "foo_value");
                }
                case 4: {
                    return new JsonArray(Arrays.asList("foo", "bar"));
                }
            }
            throw new RuntimeException();
        }));
    }

    @Test
    public void testDataObjectReturn() {
        Assert.assertEquals((Object)"ok", (Object)this.obj.methodWithDataObjectReturn(it -> new TestDataObject().setFoo("wasabi").setBar(6).setWibble(0.01)));
    }

    @Test
    public void testEnumReturn() {
        Assert.assertEquals((Object)"ok", (Object)this.obj.methodWithEnumReturn(it -> TestEnum.NICK));
    }

    @Test
    public void testListReturn() {
        Assert.assertEquals((Object)"ok", (Object)this.obj.methodWithListReturn(it -> Arrays.asList("one", "two", "three")));
    }

    @Test
    public void testSetReturn() {
        Assert.assertEquals((Object)"ok", (Object)this.obj.methodWithSetReturn(it -> new HashSet<String>(Arrays.asList("one", "two", "three"))));
    }

    @Test
    public void testMapReturn() {
        HashMap<String, String> expected = new HashMap<String, String>();
        expected.put("one", "one");
        expected.put("two", "two");
        expected.put("three", "three");
        Assert.assertEquals((Object)"ok", (Object)this.obj.methodWithMapReturn(it -> expected));
    }

    @Test
    public void testGenericReturn() {
        Assert.assertEquals((Object)"ok", (Object)this.obj.methodWithGenericReturn(it -> {
            switch (it) {
                case 0: {
                    return "the-string";
                }
                case 1: {
                    return 123;
                }
                case 2: {
                    return true;
                }
                case 3: {
                    return new JsonObject().put("foo", "foo_value");
                }
                case 4: {
                    return new JsonArray(Arrays.asList("foo", "bar"));
                }
            }
            throw new RuntimeException();
        }));
    }

    @Test
    public void testGenericUserTypeReturn() {
        Assert.assertEquals((Object)"ok", (Object)this.obj.methodWithGenericUserTypeReturn(it -> it));
    }

    @Test
    public void testNullableListReturn() {
        Assert.assertEquals((Object)"ok", (Object)this.obj.methodWithNullableListReturn(it -> null));
    }
}

