/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.codegen.extra;

import io.vertx.reactivex.RxHelper;
import io.vertx.reactivex.ObservableHelper;
import io.vertx.reactivex.FlowableHelper;
import io.vertx.reactivex.impl.AsyncResultMaybe;
import io.vertx.reactivex.impl.AsyncResultSingle;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.WriteStreamObserver;
import io.vertx.reactivex.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.codegen.extra.AnotherInterface original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.codegen.extra.AnotherInterface.class)
public class AnotherInterface {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    AnotherInterface that = (AnotherInterface) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<AnotherInterface> __TYPE_ARG = new TypeArg<>(    obj -> new AnotherInterface((io.vertx.codegen.extra.AnotherInterface) obj),
    AnotherInterface::getDelegate
  );

  private final io.vertx.codegen.extra.AnotherInterface delegate;
  
  public AnotherInterface(io.vertx.codegen.extra.AnotherInterface delegate) {
    this.delegate = delegate;
  }

  public AnotherInterface(Object delegate) {
    this.delegate = (io.vertx.codegen.extra.AnotherInterface)delegate;
  }

  public io.vertx.codegen.extra.AnotherInterface getDelegate() {
    return delegate;
  }

  public static io.vertx.reactivex.codegen.extra.AnotherInterface create() { 
    io.vertx.reactivex.codegen.extra.AnotherInterface ret = io.vertx.reactivex.codegen.extra.AnotherInterface.newInstance((io.vertx.codegen.extra.AnotherInterface)io.vertx.codegen.extra.AnotherInterface.create());
    return ret;
  }

  public <T> T methodWithClassParam(java.lang.Class<T> tClass) { 
    T ret = (T)TypeArg.of(tClass).wrap(delegate.methodWithClassParam(io.vertx.lang.reactivex.Helper.unwrap(tClass)));
    return ret;
  }

  public static AnotherInterface newInstance(io.vertx.codegen.extra.AnotherInterface arg) {
    return arg != null ? new AnotherInterface(arg) : null;
  }

}
