/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.codegen.extra;

import io.vertx.reactivex.RxHelper;
import io.vertx.reactivex.ObservableHelper;
import io.vertx.reactivex.FlowableHelper;
import io.vertx.reactivex.impl.AsyncResultMaybe;
import io.vertx.reactivex.impl.AsyncResultSingle;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.WriteStreamObserver;
import io.vertx.reactivex.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.codegen.extra.ConcreteInheritsToString original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.codegen.extra.ConcreteInheritsToString.class)
public class ConcreteInheritsToString implements io.vertx.reactivex.codegen.extra.NonConcreteWithToString {

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ConcreteInheritsToString that = (ConcreteInheritsToString) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<ConcreteInheritsToString> __TYPE_ARG = new TypeArg<>(    obj -> new ConcreteInheritsToString((io.vertx.codegen.extra.ConcreteInheritsToString) obj),
    ConcreteInheritsToString::getDelegate
  );

  private final io.vertx.codegen.extra.ConcreteInheritsToString delegate;
  
  public ConcreteInheritsToString(io.vertx.codegen.extra.ConcreteInheritsToString delegate) {
    this.delegate = delegate;
  }

  public ConcreteInheritsToString(Object delegate) {
    this.delegate = (io.vertx.codegen.extra.ConcreteInheritsToString)delegate;
  }

  public io.vertx.codegen.extra.ConcreteInheritsToString getDelegate() {
    return delegate;
  }

  /**
   * My very special toString method
   * @return 
   */
  public java.lang.String toString() { 
    java.lang.String ret = delegate.toString();
    return ret;
  }

  public void doSomething() { 
    delegate.doSomething();
  }

  public static ConcreteInheritsToString newInstance(io.vertx.codegen.extra.ConcreteInheritsToString arg) {
    return arg != null ? new ConcreteInheritsToString(arg) : null;
  }

}
