/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.codegen.extra;

import io.vertx.reactivex.RxHelper;
import io.vertx.reactivex.ObservableHelper;
import io.vertx.reactivex.FlowableHelper;
import io.vertx.reactivex.impl.AsyncResultMaybe;
import io.vertx.reactivex.impl.AsyncResultSingle;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.WriteStreamObserver;
import io.vertx.reactivex.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;


@RxGen(io.vertx.codegen.extra.DuplicatesInterface.class)
public class DuplicatesInterface {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    DuplicatesInterface that = (DuplicatesInterface) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<DuplicatesInterface> __TYPE_ARG = new TypeArg<>(    obj -> new DuplicatesInterface((io.vertx.codegen.extra.DuplicatesInterface) obj),
    DuplicatesInterface::getDelegate
  );

  private final io.vertx.codegen.extra.DuplicatesInterface delegate;
  
  public DuplicatesInterface(io.vertx.codegen.extra.DuplicatesInterface delegate) {
    this.delegate = delegate;
  }

  public DuplicatesInterface(Object delegate) {
    this.delegate = (io.vertx.codegen.extra.DuplicatesInterface)delegate;
  }

  public io.vertx.codegen.extra.DuplicatesInterface getDelegate() {
    return delegate;
  }

  public static io.vertx.reactivex.codegen.extra.DuplicatesInterface create() { 
    io.vertx.reactivex.codegen.extra.DuplicatesInterface ret = io.vertx.reactivex.codegen.extra.DuplicatesInterface.newInstance((io.vertx.codegen.extra.DuplicatesInterface)io.vertx.codegen.extra.DuplicatesInterface.create());
    return ret;
  }

  public void abc(io.vertx.codegen.extra.duplicates.SomeRandomType arg, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.codegen.extra.duplicates.SomeRandomType>> handler) { 
    delegate.abc(arg, handler);
  }

  public void abc(io.vertx.codegen.extra.duplicates.SomeRandomType arg) {
    abc(arg, ar -> { });
  }

  public io.reactivex.Single<io.vertx.codegen.extra.duplicates.SomeRandomType> rxAbc(io.vertx.codegen.extra.duplicates.SomeRandomType arg) { 
    return AsyncResultSingle.toSingle($handler -> {
      abc(arg, $handler);
    });
  }

  public void def(io.vertx.codegen.extra.duplicates.nested.SomeRandomType arg, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.codegen.extra.duplicates.nested.SomeRandomType>> handler) { 
    delegate.def(arg, handler);
  }

  public void def(io.vertx.codegen.extra.duplicates.nested.SomeRandomType arg) {
    def(arg, ar -> { });
  }

  public io.reactivex.Single<io.vertx.codegen.extra.duplicates.nested.SomeRandomType> rxDef(io.vertx.codegen.extra.duplicates.nested.SomeRandomType arg) { 
    return AsyncResultSingle.toSingle($handler -> {
      def(arg, $handler);
    });
  }

  public static DuplicatesInterface newInstance(io.vertx.codegen.extra.DuplicatesInterface arg) {
    return arg != null ? new DuplicatesInterface(arg) : null;
  }

}
