/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.codegen.extra;

import io.vertx.reactivex.RxHelper;
import io.vertx.reactivex.ObservableHelper;
import io.vertx.reactivex.FlowableHelper;
import io.vertx.reactivex.impl.AsyncResultMaybe;
import io.vertx.reactivex.impl.AsyncResultSingle;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.WriteStreamObserver;
import io.vertx.reactivex.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;


@RxGen(io.vertx.codegen.extra.Generic1.class)
public class Generic1<T> {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    Generic1 that = (Generic1) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<Generic1> __TYPE_ARG = new TypeArg<>(    obj -> new Generic1((io.vertx.codegen.extra.Generic1) obj),
    Generic1::getDelegate
  );

  private final io.vertx.codegen.extra.Generic1<T> delegate;
  public final TypeArg<T> __typeArg_0;
  
  public Generic1(io.vertx.codegen.extra.Generic1 delegate) {
    this.delegate = delegate;
    this.__typeArg_0 = TypeArg.unknown();  }

  public Generic1(Object delegate, TypeArg<T> typeArg_0) {
    this.delegate = (io.vertx.codegen.extra.Generic1)delegate;
    this.__typeArg_0 = typeArg_0;
  }

  public io.vertx.codegen.extra.Generic1 getDelegate() {
    return delegate;
  }


  public T getValue() { 
    T ret = (T)__typeArg_0.wrap(delegate.getValue());
    return ret;
  }

  public io.vertx.reactivex.codegen.extra.Generic1<T> setValue(T value) { 
    delegate.setValue(__typeArg_0.<T>unwrap(value));
    return this;
  }

  public static <T> Generic1<T> newInstance(io.vertx.codegen.extra.Generic1 arg) {
    return arg != null ? new Generic1<T>(arg) : null;
  }

  public static <T> Generic1<T> newInstance(io.vertx.codegen.extra.Generic1 arg, TypeArg<T> __typeArg_T) {
    return arg != null ? new Generic1<T>(arg, __typeArg_T) : null;
  }

}
