/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.codegen.extra;

import io.vertx.reactivex.RxHelper;
import io.vertx.reactivex.ObservableHelper;
import io.vertx.reactivex.FlowableHelper;
import io.vertx.reactivex.impl.AsyncResultMaybe;
import io.vertx.reactivex.impl.AsyncResultSingle;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.WriteStreamObserver;
import io.vertx.reactivex.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.codegen.extra.MethodWithGenericFunctionArg original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.codegen.extra.MethodWithGenericFunctionArg.class)
public class MethodWithGenericFunctionArg<T> {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    MethodWithGenericFunctionArg that = (MethodWithGenericFunctionArg) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<MethodWithGenericFunctionArg> __TYPE_ARG = new TypeArg<>(    obj -> new MethodWithGenericFunctionArg((io.vertx.codegen.extra.MethodWithGenericFunctionArg) obj),
    MethodWithGenericFunctionArg::getDelegate
  );

  private final io.vertx.codegen.extra.MethodWithGenericFunctionArg<T> delegate;
  public final TypeArg<T> __typeArg_0;
  
  public MethodWithGenericFunctionArg(io.vertx.codegen.extra.MethodWithGenericFunctionArg delegate) {
    this.delegate = delegate;
    this.__typeArg_0 = TypeArg.unknown();  }

  public MethodWithGenericFunctionArg(Object delegate, TypeArg<T> typeArg_0) {
    this.delegate = (io.vertx.codegen.extra.MethodWithGenericFunctionArg)delegate;
    this.__typeArg_0 = typeArg_0;
  }

  public io.vertx.codegen.extra.MethodWithGenericFunctionArg getDelegate() {
    return delegate;
  }


  public io.vertx.reactivex.codegen.extra.MethodWithGenericFunctionArg<T> doSomething(java.util.function.Function<io.vertx.reactivex.codegen.extra.Generic1<io.vertx.core.json.JsonObject>,T> theFunction) { 
    io.vertx.reactivex.codegen.extra.MethodWithGenericFunctionArg<T> ret = io.vertx.reactivex.codegen.extra.MethodWithGenericFunctionArg.newInstance((io.vertx.codegen.extra.MethodWithGenericFunctionArg)delegate.doSomething(new Function<io.vertx.codegen.extra.Generic1<io.vertx.core.json.JsonObject>,T>() {
      public T apply(io.vertx.codegen.extra.Generic1<io.vertx.core.json.JsonObject> arg) {
        T ret = theFunction.apply(io.vertx.reactivex.codegen.extra.Generic1.newInstance((io.vertx.codegen.extra.Generic1)arg, TypeArg.unknown()));
        return __typeArg_0.<T>unwrap(ret);
      }
    }), __typeArg_0);
    return ret;
  }

  public static <T> MethodWithGenericFunctionArg<T> newInstance(io.vertx.codegen.extra.MethodWithGenericFunctionArg arg) {
    return arg != null ? new MethodWithGenericFunctionArg<T>(arg) : null;
  }

  public static <T> MethodWithGenericFunctionArg<T> newInstance(io.vertx.codegen.extra.MethodWithGenericFunctionArg arg, TypeArg<T> __typeArg_T) {
    return arg != null ? new MethodWithGenericFunctionArg<T>(arg, __typeArg_T) : null;
  }

}
