/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.codegen.extra;

import io.vertx.reactivex.RxHelper;
import io.vertx.reactivex.ObservableHelper;
import io.vertx.reactivex.FlowableHelper;
import io.vertx.reactivex.impl.AsyncResultMaybe;
import io.vertx.reactivex.impl.AsyncResultSingle;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.WriteStreamObserver;
import io.vertx.reactivex.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;


@RxGen(io.vertx.codegen.extra.NestedParameterizedType.class)
public class NestedParameterizedType {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    NestedParameterizedType that = (NestedParameterizedType) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<NestedParameterizedType> __TYPE_ARG = new TypeArg<>(    obj -> new NestedParameterizedType((io.vertx.codegen.extra.NestedParameterizedType) obj),
    NestedParameterizedType::getDelegate
  );

  private final io.vertx.codegen.extra.NestedParameterizedType delegate;
  
  public NestedParameterizedType(io.vertx.codegen.extra.NestedParameterizedType delegate) {
    this.delegate = delegate;
  }

  public NestedParameterizedType(Object delegate) {
    this.delegate = (io.vertx.codegen.extra.NestedParameterizedType)delegate;
  }

  public io.vertx.codegen.extra.NestedParameterizedType getDelegate() {
    return delegate;
  }

  private static final TypeArg<io.vertx.reactivex.codegen.extra.Generic1<io.vertx.reactivex.codegen.extra.Foo>> TYPE_ARG_0 = new TypeArg<io.vertx.reactivex.codegen.extra.Generic1<io.vertx.reactivex.codegen.extra.Foo>>(o1 -> io.vertx.reactivex.codegen.extra.Generic1.newInstance((io.vertx.codegen.extra.Generic1)o1, new TypeArg<io.vertx.reactivex.codegen.extra.Foo>(o2 -> io.vertx.reactivex.codegen.extra.Foo.newInstance((io.vertx.codegen.extra.Foo)o2), o2 -> o2.getDelegate())), o1 -> o1.getDelegate());
  private static final TypeArg<io.vertx.reactivex.codegen.extra.Generic2<io.vertx.reactivex.codegen.extra.Foo,io.vertx.reactivex.codegen.extra.Bar>> TYPE_ARG_1 = new TypeArg<io.vertx.reactivex.codegen.extra.Generic2<io.vertx.reactivex.codegen.extra.Foo,io.vertx.reactivex.codegen.extra.Bar>>(o1 -> io.vertx.reactivex.codegen.extra.Generic2.newInstance((io.vertx.codegen.extra.Generic2)o1, new TypeArg<io.vertx.reactivex.codegen.extra.Foo>(o2 -> io.vertx.reactivex.codegen.extra.Foo.newInstance((io.vertx.codegen.extra.Foo)o2), o2 -> o2.getDelegate()), new TypeArg<io.vertx.reactivex.codegen.extra.Bar>(o2 -> io.vertx.reactivex.codegen.extra.Bar.newInstance((io.vertx.codegen.extra.Bar)o2), o2 -> o2.getDelegate())), o1 -> o1.getDelegate());

  public static io.vertx.reactivex.codegen.extra.Generic2<io.vertx.reactivex.codegen.extra.Generic1<io.vertx.reactivex.codegen.extra.Foo>,io.vertx.reactivex.codegen.extra.Generic2<io.vertx.reactivex.codegen.extra.Foo,io.vertx.reactivex.codegen.extra.Bar>> someGeneric() { 
    io.vertx.reactivex.codegen.extra.Generic2<io.vertx.reactivex.codegen.extra.Generic1<io.vertx.reactivex.codegen.extra.Foo>,io.vertx.reactivex.codegen.extra.Generic2<io.vertx.reactivex.codegen.extra.Foo,io.vertx.reactivex.codegen.extra.Bar>> ret = io.vertx.reactivex.codegen.extra.Generic2.newInstance((io.vertx.codegen.extra.Generic2)io.vertx.codegen.extra.NestedParameterizedType.someGeneric(), TYPE_ARG_0, TYPE_ARG_1);
    return ret;
  }

  public static NestedParameterizedType newInstance(io.vertx.codegen.extra.NestedParameterizedType arg) {
    return arg != null ? new NestedParameterizedType(arg) : null;
  }

}
