/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.codegen.extra;

import io.vertx.reactivex.RxHelper;
import io.vertx.reactivex.ObservableHelper;
import io.vertx.reactivex.FlowableHelper;
import io.vertx.reactivex.impl.AsyncResultMaybe;
import io.vertx.reactivex.impl.AsyncResultSingle;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.WriteStreamObserver;
import io.vertx.reactivex.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;


@RxGen(io.vertx.codegen.extra.UseVertxGenNameDeclarationsWithSameSimpleName.class)
public class UseVertxGenNameDeclarationsWithSameSimpleName extends io.vertx.reactivex.codegen.extra.sub.UseVertxGenNameDeclarationsWithSameSimpleName implements io.vertx.reactivex.core.streams.ReadStream<io.vertx.reactivex.codegen.extra.sub.UseVertxGenNameDeclarationsWithSameSimpleName>, Handler<io.vertx.reactivex.codegen.extra.sub.UseVertxGenNameDeclarationsWithSameSimpleName> {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    UseVertxGenNameDeclarationsWithSameSimpleName that = (UseVertxGenNameDeclarationsWithSameSimpleName) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<UseVertxGenNameDeclarationsWithSameSimpleName> __TYPE_ARG = new TypeArg<>(    obj -> new UseVertxGenNameDeclarationsWithSameSimpleName((io.vertx.codegen.extra.UseVertxGenNameDeclarationsWithSameSimpleName) obj),
    UseVertxGenNameDeclarationsWithSameSimpleName::getDelegate
  );

  private final io.vertx.codegen.extra.UseVertxGenNameDeclarationsWithSameSimpleName delegate;
  
  public UseVertxGenNameDeclarationsWithSameSimpleName(io.vertx.codegen.extra.UseVertxGenNameDeclarationsWithSameSimpleName delegate) {
    super(delegate);
    this.delegate = delegate;
  }

  public UseVertxGenNameDeclarationsWithSameSimpleName(Object delegate) {
    super((io.vertx.codegen.extra.UseVertxGenNameDeclarationsWithSameSimpleName)delegate);
    this.delegate = (io.vertx.codegen.extra.UseVertxGenNameDeclarationsWithSameSimpleName)delegate;
  }

  public io.vertx.codegen.extra.UseVertxGenNameDeclarationsWithSameSimpleName getDelegate() {
    return delegate;
  }

  private io.reactivex.Observable<io.vertx.reactivex.codegen.extra.sub.UseVertxGenNameDeclarationsWithSameSimpleName> observable;
  private io.reactivex.Flowable<io.vertx.reactivex.codegen.extra.sub.UseVertxGenNameDeclarationsWithSameSimpleName> flowable;

  public synchronized io.reactivex.Observable<io.vertx.reactivex.codegen.extra.sub.UseVertxGenNameDeclarationsWithSameSimpleName> toObservable() {
    if (observable == null) {
      Function<io.vertx.codegen.extra.sub.UseVertxGenNameDeclarationsWithSameSimpleName, io.vertx.reactivex.codegen.extra.sub.UseVertxGenNameDeclarationsWithSameSimpleName> conv = io.vertx.reactivex.codegen.extra.sub.UseVertxGenNameDeclarationsWithSameSimpleName::newInstance;
      observable = ObservableHelper.toObservable(delegate, conv);
    }
    return observable;
  }

  public synchronized io.reactivex.Flowable<io.vertx.reactivex.codegen.extra.sub.UseVertxGenNameDeclarationsWithSameSimpleName> toFlowable() {
    if (flowable == null) {
      Function<io.vertx.codegen.extra.sub.UseVertxGenNameDeclarationsWithSameSimpleName, io.vertx.reactivex.codegen.extra.sub.UseVertxGenNameDeclarationsWithSameSimpleName> conv = io.vertx.reactivex.codegen.extra.sub.UseVertxGenNameDeclarationsWithSameSimpleName::newInstance;
      flowable = FlowableHelper.toFlowable(delegate, conv);
    }
    return flowable;
  }

  private static final TypeArg<io.vertx.reactivex.codegen.extra.sub.UseVertxGenNameDeclarationsWithSameSimpleName> TYPE_ARG_0 = new TypeArg<io.vertx.reactivex.codegen.extra.sub.UseVertxGenNameDeclarationsWithSameSimpleName>(o1 -> io.vertx.reactivex.codegen.extra.sub.UseVertxGenNameDeclarationsWithSameSimpleName.newInstance((io.vertx.codegen.extra.sub.UseVertxGenNameDeclarationsWithSameSimpleName)o1), o1 -> o1.getDelegate());
  private static final TypeArg<io.vertx.reactivex.codegen.extra.sub.UseVertxGenNameDeclarationsWithSameSimpleName> TYPE_ARG_1 = new TypeArg<io.vertx.reactivex.codegen.extra.sub.UseVertxGenNameDeclarationsWithSameSimpleName>(o1 -> io.vertx.reactivex.codegen.extra.sub.UseVertxGenNameDeclarationsWithSameSimpleName.newInstance((io.vertx.codegen.extra.sub.UseVertxGenNameDeclarationsWithSameSimpleName)o1), o1 -> o1.getDelegate());
  private static final TypeArg<io.vertx.reactivex.codegen.extra.sub.UseVertxGenNameDeclarationsWithSameSimpleName> TYPE_ARG_2 = new TypeArg<io.vertx.reactivex.codegen.extra.sub.UseVertxGenNameDeclarationsWithSameSimpleName>(o1 -> io.vertx.reactivex.codegen.extra.sub.UseVertxGenNameDeclarationsWithSameSimpleName.newInstance((io.vertx.codegen.extra.sub.UseVertxGenNameDeclarationsWithSameSimpleName)o1), o1 -> o1.getDelegate());
  private static final TypeArg<io.vertx.reactivex.codegen.extra.sub.UseVertxGenNameDeclarationsWithSameSimpleName> TYPE_ARG_3 = new TypeArg<io.vertx.reactivex.codegen.extra.sub.UseVertxGenNameDeclarationsWithSameSimpleName>(o1 -> io.vertx.reactivex.codegen.extra.sub.UseVertxGenNameDeclarationsWithSameSimpleName.newInstance((io.vertx.codegen.extra.sub.UseVertxGenNameDeclarationsWithSameSimpleName)o1), o1 -> o1.getDelegate());
  private static final TypeArg<io.vertx.reactivex.codegen.extra.sub.UseVertxGenNameDeclarationsWithSameSimpleName> TYPE_ARG_4 = new TypeArg<io.vertx.reactivex.codegen.extra.sub.UseVertxGenNameDeclarationsWithSameSimpleName>(o1 -> io.vertx.reactivex.codegen.extra.sub.UseVertxGenNameDeclarationsWithSameSimpleName.newInstance((io.vertx.codegen.extra.sub.UseVertxGenNameDeclarationsWithSameSimpleName)o1), o1 -> o1.getDelegate());
  private static final TypeArg<io.vertx.reactivex.codegen.extra.sub.UseVertxGenNameDeclarationsWithSameSimpleName> TYPE_ARG_5 = new TypeArg<io.vertx.reactivex.codegen.extra.sub.UseVertxGenNameDeclarationsWithSameSimpleName>(o1 -> io.vertx.reactivex.codegen.extra.sub.UseVertxGenNameDeclarationsWithSameSimpleName.newInstance((io.vertx.codegen.extra.sub.UseVertxGenNameDeclarationsWithSameSimpleName)o1), o1 -> o1.getDelegate());
  private static final TypeArg<io.vertx.reactivex.codegen.extra.sub.UseVertxGenNameDeclarationsWithSameSimpleName> TYPE_ARG_6 = new TypeArg<io.vertx.reactivex.codegen.extra.sub.UseVertxGenNameDeclarationsWithSameSimpleName>(o1 -> io.vertx.reactivex.codegen.extra.sub.UseVertxGenNameDeclarationsWithSameSimpleName.newInstance((io.vertx.codegen.extra.sub.UseVertxGenNameDeclarationsWithSameSimpleName)o1), o1 -> o1.getDelegate());
  private static final TypeArg<io.vertx.reactivex.codegen.extra.sub.UseVertxGenNameDeclarationsWithSameSimpleName> TYPE_ARG_7 = new TypeArg<io.vertx.reactivex.codegen.extra.sub.UseVertxGenNameDeclarationsWithSameSimpleName>(o1 -> io.vertx.reactivex.codegen.extra.sub.UseVertxGenNameDeclarationsWithSameSimpleName.newInstance((io.vertx.codegen.extra.sub.UseVertxGenNameDeclarationsWithSameSimpleName)o1), o1 -> o1.getDelegate());

  public void handle(io.vertx.reactivex.codegen.extra.sub.UseVertxGenNameDeclarationsWithSameSimpleName arg0) { 
    delegate.handle(arg0.getDelegate());
  }

  public io.vertx.reactivex.core.streams.ReadStream<io.vertx.reactivex.codegen.extra.sub.UseVertxGenNameDeclarationsWithSameSimpleName> exceptionHandler(io.vertx.core.Handler<java.lang.Throwable> arg0) { 
    delegate.exceptionHandler(arg0);
    return this;
  }

  public io.vertx.reactivex.core.streams.ReadStream<io.vertx.reactivex.codegen.extra.sub.UseVertxGenNameDeclarationsWithSameSimpleName> handler(io.vertx.core.Handler<io.vertx.reactivex.codegen.extra.sub.UseVertxGenNameDeclarationsWithSameSimpleName> arg0) { 
    delegate.handler(new Handler<io.vertx.codegen.extra.sub.UseVertxGenNameDeclarationsWithSameSimpleName>() {
      public void handle(io.vertx.codegen.extra.sub.UseVertxGenNameDeclarationsWithSameSimpleName event) {
        arg0.handle(io.vertx.reactivex.codegen.extra.sub.UseVertxGenNameDeclarationsWithSameSimpleName.newInstance((io.vertx.codegen.extra.sub.UseVertxGenNameDeclarationsWithSameSimpleName)event));
      }
    });
    return this;
  }

  public io.vertx.reactivex.core.streams.ReadStream<io.vertx.reactivex.codegen.extra.sub.UseVertxGenNameDeclarationsWithSameSimpleName> pause() { 
    delegate.pause();
    return this;
  }

  public io.vertx.reactivex.core.streams.ReadStream<io.vertx.reactivex.codegen.extra.sub.UseVertxGenNameDeclarationsWithSameSimpleName> resume() { 
    delegate.resume();
    return this;
  }

  public io.vertx.reactivex.core.streams.ReadStream<io.vertx.reactivex.codegen.extra.sub.UseVertxGenNameDeclarationsWithSameSimpleName> fetch(long arg0) { 
    delegate.fetch(arg0);
    return this;
  }

  public io.vertx.reactivex.core.streams.ReadStream<io.vertx.reactivex.codegen.extra.sub.UseVertxGenNameDeclarationsWithSameSimpleName> endHandler(io.vertx.core.Handler<java.lang.Void> arg0) { 
    delegate.endHandler(arg0);
    return this;
  }

  public io.vertx.reactivex.core.streams.Pipe<io.vertx.reactivex.codegen.extra.sub.UseVertxGenNameDeclarationsWithSameSimpleName> pipe() { 
    io.vertx.reactivex.core.streams.Pipe<io.vertx.reactivex.codegen.extra.sub.UseVertxGenNameDeclarationsWithSameSimpleName> ret = io.vertx.reactivex.core.streams.Pipe.newInstance((io.vertx.core.streams.Pipe)delegate.pipe(), TYPE_ARG_6);
    return ret;
  }

  public void pipeTo(io.vertx.reactivex.core.streams.WriteStream<io.vertx.reactivex.codegen.extra.sub.UseVertxGenNameDeclarationsWithSameSimpleName> dst, io.vertx.core.Handler<io.vertx.core.AsyncResult<java.lang.Void>> handler) { 
    delegate.pipeTo(dst.getDelegate(), handler);
  }

  public void pipeTo(io.vertx.reactivex.core.streams.WriteStream<io.vertx.reactivex.codegen.extra.sub.UseVertxGenNameDeclarationsWithSameSimpleName> dst) {
    pipeTo(dst, ar -> { });
  }

  public io.reactivex.Completable rxPipeTo(io.vertx.reactivex.core.streams.WriteStream<io.vertx.reactivex.codegen.extra.sub.UseVertxGenNameDeclarationsWithSameSimpleName> dst) { 
    return AsyncResultCompletable.toCompletable($handler -> {
      pipeTo(dst, $handler);
    });
  }

  public io.vertx.reactivex.codegen.extra.sub.UseVertxGenNameDeclarationsWithSameSimpleName foo(io.vertx.reactivex.codegen.extra.sub.UseVertxGenNameDeclarationsWithSameSimpleName arg) { 
    if (cached_0 != null) {
      return cached_0;
    }
    io.vertx.reactivex.codegen.extra.sub.UseVertxGenNameDeclarationsWithSameSimpleName ret = io.vertx.reactivex.codegen.extra.sub.UseVertxGenNameDeclarationsWithSameSimpleName.newInstance((io.vertx.codegen.extra.sub.UseVertxGenNameDeclarationsWithSameSimpleName)delegate.foo(arg.getDelegate()));
    cached_0 = ret;
    return ret;
  }

  public void function(java.util.function.Function<io.vertx.reactivex.codegen.extra.sub.UseVertxGenNameDeclarationsWithSameSimpleName,io.vertx.reactivex.codegen.extra.sub.UseVertxGenNameDeclarationsWithSameSimpleName> function) { 
    delegate.function(new Function<io.vertx.codegen.extra.sub.UseVertxGenNameDeclarationsWithSameSimpleName,io.vertx.codegen.extra.sub.UseVertxGenNameDeclarationsWithSameSimpleName>() {
      public io.vertx.codegen.extra.sub.UseVertxGenNameDeclarationsWithSameSimpleName apply(io.vertx.codegen.extra.sub.UseVertxGenNameDeclarationsWithSameSimpleName arg) {
        io.vertx.reactivex.codegen.extra.sub.UseVertxGenNameDeclarationsWithSameSimpleName ret = function.apply(io.vertx.reactivex.codegen.extra.sub.UseVertxGenNameDeclarationsWithSameSimpleName.newInstance((io.vertx.codegen.extra.sub.UseVertxGenNameDeclarationsWithSameSimpleName)arg));
        return ret.getDelegate();
      }
    });
  }

  public void asyncResult(io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.codegen.extra.sub.UseVertxGenNameDeclarationsWithSameSimpleName>> handler) { 
    delegate.asyncResult(new Handler<AsyncResult<io.vertx.codegen.extra.sub.UseVertxGenNameDeclarationsWithSameSimpleName>>() {
      public void handle(AsyncResult<io.vertx.codegen.extra.sub.UseVertxGenNameDeclarationsWithSameSimpleName> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.codegen.extra.sub.UseVertxGenNameDeclarationsWithSameSimpleName.newInstance((io.vertx.codegen.extra.sub.UseVertxGenNameDeclarationsWithSameSimpleName)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
  }

  public void asyncResult() {
    asyncResult(ar -> { });
  }

  public io.reactivex.Single<io.vertx.reactivex.codegen.extra.sub.UseVertxGenNameDeclarationsWithSameSimpleName> rxAsyncResult() { 
    return AsyncResultSingle.toSingle($handler -> {
      asyncResult($handler);
    });
  }

  public io.vertx.core.Handler<io.vertx.reactivex.codegen.extra.sub.UseVertxGenNameDeclarationsWithSameSimpleName> returnHandler() { 
    io.vertx.core.Handler<io.vertx.reactivex.codegen.extra.sub.UseVertxGenNameDeclarationsWithSameSimpleName> ret = new Handler<io.vertx.reactivex.codegen.extra.sub.UseVertxGenNameDeclarationsWithSameSimpleName>() {
      public void handle(io.vertx.reactivex.codegen.extra.sub.UseVertxGenNameDeclarationsWithSameSimpleName event) {
          delegate.returnHandler().handle(event.getDelegate());
      }
    };
    return ret;
  }

  public io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.codegen.extra.sub.UseVertxGenNameDeclarationsWithSameSimpleName>> returnHandlerAsyncResult() { 
    io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.codegen.extra.sub.UseVertxGenNameDeclarationsWithSameSimpleName>> ret = new Handler<AsyncResult<io.vertx.reactivex.codegen.extra.sub.UseVertxGenNameDeclarationsWithSameSimpleName>>() {
      public void handle(AsyncResult<io.vertx.reactivex.codegen.extra.sub.UseVertxGenNameDeclarationsWithSameSimpleName> ar) {
        if (ar.succeeded()) {
          delegate.returnHandlerAsyncResult().handle(io.vertx.core.Future.succeededFuture(ar.result().getDelegate()));
        } else {
          delegate.returnHandlerAsyncResult().handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    };
    return ret;
  }

  private io.vertx.reactivex.codegen.extra.sub.UseVertxGenNameDeclarationsWithSameSimpleName cached_0;
  public static UseVertxGenNameDeclarationsWithSameSimpleName newInstance(io.vertx.codegen.extra.UseVertxGenNameDeclarationsWithSameSimpleName arg) {
    return arg != null ? new UseVertxGenNameDeclarationsWithSameSimpleName(arg) : null;
  }

}
