/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.codegen.rxjava2;

import io.vertx.reactivex.RxHelper;
import io.vertx.reactivex.ObservableHelper;
import io.vertx.reactivex.FlowableHelper;
import io.vertx.reactivex.impl.AsyncResultMaybe;
import io.vertx.reactivex.impl.AsyncResultSingle;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.WriteStreamObserver;
import io.vertx.reactivex.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.codegen.rxjava2.MethodWithFunction original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.codegen.rxjava2.MethodWithFunction.class)
public class MethodWithFunction {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    MethodWithFunction that = (MethodWithFunction) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<MethodWithFunction> __TYPE_ARG = new TypeArg<>(    obj -> new MethodWithFunction((io.vertx.codegen.rxjava2.MethodWithFunction) obj),
    MethodWithFunction::getDelegate
  );

  private final io.vertx.codegen.rxjava2.MethodWithFunction delegate;
  
  public MethodWithFunction(io.vertx.codegen.rxjava2.MethodWithFunction delegate) {
    this.delegate = delegate;
  }

  public MethodWithFunction(Object delegate) {
    this.delegate = (io.vertx.codegen.rxjava2.MethodWithFunction)delegate;
  }

  public io.vertx.codegen.rxjava2.MethodWithFunction getDelegate() {
    return delegate;
  }

  public static <T, R> boolean isSucceeded(T t, java.util.function.Function<T,io.vertx.core.Future<R>> future) { 
    boolean ret = io.vertx.codegen.rxjava2.MethodWithFunction.isSucceeded(t, new Function<T,io.vertx.core.Future<R>>() {
      public io.vertx.core.Future<R> apply(T arg) {
        io.vertx.core.Future<R> ret = future.apply((T) arg);
        return ret.map(val -> val);
      }
    });
    return ret;
  }

  public static <T, R> boolean isSucceeded(T t, io.reactivex.functions.Function<T,io.reactivex.Single<R>> future) { 
    boolean ret = io.vertx.codegen.rxjava2.MethodWithFunction.isSucceeded(t, new Function<T,io.vertx.core.Future<R>>() {
      public io.vertx.core.Future<R> apply(T arg) {
        io.reactivex.Single<R> ret;
        try {
          ret = future.apply((T) arg);
        } catch (Exception e) {
          return io.vertx.core.Future.failedFuture(e);
        }
        return io.vertx.reactivex.SingleHelper.toFuture(ret, obj -> obj);
      }
    });
    return ret;
  }

  public static <T, R> boolean isFailed(T t, java.util.function.Function<T,io.vertx.core.Future<R>> future) { 
    boolean ret = io.vertx.codegen.rxjava2.MethodWithFunction.isFailed(t, new Function<T,io.vertx.core.Future<R>>() {
      public io.vertx.core.Future<R> apply(T arg) {
        io.vertx.core.Future<R> ret = future.apply((T) arg);
        return ret.map(val -> val);
      }
    });
    return ret;
  }

  public static <T, R> boolean isFailed(T t, io.reactivex.functions.Function<T,io.reactivex.Single<R>> future) { 
    boolean ret = io.vertx.codegen.rxjava2.MethodWithFunction.isFailed(t, new Function<T,io.vertx.core.Future<R>>() {
      public io.vertx.core.Future<R> apply(T arg) {
        io.reactivex.Single<R> ret;
        try {
          ret = future.apply((T) arg);
        } catch (Exception e) {
          return io.vertx.core.Future.failedFuture(e);
        }
        return io.vertx.reactivex.SingleHelper.toFuture(ret, obj -> obj);
      }
    });
    return ret;
  }

  public static <T, R> boolean isComplete(T t, java.util.function.Function<T,io.vertx.core.Future<R>> future) { 
    boolean ret = io.vertx.codegen.rxjava2.MethodWithFunction.isComplete(t, new Function<T,io.vertx.core.Future<R>>() {
      public io.vertx.core.Future<R> apply(T arg) {
        io.vertx.core.Future<R> ret = future.apply((T) arg);
        return ret.map(val -> val);
      }
    });
    return ret;
  }

  public static <T, R> boolean isComplete(T t, io.reactivex.functions.Function<T,io.reactivex.Single<R>> future) { 
    boolean ret = io.vertx.codegen.rxjava2.MethodWithFunction.isComplete(t, new Function<T,io.vertx.core.Future<R>>() {
      public io.vertx.core.Future<R> apply(T arg) {
        io.reactivex.Single<R> ret;
        try {
          ret = future.apply((T) arg);
        } catch (Exception e) {
          return io.vertx.core.Future.failedFuture(e);
        }
        return io.vertx.reactivex.SingleHelper.toFuture(ret, obj -> obj);
      }
    });
    return ret;
  }

  public static <T, R> R getResult(T t, java.util.function.Function<T,io.vertx.core.Future<R>> future) { 
    R ret = (R) io.vertx.codegen.rxjava2.MethodWithFunction.getResult(t, new Function<T,io.vertx.core.Future<R>>() {
      public io.vertx.core.Future<R> apply(T arg) {
        io.vertx.core.Future<R> ret = future.apply((T) arg);
        return ret.map(val -> val);
      }
    });
    return ret;
  }

  public static <T, R> R getResult(T t, io.reactivex.functions.Function<T,io.reactivex.Single<R>> future) { 
    R ret = (R) io.vertx.codegen.rxjava2.MethodWithFunction.getResult(t, new Function<T,io.vertx.core.Future<R>>() {
      public io.vertx.core.Future<R> apply(T arg) {
        io.reactivex.Single<R> ret;
        try {
          ret = future.apply((T) arg);
        } catch (Exception e) {
          return io.vertx.core.Future.failedFuture(e);
        }
        return io.vertx.reactivex.SingleHelper.toFuture(ret, obj -> obj);
      }
    });
    return ret;
  }

  public static <T, R> java.lang.Throwable getCause(T t, java.util.function.Function<T,io.vertx.core.Future<R>> future) { 
    java.lang.Throwable ret = io.vertx.codegen.rxjava2.MethodWithFunction.getCause(t, new Function<T,io.vertx.core.Future<R>>() {
      public io.vertx.core.Future<R> apply(T arg) {
        io.vertx.core.Future<R> ret = future.apply((T) arg);
        return ret.map(val -> val);
      }
    });
    return ret;
  }

  public static <T, R> java.lang.Throwable getCause(T t, io.reactivex.functions.Function<T,io.reactivex.Single<R>> future) { 
    java.lang.Throwable ret = io.vertx.codegen.rxjava2.MethodWithFunction.getCause(t, new Function<T,io.vertx.core.Future<R>>() {
      public io.vertx.core.Future<R> apply(T arg) {
        io.reactivex.Single<R> ret;
        try {
          ret = future.apply((T) arg);
        } catch (Exception e) {
          return io.vertx.core.Future.failedFuture(e);
        }
        return io.vertx.reactivex.SingleHelper.toFuture(ret, obj -> obj);
      }
    });
    return ret;
  }

  public static MethodWithFunction newInstance(io.vertx.codegen.rxjava2.MethodWithFunction arg) {
    return arg != null ? new MethodWithFunction(arg) : null;
  }

}
