/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.codegen.rxjava2;

import io.vertx.reactivex.RxHelper;
import io.vertx.reactivex.ObservableHelper;
import io.vertx.reactivex.FlowableHelper;
import io.vertx.reactivex.impl.AsyncResultMaybe;
import io.vertx.reactivex.impl.AsyncResultSingle;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.WriteStreamObserver;
import io.vertx.reactivex.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.codegen.rxjava2.MethodWithFuture original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.codegen.rxjava2.MethodWithFuture.class)
public class MethodWithFuture {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    MethodWithFuture that = (MethodWithFuture) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<MethodWithFuture> __TYPE_ARG = new TypeArg<>(    obj -> new MethodWithFuture((io.vertx.codegen.rxjava2.MethodWithFuture) obj),
    MethodWithFuture::getDelegate
  );

  private final io.vertx.codegen.rxjava2.MethodWithFuture delegate;
  
  public MethodWithFuture(io.vertx.codegen.rxjava2.MethodWithFuture delegate) {
    this.delegate = delegate;
  }

  public MethodWithFuture(Object delegate) {
    this.delegate = (io.vertx.codegen.rxjava2.MethodWithFuture)delegate;
  }

  public io.vertx.codegen.rxjava2.MethodWithFuture getDelegate() {
    return delegate;
  }

  private static final TypeArg<io.vertx.reactivex.codegen.rxjava2.MethodWithFuture> TYPE_ARG_0 = new TypeArg<io.vertx.reactivex.codegen.rxjava2.MethodWithFuture>(o1 -> io.vertx.reactivex.codegen.rxjava2.MethodWithFuture.newInstance((io.vertx.codegen.rxjava2.MethodWithFuture)o1), o1 -> o1.getDelegate());

  public static <T> boolean isSucceeded(io.vertx.core.Future<T> future) { 
    boolean ret = io.vertx.codegen.rxjava2.MethodWithFuture.isSucceeded(future.map(val -> val));
    return ret;
  }

  public static <T> boolean isSucceeded(io.reactivex.Single<T> future) { 
    boolean ret = io.vertx.codegen.rxjava2.MethodWithFuture.isSucceeded(io.vertx.reactivex.SingleHelper.toFuture(future, obj -> obj));
    return ret;
  }

  public static <T> boolean isFailed(io.vertx.core.Future<T> future) { 
    boolean ret = io.vertx.codegen.rxjava2.MethodWithFuture.isFailed(future.map(val -> val));
    return ret;
  }

  public static <T> boolean isFailed(io.reactivex.Single<T> future) { 
    boolean ret = io.vertx.codegen.rxjava2.MethodWithFuture.isFailed(io.vertx.reactivex.SingleHelper.toFuture(future, obj -> obj));
    return ret;
  }

  public static <T> boolean isComplete(io.vertx.core.Future<T> future) { 
    boolean ret = io.vertx.codegen.rxjava2.MethodWithFuture.isComplete(future.map(val -> val));
    return ret;
  }

  public static <T> boolean isComplete(io.reactivex.Single<T> future) { 
    boolean ret = io.vertx.codegen.rxjava2.MethodWithFuture.isComplete(io.vertx.reactivex.SingleHelper.toFuture(future, obj -> obj));
    return ret;
  }

  public static <T> T getResult(io.vertx.core.Future<T> future) { 
    T ret = (T) io.vertx.codegen.rxjava2.MethodWithFuture.getResult(future.map(val -> val));
    return ret;
  }

  public static <T> T getResult(io.reactivex.Single<T> future) { 
    T ret = (T) io.vertx.codegen.rxjava2.MethodWithFuture.getResult(io.vertx.reactivex.SingleHelper.toFuture(future, obj -> obj));
    return ret;
  }

  public static <T> java.lang.Throwable getCause(io.vertx.core.Future<T> future) { 
    java.lang.Throwable ret = io.vertx.codegen.rxjava2.MethodWithFuture.getCause(future.map(val -> val));
    return ret;
  }

  public static <T> java.lang.Throwable getCause(io.reactivex.Single<T> future) { 
    java.lang.Throwable ret = io.vertx.codegen.rxjava2.MethodWithFuture.getCause(io.vertx.reactivex.SingleHelper.toFuture(future, obj -> obj));
    return ret;
  }

  public static io.vertx.core.Future<io.vertx.reactivex.codegen.rxjava2.MethodWithFuture> withVertxGen(io.vertx.core.Future<io.vertx.reactivex.codegen.rxjava2.MethodWithFuture> future) { 
    io.vertx.core.Future<io.vertx.reactivex.codegen.rxjava2.MethodWithFuture> ret = io.vertx.codegen.rxjava2.MethodWithFuture.withVertxGen(future.map(val -> val.getDelegate())).map(val -> io.vertx.reactivex.codegen.rxjava2.MethodWithFuture.newInstance((io.vertx.codegen.rxjava2.MethodWithFuture)val));
    return ret;
  }

  public static io.vertx.core.Future<io.vertx.reactivex.codegen.rxjava2.MethodWithFuture> withVertxGen(io.reactivex.Single<io.vertx.reactivex.codegen.rxjava2.MethodWithFuture> future) { 
    io.vertx.core.Future<io.vertx.reactivex.codegen.rxjava2.MethodWithFuture> ret = io.vertx.codegen.rxjava2.MethodWithFuture.withVertxGen(io.vertx.reactivex.SingleHelper.toFuture(future, obj -> obj.getDelegate())).map(val -> io.vertx.reactivex.codegen.rxjava2.MethodWithFuture.newInstance((io.vertx.codegen.rxjava2.MethodWithFuture)val));
    return ret;
  }

  public static MethodWithFuture newInstance(io.vertx.codegen.rxjava2.MethodWithFuture arg) {
    return arg != null ? new MethodWithFuture(arg) : null;
  }

}
