/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.codegen.rxjava2;

import io.vertx.reactivex.RxHelper;
import io.vertx.reactivex.ObservableHelper;
import io.vertx.reactivex.FlowableHelper;
import io.vertx.reactivex.impl.AsyncResultMaybe;
import io.vertx.reactivex.impl.AsyncResultSingle;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.WriteStreamObserver;
import io.vertx.reactivex.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.codegen.rxjava2.MethodWithMultiCallback original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.codegen.rxjava2.MethodWithMultiCallback.class)
public class MethodWithMultiCallback {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    MethodWithMultiCallback that = (MethodWithMultiCallback) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<MethodWithMultiCallback> __TYPE_ARG = new TypeArg<>(    obj -> new MethodWithMultiCallback((io.vertx.codegen.rxjava2.MethodWithMultiCallback) obj),
    MethodWithMultiCallback::getDelegate
  );

  private final io.vertx.codegen.rxjava2.MethodWithMultiCallback delegate;
  
  public MethodWithMultiCallback(io.vertx.codegen.rxjava2.MethodWithMultiCallback delegate) {
    this.delegate = delegate;
  }

  public MethodWithMultiCallback(Object delegate) {
    this.delegate = (io.vertx.codegen.rxjava2.MethodWithMultiCallback)delegate;
  }

  public io.vertx.codegen.rxjava2.MethodWithMultiCallback getDelegate() {
    return delegate;
  }

  public void multiCompletable(io.vertx.core.Handler<io.vertx.core.AsyncResult<java.lang.Void>> handler) { 
    delegate.multiCompletable(handler);
  }

  public void multiCompletable() {
    multiCompletable(ar -> { });
  }

  public io.reactivex.Completable rxMultiCompletable() { 
    return AsyncResultCompletable.toCompletable($handler -> {
      multiCompletable($handler);
    });
  }

  public void multiMaybe(io.vertx.core.Handler<io.vertx.core.AsyncResult<java.lang.String>> handler) { 
    delegate.multiMaybe(handler);
  }

  public void multiMaybe() {
    multiMaybe(ar -> { });
  }

  public io.reactivex.Maybe<java.lang.String> rxMultiMaybe() { 
    return AsyncResultMaybe.toMaybe($handler -> {
      multiMaybe($handler);
    });
  }

  public void multiSingle(io.vertx.core.Handler<io.vertx.core.AsyncResult<java.lang.String>> handler) { 
    delegate.multiSingle(handler);
  }

  public void multiSingle() {
    multiSingle(ar -> { });
  }

  public io.reactivex.Single<java.lang.String> rxMultiSingle() { 
    return AsyncResultSingle.toSingle($handler -> {
      multiSingle($handler);
    });
  }

  public static MethodWithMultiCallback newInstance(io.vertx.codegen.rxjava2.MethodWithMultiCallback arg) {
    return arg != null ? new MethodWithMultiCallback(arg) : null;
  }

}
