/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.codegen.rxjava2;

import io.vertx.reactivex.RxHelper;
import io.vertx.reactivex.ObservableHelper;
import io.vertx.reactivex.FlowableHelper;
import io.vertx.reactivex.impl.AsyncResultMaybe;
import io.vertx.reactivex.impl.AsyncResultSingle;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.WriteStreamObserver;
import io.vertx.reactivex.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.codegen.rxjava2.MethodWithNullableTypeVariable original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.codegen.rxjava2.MethodWithNullableTypeVariable.class)
public class MethodWithNullableTypeVariable<T> {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    MethodWithNullableTypeVariable that = (MethodWithNullableTypeVariable) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<MethodWithNullableTypeVariable> __TYPE_ARG = new TypeArg<>(    obj -> new MethodWithNullableTypeVariable((io.vertx.codegen.rxjava2.MethodWithNullableTypeVariable) obj),
    MethodWithNullableTypeVariable::getDelegate
  );

  private final io.vertx.codegen.rxjava2.MethodWithNullableTypeVariable<T> delegate;
  public final TypeArg<T> __typeArg_0;
  
  public MethodWithNullableTypeVariable(io.vertx.codegen.rxjava2.MethodWithNullableTypeVariable delegate) {
    this.delegate = delegate;
    this.__typeArg_0 = TypeArg.unknown();  }

  public MethodWithNullableTypeVariable(Object delegate, TypeArg<T> typeArg_0) {
    this.delegate = (io.vertx.codegen.rxjava2.MethodWithNullableTypeVariable)delegate;
    this.__typeArg_0 = typeArg_0;
  }

  public io.vertx.codegen.rxjava2.MethodWithNullableTypeVariable getDelegate() {
    return delegate;
  }

  public void doSomethingWithMaybeResult(io.vertx.core.Handler<io.vertx.core.AsyncResult<T>> handler) { 
    delegate.doSomethingWithMaybeResult(new Handler<AsyncResult<T>>() {
      public void handle(AsyncResult<T> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture((T)__typeArg_0.wrap(ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
  }

  public void doSomethingWithMaybeResult() {
    doSomethingWithMaybeResult(ar -> { });
  }

  public io.reactivex.Maybe<T> rxDoSomethingWithMaybeResult() { 
    return AsyncResultMaybe.toMaybe($handler -> {
      doSomethingWithMaybeResult($handler);
    });
  }

  public static <T> MethodWithNullableTypeVariable<T> newInstance(io.vertx.codegen.rxjava2.MethodWithNullableTypeVariable arg) {
    return arg != null ? new MethodWithNullableTypeVariable<T>(arg) : null;
  }

  public static <T> MethodWithNullableTypeVariable<T> newInstance(io.vertx.codegen.rxjava2.MethodWithNullableTypeVariable arg, TypeArg<T> __typeArg_T) {
    return arg != null ? new MethodWithNullableTypeVariable<T>(arg, __typeArg_T) : null;
  }

}
