/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.codegen.rxjava2;

import io.vertx.reactivex.RxHelper;
import io.vertx.reactivex.ObservableHelper;
import io.vertx.reactivex.FlowableHelper;
import io.vertx.reactivex.impl.AsyncResultMaybe;
import io.vertx.reactivex.impl.AsyncResultSingle;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.WriteStreamObserver;
import io.vertx.reactivex.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.codegen.rxjava2.MethodWithSingleString original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.codegen.rxjava2.MethodWithSingleString.class)
public class MethodWithSingleString {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    MethodWithSingleString that = (MethodWithSingleString) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<MethodWithSingleString> __TYPE_ARG = new TypeArg<>(    obj -> new MethodWithSingleString((io.vertx.codegen.rxjava2.MethodWithSingleString) obj),
    MethodWithSingleString::getDelegate
  );

  private final io.vertx.codegen.rxjava2.MethodWithSingleString delegate;
  
  public MethodWithSingleString(io.vertx.codegen.rxjava2.MethodWithSingleString delegate) {
    this.delegate = delegate;
  }

  public MethodWithSingleString(Object delegate) {
    this.delegate = (io.vertx.codegen.rxjava2.MethodWithSingleString)delegate;
  }

  public io.vertx.codegen.rxjava2.MethodWithSingleString getDelegate() {
    return delegate;
  }

  public void doSomethingWithResult(io.vertx.core.Handler<io.vertx.core.AsyncResult<java.lang.String>> handler) { 
    delegate.doSomethingWithResult(handler);
  }

  public void doSomethingWithResult() {
    doSomethingWithResult(ar -> { });
  }

  public io.reactivex.Single<java.lang.String> rxDoSomethingWithResult() { 
    return AsyncResultSingle.toSingle($handler -> {
      doSomethingWithResult($handler);
    });
  }

  public static MethodWithSingleString newInstance(io.vertx.codegen.rxjava2.MethodWithSingleString arg) {
    return arg != null ? new MethodWithSingleString(arg) : null;
  }

}
