/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.codegen.testmodel;

import io.vertx.reactivex.RxHelper;
import io.vertx.reactivex.ObservableHelper;
import io.vertx.reactivex.FlowableHelper;
import io.vertx.reactivex.impl.AsyncResultMaybe;
import io.vertx.reactivex.impl.AsyncResultSingle;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.WriteStreamObserver;
import io.vertx.reactivex.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;


@RxGen(io.vertx.codegen.testmodel.AnyJavaTypeTCK.class)
public class AnyJavaTypeTCK {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    AnyJavaTypeTCK that = (AnyJavaTypeTCK) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<AnyJavaTypeTCK> __TYPE_ARG = new TypeArg<>(    obj -> new AnyJavaTypeTCK((io.vertx.codegen.testmodel.AnyJavaTypeTCK) obj),
    AnyJavaTypeTCK::getDelegate
  );

  private final io.vertx.codegen.testmodel.AnyJavaTypeTCK delegate;
  
  public AnyJavaTypeTCK(io.vertx.codegen.testmodel.AnyJavaTypeTCK delegate) {
    this.delegate = delegate;
  }

  public AnyJavaTypeTCK(Object delegate) {
    this.delegate = (io.vertx.codegen.testmodel.AnyJavaTypeTCK)delegate;
  }

  public io.vertx.codegen.testmodel.AnyJavaTypeTCK getDelegate() {
    return delegate;
  }


  public void methodWithJavaTypeParam(java.net.Socket socket) { 
    delegate.methodWithJavaTypeParam(socket);
  }

  public void methodWithListOfJavaTypeParam(java.util.List<java.net.Socket> socketList) { 
    delegate.methodWithListOfJavaTypeParam(socketList);
  }

  public void methodWithSetOfJavaTypeParam(java.util.Set<java.net.Socket> socketSet) { 
    delegate.methodWithSetOfJavaTypeParam(socketSet);
  }

  public void methodWithMapOfJavaTypeParam(java.util.Map<java.lang.String,java.net.Socket> socketMap) { 
    delegate.methodWithMapOfJavaTypeParam(socketMap);
  }

  public java.net.Socket methodWithJavaTypeReturn() { 
    java.net.Socket ret = delegate.methodWithJavaTypeReturn();
    return ret;
  }

  public java.util.List<java.net.Socket> methodWithListOfJavaTypeReturn() { 
    java.util.List<java.net.Socket> ret = delegate.methodWithListOfJavaTypeReturn();
    return ret;
  }

  public java.util.Set<java.net.Socket> methodWithSetOfJavaTypeReturn() { 
    java.util.Set<java.net.Socket> ret = delegate.methodWithSetOfJavaTypeReturn();
    return ret;
  }

  public java.util.Map<java.lang.String,java.net.Socket> methodWithMapOfJavaTypeReturn() { 
    java.util.Map<java.lang.String,java.net.Socket> ret = delegate.methodWithMapOfJavaTypeReturn();
    return ret;
  }

  public void methodWithHandlerJavaTypeParam(io.vertx.core.Handler<java.net.Socket> socketHandler) { 
    delegate.methodWithHandlerJavaTypeParam(socketHandler);
  }

  public void methodWithHandlerListOfJavaTypeParam(io.vertx.core.Handler<java.util.List<java.net.Socket>> socketListHandler) { 
    delegate.methodWithHandlerListOfJavaTypeParam(socketListHandler);
  }

  public void methodWithHandlerSetOfJavaTypeParam(io.vertx.core.Handler<java.util.Set<java.net.Socket>> socketSetHandler) { 
    delegate.methodWithHandlerSetOfJavaTypeParam(socketSetHandler);
  }

  public void methodWithHandlerMapOfJavaTypeParam(io.vertx.core.Handler<java.util.Map<java.lang.String,java.net.Socket>> socketMapHandler) { 
    delegate.methodWithHandlerMapOfJavaTypeParam(socketMapHandler);
  }

  public void methodWithHandlerAsyncResultJavaTypeParam(io.vertx.core.Handler<io.vertx.core.AsyncResult<java.net.Socket>> socketHandler) { 
    delegate.methodWithHandlerAsyncResultJavaTypeParam(socketHandler);
  }

  public void methodWithHandlerAsyncResultJavaTypeParam() {
    methodWithHandlerAsyncResultJavaTypeParam(ar -> { });
  }

  public io.reactivex.Single<java.net.Socket> rxMethodWithHandlerAsyncResultJavaTypeParam() { 
    return AsyncResultSingle.toSingle($handler -> {
      methodWithHandlerAsyncResultJavaTypeParam($handler);
    });
  }

  public void methodWithHandlerAsyncResultListOfJavaTypeParam(io.vertx.core.Handler<io.vertx.core.AsyncResult<java.util.List<java.net.Socket>>> socketListHandler) { 
    delegate.methodWithHandlerAsyncResultListOfJavaTypeParam(socketListHandler);
  }

  public void methodWithHandlerAsyncResultListOfJavaTypeParam() {
    methodWithHandlerAsyncResultListOfJavaTypeParam(ar -> { });
  }

  public io.reactivex.Single<java.util.List<java.net.Socket>> rxMethodWithHandlerAsyncResultListOfJavaTypeParam() { 
    return AsyncResultSingle.toSingle($handler -> {
      methodWithHandlerAsyncResultListOfJavaTypeParam($handler);
    });
  }

  public void methodWithHandlerAsyncResultSetOfJavaTypeParam(io.vertx.core.Handler<io.vertx.core.AsyncResult<java.util.Set<java.net.Socket>>> socketSetHandler) { 
    delegate.methodWithHandlerAsyncResultSetOfJavaTypeParam(socketSetHandler);
  }

  public void methodWithHandlerAsyncResultSetOfJavaTypeParam() {
    methodWithHandlerAsyncResultSetOfJavaTypeParam(ar -> { });
  }

  public io.reactivex.Single<java.util.Set<java.net.Socket>> rxMethodWithHandlerAsyncResultSetOfJavaTypeParam() { 
    return AsyncResultSingle.toSingle($handler -> {
      methodWithHandlerAsyncResultSetOfJavaTypeParam($handler);
    });
  }

  public void methodWithHandlerAsyncResultMapOfJavaTypeParam(io.vertx.core.Handler<io.vertx.core.AsyncResult<java.util.Map<java.lang.String,java.net.Socket>>> socketMapHandler) { 
    delegate.methodWithHandlerAsyncResultMapOfJavaTypeParam(socketMapHandler);
  }

  public void methodWithHandlerAsyncResultMapOfJavaTypeParam() {
    methodWithHandlerAsyncResultMapOfJavaTypeParam(ar -> { });
  }

  public io.reactivex.Single<java.util.Map<java.lang.String,java.net.Socket>> rxMethodWithHandlerAsyncResultMapOfJavaTypeParam() { 
    return AsyncResultSingle.toSingle($handler -> {
      methodWithHandlerAsyncResultMapOfJavaTypeParam($handler);
    });
  }

  public static AnyJavaTypeTCK newInstance(io.vertx.codegen.testmodel.AnyJavaTypeTCK arg) {
    return arg != null ? new AnyJavaTypeTCK(arg) : null;
  }

}
