/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.codegen.testmodel;

import io.vertx.reactivex.RxHelper;
import io.vertx.reactivex.ObservableHelper;
import io.vertx.reactivex.FlowableHelper;
import io.vertx.reactivex.impl.AsyncResultMaybe;
import io.vertx.reactivex.impl.AsyncResultSingle;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.WriteStreamObserver;
import io.vertx.reactivex.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.codegen.testmodel.CollectionTCK original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.codegen.testmodel.CollectionTCK.class)
public class CollectionTCK {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    CollectionTCK that = (CollectionTCK) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<CollectionTCK> __TYPE_ARG = new TypeArg<>(    obj -> new CollectionTCK((io.vertx.codegen.testmodel.CollectionTCK) obj),
    CollectionTCK::getDelegate
  );

  private final io.vertx.codegen.testmodel.CollectionTCK delegate;
  
  public CollectionTCK(io.vertx.codegen.testmodel.CollectionTCK delegate) {
    this.delegate = delegate;
  }

  public CollectionTCK(Object delegate) {
    this.delegate = (io.vertx.codegen.testmodel.CollectionTCK)delegate;
  }

  public io.vertx.codegen.testmodel.CollectionTCK getDelegate() {
    return delegate;
  }

  private static final TypeArg<io.vertx.reactivex.codegen.testmodel.RefedInterface1> TYPE_ARG_0 = new TypeArg<io.vertx.reactivex.codegen.testmodel.RefedInterface1>(o1 -> io.vertx.reactivex.codegen.testmodel.RefedInterface1.newInstance((io.vertx.codegen.testmodel.RefedInterface1)o1), o1 -> o1.getDelegate());
  private static final TypeArg<io.vertx.reactivex.codegen.testmodel.RefedInterface1> TYPE_ARG_1 = new TypeArg<io.vertx.reactivex.codegen.testmodel.RefedInterface1>(o1 -> io.vertx.reactivex.codegen.testmodel.RefedInterface1.newInstance((io.vertx.codegen.testmodel.RefedInterface1)o1), o1 -> o1.getDelegate());
  private static final TypeArg<io.vertx.reactivex.codegen.testmodel.RefedInterface1> TYPE_ARG_2 = new TypeArg<io.vertx.reactivex.codegen.testmodel.RefedInterface1>(o1 -> io.vertx.reactivex.codegen.testmodel.RefedInterface1.newInstance((io.vertx.codegen.testmodel.RefedInterface1)o1), o1 -> o1.getDelegate());

  public void methodWithListParams(java.util.List<java.lang.String> listString, java.util.List<java.lang.Byte> listByte, java.util.List<java.lang.Short> listShort, java.util.List<java.lang.Integer> listInt, java.util.List<java.lang.Long> listLong, java.util.List<io.vertx.core.json.JsonObject> listJsonObject, java.util.List<io.vertx.core.json.JsonArray> listJsonArray, java.util.List<io.vertx.reactivex.codegen.testmodel.RefedInterface1> listVertxGen, java.util.List<io.vertx.codegen.testmodel.TestDataObject> listDataObject, java.util.List<io.vertx.codegen.testmodel.TestEnum> listEnum, java.util.List<java.lang.Object> listObject) { 
    delegate.methodWithListParams(listString, listByte, listShort, listInt, listLong, listJsonObject, listJsonArray, listVertxGen.stream().map(elt -> elt.getDelegate()).collect(Collectors.toList()), listDataObject, listEnum, listObject);
  }

  public void methodWithSetParams(java.util.Set<java.lang.String> setString, java.util.Set<java.lang.Byte> setByte, java.util.Set<java.lang.Short> setShort, java.util.Set<java.lang.Integer> setInt, java.util.Set<java.lang.Long> setLong, java.util.Set<io.vertx.core.json.JsonObject> setJsonObject, java.util.Set<io.vertx.core.json.JsonArray> setJsonArray, java.util.Set<io.vertx.reactivex.codegen.testmodel.RefedInterface1> setVertxGen, java.util.Set<io.vertx.codegen.testmodel.TestDataObject> setDataObject, java.util.Set<io.vertx.codegen.testmodel.TestEnum> setEnum, java.util.Set<java.lang.Object> setObject) { 
    delegate.methodWithSetParams(setString, setByte, setShort, setInt, setLong, setJsonObject, setJsonArray, setVertxGen.stream().map(elt -> elt.getDelegate()).collect(Collectors.toSet()), setDataObject, setEnum, setObject);
  }

  public void methodWithMapParams(java.util.Map<java.lang.String,java.lang.String> mapString, java.util.Map<java.lang.String,java.lang.Byte> mapByte, java.util.Map<java.lang.String,java.lang.Short> mapShort, java.util.Map<java.lang.String,java.lang.Integer> mapInt, java.util.Map<java.lang.String,java.lang.Long> mapLong, java.util.Map<java.lang.String,io.vertx.core.json.JsonObject> mapJsonObject, java.util.Map<java.lang.String,io.vertx.core.json.JsonArray> mapJsonArray, java.util.Map<java.lang.String,io.vertx.reactivex.codegen.testmodel.RefedInterface1> mapVertxGen, java.util.Map<java.lang.String,io.vertx.codegen.testmodel.TestDataObject> mapDataObject, java.util.Map<java.lang.String,io.vertx.codegen.testmodel.TestEnum> mapEnum, java.util.Map<java.lang.String,java.lang.Object> mapObject) { 
    delegate.methodWithMapParams(mapString, mapByte, mapShort, mapInt, mapLong, mapJsonObject, mapJsonArray, mapVertxGen.entrySet().stream().collect(Collectors.toMap(e -> e.getKey(), e -> e.getValue().getDelegate())), mapDataObject, mapEnum, mapObject);
  }

  public void methodWithHandlerListAndSet(io.vertx.core.Handler<java.util.List<java.lang.String>> listStringHandler, io.vertx.core.Handler<java.util.List<java.lang.Integer>> listIntHandler, io.vertx.core.Handler<java.util.Set<java.lang.String>> setStringHandler, io.vertx.core.Handler<java.util.Set<java.lang.Integer>> setIntHandler) { 
    delegate.methodWithHandlerListAndSet(listStringHandler, listIntHandler, setStringHandler, setIntHandler);
  }

  public void methodWithHandlerAsyncResultListString(io.vertx.core.Handler<io.vertx.core.AsyncResult<java.util.List<java.lang.String>>> handler) { 
    delegate.methodWithHandlerAsyncResultListString(handler);
  }

  public void methodWithHandlerAsyncResultListString() {
    methodWithHandlerAsyncResultListString(ar -> { });
  }

  public io.reactivex.Single<java.util.List<java.lang.String>> rxMethodWithHandlerAsyncResultListString() { 
    return AsyncResultSingle.toSingle($handler -> {
      methodWithHandlerAsyncResultListString($handler);
    });
  }

  public void methodWithHandlerAsyncResultListInteger(io.vertx.core.Handler<io.vertx.core.AsyncResult<java.util.List<java.lang.Integer>>> handler) { 
    delegate.methodWithHandlerAsyncResultListInteger(handler);
  }

  public void methodWithHandlerAsyncResultListInteger() {
    methodWithHandlerAsyncResultListInteger(ar -> { });
  }

  public io.reactivex.Single<java.util.List<java.lang.Integer>> rxMethodWithHandlerAsyncResultListInteger() { 
    return AsyncResultSingle.toSingle($handler -> {
      methodWithHandlerAsyncResultListInteger($handler);
    });
  }

  public void methodWithHandlerListVertxGen(io.vertx.core.Handler<java.util.List<io.vertx.reactivex.codegen.testmodel.RefedInterface1>> listHandler) { 
    delegate.methodWithHandlerListVertxGen(new Handler<java.util.List<io.vertx.codegen.testmodel.RefedInterface1>>() {
      public void handle(java.util.List<io.vertx.codegen.testmodel.RefedInterface1> event) {
        listHandler.handle(event.stream().map(elt -> io.vertx.reactivex.codegen.testmodel.RefedInterface1.newInstance((io.vertx.codegen.testmodel.RefedInterface1)elt)).collect(Collectors.toList()));
      }
    });
  }

  public void methodWithHandlerListAbstractVertxGen(io.vertx.core.Handler<java.util.List<io.vertx.reactivex.codegen.testmodel.RefedInterface2>> listHandler) { 
    delegate.methodWithHandlerListAbstractVertxGen(new Handler<java.util.List<io.vertx.codegen.testmodel.RefedInterface2>>() {
      public void handle(java.util.List<io.vertx.codegen.testmodel.RefedInterface2> event) {
        listHandler.handle(event.stream().map(elt -> io.vertx.reactivex.codegen.testmodel.RefedInterface2.newInstance((io.vertx.codegen.testmodel.RefedInterface2)elt)).collect(Collectors.toList()));
      }
    });
  }

  public void methodWithHandlerListJsonObject(io.vertx.core.Handler<java.util.List<io.vertx.core.json.JsonObject>> listHandler) { 
    delegate.methodWithHandlerListJsonObject(listHandler);
  }

  public void methodWithHandlerListComplexJsonObject(io.vertx.core.Handler<java.util.List<io.vertx.core.json.JsonObject>> listHandler) { 
    delegate.methodWithHandlerListComplexJsonObject(listHandler);
  }

  public void methodWithHandlerListJsonArray(io.vertx.core.Handler<java.util.List<io.vertx.core.json.JsonArray>> listHandler) { 
    delegate.methodWithHandlerListJsonArray(listHandler);
  }

  public void methodWithHandlerListComplexJsonArray(io.vertx.core.Handler<java.util.List<io.vertx.core.json.JsonArray>> listHandler) { 
    delegate.methodWithHandlerListComplexJsonArray(listHandler);
  }

  public void methodWithHandlerListDataObject(io.vertx.core.Handler<java.util.List<io.vertx.codegen.testmodel.TestDataObject>> listHandler) { 
    delegate.methodWithHandlerListDataObject(listHandler);
  }

  public void methodWithHandlerListEnum(io.vertx.core.Handler<java.util.List<io.vertx.codegen.testmodel.TestEnum>> listHandler) { 
    delegate.methodWithHandlerListEnum(listHandler);
  }

  public void methodWithHandlerAsyncResultSetString(io.vertx.core.Handler<io.vertx.core.AsyncResult<java.util.Set<java.lang.String>>> handler) { 
    delegate.methodWithHandlerAsyncResultSetString(handler);
  }

  public void methodWithHandlerAsyncResultSetString() {
    methodWithHandlerAsyncResultSetString(ar -> { });
  }

  public io.reactivex.Single<java.util.Set<java.lang.String>> rxMethodWithHandlerAsyncResultSetString() { 
    return AsyncResultSingle.toSingle($handler -> {
      methodWithHandlerAsyncResultSetString($handler);
    });
  }

  public void methodWithHandlerAsyncResultSetInteger(io.vertx.core.Handler<io.vertx.core.AsyncResult<java.util.Set<java.lang.Integer>>> handler) { 
    delegate.methodWithHandlerAsyncResultSetInteger(handler);
  }

  public void methodWithHandlerAsyncResultSetInteger() {
    methodWithHandlerAsyncResultSetInteger(ar -> { });
  }

  public io.reactivex.Single<java.util.Set<java.lang.Integer>> rxMethodWithHandlerAsyncResultSetInteger() { 
    return AsyncResultSingle.toSingle($handler -> {
      methodWithHandlerAsyncResultSetInteger($handler);
    });
  }

  public void methodWithHandlerSetVertxGen(io.vertx.core.Handler<java.util.Set<io.vertx.reactivex.codegen.testmodel.RefedInterface1>> listHandler) { 
    delegate.methodWithHandlerSetVertxGen(new Handler<java.util.Set<io.vertx.codegen.testmodel.RefedInterface1>>() {
      public void handle(java.util.Set<io.vertx.codegen.testmodel.RefedInterface1> event) {
        listHandler.handle(event.stream().map(elt -> io.vertx.reactivex.codegen.testmodel.RefedInterface1.newInstance((io.vertx.codegen.testmodel.RefedInterface1)elt)).collect(Collectors.toSet()));
      }
    });
  }

  public void methodWithHandlerSetAbstractVertxGen(io.vertx.core.Handler<java.util.Set<io.vertx.reactivex.codegen.testmodel.RefedInterface2>> listHandler) { 
    delegate.methodWithHandlerSetAbstractVertxGen(new Handler<java.util.Set<io.vertx.codegen.testmodel.RefedInterface2>>() {
      public void handle(java.util.Set<io.vertx.codegen.testmodel.RefedInterface2> event) {
        listHandler.handle(event.stream().map(elt -> io.vertx.reactivex.codegen.testmodel.RefedInterface2.newInstance((io.vertx.codegen.testmodel.RefedInterface2)elt)).collect(Collectors.toSet()));
      }
    });
  }

  public void methodWithHandlerSetJsonObject(io.vertx.core.Handler<java.util.Set<io.vertx.core.json.JsonObject>> listHandler) { 
    delegate.methodWithHandlerSetJsonObject(listHandler);
  }

  public void methodWithHandlerSetComplexJsonObject(io.vertx.core.Handler<java.util.Set<io.vertx.core.json.JsonObject>> listHandler) { 
    delegate.methodWithHandlerSetComplexJsonObject(listHandler);
  }

  public void methodWithHandlerSetJsonArray(io.vertx.core.Handler<java.util.Set<io.vertx.core.json.JsonArray>> listHandler) { 
    delegate.methodWithHandlerSetJsonArray(listHandler);
  }

  public void methodWithHandlerSetComplexJsonArray(io.vertx.core.Handler<java.util.Set<io.vertx.core.json.JsonArray>> setHandler) { 
    delegate.methodWithHandlerSetComplexJsonArray(setHandler);
  }

  public void methodWithHandlerSetDataObject(io.vertx.core.Handler<java.util.Set<io.vertx.codegen.testmodel.TestDataObject>> setHandler) { 
    delegate.methodWithHandlerSetDataObject(setHandler);
  }

  public void methodWithHandlerSetEnum(io.vertx.core.Handler<java.util.Set<io.vertx.codegen.testmodel.TestEnum>> setHandler) { 
    delegate.methodWithHandlerSetEnum(setHandler);
  }

  public void methodWithHandlerAsyncResultListVertxGen(io.vertx.core.Handler<io.vertx.core.AsyncResult<java.util.List<io.vertx.reactivex.codegen.testmodel.RefedInterface1>>> listHandler) { 
    delegate.methodWithHandlerAsyncResultListVertxGen(new Handler<AsyncResult<java.util.List<io.vertx.codegen.testmodel.RefedInterface1>>>() {
      public void handle(AsyncResult<java.util.List<io.vertx.codegen.testmodel.RefedInterface1>> ar) {
        if (ar.succeeded()) {
          listHandler.handle(io.vertx.core.Future.succeededFuture(ar.result().stream().map(elt -> io.vertx.reactivex.codegen.testmodel.RefedInterface1.newInstance((io.vertx.codegen.testmodel.RefedInterface1)elt)).collect(Collectors.toList())));
        } else {
          listHandler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
  }

  public void methodWithHandlerAsyncResultListVertxGen() {
    methodWithHandlerAsyncResultListVertxGen(ar -> { });
  }

  public io.reactivex.Single<java.util.List<io.vertx.reactivex.codegen.testmodel.RefedInterface1>> rxMethodWithHandlerAsyncResultListVertxGen() { 
    return AsyncResultSingle.toSingle($handler -> {
      methodWithHandlerAsyncResultListVertxGen($handler);
    });
  }

  public void methodWithHandlerAsyncResultListAbstractVertxGen(io.vertx.core.Handler<io.vertx.core.AsyncResult<java.util.List<io.vertx.reactivex.codegen.testmodel.RefedInterface2>>> listHandler) { 
    delegate.methodWithHandlerAsyncResultListAbstractVertxGen(new Handler<AsyncResult<java.util.List<io.vertx.codegen.testmodel.RefedInterface2>>>() {
      public void handle(AsyncResult<java.util.List<io.vertx.codegen.testmodel.RefedInterface2>> ar) {
        if (ar.succeeded()) {
          listHandler.handle(io.vertx.core.Future.succeededFuture(ar.result().stream().map(elt -> io.vertx.reactivex.codegen.testmodel.RefedInterface2.newInstance((io.vertx.codegen.testmodel.RefedInterface2)elt)).collect(Collectors.toList())));
        } else {
          listHandler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
  }

  public void methodWithHandlerAsyncResultListAbstractVertxGen() {
    methodWithHandlerAsyncResultListAbstractVertxGen(ar -> { });
  }

  public io.reactivex.Single<java.util.List<io.vertx.reactivex.codegen.testmodel.RefedInterface2>> rxMethodWithHandlerAsyncResultListAbstractVertxGen() { 
    return AsyncResultSingle.toSingle($handler -> {
      methodWithHandlerAsyncResultListAbstractVertxGen($handler);
    });
  }

  public void methodWithHandlerAsyncResultListJsonObject(io.vertx.core.Handler<io.vertx.core.AsyncResult<java.util.List<io.vertx.core.json.JsonObject>>> listHandler) { 
    delegate.methodWithHandlerAsyncResultListJsonObject(listHandler);
  }

  public void methodWithHandlerAsyncResultListJsonObject() {
    methodWithHandlerAsyncResultListJsonObject(ar -> { });
  }

  public io.reactivex.Single<java.util.List<io.vertx.core.json.JsonObject>> rxMethodWithHandlerAsyncResultListJsonObject() { 
    return AsyncResultSingle.toSingle($handler -> {
      methodWithHandlerAsyncResultListJsonObject($handler);
    });
  }

  public void methodWithHandlerAsyncResultListComplexJsonObject(io.vertx.core.Handler<io.vertx.core.AsyncResult<java.util.List<io.vertx.core.json.JsonObject>>> listHandler) { 
    delegate.methodWithHandlerAsyncResultListComplexJsonObject(listHandler);
  }

  public void methodWithHandlerAsyncResultListComplexJsonObject() {
    methodWithHandlerAsyncResultListComplexJsonObject(ar -> { });
  }

  public io.reactivex.Single<java.util.List<io.vertx.core.json.JsonObject>> rxMethodWithHandlerAsyncResultListComplexJsonObject() { 
    return AsyncResultSingle.toSingle($handler -> {
      methodWithHandlerAsyncResultListComplexJsonObject($handler);
    });
  }

  public void methodWithHandlerAsyncResultListJsonArray(io.vertx.core.Handler<io.vertx.core.AsyncResult<java.util.List<io.vertx.core.json.JsonArray>>> listHandler) { 
    delegate.methodWithHandlerAsyncResultListJsonArray(listHandler);
  }

  public void methodWithHandlerAsyncResultListJsonArray() {
    methodWithHandlerAsyncResultListJsonArray(ar -> { });
  }

  public io.reactivex.Single<java.util.List<io.vertx.core.json.JsonArray>> rxMethodWithHandlerAsyncResultListJsonArray() { 
    return AsyncResultSingle.toSingle($handler -> {
      methodWithHandlerAsyncResultListJsonArray($handler);
    });
  }

  public void methodWithHandlerAsyncResultListComplexJsonArray(io.vertx.core.Handler<io.vertx.core.AsyncResult<java.util.List<io.vertx.core.json.JsonArray>>> listHandler) { 
    delegate.methodWithHandlerAsyncResultListComplexJsonArray(listHandler);
  }

  public void methodWithHandlerAsyncResultListComplexJsonArray() {
    methodWithHandlerAsyncResultListComplexJsonArray(ar -> { });
  }

  public io.reactivex.Single<java.util.List<io.vertx.core.json.JsonArray>> rxMethodWithHandlerAsyncResultListComplexJsonArray() { 
    return AsyncResultSingle.toSingle($handler -> {
      methodWithHandlerAsyncResultListComplexJsonArray($handler);
    });
  }

  public void methodWithHandlerAsyncResultListDataObject(io.vertx.core.Handler<io.vertx.core.AsyncResult<java.util.List<io.vertx.codegen.testmodel.TestDataObject>>> listHandler) { 
    delegate.methodWithHandlerAsyncResultListDataObject(listHandler);
  }

  public void methodWithHandlerAsyncResultListDataObject() {
    methodWithHandlerAsyncResultListDataObject(ar -> { });
  }

  public io.reactivex.Single<java.util.List<io.vertx.codegen.testmodel.TestDataObject>> rxMethodWithHandlerAsyncResultListDataObject() { 
    return AsyncResultSingle.toSingle($handler -> {
      methodWithHandlerAsyncResultListDataObject($handler);
    });
  }

  public void methodWithHandlerAsyncResultListEnum(io.vertx.core.Handler<io.vertx.core.AsyncResult<java.util.List<io.vertx.codegen.testmodel.TestEnum>>> listHandler) { 
    delegate.methodWithHandlerAsyncResultListEnum(listHandler);
  }

  public void methodWithHandlerAsyncResultListEnum() {
    methodWithHandlerAsyncResultListEnum(ar -> { });
  }

  public io.reactivex.Single<java.util.List<io.vertx.codegen.testmodel.TestEnum>> rxMethodWithHandlerAsyncResultListEnum() { 
    return AsyncResultSingle.toSingle($handler -> {
      methodWithHandlerAsyncResultListEnum($handler);
    });
  }

  public void methodWithHandlerAsyncResultSetVertxGen(io.vertx.core.Handler<io.vertx.core.AsyncResult<java.util.Set<io.vertx.reactivex.codegen.testmodel.RefedInterface1>>> listHandler) { 
    delegate.methodWithHandlerAsyncResultSetVertxGen(new Handler<AsyncResult<java.util.Set<io.vertx.codegen.testmodel.RefedInterface1>>>() {
      public void handle(AsyncResult<java.util.Set<io.vertx.codegen.testmodel.RefedInterface1>> ar) {
        if (ar.succeeded()) {
          listHandler.handle(io.vertx.core.Future.succeededFuture(ar.result().stream().map(elt -> io.vertx.reactivex.codegen.testmodel.RefedInterface1.newInstance((io.vertx.codegen.testmodel.RefedInterface1)elt)).collect(Collectors.toSet())));
        } else {
          listHandler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
  }

  public void methodWithHandlerAsyncResultSetVertxGen() {
    methodWithHandlerAsyncResultSetVertxGen(ar -> { });
  }

  public io.reactivex.Single<java.util.Set<io.vertx.reactivex.codegen.testmodel.RefedInterface1>> rxMethodWithHandlerAsyncResultSetVertxGen() { 
    return AsyncResultSingle.toSingle($handler -> {
      methodWithHandlerAsyncResultSetVertxGen($handler);
    });
  }

  public void methodWithHandlerAsyncResultSetAbstractVertxGen(io.vertx.core.Handler<io.vertx.core.AsyncResult<java.util.Set<io.vertx.reactivex.codegen.testmodel.RefedInterface2>>> listHandler) { 
    delegate.methodWithHandlerAsyncResultSetAbstractVertxGen(new Handler<AsyncResult<java.util.Set<io.vertx.codegen.testmodel.RefedInterface2>>>() {
      public void handle(AsyncResult<java.util.Set<io.vertx.codegen.testmodel.RefedInterface2>> ar) {
        if (ar.succeeded()) {
          listHandler.handle(io.vertx.core.Future.succeededFuture(ar.result().stream().map(elt -> io.vertx.reactivex.codegen.testmodel.RefedInterface2.newInstance((io.vertx.codegen.testmodel.RefedInterface2)elt)).collect(Collectors.toSet())));
        } else {
          listHandler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
  }

  public void methodWithHandlerAsyncResultSetAbstractVertxGen() {
    methodWithHandlerAsyncResultSetAbstractVertxGen(ar -> { });
  }

  public io.reactivex.Single<java.util.Set<io.vertx.reactivex.codegen.testmodel.RefedInterface2>> rxMethodWithHandlerAsyncResultSetAbstractVertxGen() { 
    return AsyncResultSingle.toSingle($handler -> {
      methodWithHandlerAsyncResultSetAbstractVertxGen($handler);
    });
  }

  public void methodWithHandlerAsyncResultSetJsonObject(io.vertx.core.Handler<io.vertx.core.AsyncResult<java.util.Set<io.vertx.core.json.JsonObject>>> listHandler) { 
    delegate.methodWithHandlerAsyncResultSetJsonObject(listHandler);
  }

  public void methodWithHandlerAsyncResultSetJsonObject() {
    methodWithHandlerAsyncResultSetJsonObject(ar -> { });
  }

  public io.reactivex.Single<java.util.Set<io.vertx.core.json.JsonObject>> rxMethodWithHandlerAsyncResultSetJsonObject() { 
    return AsyncResultSingle.toSingle($handler -> {
      methodWithHandlerAsyncResultSetJsonObject($handler);
    });
  }

  public void methodWithHandlerAsyncResultSetComplexJsonObject(io.vertx.core.Handler<io.vertx.core.AsyncResult<java.util.Set<io.vertx.core.json.JsonObject>>> listHandler) { 
    delegate.methodWithHandlerAsyncResultSetComplexJsonObject(listHandler);
  }

  public void methodWithHandlerAsyncResultSetComplexJsonObject() {
    methodWithHandlerAsyncResultSetComplexJsonObject(ar -> { });
  }

  public io.reactivex.Single<java.util.Set<io.vertx.core.json.JsonObject>> rxMethodWithHandlerAsyncResultSetComplexJsonObject() { 
    return AsyncResultSingle.toSingle($handler -> {
      methodWithHandlerAsyncResultSetComplexJsonObject($handler);
    });
  }

  public void methodWithHandlerAsyncResultSetJsonArray(io.vertx.core.Handler<io.vertx.core.AsyncResult<java.util.Set<io.vertx.core.json.JsonArray>>> listHandler) { 
    delegate.methodWithHandlerAsyncResultSetJsonArray(listHandler);
  }

  public void methodWithHandlerAsyncResultSetJsonArray() {
    methodWithHandlerAsyncResultSetJsonArray(ar -> { });
  }

  public io.reactivex.Single<java.util.Set<io.vertx.core.json.JsonArray>> rxMethodWithHandlerAsyncResultSetJsonArray() { 
    return AsyncResultSingle.toSingle($handler -> {
      methodWithHandlerAsyncResultSetJsonArray($handler);
    });
  }

  public void methodWithHandlerAsyncResultSetComplexJsonArray(io.vertx.core.Handler<io.vertx.core.AsyncResult<java.util.Set<io.vertx.core.json.JsonArray>>> listHandler) { 
    delegate.methodWithHandlerAsyncResultSetComplexJsonArray(listHandler);
  }

  public void methodWithHandlerAsyncResultSetComplexJsonArray() {
    methodWithHandlerAsyncResultSetComplexJsonArray(ar -> { });
  }

  public io.reactivex.Single<java.util.Set<io.vertx.core.json.JsonArray>> rxMethodWithHandlerAsyncResultSetComplexJsonArray() { 
    return AsyncResultSingle.toSingle($handler -> {
      methodWithHandlerAsyncResultSetComplexJsonArray($handler);
    });
  }

  public void methodWithHandlerAsyncResultSetDataObject(io.vertx.core.Handler<io.vertx.core.AsyncResult<java.util.Set<io.vertx.codegen.testmodel.TestDataObject>>> setHandler) { 
    delegate.methodWithHandlerAsyncResultSetDataObject(setHandler);
  }

  public void methodWithHandlerAsyncResultSetDataObject() {
    methodWithHandlerAsyncResultSetDataObject(ar -> { });
  }

  public io.reactivex.Single<java.util.Set<io.vertx.codegen.testmodel.TestDataObject>> rxMethodWithHandlerAsyncResultSetDataObject() { 
    return AsyncResultSingle.toSingle($handler -> {
      methodWithHandlerAsyncResultSetDataObject($handler);
    });
  }

  public void methodWithHandlerAsyncResultSetEnum(io.vertx.core.Handler<io.vertx.core.AsyncResult<java.util.Set<io.vertx.codegen.testmodel.TestEnum>>> setHandler) { 
    delegate.methodWithHandlerAsyncResultSetEnum(setHandler);
  }

  public void methodWithHandlerAsyncResultSetEnum() {
    methodWithHandlerAsyncResultSetEnum(ar -> { });
  }

  public io.reactivex.Single<java.util.Set<io.vertx.codegen.testmodel.TestEnum>> rxMethodWithHandlerAsyncResultSetEnum() { 
    return AsyncResultSingle.toSingle($handler -> {
      methodWithHandlerAsyncResultSetEnum($handler);
    });
  }

  public java.util.Map<java.lang.String,java.lang.String> methodWithMapStringReturn(io.vertx.core.Handler<java.lang.String> handler) { 
    java.util.Map<java.lang.String,java.lang.String> ret = delegate.methodWithMapStringReturn(handler);
    return ret;
  }

  public java.util.Map<java.lang.String,java.lang.Long> methodWithMapLongReturn(io.vertx.core.Handler<java.lang.String> handler) { 
    java.util.Map<java.lang.String,java.lang.Long> ret = delegate.methodWithMapLongReturn(handler);
    return ret;
  }

  public java.util.Map<java.lang.String,java.lang.Integer> methodWithMapIntegerReturn(io.vertx.core.Handler<java.lang.String> handler) { 
    java.util.Map<java.lang.String,java.lang.Integer> ret = delegate.methodWithMapIntegerReturn(handler);
    return ret;
  }

  public java.util.Map<java.lang.String,java.lang.Short> methodWithMapShortReturn(io.vertx.core.Handler<java.lang.String> handler) { 
    java.util.Map<java.lang.String,java.lang.Short> ret = delegate.methodWithMapShortReturn(handler);
    return ret;
  }

  public java.util.Map<java.lang.String,java.lang.Byte> methodWithMapByteReturn(io.vertx.core.Handler<java.lang.String> handler) { 
    java.util.Map<java.lang.String,java.lang.Byte> ret = delegate.methodWithMapByteReturn(handler);
    return ret;
  }

  public java.util.Map<java.lang.String,java.lang.Character> methodWithMapCharacterReturn(io.vertx.core.Handler<java.lang.String> handler) { 
    java.util.Map<java.lang.String,java.lang.Character> ret = delegate.methodWithMapCharacterReturn(handler);
    return ret;
  }

  public java.util.Map<java.lang.String,java.lang.Boolean> methodWithMapBooleanReturn(io.vertx.core.Handler<java.lang.String> handler) { 
    java.util.Map<java.lang.String,java.lang.Boolean> ret = delegate.methodWithMapBooleanReturn(handler);
    return ret;
  }

  public java.util.Map<java.lang.String,java.lang.Float> methodWithMapFloatReturn(io.vertx.core.Handler<java.lang.String> handler) { 
    java.util.Map<java.lang.String,java.lang.Float> ret = delegate.methodWithMapFloatReturn(handler);
    return ret;
  }

  public java.util.Map<java.lang.String,java.lang.Double> methodWithMapDoubleReturn(io.vertx.core.Handler<java.lang.String> handler) { 
    java.util.Map<java.lang.String,java.lang.Double> ret = delegate.methodWithMapDoubleReturn(handler);
    return ret;
  }

  public java.util.Map<java.lang.String,io.vertx.reactivex.codegen.testmodel.RefedInterface1> methodWithMapVertxGenReturn(io.vertx.core.Handler<java.lang.String> handler) { 
    java.util.Map<java.lang.String,io.vertx.reactivex.codegen.testmodel.RefedInterface1> ret = delegate.methodWithMapVertxGenReturn(handler).entrySet().stream().collect(Collectors.toMap(_e -> _e.getKey(), _e -> io.vertx.reactivex.codegen.testmodel.RefedInterface1.newInstance((io.vertx.codegen.testmodel.RefedInterface1)_e.getValue())));
    return ret;
  }

  public java.util.Map<java.lang.String,io.vertx.codegen.testmodel.TestDataObject> methodWithMapDataObjectReturn(io.vertx.core.Handler<java.lang.String> handler) { 
    java.util.Map<java.lang.String,io.vertx.codegen.testmodel.TestDataObject> ret = delegate.methodWithMapDataObjectReturn(handler);
    return ret;
  }

  public java.util.Map<java.lang.String,io.vertx.codegen.testmodel.TestEnum> methodWithMapEnumReturn(io.vertx.core.Handler<java.lang.String> handler) { 
    java.util.Map<java.lang.String,io.vertx.codegen.testmodel.TestEnum> ret = delegate.methodWithMapEnumReturn(handler);
    return ret;
  }

  public java.util.Map<java.lang.String,io.vertx.core.json.JsonObject> methodWithMapJsonObjectReturn(io.vertx.core.Handler<java.lang.String> handler) { 
    java.util.Map<java.lang.String,io.vertx.core.json.JsonObject> ret = delegate.methodWithMapJsonObjectReturn(handler);
    return ret;
  }

  public java.util.Map<java.lang.String,io.vertx.core.json.JsonObject> methodWithMapComplexJsonObjectReturn(io.vertx.core.Handler<java.lang.String> handler) { 
    java.util.Map<java.lang.String,io.vertx.core.json.JsonObject> ret = delegate.methodWithMapComplexJsonObjectReturn(handler);
    return ret;
  }

  public java.util.Map<java.lang.String,io.vertx.core.json.JsonArray> methodWithMapJsonArrayReturn(io.vertx.core.Handler<java.lang.String> handler) { 
    java.util.Map<java.lang.String,io.vertx.core.json.JsonArray> ret = delegate.methodWithMapJsonArrayReturn(handler);
    return ret;
  }

  public java.util.Map<java.lang.String,io.vertx.core.json.JsonArray> methodWithMapComplexJsonArrayReturn(io.vertx.core.Handler<java.lang.String> handler) { 
    java.util.Map<java.lang.String,io.vertx.core.json.JsonArray> ret = delegate.methodWithMapComplexJsonArrayReturn(handler);
    return ret;
  }

  public java.util.Map<java.lang.String,java.lang.Object> methodWithMapObjectReturn(io.vertx.core.Handler<java.lang.String> handler) { 
    java.util.Map<java.lang.String,java.lang.Object> ret = delegate.methodWithMapObjectReturn(handler);
    return ret;
  }

  public java.util.List<java.lang.String> methodWithListStringReturn() { 
    java.util.List<java.lang.String> ret = delegate.methodWithListStringReturn();
    return ret;
  }

  public java.util.List<java.lang.Long> methodWithListLongReturn() { 
    java.util.List<java.lang.Long> ret = delegate.methodWithListLongReturn();
    return ret;
  }

  public java.util.List<io.vertx.reactivex.codegen.testmodel.RefedInterface1> methodWithListVertxGenReturn() { 
    java.util.List<io.vertx.reactivex.codegen.testmodel.RefedInterface1> ret = delegate.methodWithListVertxGenReturn().stream().map(elt -> io.vertx.reactivex.codegen.testmodel.RefedInterface1.newInstance((io.vertx.codegen.testmodel.RefedInterface1)elt)).collect(Collectors.toList());
    return ret;
  }

  public java.util.List<io.vertx.core.json.JsonObject> methodWithListJsonObjectReturn() { 
    java.util.List<io.vertx.core.json.JsonObject> ret = delegate.methodWithListJsonObjectReturn();
    return ret;
  }

  public java.util.List<io.vertx.core.json.JsonObject> methodWithListComplexJsonObjectReturn() { 
    java.util.List<io.vertx.core.json.JsonObject> ret = delegate.methodWithListComplexJsonObjectReturn();
    return ret;
  }

  public java.util.List<io.vertx.core.json.JsonArray> methodWithListJsonArrayReturn() { 
    java.util.List<io.vertx.core.json.JsonArray> ret = delegate.methodWithListJsonArrayReturn();
    return ret;
  }

  public java.util.List<io.vertx.core.json.JsonArray> methodWithListComplexJsonArrayReturn() { 
    java.util.List<io.vertx.core.json.JsonArray> ret = delegate.methodWithListComplexJsonArrayReturn();
    return ret;
  }

  public java.util.List<io.vertx.codegen.testmodel.TestDataObject> methodWithListDataObjectReturn() { 
    java.util.List<io.vertx.codegen.testmodel.TestDataObject> ret = delegate.methodWithListDataObjectReturn();
    return ret;
  }

  public java.util.List<io.vertx.codegen.testmodel.TestEnum> methodWithListEnumReturn() { 
    java.util.List<io.vertx.codegen.testmodel.TestEnum> ret = delegate.methodWithListEnumReturn();
    return ret;
  }

  public java.util.List<java.lang.Object> methodWithListObjectReturn() { 
    java.util.List<java.lang.Object> ret = delegate.methodWithListObjectReturn();
    return ret;
  }

  public java.util.Set<java.lang.String> methodWithSetStringReturn() { 
    java.util.Set<java.lang.String> ret = delegate.methodWithSetStringReturn();
    return ret;
  }

  public java.util.Set<java.lang.Long> methodWithSetLongReturn() { 
    java.util.Set<java.lang.Long> ret = delegate.methodWithSetLongReturn();
    return ret;
  }

  public java.util.Set<io.vertx.reactivex.codegen.testmodel.RefedInterface1> methodWithSetVertxGenReturn() { 
    java.util.Set<io.vertx.reactivex.codegen.testmodel.RefedInterface1> ret = delegate.methodWithSetVertxGenReturn().stream().map(elt -> io.vertx.reactivex.codegen.testmodel.RefedInterface1.newInstance((io.vertx.codegen.testmodel.RefedInterface1)elt)).collect(Collectors.toSet());
    return ret;
  }

  public java.util.Set<io.vertx.core.json.JsonObject> methodWithSetJsonObjectReturn() { 
    java.util.Set<io.vertx.core.json.JsonObject> ret = delegate.methodWithSetJsonObjectReturn();
    return ret;
  }

  public java.util.Set<io.vertx.core.json.JsonObject> methodWithSetComplexJsonObjectReturn() { 
    java.util.Set<io.vertx.core.json.JsonObject> ret = delegate.methodWithSetComplexJsonObjectReturn();
    return ret;
  }

  public java.util.Set<io.vertx.core.json.JsonArray> methodWithSetJsonArrayReturn() { 
    java.util.Set<io.vertx.core.json.JsonArray> ret = delegate.methodWithSetJsonArrayReturn();
    return ret;
  }

  public java.util.Set<io.vertx.core.json.JsonArray> methodWithSetComplexJsonArrayReturn() { 
    java.util.Set<io.vertx.core.json.JsonArray> ret = delegate.methodWithSetComplexJsonArrayReturn();
    return ret;
  }

  public java.util.Set<io.vertx.codegen.testmodel.TestDataObject> methodWithSetDataObjectReturn() { 
    java.util.Set<io.vertx.codegen.testmodel.TestDataObject> ret = delegate.methodWithSetDataObjectReturn();
    return ret;
  }

  public java.util.Set<io.vertx.codegen.testmodel.TestEnum> methodWithSetEnumReturn() { 
    java.util.Set<io.vertx.codegen.testmodel.TestEnum> ret = delegate.methodWithSetEnumReturn();
    return ret;
  }

  public java.util.Set<java.lang.Object> methodWithSetObjectReturn() { 
    java.util.Set<java.lang.Object> ret = delegate.methodWithSetObjectReturn();
    return ret;
  }

  public static CollectionTCK newInstance(io.vertx.codegen.testmodel.CollectionTCK arg) {
    return arg != null ? new CollectionTCK(arg) : null;
  }

}
