/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.codegen.testmodel;

import io.vertx.reactivex.RxHelper;
import io.vertx.reactivex.ObservableHelper;
import io.vertx.reactivex.FlowableHelper;
import io.vertx.reactivex.impl.AsyncResultMaybe;
import io.vertx.reactivex.impl.AsyncResultSingle;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.WriteStreamObserver;
import io.vertx.reactivex.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;


@RxGen(io.vertx.codegen.testmodel.ConstantTCK.class)
public class ConstantTCK {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ConstantTCK that = (ConstantTCK) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<ConstantTCK> __TYPE_ARG = new TypeArg<>(    obj -> new ConstantTCK((io.vertx.codegen.testmodel.ConstantTCK) obj),
    ConstantTCK::getDelegate
  );

  private final io.vertx.codegen.testmodel.ConstantTCK delegate;
  
  public ConstantTCK(io.vertx.codegen.testmodel.ConstantTCK delegate) {
    this.delegate = delegate;
  }

  public ConstantTCK(Object delegate) {
    this.delegate = (io.vertx.codegen.testmodel.ConstantTCK)delegate;
  }

  public io.vertx.codegen.testmodel.ConstantTCK getDelegate() {
    return delegate;
  }

  /**
   * Some doc.
   */
  public static final byte BYTE = io.vertx.codegen.testmodel.ConstantTCK.BYTE;
  public static final java.lang.Byte BOXED_BYTE = io.vertx.codegen.testmodel.ConstantTCK.BOXED_BYTE;
  public static final short SHORT = io.vertx.codegen.testmodel.ConstantTCK.SHORT;
  public static final java.lang.Short BOXED_SHORT = io.vertx.codegen.testmodel.ConstantTCK.BOXED_SHORT;
  public static final int INT = io.vertx.codegen.testmodel.ConstantTCK.INT;
  public static final java.lang.Integer BOXED_INT = io.vertx.codegen.testmodel.ConstantTCK.BOXED_INT;
  public static final long LONG = io.vertx.codegen.testmodel.ConstantTCK.LONG;
  public static final java.lang.Long BOXED_LONG = io.vertx.codegen.testmodel.ConstantTCK.BOXED_LONG;
  public static final float FLOAT = io.vertx.codegen.testmodel.ConstantTCK.FLOAT;
  public static final java.lang.Float BOXED_FLOAT = io.vertx.codegen.testmodel.ConstantTCK.BOXED_FLOAT;
  public static final double DOUBLE = io.vertx.codegen.testmodel.ConstantTCK.DOUBLE;
  public static final java.lang.Double BOXED_DOUBLE = io.vertx.codegen.testmodel.ConstantTCK.BOXED_DOUBLE;
  public static final boolean BOOLEAN = io.vertx.codegen.testmodel.ConstantTCK.BOOLEAN;
  public static final java.lang.Boolean BOXED_BOOLEAN = io.vertx.codegen.testmodel.ConstantTCK.BOXED_BOOLEAN;
  public static final char CHAR = io.vertx.codegen.testmodel.ConstantTCK.CHAR;
  public static final java.lang.Character BOXED_CHAR = io.vertx.codegen.testmodel.ConstantTCK.BOXED_CHAR;
  public static final java.lang.String STRING = io.vertx.codegen.testmodel.ConstantTCK.STRING;
  public static final io.vertx.reactivex.codegen.testmodel.RefedInterface1 VERTX_GEN = io.vertx.reactivex.codegen.testmodel.RefedInterface1.newInstance((io.vertx.codegen.testmodel.RefedInterface1)io.vertx.codegen.testmodel.ConstantTCK.VERTX_GEN);
  public static final io.vertx.codegen.testmodel.TestDataObject DATA_OBJECT = io.vertx.codegen.testmodel.ConstantTCK.DATA_OBJECT;
  public static final io.vertx.core.json.JsonObject JSON_OBJECT = io.vertx.codegen.testmodel.ConstantTCK.JSON_OBJECT;
  public static final io.vertx.core.json.JsonArray JSON_ARRAY = io.vertx.codegen.testmodel.ConstantTCK.JSON_ARRAY;
  public static final io.vertx.codegen.testmodel.TestEnum ENUM = io.vertx.codegen.testmodel.ConstantTCK.ENUM;
  public static final java.lang.Throwable THROWABLE = io.vertx.codegen.testmodel.ConstantTCK.THROWABLE;
  public static final java.lang.Object OBJECT = (Object) io.vertx.codegen.testmodel.ConstantTCK.OBJECT;
  public static final io.vertx.reactivex.codegen.testmodel.RefedInterface1 NULLABLE_NON_NULL = io.vertx.reactivex.codegen.testmodel.RefedInterface1.newInstance((io.vertx.codegen.testmodel.RefedInterface1)io.vertx.codegen.testmodel.ConstantTCK.NULLABLE_NON_NULL);
  public static final io.vertx.reactivex.codegen.testmodel.RefedInterface1 NULLABLE_NULL = io.vertx.reactivex.codegen.testmodel.RefedInterface1.newInstance((io.vertx.codegen.testmodel.RefedInterface1)io.vertx.codegen.testmodel.ConstantTCK.NULLABLE_NULL);
  public static final java.util.List<java.lang.Byte> BYTE_LIST = io.vertx.codegen.testmodel.ConstantTCK.BYTE_LIST;
  public static final java.util.List<java.lang.Short> SHORT_LIST = io.vertx.codegen.testmodel.ConstantTCK.SHORT_LIST;
  public static final java.util.List<java.lang.Integer> INT_LIST = io.vertx.codegen.testmodel.ConstantTCK.INT_LIST;
  public static final java.util.List<java.lang.Long> LONG_LIST = io.vertx.codegen.testmodel.ConstantTCK.LONG_LIST;
  public static final java.util.List<java.lang.Float> FLOAT_LIST = io.vertx.codegen.testmodel.ConstantTCK.FLOAT_LIST;
  public static final java.util.List<java.lang.Double> DOUBLE_LIST = io.vertx.codegen.testmodel.ConstantTCK.DOUBLE_LIST;
  public static final java.util.List<java.lang.Boolean> BOOLEAN_LIST = io.vertx.codegen.testmodel.ConstantTCK.BOOLEAN_LIST;
  public static final java.util.List<java.lang.Character> CHAR_LIST = io.vertx.codegen.testmodel.ConstantTCK.CHAR_LIST;
  public static final java.util.List<java.lang.String> STRING_LIST = io.vertx.codegen.testmodel.ConstantTCK.STRING_LIST;
  public static final java.util.List<io.vertx.reactivex.codegen.testmodel.RefedInterface1> VERTX_GEN_LIST = io.vertx.codegen.testmodel.ConstantTCK.VERTX_GEN_LIST.stream().map(elt -> io.vertx.reactivex.codegen.testmodel.RefedInterface1.newInstance((io.vertx.codegen.testmodel.RefedInterface1)elt)).collect(Collectors.toList());
  public static final java.util.List<io.vertx.core.json.JsonObject> JSON_OBJECT_LIST = io.vertx.codegen.testmodel.ConstantTCK.JSON_OBJECT_LIST;
  public static final java.util.List<io.vertx.core.json.JsonArray> JSON_ARRAY_LIST = io.vertx.codegen.testmodel.ConstantTCK.JSON_ARRAY_LIST;
  public static final java.util.List<io.vertx.codegen.testmodel.TestDataObject> DATA_OBJECT_LIST = io.vertx.codegen.testmodel.ConstantTCK.DATA_OBJECT_LIST;
  public static final java.util.List<io.vertx.codegen.testmodel.TestEnum> ENUM_LIST = io.vertx.codegen.testmodel.ConstantTCK.ENUM_LIST;
  public static final java.util.Set<java.lang.Byte> BYTE_SET = io.vertx.codegen.testmodel.ConstantTCK.BYTE_SET;
  public static final java.util.Set<java.lang.Short> SHORT_SET = io.vertx.codegen.testmodel.ConstantTCK.SHORT_SET;
  public static final java.util.Set<java.lang.Integer> INT_SET = io.vertx.codegen.testmodel.ConstantTCK.INT_SET;
  public static final java.util.Set<java.lang.Long> LONG_SET = io.vertx.codegen.testmodel.ConstantTCK.LONG_SET;
  public static final java.util.Set<java.lang.Float> FLOAT_SET = io.vertx.codegen.testmodel.ConstantTCK.FLOAT_SET;
  public static final java.util.Set<java.lang.Double> DOUBLE_SET = io.vertx.codegen.testmodel.ConstantTCK.DOUBLE_SET;
  public static final java.util.Set<java.lang.Boolean> BOOLEAN_SET = io.vertx.codegen.testmodel.ConstantTCK.BOOLEAN_SET;
  public static final java.util.Set<java.lang.Character> CHAR_SET = io.vertx.codegen.testmodel.ConstantTCK.CHAR_SET;
  public static final java.util.Set<java.lang.String> STRING_SET = io.vertx.codegen.testmodel.ConstantTCK.STRING_SET;
  public static final java.util.Set<io.vertx.reactivex.codegen.testmodel.RefedInterface1> VERTX_GEN_SET = io.vertx.codegen.testmodel.ConstantTCK.VERTX_GEN_SET.stream().map(elt -> io.vertx.reactivex.codegen.testmodel.RefedInterface1.newInstance((io.vertx.codegen.testmodel.RefedInterface1)elt)).collect(Collectors.toSet());
  public static final java.util.Set<io.vertx.core.json.JsonObject> JSON_OBJECT_SET = io.vertx.codegen.testmodel.ConstantTCK.JSON_OBJECT_SET;
  public static final java.util.Set<io.vertx.core.json.JsonArray> JSON_ARRAY_SET = io.vertx.codegen.testmodel.ConstantTCK.JSON_ARRAY_SET;
  public static final java.util.Set<io.vertx.codegen.testmodel.TestDataObject> DATA_OBJECT_SET = io.vertx.codegen.testmodel.ConstantTCK.DATA_OBJECT_SET;
  public static final java.util.Set<io.vertx.codegen.testmodel.TestEnum> ENUM_SET = io.vertx.codegen.testmodel.ConstantTCK.ENUM_SET;
  public static final java.util.Map<java.lang.String,java.lang.Byte> BYTE_MAP = io.vertx.codegen.testmodel.ConstantTCK.BYTE_MAP;
  public static final java.util.Map<java.lang.String,java.lang.Short> SHORT_MAP = io.vertx.codegen.testmodel.ConstantTCK.SHORT_MAP;
  public static final java.util.Map<java.lang.String,java.lang.Integer> INT_MAP = io.vertx.codegen.testmodel.ConstantTCK.INT_MAP;
  public static final java.util.Map<java.lang.String,java.lang.Long> LONG_MAP = io.vertx.codegen.testmodel.ConstantTCK.LONG_MAP;
  public static final java.util.Map<java.lang.String,java.lang.Float> FLOAT_MAP = io.vertx.codegen.testmodel.ConstantTCK.FLOAT_MAP;
  public static final java.util.Map<java.lang.String,java.lang.Double> DOUBLE_MAP = io.vertx.codegen.testmodel.ConstantTCK.DOUBLE_MAP;
  public static final java.util.Map<java.lang.String,java.lang.Boolean> BOOLEAN_MAP = io.vertx.codegen.testmodel.ConstantTCK.BOOLEAN_MAP;
  public static final java.util.Map<java.lang.String,java.lang.Character> CHAR_MAP = io.vertx.codegen.testmodel.ConstantTCK.CHAR_MAP;
  public static final java.util.Map<java.lang.String,java.lang.String> STRING_MAP = io.vertx.codegen.testmodel.ConstantTCK.STRING_MAP;
  public static final java.util.Map<java.lang.String,io.vertx.core.json.JsonObject> JSON_OBJECT_MAP = io.vertx.codegen.testmodel.ConstantTCK.JSON_OBJECT_MAP;
  public static final java.util.Map<java.lang.String,io.vertx.core.json.JsonArray> JSON_ARRAY_MAP = io.vertx.codegen.testmodel.ConstantTCK.JSON_ARRAY_MAP;
  public static ConstantTCK newInstance(io.vertx.codegen.testmodel.ConstantTCK arg) {
    return arg != null ? new ConstantTCK(arg) : null;
  }

}
