/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.codegen.testmodel;

import io.vertx.reactivex.RxHelper;
import io.vertx.reactivex.ObservableHelper;
import io.vertx.reactivex.FlowableHelper;
import io.vertx.reactivex.impl.AsyncResultMaybe;
import io.vertx.reactivex.impl.AsyncResultSingle;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.WriteStreamObserver;
import io.vertx.reactivex.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * todo:
 * - Buffer support
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.codegen.testmodel.DataObjectTCK original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.codegen.testmodel.DataObjectTCK.class)
public class DataObjectTCK {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    DataObjectTCK that = (DataObjectTCK) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<DataObjectTCK> __TYPE_ARG = new TypeArg<>(    obj -> new DataObjectTCK((io.vertx.codegen.testmodel.DataObjectTCK) obj),
    DataObjectTCK::getDelegate
  );

  private final io.vertx.codegen.testmodel.DataObjectTCK delegate;
  
  public DataObjectTCK(io.vertx.codegen.testmodel.DataObjectTCK delegate) {
    this.delegate = delegate;
  }

  public DataObjectTCK(Object delegate) {
    this.delegate = (io.vertx.codegen.testmodel.DataObjectTCK)delegate;
  }

  public io.vertx.codegen.testmodel.DataObjectTCK getDelegate() {
    return delegate;
  }

  public io.vertx.codegen.testmodel.DataObjectWithValues getDataObjectWithValues() { 
    io.vertx.codegen.testmodel.DataObjectWithValues ret = delegate.getDataObjectWithValues();
    return ret;
  }

  public void setDataObjectWithValues(io.vertx.codegen.testmodel.DataObjectWithValues dataObject) { 
    delegate.setDataObjectWithValues(dataObject);
  }

  public io.vertx.codegen.testmodel.DataObjectWithLists getDataObjectWithLists() { 
    io.vertx.codegen.testmodel.DataObjectWithLists ret = delegate.getDataObjectWithLists();
    return ret;
  }

  public void setDataObjectWithLists(io.vertx.codegen.testmodel.DataObjectWithLists dataObject) { 
    delegate.setDataObjectWithLists(dataObject);
  }

  public io.vertx.codegen.testmodel.DataObjectWithMaps getDataObjectWithMaps() { 
    io.vertx.codegen.testmodel.DataObjectWithMaps ret = delegate.getDataObjectWithMaps();
    return ret;
  }

  public void setDataObjectWithMaps(io.vertx.codegen.testmodel.DataObjectWithMaps dataObject) { 
    delegate.setDataObjectWithMaps(dataObject);
  }

  public void methodWithOnlyJsonObjectConstructorDataObject(io.vertx.codegen.testmodel.DataObjectWithOnlyJsonObjectConstructor dataObject) { 
    delegate.methodWithOnlyJsonObjectConstructorDataObject(dataObject);
  }

  public void setDataObjectWithBuffer(io.vertx.codegen.testmodel.DataObjectWithNestedBuffer dataObject) { 
    delegate.setDataObjectWithBuffer(dataObject);
  }

  public void setDataObjectWithListAdders(io.vertx.codegen.testmodel.DataObjectWithListAdders dataObject) { 
    delegate.setDataObjectWithListAdders(dataObject);
  }

  public void setDataObjectWithMapAdders(io.vertx.codegen.testmodel.DataObjectWithMapAdders dataObject) { 
    delegate.setDataObjectWithMapAdders(dataObject);
  }

  public void setDataObjectWithRecursion(io.vertx.codegen.testmodel.DataObjectWithRecursion dataObject) { 
    delegate.setDataObjectWithRecursion(dataObject);
  }

  public static DataObjectTCK newInstance(io.vertx.codegen.testmodel.DataObjectTCK arg) {
    return arg != null ? new DataObjectTCK(arg) : null;
  }

}
