/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.codegen.testmodel;

import io.vertx.reactivex.RxHelper;
import io.vertx.reactivex.ObservableHelper;
import io.vertx.reactivex.FlowableHelper;
import io.vertx.reactivex.impl.AsyncResultMaybe;
import io.vertx.reactivex.impl.AsyncResultSingle;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.WriteStreamObserver;
import io.vertx.reactivex.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.codegen.testmodel.Factory original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.codegen.testmodel.Factory.class)
public class Factory {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    Factory that = (Factory) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<Factory> __TYPE_ARG = new TypeArg<>(    obj -> new Factory((io.vertx.codegen.testmodel.Factory) obj),
    Factory::getDelegate
  );

  private final io.vertx.codegen.testmodel.Factory delegate;
  
  public Factory(io.vertx.codegen.testmodel.Factory delegate) {
    this.delegate = delegate;
  }

  public Factory(Object delegate) {
    this.delegate = (io.vertx.codegen.testmodel.Factory)delegate;
  }

  public io.vertx.codegen.testmodel.Factory getDelegate() {
    return delegate;
  }

  public static io.vertx.reactivex.codegen.testmodel.ConcreteHandlerUserType createConcreteHandlerUserType(io.vertx.core.Handler<io.vertx.reactivex.codegen.testmodel.RefedInterface1> handler) { 
    io.vertx.reactivex.codegen.testmodel.ConcreteHandlerUserType ret = io.vertx.reactivex.codegen.testmodel.ConcreteHandlerUserType.newInstance((io.vertx.codegen.testmodel.ConcreteHandlerUserType)io.vertx.codegen.testmodel.Factory.createConcreteHandlerUserType(new Handler<io.vertx.codegen.testmodel.RefedInterface1>() {
      public void handle(io.vertx.codegen.testmodel.RefedInterface1 event) {
        handler.handle(io.vertx.reactivex.codegen.testmodel.RefedInterface1.newInstance((io.vertx.codegen.testmodel.RefedInterface1)event));
      }
    }));
    return ret;
  }

  public static io.vertx.reactivex.codegen.testmodel.AbstractHandlerUserType createAbstractHandlerUserType(io.vertx.core.Handler<io.vertx.reactivex.codegen.testmodel.RefedInterface1> handler) { 
    io.vertx.reactivex.codegen.testmodel.AbstractHandlerUserType ret = io.vertx.reactivex.codegen.testmodel.AbstractHandlerUserType.newInstance((io.vertx.codegen.testmodel.AbstractHandlerUserType)io.vertx.codegen.testmodel.Factory.createAbstractHandlerUserType(new Handler<io.vertx.codegen.testmodel.RefedInterface1>() {
      public void handle(io.vertx.codegen.testmodel.RefedInterface1 event) {
        handler.handle(io.vertx.reactivex.codegen.testmodel.RefedInterface1.newInstance((io.vertx.codegen.testmodel.RefedInterface1)event));
      }
    }));
    return ret;
  }

  public static io.vertx.reactivex.codegen.testmodel.ConcreteHandlerUserTypeExtension createConcreteHandlerUserTypeExtension(io.vertx.core.Handler<io.vertx.reactivex.codegen.testmodel.RefedInterface1> handler) { 
    io.vertx.reactivex.codegen.testmodel.ConcreteHandlerUserTypeExtension ret = io.vertx.reactivex.codegen.testmodel.ConcreteHandlerUserTypeExtension.newInstance((io.vertx.codegen.testmodel.ConcreteHandlerUserTypeExtension)io.vertx.codegen.testmodel.Factory.createConcreteHandlerUserTypeExtension(new Handler<io.vertx.codegen.testmodel.RefedInterface1>() {
      public void handle(io.vertx.codegen.testmodel.RefedInterface1 event) {
        handler.handle(io.vertx.reactivex.codegen.testmodel.RefedInterface1.newInstance((io.vertx.codegen.testmodel.RefedInterface1)event));
      }
    }));
    return ret;
  }

  public static Factory newInstance(io.vertx.codegen.testmodel.Factory arg) {
    return arg != null ? new Factory(arg) : null;
  }

}
