/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.codegen.testmodel;

import io.vertx.reactivex.RxHelper;
import io.vertx.reactivex.ObservableHelper;
import io.vertx.reactivex.FlowableHelper;
import io.vertx.reactivex.impl.AsyncResultMaybe;
import io.vertx.reactivex.impl.AsyncResultSingle;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.WriteStreamObserver;
import io.vertx.reactivex.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.codegen.testmodel.FunctionParamTCK original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.codegen.testmodel.FunctionParamTCK.class)
public class FunctionParamTCK {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    FunctionParamTCK that = (FunctionParamTCK) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<FunctionParamTCK> __TYPE_ARG = new TypeArg<>(    obj -> new FunctionParamTCK((io.vertx.codegen.testmodel.FunctionParamTCK) obj),
    FunctionParamTCK::getDelegate
  );

  private final io.vertx.codegen.testmodel.FunctionParamTCK delegate;
  
  public FunctionParamTCK(io.vertx.codegen.testmodel.FunctionParamTCK delegate) {
    this.delegate = delegate;
  }

  public FunctionParamTCK(Object delegate) {
    this.delegate = (io.vertx.codegen.testmodel.FunctionParamTCK)delegate;
  }

  public io.vertx.codegen.testmodel.FunctionParamTCK getDelegate() {
    return delegate;
  }


  public java.util.List<java.lang.String> methodWithBasicParam(java.util.function.Function<java.lang.Byte,java.lang.String> byteFunc, java.util.function.Function<java.lang.Short,java.lang.String> shortFunc, java.util.function.Function<java.lang.Integer,java.lang.String> integerFunc, java.util.function.Function<java.lang.Long,java.lang.String> longFunc, java.util.function.Function<java.lang.Float,java.lang.String> floatFunc, java.util.function.Function<java.lang.Double,java.lang.String> doubleFunc, java.util.function.Function<java.lang.Boolean,java.lang.String> booleanFunc, java.util.function.Function<java.lang.Character,java.lang.String> charFunc, java.util.function.Function<java.lang.String,java.lang.String> stringFunc) { 
    java.util.List<java.lang.String> ret = delegate.methodWithBasicParam(byteFunc, shortFunc, integerFunc, longFunc, floatFunc, doubleFunc, booleanFunc, charFunc, stringFunc);
    return ret;
  }

  public java.util.List<java.lang.String> methodWithJsonParam(java.util.function.Function<io.vertx.core.json.JsonObject,java.lang.String> objectFunc, java.util.function.Function<io.vertx.core.json.JsonArray,java.lang.String> arrayFunc) { 
    java.util.List<java.lang.String> ret = delegate.methodWithJsonParam(objectFunc, arrayFunc);
    return ret;
  }

  public java.lang.String methodWithVoidParam(java.util.function.Function<java.lang.Void,java.lang.String> func) { 
    java.lang.String ret = delegate.methodWithVoidParam(func);
    return ret;
  }

  public java.lang.String methodWithUserTypeParam(io.vertx.reactivex.codegen.testmodel.RefedInterface1 arg, java.util.function.Function<io.vertx.reactivex.codegen.testmodel.RefedInterface1,java.lang.String> func) { 
    java.lang.String ret = delegate.methodWithUserTypeParam(arg.getDelegate(), new Function<io.vertx.codegen.testmodel.RefedInterface1,java.lang.String>() {
      public java.lang.String apply(io.vertx.codegen.testmodel.RefedInterface1 arg) {
        java.lang.String ret = func.apply(io.vertx.reactivex.codegen.testmodel.RefedInterface1.newInstance((io.vertx.codegen.testmodel.RefedInterface1)arg));
        return ret;
      }
    });
    return ret;
  }

  public java.lang.String methodWithObjectParam(java.lang.Object arg, java.util.function.Function<java.lang.Object,java.lang.String> func) { 
    java.lang.String ret = delegate.methodWithObjectParam(arg, func);
    return ret;
  }

  public java.lang.String methodWithDataObjectParam(java.util.function.Function<io.vertx.codegen.testmodel.TestDataObject,java.lang.String> func) { 
    java.lang.String ret = delegate.methodWithDataObjectParam(func);
    return ret;
  }

  public java.lang.String methodWithEnumParam(java.util.function.Function<io.vertx.codegen.testmodel.TestEnum,java.lang.String> func) { 
    java.lang.String ret = delegate.methodWithEnumParam(func);
    return ret;
  }

  public java.lang.String methodWithListParam(java.util.function.Function<java.util.List<java.lang.String>,java.lang.String> stringFunc) { 
    java.lang.String ret = delegate.methodWithListParam(stringFunc);
    return ret;
  }

  public java.lang.String methodWithSetParam(java.util.function.Function<java.util.Set<java.lang.String>,java.lang.String> func) { 
    java.lang.String ret = delegate.methodWithSetParam(func);
    return ret;
  }

  public java.lang.String methodWithMapParam(java.util.function.Function<java.util.Map<java.lang.String,java.lang.String>,java.lang.String> func) { 
    java.lang.String ret = delegate.methodWithMapParam(func);
    return ret;
  }

  public <T> java.lang.String methodWithGenericParam(T t, java.util.function.Function<T,java.lang.String> func) { 
    java.lang.String ret = delegate.methodWithGenericParam(t, func);
    return ret;
  }

  public <T> java.lang.String methodWithGenericUserTypeParam(T t, java.util.function.Function<io.vertx.reactivex.codegen.testmodel.GenericRefedInterface<T>,java.lang.String> func) { 
    java.lang.String ret = delegate.methodWithGenericUserTypeParam(t, new Function<io.vertx.codegen.testmodel.GenericRefedInterface<T>,java.lang.String>() {
      public java.lang.String apply(io.vertx.codegen.testmodel.GenericRefedInterface<T> arg) {
        java.lang.String ret = func.apply(io.vertx.reactivex.codegen.testmodel.GenericRefedInterface.newInstance((io.vertx.codegen.testmodel.GenericRefedInterface)arg, TypeArg.unknown()));
        return ret;
      }
    });
    return ret;
  }

  public java.lang.String methodWithBasicReturn(java.util.function.Function<java.lang.String,java.lang.Byte> byteFunc, java.util.function.Function<java.lang.String,java.lang.Short> shortFunc, java.util.function.Function<java.lang.String,java.lang.Integer> integerFunc, java.util.function.Function<java.lang.String,java.lang.Long> longFunc, java.util.function.Function<java.lang.String,java.lang.Float> floatFunc, java.util.function.Function<java.lang.String,java.lang.Double> doubleFunc, java.util.function.Function<java.lang.String,java.lang.Boolean> booleanFunc, java.util.function.Function<java.lang.String,java.lang.Character> charFunc, java.util.function.Function<java.lang.String,java.lang.String> stringFunc) { 
    java.lang.String ret = delegate.methodWithBasicReturn(byteFunc, shortFunc, integerFunc, longFunc, floatFunc, doubleFunc, booleanFunc, charFunc, stringFunc);
    return ret;
  }

  public java.lang.String methodWithJsonReturn(java.util.function.Function<java.lang.String,io.vertx.core.json.JsonObject> objectFunc, java.util.function.Function<java.lang.String,io.vertx.core.json.JsonArray> arrayFunc) { 
    java.lang.String ret = delegate.methodWithJsonReturn(objectFunc, arrayFunc);
    return ret;
  }

  public java.lang.String methodWithObjectReturn(java.util.function.Function<java.lang.Integer,java.lang.Object> func) { 
    java.lang.String ret = delegate.methodWithObjectReturn(func);
    return ret;
  }

  public java.lang.String methodWithDataObjectReturn(java.util.function.Function<java.lang.String,io.vertx.codegen.testmodel.TestDataObject> func) { 
    java.lang.String ret = delegate.methodWithDataObjectReturn(func);
    return ret;
  }

  public java.lang.String methodWithEnumReturn(java.util.function.Function<java.lang.String,io.vertx.codegen.testmodel.TestEnum> func) { 
    java.lang.String ret = delegate.methodWithEnumReturn(func);
    return ret;
  }

  public java.lang.String methodWithListReturn(java.util.function.Function<java.lang.String,java.util.List<java.lang.String>> func) { 
    java.lang.String ret = delegate.methodWithListReturn(func);
    return ret;
  }

  public java.lang.String methodWithSetReturn(java.util.function.Function<java.lang.String,java.util.Set<java.lang.String>> func) { 
    java.lang.String ret = delegate.methodWithSetReturn(func);
    return ret;
  }

  public java.lang.String methodWithMapReturn(java.util.function.Function<java.lang.String,java.util.Map<java.lang.String,java.lang.String>> func) { 
    java.lang.String ret = delegate.methodWithMapReturn(func);
    return ret;
  }

  public <T> java.lang.String methodWithGenericReturn(java.util.function.Function<java.lang.Integer,T> func) { 
    java.lang.String ret = delegate.methodWithGenericReturn(func);
    return ret;
  }

  public <T> java.lang.String methodWithGenericUserTypeReturn(java.util.function.Function<io.vertx.reactivex.codegen.testmodel.GenericRefedInterface<T>,io.vertx.reactivex.codegen.testmodel.GenericRefedInterface<T>> func) { 
    java.lang.String ret = delegate.methodWithGenericUserTypeReturn(new Function<io.vertx.codegen.testmodel.GenericRefedInterface<T>,io.vertx.codegen.testmodel.GenericRefedInterface<T>>() {
      public io.vertx.codegen.testmodel.GenericRefedInterface<T> apply(io.vertx.codegen.testmodel.GenericRefedInterface<T> arg) {
        io.vertx.reactivex.codegen.testmodel.GenericRefedInterface<T> ret = func.apply(io.vertx.reactivex.codegen.testmodel.GenericRefedInterface.newInstance((io.vertx.codegen.testmodel.GenericRefedInterface)arg, TypeArg.unknown()));
        return ret.getDelegate();
      }
    });
    return ret;
  }

  public java.lang.String methodWithNullableListParam(java.util.function.Function<java.util.List<java.lang.String>,java.lang.String> func) { 
    java.lang.String ret = delegate.methodWithNullableListParam(func);
    return ret;
  }

  public java.lang.String methodWithNullableListReturn(java.util.function.Function<java.lang.String,java.util.List<java.lang.String>> func) { 
    java.lang.String ret = delegate.methodWithNullableListReturn(func);
    return ret;
  }

  public static FunctionParamTCK newInstance(io.vertx.codegen.testmodel.FunctionParamTCK arg) {
    return arg != null ? new FunctionParamTCK(arg) : null;
  }

}
