/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.codegen.testmodel;

import io.vertx.reactivex.RxHelper;
import io.vertx.reactivex.ObservableHelper;
import io.vertx.reactivex.FlowableHelper;
import io.vertx.reactivex.impl.AsyncResultMaybe;
import io.vertx.reactivex.impl.AsyncResultSingle;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.WriteStreamObserver;
import io.vertx.reactivex.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.codegen.testmodel.GenericsTCK original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.codegen.testmodel.GenericsTCK.class)
public class GenericsTCK {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    GenericsTCK that = (GenericsTCK) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<GenericsTCK> __TYPE_ARG = new TypeArg<>(    obj -> new GenericsTCK((io.vertx.codegen.testmodel.GenericsTCK) obj),
    GenericsTCK::getDelegate
  );

  private final io.vertx.codegen.testmodel.GenericsTCK delegate;
  
  public GenericsTCK(io.vertx.codegen.testmodel.GenericsTCK delegate) {
    this.delegate = delegate;
  }

  public GenericsTCK(Object delegate) {
    this.delegate = (io.vertx.codegen.testmodel.GenericsTCK)delegate;
  }

  public io.vertx.codegen.testmodel.GenericsTCK getDelegate() {
    return delegate;
  }

  private static final TypeArg<io.vertx.reactivex.codegen.testmodel.RefedInterface1> TYPE_ARG_0 = new TypeArg<io.vertx.reactivex.codegen.testmodel.RefedInterface1>(o1 -> io.vertx.reactivex.codegen.testmodel.RefedInterface1.newInstance((io.vertx.codegen.testmodel.RefedInterface1)o1), o1 -> o1.getDelegate());
  private static final TypeArg<io.vertx.reactivex.codegen.testmodel.RefedInterface1> TYPE_ARG_1 = new TypeArg<io.vertx.reactivex.codegen.testmodel.RefedInterface1>(o1 -> io.vertx.reactivex.codegen.testmodel.RefedInterface1.newInstance((io.vertx.codegen.testmodel.RefedInterface1)o1), o1 -> o1.getDelegate());

  public io.vertx.reactivex.codegen.testmodel.GenericRefedInterface<java.lang.Byte> methodWithByteParameterizedReturn() { 
    io.vertx.reactivex.codegen.testmodel.GenericRefedInterface<java.lang.Byte> ret = io.vertx.reactivex.codegen.testmodel.GenericRefedInterface.newInstance((io.vertx.codegen.testmodel.GenericRefedInterface)delegate.methodWithByteParameterizedReturn(), TypeArg.unknown());
    return ret;
  }

  public io.vertx.reactivex.codegen.testmodel.GenericRefedInterface<java.lang.Short> methodWithShortParameterizedReturn() { 
    io.vertx.reactivex.codegen.testmodel.GenericRefedInterface<java.lang.Short> ret = io.vertx.reactivex.codegen.testmodel.GenericRefedInterface.newInstance((io.vertx.codegen.testmodel.GenericRefedInterface)delegate.methodWithShortParameterizedReturn(), TypeArg.unknown());
    return ret;
  }

  public io.vertx.reactivex.codegen.testmodel.GenericRefedInterface<java.lang.Integer> methodWithIntegerParameterizedReturn() { 
    io.vertx.reactivex.codegen.testmodel.GenericRefedInterface<java.lang.Integer> ret = io.vertx.reactivex.codegen.testmodel.GenericRefedInterface.newInstance((io.vertx.codegen.testmodel.GenericRefedInterface)delegate.methodWithIntegerParameterizedReturn(), TypeArg.unknown());
    return ret;
  }

  public io.vertx.reactivex.codegen.testmodel.GenericRefedInterface<java.lang.Long> methodWithLongParameterizedReturn() { 
    io.vertx.reactivex.codegen.testmodel.GenericRefedInterface<java.lang.Long> ret = io.vertx.reactivex.codegen.testmodel.GenericRefedInterface.newInstance((io.vertx.codegen.testmodel.GenericRefedInterface)delegate.methodWithLongParameterizedReturn(), TypeArg.unknown());
    return ret;
  }

  public io.vertx.reactivex.codegen.testmodel.GenericRefedInterface<java.lang.Float> methodWithFloatParameterizedReturn() { 
    io.vertx.reactivex.codegen.testmodel.GenericRefedInterface<java.lang.Float> ret = io.vertx.reactivex.codegen.testmodel.GenericRefedInterface.newInstance((io.vertx.codegen.testmodel.GenericRefedInterface)delegate.methodWithFloatParameterizedReturn(), TypeArg.unknown());
    return ret;
  }

  public io.vertx.reactivex.codegen.testmodel.GenericRefedInterface<java.lang.Double> methodWithDoubleParameterizedReturn() { 
    io.vertx.reactivex.codegen.testmodel.GenericRefedInterface<java.lang.Double> ret = io.vertx.reactivex.codegen.testmodel.GenericRefedInterface.newInstance((io.vertx.codegen.testmodel.GenericRefedInterface)delegate.methodWithDoubleParameterizedReturn(), TypeArg.unknown());
    return ret;
  }

  public io.vertx.reactivex.codegen.testmodel.GenericRefedInterface<java.lang.Boolean> methodWithBooleanParameterizedReturn() { 
    io.vertx.reactivex.codegen.testmodel.GenericRefedInterface<java.lang.Boolean> ret = io.vertx.reactivex.codegen.testmodel.GenericRefedInterface.newInstance((io.vertx.codegen.testmodel.GenericRefedInterface)delegate.methodWithBooleanParameterizedReturn(), TypeArg.unknown());
    return ret;
  }

  public io.vertx.reactivex.codegen.testmodel.GenericRefedInterface<java.lang.Character> methodWithCharacterParameterizedReturn() { 
    io.vertx.reactivex.codegen.testmodel.GenericRefedInterface<java.lang.Character> ret = io.vertx.reactivex.codegen.testmodel.GenericRefedInterface.newInstance((io.vertx.codegen.testmodel.GenericRefedInterface)delegate.methodWithCharacterParameterizedReturn(), TypeArg.unknown());
    return ret;
  }

  public io.vertx.reactivex.codegen.testmodel.GenericRefedInterface<java.lang.String> methodWithStringParameterizedReturn() { 
    io.vertx.reactivex.codegen.testmodel.GenericRefedInterface<java.lang.String> ret = io.vertx.reactivex.codegen.testmodel.GenericRefedInterface.newInstance((io.vertx.codegen.testmodel.GenericRefedInterface)delegate.methodWithStringParameterizedReturn(), TypeArg.unknown());
    return ret;
  }

  public io.vertx.reactivex.codegen.testmodel.GenericRefedInterface<io.vertx.core.json.JsonObject> methodWithJsonObjectParameterizedReturn() { 
    io.vertx.reactivex.codegen.testmodel.GenericRefedInterface<io.vertx.core.json.JsonObject> ret = io.vertx.reactivex.codegen.testmodel.GenericRefedInterface.newInstance((io.vertx.codegen.testmodel.GenericRefedInterface)delegate.methodWithJsonObjectParameterizedReturn(), TypeArg.unknown());
    return ret;
  }

  public io.vertx.reactivex.codegen.testmodel.GenericRefedInterface<io.vertx.core.json.JsonArray> methodWithJsonArrayParameterizedReturn() { 
    io.vertx.reactivex.codegen.testmodel.GenericRefedInterface<io.vertx.core.json.JsonArray> ret = io.vertx.reactivex.codegen.testmodel.GenericRefedInterface.newInstance((io.vertx.codegen.testmodel.GenericRefedInterface)delegate.methodWithJsonArrayParameterizedReturn(), TypeArg.unknown());
    return ret;
  }

  public io.vertx.reactivex.codegen.testmodel.GenericRefedInterface<io.vertx.codegen.testmodel.TestDataObject> methodWithDataObjectParameterizedReturn() { 
    io.vertx.reactivex.codegen.testmodel.GenericRefedInterface<io.vertx.codegen.testmodel.TestDataObject> ret = io.vertx.reactivex.codegen.testmodel.GenericRefedInterface.newInstance((io.vertx.codegen.testmodel.GenericRefedInterface)delegate.methodWithDataObjectParameterizedReturn(), TypeArg.unknown());
    return ret;
  }

  public io.vertx.reactivex.codegen.testmodel.GenericRefedInterface<io.vertx.codegen.testmodel.TestEnum> methodWithEnumParameterizedReturn() { 
    io.vertx.reactivex.codegen.testmodel.GenericRefedInterface<io.vertx.codegen.testmodel.TestEnum> ret = io.vertx.reactivex.codegen.testmodel.GenericRefedInterface.newInstance((io.vertx.codegen.testmodel.GenericRefedInterface)delegate.methodWithEnumParameterizedReturn(), TypeArg.unknown());
    return ret;
  }

  public io.vertx.reactivex.codegen.testmodel.GenericRefedInterface<io.vertx.codegen.testmodel.TestGenEnum> methodWithGenEnumParameterizedReturn() { 
    io.vertx.reactivex.codegen.testmodel.GenericRefedInterface<io.vertx.codegen.testmodel.TestGenEnum> ret = io.vertx.reactivex.codegen.testmodel.GenericRefedInterface.newInstance((io.vertx.codegen.testmodel.GenericRefedInterface)delegate.methodWithGenEnumParameterizedReturn(), TypeArg.unknown());
    return ret;
  }

  public io.vertx.reactivex.codegen.testmodel.GenericRefedInterface<io.vertx.reactivex.codegen.testmodel.RefedInterface1> methodWithUserTypeParameterizedReturn() { 
    io.vertx.reactivex.codegen.testmodel.GenericRefedInterface<io.vertx.reactivex.codegen.testmodel.RefedInterface1> ret = io.vertx.reactivex.codegen.testmodel.GenericRefedInterface.newInstance((io.vertx.codegen.testmodel.GenericRefedInterface)delegate.methodWithUserTypeParameterizedReturn(), TYPE_ARG_0);
    return ret;
  }

  public io.vertx.reactivex.codegen.testmodel.GenericRefedInterface<java.util.List<java.lang.Object>> methodWithListOfObjectsParameterizedReturn() { 
    io.vertx.reactivex.codegen.testmodel.GenericRefedInterface<java.util.List<java.lang.Object>> ret = io.vertx.reactivex.codegen.testmodel.GenericRefedInterface.newInstance((io.vertx.codegen.testmodel.GenericRefedInterface)delegate.methodWithListOfObjectsParameterizedReturn(), TypeArg.unknown());
    return ret;
  }

  public io.vertx.reactivex.codegen.testmodel.GenericRefedInterface<java.util.Set<java.lang.Object>> methodWithSetOfObjectsParameterizedReturn() { 
    io.vertx.reactivex.codegen.testmodel.GenericRefedInterface<java.util.Set<java.lang.Object>> ret = io.vertx.reactivex.codegen.testmodel.GenericRefedInterface.newInstance((io.vertx.codegen.testmodel.GenericRefedInterface)delegate.methodWithSetOfObjectsParameterizedReturn(), TypeArg.unknown());
    return ret;
  }

  public io.vertx.reactivex.codegen.testmodel.GenericRefedInterface<java.util.Map<java.lang.String,java.lang.Object>> methodWithMapOfObjectsParameterizedReturn() { 
    io.vertx.reactivex.codegen.testmodel.GenericRefedInterface<java.util.Map<java.lang.String,java.lang.Object>> ret = io.vertx.reactivex.codegen.testmodel.GenericRefedInterface.newInstance((io.vertx.codegen.testmodel.GenericRefedInterface)delegate.methodWithMapOfObjectsParameterizedReturn(), TypeArg.unknown());
    return ret;
  }

  public void methodWithHandlerByteParameterized(io.vertx.core.Handler<io.vertx.reactivex.codegen.testmodel.GenericRefedInterface<java.lang.Byte>> handler) { 
    delegate.methodWithHandlerByteParameterized(new Handler<io.vertx.codegen.testmodel.GenericRefedInterface<java.lang.Byte>>() {
      public void handle(io.vertx.codegen.testmodel.GenericRefedInterface<java.lang.Byte> event) {
        handler.handle(io.vertx.reactivex.codegen.testmodel.GenericRefedInterface.newInstance((io.vertx.codegen.testmodel.GenericRefedInterface)event, TypeArg.unknown()));
      }
    });
  }

  public void methodWithHandlerShortParameterized(io.vertx.core.Handler<io.vertx.reactivex.codegen.testmodel.GenericRefedInterface<java.lang.Short>> handler) { 
    delegate.methodWithHandlerShortParameterized(new Handler<io.vertx.codegen.testmodel.GenericRefedInterface<java.lang.Short>>() {
      public void handle(io.vertx.codegen.testmodel.GenericRefedInterface<java.lang.Short> event) {
        handler.handle(io.vertx.reactivex.codegen.testmodel.GenericRefedInterface.newInstance((io.vertx.codegen.testmodel.GenericRefedInterface)event, TypeArg.unknown()));
      }
    });
  }

  public void methodWithHandlerIntegerParameterized(io.vertx.core.Handler<io.vertx.reactivex.codegen.testmodel.GenericRefedInterface<java.lang.Integer>> handler) { 
    delegate.methodWithHandlerIntegerParameterized(new Handler<io.vertx.codegen.testmodel.GenericRefedInterface<java.lang.Integer>>() {
      public void handle(io.vertx.codegen.testmodel.GenericRefedInterface<java.lang.Integer> event) {
        handler.handle(io.vertx.reactivex.codegen.testmodel.GenericRefedInterface.newInstance((io.vertx.codegen.testmodel.GenericRefedInterface)event, TypeArg.unknown()));
      }
    });
  }

  public void methodWithHandlerLongParameterized(io.vertx.core.Handler<io.vertx.reactivex.codegen.testmodel.GenericRefedInterface<java.lang.Long>> handler) { 
    delegate.methodWithHandlerLongParameterized(new Handler<io.vertx.codegen.testmodel.GenericRefedInterface<java.lang.Long>>() {
      public void handle(io.vertx.codegen.testmodel.GenericRefedInterface<java.lang.Long> event) {
        handler.handle(io.vertx.reactivex.codegen.testmodel.GenericRefedInterface.newInstance((io.vertx.codegen.testmodel.GenericRefedInterface)event, TypeArg.unknown()));
      }
    });
  }

  public void methodWithHandlerFloatParameterized(io.vertx.core.Handler<io.vertx.reactivex.codegen.testmodel.GenericRefedInterface<java.lang.Float>> handler) { 
    delegate.methodWithHandlerFloatParameterized(new Handler<io.vertx.codegen.testmodel.GenericRefedInterface<java.lang.Float>>() {
      public void handle(io.vertx.codegen.testmodel.GenericRefedInterface<java.lang.Float> event) {
        handler.handle(io.vertx.reactivex.codegen.testmodel.GenericRefedInterface.newInstance((io.vertx.codegen.testmodel.GenericRefedInterface)event, TypeArg.unknown()));
      }
    });
  }

  public void methodWithHandlerDoubleParameterized(io.vertx.core.Handler<io.vertx.reactivex.codegen.testmodel.GenericRefedInterface<java.lang.Double>> handler) { 
    delegate.methodWithHandlerDoubleParameterized(new Handler<io.vertx.codegen.testmodel.GenericRefedInterface<java.lang.Double>>() {
      public void handle(io.vertx.codegen.testmodel.GenericRefedInterface<java.lang.Double> event) {
        handler.handle(io.vertx.reactivex.codegen.testmodel.GenericRefedInterface.newInstance((io.vertx.codegen.testmodel.GenericRefedInterface)event, TypeArg.unknown()));
      }
    });
  }

  public void methodWithHandlerBooleanParameterized(io.vertx.core.Handler<io.vertx.reactivex.codegen.testmodel.GenericRefedInterface<java.lang.Boolean>> handler) { 
    delegate.methodWithHandlerBooleanParameterized(new Handler<io.vertx.codegen.testmodel.GenericRefedInterface<java.lang.Boolean>>() {
      public void handle(io.vertx.codegen.testmodel.GenericRefedInterface<java.lang.Boolean> event) {
        handler.handle(io.vertx.reactivex.codegen.testmodel.GenericRefedInterface.newInstance((io.vertx.codegen.testmodel.GenericRefedInterface)event, TypeArg.unknown()));
      }
    });
  }

  public void methodWithHandlerCharacterParameterized(io.vertx.core.Handler<io.vertx.reactivex.codegen.testmodel.GenericRefedInterface<java.lang.Character>> handler) { 
    delegate.methodWithHandlerCharacterParameterized(new Handler<io.vertx.codegen.testmodel.GenericRefedInterface<java.lang.Character>>() {
      public void handle(io.vertx.codegen.testmodel.GenericRefedInterface<java.lang.Character> event) {
        handler.handle(io.vertx.reactivex.codegen.testmodel.GenericRefedInterface.newInstance((io.vertx.codegen.testmodel.GenericRefedInterface)event, TypeArg.unknown()));
      }
    });
  }

  public void methodWithHandlerStringParameterized(io.vertx.core.Handler<io.vertx.reactivex.codegen.testmodel.GenericRefedInterface<java.lang.String>> handler) { 
    delegate.methodWithHandlerStringParameterized(new Handler<io.vertx.codegen.testmodel.GenericRefedInterface<java.lang.String>>() {
      public void handle(io.vertx.codegen.testmodel.GenericRefedInterface<java.lang.String> event) {
        handler.handle(io.vertx.reactivex.codegen.testmodel.GenericRefedInterface.newInstance((io.vertx.codegen.testmodel.GenericRefedInterface)event, TypeArg.unknown()));
      }
    });
  }

  public void methodWithHandlerJsonObjectParameterized(io.vertx.core.Handler<io.vertx.reactivex.codegen.testmodel.GenericRefedInterface<io.vertx.core.json.JsonObject>> handler) { 
    delegate.methodWithHandlerJsonObjectParameterized(new Handler<io.vertx.codegen.testmodel.GenericRefedInterface<io.vertx.core.json.JsonObject>>() {
      public void handle(io.vertx.codegen.testmodel.GenericRefedInterface<io.vertx.core.json.JsonObject> event) {
        handler.handle(io.vertx.reactivex.codegen.testmodel.GenericRefedInterface.newInstance((io.vertx.codegen.testmodel.GenericRefedInterface)event, TypeArg.unknown()));
      }
    });
  }

  public void methodWithHandlerJsonArrayParameterized(io.vertx.core.Handler<io.vertx.reactivex.codegen.testmodel.GenericRefedInterface<io.vertx.core.json.JsonArray>> handler) { 
    delegate.methodWithHandlerJsonArrayParameterized(new Handler<io.vertx.codegen.testmodel.GenericRefedInterface<io.vertx.core.json.JsonArray>>() {
      public void handle(io.vertx.codegen.testmodel.GenericRefedInterface<io.vertx.core.json.JsonArray> event) {
        handler.handle(io.vertx.reactivex.codegen.testmodel.GenericRefedInterface.newInstance((io.vertx.codegen.testmodel.GenericRefedInterface)event, TypeArg.unknown()));
      }
    });
  }

  public void methodWithHandlerDataObjectParameterized(io.vertx.core.Handler<io.vertx.reactivex.codegen.testmodel.GenericRefedInterface<io.vertx.codegen.testmodel.TestDataObject>> handler) { 
    delegate.methodWithHandlerDataObjectParameterized(new Handler<io.vertx.codegen.testmodel.GenericRefedInterface<io.vertx.codegen.testmodel.TestDataObject>>() {
      public void handle(io.vertx.codegen.testmodel.GenericRefedInterface<io.vertx.codegen.testmodel.TestDataObject> event) {
        handler.handle(io.vertx.reactivex.codegen.testmodel.GenericRefedInterface.newInstance((io.vertx.codegen.testmodel.GenericRefedInterface)event, TypeArg.unknown()));
      }
    });
  }

  public void methodWithHandlerEnumParameterized(io.vertx.core.Handler<io.vertx.reactivex.codegen.testmodel.GenericRefedInterface<io.vertx.codegen.testmodel.TestEnum>> handler) { 
    delegate.methodWithHandlerEnumParameterized(new Handler<io.vertx.codegen.testmodel.GenericRefedInterface<io.vertx.codegen.testmodel.TestEnum>>() {
      public void handle(io.vertx.codegen.testmodel.GenericRefedInterface<io.vertx.codegen.testmodel.TestEnum> event) {
        handler.handle(io.vertx.reactivex.codegen.testmodel.GenericRefedInterface.newInstance((io.vertx.codegen.testmodel.GenericRefedInterface)event, TypeArg.unknown()));
      }
    });
  }

  public void methodWithHandlerGenEnumParameterized(io.vertx.core.Handler<io.vertx.reactivex.codegen.testmodel.GenericRefedInterface<io.vertx.codegen.testmodel.TestGenEnum>> handler) { 
    delegate.methodWithHandlerGenEnumParameterized(new Handler<io.vertx.codegen.testmodel.GenericRefedInterface<io.vertx.codegen.testmodel.TestGenEnum>>() {
      public void handle(io.vertx.codegen.testmodel.GenericRefedInterface<io.vertx.codegen.testmodel.TestGenEnum> event) {
        handler.handle(io.vertx.reactivex.codegen.testmodel.GenericRefedInterface.newInstance((io.vertx.codegen.testmodel.GenericRefedInterface)event, TypeArg.unknown()));
      }
    });
  }

  public void methodWithHandlerUserTypeParameterized(io.vertx.core.Handler<io.vertx.reactivex.codegen.testmodel.GenericRefedInterface<io.vertx.reactivex.codegen.testmodel.RefedInterface1>> handler) { 
    delegate.methodWithHandlerUserTypeParameterized(new Handler<io.vertx.codegen.testmodel.GenericRefedInterface<io.vertx.codegen.testmodel.RefedInterface1>>() {
      public void handle(io.vertx.codegen.testmodel.GenericRefedInterface<io.vertx.codegen.testmodel.RefedInterface1> event) {
        handler.handle(io.vertx.reactivex.codegen.testmodel.GenericRefedInterface.newInstance((io.vertx.codegen.testmodel.GenericRefedInterface)event, new TypeArg<io.vertx.reactivex.codegen.testmodel.RefedInterface1>(o0 -> io.vertx.reactivex.codegen.testmodel.RefedInterface1.newInstance((io.vertx.codegen.testmodel.RefedInterface1)o0), o0 -> o0.getDelegate())));
      }
    });
  }

  public void methodWithHandlerListOfObjectsParameterized(io.vertx.core.Handler<io.vertx.reactivex.codegen.testmodel.GenericRefedInterface<java.util.List<java.lang.Object>>> handler) { 
    delegate.methodWithHandlerListOfObjectsParameterized(new Handler<io.vertx.codegen.testmodel.GenericRefedInterface<java.util.List<java.lang.Object>>>() {
      public void handle(io.vertx.codegen.testmodel.GenericRefedInterface<java.util.List<java.lang.Object>> event) {
        handler.handle(io.vertx.reactivex.codegen.testmodel.GenericRefedInterface.newInstance((io.vertx.codegen.testmodel.GenericRefedInterface)event, TypeArg.unknown()));
      }
    });
  }

  public void methodWithHandlerSetOfObjectsParameterized(io.vertx.core.Handler<io.vertx.reactivex.codegen.testmodel.GenericRefedInterface<java.util.Set<java.lang.Object>>> handler) { 
    delegate.methodWithHandlerSetOfObjectsParameterized(new Handler<io.vertx.codegen.testmodel.GenericRefedInterface<java.util.Set<java.lang.Object>>>() {
      public void handle(io.vertx.codegen.testmodel.GenericRefedInterface<java.util.Set<java.lang.Object>> event) {
        handler.handle(io.vertx.reactivex.codegen.testmodel.GenericRefedInterface.newInstance((io.vertx.codegen.testmodel.GenericRefedInterface)event, TypeArg.unknown()));
      }
    });
  }

  public void methodWithHandlerMapOfObjectsParameterized(io.vertx.core.Handler<io.vertx.reactivex.codegen.testmodel.GenericRefedInterface<java.util.Map<java.lang.String,java.lang.Object>>> handler) { 
    delegate.methodWithHandlerMapOfObjectsParameterized(new Handler<io.vertx.codegen.testmodel.GenericRefedInterface<java.util.Map<java.lang.String,java.lang.Object>>>() {
      public void handle(io.vertx.codegen.testmodel.GenericRefedInterface<java.util.Map<java.lang.String,java.lang.Object>> event) {
        handler.handle(io.vertx.reactivex.codegen.testmodel.GenericRefedInterface.newInstance((io.vertx.codegen.testmodel.GenericRefedInterface)event, TypeArg.unknown()));
      }
    });
  }

  public void methodWithHandlerAsyncResultByteParameterized(io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.codegen.testmodel.GenericRefedInterface<java.lang.Byte>>> handler) { 
    delegate.methodWithHandlerAsyncResultByteParameterized(new Handler<AsyncResult<io.vertx.codegen.testmodel.GenericRefedInterface<java.lang.Byte>>>() {
      public void handle(AsyncResult<io.vertx.codegen.testmodel.GenericRefedInterface<java.lang.Byte>> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.codegen.testmodel.GenericRefedInterface.newInstance((io.vertx.codegen.testmodel.GenericRefedInterface)ar.result(), TypeArg.unknown())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
  }

  public void methodWithHandlerAsyncResultByteParameterized() {
    methodWithHandlerAsyncResultByteParameterized(ar -> { });
  }

  public io.reactivex.Single<io.vertx.reactivex.codegen.testmodel.GenericRefedInterface<java.lang.Byte>> rxMethodWithHandlerAsyncResultByteParameterized() { 
    return AsyncResultSingle.toSingle($handler -> {
      methodWithHandlerAsyncResultByteParameterized($handler);
    });
  }

  public void methodWithHandlerAsyncResultShortParameterized(io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.codegen.testmodel.GenericRefedInterface<java.lang.Short>>> handler) { 
    delegate.methodWithHandlerAsyncResultShortParameterized(new Handler<AsyncResult<io.vertx.codegen.testmodel.GenericRefedInterface<java.lang.Short>>>() {
      public void handle(AsyncResult<io.vertx.codegen.testmodel.GenericRefedInterface<java.lang.Short>> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.codegen.testmodel.GenericRefedInterface.newInstance((io.vertx.codegen.testmodel.GenericRefedInterface)ar.result(), TypeArg.unknown())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
  }

  public void methodWithHandlerAsyncResultShortParameterized() {
    methodWithHandlerAsyncResultShortParameterized(ar -> { });
  }

  public io.reactivex.Single<io.vertx.reactivex.codegen.testmodel.GenericRefedInterface<java.lang.Short>> rxMethodWithHandlerAsyncResultShortParameterized() { 
    return AsyncResultSingle.toSingle($handler -> {
      methodWithHandlerAsyncResultShortParameterized($handler);
    });
  }

  public void methodWithHandlerAsyncResultIntegerParameterized(io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.codegen.testmodel.GenericRefedInterface<java.lang.Integer>>> handler) { 
    delegate.methodWithHandlerAsyncResultIntegerParameterized(new Handler<AsyncResult<io.vertx.codegen.testmodel.GenericRefedInterface<java.lang.Integer>>>() {
      public void handle(AsyncResult<io.vertx.codegen.testmodel.GenericRefedInterface<java.lang.Integer>> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.codegen.testmodel.GenericRefedInterface.newInstance((io.vertx.codegen.testmodel.GenericRefedInterface)ar.result(), TypeArg.unknown())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
  }

  public void methodWithHandlerAsyncResultIntegerParameterized() {
    methodWithHandlerAsyncResultIntegerParameterized(ar -> { });
  }

  public io.reactivex.Single<io.vertx.reactivex.codegen.testmodel.GenericRefedInterface<java.lang.Integer>> rxMethodWithHandlerAsyncResultIntegerParameterized() { 
    return AsyncResultSingle.toSingle($handler -> {
      methodWithHandlerAsyncResultIntegerParameterized($handler);
    });
  }

  public void methodWithHandlerAsyncResultLongParameterized(io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.codegen.testmodel.GenericRefedInterface<java.lang.Long>>> handler) { 
    delegate.methodWithHandlerAsyncResultLongParameterized(new Handler<AsyncResult<io.vertx.codegen.testmodel.GenericRefedInterface<java.lang.Long>>>() {
      public void handle(AsyncResult<io.vertx.codegen.testmodel.GenericRefedInterface<java.lang.Long>> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.codegen.testmodel.GenericRefedInterface.newInstance((io.vertx.codegen.testmodel.GenericRefedInterface)ar.result(), TypeArg.unknown())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
  }

  public void methodWithHandlerAsyncResultLongParameterized() {
    methodWithHandlerAsyncResultLongParameterized(ar -> { });
  }

  public io.reactivex.Single<io.vertx.reactivex.codegen.testmodel.GenericRefedInterface<java.lang.Long>> rxMethodWithHandlerAsyncResultLongParameterized() { 
    return AsyncResultSingle.toSingle($handler -> {
      methodWithHandlerAsyncResultLongParameterized($handler);
    });
  }

  public void methodWithHandlerAsyncResultFloatParameterized(io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.codegen.testmodel.GenericRefedInterface<java.lang.Float>>> handler) { 
    delegate.methodWithHandlerAsyncResultFloatParameterized(new Handler<AsyncResult<io.vertx.codegen.testmodel.GenericRefedInterface<java.lang.Float>>>() {
      public void handle(AsyncResult<io.vertx.codegen.testmodel.GenericRefedInterface<java.lang.Float>> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.codegen.testmodel.GenericRefedInterface.newInstance((io.vertx.codegen.testmodel.GenericRefedInterface)ar.result(), TypeArg.unknown())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
  }

  public void methodWithHandlerAsyncResultFloatParameterized() {
    methodWithHandlerAsyncResultFloatParameterized(ar -> { });
  }

  public io.reactivex.Single<io.vertx.reactivex.codegen.testmodel.GenericRefedInterface<java.lang.Float>> rxMethodWithHandlerAsyncResultFloatParameterized() { 
    return AsyncResultSingle.toSingle($handler -> {
      methodWithHandlerAsyncResultFloatParameterized($handler);
    });
  }

  public void methodWithHandlerAsyncResultDoubleParameterized(io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.codegen.testmodel.GenericRefedInterface<java.lang.Double>>> handler) { 
    delegate.methodWithHandlerAsyncResultDoubleParameterized(new Handler<AsyncResult<io.vertx.codegen.testmodel.GenericRefedInterface<java.lang.Double>>>() {
      public void handle(AsyncResult<io.vertx.codegen.testmodel.GenericRefedInterface<java.lang.Double>> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.codegen.testmodel.GenericRefedInterface.newInstance((io.vertx.codegen.testmodel.GenericRefedInterface)ar.result(), TypeArg.unknown())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
  }

  public void methodWithHandlerAsyncResultDoubleParameterized() {
    methodWithHandlerAsyncResultDoubleParameterized(ar -> { });
  }

  public io.reactivex.Single<io.vertx.reactivex.codegen.testmodel.GenericRefedInterface<java.lang.Double>> rxMethodWithHandlerAsyncResultDoubleParameterized() { 
    return AsyncResultSingle.toSingle($handler -> {
      methodWithHandlerAsyncResultDoubleParameterized($handler);
    });
  }

  public void methodWithHandlerAsyncResultBooleanParameterized(io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.codegen.testmodel.GenericRefedInterface<java.lang.Boolean>>> handler) { 
    delegate.methodWithHandlerAsyncResultBooleanParameterized(new Handler<AsyncResult<io.vertx.codegen.testmodel.GenericRefedInterface<java.lang.Boolean>>>() {
      public void handle(AsyncResult<io.vertx.codegen.testmodel.GenericRefedInterface<java.lang.Boolean>> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.codegen.testmodel.GenericRefedInterface.newInstance((io.vertx.codegen.testmodel.GenericRefedInterface)ar.result(), TypeArg.unknown())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
  }

  public void methodWithHandlerAsyncResultBooleanParameterized() {
    methodWithHandlerAsyncResultBooleanParameterized(ar -> { });
  }

  public io.reactivex.Single<io.vertx.reactivex.codegen.testmodel.GenericRefedInterface<java.lang.Boolean>> rxMethodWithHandlerAsyncResultBooleanParameterized() { 
    return AsyncResultSingle.toSingle($handler -> {
      methodWithHandlerAsyncResultBooleanParameterized($handler);
    });
  }

  public void methodWithHandlerAsyncResultCharacterParameterized(io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.codegen.testmodel.GenericRefedInterface<java.lang.Character>>> handler) { 
    delegate.methodWithHandlerAsyncResultCharacterParameterized(new Handler<AsyncResult<io.vertx.codegen.testmodel.GenericRefedInterface<java.lang.Character>>>() {
      public void handle(AsyncResult<io.vertx.codegen.testmodel.GenericRefedInterface<java.lang.Character>> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.codegen.testmodel.GenericRefedInterface.newInstance((io.vertx.codegen.testmodel.GenericRefedInterface)ar.result(), TypeArg.unknown())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
  }

  public void methodWithHandlerAsyncResultCharacterParameterized() {
    methodWithHandlerAsyncResultCharacterParameterized(ar -> { });
  }

  public io.reactivex.Single<io.vertx.reactivex.codegen.testmodel.GenericRefedInterface<java.lang.Character>> rxMethodWithHandlerAsyncResultCharacterParameterized() { 
    return AsyncResultSingle.toSingle($handler -> {
      methodWithHandlerAsyncResultCharacterParameterized($handler);
    });
  }

  public void methodWithHandlerAsyncResultStringParameterized(io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.codegen.testmodel.GenericRefedInterface<java.lang.String>>> handler) { 
    delegate.methodWithHandlerAsyncResultStringParameterized(new Handler<AsyncResult<io.vertx.codegen.testmodel.GenericRefedInterface<java.lang.String>>>() {
      public void handle(AsyncResult<io.vertx.codegen.testmodel.GenericRefedInterface<java.lang.String>> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.codegen.testmodel.GenericRefedInterface.newInstance((io.vertx.codegen.testmodel.GenericRefedInterface)ar.result(), TypeArg.unknown())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
  }

  public void methodWithHandlerAsyncResultStringParameterized() {
    methodWithHandlerAsyncResultStringParameterized(ar -> { });
  }

  public io.reactivex.Single<io.vertx.reactivex.codegen.testmodel.GenericRefedInterface<java.lang.String>> rxMethodWithHandlerAsyncResultStringParameterized() { 
    return AsyncResultSingle.toSingle($handler -> {
      methodWithHandlerAsyncResultStringParameterized($handler);
    });
  }

  public void methodWithHandlerAsyncResultJsonObjectParameterized(io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.codegen.testmodel.GenericRefedInterface<io.vertx.core.json.JsonObject>>> handler) { 
    delegate.methodWithHandlerAsyncResultJsonObjectParameterized(new Handler<AsyncResult<io.vertx.codegen.testmodel.GenericRefedInterface<io.vertx.core.json.JsonObject>>>() {
      public void handle(AsyncResult<io.vertx.codegen.testmodel.GenericRefedInterface<io.vertx.core.json.JsonObject>> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.codegen.testmodel.GenericRefedInterface.newInstance((io.vertx.codegen.testmodel.GenericRefedInterface)ar.result(), TypeArg.unknown())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
  }

  public void methodWithHandlerAsyncResultJsonObjectParameterized() {
    methodWithHandlerAsyncResultJsonObjectParameterized(ar -> { });
  }

  public io.reactivex.Single<io.vertx.reactivex.codegen.testmodel.GenericRefedInterface<io.vertx.core.json.JsonObject>> rxMethodWithHandlerAsyncResultJsonObjectParameterized() { 
    return AsyncResultSingle.toSingle($handler -> {
      methodWithHandlerAsyncResultJsonObjectParameterized($handler);
    });
  }

  public void methodWithHandlerAsyncResultJsonArrayParameterized(io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.codegen.testmodel.GenericRefedInterface<io.vertx.core.json.JsonArray>>> handler) { 
    delegate.methodWithHandlerAsyncResultJsonArrayParameterized(new Handler<AsyncResult<io.vertx.codegen.testmodel.GenericRefedInterface<io.vertx.core.json.JsonArray>>>() {
      public void handle(AsyncResult<io.vertx.codegen.testmodel.GenericRefedInterface<io.vertx.core.json.JsonArray>> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.codegen.testmodel.GenericRefedInterface.newInstance((io.vertx.codegen.testmodel.GenericRefedInterface)ar.result(), TypeArg.unknown())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
  }

  public void methodWithHandlerAsyncResultJsonArrayParameterized() {
    methodWithHandlerAsyncResultJsonArrayParameterized(ar -> { });
  }

  public io.reactivex.Single<io.vertx.reactivex.codegen.testmodel.GenericRefedInterface<io.vertx.core.json.JsonArray>> rxMethodWithHandlerAsyncResultJsonArrayParameterized() { 
    return AsyncResultSingle.toSingle($handler -> {
      methodWithHandlerAsyncResultJsonArrayParameterized($handler);
    });
  }

  public void methodWithHandlerAsyncResultDataObjectParameterized(io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.codegen.testmodel.GenericRefedInterface<io.vertx.codegen.testmodel.TestDataObject>>> handler) { 
    delegate.methodWithHandlerAsyncResultDataObjectParameterized(new Handler<AsyncResult<io.vertx.codegen.testmodel.GenericRefedInterface<io.vertx.codegen.testmodel.TestDataObject>>>() {
      public void handle(AsyncResult<io.vertx.codegen.testmodel.GenericRefedInterface<io.vertx.codegen.testmodel.TestDataObject>> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.codegen.testmodel.GenericRefedInterface.newInstance((io.vertx.codegen.testmodel.GenericRefedInterface)ar.result(), TypeArg.unknown())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
  }

  public void methodWithHandlerAsyncResultDataObjectParameterized() {
    methodWithHandlerAsyncResultDataObjectParameterized(ar -> { });
  }

  public io.reactivex.Single<io.vertx.reactivex.codegen.testmodel.GenericRefedInterface<io.vertx.codegen.testmodel.TestDataObject>> rxMethodWithHandlerAsyncResultDataObjectParameterized() { 
    return AsyncResultSingle.toSingle($handler -> {
      methodWithHandlerAsyncResultDataObjectParameterized($handler);
    });
  }

  public void methodWithHandlerAsyncResultEnumParameterized(io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.codegen.testmodel.GenericRefedInterface<io.vertx.codegen.testmodel.TestEnum>>> handler) { 
    delegate.methodWithHandlerAsyncResultEnumParameterized(new Handler<AsyncResult<io.vertx.codegen.testmodel.GenericRefedInterface<io.vertx.codegen.testmodel.TestEnum>>>() {
      public void handle(AsyncResult<io.vertx.codegen.testmodel.GenericRefedInterface<io.vertx.codegen.testmodel.TestEnum>> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.codegen.testmodel.GenericRefedInterface.newInstance((io.vertx.codegen.testmodel.GenericRefedInterface)ar.result(), TypeArg.unknown())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
  }

  public void methodWithHandlerAsyncResultEnumParameterized() {
    methodWithHandlerAsyncResultEnumParameterized(ar -> { });
  }

  public io.reactivex.Single<io.vertx.reactivex.codegen.testmodel.GenericRefedInterface<io.vertx.codegen.testmodel.TestEnum>> rxMethodWithHandlerAsyncResultEnumParameterized() { 
    return AsyncResultSingle.toSingle($handler -> {
      methodWithHandlerAsyncResultEnumParameterized($handler);
    });
  }

  public void methodWithHandlerAsyncResultGenEnumParameterized(io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.codegen.testmodel.GenericRefedInterface<io.vertx.codegen.testmodel.TestGenEnum>>> handler) { 
    delegate.methodWithHandlerAsyncResultGenEnumParameterized(new Handler<AsyncResult<io.vertx.codegen.testmodel.GenericRefedInterface<io.vertx.codegen.testmodel.TestGenEnum>>>() {
      public void handle(AsyncResult<io.vertx.codegen.testmodel.GenericRefedInterface<io.vertx.codegen.testmodel.TestGenEnum>> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.codegen.testmodel.GenericRefedInterface.newInstance((io.vertx.codegen.testmodel.GenericRefedInterface)ar.result(), TypeArg.unknown())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
  }

  public void methodWithHandlerAsyncResultGenEnumParameterized() {
    methodWithHandlerAsyncResultGenEnumParameterized(ar -> { });
  }

  public io.reactivex.Single<io.vertx.reactivex.codegen.testmodel.GenericRefedInterface<io.vertx.codegen.testmodel.TestGenEnum>> rxMethodWithHandlerAsyncResultGenEnumParameterized() { 
    return AsyncResultSingle.toSingle($handler -> {
      methodWithHandlerAsyncResultGenEnumParameterized($handler);
    });
  }

  public void methodWithHandlerAsyncResultUserTypeParameterized(io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.codegen.testmodel.GenericRefedInterface<io.vertx.reactivex.codegen.testmodel.RefedInterface1>>> handler) { 
    delegate.methodWithHandlerAsyncResultUserTypeParameterized(new Handler<AsyncResult<io.vertx.codegen.testmodel.GenericRefedInterface<io.vertx.codegen.testmodel.RefedInterface1>>>() {
      public void handle(AsyncResult<io.vertx.codegen.testmodel.GenericRefedInterface<io.vertx.codegen.testmodel.RefedInterface1>> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.codegen.testmodel.GenericRefedInterface.newInstance((io.vertx.codegen.testmodel.GenericRefedInterface)ar.result(), new TypeArg<io.vertx.reactivex.codegen.testmodel.RefedInterface1>(o0 -> io.vertx.reactivex.codegen.testmodel.RefedInterface1.newInstance((io.vertx.codegen.testmodel.RefedInterface1)o0), o0 -> o0.getDelegate()))));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
  }

  public void methodWithHandlerAsyncResultUserTypeParameterized() {
    methodWithHandlerAsyncResultUserTypeParameterized(ar -> { });
  }

  public io.reactivex.Single<io.vertx.reactivex.codegen.testmodel.GenericRefedInterface<io.vertx.reactivex.codegen.testmodel.RefedInterface1>> rxMethodWithHandlerAsyncResultUserTypeParameterized() { 
    return AsyncResultSingle.toSingle($handler -> {
      methodWithHandlerAsyncResultUserTypeParameterized($handler);
    });
  }

  public void methodWithHandlerAsyncResultListOfObjectsParameterized(io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.codegen.testmodel.GenericRefedInterface<java.util.List<java.lang.Object>>>> handler) { 
    delegate.methodWithHandlerAsyncResultListOfObjectsParameterized(new Handler<AsyncResult<io.vertx.codegen.testmodel.GenericRefedInterface<java.util.List<java.lang.Object>>>>() {
      public void handle(AsyncResult<io.vertx.codegen.testmodel.GenericRefedInterface<java.util.List<java.lang.Object>>> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.codegen.testmodel.GenericRefedInterface.newInstance((io.vertx.codegen.testmodel.GenericRefedInterface)ar.result(), TypeArg.unknown())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
  }

  public void methodWithHandlerAsyncResultListOfObjectsParameterized() {
    methodWithHandlerAsyncResultListOfObjectsParameterized(ar -> { });
  }

  public io.reactivex.Single<io.vertx.reactivex.codegen.testmodel.GenericRefedInterface<java.util.List<java.lang.Object>>> rxMethodWithHandlerAsyncResultListOfObjectsParameterized() { 
    return AsyncResultSingle.toSingle($handler -> {
      methodWithHandlerAsyncResultListOfObjectsParameterized($handler);
    });
  }

  public void methodWithHandlerAsyncResultSetOfObjectsParameterized(io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.codegen.testmodel.GenericRefedInterface<java.util.Set<java.lang.Object>>>> handler) { 
    delegate.methodWithHandlerAsyncResultSetOfObjectsParameterized(new Handler<AsyncResult<io.vertx.codegen.testmodel.GenericRefedInterface<java.util.Set<java.lang.Object>>>>() {
      public void handle(AsyncResult<io.vertx.codegen.testmodel.GenericRefedInterface<java.util.Set<java.lang.Object>>> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.codegen.testmodel.GenericRefedInterface.newInstance((io.vertx.codegen.testmodel.GenericRefedInterface)ar.result(), TypeArg.unknown())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
  }

  public void methodWithHandlerAsyncResultSetOfObjectsParameterized() {
    methodWithHandlerAsyncResultSetOfObjectsParameterized(ar -> { });
  }

  public io.reactivex.Single<io.vertx.reactivex.codegen.testmodel.GenericRefedInterface<java.util.Set<java.lang.Object>>> rxMethodWithHandlerAsyncResultSetOfObjectsParameterized() { 
    return AsyncResultSingle.toSingle($handler -> {
      methodWithHandlerAsyncResultSetOfObjectsParameterized($handler);
    });
  }

  public void methodWithHandlerAsyncResultMapOfObjectsParameterized(io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.codegen.testmodel.GenericRefedInterface<java.util.Map<java.lang.String,java.lang.Object>>>> handler) { 
    delegate.methodWithHandlerAsyncResultMapOfObjectsParameterized(new Handler<AsyncResult<io.vertx.codegen.testmodel.GenericRefedInterface<java.util.Map<java.lang.String,java.lang.Object>>>>() {
      public void handle(AsyncResult<io.vertx.codegen.testmodel.GenericRefedInterface<java.util.Map<java.lang.String,java.lang.Object>>> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.codegen.testmodel.GenericRefedInterface.newInstance((io.vertx.codegen.testmodel.GenericRefedInterface)ar.result(), TypeArg.unknown())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
  }

  public void methodWithHandlerAsyncResultMapOfObjectsParameterized() {
    methodWithHandlerAsyncResultMapOfObjectsParameterized(ar -> { });
  }

  public io.reactivex.Single<io.vertx.reactivex.codegen.testmodel.GenericRefedInterface<java.util.Map<java.lang.String,java.lang.Object>>> rxMethodWithHandlerAsyncResultMapOfObjectsParameterized() { 
    return AsyncResultSingle.toSingle($handler -> {
      methodWithHandlerAsyncResultMapOfObjectsParameterized($handler);
    });
  }

  public void methodWithFunctionParamByteParameterized(java.util.function.Function<io.vertx.reactivex.codegen.testmodel.GenericRefedInterface<java.lang.Byte>,java.lang.String> handler) { 
    delegate.methodWithFunctionParamByteParameterized(new Function<io.vertx.codegen.testmodel.GenericRefedInterface<java.lang.Byte>,java.lang.String>() {
      public java.lang.String apply(io.vertx.codegen.testmodel.GenericRefedInterface<java.lang.Byte> arg) {
        java.lang.String ret = handler.apply(io.vertx.reactivex.codegen.testmodel.GenericRefedInterface.newInstance((io.vertx.codegen.testmodel.GenericRefedInterface)arg, TypeArg.unknown()));
        return ret;
      }
    });
  }

  public void methodWithFunctionParamShortParameterized(java.util.function.Function<io.vertx.reactivex.codegen.testmodel.GenericRefedInterface<java.lang.Short>,java.lang.String> handler) { 
    delegate.methodWithFunctionParamShortParameterized(new Function<io.vertx.codegen.testmodel.GenericRefedInterface<java.lang.Short>,java.lang.String>() {
      public java.lang.String apply(io.vertx.codegen.testmodel.GenericRefedInterface<java.lang.Short> arg) {
        java.lang.String ret = handler.apply(io.vertx.reactivex.codegen.testmodel.GenericRefedInterface.newInstance((io.vertx.codegen.testmodel.GenericRefedInterface)arg, TypeArg.unknown()));
        return ret;
      }
    });
  }

  public void methodWithFunctionParamIntegerParameterized(java.util.function.Function<io.vertx.reactivex.codegen.testmodel.GenericRefedInterface<java.lang.Integer>,java.lang.String> handler) { 
    delegate.methodWithFunctionParamIntegerParameterized(new Function<io.vertx.codegen.testmodel.GenericRefedInterface<java.lang.Integer>,java.lang.String>() {
      public java.lang.String apply(io.vertx.codegen.testmodel.GenericRefedInterface<java.lang.Integer> arg) {
        java.lang.String ret = handler.apply(io.vertx.reactivex.codegen.testmodel.GenericRefedInterface.newInstance((io.vertx.codegen.testmodel.GenericRefedInterface)arg, TypeArg.unknown()));
        return ret;
      }
    });
  }

  public void methodWithFunctionParamLongParameterized(java.util.function.Function<io.vertx.reactivex.codegen.testmodel.GenericRefedInterface<java.lang.Long>,java.lang.String> handler) { 
    delegate.methodWithFunctionParamLongParameterized(new Function<io.vertx.codegen.testmodel.GenericRefedInterface<java.lang.Long>,java.lang.String>() {
      public java.lang.String apply(io.vertx.codegen.testmodel.GenericRefedInterface<java.lang.Long> arg) {
        java.lang.String ret = handler.apply(io.vertx.reactivex.codegen.testmodel.GenericRefedInterface.newInstance((io.vertx.codegen.testmodel.GenericRefedInterface)arg, TypeArg.unknown()));
        return ret;
      }
    });
  }

  public void methodWithFunctionParamFloatParameterized(java.util.function.Function<io.vertx.reactivex.codegen.testmodel.GenericRefedInterface<java.lang.Float>,java.lang.String> handler) { 
    delegate.methodWithFunctionParamFloatParameterized(new Function<io.vertx.codegen.testmodel.GenericRefedInterface<java.lang.Float>,java.lang.String>() {
      public java.lang.String apply(io.vertx.codegen.testmodel.GenericRefedInterface<java.lang.Float> arg) {
        java.lang.String ret = handler.apply(io.vertx.reactivex.codegen.testmodel.GenericRefedInterface.newInstance((io.vertx.codegen.testmodel.GenericRefedInterface)arg, TypeArg.unknown()));
        return ret;
      }
    });
  }

  public void methodWithFunctionParamDoubleParameterized(java.util.function.Function<io.vertx.reactivex.codegen.testmodel.GenericRefedInterface<java.lang.Double>,java.lang.String> handler) { 
    delegate.methodWithFunctionParamDoubleParameterized(new Function<io.vertx.codegen.testmodel.GenericRefedInterface<java.lang.Double>,java.lang.String>() {
      public java.lang.String apply(io.vertx.codegen.testmodel.GenericRefedInterface<java.lang.Double> arg) {
        java.lang.String ret = handler.apply(io.vertx.reactivex.codegen.testmodel.GenericRefedInterface.newInstance((io.vertx.codegen.testmodel.GenericRefedInterface)arg, TypeArg.unknown()));
        return ret;
      }
    });
  }

  public void methodWithFunctionParamBooleanParameterized(java.util.function.Function<io.vertx.reactivex.codegen.testmodel.GenericRefedInterface<java.lang.Boolean>,java.lang.String> handler) { 
    delegate.methodWithFunctionParamBooleanParameterized(new Function<io.vertx.codegen.testmodel.GenericRefedInterface<java.lang.Boolean>,java.lang.String>() {
      public java.lang.String apply(io.vertx.codegen.testmodel.GenericRefedInterface<java.lang.Boolean> arg) {
        java.lang.String ret = handler.apply(io.vertx.reactivex.codegen.testmodel.GenericRefedInterface.newInstance((io.vertx.codegen.testmodel.GenericRefedInterface)arg, TypeArg.unknown()));
        return ret;
      }
    });
  }

  public void methodWithFunctionParamCharacterParameterized(java.util.function.Function<io.vertx.reactivex.codegen.testmodel.GenericRefedInterface<java.lang.Character>,java.lang.String> handler) { 
    delegate.methodWithFunctionParamCharacterParameterized(new Function<io.vertx.codegen.testmodel.GenericRefedInterface<java.lang.Character>,java.lang.String>() {
      public java.lang.String apply(io.vertx.codegen.testmodel.GenericRefedInterface<java.lang.Character> arg) {
        java.lang.String ret = handler.apply(io.vertx.reactivex.codegen.testmodel.GenericRefedInterface.newInstance((io.vertx.codegen.testmodel.GenericRefedInterface)arg, TypeArg.unknown()));
        return ret;
      }
    });
  }

  public void methodWithFunctionParamStringParameterized(java.util.function.Function<io.vertx.reactivex.codegen.testmodel.GenericRefedInterface<java.lang.String>,java.lang.String> handler) { 
    delegate.methodWithFunctionParamStringParameterized(new Function<io.vertx.codegen.testmodel.GenericRefedInterface<java.lang.String>,java.lang.String>() {
      public java.lang.String apply(io.vertx.codegen.testmodel.GenericRefedInterface<java.lang.String> arg) {
        java.lang.String ret = handler.apply(io.vertx.reactivex.codegen.testmodel.GenericRefedInterface.newInstance((io.vertx.codegen.testmodel.GenericRefedInterface)arg, TypeArg.unknown()));
        return ret;
      }
    });
  }

  public void methodWithFunctionParamJsonObjectParameterized(java.util.function.Function<io.vertx.reactivex.codegen.testmodel.GenericRefedInterface<io.vertx.core.json.JsonObject>,java.lang.String> handler) { 
    delegate.methodWithFunctionParamJsonObjectParameterized(new Function<io.vertx.codegen.testmodel.GenericRefedInterface<io.vertx.core.json.JsonObject>,java.lang.String>() {
      public java.lang.String apply(io.vertx.codegen.testmodel.GenericRefedInterface<io.vertx.core.json.JsonObject> arg) {
        java.lang.String ret = handler.apply(io.vertx.reactivex.codegen.testmodel.GenericRefedInterface.newInstance((io.vertx.codegen.testmodel.GenericRefedInterface)arg, TypeArg.unknown()));
        return ret;
      }
    });
  }

  public void methodWithFunctionParamJsonArrayParameterized(java.util.function.Function<io.vertx.reactivex.codegen.testmodel.GenericRefedInterface<io.vertx.core.json.JsonArray>,java.lang.String> handler) { 
    delegate.methodWithFunctionParamJsonArrayParameterized(new Function<io.vertx.codegen.testmodel.GenericRefedInterface<io.vertx.core.json.JsonArray>,java.lang.String>() {
      public java.lang.String apply(io.vertx.codegen.testmodel.GenericRefedInterface<io.vertx.core.json.JsonArray> arg) {
        java.lang.String ret = handler.apply(io.vertx.reactivex.codegen.testmodel.GenericRefedInterface.newInstance((io.vertx.codegen.testmodel.GenericRefedInterface)arg, TypeArg.unknown()));
        return ret;
      }
    });
  }

  public void methodWithFunctionParamDataObjectParameterized(java.util.function.Function<io.vertx.reactivex.codegen.testmodel.GenericRefedInterface<io.vertx.codegen.testmodel.TestDataObject>,java.lang.String> handler) { 
    delegate.methodWithFunctionParamDataObjectParameterized(new Function<io.vertx.codegen.testmodel.GenericRefedInterface<io.vertx.codegen.testmodel.TestDataObject>,java.lang.String>() {
      public java.lang.String apply(io.vertx.codegen.testmodel.GenericRefedInterface<io.vertx.codegen.testmodel.TestDataObject> arg) {
        java.lang.String ret = handler.apply(io.vertx.reactivex.codegen.testmodel.GenericRefedInterface.newInstance((io.vertx.codegen.testmodel.GenericRefedInterface)arg, TypeArg.unknown()));
        return ret;
      }
    });
  }

  public void methodWithFunctionParamEnumParameterized(java.util.function.Function<io.vertx.reactivex.codegen.testmodel.GenericRefedInterface<io.vertx.codegen.testmodel.TestEnum>,java.lang.String> handler) { 
    delegate.methodWithFunctionParamEnumParameterized(new Function<io.vertx.codegen.testmodel.GenericRefedInterface<io.vertx.codegen.testmodel.TestEnum>,java.lang.String>() {
      public java.lang.String apply(io.vertx.codegen.testmodel.GenericRefedInterface<io.vertx.codegen.testmodel.TestEnum> arg) {
        java.lang.String ret = handler.apply(io.vertx.reactivex.codegen.testmodel.GenericRefedInterface.newInstance((io.vertx.codegen.testmodel.GenericRefedInterface)arg, TypeArg.unknown()));
        return ret;
      }
    });
  }

  public void methodWithFunctionParamGenEnumParameterized(java.util.function.Function<io.vertx.reactivex.codegen.testmodel.GenericRefedInterface<io.vertx.codegen.testmodel.TestGenEnum>,java.lang.String> handler) { 
    delegate.methodWithFunctionParamGenEnumParameterized(new Function<io.vertx.codegen.testmodel.GenericRefedInterface<io.vertx.codegen.testmodel.TestGenEnum>,java.lang.String>() {
      public java.lang.String apply(io.vertx.codegen.testmodel.GenericRefedInterface<io.vertx.codegen.testmodel.TestGenEnum> arg) {
        java.lang.String ret = handler.apply(io.vertx.reactivex.codegen.testmodel.GenericRefedInterface.newInstance((io.vertx.codegen.testmodel.GenericRefedInterface)arg, TypeArg.unknown()));
        return ret;
      }
    });
  }

  public void methodWithFunctionParamUserTypeParameterized(java.util.function.Function<io.vertx.reactivex.codegen.testmodel.GenericRefedInterface<io.vertx.reactivex.codegen.testmodel.RefedInterface1>,java.lang.String> handler) { 
    delegate.methodWithFunctionParamUserTypeParameterized(new Function<io.vertx.codegen.testmodel.GenericRefedInterface<io.vertx.codegen.testmodel.RefedInterface1>,java.lang.String>() {
      public java.lang.String apply(io.vertx.codegen.testmodel.GenericRefedInterface<io.vertx.codegen.testmodel.RefedInterface1> arg) {
        java.lang.String ret = handler.apply(io.vertx.reactivex.codegen.testmodel.GenericRefedInterface.newInstance((io.vertx.codegen.testmodel.GenericRefedInterface)arg, new TypeArg<io.vertx.reactivex.codegen.testmodel.RefedInterface1>(o0 -> io.vertx.reactivex.codegen.testmodel.RefedInterface1.newInstance((io.vertx.codegen.testmodel.RefedInterface1)o0), o0 -> o0.getDelegate())));
        return ret;
      }
    });
  }

  public void methodWithFunctionParamListOfObjectsParameterized(java.util.function.Function<io.vertx.reactivex.codegen.testmodel.GenericRefedInterface<java.util.List<java.lang.Object>>,java.lang.String> handler) { 
    delegate.methodWithFunctionParamListOfObjectsParameterized(new Function<io.vertx.codegen.testmodel.GenericRefedInterface<java.util.List<java.lang.Object>>,java.lang.String>() {
      public java.lang.String apply(io.vertx.codegen.testmodel.GenericRefedInterface<java.util.List<java.lang.Object>> arg) {
        java.lang.String ret = handler.apply(io.vertx.reactivex.codegen.testmodel.GenericRefedInterface.newInstance((io.vertx.codegen.testmodel.GenericRefedInterface)arg, TypeArg.unknown()));
        return ret;
      }
    });
  }

  public void methodWithFunctionParamSetOfObjectsParameterized(java.util.function.Function<io.vertx.reactivex.codegen.testmodel.GenericRefedInterface<java.util.Set<java.lang.Object>>,java.lang.String> handler) { 
    delegate.methodWithFunctionParamSetOfObjectsParameterized(new Function<io.vertx.codegen.testmodel.GenericRefedInterface<java.util.Set<java.lang.Object>>,java.lang.String>() {
      public java.lang.String apply(io.vertx.codegen.testmodel.GenericRefedInterface<java.util.Set<java.lang.Object>> arg) {
        java.lang.String ret = handler.apply(io.vertx.reactivex.codegen.testmodel.GenericRefedInterface.newInstance((io.vertx.codegen.testmodel.GenericRefedInterface)arg, TypeArg.unknown()));
        return ret;
      }
    });
  }

  public void methodWithFunctionParamMapOfObjectsParameterized(java.util.function.Function<io.vertx.reactivex.codegen.testmodel.GenericRefedInterface<java.util.Map<java.lang.String,java.lang.Object>>,java.lang.String> handler) { 
    delegate.methodWithFunctionParamMapOfObjectsParameterized(new Function<io.vertx.codegen.testmodel.GenericRefedInterface<java.util.Map<java.lang.String,java.lang.Object>>,java.lang.String>() {
      public java.lang.String apply(io.vertx.codegen.testmodel.GenericRefedInterface<java.util.Map<java.lang.String,java.lang.Object>> arg) {
        java.lang.String ret = handler.apply(io.vertx.reactivex.codegen.testmodel.GenericRefedInterface.newInstance((io.vertx.codegen.testmodel.GenericRefedInterface)arg, TypeArg.unknown()));
        return ret;
      }
    });
  }

  public <U> io.vertx.reactivex.codegen.testmodel.GenericRefedInterface<U> methodWithClassTypeParameterizedReturn(java.lang.Class<U> type) { 
    io.vertx.reactivex.codegen.testmodel.GenericRefedInterface<U> ret = io.vertx.reactivex.codegen.testmodel.GenericRefedInterface.newInstance((io.vertx.codegen.testmodel.GenericRefedInterface)delegate.methodWithClassTypeParameterizedReturn(io.vertx.lang.reactivex.Helper.unwrap(type)), TypeArg.of(type));
    return ret;
  }

  public <U> void methodWithHandlerClassTypeParameterized(java.lang.Class<U> type, io.vertx.core.Handler<io.vertx.reactivex.codegen.testmodel.GenericRefedInterface<U>> handler) { 
    delegate.methodWithHandlerClassTypeParameterized(io.vertx.lang.reactivex.Helper.unwrap(type), new Handler<io.vertx.codegen.testmodel.GenericRefedInterface<U>>() {
      public void handle(io.vertx.codegen.testmodel.GenericRefedInterface<U> event) {
        handler.handle(io.vertx.reactivex.codegen.testmodel.GenericRefedInterface.newInstance((io.vertx.codegen.testmodel.GenericRefedInterface)event, TypeArg.of(type)));
      }
    });
  }

  public <U> void methodWithHandlerAsyncResultClassTypeParameterized(java.lang.Class<U> type, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.codegen.testmodel.GenericRefedInterface<U>>> handler) { 
    delegate.methodWithHandlerAsyncResultClassTypeParameterized(io.vertx.lang.reactivex.Helper.unwrap(type), new Handler<AsyncResult<io.vertx.codegen.testmodel.GenericRefedInterface<U>>>() {
      public void handle(AsyncResult<io.vertx.codegen.testmodel.GenericRefedInterface<U>> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.codegen.testmodel.GenericRefedInterface.newInstance((io.vertx.codegen.testmodel.GenericRefedInterface)ar.result(), TypeArg.of(type))));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
  }

  public <U> void methodWithHandlerAsyncResultClassTypeParameterized(java.lang.Class<U> type) {
    methodWithHandlerAsyncResultClassTypeParameterized(type, ar -> { });
  }

  public <U> io.reactivex.Single<io.vertx.reactivex.codegen.testmodel.GenericRefedInterface<U>> rxMethodWithHandlerAsyncResultClassTypeParameterized(java.lang.Class<U> type) { 
    return AsyncResultSingle.toSingle($handler -> {
      methodWithHandlerAsyncResultClassTypeParameterized(type, $handler);
    });
  }

  public <U> void methodWithFunctionParamClassTypeParameterized(java.lang.Class<U> type, java.util.function.Function<io.vertx.reactivex.codegen.testmodel.GenericRefedInterface<U>,java.lang.String> handler) { 
    delegate.methodWithFunctionParamClassTypeParameterized(io.vertx.lang.reactivex.Helper.unwrap(type), new Function<io.vertx.codegen.testmodel.GenericRefedInterface<U>,java.lang.String>() {
      public java.lang.String apply(io.vertx.codegen.testmodel.GenericRefedInterface<U> arg) {
        java.lang.String ret = handler.apply(io.vertx.reactivex.codegen.testmodel.GenericRefedInterface.newInstance((io.vertx.codegen.testmodel.GenericRefedInterface)arg, TypeArg.of(type)));
        return ret;
      }
    });
  }

  public <U> void methodWithClassTypeParam(java.lang.Class<U> type, U u) { 
    delegate.methodWithClassTypeParam(io.vertx.lang.reactivex.Helper.unwrap(type), TypeArg.of(type).<U>unwrap(u));
  }

  public <U> U methodWithClassTypeReturn(java.lang.Class<U> type) { 
    U ret = (U)TypeArg.of(type).wrap(delegate.methodWithClassTypeReturn(io.vertx.lang.reactivex.Helper.unwrap(type)));
    return ret;
  }

  public <U> void methodWithClassTypeHandler(java.lang.Class<U> type, io.vertx.core.Handler<U> f) { 
    delegate.methodWithClassTypeHandler(io.vertx.lang.reactivex.Helper.unwrap(type), new Handler<U>() {
      public void handle(U event) {
        f.handle((U)TypeArg.of(type).wrap(event));
      }
    });
  }

  public <U> void methodWithClassTypeHandlerAsyncResult(java.lang.Class<U> type, io.vertx.core.Handler<io.vertx.core.AsyncResult<U>> f) { 
    delegate.methodWithClassTypeHandlerAsyncResult(io.vertx.lang.reactivex.Helper.unwrap(type), new Handler<AsyncResult<U>>() {
      public void handle(AsyncResult<U> ar) {
        if (ar.succeeded()) {
          f.handle(io.vertx.core.Future.succeededFuture((U)TypeArg.of(type).wrap(ar.result())));
        } else {
          f.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
  }

  public <U> void methodWithClassTypeHandlerAsyncResult(java.lang.Class<U> type) {
    methodWithClassTypeHandlerAsyncResult(type, ar -> { });
  }

  public <U> io.reactivex.Single<U> rxMethodWithClassTypeHandlerAsyncResult(java.lang.Class<U> type) { 
    return AsyncResultSingle.toSingle($handler -> {
      methodWithClassTypeHandlerAsyncResult(type, $handler);
    });
  }

  public <U> void methodWithClassTypeFunctionParam(java.lang.Class<U> type, java.util.function.Function<U,java.lang.String> f) { 
    delegate.methodWithClassTypeFunctionParam(io.vertx.lang.reactivex.Helper.unwrap(type), new Function<U,java.lang.String>() {
      public java.lang.String apply(U arg) {
        java.lang.String ret = f.apply((U)TypeArg.of(type).wrap(arg));
        return ret;
      }
    });
  }

  public <U> void methodWithClassTypeFunctionReturn(java.lang.Class<U> type, java.util.function.Function<java.lang.String,U> f) { 
    delegate.methodWithClassTypeFunctionReturn(io.vertx.lang.reactivex.Helper.unwrap(type), new Function<java.lang.String,U>() {
      public U apply(java.lang.String arg) {
        U ret = f.apply(arg);
        return TypeArg.of(type).<U>unwrap(ret);
      }
    });
  }

  public io.vertx.reactivex.codegen.testmodel.InterfaceWithApiArg interfaceWithApiArg(io.vertx.reactivex.codegen.testmodel.RefedInterface1 value) { 
    io.vertx.reactivex.codegen.testmodel.InterfaceWithApiArg ret = io.vertx.reactivex.codegen.testmodel.InterfaceWithApiArg.newInstance((io.vertx.codegen.testmodel.InterfaceWithApiArg)delegate.interfaceWithApiArg(value.getDelegate()));
    return ret;
  }

  public io.vertx.reactivex.codegen.testmodel.InterfaceWithStringArg interfaceWithStringArg(java.lang.String value) { 
    io.vertx.reactivex.codegen.testmodel.InterfaceWithStringArg ret = io.vertx.reactivex.codegen.testmodel.InterfaceWithStringArg.newInstance((io.vertx.codegen.testmodel.InterfaceWithStringArg)delegate.interfaceWithStringArg(value));
    return ret;
  }

  public <T, U> io.vertx.reactivex.codegen.testmodel.InterfaceWithVariableArg<T,U> interfaceWithVariableArg(T value1, java.lang.Class<U> type, U value2) { 
    io.vertx.reactivex.codegen.testmodel.InterfaceWithVariableArg<T,U> ret = io.vertx.reactivex.codegen.testmodel.InterfaceWithVariableArg.newInstance((io.vertx.codegen.testmodel.InterfaceWithVariableArg)delegate.interfaceWithVariableArg(value1, io.vertx.lang.reactivex.Helper.unwrap(type), TypeArg.of(type).<U>unwrap(value2)), TypeArg.unknown(), TypeArg.of(type));
    return ret;
  }

  public void methodWithHandlerGenericNullableApi(boolean notNull, io.vertx.core.Handler<io.vertx.reactivex.codegen.testmodel.GenericNullableRefedInterface<io.vertx.reactivex.codegen.testmodel.RefedInterface1>> handler) { 
    delegate.methodWithHandlerGenericNullableApi(notNull, new Handler<io.vertx.codegen.testmodel.GenericNullableRefedInterface<io.vertx.codegen.testmodel.RefedInterface1>>() {
      public void handle(io.vertx.codegen.testmodel.GenericNullableRefedInterface<io.vertx.codegen.testmodel.RefedInterface1> event) {
        handler.handle(io.vertx.reactivex.codegen.testmodel.GenericNullableRefedInterface.newInstance((io.vertx.codegen.testmodel.GenericNullableRefedInterface)event, new TypeArg<io.vertx.reactivex.codegen.testmodel.RefedInterface1>(o0 -> io.vertx.reactivex.codegen.testmodel.RefedInterface1.newInstance((io.vertx.codegen.testmodel.RefedInterface1)o0), o0 -> o0.getDelegate())));
      }
    });
  }

  public void methodWithHandlerAsyncResultGenericNullableApi(boolean notNull, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.codegen.testmodel.GenericNullableRefedInterface<io.vertx.reactivex.codegen.testmodel.RefedInterface1>>> handler) { 
    delegate.methodWithHandlerAsyncResultGenericNullableApi(notNull, new Handler<AsyncResult<io.vertx.codegen.testmodel.GenericNullableRefedInterface<io.vertx.codegen.testmodel.RefedInterface1>>>() {
      public void handle(AsyncResult<io.vertx.codegen.testmodel.GenericNullableRefedInterface<io.vertx.codegen.testmodel.RefedInterface1>> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.codegen.testmodel.GenericNullableRefedInterface.newInstance((io.vertx.codegen.testmodel.GenericNullableRefedInterface)ar.result(), new TypeArg<io.vertx.reactivex.codegen.testmodel.RefedInterface1>(o0 -> io.vertx.reactivex.codegen.testmodel.RefedInterface1.newInstance((io.vertx.codegen.testmodel.RefedInterface1)o0), o0 -> o0.getDelegate()))));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
  }

  public void methodWithHandlerAsyncResultGenericNullableApi(boolean notNull) {
    methodWithHandlerAsyncResultGenericNullableApi(notNull, ar -> { });
  }

  public io.reactivex.Single<io.vertx.reactivex.codegen.testmodel.GenericNullableRefedInterface<io.vertx.reactivex.codegen.testmodel.RefedInterface1>> rxMethodWithHandlerAsyncResultGenericNullableApi(boolean notNull) { 
    return AsyncResultSingle.toSingle($handler -> {
      methodWithHandlerAsyncResultGenericNullableApi(notNull, $handler);
    });
  }

  public io.vertx.reactivex.codegen.testmodel.GenericNullableRefedInterface<io.vertx.reactivex.codegen.testmodel.RefedInterface1> methodWithGenericNullableApiReturn(boolean notNull) { 
    io.vertx.reactivex.codegen.testmodel.GenericNullableRefedInterface<io.vertx.reactivex.codegen.testmodel.RefedInterface1> ret = io.vertx.reactivex.codegen.testmodel.GenericNullableRefedInterface.newInstance((io.vertx.codegen.testmodel.GenericNullableRefedInterface)delegate.methodWithGenericNullableApiReturn(notNull), TYPE_ARG_1);
    return ret;
  }

  public <T> io.vertx.reactivex.codegen.testmodel.GenericRefedInterface<T> methodWithParamInferedReturn(io.vertx.reactivex.codegen.testmodel.GenericRefedInterface<T> param) { 
    io.vertx.reactivex.codegen.testmodel.GenericRefedInterface<T> ret = io.vertx.reactivex.codegen.testmodel.GenericRefedInterface.newInstance((io.vertx.codegen.testmodel.GenericRefedInterface)delegate.methodWithParamInferedReturn(param.getDelegate()), param.__typeArg_0);
    return ret;
  }

  public <T> void methodWithHandlerParamInfered(io.vertx.reactivex.codegen.testmodel.GenericRefedInterface<T> param, io.vertx.core.Handler<io.vertx.reactivex.codegen.testmodel.GenericRefedInterface<T>> handler) { 
    delegate.methodWithHandlerParamInfered(param.getDelegate(), new Handler<io.vertx.codegen.testmodel.GenericRefedInterface<T>>() {
      public void handle(io.vertx.codegen.testmodel.GenericRefedInterface<T> event) {
        handler.handle(io.vertx.reactivex.codegen.testmodel.GenericRefedInterface.newInstance((io.vertx.codegen.testmodel.GenericRefedInterface)event, param.__typeArg_0));
      }
    });
  }

  public <T> void methodWithHandlerAsyncResultParamInfered(io.vertx.reactivex.codegen.testmodel.GenericRefedInterface<T> param, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.codegen.testmodel.GenericRefedInterface<T>>> handler) { 
    delegate.methodWithHandlerAsyncResultParamInfered(param.getDelegate(), new Handler<AsyncResult<io.vertx.codegen.testmodel.GenericRefedInterface<T>>>() {
      public void handle(AsyncResult<io.vertx.codegen.testmodel.GenericRefedInterface<T>> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.codegen.testmodel.GenericRefedInterface.newInstance((io.vertx.codegen.testmodel.GenericRefedInterface)ar.result(), param.__typeArg_0)));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
  }

  public <T> void methodWithHandlerAsyncResultParamInfered(io.vertx.reactivex.codegen.testmodel.GenericRefedInterface<T> param) {
    methodWithHandlerAsyncResultParamInfered(param, ar -> { });
  }

  public <T> io.reactivex.Single<io.vertx.reactivex.codegen.testmodel.GenericRefedInterface<T>> rxMethodWithHandlerAsyncResultParamInfered(io.vertx.reactivex.codegen.testmodel.GenericRefedInterface<T> param) { 
    return AsyncResultSingle.toSingle($handler -> {
      methodWithHandlerAsyncResultParamInfered(param, $handler);
    });
  }

  public static GenericsTCK newInstance(io.vertx.codegen.testmodel.GenericsTCK arg) {
    return arg != null ? new GenericsTCK(arg) : null;
  }

}
