/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.codegen.testmodel;

import io.vertx.reactivex.RxHelper;
import io.vertx.reactivex.ObservableHelper;
import io.vertx.reactivex.FlowableHelper;
import io.vertx.reactivex.impl.AsyncResultMaybe;
import io.vertx.reactivex.impl.AsyncResultSingle;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.WriteStreamObserver;
import io.vertx.reactivex.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;


@RxGen(io.vertx.codegen.testmodel.JsonMapperTCK.class)
public class JsonMapperTCK {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    JsonMapperTCK that = (JsonMapperTCK) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<JsonMapperTCK> __TYPE_ARG = new TypeArg<>(    obj -> new JsonMapperTCK((io.vertx.codegen.testmodel.JsonMapperTCK) obj),
    JsonMapperTCK::getDelegate
  );

  private final io.vertx.codegen.testmodel.JsonMapperTCK delegate;
  
  public JsonMapperTCK(io.vertx.codegen.testmodel.JsonMapperTCK delegate) {
    this.delegate = delegate;
  }

  public JsonMapperTCK(Object delegate) {
    this.delegate = (io.vertx.codegen.testmodel.JsonMapperTCK)delegate;
  }

  public io.vertx.codegen.testmodel.JsonMapperTCK getDelegate() {
    return delegate;
  }


  public void methodWithTypeToIntegerParam(io.vertx.codegen.testmodel.MyPojoToInteger myPojoToInteger) { 
    delegate.methodWithTypeToIntegerParam(myPojoToInteger);
  }

  public void methodWithListOfTypeToIntegerParam(java.util.List<io.vertx.codegen.testmodel.MyPojoToInteger> myPojoToIntegerList) { 
    delegate.methodWithListOfTypeToIntegerParam(myPojoToIntegerList);
  }

  public void methodWithSetOfTypeToIntegerParam(java.util.Set<io.vertx.codegen.testmodel.MyPojoToInteger> myPojoToIntegerSet) { 
    delegate.methodWithSetOfTypeToIntegerParam(myPojoToIntegerSet);
  }

  public void methodWithMapOfTypeToIntegerParam(java.util.Map<java.lang.String,io.vertx.codegen.testmodel.MyPojoToInteger> myPojoToIntegerMap) { 
    delegate.methodWithMapOfTypeToIntegerParam(myPojoToIntegerMap);
  }

  public io.vertx.codegen.testmodel.MyPojoToInteger methodWithTypeToIntegerReturn() { 
    io.vertx.codegen.testmodel.MyPojoToInteger ret = delegate.methodWithTypeToIntegerReturn();
    return ret;
  }

  public java.util.List<io.vertx.codegen.testmodel.MyPojoToInteger> methodWithListOfTypeToIntegerReturn() { 
    java.util.List<io.vertx.codegen.testmodel.MyPojoToInteger> ret = delegate.methodWithListOfTypeToIntegerReturn();
    return ret;
  }

  public java.util.Set<io.vertx.codegen.testmodel.MyPojoToInteger> methodWithSetOfTypeToIntegerReturn() { 
    java.util.Set<io.vertx.codegen.testmodel.MyPojoToInteger> ret = delegate.methodWithSetOfTypeToIntegerReturn();
    return ret;
  }

  public java.util.Map<java.lang.String,io.vertx.codegen.testmodel.MyPojoToInteger> methodWithMapOfTypeToIntegerReturn() { 
    java.util.Map<java.lang.String,io.vertx.codegen.testmodel.MyPojoToInteger> ret = delegate.methodWithMapOfTypeToIntegerReturn();
    return ret;
  }

  public void methodWithHandlerTypeToIntegerParam(io.vertx.core.Handler<io.vertx.codegen.testmodel.MyPojoToInteger> myPojoToIntegerHandler) { 
    delegate.methodWithHandlerTypeToIntegerParam(myPojoToIntegerHandler);
  }

  public void methodWithHandlerListOfTypeToIntegerParam(io.vertx.core.Handler<java.util.List<io.vertx.codegen.testmodel.MyPojoToInteger>> myPojoToIntegerListHandler) { 
    delegate.methodWithHandlerListOfTypeToIntegerParam(myPojoToIntegerListHandler);
  }

  public void methodWithHandlerSetOfTypeToIntegerParam(io.vertx.core.Handler<java.util.Set<io.vertx.codegen.testmodel.MyPojoToInteger>> myPojoToIntegerSetHandler) { 
    delegate.methodWithHandlerSetOfTypeToIntegerParam(myPojoToIntegerSetHandler);
  }

  public void methodWithHandlerMapOfTypeToIntegerParam(io.vertx.core.Handler<java.util.Map<java.lang.String,io.vertx.codegen.testmodel.MyPojoToInteger>> myPojoToIntegerMapHandler) { 
    delegate.methodWithHandlerMapOfTypeToIntegerParam(myPojoToIntegerMapHandler);
  }

  public void methodWithHandlerAsyncResultTypeToIntegerParam(io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.codegen.testmodel.MyPojoToInteger>> myPojoToIntegerHandler) { 
    delegate.methodWithHandlerAsyncResultTypeToIntegerParam(myPojoToIntegerHandler);
  }

  public void methodWithHandlerAsyncResultTypeToIntegerParam() {
    methodWithHandlerAsyncResultTypeToIntegerParam(ar -> { });
  }

  public io.reactivex.Single<io.vertx.codegen.testmodel.MyPojoToInteger> rxMethodWithHandlerAsyncResultTypeToIntegerParam() { 
    return AsyncResultSingle.toSingle($handler -> {
      methodWithHandlerAsyncResultTypeToIntegerParam($handler);
    });
  }

  public void methodWithHandlerAsyncResultListOfTypeToIntegerParam(io.vertx.core.Handler<io.vertx.core.AsyncResult<java.util.List<io.vertx.codegen.testmodel.MyPojoToInteger>>> myPojoToIntegerListHandler) { 
    delegate.methodWithHandlerAsyncResultListOfTypeToIntegerParam(myPojoToIntegerListHandler);
  }

  public void methodWithHandlerAsyncResultListOfTypeToIntegerParam() {
    methodWithHandlerAsyncResultListOfTypeToIntegerParam(ar -> { });
  }

  public io.reactivex.Single<java.util.List<io.vertx.codegen.testmodel.MyPojoToInteger>> rxMethodWithHandlerAsyncResultListOfTypeToIntegerParam() { 
    return AsyncResultSingle.toSingle($handler -> {
      methodWithHandlerAsyncResultListOfTypeToIntegerParam($handler);
    });
  }

  public void methodWithHandlerAsyncResultSetOfTypeToIntegerParam(io.vertx.core.Handler<io.vertx.core.AsyncResult<java.util.Set<io.vertx.codegen.testmodel.MyPojoToInteger>>> myPojoToIntegerSetHandler) { 
    delegate.methodWithHandlerAsyncResultSetOfTypeToIntegerParam(myPojoToIntegerSetHandler);
  }

  public void methodWithHandlerAsyncResultSetOfTypeToIntegerParam() {
    methodWithHandlerAsyncResultSetOfTypeToIntegerParam(ar -> { });
  }

  public io.reactivex.Single<java.util.Set<io.vertx.codegen.testmodel.MyPojoToInteger>> rxMethodWithHandlerAsyncResultSetOfTypeToIntegerParam() { 
    return AsyncResultSingle.toSingle($handler -> {
      methodWithHandlerAsyncResultSetOfTypeToIntegerParam($handler);
    });
  }

  public void methodWithHandlerAsyncResultMapOfTypeToIntegerParam(io.vertx.core.Handler<io.vertx.core.AsyncResult<java.util.Map<java.lang.String,io.vertx.codegen.testmodel.MyPojoToInteger>>> myPojoToIntegerMapHandler) { 
    delegate.methodWithHandlerAsyncResultMapOfTypeToIntegerParam(myPojoToIntegerMapHandler);
  }

  public void methodWithHandlerAsyncResultMapOfTypeToIntegerParam() {
    methodWithHandlerAsyncResultMapOfTypeToIntegerParam(ar -> { });
  }

  public io.reactivex.Single<java.util.Map<java.lang.String,io.vertx.codegen.testmodel.MyPojoToInteger>> rxMethodWithHandlerAsyncResultMapOfTypeToIntegerParam() { 
    return AsyncResultSingle.toSingle($handler -> {
      methodWithHandlerAsyncResultMapOfTypeToIntegerParam($handler);
    });
  }

  public void methodWithTypeToStringParam(java.time.ZonedDateTime zonedDateTime) { 
    delegate.methodWithTypeToStringParam(zonedDateTime);
  }

  public void methodWithListOfTypeToStringParam(java.util.List<java.time.ZonedDateTime> zonedDateTimeList) { 
    delegate.methodWithListOfTypeToStringParam(zonedDateTimeList);
  }

  public void methodWithSetOfTypeToStringParam(java.util.Set<java.time.ZonedDateTime> zonedDateTimeSet) { 
    delegate.methodWithSetOfTypeToStringParam(zonedDateTimeSet);
  }

  public void methodWithMapOfTypeToStringParam(java.util.Map<java.lang.String,java.time.ZonedDateTime> zonedDateTimeMap) { 
    delegate.methodWithMapOfTypeToStringParam(zonedDateTimeMap);
  }

  public java.time.ZonedDateTime methodWithTypeToStringReturn() { 
    java.time.ZonedDateTime ret = delegate.methodWithTypeToStringReturn();
    return ret;
  }

  public java.util.List<java.time.ZonedDateTime> methodWithListOfTypeToStringReturn() { 
    java.util.List<java.time.ZonedDateTime> ret = delegate.methodWithListOfTypeToStringReturn();
    return ret;
  }

  public java.util.Set<java.time.ZonedDateTime> methodWithSetOfTypeToStringReturn() { 
    java.util.Set<java.time.ZonedDateTime> ret = delegate.methodWithSetOfTypeToStringReturn();
    return ret;
  }

  public java.util.Map<java.lang.String,java.time.ZonedDateTime> methodWithMapOfTypeToStringReturn() { 
    java.util.Map<java.lang.String,java.time.ZonedDateTime> ret = delegate.methodWithMapOfTypeToStringReturn();
    return ret;
  }

  public void methodWithHandlerTypeToStringParam(io.vertx.core.Handler<java.time.ZonedDateTime> zonedDateTimeHandler) { 
    delegate.methodWithHandlerTypeToStringParam(zonedDateTimeHandler);
  }

  public void methodWithHandlerListOfTypeToStringParam(io.vertx.core.Handler<java.util.List<java.time.ZonedDateTime>> zonedDateTimeListHandler) { 
    delegate.methodWithHandlerListOfTypeToStringParam(zonedDateTimeListHandler);
  }

  public void methodWithHandlerSetOfTypeToStringParam(io.vertx.core.Handler<java.util.Set<java.time.ZonedDateTime>> zonedDateTimeSetHandler) { 
    delegate.methodWithHandlerSetOfTypeToStringParam(zonedDateTimeSetHandler);
  }

  public void methodWithHandlerMapOfTypeToStringParam(io.vertx.core.Handler<java.util.Map<java.lang.String,java.time.ZonedDateTime>> zonedDateTimeMapHandler) { 
    delegate.methodWithHandlerMapOfTypeToStringParam(zonedDateTimeMapHandler);
  }

  public void methodWithHandlerAsyncResultTypeToStringParam(io.vertx.core.Handler<io.vertx.core.AsyncResult<java.time.ZonedDateTime>> zonedDateTimeHandler) { 
    delegate.methodWithHandlerAsyncResultTypeToStringParam(zonedDateTimeHandler);
  }

  public void methodWithHandlerAsyncResultTypeToStringParam() {
    methodWithHandlerAsyncResultTypeToStringParam(ar -> { });
  }

  public io.reactivex.Single<java.time.ZonedDateTime> rxMethodWithHandlerAsyncResultTypeToStringParam() { 
    return AsyncResultSingle.toSingle($handler -> {
      methodWithHandlerAsyncResultTypeToStringParam($handler);
    });
  }

  public void methodWithHandlerAsyncResultListOfTypeToStringParam(io.vertx.core.Handler<io.vertx.core.AsyncResult<java.util.List<java.time.ZonedDateTime>>> zonedDateTimeListHandler) { 
    delegate.methodWithHandlerAsyncResultListOfTypeToStringParam(zonedDateTimeListHandler);
  }

  public void methodWithHandlerAsyncResultListOfTypeToStringParam() {
    methodWithHandlerAsyncResultListOfTypeToStringParam(ar -> { });
  }

  public io.reactivex.Single<java.util.List<java.time.ZonedDateTime>> rxMethodWithHandlerAsyncResultListOfTypeToStringParam() { 
    return AsyncResultSingle.toSingle($handler -> {
      methodWithHandlerAsyncResultListOfTypeToStringParam($handler);
    });
  }

  public void methodWithHandlerAsyncResultSetOfTypeToStringParam(io.vertx.core.Handler<io.vertx.core.AsyncResult<java.util.Set<java.time.ZonedDateTime>>> zonedDateTimeSetHandler) { 
    delegate.methodWithHandlerAsyncResultSetOfTypeToStringParam(zonedDateTimeSetHandler);
  }

  public void methodWithHandlerAsyncResultSetOfTypeToStringParam() {
    methodWithHandlerAsyncResultSetOfTypeToStringParam(ar -> { });
  }

  public io.reactivex.Single<java.util.Set<java.time.ZonedDateTime>> rxMethodWithHandlerAsyncResultSetOfTypeToStringParam() { 
    return AsyncResultSingle.toSingle($handler -> {
      methodWithHandlerAsyncResultSetOfTypeToStringParam($handler);
    });
  }

  public void methodWithHandlerAsyncResultMapOfTypeToStringParam(io.vertx.core.Handler<io.vertx.core.AsyncResult<java.util.Map<java.lang.String,java.time.ZonedDateTime>>> zonedDateTimeMapHandler) { 
    delegate.methodWithHandlerAsyncResultMapOfTypeToStringParam(zonedDateTimeMapHandler);
  }

  public void methodWithHandlerAsyncResultMapOfTypeToStringParam() {
    methodWithHandlerAsyncResultMapOfTypeToStringParam(ar -> { });
  }

  public io.reactivex.Single<java.util.Map<java.lang.String,java.time.ZonedDateTime>> rxMethodWithHandlerAsyncResultMapOfTypeToStringParam() { 
    return AsyncResultSingle.toSingle($handler -> {
      methodWithHandlerAsyncResultMapOfTypeToStringParam($handler);
    });
  }

  public void methodWithTypeToJsonArrayParam(io.vertx.codegen.testmodel.MyPojoToJsonArray myPojoToJsonArray) { 
    delegate.methodWithTypeToJsonArrayParam(myPojoToJsonArray);
  }

  public void methodWithListOfTypeToJsonArrayParam(java.util.List<io.vertx.codegen.testmodel.MyPojoToJsonArray> myPojoToJsonArrayList) { 
    delegate.methodWithListOfTypeToJsonArrayParam(myPojoToJsonArrayList);
  }

  public void methodWithSetOfTypeToJsonArrayParam(java.util.Set<io.vertx.codegen.testmodel.MyPojoToJsonArray> myPojoToJsonArraySet) { 
    delegate.methodWithSetOfTypeToJsonArrayParam(myPojoToJsonArraySet);
  }

  public void methodWithMapOfTypeToJsonArrayParam(java.util.Map<java.lang.String,io.vertx.codegen.testmodel.MyPojoToJsonArray> myPojoToJsonArrayMap) { 
    delegate.methodWithMapOfTypeToJsonArrayParam(myPojoToJsonArrayMap);
  }

  public io.vertx.codegen.testmodel.MyPojoToJsonArray methodWithTypeToJsonArrayReturn() { 
    io.vertx.codegen.testmodel.MyPojoToJsonArray ret = delegate.methodWithTypeToJsonArrayReturn();
    return ret;
  }

  public java.util.List<io.vertx.codegen.testmodel.MyPojoToJsonArray> methodWithListOfTypeToJsonArrayReturn() { 
    java.util.List<io.vertx.codegen.testmodel.MyPojoToJsonArray> ret = delegate.methodWithListOfTypeToJsonArrayReturn();
    return ret;
  }

  public java.util.Set<io.vertx.codegen.testmodel.MyPojoToJsonArray> methodWithSetOfTypeToJsonArrayReturn() { 
    java.util.Set<io.vertx.codegen.testmodel.MyPojoToJsonArray> ret = delegate.methodWithSetOfTypeToJsonArrayReturn();
    return ret;
  }

  public java.util.Map<java.lang.String,io.vertx.codegen.testmodel.MyPojoToJsonArray> methodWithMapOfTypeToJsonArrayReturn() { 
    java.util.Map<java.lang.String,io.vertx.codegen.testmodel.MyPojoToJsonArray> ret = delegate.methodWithMapOfTypeToJsonArrayReturn();
    return ret;
  }

  public void methodWithHandlerTypeToJsonArrayParam(io.vertx.core.Handler<io.vertx.codegen.testmodel.MyPojoToJsonArray> myPojoToJsonArrayHandler) { 
    delegate.methodWithHandlerTypeToJsonArrayParam(myPojoToJsonArrayHandler);
  }

  public void methodWithHandlerListOfTypeToJsonArrayParam(io.vertx.core.Handler<java.util.List<io.vertx.codegen.testmodel.MyPojoToJsonArray>> myPojoToJsonArrayListHandler) { 
    delegate.methodWithHandlerListOfTypeToJsonArrayParam(myPojoToJsonArrayListHandler);
  }

  public void methodWithHandlerSetOfTypeToJsonArrayParam(io.vertx.core.Handler<java.util.Set<io.vertx.codegen.testmodel.MyPojoToJsonArray>> myPojoToJsonArraySetHandler) { 
    delegate.methodWithHandlerSetOfTypeToJsonArrayParam(myPojoToJsonArraySetHandler);
  }

  public void methodWithHandlerMapOfTypeToJsonArrayParam(io.vertx.core.Handler<java.util.Map<java.lang.String,io.vertx.codegen.testmodel.MyPojoToJsonArray>> myPojoToJsonArrayMapHandler) { 
    delegate.methodWithHandlerMapOfTypeToJsonArrayParam(myPojoToJsonArrayMapHandler);
  }

  public void methodWithHandlerAsyncResultTypeToJsonArrayParam(io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.codegen.testmodel.MyPojoToJsonArray>> myPojoToJsonArrayHandler) { 
    delegate.methodWithHandlerAsyncResultTypeToJsonArrayParam(myPojoToJsonArrayHandler);
  }

  public void methodWithHandlerAsyncResultTypeToJsonArrayParam() {
    methodWithHandlerAsyncResultTypeToJsonArrayParam(ar -> { });
  }

  public io.reactivex.Single<io.vertx.codegen.testmodel.MyPojoToJsonArray> rxMethodWithHandlerAsyncResultTypeToJsonArrayParam() { 
    return AsyncResultSingle.toSingle($handler -> {
      methodWithHandlerAsyncResultTypeToJsonArrayParam($handler);
    });
  }

  public void methodWithHandlerAsyncResultListOfTypeToJsonArrayParam(io.vertx.core.Handler<io.vertx.core.AsyncResult<java.util.List<io.vertx.codegen.testmodel.MyPojoToJsonArray>>> myPojoToJsonArrayListHandler) { 
    delegate.methodWithHandlerAsyncResultListOfTypeToJsonArrayParam(myPojoToJsonArrayListHandler);
  }

  public void methodWithHandlerAsyncResultListOfTypeToJsonArrayParam() {
    methodWithHandlerAsyncResultListOfTypeToJsonArrayParam(ar -> { });
  }

  public io.reactivex.Single<java.util.List<io.vertx.codegen.testmodel.MyPojoToJsonArray>> rxMethodWithHandlerAsyncResultListOfTypeToJsonArrayParam() { 
    return AsyncResultSingle.toSingle($handler -> {
      methodWithHandlerAsyncResultListOfTypeToJsonArrayParam($handler);
    });
  }

  public void methodWithHandlerAsyncResultSetOfTypeToJsonArrayParam(io.vertx.core.Handler<io.vertx.core.AsyncResult<java.util.Set<io.vertx.codegen.testmodel.MyPojoToJsonArray>>> myPojoToJsonArraySetHandler) { 
    delegate.methodWithHandlerAsyncResultSetOfTypeToJsonArrayParam(myPojoToJsonArraySetHandler);
  }

  public void methodWithHandlerAsyncResultSetOfTypeToJsonArrayParam() {
    methodWithHandlerAsyncResultSetOfTypeToJsonArrayParam(ar -> { });
  }

  public io.reactivex.Single<java.util.Set<io.vertx.codegen.testmodel.MyPojoToJsonArray>> rxMethodWithHandlerAsyncResultSetOfTypeToJsonArrayParam() { 
    return AsyncResultSingle.toSingle($handler -> {
      methodWithHandlerAsyncResultSetOfTypeToJsonArrayParam($handler);
    });
  }

  public void methodWithHandlerAsyncResultMapOfTypeToJsonArrayParam(io.vertx.core.Handler<io.vertx.core.AsyncResult<java.util.Map<java.lang.String,io.vertx.codegen.testmodel.MyPojoToJsonArray>>> myPojoToJsonArrayMapHandler) { 
    delegate.methodWithHandlerAsyncResultMapOfTypeToJsonArrayParam(myPojoToJsonArrayMapHandler);
  }

  public void methodWithHandlerAsyncResultMapOfTypeToJsonArrayParam() {
    methodWithHandlerAsyncResultMapOfTypeToJsonArrayParam(ar -> { });
  }

  public io.reactivex.Single<java.util.Map<java.lang.String,io.vertx.codegen.testmodel.MyPojoToJsonArray>> rxMethodWithHandlerAsyncResultMapOfTypeToJsonArrayParam() { 
    return AsyncResultSingle.toSingle($handler -> {
      methodWithHandlerAsyncResultMapOfTypeToJsonArrayParam($handler);
    });
  }

  public void methodWithTypeToJsonObjectParam(io.vertx.codegen.testmodel.MyPojoToJsonObject myPojoToJsonObject) { 
    delegate.methodWithTypeToJsonObjectParam(myPojoToJsonObject);
  }

  public void methodWithListOfTypeToJsonObjectParam(java.util.List<io.vertx.codegen.testmodel.MyPojoToJsonObject> myPojoToJsonObjectList) { 
    delegate.methodWithListOfTypeToJsonObjectParam(myPojoToJsonObjectList);
  }

  public void methodWithSetOfTypeToJsonObjectParam(java.util.Set<io.vertx.codegen.testmodel.MyPojoToJsonObject> myPojoToJsonObjectSet) { 
    delegate.methodWithSetOfTypeToJsonObjectParam(myPojoToJsonObjectSet);
  }

  public void methodWithMapOfTypeToJsonObjectParam(java.util.Map<java.lang.String,io.vertx.codegen.testmodel.MyPojoToJsonObject> myPojoToJsonObjectMap) { 
    delegate.methodWithMapOfTypeToJsonObjectParam(myPojoToJsonObjectMap);
  }

  public io.vertx.codegen.testmodel.MyPojoToJsonObject methodWithTypeToJsonObjectReturn() { 
    io.vertx.codegen.testmodel.MyPojoToJsonObject ret = delegate.methodWithTypeToJsonObjectReturn();
    return ret;
  }

  public java.util.List<io.vertx.codegen.testmodel.MyPojoToJsonObject> methodWithListOfTypeToJsonObjectReturn() { 
    java.util.List<io.vertx.codegen.testmodel.MyPojoToJsonObject> ret = delegate.methodWithListOfTypeToJsonObjectReturn();
    return ret;
  }

  public java.util.Set<io.vertx.codegen.testmodel.MyPojoToJsonObject> methodWithSetOfTypeToJsonObjectReturn() { 
    java.util.Set<io.vertx.codegen.testmodel.MyPojoToJsonObject> ret = delegate.methodWithSetOfTypeToJsonObjectReturn();
    return ret;
  }

  public java.util.Map<java.lang.String,io.vertx.codegen.testmodel.MyPojoToJsonObject> methodWithMapOfTypeToJsonObjectReturn() { 
    java.util.Map<java.lang.String,io.vertx.codegen.testmodel.MyPojoToJsonObject> ret = delegate.methodWithMapOfTypeToJsonObjectReturn();
    return ret;
  }

  public void methodWithHandlerTypeToJsonObjectParam(io.vertx.core.Handler<io.vertx.codegen.testmodel.MyPojoToJsonObject> myPojoToJsonObjectHandler) { 
    delegate.methodWithHandlerTypeToJsonObjectParam(myPojoToJsonObjectHandler);
  }

  public void methodWithHandlerListOfTypeToJsonObjectParam(io.vertx.core.Handler<java.util.List<io.vertx.codegen.testmodel.MyPojoToJsonObject>> myPojoToJsonObjectListHandler) { 
    delegate.methodWithHandlerListOfTypeToJsonObjectParam(myPojoToJsonObjectListHandler);
  }

  public void methodWithHandlerSetOfTypeToJsonObjectParam(io.vertx.core.Handler<java.util.Set<io.vertx.codegen.testmodel.MyPojoToJsonObject>> myPojoToJsonObjectSetHandler) { 
    delegate.methodWithHandlerSetOfTypeToJsonObjectParam(myPojoToJsonObjectSetHandler);
  }

  public void methodWithHandlerMapOfTypeToJsonObjectParam(io.vertx.core.Handler<java.util.Map<java.lang.String,io.vertx.codegen.testmodel.MyPojoToJsonObject>> myPojoToJsonObjectMapHandler) { 
    delegate.methodWithHandlerMapOfTypeToJsonObjectParam(myPojoToJsonObjectMapHandler);
  }

  public void methodWithHandlerAsyncResultTypeToJsonObjectParam(io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.codegen.testmodel.MyPojoToJsonObject>> myPojoToJsonObjectHandler) { 
    delegate.methodWithHandlerAsyncResultTypeToJsonObjectParam(myPojoToJsonObjectHandler);
  }

  public void methodWithHandlerAsyncResultTypeToJsonObjectParam() {
    methodWithHandlerAsyncResultTypeToJsonObjectParam(ar -> { });
  }

  public io.reactivex.Single<io.vertx.codegen.testmodel.MyPojoToJsonObject> rxMethodWithHandlerAsyncResultTypeToJsonObjectParam() { 
    return AsyncResultSingle.toSingle($handler -> {
      methodWithHandlerAsyncResultTypeToJsonObjectParam($handler);
    });
  }

  public void methodWithHandlerAsyncResultListOfTypeToJsonObjectParam(io.vertx.core.Handler<io.vertx.core.AsyncResult<java.util.List<io.vertx.codegen.testmodel.MyPojoToJsonObject>>> myPojoToJsonObjectListHandler) { 
    delegate.methodWithHandlerAsyncResultListOfTypeToJsonObjectParam(myPojoToJsonObjectListHandler);
  }

  public void methodWithHandlerAsyncResultListOfTypeToJsonObjectParam() {
    methodWithHandlerAsyncResultListOfTypeToJsonObjectParam(ar -> { });
  }

  public io.reactivex.Single<java.util.List<io.vertx.codegen.testmodel.MyPojoToJsonObject>> rxMethodWithHandlerAsyncResultListOfTypeToJsonObjectParam() { 
    return AsyncResultSingle.toSingle($handler -> {
      methodWithHandlerAsyncResultListOfTypeToJsonObjectParam($handler);
    });
  }

  public void methodWithHandlerAsyncResultSetOfTypeToJsonObjectParam(io.vertx.core.Handler<io.vertx.core.AsyncResult<java.util.Set<io.vertx.codegen.testmodel.MyPojoToJsonObject>>> myPojoToJsonObjectSetHandler) { 
    delegate.methodWithHandlerAsyncResultSetOfTypeToJsonObjectParam(myPojoToJsonObjectSetHandler);
  }

  public void methodWithHandlerAsyncResultSetOfTypeToJsonObjectParam() {
    methodWithHandlerAsyncResultSetOfTypeToJsonObjectParam(ar -> { });
  }

  public io.reactivex.Single<java.util.Set<io.vertx.codegen.testmodel.MyPojoToJsonObject>> rxMethodWithHandlerAsyncResultSetOfTypeToJsonObjectParam() { 
    return AsyncResultSingle.toSingle($handler -> {
      methodWithHandlerAsyncResultSetOfTypeToJsonObjectParam($handler);
    });
  }

  public void methodWithHandlerAsyncResultMapOfTypeToJsonObjectParam(io.vertx.core.Handler<io.vertx.core.AsyncResult<java.util.Map<java.lang.String,io.vertx.codegen.testmodel.MyPojoToJsonObject>>> myPojoToJsonObjectMapHandler) { 
    delegate.methodWithHandlerAsyncResultMapOfTypeToJsonObjectParam(myPojoToJsonObjectMapHandler);
  }

  public void methodWithHandlerAsyncResultMapOfTypeToJsonObjectParam() {
    methodWithHandlerAsyncResultMapOfTypeToJsonObjectParam(ar -> { });
  }

  public io.reactivex.Single<java.util.Map<java.lang.String,io.vertx.codegen.testmodel.MyPojoToJsonObject>> rxMethodWithHandlerAsyncResultMapOfTypeToJsonObjectParam() { 
    return AsyncResultSingle.toSingle($handler -> {
      methodWithHandlerAsyncResultMapOfTypeToJsonObjectParam($handler);
    });
  }

  public static JsonMapperTCK newInstance(io.vertx.codegen.testmodel.JsonMapperTCK arg) {
    return arg != null ? new JsonMapperTCK(arg) : null;
  }

}
