/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.codegen.testmodel;

import io.vertx.reactivex.RxHelper;
import io.vertx.reactivex.ObservableHelper;
import io.vertx.reactivex.FlowableHelper;
import io.vertx.reactivex.impl.AsyncResultMaybe;
import io.vertx.reactivex.impl.AsyncResultSingle;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.WriteStreamObserver;
import io.vertx.reactivex.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * The TCK for @Nullable.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.codegen.testmodel.NullableTCK original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.codegen.testmodel.NullableTCK.class)
public class NullableTCK {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    NullableTCK that = (NullableTCK) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<NullableTCK> __TYPE_ARG = new TypeArg<>(    obj -> new NullableTCK((io.vertx.codegen.testmodel.NullableTCK) obj),
    NullableTCK::getDelegate
  );

  private final io.vertx.codegen.testmodel.NullableTCK delegate;
  
  public NullableTCK(io.vertx.codegen.testmodel.NullableTCK delegate) {
    this.delegate = delegate;
  }

  public NullableTCK(Object delegate) {
    this.delegate = (io.vertx.codegen.testmodel.NullableTCK)delegate;
  }

  public io.vertx.codegen.testmodel.NullableTCK getDelegate() {
    return delegate;
  }

  private static final TypeArg<io.vertx.reactivex.codegen.testmodel.RefedInterface1> TYPE_ARG_0 = new TypeArg<io.vertx.reactivex.codegen.testmodel.RefedInterface1>(o1 -> io.vertx.reactivex.codegen.testmodel.RefedInterface1.newInstance((io.vertx.codegen.testmodel.RefedInterface1)o1), o1 -> o1.getDelegate());
  private static final TypeArg<io.vertx.reactivex.codegen.testmodel.RefedInterface1> TYPE_ARG_1 = new TypeArg<io.vertx.reactivex.codegen.testmodel.RefedInterface1>(o1 -> io.vertx.reactivex.codegen.testmodel.RefedInterface1.newInstance((io.vertx.codegen.testmodel.RefedInterface1)o1), o1 -> o1.getDelegate());
  private static final TypeArg<io.vertx.reactivex.codegen.testmodel.RefedInterface1> TYPE_ARG_2 = new TypeArg<io.vertx.reactivex.codegen.testmodel.RefedInterface1>(o1 -> io.vertx.reactivex.codegen.testmodel.RefedInterface1.newInstance((io.vertx.codegen.testmodel.RefedInterface1)o1), o1 -> o1.getDelegate());
  private static final TypeArg<io.vertx.reactivex.codegen.testmodel.RefedInterface1> TYPE_ARG_3 = new TypeArg<io.vertx.reactivex.codegen.testmodel.RefedInterface1>(o1 -> io.vertx.reactivex.codegen.testmodel.RefedInterface1.newInstance((io.vertx.codegen.testmodel.RefedInterface1)o1), o1 -> o1.getDelegate());

  public boolean methodWithNonNullableByteParam(java.lang.Byte param) { 
    boolean ret = delegate.methodWithNonNullableByteParam(param);
    return ret;
  }

  public void methodWithNullableByteParam(boolean expectNull, java.lang.Byte param) { 
    delegate.methodWithNullableByteParam(expectNull, param);
  }

  public void methodWithNullableByteHandler(boolean notNull, io.vertx.core.Handler<java.lang.Byte> handler) { 
    delegate.methodWithNullableByteHandler(notNull, handler);
  }

  public void methodWithNullableByteHandlerAsyncResult(boolean notNull, io.vertx.core.Handler<io.vertx.core.AsyncResult<java.lang.Byte>> handler) { 
    delegate.methodWithNullableByteHandlerAsyncResult(notNull, handler);
  }

  public void methodWithNullableByteHandlerAsyncResult(boolean notNull) {
    methodWithNullableByteHandlerAsyncResult(notNull, ar -> { });
  }

  public io.reactivex.Maybe<java.lang.Byte> rxMethodWithNullableByteHandlerAsyncResult(boolean notNull) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      methodWithNullableByteHandlerAsyncResult(notNull, $handler);
    });
  }

  public java.lang.Byte methodWithNullableByteReturn(boolean notNull) { 
    java.lang.Byte ret = delegate.methodWithNullableByteReturn(notNull);
    return ret;
  }

  public boolean methodWithNonNullableShortParam(java.lang.Short param) { 
    boolean ret = delegate.methodWithNonNullableShortParam(param);
    return ret;
  }

  public void methodWithNullableShortParam(boolean expectNull, java.lang.Short param) { 
    delegate.methodWithNullableShortParam(expectNull, param);
  }

  public void methodWithNullableShortHandler(boolean notNull, io.vertx.core.Handler<java.lang.Short> handler) { 
    delegate.methodWithNullableShortHandler(notNull, handler);
  }

  public void methodWithNullableShortHandlerAsyncResult(boolean notNull, io.vertx.core.Handler<io.vertx.core.AsyncResult<java.lang.Short>> handler) { 
    delegate.methodWithNullableShortHandlerAsyncResult(notNull, handler);
  }

  public void methodWithNullableShortHandlerAsyncResult(boolean notNull) {
    methodWithNullableShortHandlerAsyncResult(notNull, ar -> { });
  }

  public io.reactivex.Maybe<java.lang.Short> rxMethodWithNullableShortHandlerAsyncResult(boolean notNull) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      methodWithNullableShortHandlerAsyncResult(notNull, $handler);
    });
  }

  public java.lang.Short methodWithNullableShortReturn(boolean notNull) { 
    java.lang.Short ret = delegate.methodWithNullableShortReturn(notNull);
    return ret;
  }

  public boolean methodWithNonNullableIntegerParam(java.lang.Integer param) { 
    boolean ret = delegate.methodWithNonNullableIntegerParam(param);
    return ret;
  }

  public void methodWithNullableIntegerParam(boolean expectNull, java.lang.Integer param) { 
    delegate.methodWithNullableIntegerParam(expectNull, param);
  }

  public void methodWithNullableIntegerHandler(boolean notNull, io.vertx.core.Handler<java.lang.Integer> handler) { 
    delegate.methodWithNullableIntegerHandler(notNull, handler);
  }

  public void methodWithNullableIntegerHandlerAsyncResult(boolean notNull, io.vertx.core.Handler<io.vertx.core.AsyncResult<java.lang.Integer>> handler) { 
    delegate.methodWithNullableIntegerHandlerAsyncResult(notNull, handler);
  }

  public void methodWithNullableIntegerHandlerAsyncResult(boolean notNull) {
    methodWithNullableIntegerHandlerAsyncResult(notNull, ar -> { });
  }

  public io.reactivex.Maybe<java.lang.Integer> rxMethodWithNullableIntegerHandlerAsyncResult(boolean notNull) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      methodWithNullableIntegerHandlerAsyncResult(notNull, $handler);
    });
  }

  public java.lang.Integer methodWithNullableIntegerReturn(boolean notNull) { 
    java.lang.Integer ret = delegate.methodWithNullableIntegerReturn(notNull);
    return ret;
  }

  public boolean methodWithNonNullableLongParam(java.lang.Long param) { 
    boolean ret = delegate.methodWithNonNullableLongParam(param);
    return ret;
  }

  public void methodWithNullableLongParam(boolean expectNull, java.lang.Long param) { 
    delegate.methodWithNullableLongParam(expectNull, param);
  }

  public void methodWithNullableLongHandler(boolean notNull, io.vertx.core.Handler<java.lang.Long> handler) { 
    delegate.methodWithNullableLongHandler(notNull, handler);
  }

  public void methodWithNullableLongHandlerAsyncResult(boolean notNull, io.vertx.core.Handler<io.vertx.core.AsyncResult<java.lang.Long>> handler) { 
    delegate.methodWithNullableLongHandlerAsyncResult(notNull, handler);
  }

  public void methodWithNullableLongHandlerAsyncResult(boolean notNull) {
    methodWithNullableLongHandlerAsyncResult(notNull, ar -> { });
  }

  public io.reactivex.Maybe<java.lang.Long> rxMethodWithNullableLongHandlerAsyncResult(boolean notNull) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      methodWithNullableLongHandlerAsyncResult(notNull, $handler);
    });
  }

  public java.lang.Long methodWithNullableLongReturn(boolean notNull) { 
    java.lang.Long ret = delegate.methodWithNullableLongReturn(notNull);
    return ret;
  }

  public boolean methodWithNonNullableFloatParam(java.lang.Float param) { 
    boolean ret = delegate.methodWithNonNullableFloatParam(param);
    return ret;
  }

  public void methodWithNullableFloatParam(boolean expectNull, java.lang.Float param) { 
    delegate.methodWithNullableFloatParam(expectNull, param);
  }

  public void methodWithNullableFloatHandler(boolean notNull, io.vertx.core.Handler<java.lang.Float> handler) { 
    delegate.methodWithNullableFloatHandler(notNull, handler);
  }

  public void methodWithNullableFloatHandlerAsyncResult(boolean notNull, io.vertx.core.Handler<io.vertx.core.AsyncResult<java.lang.Float>> handler) { 
    delegate.methodWithNullableFloatHandlerAsyncResult(notNull, handler);
  }

  public void methodWithNullableFloatHandlerAsyncResult(boolean notNull) {
    methodWithNullableFloatHandlerAsyncResult(notNull, ar -> { });
  }

  public io.reactivex.Maybe<java.lang.Float> rxMethodWithNullableFloatHandlerAsyncResult(boolean notNull) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      methodWithNullableFloatHandlerAsyncResult(notNull, $handler);
    });
  }

  public java.lang.Float methodWithNullableFloatReturn(boolean notNull) { 
    java.lang.Float ret = delegate.methodWithNullableFloatReturn(notNull);
    return ret;
  }

  public boolean methodWithNonNullableDoubleParam(java.lang.Double param) { 
    boolean ret = delegate.methodWithNonNullableDoubleParam(param);
    return ret;
  }

  public void methodWithNullableDoubleParam(boolean expectNull, java.lang.Double param) { 
    delegate.methodWithNullableDoubleParam(expectNull, param);
  }

  public void methodWithNullableDoubleHandler(boolean notNull, io.vertx.core.Handler<java.lang.Double> handler) { 
    delegate.methodWithNullableDoubleHandler(notNull, handler);
  }

  public void methodWithNullableDoubleHandlerAsyncResult(boolean notNull, io.vertx.core.Handler<io.vertx.core.AsyncResult<java.lang.Double>> handler) { 
    delegate.methodWithNullableDoubleHandlerAsyncResult(notNull, handler);
  }

  public void methodWithNullableDoubleHandlerAsyncResult(boolean notNull) {
    methodWithNullableDoubleHandlerAsyncResult(notNull, ar -> { });
  }

  public io.reactivex.Maybe<java.lang.Double> rxMethodWithNullableDoubleHandlerAsyncResult(boolean notNull) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      methodWithNullableDoubleHandlerAsyncResult(notNull, $handler);
    });
  }

  public java.lang.Double methodWithNullableDoubleReturn(boolean notNull) { 
    java.lang.Double ret = delegate.methodWithNullableDoubleReturn(notNull);
    return ret;
  }

  public boolean methodWithNonNullableBooleanParam(java.lang.Boolean param) { 
    boolean ret = delegate.methodWithNonNullableBooleanParam(param);
    return ret;
  }

  public void methodWithNullableBooleanParam(boolean expectNull, java.lang.Boolean param) { 
    delegate.methodWithNullableBooleanParam(expectNull, param);
  }

  public void methodWithNullableBooleanHandler(boolean notNull, io.vertx.core.Handler<java.lang.Boolean> handler) { 
    delegate.methodWithNullableBooleanHandler(notNull, handler);
  }

  public void methodWithNullableBooleanHandlerAsyncResult(boolean notNull, io.vertx.core.Handler<io.vertx.core.AsyncResult<java.lang.Boolean>> handler) { 
    delegate.methodWithNullableBooleanHandlerAsyncResult(notNull, handler);
  }

  public void methodWithNullableBooleanHandlerAsyncResult(boolean notNull) {
    methodWithNullableBooleanHandlerAsyncResult(notNull, ar -> { });
  }

  public io.reactivex.Maybe<java.lang.Boolean> rxMethodWithNullableBooleanHandlerAsyncResult(boolean notNull) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      methodWithNullableBooleanHandlerAsyncResult(notNull, $handler);
    });
  }

  public java.lang.Boolean methodWithNullableBooleanReturn(boolean notNull) { 
    java.lang.Boolean ret = delegate.methodWithNullableBooleanReturn(notNull);
    return ret;
  }

  public boolean methodWithNonNullableStringParam(java.lang.String param) { 
    boolean ret = delegate.methodWithNonNullableStringParam(param);
    return ret;
  }

  public void methodWithNullableStringParam(boolean expectNull, java.lang.String param) { 
    delegate.methodWithNullableStringParam(expectNull, param);
  }

  public void methodWithNullableStringHandler(boolean notNull, io.vertx.core.Handler<java.lang.String> handler) { 
    delegate.methodWithNullableStringHandler(notNull, handler);
  }

  public void methodWithNullableStringHandlerAsyncResult(boolean notNull, io.vertx.core.Handler<io.vertx.core.AsyncResult<java.lang.String>> handler) { 
    delegate.methodWithNullableStringHandlerAsyncResult(notNull, handler);
  }

  public void methodWithNullableStringHandlerAsyncResult(boolean notNull) {
    methodWithNullableStringHandlerAsyncResult(notNull, ar -> { });
  }

  public io.reactivex.Maybe<java.lang.String> rxMethodWithNullableStringHandlerAsyncResult(boolean notNull) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      methodWithNullableStringHandlerAsyncResult(notNull, $handler);
    });
  }

  public java.lang.String methodWithNullableStringReturn(boolean notNull) { 
    java.lang.String ret = delegate.methodWithNullableStringReturn(notNull);
    return ret;
  }

  public boolean methodWithNonNullableCharParam(java.lang.Character param) { 
    boolean ret = delegate.methodWithNonNullableCharParam(param);
    return ret;
  }

  public void methodWithNullableCharParam(boolean expectNull, java.lang.Character param) { 
    delegate.methodWithNullableCharParam(expectNull, param);
  }

  public void methodWithNullableCharHandler(boolean notNull, io.vertx.core.Handler<java.lang.Character> handler) { 
    delegate.methodWithNullableCharHandler(notNull, handler);
  }

  public void methodWithNullableCharHandlerAsyncResult(boolean notNull, io.vertx.core.Handler<io.vertx.core.AsyncResult<java.lang.Character>> handler) { 
    delegate.methodWithNullableCharHandlerAsyncResult(notNull, handler);
  }

  public void methodWithNullableCharHandlerAsyncResult(boolean notNull) {
    methodWithNullableCharHandlerAsyncResult(notNull, ar -> { });
  }

  public io.reactivex.Maybe<java.lang.Character> rxMethodWithNullableCharHandlerAsyncResult(boolean notNull) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      methodWithNullableCharHandlerAsyncResult(notNull, $handler);
    });
  }

  public java.lang.Character methodWithNullableCharReturn(boolean notNull) { 
    java.lang.Character ret = delegate.methodWithNullableCharReturn(notNull);
    return ret;
  }

  public boolean methodWithNonNullableJsonObjectParam(io.vertx.core.json.JsonObject param) { 
    boolean ret = delegate.methodWithNonNullableJsonObjectParam(param);
    return ret;
  }

  public void methodWithNullableJsonObjectParam(boolean expectNull, io.vertx.core.json.JsonObject param) { 
    delegate.methodWithNullableJsonObjectParam(expectNull, param);
  }

  public void methodWithNullableJsonObjectHandler(boolean notNull, io.vertx.core.Handler<io.vertx.core.json.JsonObject> handler) { 
    delegate.methodWithNullableJsonObjectHandler(notNull, handler);
  }

  public void methodWithNullableJsonObjectHandlerAsyncResult(boolean notNull, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.core.json.JsonObject>> handler) { 
    delegate.methodWithNullableJsonObjectHandlerAsyncResult(notNull, handler);
  }

  public void methodWithNullableJsonObjectHandlerAsyncResult(boolean notNull) {
    methodWithNullableJsonObjectHandlerAsyncResult(notNull, ar -> { });
  }

  public io.reactivex.Maybe<io.vertx.core.json.JsonObject> rxMethodWithNullableJsonObjectHandlerAsyncResult(boolean notNull) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      methodWithNullableJsonObjectHandlerAsyncResult(notNull, $handler);
    });
  }

  public io.vertx.core.json.JsonObject methodWithNullableJsonObjectReturn(boolean notNull) { 
    io.vertx.core.json.JsonObject ret = delegate.methodWithNullableJsonObjectReturn(notNull);
    return ret;
  }

  public boolean methodWithNonNullableJsonArrayParam(io.vertx.core.json.JsonArray param) { 
    boolean ret = delegate.methodWithNonNullableJsonArrayParam(param);
    return ret;
  }

  public void methodWithNullableJsonArrayParam(boolean expectNull, io.vertx.core.json.JsonArray param) { 
    delegate.methodWithNullableJsonArrayParam(expectNull, param);
  }

  public void methodWithNullableJsonArrayHandler(boolean notNull, io.vertx.core.Handler<io.vertx.core.json.JsonArray> handler) { 
    delegate.methodWithNullableJsonArrayHandler(notNull, handler);
  }

  public void methodWithNullableJsonArrayHandlerAsyncResult(boolean notNull, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.core.json.JsonArray>> handler) { 
    delegate.methodWithNullableJsonArrayHandlerAsyncResult(notNull, handler);
  }

  public void methodWithNullableJsonArrayHandlerAsyncResult(boolean notNull) {
    methodWithNullableJsonArrayHandlerAsyncResult(notNull, ar -> { });
  }

  public io.reactivex.Maybe<io.vertx.core.json.JsonArray> rxMethodWithNullableJsonArrayHandlerAsyncResult(boolean notNull) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      methodWithNullableJsonArrayHandlerAsyncResult(notNull, $handler);
    });
  }

  public io.vertx.core.json.JsonArray methodWithNullableJsonArrayReturn(boolean notNull) { 
    io.vertx.core.json.JsonArray ret = delegate.methodWithNullableJsonArrayReturn(notNull);
    return ret;
  }

  public boolean methodWithNonNullableApiParam(io.vertx.reactivex.codegen.testmodel.RefedInterface1 param) { 
    boolean ret = delegate.methodWithNonNullableApiParam(param.getDelegate());
    return ret;
  }

  public void methodWithNullableApiParam(boolean expectNull, io.vertx.reactivex.codegen.testmodel.RefedInterface1 param) { 
    delegate.methodWithNullableApiParam(expectNull, param.getDelegate());
  }

  public void methodWithNullableApiHandler(boolean notNull, io.vertx.core.Handler<io.vertx.reactivex.codegen.testmodel.RefedInterface1> handler) { 
    delegate.methodWithNullableApiHandler(notNull, new Handler<io.vertx.codegen.testmodel.RefedInterface1>() {
      public void handle(io.vertx.codegen.testmodel.RefedInterface1 event) {
        handler.handle(io.vertx.reactivex.codegen.testmodel.RefedInterface1.newInstance((io.vertx.codegen.testmodel.RefedInterface1)event));
      }
    });
  }

  public void methodWithNullableApiHandlerAsyncResult(boolean notNull, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.codegen.testmodel.RefedInterface1>> handler) { 
    delegate.methodWithNullableApiHandlerAsyncResult(notNull, new Handler<AsyncResult<io.vertx.codegen.testmodel.RefedInterface1>>() {
      public void handle(AsyncResult<io.vertx.codegen.testmodel.RefedInterface1> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.codegen.testmodel.RefedInterface1.newInstance((io.vertx.codegen.testmodel.RefedInterface1)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
  }

  public void methodWithNullableApiHandlerAsyncResult(boolean notNull) {
    methodWithNullableApiHandlerAsyncResult(notNull, ar -> { });
  }

  public io.reactivex.Maybe<io.vertx.reactivex.codegen.testmodel.RefedInterface1> rxMethodWithNullableApiHandlerAsyncResult(boolean notNull) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      methodWithNullableApiHandlerAsyncResult(notNull, $handler);
    });
  }

  public io.vertx.reactivex.codegen.testmodel.RefedInterface1 methodWithNullableApiReturn(boolean notNull) { 
    io.vertx.reactivex.codegen.testmodel.RefedInterface1 ret = io.vertx.reactivex.codegen.testmodel.RefedInterface1.newInstance((io.vertx.codegen.testmodel.RefedInterface1)delegate.methodWithNullableApiReturn(notNull));
    return ret;
  }

  public boolean methodWithNonNullableDataObjectParam(io.vertx.codegen.testmodel.TestDataObject param) { 
    boolean ret = delegate.methodWithNonNullableDataObjectParam(param);
    return ret;
  }

  public void methodWithNullableDataObjectParam(boolean expectNull, io.vertx.codegen.testmodel.TestDataObject param) { 
    delegate.methodWithNullableDataObjectParam(expectNull, param);
  }

  public void methodWithNullableDataObjectHandler(boolean notNull, io.vertx.core.Handler<io.vertx.codegen.testmodel.TestDataObject> handler) { 
    delegate.methodWithNullableDataObjectHandler(notNull, handler);
  }

  public void methodWithNullableDataObjectHandlerAsyncResult(boolean notNull, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.codegen.testmodel.TestDataObject>> handler) { 
    delegate.methodWithNullableDataObjectHandlerAsyncResult(notNull, handler);
  }

  public void methodWithNullableDataObjectHandlerAsyncResult(boolean notNull) {
    methodWithNullableDataObjectHandlerAsyncResult(notNull, ar -> { });
  }

  public io.reactivex.Maybe<io.vertx.codegen.testmodel.TestDataObject> rxMethodWithNullableDataObjectHandlerAsyncResult(boolean notNull) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      methodWithNullableDataObjectHandlerAsyncResult(notNull, $handler);
    });
  }

  public io.vertx.codegen.testmodel.TestDataObject methodWithNullableDataObjectReturn(boolean notNull) { 
    io.vertx.codegen.testmodel.TestDataObject ret = delegate.methodWithNullableDataObjectReturn(notNull);
    return ret;
  }

  public boolean methodWithNonNullableJsonMappedParam(java.time.ZonedDateTime param) { 
    boolean ret = delegate.methodWithNonNullableJsonMappedParam(param);
    return ret;
  }

  public void methodWithNullableJsonMappedParam(boolean expectNull, java.time.ZonedDateTime param) { 
    delegate.methodWithNullableJsonMappedParam(expectNull, param);
  }

  public void methodWithNullableJsonMappedHandler(boolean notNull, io.vertx.core.Handler<java.time.ZonedDateTime> handler) { 
    delegate.methodWithNullableJsonMappedHandler(notNull, handler);
  }

  public void methodWithNullableJsonMappedHandlerAsyncResult(boolean notNull, io.vertx.core.Handler<io.vertx.core.AsyncResult<java.time.ZonedDateTime>> handler) { 
    delegate.methodWithNullableJsonMappedHandlerAsyncResult(notNull, handler);
  }

  public void methodWithNullableJsonMappedHandlerAsyncResult(boolean notNull) {
    methodWithNullableJsonMappedHandlerAsyncResult(notNull, ar -> { });
  }

  public io.reactivex.Maybe<java.time.ZonedDateTime> rxMethodWithNullableJsonMappedHandlerAsyncResult(boolean notNull) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      methodWithNullableJsonMappedHandlerAsyncResult(notNull, $handler);
    });
  }

  public java.time.ZonedDateTime methodWithNullableJsonMappedReturn(boolean notNull) { 
    java.time.ZonedDateTime ret = delegate.methodWithNullableJsonMappedReturn(notNull);
    return ret;
  }

  public boolean methodWithNonNullableEnumParam(io.vertx.codegen.testmodel.TestEnum param) { 
    boolean ret = delegate.methodWithNonNullableEnumParam(param);
    return ret;
  }

  public void methodWithNullableEnumParam(boolean expectNull, io.vertx.codegen.testmodel.TestEnum param) { 
    delegate.methodWithNullableEnumParam(expectNull, param);
  }

  public void methodWithNullableEnumHandler(boolean notNull, io.vertx.core.Handler<io.vertx.codegen.testmodel.TestEnum> handler) { 
    delegate.methodWithNullableEnumHandler(notNull, handler);
  }

  public void methodWithNullableEnumHandlerAsyncResult(boolean notNull, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.codegen.testmodel.TestEnum>> handler) { 
    delegate.methodWithNullableEnumHandlerAsyncResult(notNull, handler);
  }

  public void methodWithNullableEnumHandlerAsyncResult(boolean notNull) {
    methodWithNullableEnumHandlerAsyncResult(notNull, ar -> { });
  }

  public io.reactivex.Maybe<io.vertx.codegen.testmodel.TestEnum> rxMethodWithNullableEnumHandlerAsyncResult(boolean notNull) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      methodWithNullableEnumHandlerAsyncResult(notNull, $handler);
    });
  }

  public io.vertx.codegen.testmodel.TestEnum methodWithNullableEnumReturn(boolean notNull) { 
    io.vertx.codegen.testmodel.TestEnum ret = delegate.methodWithNullableEnumReturn(notNull);
    return ret;
  }

  public boolean methodWithNonNullableGenEnumParam(io.vertx.codegen.testmodel.TestGenEnum param) { 
    boolean ret = delegate.methodWithNonNullableGenEnumParam(param);
    return ret;
  }

  public void methodWithNullableGenEnumParam(boolean expectNull, io.vertx.codegen.testmodel.TestGenEnum param) { 
    delegate.methodWithNullableGenEnumParam(expectNull, param);
  }

  public void methodWithNullableGenEnumHandler(boolean notNull, io.vertx.core.Handler<io.vertx.codegen.testmodel.TestGenEnum> handler) { 
    delegate.methodWithNullableGenEnumHandler(notNull, handler);
  }

  public void methodWithNullableGenEnumHandlerAsyncResult(boolean notNull, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.codegen.testmodel.TestGenEnum>> handler) { 
    delegate.methodWithNullableGenEnumHandlerAsyncResult(notNull, handler);
  }

  public void methodWithNullableGenEnumHandlerAsyncResult(boolean notNull) {
    methodWithNullableGenEnumHandlerAsyncResult(notNull, ar -> { });
  }

  public io.reactivex.Maybe<io.vertx.codegen.testmodel.TestGenEnum> rxMethodWithNullableGenEnumHandlerAsyncResult(boolean notNull) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      methodWithNullableGenEnumHandlerAsyncResult(notNull, $handler);
    });
  }

  public io.vertx.codegen.testmodel.TestGenEnum methodWithNullableGenEnumReturn(boolean notNull) { 
    io.vertx.codegen.testmodel.TestGenEnum ret = delegate.methodWithNullableGenEnumReturn(notNull);
    return ret;
  }

  public <T> void methodWithNullableTypeVariableParam(boolean expectNull, T param) { 
    delegate.methodWithNullableTypeVariableParam(expectNull, param);
  }

  public <T> void methodWithNullableTypeVariableHandler(boolean notNull, T value, io.vertx.core.Handler<T> handler) { 
    delegate.methodWithNullableTypeVariableHandler(notNull, value, handler);
  }

  public <T> void methodWithNullableTypeVariableHandlerAsyncResult(boolean notNull, T value, io.vertx.core.Handler<io.vertx.core.AsyncResult<T>> handler) { 
    delegate.methodWithNullableTypeVariableHandlerAsyncResult(notNull, value, handler);
  }

  public <T> void methodWithNullableTypeVariableHandlerAsyncResult(boolean notNull, T value) {
    methodWithNullableTypeVariableHandlerAsyncResult(notNull, value, ar -> { });
  }

  public <T> io.reactivex.Single<T> rxMethodWithNullableTypeVariableHandlerAsyncResult(boolean notNull, T value) { 
    return AsyncResultSingle.toSingle($handler -> {
      methodWithNullableTypeVariableHandlerAsyncResult(notNull, value, $handler);
    });
  }

  public <T> T methodWithNullableTypeVariableReturn(boolean notNull, T value) { 
    T ret = (T) delegate.methodWithNullableTypeVariableReturn(notNull, value);
    return ret;
  }

  public void methodWithNullableObjectParam(boolean expectNull, java.lang.Object param) { 
    delegate.methodWithNullableObjectParam(expectNull, param);
  }

  public boolean methodWithNonNullableListByteParam(java.util.List<java.lang.Byte> param) { 
    boolean ret = delegate.methodWithNonNullableListByteParam(param);
    return ret;
  }

  public void methodWithNullableListByteParam(boolean expectNull, java.util.List<java.lang.Byte> param) { 
    delegate.methodWithNullableListByteParam(expectNull, param);
  }

  public void methodWithNullableListByteHandler(boolean notNull, io.vertx.core.Handler<java.util.List<java.lang.Byte>> handler) { 
    delegate.methodWithNullableListByteHandler(notNull, handler);
  }

  public void methodWithNullableListByteHandlerAsyncResult(boolean notNull, io.vertx.core.Handler<io.vertx.core.AsyncResult<java.util.List<java.lang.Byte>>> handler) { 
    delegate.methodWithNullableListByteHandlerAsyncResult(notNull, handler);
  }

  public void methodWithNullableListByteHandlerAsyncResult(boolean notNull) {
    methodWithNullableListByteHandlerAsyncResult(notNull, ar -> { });
  }

  public io.reactivex.Maybe<java.util.List<java.lang.Byte>> rxMethodWithNullableListByteHandlerAsyncResult(boolean notNull) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      methodWithNullableListByteHandlerAsyncResult(notNull, $handler);
    });
  }

  public java.util.List<java.lang.Byte> methodWithNullableListByteReturn(boolean notNull) { 
    java.util.List<java.lang.Byte> ret = delegate.methodWithNullableListByteReturn(notNull);
    return ret;
  }

  public boolean methodWithNonNullableListShortParam(java.util.List<java.lang.Short> param) { 
    boolean ret = delegate.methodWithNonNullableListShortParam(param);
    return ret;
  }

  public void methodWithNullableListShortParam(boolean expectNull, java.util.List<java.lang.Short> param) { 
    delegate.methodWithNullableListShortParam(expectNull, param);
  }

  public void methodWithNullableListShortHandler(boolean notNull, io.vertx.core.Handler<java.util.List<java.lang.Short>> handler) { 
    delegate.methodWithNullableListShortHandler(notNull, handler);
  }

  public void methodWithNullableListShortHandlerAsyncResult(boolean notNull, io.vertx.core.Handler<io.vertx.core.AsyncResult<java.util.List<java.lang.Short>>> handler) { 
    delegate.methodWithNullableListShortHandlerAsyncResult(notNull, handler);
  }

  public void methodWithNullableListShortHandlerAsyncResult(boolean notNull) {
    methodWithNullableListShortHandlerAsyncResult(notNull, ar -> { });
  }

  public io.reactivex.Maybe<java.util.List<java.lang.Short>> rxMethodWithNullableListShortHandlerAsyncResult(boolean notNull) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      methodWithNullableListShortHandlerAsyncResult(notNull, $handler);
    });
  }

  public java.util.List<java.lang.Short> methodWithNullableListShortReturn(boolean notNull) { 
    java.util.List<java.lang.Short> ret = delegate.methodWithNullableListShortReturn(notNull);
    return ret;
  }

  public boolean methodWithNonNullableListIntegerParam(java.util.List<java.lang.Integer> param) { 
    boolean ret = delegate.methodWithNonNullableListIntegerParam(param);
    return ret;
  }

  public void methodWithNullableListIntegerParam(boolean expectNull, java.util.List<java.lang.Integer> param) { 
    delegate.methodWithNullableListIntegerParam(expectNull, param);
  }

  public void methodWithNullableListIntegerHandler(boolean notNull, io.vertx.core.Handler<java.util.List<java.lang.Integer>> handler) { 
    delegate.methodWithNullableListIntegerHandler(notNull, handler);
  }

  public void methodWithNullableListIntegerHandlerAsyncResult(boolean notNull, io.vertx.core.Handler<io.vertx.core.AsyncResult<java.util.List<java.lang.Integer>>> handler) { 
    delegate.methodWithNullableListIntegerHandlerAsyncResult(notNull, handler);
  }

  public void methodWithNullableListIntegerHandlerAsyncResult(boolean notNull) {
    methodWithNullableListIntegerHandlerAsyncResult(notNull, ar -> { });
  }

  public io.reactivex.Maybe<java.util.List<java.lang.Integer>> rxMethodWithNullableListIntegerHandlerAsyncResult(boolean notNull) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      methodWithNullableListIntegerHandlerAsyncResult(notNull, $handler);
    });
  }

  public java.util.List<java.lang.Integer> methodWithNullableListIntegerReturn(boolean notNull) { 
    java.util.List<java.lang.Integer> ret = delegate.methodWithNullableListIntegerReturn(notNull);
    return ret;
  }

  public boolean methodWithNonNullableListLongParam(java.util.List<java.lang.Long> param) { 
    boolean ret = delegate.methodWithNonNullableListLongParam(param);
    return ret;
  }

  public void methodWithNullableListLongParam(boolean expectNull, java.util.List<java.lang.Long> param) { 
    delegate.methodWithNullableListLongParam(expectNull, param);
  }

  public void methodWithNullableListLongHandler(boolean notNull, io.vertx.core.Handler<java.util.List<java.lang.Long>> handler) { 
    delegate.methodWithNullableListLongHandler(notNull, handler);
  }

  public void methodWithNullableListLongHandlerAsyncResult(boolean notNull, io.vertx.core.Handler<io.vertx.core.AsyncResult<java.util.List<java.lang.Long>>> handler) { 
    delegate.methodWithNullableListLongHandlerAsyncResult(notNull, handler);
  }

  public void methodWithNullableListLongHandlerAsyncResult(boolean notNull) {
    methodWithNullableListLongHandlerAsyncResult(notNull, ar -> { });
  }

  public io.reactivex.Maybe<java.util.List<java.lang.Long>> rxMethodWithNullableListLongHandlerAsyncResult(boolean notNull) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      methodWithNullableListLongHandlerAsyncResult(notNull, $handler);
    });
  }

  public java.util.List<java.lang.Long> methodWithNullableListLongReturn(boolean notNull) { 
    java.util.List<java.lang.Long> ret = delegate.methodWithNullableListLongReturn(notNull);
    return ret;
  }

  public boolean methodWithNonNullableListFloatParam(java.util.List<java.lang.Float> param) { 
    boolean ret = delegate.methodWithNonNullableListFloatParam(param);
    return ret;
  }

  public void methodWithNullableListFloatParam(boolean expectNull, java.util.List<java.lang.Float> param) { 
    delegate.methodWithNullableListFloatParam(expectNull, param);
  }

  public void methodWithNullableListFloatHandler(boolean notNull, io.vertx.core.Handler<java.util.List<java.lang.Float>> handler) { 
    delegate.methodWithNullableListFloatHandler(notNull, handler);
  }

  public void methodWithNullableListFloatHandlerAsyncResult(boolean notNull, io.vertx.core.Handler<io.vertx.core.AsyncResult<java.util.List<java.lang.Float>>> handler) { 
    delegate.methodWithNullableListFloatHandlerAsyncResult(notNull, handler);
  }

  public void methodWithNullableListFloatHandlerAsyncResult(boolean notNull) {
    methodWithNullableListFloatHandlerAsyncResult(notNull, ar -> { });
  }

  public io.reactivex.Maybe<java.util.List<java.lang.Float>> rxMethodWithNullableListFloatHandlerAsyncResult(boolean notNull) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      methodWithNullableListFloatHandlerAsyncResult(notNull, $handler);
    });
  }

  public java.util.List<java.lang.Float> methodWithNullableListFloatReturn(boolean notNull) { 
    java.util.List<java.lang.Float> ret = delegate.methodWithNullableListFloatReturn(notNull);
    return ret;
  }

  public boolean methodWithNonNullableListDoubleParam(java.util.List<java.lang.Double> param) { 
    boolean ret = delegate.methodWithNonNullableListDoubleParam(param);
    return ret;
  }

  public void methodWithNullableListDoubleParam(boolean expectNull, java.util.List<java.lang.Double> param) { 
    delegate.methodWithNullableListDoubleParam(expectNull, param);
  }

  public void methodWithNullableListDoubleHandler(boolean notNull, io.vertx.core.Handler<java.util.List<java.lang.Double>> handler) { 
    delegate.methodWithNullableListDoubleHandler(notNull, handler);
  }

  public void methodWithNullableListDoubleHandlerAsyncResult(boolean notNull, io.vertx.core.Handler<io.vertx.core.AsyncResult<java.util.List<java.lang.Double>>> handler) { 
    delegate.methodWithNullableListDoubleHandlerAsyncResult(notNull, handler);
  }

  public void methodWithNullableListDoubleHandlerAsyncResult(boolean notNull) {
    methodWithNullableListDoubleHandlerAsyncResult(notNull, ar -> { });
  }

  public io.reactivex.Maybe<java.util.List<java.lang.Double>> rxMethodWithNullableListDoubleHandlerAsyncResult(boolean notNull) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      methodWithNullableListDoubleHandlerAsyncResult(notNull, $handler);
    });
  }

  public java.util.List<java.lang.Double> methodWithNullableListDoubleReturn(boolean notNull) { 
    java.util.List<java.lang.Double> ret = delegate.methodWithNullableListDoubleReturn(notNull);
    return ret;
  }

  public boolean methodWithNonNullableListBooleanParam(java.util.List<java.lang.Boolean> param) { 
    boolean ret = delegate.methodWithNonNullableListBooleanParam(param);
    return ret;
  }

  public void methodWithNullableListBooleanParam(boolean expectNull, java.util.List<java.lang.Boolean> param) { 
    delegate.methodWithNullableListBooleanParam(expectNull, param);
  }

  public void methodWithNullableListBooleanHandler(boolean notNull, io.vertx.core.Handler<java.util.List<java.lang.Boolean>> handler) { 
    delegate.methodWithNullableListBooleanHandler(notNull, handler);
  }

  public void methodWithNullableListBooleanHandlerAsyncResult(boolean notNull, io.vertx.core.Handler<io.vertx.core.AsyncResult<java.util.List<java.lang.Boolean>>> handler) { 
    delegate.methodWithNullableListBooleanHandlerAsyncResult(notNull, handler);
  }

  public void methodWithNullableListBooleanHandlerAsyncResult(boolean notNull) {
    methodWithNullableListBooleanHandlerAsyncResult(notNull, ar -> { });
  }

  public io.reactivex.Maybe<java.util.List<java.lang.Boolean>> rxMethodWithNullableListBooleanHandlerAsyncResult(boolean notNull) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      methodWithNullableListBooleanHandlerAsyncResult(notNull, $handler);
    });
  }

  public java.util.List<java.lang.Boolean> methodWithNullableListBooleanReturn(boolean notNull) { 
    java.util.List<java.lang.Boolean> ret = delegate.methodWithNullableListBooleanReturn(notNull);
    return ret;
  }

  public boolean methodWithNonNullableListStringParam(java.util.List<java.lang.String> param) { 
    boolean ret = delegate.methodWithNonNullableListStringParam(param);
    return ret;
  }

  public void methodWithNullableListStringParam(boolean expectNull, java.util.List<java.lang.String> param) { 
    delegate.methodWithNullableListStringParam(expectNull, param);
  }

  public void methodWithNullableListStringHandler(boolean notNull, io.vertx.core.Handler<java.util.List<java.lang.String>> handler) { 
    delegate.methodWithNullableListStringHandler(notNull, handler);
  }

  public void methodWithNullableListStringHandlerAsyncResult(boolean notNull, io.vertx.core.Handler<io.vertx.core.AsyncResult<java.util.List<java.lang.String>>> handler) { 
    delegate.methodWithNullableListStringHandlerAsyncResult(notNull, handler);
  }

  public void methodWithNullableListStringHandlerAsyncResult(boolean notNull) {
    methodWithNullableListStringHandlerAsyncResult(notNull, ar -> { });
  }

  public io.reactivex.Maybe<java.util.List<java.lang.String>> rxMethodWithNullableListStringHandlerAsyncResult(boolean notNull) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      methodWithNullableListStringHandlerAsyncResult(notNull, $handler);
    });
  }

  public java.util.List<java.lang.String> methodWithNullableListStringReturn(boolean notNull) { 
    java.util.List<java.lang.String> ret = delegate.methodWithNullableListStringReturn(notNull);
    return ret;
  }

  public boolean methodWithNonNullableListCharParam(java.util.List<java.lang.Character> param) { 
    boolean ret = delegate.methodWithNonNullableListCharParam(param);
    return ret;
  }

  public void methodWithNullableListCharParam(boolean expectNull, java.util.List<java.lang.Character> param) { 
    delegate.methodWithNullableListCharParam(expectNull, param);
  }

  public void methodWithNullableListCharHandler(boolean notNull, io.vertx.core.Handler<java.util.List<java.lang.Character>> handler) { 
    delegate.methodWithNullableListCharHandler(notNull, handler);
  }

  public void methodWithNullableListCharHandlerAsyncResult(boolean notNull, io.vertx.core.Handler<io.vertx.core.AsyncResult<java.util.List<java.lang.Character>>> handler) { 
    delegate.methodWithNullableListCharHandlerAsyncResult(notNull, handler);
  }

  public void methodWithNullableListCharHandlerAsyncResult(boolean notNull) {
    methodWithNullableListCharHandlerAsyncResult(notNull, ar -> { });
  }

  public io.reactivex.Maybe<java.util.List<java.lang.Character>> rxMethodWithNullableListCharHandlerAsyncResult(boolean notNull) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      methodWithNullableListCharHandlerAsyncResult(notNull, $handler);
    });
  }

  public java.util.List<java.lang.Character> methodWithNullableListCharReturn(boolean notNull) { 
    java.util.List<java.lang.Character> ret = delegate.methodWithNullableListCharReturn(notNull);
    return ret;
  }

  public boolean methodWithNonNullableListJsonObjectParam(java.util.List<io.vertx.core.json.JsonObject> param) { 
    boolean ret = delegate.methodWithNonNullableListJsonObjectParam(param);
    return ret;
  }

  public void methodWithNullableListJsonObjectParam(boolean expectNull, java.util.List<io.vertx.core.json.JsonObject> param) { 
    delegate.methodWithNullableListJsonObjectParam(expectNull, param);
  }

  public void methodWithNullableListJsonObjectHandler(boolean notNull, io.vertx.core.Handler<java.util.List<io.vertx.core.json.JsonObject>> handler) { 
    delegate.methodWithNullableListJsonObjectHandler(notNull, handler);
  }

  public void methodWithNullableListJsonObjectHandlerAsyncResult(boolean notNull, io.vertx.core.Handler<io.vertx.core.AsyncResult<java.util.List<io.vertx.core.json.JsonObject>>> handler) { 
    delegate.methodWithNullableListJsonObjectHandlerAsyncResult(notNull, handler);
  }

  public void methodWithNullableListJsonObjectHandlerAsyncResult(boolean notNull) {
    methodWithNullableListJsonObjectHandlerAsyncResult(notNull, ar -> { });
  }

  public io.reactivex.Maybe<java.util.List<io.vertx.core.json.JsonObject>> rxMethodWithNullableListJsonObjectHandlerAsyncResult(boolean notNull) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      methodWithNullableListJsonObjectHandlerAsyncResult(notNull, $handler);
    });
  }

  public java.util.List<io.vertx.core.json.JsonObject> methodWithNullableListJsonObjectReturn(boolean notNull) { 
    java.util.List<io.vertx.core.json.JsonObject> ret = delegate.methodWithNullableListJsonObjectReturn(notNull);
    return ret;
  }

  public boolean methodWithNonNullableListJsonArrayParam(java.util.List<io.vertx.core.json.JsonArray> param) { 
    boolean ret = delegate.methodWithNonNullableListJsonArrayParam(param);
    return ret;
  }

  public void methodWithNullableListJsonArrayParam(boolean expectNull, java.util.List<io.vertx.core.json.JsonArray> param) { 
    delegate.methodWithNullableListJsonArrayParam(expectNull, param);
  }

  public void methodWithNullableListJsonArrayHandler(boolean notNull, io.vertx.core.Handler<java.util.List<io.vertx.core.json.JsonArray>> handler) { 
    delegate.methodWithNullableListJsonArrayHandler(notNull, handler);
  }

  public void methodWithNullableListJsonArrayHandlerAsyncResult(boolean notNull, io.vertx.core.Handler<io.vertx.core.AsyncResult<java.util.List<io.vertx.core.json.JsonArray>>> handler) { 
    delegate.methodWithNullableListJsonArrayHandlerAsyncResult(notNull, handler);
  }

  public void methodWithNullableListJsonArrayHandlerAsyncResult(boolean notNull) {
    methodWithNullableListJsonArrayHandlerAsyncResult(notNull, ar -> { });
  }

  public io.reactivex.Maybe<java.util.List<io.vertx.core.json.JsonArray>> rxMethodWithNullableListJsonArrayHandlerAsyncResult(boolean notNull) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      methodWithNullableListJsonArrayHandlerAsyncResult(notNull, $handler);
    });
  }

  public java.util.List<io.vertx.core.json.JsonArray> methodWithNullableListJsonArrayReturn(boolean notNull) { 
    java.util.List<io.vertx.core.json.JsonArray> ret = delegate.methodWithNullableListJsonArrayReturn(notNull);
    return ret;
  }

  public boolean methodWithNonNullableListApiParam(java.util.List<io.vertx.reactivex.codegen.testmodel.RefedInterface1> param) { 
    boolean ret = delegate.methodWithNonNullableListApiParam(param.stream().map(elt -> elt.getDelegate()).collect(Collectors.toList()));
    return ret;
  }

  public void methodWithNullableListApiParam(boolean expectNull, java.util.List<io.vertx.reactivex.codegen.testmodel.RefedInterface1> param) { 
    delegate.methodWithNullableListApiParam(expectNull, param.stream().map(elt -> elt.getDelegate()).collect(Collectors.toList()));
  }

  public void methodWithNullableListApiHandler(boolean notNull, io.vertx.core.Handler<java.util.List<io.vertx.reactivex.codegen.testmodel.RefedInterface1>> handler) { 
    delegate.methodWithNullableListApiHandler(notNull, new Handler<java.util.List<io.vertx.codegen.testmodel.RefedInterface1>>() {
      public void handle(java.util.List<io.vertx.codegen.testmodel.RefedInterface1> event) {
        handler.handle(event.stream().map(elt -> io.vertx.reactivex.codegen.testmodel.RefedInterface1.newInstance((io.vertx.codegen.testmodel.RefedInterface1)elt)).collect(Collectors.toList()));
      }
    });
  }

  public void methodWithNullableListApiHandlerAsyncResult(boolean notNull, io.vertx.core.Handler<io.vertx.core.AsyncResult<java.util.List<io.vertx.reactivex.codegen.testmodel.RefedInterface1>>> handler) { 
    delegate.methodWithNullableListApiHandlerAsyncResult(notNull, new Handler<AsyncResult<java.util.List<io.vertx.codegen.testmodel.RefedInterface1>>>() {
      public void handle(AsyncResult<java.util.List<io.vertx.codegen.testmodel.RefedInterface1>> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(ar.result().stream().map(elt -> io.vertx.reactivex.codegen.testmodel.RefedInterface1.newInstance((io.vertx.codegen.testmodel.RefedInterface1)elt)).collect(Collectors.toList())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
  }

  public void methodWithNullableListApiHandlerAsyncResult(boolean notNull) {
    methodWithNullableListApiHandlerAsyncResult(notNull, ar -> { });
  }

  public io.reactivex.Maybe<java.util.List<io.vertx.reactivex.codegen.testmodel.RefedInterface1>> rxMethodWithNullableListApiHandlerAsyncResult(boolean notNull) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      methodWithNullableListApiHandlerAsyncResult(notNull, $handler);
    });
  }

  public java.util.List<io.vertx.reactivex.codegen.testmodel.RefedInterface1> methodWithNullableListApiReturn(boolean notNull) { 
    java.util.List<io.vertx.reactivex.codegen.testmodel.RefedInterface1> ret = delegate.methodWithNullableListApiReturn(notNull).stream().map(elt -> io.vertx.reactivex.codegen.testmodel.RefedInterface1.newInstance((io.vertx.codegen.testmodel.RefedInterface1)elt)).collect(Collectors.toList());
    return ret;
  }

  public boolean methodWithNonNullableListDataObjectParam(java.util.List<io.vertx.codegen.testmodel.TestDataObject> param) { 
    boolean ret = delegate.methodWithNonNullableListDataObjectParam(param);
    return ret;
  }

  public void methodWithNullableListDataObjectParam(boolean expectNull, java.util.List<io.vertx.codegen.testmodel.TestDataObject> param) { 
    delegate.methodWithNullableListDataObjectParam(expectNull, param);
  }

  public void methodWithNullableListDataObjectHandler(boolean notNull, io.vertx.core.Handler<java.util.List<io.vertx.codegen.testmodel.TestDataObject>> handler) { 
    delegate.methodWithNullableListDataObjectHandler(notNull, handler);
  }

  public void methodWithNullableListDataObjectHandlerAsyncResult(boolean notNull, io.vertx.core.Handler<io.vertx.core.AsyncResult<java.util.List<io.vertx.codegen.testmodel.TestDataObject>>> handler) { 
    delegate.methodWithNullableListDataObjectHandlerAsyncResult(notNull, handler);
  }

  public void methodWithNullableListDataObjectHandlerAsyncResult(boolean notNull) {
    methodWithNullableListDataObjectHandlerAsyncResult(notNull, ar -> { });
  }

  public io.reactivex.Maybe<java.util.List<io.vertx.codegen.testmodel.TestDataObject>> rxMethodWithNullableListDataObjectHandlerAsyncResult(boolean notNull) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      methodWithNullableListDataObjectHandlerAsyncResult(notNull, $handler);
    });
  }

  public java.util.List<io.vertx.codegen.testmodel.TestDataObject> methodWithNullableListDataObjectReturn(boolean notNull) { 
    java.util.List<io.vertx.codegen.testmodel.TestDataObject> ret = delegate.methodWithNullableListDataObjectReturn(notNull);
    return ret;
  }

  public boolean methodWithNonNullableListEnumParam(java.util.List<io.vertx.codegen.testmodel.TestEnum> param) { 
    boolean ret = delegate.methodWithNonNullableListEnumParam(param);
    return ret;
  }

  public void methodWithNullableListEnumParam(boolean expectNull, java.util.List<io.vertx.codegen.testmodel.TestEnum> param) { 
    delegate.methodWithNullableListEnumParam(expectNull, param);
  }

  public void methodWithNullableListEnumHandler(boolean notNull, io.vertx.core.Handler<java.util.List<io.vertx.codegen.testmodel.TestEnum>> handler) { 
    delegate.methodWithNullableListEnumHandler(notNull, handler);
  }

  public void methodWithNullableListEnumHandlerAsyncResult(boolean notNull, io.vertx.core.Handler<io.vertx.core.AsyncResult<java.util.List<io.vertx.codegen.testmodel.TestEnum>>> handler) { 
    delegate.methodWithNullableListEnumHandlerAsyncResult(notNull, handler);
  }

  public void methodWithNullableListEnumHandlerAsyncResult(boolean notNull) {
    methodWithNullableListEnumHandlerAsyncResult(notNull, ar -> { });
  }

  public io.reactivex.Maybe<java.util.List<io.vertx.codegen.testmodel.TestEnum>> rxMethodWithNullableListEnumHandlerAsyncResult(boolean notNull) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      methodWithNullableListEnumHandlerAsyncResult(notNull, $handler);
    });
  }

  public java.util.List<io.vertx.codegen.testmodel.TestEnum> methodWithNullableListEnumReturn(boolean notNull) { 
    java.util.List<io.vertx.codegen.testmodel.TestEnum> ret = delegate.methodWithNullableListEnumReturn(notNull);
    return ret;
  }

  public boolean methodWithNonNullableListGenEnumParam(java.util.List<io.vertx.codegen.testmodel.TestGenEnum> param) { 
    boolean ret = delegate.methodWithNonNullableListGenEnumParam(param);
    return ret;
  }

  public void methodWithNullableListGenEnumParam(boolean expectNull, java.util.List<io.vertx.codegen.testmodel.TestGenEnum> param) { 
    delegate.methodWithNullableListGenEnumParam(expectNull, param);
  }

  public void methodWithNullableListGenEnumHandler(boolean notNull, io.vertx.core.Handler<java.util.List<io.vertx.codegen.testmodel.TestGenEnum>> handler) { 
    delegate.methodWithNullableListGenEnumHandler(notNull, handler);
  }

  public void methodWithNullableListGenEnumHandlerAsyncResult(boolean notNull, io.vertx.core.Handler<io.vertx.core.AsyncResult<java.util.List<io.vertx.codegen.testmodel.TestGenEnum>>> handler) { 
    delegate.methodWithNullableListGenEnumHandlerAsyncResult(notNull, handler);
  }

  public void methodWithNullableListGenEnumHandlerAsyncResult(boolean notNull) {
    methodWithNullableListGenEnumHandlerAsyncResult(notNull, ar -> { });
  }

  public io.reactivex.Maybe<java.util.List<io.vertx.codegen.testmodel.TestGenEnum>> rxMethodWithNullableListGenEnumHandlerAsyncResult(boolean notNull) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      methodWithNullableListGenEnumHandlerAsyncResult(notNull, $handler);
    });
  }

  public java.util.List<io.vertx.codegen.testmodel.TestGenEnum> methodWithNullableListGenEnumReturn(boolean notNull) { 
    java.util.List<io.vertx.codegen.testmodel.TestGenEnum> ret = delegate.methodWithNullableListGenEnumReturn(notNull);
    return ret;
  }

  public boolean methodWithNonNullableSetByteParam(java.util.Set<java.lang.Byte> param) { 
    boolean ret = delegate.methodWithNonNullableSetByteParam(param);
    return ret;
  }

  public void methodWithNullableSetByteParam(boolean expectNull, java.util.Set<java.lang.Byte> param) { 
    delegate.methodWithNullableSetByteParam(expectNull, param);
  }

  public void methodWithNullableSetByteHandler(boolean notNull, io.vertx.core.Handler<java.util.Set<java.lang.Byte>> handler) { 
    delegate.methodWithNullableSetByteHandler(notNull, handler);
  }

  public void methodWithNullableSetByteHandlerAsyncResult(boolean notNull, io.vertx.core.Handler<io.vertx.core.AsyncResult<java.util.Set<java.lang.Byte>>> handler) { 
    delegate.methodWithNullableSetByteHandlerAsyncResult(notNull, handler);
  }

  public void methodWithNullableSetByteHandlerAsyncResult(boolean notNull) {
    methodWithNullableSetByteHandlerAsyncResult(notNull, ar -> { });
  }

  public io.reactivex.Maybe<java.util.Set<java.lang.Byte>> rxMethodWithNullableSetByteHandlerAsyncResult(boolean notNull) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      methodWithNullableSetByteHandlerAsyncResult(notNull, $handler);
    });
  }

  public java.util.Set<java.lang.Byte> methodWithNullableSetByteReturn(boolean notNull) { 
    java.util.Set<java.lang.Byte> ret = delegate.methodWithNullableSetByteReturn(notNull);
    return ret;
  }

  public boolean methodWithNonNullableSetShortParam(java.util.Set<java.lang.Short> param) { 
    boolean ret = delegate.methodWithNonNullableSetShortParam(param);
    return ret;
  }

  public void methodWithNullableSetShortParam(boolean expectNull, java.util.Set<java.lang.Short> param) { 
    delegate.methodWithNullableSetShortParam(expectNull, param);
  }

  public void methodWithNullableSetShortHandler(boolean notNull, io.vertx.core.Handler<java.util.Set<java.lang.Short>> handler) { 
    delegate.methodWithNullableSetShortHandler(notNull, handler);
  }

  public void methodWithNullableSetShortHandlerAsyncResult(boolean notNull, io.vertx.core.Handler<io.vertx.core.AsyncResult<java.util.Set<java.lang.Short>>> handler) { 
    delegate.methodWithNullableSetShortHandlerAsyncResult(notNull, handler);
  }

  public void methodWithNullableSetShortHandlerAsyncResult(boolean notNull) {
    methodWithNullableSetShortHandlerAsyncResult(notNull, ar -> { });
  }

  public io.reactivex.Maybe<java.util.Set<java.lang.Short>> rxMethodWithNullableSetShortHandlerAsyncResult(boolean notNull) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      methodWithNullableSetShortHandlerAsyncResult(notNull, $handler);
    });
  }

  public java.util.Set<java.lang.Short> methodWithNullableSetShortReturn(boolean notNull) { 
    java.util.Set<java.lang.Short> ret = delegate.methodWithNullableSetShortReturn(notNull);
    return ret;
  }

  public boolean methodWithNonNullableSetIntegerParam(java.util.Set<java.lang.Integer> param) { 
    boolean ret = delegate.methodWithNonNullableSetIntegerParam(param);
    return ret;
  }

  public void methodWithNullableSetIntegerParam(boolean expectNull, java.util.Set<java.lang.Integer> param) { 
    delegate.methodWithNullableSetIntegerParam(expectNull, param);
  }

  public void methodWithNullableSetIntegerHandler(boolean notNull, io.vertx.core.Handler<java.util.Set<java.lang.Integer>> handler) { 
    delegate.methodWithNullableSetIntegerHandler(notNull, handler);
  }

  public void methodWithNullableSetIntegerHandlerAsyncResult(boolean notNull, io.vertx.core.Handler<io.vertx.core.AsyncResult<java.util.Set<java.lang.Integer>>> handler) { 
    delegate.methodWithNullableSetIntegerHandlerAsyncResult(notNull, handler);
  }

  public void methodWithNullableSetIntegerHandlerAsyncResult(boolean notNull) {
    methodWithNullableSetIntegerHandlerAsyncResult(notNull, ar -> { });
  }

  public io.reactivex.Maybe<java.util.Set<java.lang.Integer>> rxMethodWithNullableSetIntegerHandlerAsyncResult(boolean notNull) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      methodWithNullableSetIntegerHandlerAsyncResult(notNull, $handler);
    });
  }

  public java.util.Set<java.lang.Integer> methodWithNullableSetIntegerReturn(boolean notNull) { 
    java.util.Set<java.lang.Integer> ret = delegate.methodWithNullableSetIntegerReturn(notNull);
    return ret;
  }

  public boolean methodWithNonNullableSetLongParam(java.util.Set<java.lang.Long> param) { 
    boolean ret = delegate.methodWithNonNullableSetLongParam(param);
    return ret;
  }

  public void methodWithNullableSetLongParam(boolean expectNull, java.util.Set<java.lang.Long> param) { 
    delegate.methodWithNullableSetLongParam(expectNull, param);
  }

  public void methodWithNullableSetLongHandler(boolean notNull, io.vertx.core.Handler<java.util.Set<java.lang.Long>> handler) { 
    delegate.methodWithNullableSetLongHandler(notNull, handler);
  }

  public void methodWithNullableSetLongHandlerAsyncResult(boolean notNull, io.vertx.core.Handler<io.vertx.core.AsyncResult<java.util.Set<java.lang.Long>>> handler) { 
    delegate.methodWithNullableSetLongHandlerAsyncResult(notNull, handler);
  }

  public void methodWithNullableSetLongHandlerAsyncResult(boolean notNull) {
    methodWithNullableSetLongHandlerAsyncResult(notNull, ar -> { });
  }

  public io.reactivex.Maybe<java.util.Set<java.lang.Long>> rxMethodWithNullableSetLongHandlerAsyncResult(boolean notNull) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      methodWithNullableSetLongHandlerAsyncResult(notNull, $handler);
    });
  }

  public java.util.Set<java.lang.Long> methodWithNullableSetLongReturn(boolean notNull) { 
    java.util.Set<java.lang.Long> ret = delegate.methodWithNullableSetLongReturn(notNull);
    return ret;
  }

  public boolean methodWithNonNullableSetFloatParam(java.util.Set<java.lang.Float> param) { 
    boolean ret = delegate.methodWithNonNullableSetFloatParam(param);
    return ret;
  }

  public void methodWithNullableSetFloatParam(boolean expectNull, java.util.Set<java.lang.Float> param) { 
    delegate.methodWithNullableSetFloatParam(expectNull, param);
  }

  public void methodWithNullableSetFloatHandler(boolean notNull, io.vertx.core.Handler<java.util.Set<java.lang.Float>> handler) { 
    delegate.methodWithNullableSetFloatHandler(notNull, handler);
  }

  public void methodWithNullableSetFloatHandlerAsyncResult(boolean notNull, io.vertx.core.Handler<io.vertx.core.AsyncResult<java.util.Set<java.lang.Float>>> handler) { 
    delegate.methodWithNullableSetFloatHandlerAsyncResult(notNull, handler);
  }

  public void methodWithNullableSetFloatHandlerAsyncResult(boolean notNull) {
    methodWithNullableSetFloatHandlerAsyncResult(notNull, ar -> { });
  }

  public io.reactivex.Maybe<java.util.Set<java.lang.Float>> rxMethodWithNullableSetFloatHandlerAsyncResult(boolean notNull) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      methodWithNullableSetFloatHandlerAsyncResult(notNull, $handler);
    });
  }

  public java.util.Set<java.lang.Float> methodWithNullableSetFloatReturn(boolean notNull) { 
    java.util.Set<java.lang.Float> ret = delegate.methodWithNullableSetFloatReturn(notNull);
    return ret;
  }

  public boolean methodWithNonNullableSetDoubleParam(java.util.Set<java.lang.Double> param) { 
    boolean ret = delegate.methodWithNonNullableSetDoubleParam(param);
    return ret;
  }

  public void methodWithNullableSetDoubleParam(boolean expectNull, java.util.Set<java.lang.Double> param) { 
    delegate.methodWithNullableSetDoubleParam(expectNull, param);
  }

  public void methodWithNullableSetDoubleHandler(boolean notNull, io.vertx.core.Handler<java.util.Set<java.lang.Double>> handler) { 
    delegate.methodWithNullableSetDoubleHandler(notNull, handler);
  }

  public void methodWithNullableSetDoubleHandlerAsyncResult(boolean notNull, io.vertx.core.Handler<io.vertx.core.AsyncResult<java.util.Set<java.lang.Double>>> handler) { 
    delegate.methodWithNullableSetDoubleHandlerAsyncResult(notNull, handler);
  }

  public void methodWithNullableSetDoubleHandlerAsyncResult(boolean notNull) {
    methodWithNullableSetDoubleHandlerAsyncResult(notNull, ar -> { });
  }

  public io.reactivex.Maybe<java.util.Set<java.lang.Double>> rxMethodWithNullableSetDoubleHandlerAsyncResult(boolean notNull) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      methodWithNullableSetDoubleHandlerAsyncResult(notNull, $handler);
    });
  }

  public java.util.Set<java.lang.Double> methodWithNullableSetDoubleReturn(boolean notNull) { 
    java.util.Set<java.lang.Double> ret = delegate.methodWithNullableSetDoubleReturn(notNull);
    return ret;
  }

  public boolean methodWithNonNullableSetBooleanParam(java.util.Set<java.lang.Boolean> param) { 
    boolean ret = delegate.methodWithNonNullableSetBooleanParam(param);
    return ret;
  }

  public void methodWithNullableSetBooleanParam(boolean expectNull, java.util.Set<java.lang.Boolean> param) { 
    delegate.methodWithNullableSetBooleanParam(expectNull, param);
  }

  public void methodWithNullableSetBooleanHandler(boolean notNull, io.vertx.core.Handler<java.util.Set<java.lang.Boolean>> handler) { 
    delegate.methodWithNullableSetBooleanHandler(notNull, handler);
  }

  public void methodWithNullableSetBooleanHandlerAsyncResult(boolean notNull, io.vertx.core.Handler<io.vertx.core.AsyncResult<java.util.Set<java.lang.Boolean>>> handler) { 
    delegate.methodWithNullableSetBooleanHandlerAsyncResult(notNull, handler);
  }

  public void methodWithNullableSetBooleanHandlerAsyncResult(boolean notNull) {
    methodWithNullableSetBooleanHandlerAsyncResult(notNull, ar -> { });
  }

  public io.reactivex.Maybe<java.util.Set<java.lang.Boolean>> rxMethodWithNullableSetBooleanHandlerAsyncResult(boolean notNull) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      methodWithNullableSetBooleanHandlerAsyncResult(notNull, $handler);
    });
  }

  public java.util.Set<java.lang.Boolean> methodWithNullableSetBooleanReturn(boolean notNull) { 
    java.util.Set<java.lang.Boolean> ret = delegate.methodWithNullableSetBooleanReturn(notNull);
    return ret;
  }

  public boolean methodWithNonNullableSetStringParam(java.util.Set<java.lang.String> param) { 
    boolean ret = delegate.methodWithNonNullableSetStringParam(param);
    return ret;
  }

  public void methodWithNullableSetStringParam(boolean expectNull, java.util.Set<java.lang.String> param) { 
    delegate.methodWithNullableSetStringParam(expectNull, param);
  }

  public void methodWithNullableSetStringHandler(boolean notNull, io.vertx.core.Handler<java.util.Set<java.lang.String>> handler) { 
    delegate.methodWithNullableSetStringHandler(notNull, handler);
  }

  public void methodWithNullableSetStringHandlerAsyncResult(boolean notNull, io.vertx.core.Handler<io.vertx.core.AsyncResult<java.util.Set<java.lang.String>>> handler) { 
    delegate.methodWithNullableSetStringHandlerAsyncResult(notNull, handler);
  }

  public void methodWithNullableSetStringHandlerAsyncResult(boolean notNull) {
    methodWithNullableSetStringHandlerAsyncResult(notNull, ar -> { });
  }

  public io.reactivex.Maybe<java.util.Set<java.lang.String>> rxMethodWithNullableSetStringHandlerAsyncResult(boolean notNull) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      methodWithNullableSetStringHandlerAsyncResult(notNull, $handler);
    });
  }

  public java.util.Set<java.lang.String> methodWithNullableSetStringReturn(boolean notNull) { 
    java.util.Set<java.lang.String> ret = delegate.methodWithNullableSetStringReturn(notNull);
    return ret;
  }

  public boolean methodWithNonNullableSetCharParam(java.util.Set<java.lang.Character> param) { 
    boolean ret = delegate.methodWithNonNullableSetCharParam(param);
    return ret;
  }

  public void methodWithNullableSetCharParam(boolean expectNull, java.util.Set<java.lang.Character> param) { 
    delegate.methodWithNullableSetCharParam(expectNull, param);
  }

  public void methodWithNullableSetCharHandler(boolean notNull, io.vertx.core.Handler<java.util.Set<java.lang.Character>> handler) { 
    delegate.methodWithNullableSetCharHandler(notNull, handler);
  }

  public void methodWithNullableSetCharHandlerAsyncResult(boolean notNull, io.vertx.core.Handler<io.vertx.core.AsyncResult<java.util.Set<java.lang.Character>>> handler) { 
    delegate.methodWithNullableSetCharHandlerAsyncResult(notNull, handler);
  }

  public void methodWithNullableSetCharHandlerAsyncResult(boolean notNull) {
    methodWithNullableSetCharHandlerAsyncResult(notNull, ar -> { });
  }

  public io.reactivex.Maybe<java.util.Set<java.lang.Character>> rxMethodWithNullableSetCharHandlerAsyncResult(boolean notNull) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      methodWithNullableSetCharHandlerAsyncResult(notNull, $handler);
    });
  }

  public java.util.Set<java.lang.Character> methodWithNullableSetCharReturn(boolean notNull) { 
    java.util.Set<java.lang.Character> ret = delegate.methodWithNullableSetCharReturn(notNull);
    return ret;
  }

  public boolean methodWithNonNullableSetJsonObjectParam(java.util.Set<io.vertx.core.json.JsonObject> param) { 
    boolean ret = delegate.methodWithNonNullableSetJsonObjectParam(param);
    return ret;
  }

  public void methodWithNullableSetJsonObjectParam(boolean expectNull, java.util.Set<io.vertx.core.json.JsonObject> param) { 
    delegate.methodWithNullableSetJsonObjectParam(expectNull, param);
  }

  public void methodWithNullableSetJsonObjectHandler(boolean notNull, io.vertx.core.Handler<java.util.Set<io.vertx.core.json.JsonObject>> handler) { 
    delegate.methodWithNullableSetJsonObjectHandler(notNull, handler);
  }

  public void methodWithNullableSetJsonObjectHandlerAsyncResult(boolean notNull, io.vertx.core.Handler<io.vertx.core.AsyncResult<java.util.Set<io.vertx.core.json.JsonObject>>> handler) { 
    delegate.methodWithNullableSetJsonObjectHandlerAsyncResult(notNull, handler);
  }

  public void methodWithNullableSetJsonObjectHandlerAsyncResult(boolean notNull) {
    methodWithNullableSetJsonObjectHandlerAsyncResult(notNull, ar -> { });
  }

  public io.reactivex.Maybe<java.util.Set<io.vertx.core.json.JsonObject>> rxMethodWithNullableSetJsonObjectHandlerAsyncResult(boolean notNull) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      methodWithNullableSetJsonObjectHandlerAsyncResult(notNull, $handler);
    });
  }

  public java.util.Set<io.vertx.core.json.JsonObject> methodWithNullableSetJsonObjectReturn(boolean notNull) { 
    java.util.Set<io.vertx.core.json.JsonObject> ret = delegate.methodWithNullableSetJsonObjectReturn(notNull);
    return ret;
  }

  public boolean methodWithNonNullableSetJsonArrayParam(java.util.Set<io.vertx.core.json.JsonArray> param) { 
    boolean ret = delegate.methodWithNonNullableSetJsonArrayParam(param);
    return ret;
  }

  public void methodWithNullableSetJsonArrayParam(boolean expectNull, java.util.Set<io.vertx.core.json.JsonArray> param) { 
    delegate.methodWithNullableSetJsonArrayParam(expectNull, param);
  }

  public void methodWithNullableSetJsonArrayHandler(boolean notNull, io.vertx.core.Handler<java.util.Set<io.vertx.core.json.JsonArray>> handler) { 
    delegate.methodWithNullableSetJsonArrayHandler(notNull, handler);
  }

  public void methodWithNullableSetJsonArrayHandlerAsyncResult(boolean notNull, io.vertx.core.Handler<io.vertx.core.AsyncResult<java.util.Set<io.vertx.core.json.JsonArray>>> handler) { 
    delegate.methodWithNullableSetJsonArrayHandlerAsyncResult(notNull, handler);
  }

  public void methodWithNullableSetJsonArrayHandlerAsyncResult(boolean notNull) {
    methodWithNullableSetJsonArrayHandlerAsyncResult(notNull, ar -> { });
  }

  public io.reactivex.Maybe<java.util.Set<io.vertx.core.json.JsonArray>> rxMethodWithNullableSetJsonArrayHandlerAsyncResult(boolean notNull) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      methodWithNullableSetJsonArrayHandlerAsyncResult(notNull, $handler);
    });
  }

  public java.util.Set<io.vertx.core.json.JsonArray> methodWithNullableSetJsonArrayReturn(boolean notNull) { 
    java.util.Set<io.vertx.core.json.JsonArray> ret = delegate.methodWithNullableSetJsonArrayReturn(notNull);
    return ret;
  }

  public boolean methodWithNonNullableSetApiParam(java.util.Set<io.vertx.reactivex.codegen.testmodel.RefedInterface1> param) { 
    boolean ret = delegate.methodWithNonNullableSetApiParam(param.stream().map(elt -> elt.getDelegate()).collect(Collectors.toSet()));
    return ret;
  }

  public void methodWithNullableSetApiParam(boolean expectNull, java.util.Set<io.vertx.reactivex.codegen.testmodel.RefedInterface1> param) { 
    delegate.methodWithNullableSetApiParam(expectNull, param.stream().map(elt -> elt.getDelegate()).collect(Collectors.toSet()));
  }

  public void methodWithNullableSetApiHandler(boolean notNull, io.vertx.core.Handler<java.util.Set<io.vertx.reactivex.codegen.testmodel.RefedInterface1>> handler) { 
    delegate.methodWithNullableSetApiHandler(notNull, new Handler<java.util.Set<io.vertx.codegen.testmodel.RefedInterface1>>() {
      public void handle(java.util.Set<io.vertx.codegen.testmodel.RefedInterface1> event) {
        handler.handle(event.stream().map(elt -> io.vertx.reactivex.codegen.testmodel.RefedInterface1.newInstance((io.vertx.codegen.testmodel.RefedInterface1)elt)).collect(Collectors.toSet()));
      }
    });
  }

  public void methodWithNullableSetApiHandlerAsyncResult(boolean notNull, io.vertx.core.Handler<io.vertx.core.AsyncResult<java.util.Set<io.vertx.reactivex.codegen.testmodel.RefedInterface1>>> handler) { 
    delegate.methodWithNullableSetApiHandlerAsyncResult(notNull, new Handler<AsyncResult<java.util.Set<io.vertx.codegen.testmodel.RefedInterface1>>>() {
      public void handle(AsyncResult<java.util.Set<io.vertx.codegen.testmodel.RefedInterface1>> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(ar.result().stream().map(elt -> io.vertx.reactivex.codegen.testmodel.RefedInterface1.newInstance((io.vertx.codegen.testmodel.RefedInterface1)elt)).collect(Collectors.toSet())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
  }

  public void methodWithNullableSetApiHandlerAsyncResult(boolean notNull) {
    methodWithNullableSetApiHandlerAsyncResult(notNull, ar -> { });
  }

  public io.reactivex.Maybe<java.util.Set<io.vertx.reactivex.codegen.testmodel.RefedInterface1>> rxMethodWithNullableSetApiHandlerAsyncResult(boolean notNull) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      methodWithNullableSetApiHandlerAsyncResult(notNull, $handler);
    });
  }

  public java.util.Set<io.vertx.reactivex.codegen.testmodel.RefedInterface1> methodWithNullableSetApiReturn(boolean notNull) { 
    java.util.Set<io.vertx.reactivex.codegen.testmodel.RefedInterface1> ret = delegate.methodWithNullableSetApiReturn(notNull).stream().map(elt -> io.vertx.reactivex.codegen.testmodel.RefedInterface1.newInstance((io.vertx.codegen.testmodel.RefedInterface1)elt)).collect(Collectors.toSet());
    return ret;
  }

  public boolean methodWithNonNullableSetDataObjectParam(java.util.Set<io.vertx.codegen.testmodel.TestDataObject> param) { 
    boolean ret = delegate.methodWithNonNullableSetDataObjectParam(param);
    return ret;
  }

  public void methodWithNullableSetDataObjectParam(boolean expectNull, java.util.Set<io.vertx.codegen.testmodel.TestDataObject> param) { 
    delegate.methodWithNullableSetDataObjectParam(expectNull, param);
  }

  public void methodWithNullableSetDataObjectHandler(boolean notNull, io.vertx.core.Handler<java.util.Set<io.vertx.codegen.testmodel.TestDataObject>> handler) { 
    delegate.methodWithNullableSetDataObjectHandler(notNull, handler);
  }

  public void methodWithNullableSetDataObjectHandlerAsyncResult(boolean notNull, io.vertx.core.Handler<io.vertx.core.AsyncResult<java.util.Set<io.vertx.codegen.testmodel.TestDataObject>>> handler) { 
    delegate.methodWithNullableSetDataObjectHandlerAsyncResult(notNull, handler);
  }

  public void methodWithNullableSetDataObjectHandlerAsyncResult(boolean notNull) {
    methodWithNullableSetDataObjectHandlerAsyncResult(notNull, ar -> { });
  }

  public io.reactivex.Maybe<java.util.Set<io.vertx.codegen.testmodel.TestDataObject>> rxMethodWithNullableSetDataObjectHandlerAsyncResult(boolean notNull) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      methodWithNullableSetDataObjectHandlerAsyncResult(notNull, $handler);
    });
  }

  public java.util.Set<io.vertx.codegen.testmodel.TestDataObject> methodWithNullableSetDataObjectReturn(boolean notNull) { 
    java.util.Set<io.vertx.codegen.testmodel.TestDataObject> ret = delegate.methodWithNullableSetDataObjectReturn(notNull);
    return ret;
  }

  public boolean methodWithNonNullableSetEnumParam(java.util.Set<io.vertx.codegen.testmodel.TestEnum> param) { 
    boolean ret = delegate.methodWithNonNullableSetEnumParam(param);
    return ret;
  }

  public void methodWithNullableSetEnumParam(boolean expectNull, java.util.Set<io.vertx.codegen.testmodel.TestEnum> param) { 
    delegate.methodWithNullableSetEnumParam(expectNull, param);
  }

  public void methodWithNullableSetEnumHandler(boolean notNull, io.vertx.core.Handler<java.util.Set<io.vertx.codegen.testmodel.TestEnum>> handler) { 
    delegate.methodWithNullableSetEnumHandler(notNull, handler);
  }

  public void methodWithNullableSetEnumHandlerAsyncResult(boolean notNull, io.vertx.core.Handler<io.vertx.core.AsyncResult<java.util.Set<io.vertx.codegen.testmodel.TestEnum>>> handler) { 
    delegate.methodWithNullableSetEnumHandlerAsyncResult(notNull, handler);
  }

  public void methodWithNullableSetEnumHandlerAsyncResult(boolean notNull) {
    methodWithNullableSetEnumHandlerAsyncResult(notNull, ar -> { });
  }

  public io.reactivex.Maybe<java.util.Set<io.vertx.codegen.testmodel.TestEnum>> rxMethodWithNullableSetEnumHandlerAsyncResult(boolean notNull) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      methodWithNullableSetEnumHandlerAsyncResult(notNull, $handler);
    });
  }

  public java.util.Set<io.vertx.codegen.testmodel.TestEnum> methodWithNullableSetEnumReturn(boolean notNull) { 
    java.util.Set<io.vertx.codegen.testmodel.TestEnum> ret = delegate.methodWithNullableSetEnumReturn(notNull);
    return ret;
  }

  public boolean methodWithNonNullableSetGenEnumParam(java.util.Set<io.vertx.codegen.testmodel.TestGenEnum> param) { 
    boolean ret = delegate.methodWithNonNullableSetGenEnumParam(param);
    return ret;
  }

  public void methodWithNullableSetGenEnumParam(boolean expectNull, java.util.Set<io.vertx.codegen.testmodel.TestGenEnum> param) { 
    delegate.methodWithNullableSetGenEnumParam(expectNull, param);
  }

  public void methodWithNullableSetGenEnumHandler(boolean notNull, io.vertx.core.Handler<java.util.Set<io.vertx.codegen.testmodel.TestGenEnum>> handler) { 
    delegate.methodWithNullableSetGenEnumHandler(notNull, handler);
  }

  public void methodWithNullableSetGenEnumHandlerAsyncResult(boolean notNull, io.vertx.core.Handler<io.vertx.core.AsyncResult<java.util.Set<io.vertx.codegen.testmodel.TestGenEnum>>> handler) { 
    delegate.methodWithNullableSetGenEnumHandlerAsyncResult(notNull, handler);
  }

  public void methodWithNullableSetGenEnumHandlerAsyncResult(boolean notNull) {
    methodWithNullableSetGenEnumHandlerAsyncResult(notNull, ar -> { });
  }

  public io.reactivex.Maybe<java.util.Set<io.vertx.codegen.testmodel.TestGenEnum>> rxMethodWithNullableSetGenEnumHandlerAsyncResult(boolean notNull) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      methodWithNullableSetGenEnumHandlerAsyncResult(notNull, $handler);
    });
  }

  public java.util.Set<io.vertx.codegen.testmodel.TestGenEnum> methodWithNullableSetGenEnumReturn(boolean notNull) { 
    java.util.Set<io.vertx.codegen.testmodel.TestGenEnum> ret = delegate.methodWithNullableSetGenEnumReturn(notNull);
    return ret;
  }

  public boolean methodWithNonNullableMapByteParam(java.util.Map<java.lang.String,java.lang.Byte> param) { 
    boolean ret = delegate.methodWithNonNullableMapByteParam(param);
    return ret;
  }

  public void methodWithNullableMapByteParam(boolean expectNull, java.util.Map<java.lang.String,java.lang.Byte> param) { 
    delegate.methodWithNullableMapByteParam(expectNull, param);
  }

  public void methodWithNullableMapByteHandler(boolean notNull, io.vertx.core.Handler<java.util.Map<java.lang.String,java.lang.Byte>> handler) { 
    delegate.methodWithNullableMapByteHandler(notNull, handler);
  }

  public void methodWithNullableMapByteHandlerAsyncResult(boolean notNull, io.vertx.core.Handler<io.vertx.core.AsyncResult<java.util.Map<java.lang.String,java.lang.Byte>>> handler) { 
    delegate.methodWithNullableMapByteHandlerAsyncResult(notNull, handler);
  }

  public void methodWithNullableMapByteHandlerAsyncResult(boolean notNull) {
    methodWithNullableMapByteHandlerAsyncResult(notNull, ar -> { });
  }

  public io.reactivex.Maybe<java.util.Map<java.lang.String,java.lang.Byte>> rxMethodWithNullableMapByteHandlerAsyncResult(boolean notNull) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      methodWithNullableMapByteHandlerAsyncResult(notNull, $handler);
    });
  }

  public java.util.Map<java.lang.String,java.lang.Byte> methodWithNullableMapByteReturn(boolean notNull) { 
    java.util.Map<java.lang.String,java.lang.Byte> ret = delegate.methodWithNullableMapByteReturn(notNull);
    return ret;
  }

  public boolean methodWithNonNullableMapShortParam(java.util.Map<java.lang.String,java.lang.Short> param) { 
    boolean ret = delegate.methodWithNonNullableMapShortParam(param);
    return ret;
  }

  public void methodWithNullableMapShortParam(boolean expectNull, java.util.Map<java.lang.String,java.lang.Short> param) { 
    delegate.methodWithNullableMapShortParam(expectNull, param);
  }

  public void methodWithNullableMapShortHandler(boolean notNull, io.vertx.core.Handler<java.util.Map<java.lang.String,java.lang.Short>> handler) { 
    delegate.methodWithNullableMapShortHandler(notNull, handler);
  }

  public void methodWithNullableMapShortHandlerAsyncResult(boolean notNull, io.vertx.core.Handler<io.vertx.core.AsyncResult<java.util.Map<java.lang.String,java.lang.Short>>> handler) { 
    delegate.methodWithNullableMapShortHandlerAsyncResult(notNull, handler);
  }

  public void methodWithNullableMapShortHandlerAsyncResult(boolean notNull) {
    methodWithNullableMapShortHandlerAsyncResult(notNull, ar -> { });
  }

  public io.reactivex.Maybe<java.util.Map<java.lang.String,java.lang.Short>> rxMethodWithNullableMapShortHandlerAsyncResult(boolean notNull) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      methodWithNullableMapShortHandlerAsyncResult(notNull, $handler);
    });
  }

  public java.util.Map<java.lang.String,java.lang.Short> methodWithNullableMapShortReturn(boolean notNull) { 
    java.util.Map<java.lang.String,java.lang.Short> ret = delegate.methodWithNullableMapShortReturn(notNull);
    return ret;
  }

  public boolean methodWithNonNullableMapIntegerParam(java.util.Map<java.lang.String,java.lang.Integer> param) { 
    boolean ret = delegate.methodWithNonNullableMapIntegerParam(param);
    return ret;
  }

  public void methodWithNullableMapIntegerParam(boolean expectNull, java.util.Map<java.lang.String,java.lang.Integer> param) { 
    delegate.methodWithNullableMapIntegerParam(expectNull, param);
  }

  public void methodWithNullableMapIntegerHandler(boolean notNull, io.vertx.core.Handler<java.util.Map<java.lang.String,java.lang.Integer>> handler) { 
    delegate.methodWithNullableMapIntegerHandler(notNull, handler);
  }

  public void methodWithNullableMapIntegerHandlerAsyncResult(boolean notNull, io.vertx.core.Handler<io.vertx.core.AsyncResult<java.util.Map<java.lang.String,java.lang.Integer>>> handler) { 
    delegate.methodWithNullableMapIntegerHandlerAsyncResult(notNull, handler);
  }

  public void methodWithNullableMapIntegerHandlerAsyncResult(boolean notNull) {
    methodWithNullableMapIntegerHandlerAsyncResult(notNull, ar -> { });
  }

  public io.reactivex.Maybe<java.util.Map<java.lang.String,java.lang.Integer>> rxMethodWithNullableMapIntegerHandlerAsyncResult(boolean notNull) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      methodWithNullableMapIntegerHandlerAsyncResult(notNull, $handler);
    });
  }

  public java.util.Map<java.lang.String,java.lang.Integer> methodWithNullableMapIntegerReturn(boolean notNull) { 
    java.util.Map<java.lang.String,java.lang.Integer> ret = delegate.methodWithNullableMapIntegerReturn(notNull);
    return ret;
  }

  public boolean methodWithNonNullableMapLongParam(java.util.Map<java.lang.String,java.lang.Long> param) { 
    boolean ret = delegate.methodWithNonNullableMapLongParam(param);
    return ret;
  }

  public void methodWithNullableMapLongParam(boolean expectNull, java.util.Map<java.lang.String,java.lang.Long> param) { 
    delegate.methodWithNullableMapLongParam(expectNull, param);
  }

  public void methodWithNullableMapLongHandler(boolean notNull, io.vertx.core.Handler<java.util.Map<java.lang.String,java.lang.Long>> handler) { 
    delegate.methodWithNullableMapLongHandler(notNull, handler);
  }

  public void methodWithNullableMapLongHandlerAsyncResult(boolean notNull, io.vertx.core.Handler<io.vertx.core.AsyncResult<java.util.Map<java.lang.String,java.lang.Long>>> handler) { 
    delegate.methodWithNullableMapLongHandlerAsyncResult(notNull, handler);
  }

  public void methodWithNullableMapLongHandlerAsyncResult(boolean notNull) {
    methodWithNullableMapLongHandlerAsyncResult(notNull, ar -> { });
  }

  public io.reactivex.Maybe<java.util.Map<java.lang.String,java.lang.Long>> rxMethodWithNullableMapLongHandlerAsyncResult(boolean notNull) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      methodWithNullableMapLongHandlerAsyncResult(notNull, $handler);
    });
  }

  public java.util.Map<java.lang.String,java.lang.Long> methodWithNullableMapLongReturn(boolean notNull) { 
    java.util.Map<java.lang.String,java.lang.Long> ret = delegate.methodWithNullableMapLongReturn(notNull);
    return ret;
  }

  public boolean methodWithNonNullableMapFloatParam(java.util.Map<java.lang.String,java.lang.Float> param) { 
    boolean ret = delegate.methodWithNonNullableMapFloatParam(param);
    return ret;
  }

  public void methodWithNullableMapFloatParam(boolean expectNull, java.util.Map<java.lang.String,java.lang.Float> param) { 
    delegate.methodWithNullableMapFloatParam(expectNull, param);
  }

  public void methodWithNullableMapFloatHandler(boolean notNull, io.vertx.core.Handler<java.util.Map<java.lang.String,java.lang.Float>> handler) { 
    delegate.methodWithNullableMapFloatHandler(notNull, handler);
  }

  public void methodWithNullableMapFloatHandlerAsyncResult(boolean notNull, io.vertx.core.Handler<io.vertx.core.AsyncResult<java.util.Map<java.lang.String,java.lang.Float>>> handler) { 
    delegate.methodWithNullableMapFloatHandlerAsyncResult(notNull, handler);
  }

  public void methodWithNullableMapFloatHandlerAsyncResult(boolean notNull) {
    methodWithNullableMapFloatHandlerAsyncResult(notNull, ar -> { });
  }

  public io.reactivex.Maybe<java.util.Map<java.lang.String,java.lang.Float>> rxMethodWithNullableMapFloatHandlerAsyncResult(boolean notNull) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      methodWithNullableMapFloatHandlerAsyncResult(notNull, $handler);
    });
  }

  public java.util.Map<java.lang.String,java.lang.Float> methodWithNullableMapFloatReturn(boolean notNull) { 
    java.util.Map<java.lang.String,java.lang.Float> ret = delegate.methodWithNullableMapFloatReturn(notNull);
    return ret;
  }

  public boolean methodWithNonNullableMapDoubleParam(java.util.Map<java.lang.String,java.lang.Double> param) { 
    boolean ret = delegate.methodWithNonNullableMapDoubleParam(param);
    return ret;
  }

  public void methodWithNullableMapDoubleParam(boolean expectNull, java.util.Map<java.lang.String,java.lang.Double> param) { 
    delegate.methodWithNullableMapDoubleParam(expectNull, param);
  }

  public void methodWithNullableMapDoubleHandler(boolean notNull, io.vertx.core.Handler<java.util.Map<java.lang.String,java.lang.Double>> handler) { 
    delegate.methodWithNullableMapDoubleHandler(notNull, handler);
  }

  public void methodWithNullableMapDoubleHandlerAsyncResult(boolean notNull, io.vertx.core.Handler<io.vertx.core.AsyncResult<java.util.Map<java.lang.String,java.lang.Double>>> handler) { 
    delegate.methodWithNullableMapDoubleHandlerAsyncResult(notNull, handler);
  }

  public void methodWithNullableMapDoubleHandlerAsyncResult(boolean notNull) {
    methodWithNullableMapDoubleHandlerAsyncResult(notNull, ar -> { });
  }

  public io.reactivex.Maybe<java.util.Map<java.lang.String,java.lang.Double>> rxMethodWithNullableMapDoubleHandlerAsyncResult(boolean notNull) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      methodWithNullableMapDoubleHandlerAsyncResult(notNull, $handler);
    });
  }

  public java.util.Map<java.lang.String,java.lang.Double> methodWithNullableMapDoubleReturn(boolean notNull) { 
    java.util.Map<java.lang.String,java.lang.Double> ret = delegate.methodWithNullableMapDoubleReturn(notNull);
    return ret;
  }

  public boolean methodWithNonNullableMapBooleanParam(java.util.Map<java.lang.String,java.lang.Boolean> param) { 
    boolean ret = delegate.methodWithNonNullableMapBooleanParam(param);
    return ret;
  }

  public void methodWithNullableMapBooleanParam(boolean expectNull, java.util.Map<java.lang.String,java.lang.Boolean> param) { 
    delegate.methodWithNullableMapBooleanParam(expectNull, param);
  }

  public void methodWithNullableMapBooleanHandler(boolean notNull, io.vertx.core.Handler<java.util.Map<java.lang.String,java.lang.Boolean>> handler) { 
    delegate.methodWithNullableMapBooleanHandler(notNull, handler);
  }

  public void methodWithNullableMapBooleanHandlerAsyncResult(boolean notNull, io.vertx.core.Handler<io.vertx.core.AsyncResult<java.util.Map<java.lang.String,java.lang.Boolean>>> handler) { 
    delegate.methodWithNullableMapBooleanHandlerAsyncResult(notNull, handler);
  }

  public void methodWithNullableMapBooleanHandlerAsyncResult(boolean notNull) {
    methodWithNullableMapBooleanHandlerAsyncResult(notNull, ar -> { });
  }

  public io.reactivex.Maybe<java.util.Map<java.lang.String,java.lang.Boolean>> rxMethodWithNullableMapBooleanHandlerAsyncResult(boolean notNull) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      methodWithNullableMapBooleanHandlerAsyncResult(notNull, $handler);
    });
  }

  public java.util.Map<java.lang.String,java.lang.Boolean> methodWithNullableMapBooleanReturn(boolean notNull) { 
    java.util.Map<java.lang.String,java.lang.Boolean> ret = delegate.methodWithNullableMapBooleanReturn(notNull);
    return ret;
  }

  public boolean methodWithNonNullableMapStringParam(java.util.Map<java.lang.String,java.lang.String> param) { 
    boolean ret = delegate.methodWithNonNullableMapStringParam(param);
    return ret;
  }

  public void methodWithNullableMapStringParam(boolean expectNull, java.util.Map<java.lang.String,java.lang.String> param) { 
    delegate.methodWithNullableMapStringParam(expectNull, param);
  }

  public void methodWithNullableMapStringHandler(boolean notNull, io.vertx.core.Handler<java.util.Map<java.lang.String,java.lang.String>> handler) { 
    delegate.methodWithNullableMapStringHandler(notNull, handler);
  }

  public void methodWithNullableMapStringHandlerAsyncResult(boolean notNull, io.vertx.core.Handler<io.vertx.core.AsyncResult<java.util.Map<java.lang.String,java.lang.String>>> handler) { 
    delegate.methodWithNullableMapStringHandlerAsyncResult(notNull, handler);
  }

  public void methodWithNullableMapStringHandlerAsyncResult(boolean notNull) {
    methodWithNullableMapStringHandlerAsyncResult(notNull, ar -> { });
  }

  public io.reactivex.Maybe<java.util.Map<java.lang.String,java.lang.String>> rxMethodWithNullableMapStringHandlerAsyncResult(boolean notNull) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      methodWithNullableMapStringHandlerAsyncResult(notNull, $handler);
    });
  }

  public java.util.Map<java.lang.String,java.lang.String> methodWithNullableMapStringReturn(boolean notNull) { 
    java.util.Map<java.lang.String,java.lang.String> ret = delegate.methodWithNullableMapStringReturn(notNull);
    return ret;
  }

  public boolean methodWithNonNullableMapCharParam(java.util.Map<java.lang.String,java.lang.Character> param) { 
    boolean ret = delegate.methodWithNonNullableMapCharParam(param);
    return ret;
  }

  public void methodWithNullableMapCharParam(boolean expectNull, java.util.Map<java.lang.String,java.lang.Character> param) { 
    delegate.methodWithNullableMapCharParam(expectNull, param);
  }

  public void methodWithNullableMapCharHandler(boolean notNull, io.vertx.core.Handler<java.util.Map<java.lang.String,java.lang.Character>> handler) { 
    delegate.methodWithNullableMapCharHandler(notNull, handler);
  }

  public void methodWithNullableMapCharHandlerAsyncResult(boolean notNull, io.vertx.core.Handler<io.vertx.core.AsyncResult<java.util.Map<java.lang.String,java.lang.Character>>> handler) { 
    delegate.methodWithNullableMapCharHandlerAsyncResult(notNull, handler);
  }

  public void methodWithNullableMapCharHandlerAsyncResult(boolean notNull) {
    methodWithNullableMapCharHandlerAsyncResult(notNull, ar -> { });
  }

  public io.reactivex.Maybe<java.util.Map<java.lang.String,java.lang.Character>> rxMethodWithNullableMapCharHandlerAsyncResult(boolean notNull) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      methodWithNullableMapCharHandlerAsyncResult(notNull, $handler);
    });
  }

  public java.util.Map<java.lang.String,java.lang.Character> methodWithNullableMapCharReturn(boolean notNull) { 
    java.util.Map<java.lang.String,java.lang.Character> ret = delegate.methodWithNullableMapCharReturn(notNull);
    return ret;
  }

  public boolean methodWithNonNullableMapJsonObjectParam(java.util.Map<java.lang.String,io.vertx.core.json.JsonObject> param) { 
    boolean ret = delegate.methodWithNonNullableMapJsonObjectParam(param);
    return ret;
  }

  public void methodWithNullableMapJsonObjectParam(boolean expectNull, java.util.Map<java.lang.String,io.vertx.core.json.JsonObject> param) { 
    delegate.methodWithNullableMapJsonObjectParam(expectNull, param);
  }

  public void methodWithNullableMapJsonObjectHandler(boolean notNull, io.vertx.core.Handler<java.util.Map<java.lang.String,io.vertx.core.json.JsonObject>> handler) { 
    delegate.methodWithNullableMapJsonObjectHandler(notNull, handler);
  }

  public void methodWithNullableMapJsonObjectHandlerAsyncResult(boolean notNull, io.vertx.core.Handler<io.vertx.core.AsyncResult<java.util.Map<java.lang.String,io.vertx.core.json.JsonObject>>> handler) { 
    delegate.methodWithNullableMapJsonObjectHandlerAsyncResult(notNull, handler);
  }

  public void methodWithNullableMapJsonObjectHandlerAsyncResult(boolean notNull) {
    methodWithNullableMapJsonObjectHandlerAsyncResult(notNull, ar -> { });
  }

  public io.reactivex.Maybe<java.util.Map<java.lang.String,io.vertx.core.json.JsonObject>> rxMethodWithNullableMapJsonObjectHandlerAsyncResult(boolean notNull) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      methodWithNullableMapJsonObjectHandlerAsyncResult(notNull, $handler);
    });
  }

  public java.util.Map<java.lang.String,io.vertx.core.json.JsonObject> methodWithNullableMapJsonObjectReturn(boolean notNull) { 
    java.util.Map<java.lang.String,io.vertx.core.json.JsonObject> ret = delegate.methodWithNullableMapJsonObjectReturn(notNull);
    return ret;
  }

  public boolean methodWithNonNullableMapJsonArrayParam(java.util.Map<java.lang.String,io.vertx.core.json.JsonArray> param) { 
    boolean ret = delegate.methodWithNonNullableMapJsonArrayParam(param);
    return ret;
  }

  public void methodWithNullableMapJsonArrayParam(boolean expectNull, java.util.Map<java.lang.String,io.vertx.core.json.JsonArray> param) { 
    delegate.methodWithNullableMapJsonArrayParam(expectNull, param);
  }

  public void methodWithNullableMapJsonArrayHandler(boolean notNull, io.vertx.core.Handler<java.util.Map<java.lang.String,io.vertx.core.json.JsonArray>> handler) { 
    delegate.methodWithNullableMapJsonArrayHandler(notNull, handler);
  }

  public void methodWithNullableMapJsonArrayHandlerAsyncResult(boolean notNull, io.vertx.core.Handler<io.vertx.core.AsyncResult<java.util.Map<java.lang.String,io.vertx.core.json.JsonArray>>> handler) { 
    delegate.methodWithNullableMapJsonArrayHandlerAsyncResult(notNull, handler);
  }

  public void methodWithNullableMapJsonArrayHandlerAsyncResult(boolean notNull) {
    methodWithNullableMapJsonArrayHandlerAsyncResult(notNull, ar -> { });
  }

  public io.reactivex.Maybe<java.util.Map<java.lang.String,io.vertx.core.json.JsonArray>> rxMethodWithNullableMapJsonArrayHandlerAsyncResult(boolean notNull) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      methodWithNullableMapJsonArrayHandlerAsyncResult(notNull, $handler);
    });
  }

  public java.util.Map<java.lang.String,io.vertx.core.json.JsonArray> methodWithNullableMapJsonArrayReturn(boolean notNull) { 
    java.util.Map<java.lang.String,io.vertx.core.json.JsonArray> ret = delegate.methodWithNullableMapJsonArrayReturn(notNull);
    return ret;
  }

  public boolean methodWithNonNullableMapApiParam(java.util.Map<java.lang.String,io.vertx.reactivex.codegen.testmodel.RefedInterface1> param) { 
    boolean ret = delegate.methodWithNonNullableMapApiParam(param.entrySet().stream().collect(Collectors.toMap(e -> e.getKey(), e -> e.getValue().getDelegate())));
    return ret;
  }

  public void methodWithNullableMapApiParam(boolean expectNull, java.util.Map<java.lang.String,io.vertx.reactivex.codegen.testmodel.RefedInterface1> param) { 
    delegate.methodWithNullableMapApiParam(expectNull, param.entrySet().stream().collect(Collectors.toMap(e -> e.getKey(), e -> e.getValue().getDelegate())));
  }

  public void methodWithListNullableByteParam(java.util.List<java.lang.Byte> param) { 
    delegate.methodWithListNullableByteParam(param);
  }

  public void methodWithListNullableByteHandler(io.vertx.core.Handler<java.util.List<java.lang.Byte>> handler) { 
    delegate.methodWithListNullableByteHandler(handler);
  }

  public void methodWithListNullableByteHandlerAsyncResult(io.vertx.core.Handler<io.vertx.core.AsyncResult<java.util.List<java.lang.Byte>>> handler) { 
    delegate.methodWithListNullableByteHandlerAsyncResult(handler);
  }

  public void methodWithListNullableByteHandlerAsyncResult() {
    methodWithListNullableByteHandlerAsyncResult(ar -> { });
  }

  public io.reactivex.Single<java.util.List<java.lang.Byte>> rxMethodWithListNullableByteHandlerAsyncResult() { 
    return AsyncResultSingle.toSingle($handler -> {
      methodWithListNullableByteHandlerAsyncResult($handler);
    });
  }

  public java.util.List<java.lang.Byte> methodWithListNullableByteReturn() { 
    java.util.List<java.lang.Byte> ret = delegate.methodWithListNullableByteReturn();
    return ret;
  }

  public void methodWithListNullableShortParam(java.util.List<java.lang.Short> param) { 
    delegate.methodWithListNullableShortParam(param);
  }

  public void methodWithListNullableShortHandler(io.vertx.core.Handler<java.util.List<java.lang.Short>> handler) { 
    delegate.methodWithListNullableShortHandler(handler);
  }

  public void methodWithListNullableShortHandlerAsyncResult(io.vertx.core.Handler<io.vertx.core.AsyncResult<java.util.List<java.lang.Short>>> handler) { 
    delegate.methodWithListNullableShortHandlerAsyncResult(handler);
  }

  public void methodWithListNullableShortHandlerAsyncResult() {
    methodWithListNullableShortHandlerAsyncResult(ar -> { });
  }

  public io.reactivex.Single<java.util.List<java.lang.Short>> rxMethodWithListNullableShortHandlerAsyncResult() { 
    return AsyncResultSingle.toSingle($handler -> {
      methodWithListNullableShortHandlerAsyncResult($handler);
    });
  }

  public java.util.List<java.lang.Short> methodWithListNullableShortReturn() { 
    java.util.List<java.lang.Short> ret = delegate.methodWithListNullableShortReturn();
    return ret;
  }

  public void methodWithListNullableIntegerParam(java.util.List<java.lang.Integer> param) { 
    delegate.methodWithListNullableIntegerParam(param);
  }

  public void methodWithListNullableIntegerHandler(io.vertx.core.Handler<java.util.List<java.lang.Integer>> handler) { 
    delegate.methodWithListNullableIntegerHandler(handler);
  }

  public void methodWithListNullableIntegerHandlerAsyncResult(io.vertx.core.Handler<io.vertx.core.AsyncResult<java.util.List<java.lang.Integer>>> handler) { 
    delegate.methodWithListNullableIntegerHandlerAsyncResult(handler);
  }

  public void methodWithListNullableIntegerHandlerAsyncResult() {
    methodWithListNullableIntegerHandlerAsyncResult(ar -> { });
  }

  public io.reactivex.Single<java.util.List<java.lang.Integer>> rxMethodWithListNullableIntegerHandlerAsyncResult() { 
    return AsyncResultSingle.toSingle($handler -> {
      methodWithListNullableIntegerHandlerAsyncResult($handler);
    });
  }

  public java.util.List<java.lang.Integer> methodWithListNullableIntegerReturn() { 
    java.util.List<java.lang.Integer> ret = delegate.methodWithListNullableIntegerReturn();
    return ret;
  }

  public void methodWithListNullableLongParam(java.util.List<java.lang.Long> param) { 
    delegate.methodWithListNullableLongParam(param);
  }

  public void methodWithListNullableLongHandler(io.vertx.core.Handler<java.util.List<java.lang.Long>> handler) { 
    delegate.methodWithListNullableLongHandler(handler);
  }

  public void methodWithListNullableLongHandlerAsyncResult(io.vertx.core.Handler<io.vertx.core.AsyncResult<java.util.List<java.lang.Long>>> handler) { 
    delegate.methodWithListNullableLongHandlerAsyncResult(handler);
  }

  public void methodWithListNullableLongHandlerAsyncResult() {
    methodWithListNullableLongHandlerAsyncResult(ar -> { });
  }

  public io.reactivex.Single<java.util.List<java.lang.Long>> rxMethodWithListNullableLongHandlerAsyncResult() { 
    return AsyncResultSingle.toSingle($handler -> {
      methodWithListNullableLongHandlerAsyncResult($handler);
    });
  }

  public java.util.List<java.lang.Long> methodWithListNullableLongReturn() { 
    java.util.List<java.lang.Long> ret = delegate.methodWithListNullableLongReturn();
    return ret;
  }

  public void methodWithListNullableBooleanParam(java.util.List<java.lang.Boolean> param) { 
    delegate.methodWithListNullableBooleanParam(param);
  }

  public void methodWithListNullableBooleanHandler(io.vertx.core.Handler<java.util.List<java.lang.Boolean>> handler) { 
    delegate.methodWithListNullableBooleanHandler(handler);
  }

  public void methodWithListNullableBooleanHandlerAsyncResult(io.vertx.core.Handler<io.vertx.core.AsyncResult<java.util.List<java.lang.Boolean>>> handler) { 
    delegate.methodWithListNullableBooleanHandlerAsyncResult(handler);
  }

  public void methodWithListNullableBooleanHandlerAsyncResult() {
    methodWithListNullableBooleanHandlerAsyncResult(ar -> { });
  }

  public io.reactivex.Single<java.util.List<java.lang.Boolean>> rxMethodWithListNullableBooleanHandlerAsyncResult() { 
    return AsyncResultSingle.toSingle($handler -> {
      methodWithListNullableBooleanHandlerAsyncResult($handler);
    });
  }

  public java.util.List<java.lang.Boolean> methodWithListNullableBooleanReturn() { 
    java.util.List<java.lang.Boolean> ret = delegate.methodWithListNullableBooleanReturn();
    return ret;
  }

  public void methodWithListNullableFloatParam(java.util.List<java.lang.Float> param) { 
    delegate.methodWithListNullableFloatParam(param);
  }

  public void methodWithListNullableFloatHandler(io.vertx.core.Handler<java.util.List<java.lang.Float>> handler) { 
    delegate.methodWithListNullableFloatHandler(handler);
  }

  public void methodWithListNullableFloatHandlerAsyncResult(io.vertx.core.Handler<io.vertx.core.AsyncResult<java.util.List<java.lang.Float>>> handler) { 
    delegate.methodWithListNullableFloatHandlerAsyncResult(handler);
  }

  public void methodWithListNullableFloatHandlerAsyncResult() {
    methodWithListNullableFloatHandlerAsyncResult(ar -> { });
  }

  public io.reactivex.Single<java.util.List<java.lang.Float>> rxMethodWithListNullableFloatHandlerAsyncResult() { 
    return AsyncResultSingle.toSingle($handler -> {
      methodWithListNullableFloatHandlerAsyncResult($handler);
    });
  }

  public java.util.List<java.lang.Float> methodWithListNullableFloatReturn() { 
    java.util.List<java.lang.Float> ret = delegate.methodWithListNullableFloatReturn();
    return ret;
  }

  public void methodWithListNullableDoubleParam(java.util.List<java.lang.Double> param) { 
    delegate.methodWithListNullableDoubleParam(param);
  }

  public void methodWithListNullableDoubleHandler(io.vertx.core.Handler<java.util.List<java.lang.Double>> handler) { 
    delegate.methodWithListNullableDoubleHandler(handler);
  }

  public void methodWithListNullableDoubleHandlerAsyncResult(io.vertx.core.Handler<io.vertx.core.AsyncResult<java.util.List<java.lang.Double>>> handler) { 
    delegate.methodWithListNullableDoubleHandlerAsyncResult(handler);
  }

  public void methodWithListNullableDoubleHandlerAsyncResult() {
    methodWithListNullableDoubleHandlerAsyncResult(ar -> { });
  }

  public io.reactivex.Single<java.util.List<java.lang.Double>> rxMethodWithListNullableDoubleHandlerAsyncResult() { 
    return AsyncResultSingle.toSingle($handler -> {
      methodWithListNullableDoubleHandlerAsyncResult($handler);
    });
  }

  public java.util.List<java.lang.Double> methodWithListNullableDoubleReturn() { 
    java.util.List<java.lang.Double> ret = delegate.methodWithListNullableDoubleReturn();
    return ret;
  }

  public void methodWithListNullableStringParam(java.util.List<java.lang.String> param) { 
    delegate.methodWithListNullableStringParam(param);
  }

  public void methodWithListNullableStringHandler(io.vertx.core.Handler<java.util.List<java.lang.String>> handler) { 
    delegate.methodWithListNullableStringHandler(handler);
  }

  public void methodWithListNullableStringHandlerAsyncResult(io.vertx.core.Handler<io.vertx.core.AsyncResult<java.util.List<java.lang.String>>> handler) { 
    delegate.methodWithListNullableStringHandlerAsyncResult(handler);
  }

  public void methodWithListNullableStringHandlerAsyncResult() {
    methodWithListNullableStringHandlerAsyncResult(ar -> { });
  }

  public io.reactivex.Single<java.util.List<java.lang.String>> rxMethodWithListNullableStringHandlerAsyncResult() { 
    return AsyncResultSingle.toSingle($handler -> {
      methodWithListNullableStringHandlerAsyncResult($handler);
    });
  }

  public java.util.List<java.lang.String> methodWithListNullableStringReturn() { 
    java.util.List<java.lang.String> ret = delegate.methodWithListNullableStringReturn();
    return ret;
  }

  public void methodWithListNullableCharParam(java.util.List<java.lang.Character> param) { 
    delegate.methodWithListNullableCharParam(param);
  }

  public void methodWithListNullableCharHandler(io.vertx.core.Handler<java.util.List<java.lang.Character>> handler) { 
    delegate.methodWithListNullableCharHandler(handler);
  }

  public void methodWithListNullableCharHandlerAsyncResult(io.vertx.core.Handler<io.vertx.core.AsyncResult<java.util.List<java.lang.Character>>> handler) { 
    delegate.methodWithListNullableCharHandlerAsyncResult(handler);
  }

  public void methodWithListNullableCharHandlerAsyncResult() {
    methodWithListNullableCharHandlerAsyncResult(ar -> { });
  }

  public io.reactivex.Single<java.util.List<java.lang.Character>> rxMethodWithListNullableCharHandlerAsyncResult() { 
    return AsyncResultSingle.toSingle($handler -> {
      methodWithListNullableCharHandlerAsyncResult($handler);
    });
  }

  public java.util.List<java.lang.Character> methodWithListNullableCharReturn() { 
    java.util.List<java.lang.Character> ret = delegate.methodWithListNullableCharReturn();
    return ret;
  }

  public void methodWithListNullableJsonObjectParam(java.util.List<io.vertx.core.json.JsonObject> param) { 
    delegate.methodWithListNullableJsonObjectParam(param);
  }

  public void methodWithListNullableJsonObjectHandler(io.vertx.core.Handler<java.util.List<io.vertx.core.json.JsonObject>> handler) { 
    delegate.methodWithListNullableJsonObjectHandler(handler);
  }

  public void methodWithListNullableJsonObjectHandlerAsyncResult(io.vertx.core.Handler<io.vertx.core.AsyncResult<java.util.List<io.vertx.core.json.JsonObject>>> handler) { 
    delegate.methodWithListNullableJsonObjectHandlerAsyncResult(handler);
  }

  public void methodWithListNullableJsonObjectHandlerAsyncResult() {
    methodWithListNullableJsonObjectHandlerAsyncResult(ar -> { });
  }

  public io.reactivex.Single<java.util.List<io.vertx.core.json.JsonObject>> rxMethodWithListNullableJsonObjectHandlerAsyncResult() { 
    return AsyncResultSingle.toSingle($handler -> {
      methodWithListNullableJsonObjectHandlerAsyncResult($handler);
    });
  }

  public java.util.List<io.vertx.core.json.JsonObject> methodWithListNullableJsonObjectReturn() { 
    java.util.List<io.vertx.core.json.JsonObject> ret = delegate.methodWithListNullableJsonObjectReturn();
    return ret;
  }

  public void methodWithListNullableJsonArrayParam(java.util.List<io.vertx.core.json.JsonArray> param) { 
    delegate.methodWithListNullableJsonArrayParam(param);
  }

  public void methodWithListNullableJsonArrayHandler(io.vertx.core.Handler<java.util.List<io.vertx.core.json.JsonArray>> handler) { 
    delegate.methodWithListNullableJsonArrayHandler(handler);
  }

  public void methodWithListNullableJsonArrayHandlerAsyncResult(io.vertx.core.Handler<io.vertx.core.AsyncResult<java.util.List<io.vertx.core.json.JsonArray>>> handler) { 
    delegate.methodWithListNullableJsonArrayHandlerAsyncResult(handler);
  }

  public void methodWithListNullableJsonArrayHandlerAsyncResult() {
    methodWithListNullableJsonArrayHandlerAsyncResult(ar -> { });
  }

  public io.reactivex.Single<java.util.List<io.vertx.core.json.JsonArray>> rxMethodWithListNullableJsonArrayHandlerAsyncResult() { 
    return AsyncResultSingle.toSingle($handler -> {
      methodWithListNullableJsonArrayHandlerAsyncResult($handler);
    });
  }

  public java.util.List<io.vertx.core.json.JsonArray> methodWithListNullableJsonArrayReturn() { 
    java.util.List<io.vertx.core.json.JsonArray> ret = delegate.methodWithListNullableJsonArrayReturn();
    return ret;
  }

  public void methodWithListNullableApiParam(java.util.List<io.vertx.reactivex.codegen.testmodel.RefedInterface1> param) { 
    delegate.methodWithListNullableApiParam(param.stream().map(elt -> elt.getDelegate()).collect(Collectors.toList()));
  }

  public void methodWithListNullableApiHandler(io.vertx.core.Handler<java.util.List<io.vertx.reactivex.codegen.testmodel.RefedInterface1>> handler) { 
    delegate.methodWithListNullableApiHandler(new Handler<java.util.List<io.vertx.codegen.testmodel.RefedInterface1>>() {
      public void handle(java.util.List<io.vertx.codegen.testmodel.RefedInterface1> event) {
        handler.handle(event.stream().map(elt -> io.vertx.reactivex.codegen.testmodel.RefedInterface1.newInstance((io.vertx.codegen.testmodel.RefedInterface1)elt)).collect(Collectors.toList()));
      }
    });
  }

  public void methodWithListNullableApiHandlerAsyncResult(io.vertx.core.Handler<io.vertx.core.AsyncResult<java.util.List<io.vertx.reactivex.codegen.testmodel.RefedInterface1>>> handler) { 
    delegate.methodWithListNullableApiHandlerAsyncResult(new Handler<AsyncResult<java.util.List<io.vertx.codegen.testmodel.RefedInterface1>>>() {
      public void handle(AsyncResult<java.util.List<io.vertx.codegen.testmodel.RefedInterface1>> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(ar.result().stream().map(elt -> io.vertx.reactivex.codegen.testmodel.RefedInterface1.newInstance((io.vertx.codegen.testmodel.RefedInterface1)elt)).collect(Collectors.toList())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
  }

  public void methodWithListNullableApiHandlerAsyncResult() {
    methodWithListNullableApiHandlerAsyncResult(ar -> { });
  }

  public io.reactivex.Single<java.util.List<io.vertx.reactivex.codegen.testmodel.RefedInterface1>> rxMethodWithListNullableApiHandlerAsyncResult() { 
    return AsyncResultSingle.toSingle($handler -> {
      methodWithListNullableApiHandlerAsyncResult($handler);
    });
  }

  public java.util.List<io.vertx.reactivex.codegen.testmodel.RefedInterface1> methodWithListNullableApiReturn() { 
    java.util.List<io.vertx.reactivex.codegen.testmodel.RefedInterface1> ret = delegate.methodWithListNullableApiReturn().stream().map(elt -> io.vertx.reactivex.codegen.testmodel.RefedInterface1.newInstance((io.vertx.codegen.testmodel.RefedInterface1)elt)).collect(Collectors.toList());
    return ret;
  }

  public void methodWithListNullableDataObjectParam(java.util.List<io.vertx.codegen.testmodel.TestDataObject> param) { 
    delegate.methodWithListNullableDataObjectParam(param);
  }

  public void methodWithListNullableDataObjectHandler(io.vertx.core.Handler<java.util.List<io.vertx.codegen.testmodel.TestDataObject>> handler) { 
    delegate.methodWithListNullableDataObjectHandler(handler);
  }

  public void methodWithListNullableDataObjectHandlerAsyncResult(io.vertx.core.Handler<io.vertx.core.AsyncResult<java.util.List<io.vertx.codegen.testmodel.TestDataObject>>> handler) { 
    delegate.methodWithListNullableDataObjectHandlerAsyncResult(handler);
  }

  public void methodWithListNullableDataObjectHandlerAsyncResult() {
    methodWithListNullableDataObjectHandlerAsyncResult(ar -> { });
  }

  public io.reactivex.Single<java.util.List<io.vertx.codegen.testmodel.TestDataObject>> rxMethodWithListNullableDataObjectHandlerAsyncResult() { 
    return AsyncResultSingle.toSingle($handler -> {
      methodWithListNullableDataObjectHandlerAsyncResult($handler);
    });
  }

  public java.util.List<io.vertx.codegen.testmodel.TestDataObject> methodWithListNullableDataObjectReturn() { 
    java.util.List<io.vertx.codegen.testmodel.TestDataObject> ret = delegate.methodWithListNullableDataObjectReturn();
    return ret;
  }

  public void methodWithListNullableEnumParam(java.util.List<io.vertx.codegen.testmodel.TestEnum> param) { 
    delegate.methodWithListNullableEnumParam(param);
  }

  public void methodWithListNullableEnumHandler(io.vertx.core.Handler<java.util.List<io.vertx.codegen.testmodel.TestEnum>> handler) { 
    delegate.methodWithListNullableEnumHandler(handler);
  }

  public void methodWithListNullableEnumHandlerAsyncResult(io.vertx.core.Handler<io.vertx.core.AsyncResult<java.util.List<io.vertx.codegen.testmodel.TestEnum>>> handler) { 
    delegate.methodWithListNullableEnumHandlerAsyncResult(handler);
  }

  public void methodWithListNullableEnumHandlerAsyncResult() {
    methodWithListNullableEnumHandlerAsyncResult(ar -> { });
  }

  public io.reactivex.Single<java.util.List<io.vertx.codegen.testmodel.TestEnum>> rxMethodWithListNullableEnumHandlerAsyncResult() { 
    return AsyncResultSingle.toSingle($handler -> {
      methodWithListNullableEnumHandlerAsyncResult($handler);
    });
  }

  public java.util.List<io.vertx.codegen.testmodel.TestEnum> methodWithListNullableEnumReturn() { 
    java.util.List<io.vertx.codegen.testmodel.TestEnum> ret = delegate.methodWithListNullableEnumReturn();
    return ret;
  }

  public void methodWithListNullableGenEnumParam(java.util.List<io.vertx.codegen.testmodel.TestGenEnum> param) { 
    delegate.methodWithListNullableGenEnumParam(param);
  }

  public void methodWithListNullableGenEnumHandler(io.vertx.core.Handler<java.util.List<io.vertx.codegen.testmodel.TestGenEnum>> handler) { 
    delegate.methodWithListNullableGenEnumHandler(handler);
  }

  public void methodWithListNullableGenEnumHandlerAsyncResult(io.vertx.core.Handler<io.vertx.core.AsyncResult<java.util.List<io.vertx.codegen.testmodel.TestGenEnum>>> handler) { 
    delegate.methodWithListNullableGenEnumHandlerAsyncResult(handler);
  }

  public void methodWithListNullableGenEnumHandlerAsyncResult() {
    methodWithListNullableGenEnumHandlerAsyncResult(ar -> { });
  }

  public io.reactivex.Single<java.util.List<io.vertx.codegen.testmodel.TestGenEnum>> rxMethodWithListNullableGenEnumHandlerAsyncResult() { 
    return AsyncResultSingle.toSingle($handler -> {
      methodWithListNullableGenEnumHandlerAsyncResult($handler);
    });
  }

  public java.util.List<io.vertx.codegen.testmodel.TestGenEnum> methodWithListNullableGenEnumReturn() { 
    java.util.List<io.vertx.codegen.testmodel.TestGenEnum> ret = delegate.methodWithListNullableGenEnumReturn();
    return ret;
  }

  public void methodWithSetNullableByteParam(java.util.Set<java.lang.Byte> param) { 
    delegate.methodWithSetNullableByteParam(param);
  }

  public void methodWithSetNullableByteHandler(io.vertx.core.Handler<java.util.Set<java.lang.Byte>> handler) { 
    delegate.methodWithSetNullableByteHandler(handler);
  }

  public void methodWithSetNullableByteHandlerAsyncResult(io.vertx.core.Handler<io.vertx.core.AsyncResult<java.util.Set<java.lang.Byte>>> handler) { 
    delegate.methodWithSetNullableByteHandlerAsyncResult(handler);
  }

  public void methodWithSetNullableByteHandlerAsyncResult() {
    methodWithSetNullableByteHandlerAsyncResult(ar -> { });
  }

  public io.reactivex.Single<java.util.Set<java.lang.Byte>> rxMethodWithSetNullableByteHandlerAsyncResult() { 
    return AsyncResultSingle.toSingle($handler -> {
      methodWithSetNullableByteHandlerAsyncResult($handler);
    });
  }

  public java.util.Set<java.lang.Byte> methodWithSetNullableByteReturn() { 
    java.util.Set<java.lang.Byte> ret = delegate.methodWithSetNullableByteReturn();
    return ret;
  }

  public void methodWithSetNullableShortParam(java.util.Set<java.lang.Short> param) { 
    delegate.methodWithSetNullableShortParam(param);
  }

  public void methodWithSetNullableShortHandler(io.vertx.core.Handler<java.util.Set<java.lang.Short>> handler) { 
    delegate.methodWithSetNullableShortHandler(handler);
  }

  public void methodWithSetNullableShortHandlerAsyncResult(io.vertx.core.Handler<io.vertx.core.AsyncResult<java.util.Set<java.lang.Short>>> handler) { 
    delegate.methodWithSetNullableShortHandlerAsyncResult(handler);
  }

  public void methodWithSetNullableShortHandlerAsyncResult() {
    methodWithSetNullableShortHandlerAsyncResult(ar -> { });
  }

  public io.reactivex.Single<java.util.Set<java.lang.Short>> rxMethodWithSetNullableShortHandlerAsyncResult() { 
    return AsyncResultSingle.toSingle($handler -> {
      methodWithSetNullableShortHandlerAsyncResult($handler);
    });
  }

  public java.util.Set<java.lang.Short> methodWithSetNullableShortReturn() { 
    java.util.Set<java.lang.Short> ret = delegate.methodWithSetNullableShortReturn();
    return ret;
  }

  public void methodWithSetNullableIntegerParam(java.util.Set<java.lang.Integer> param) { 
    delegate.methodWithSetNullableIntegerParam(param);
  }

  public void methodWithSetNullableIntegerHandler(io.vertx.core.Handler<java.util.Set<java.lang.Integer>> handler) { 
    delegate.methodWithSetNullableIntegerHandler(handler);
  }

  public void methodWithSetNullableIntegerHandlerAsyncResult(io.vertx.core.Handler<io.vertx.core.AsyncResult<java.util.Set<java.lang.Integer>>> handler) { 
    delegate.methodWithSetNullableIntegerHandlerAsyncResult(handler);
  }

  public void methodWithSetNullableIntegerHandlerAsyncResult() {
    methodWithSetNullableIntegerHandlerAsyncResult(ar -> { });
  }

  public io.reactivex.Single<java.util.Set<java.lang.Integer>> rxMethodWithSetNullableIntegerHandlerAsyncResult() { 
    return AsyncResultSingle.toSingle($handler -> {
      methodWithSetNullableIntegerHandlerAsyncResult($handler);
    });
  }

  public java.util.Set<java.lang.Integer> methodWithSetNullableIntegerReturn() { 
    java.util.Set<java.lang.Integer> ret = delegate.methodWithSetNullableIntegerReturn();
    return ret;
  }

  public void methodWithSetNullableLongParam(java.util.Set<java.lang.Long> param) { 
    delegate.methodWithSetNullableLongParam(param);
  }

  public void methodWithSetNullableLongHandler(io.vertx.core.Handler<java.util.Set<java.lang.Long>> handler) { 
    delegate.methodWithSetNullableLongHandler(handler);
  }

  public void methodWithSetNullableLongHandlerAsyncResult(io.vertx.core.Handler<io.vertx.core.AsyncResult<java.util.Set<java.lang.Long>>> handler) { 
    delegate.methodWithSetNullableLongHandlerAsyncResult(handler);
  }

  public void methodWithSetNullableLongHandlerAsyncResult() {
    methodWithSetNullableLongHandlerAsyncResult(ar -> { });
  }

  public io.reactivex.Single<java.util.Set<java.lang.Long>> rxMethodWithSetNullableLongHandlerAsyncResult() { 
    return AsyncResultSingle.toSingle($handler -> {
      methodWithSetNullableLongHandlerAsyncResult($handler);
    });
  }

  public java.util.Set<java.lang.Long> methodWithSetNullableLongReturn() { 
    java.util.Set<java.lang.Long> ret = delegate.methodWithSetNullableLongReturn();
    return ret;
  }

  public void methodWithSetNullableBooleanParam(java.util.Set<java.lang.Boolean> param) { 
    delegate.methodWithSetNullableBooleanParam(param);
  }

  public void methodWithSetNullableBooleanHandler(io.vertx.core.Handler<java.util.Set<java.lang.Boolean>> handler) { 
    delegate.methodWithSetNullableBooleanHandler(handler);
  }

  public void methodWithSetNullableBooleanHandlerAsyncResult(io.vertx.core.Handler<io.vertx.core.AsyncResult<java.util.Set<java.lang.Boolean>>> handler) { 
    delegate.methodWithSetNullableBooleanHandlerAsyncResult(handler);
  }

  public void methodWithSetNullableBooleanHandlerAsyncResult() {
    methodWithSetNullableBooleanHandlerAsyncResult(ar -> { });
  }

  public io.reactivex.Single<java.util.Set<java.lang.Boolean>> rxMethodWithSetNullableBooleanHandlerAsyncResult() { 
    return AsyncResultSingle.toSingle($handler -> {
      methodWithSetNullableBooleanHandlerAsyncResult($handler);
    });
  }

  public java.util.Set<java.lang.Boolean> methodWithSetNullableBooleanReturn() { 
    java.util.Set<java.lang.Boolean> ret = delegate.methodWithSetNullableBooleanReturn();
    return ret;
  }

  public void methodWithSetNullableFloatParam(java.util.Set<java.lang.Float> param) { 
    delegate.methodWithSetNullableFloatParam(param);
  }

  public void methodWithSetNullableFloatHandler(io.vertx.core.Handler<java.util.Set<java.lang.Float>> handler) { 
    delegate.methodWithSetNullableFloatHandler(handler);
  }

  public void methodWithSetNullableFloatHandlerAsyncResult(io.vertx.core.Handler<io.vertx.core.AsyncResult<java.util.Set<java.lang.Float>>> handler) { 
    delegate.methodWithSetNullableFloatHandlerAsyncResult(handler);
  }

  public void methodWithSetNullableFloatHandlerAsyncResult() {
    methodWithSetNullableFloatHandlerAsyncResult(ar -> { });
  }

  public io.reactivex.Single<java.util.Set<java.lang.Float>> rxMethodWithSetNullableFloatHandlerAsyncResult() { 
    return AsyncResultSingle.toSingle($handler -> {
      methodWithSetNullableFloatHandlerAsyncResult($handler);
    });
  }

  public java.util.Set<java.lang.Float> methodWithSetNullableFloatReturn() { 
    java.util.Set<java.lang.Float> ret = delegate.methodWithSetNullableFloatReturn();
    return ret;
  }

  public void methodWithSetNullableDoubleParam(java.util.Set<java.lang.Double> param) { 
    delegate.methodWithSetNullableDoubleParam(param);
  }

  public void methodWithSetNullableDoubleHandler(io.vertx.core.Handler<java.util.Set<java.lang.Double>> handler) { 
    delegate.methodWithSetNullableDoubleHandler(handler);
  }

  public void methodWithSetNullableDoubleHandlerAsyncResult(io.vertx.core.Handler<io.vertx.core.AsyncResult<java.util.Set<java.lang.Double>>> handler) { 
    delegate.methodWithSetNullableDoubleHandlerAsyncResult(handler);
  }

  public void methodWithSetNullableDoubleHandlerAsyncResult() {
    methodWithSetNullableDoubleHandlerAsyncResult(ar -> { });
  }

  public io.reactivex.Single<java.util.Set<java.lang.Double>> rxMethodWithSetNullableDoubleHandlerAsyncResult() { 
    return AsyncResultSingle.toSingle($handler -> {
      methodWithSetNullableDoubleHandlerAsyncResult($handler);
    });
  }

  public java.util.Set<java.lang.Double> methodWithSetNullableDoubleReturn() { 
    java.util.Set<java.lang.Double> ret = delegate.methodWithSetNullableDoubleReturn();
    return ret;
  }

  public void methodWithSetNullableStringParam(java.util.Set<java.lang.String> param) { 
    delegate.methodWithSetNullableStringParam(param);
  }

  public void methodWithSetNullableStringHandler(io.vertx.core.Handler<java.util.Set<java.lang.String>> handler) { 
    delegate.methodWithSetNullableStringHandler(handler);
  }

  public void methodWithSetNullableStringHandlerAsyncResult(io.vertx.core.Handler<io.vertx.core.AsyncResult<java.util.Set<java.lang.String>>> handler) { 
    delegate.methodWithSetNullableStringHandlerAsyncResult(handler);
  }

  public void methodWithSetNullableStringHandlerAsyncResult() {
    methodWithSetNullableStringHandlerAsyncResult(ar -> { });
  }

  public io.reactivex.Single<java.util.Set<java.lang.String>> rxMethodWithSetNullableStringHandlerAsyncResult() { 
    return AsyncResultSingle.toSingle($handler -> {
      methodWithSetNullableStringHandlerAsyncResult($handler);
    });
  }

  public java.util.Set<java.lang.String> methodWithSetNullableStringReturn() { 
    java.util.Set<java.lang.String> ret = delegate.methodWithSetNullableStringReturn();
    return ret;
  }

  public void methodWithSetNullableCharParam(java.util.Set<java.lang.Character> param) { 
    delegate.methodWithSetNullableCharParam(param);
  }

  public void methodWithSetNullableCharHandler(io.vertx.core.Handler<java.util.Set<java.lang.Character>> handler) { 
    delegate.methodWithSetNullableCharHandler(handler);
  }

  public void methodWithSetNullableCharHandlerAsyncResult(io.vertx.core.Handler<io.vertx.core.AsyncResult<java.util.Set<java.lang.Character>>> handler) { 
    delegate.methodWithSetNullableCharHandlerAsyncResult(handler);
  }

  public void methodWithSetNullableCharHandlerAsyncResult() {
    methodWithSetNullableCharHandlerAsyncResult(ar -> { });
  }

  public io.reactivex.Single<java.util.Set<java.lang.Character>> rxMethodWithSetNullableCharHandlerAsyncResult() { 
    return AsyncResultSingle.toSingle($handler -> {
      methodWithSetNullableCharHandlerAsyncResult($handler);
    });
  }

  public java.util.Set<java.lang.Character> methodWithSetNullableCharReturn() { 
    java.util.Set<java.lang.Character> ret = delegate.methodWithSetNullableCharReturn();
    return ret;
  }

  public void methodWithSetNullableJsonObjectParam(java.util.Set<io.vertx.core.json.JsonObject> param) { 
    delegate.methodWithSetNullableJsonObjectParam(param);
  }

  public void methodWithSetNullableJsonObjectHandler(io.vertx.core.Handler<java.util.Set<io.vertx.core.json.JsonObject>> handler) { 
    delegate.methodWithSetNullableJsonObjectHandler(handler);
  }

  public void methodWithSetNullableJsonObjectHandlerAsyncResult(io.vertx.core.Handler<io.vertx.core.AsyncResult<java.util.Set<io.vertx.core.json.JsonObject>>> handler) { 
    delegate.methodWithSetNullableJsonObjectHandlerAsyncResult(handler);
  }

  public void methodWithSetNullableJsonObjectHandlerAsyncResult() {
    methodWithSetNullableJsonObjectHandlerAsyncResult(ar -> { });
  }

  public io.reactivex.Single<java.util.Set<io.vertx.core.json.JsonObject>> rxMethodWithSetNullableJsonObjectHandlerAsyncResult() { 
    return AsyncResultSingle.toSingle($handler -> {
      methodWithSetNullableJsonObjectHandlerAsyncResult($handler);
    });
  }

  public java.util.Set<io.vertx.core.json.JsonObject> methodWithSetNullableJsonObjectReturn() { 
    java.util.Set<io.vertx.core.json.JsonObject> ret = delegate.methodWithSetNullableJsonObjectReturn();
    return ret;
  }

  public void methodWithSetNullableJsonArrayParam(java.util.Set<io.vertx.core.json.JsonArray> param) { 
    delegate.methodWithSetNullableJsonArrayParam(param);
  }

  public void methodWithSetNullableJsonArrayHandler(io.vertx.core.Handler<java.util.Set<io.vertx.core.json.JsonArray>> handler) { 
    delegate.methodWithSetNullableJsonArrayHandler(handler);
  }

  public void methodWithSetNullableJsonArrayHandlerAsyncResult(io.vertx.core.Handler<io.vertx.core.AsyncResult<java.util.Set<io.vertx.core.json.JsonArray>>> handler) { 
    delegate.methodWithSetNullableJsonArrayHandlerAsyncResult(handler);
  }

  public void methodWithSetNullableJsonArrayHandlerAsyncResult() {
    methodWithSetNullableJsonArrayHandlerAsyncResult(ar -> { });
  }

  public io.reactivex.Single<java.util.Set<io.vertx.core.json.JsonArray>> rxMethodWithSetNullableJsonArrayHandlerAsyncResult() { 
    return AsyncResultSingle.toSingle($handler -> {
      methodWithSetNullableJsonArrayHandlerAsyncResult($handler);
    });
  }

  public java.util.Set<io.vertx.core.json.JsonArray> methodWithSetNullableJsonArrayReturn() { 
    java.util.Set<io.vertx.core.json.JsonArray> ret = delegate.methodWithSetNullableJsonArrayReturn();
    return ret;
  }

  public void methodWithSetNullableApiParam(java.util.Set<io.vertx.reactivex.codegen.testmodel.RefedInterface1> param) { 
    delegate.methodWithSetNullableApiParam(param.stream().map(elt -> elt.getDelegate()).collect(Collectors.toSet()));
  }

  public void methodWithSetNullableApiHandler(io.vertx.core.Handler<java.util.Set<io.vertx.reactivex.codegen.testmodel.RefedInterface1>> handler) { 
    delegate.methodWithSetNullableApiHandler(new Handler<java.util.Set<io.vertx.codegen.testmodel.RefedInterface1>>() {
      public void handle(java.util.Set<io.vertx.codegen.testmodel.RefedInterface1> event) {
        handler.handle(event.stream().map(elt -> io.vertx.reactivex.codegen.testmodel.RefedInterface1.newInstance((io.vertx.codegen.testmodel.RefedInterface1)elt)).collect(Collectors.toSet()));
      }
    });
  }

  public void methodWithSetNullableApiHandlerAsyncResult(io.vertx.core.Handler<io.vertx.core.AsyncResult<java.util.Set<io.vertx.reactivex.codegen.testmodel.RefedInterface1>>> handler) { 
    delegate.methodWithSetNullableApiHandlerAsyncResult(new Handler<AsyncResult<java.util.Set<io.vertx.codegen.testmodel.RefedInterface1>>>() {
      public void handle(AsyncResult<java.util.Set<io.vertx.codegen.testmodel.RefedInterface1>> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(ar.result().stream().map(elt -> io.vertx.reactivex.codegen.testmodel.RefedInterface1.newInstance((io.vertx.codegen.testmodel.RefedInterface1)elt)).collect(Collectors.toSet())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
  }

  public void methodWithSetNullableApiHandlerAsyncResult() {
    methodWithSetNullableApiHandlerAsyncResult(ar -> { });
  }

  public io.reactivex.Single<java.util.Set<io.vertx.reactivex.codegen.testmodel.RefedInterface1>> rxMethodWithSetNullableApiHandlerAsyncResult() { 
    return AsyncResultSingle.toSingle($handler -> {
      methodWithSetNullableApiHandlerAsyncResult($handler);
    });
  }

  public java.util.Set<io.vertx.reactivex.codegen.testmodel.RefedInterface1> methodWithSetNullableApiReturn() { 
    java.util.Set<io.vertx.reactivex.codegen.testmodel.RefedInterface1> ret = delegate.methodWithSetNullableApiReturn().stream().map(elt -> io.vertx.reactivex.codegen.testmodel.RefedInterface1.newInstance((io.vertx.codegen.testmodel.RefedInterface1)elt)).collect(Collectors.toSet());
    return ret;
  }

  public void methodWithSetNullableDataObjectParam(java.util.Set<io.vertx.codegen.testmodel.TestDataObject> param) { 
    delegate.methodWithSetNullableDataObjectParam(param);
  }

  public void methodWithSetNullableDataObjectHandler(io.vertx.core.Handler<java.util.Set<io.vertx.codegen.testmodel.TestDataObject>> handler) { 
    delegate.methodWithSetNullableDataObjectHandler(handler);
  }

  public void methodWithSetNullableDataObjectHandlerAsyncResult(io.vertx.core.Handler<io.vertx.core.AsyncResult<java.util.Set<io.vertx.codegen.testmodel.TestDataObject>>> handler) { 
    delegate.methodWithSetNullableDataObjectHandlerAsyncResult(handler);
  }

  public void methodWithSetNullableDataObjectHandlerAsyncResult() {
    methodWithSetNullableDataObjectHandlerAsyncResult(ar -> { });
  }

  public io.reactivex.Single<java.util.Set<io.vertx.codegen.testmodel.TestDataObject>> rxMethodWithSetNullableDataObjectHandlerAsyncResult() { 
    return AsyncResultSingle.toSingle($handler -> {
      methodWithSetNullableDataObjectHandlerAsyncResult($handler);
    });
  }

  public java.util.Set<io.vertx.codegen.testmodel.TestDataObject> methodWithSetNullableDataObjectReturn() { 
    java.util.Set<io.vertx.codegen.testmodel.TestDataObject> ret = delegate.methodWithSetNullableDataObjectReturn();
    return ret;
  }

  public void methodWithSetNullableEnumParam(java.util.Set<io.vertx.codegen.testmodel.TestEnum> param) { 
    delegate.methodWithSetNullableEnumParam(param);
  }

  public void methodWithSetNullableEnumHandler(io.vertx.core.Handler<java.util.Set<io.vertx.codegen.testmodel.TestEnum>> handler) { 
    delegate.methodWithSetNullableEnumHandler(handler);
  }

  public void methodWithSetNullableEnumHandlerAsyncResult(io.vertx.core.Handler<io.vertx.core.AsyncResult<java.util.Set<io.vertx.codegen.testmodel.TestEnum>>> handler) { 
    delegate.methodWithSetNullableEnumHandlerAsyncResult(handler);
  }

  public void methodWithSetNullableEnumHandlerAsyncResult() {
    methodWithSetNullableEnumHandlerAsyncResult(ar -> { });
  }

  public io.reactivex.Single<java.util.Set<io.vertx.codegen.testmodel.TestEnum>> rxMethodWithSetNullableEnumHandlerAsyncResult() { 
    return AsyncResultSingle.toSingle($handler -> {
      methodWithSetNullableEnumHandlerAsyncResult($handler);
    });
  }

  public java.util.Set<io.vertx.codegen.testmodel.TestEnum> methodWithSetNullableEnumReturn() { 
    java.util.Set<io.vertx.codegen.testmodel.TestEnum> ret = delegate.methodWithSetNullableEnumReturn();
    return ret;
  }

  public void methodWithSetNullableGenEnumParam(java.util.Set<io.vertx.codegen.testmodel.TestGenEnum> param) { 
    delegate.methodWithSetNullableGenEnumParam(param);
  }

  public void methodWithSetNullableGenEnumHandler(io.vertx.core.Handler<java.util.Set<io.vertx.codegen.testmodel.TestGenEnum>> handler) { 
    delegate.methodWithSetNullableGenEnumHandler(handler);
  }

  public void methodWithSetNullableGenEnumHandlerAsyncResult(io.vertx.core.Handler<io.vertx.core.AsyncResult<java.util.Set<io.vertx.codegen.testmodel.TestGenEnum>>> handler) { 
    delegate.methodWithSetNullableGenEnumHandlerAsyncResult(handler);
  }

  public void methodWithSetNullableGenEnumHandlerAsyncResult() {
    methodWithSetNullableGenEnumHandlerAsyncResult(ar -> { });
  }

  public io.reactivex.Single<java.util.Set<io.vertx.codegen.testmodel.TestGenEnum>> rxMethodWithSetNullableGenEnumHandlerAsyncResult() { 
    return AsyncResultSingle.toSingle($handler -> {
      methodWithSetNullableGenEnumHandlerAsyncResult($handler);
    });
  }

  public java.util.Set<io.vertx.codegen.testmodel.TestGenEnum> methodWithSetNullableGenEnumReturn() { 
    java.util.Set<io.vertx.codegen.testmodel.TestGenEnum> ret = delegate.methodWithSetNullableGenEnumReturn();
    return ret;
  }

  public void methodWithMapNullableByteParam(java.util.Map<java.lang.String,java.lang.Byte> param) { 
    delegate.methodWithMapNullableByteParam(param);
  }

  public void methodWithMapNullableByteHandler(io.vertx.core.Handler<java.util.Map<java.lang.String,java.lang.Byte>> handler) { 
    delegate.methodWithMapNullableByteHandler(handler);
  }

  public void methodWithMapNullableByteHandlerAsyncResult(io.vertx.core.Handler<io.vertx.core.AsyncResult<java.util.Map<java.lang.String,java.lang.Byte>>> handler) { 
    delegate.methodWithMapNullableByteHandlerAsyncResult(handler);
  }

  public void methodWithMapNullableByteHandlerAsyncResult() {
    methodWithMapNullableByteHandlerAsyncResult(ar -> { });
  }

  public io.reactivex.Single<java.util.Map<java.lang.String,java.lang.Byte>> rxMethodWithMapNullableByteHandlerAsyncResult() { 
    return AsyncResultSingle.toSingle($handler -> {
      methodWithMapNullableByteHandlerAsyncResult($handler);
    });
  }

  public java.util.Map<java.lang.String,java.lang.Byte> methodWithMapNullableByteReturn() { 
    java.util.Map<java.lang.String,java.lang.Byte> ret = delegate.methodWithMapNullableByteReturn();
    return ret;
  }

  public void methodWithMapNullableShortParam(java.util.Map<java.lang.String,java.lang.Short> param) { 
    delegate.methodWithMapNullableShortParam(param);
  }

  public void methodWithMapNullableShortHandler(io.vertx.core.Handler<java.util.Map<java.lang.String,java.lang.Short>> handler) { 
    delegate.methodWithMapNullableShortHandler(handler);
  }

  public void methodWithMapNullableShortHandlerAsyncResult(io.vertx.core.Handler<io.vertx.core.AsyncResult<java.util.Map<java.lang.String,java.lang.Short>>> handler) { 
    delegate.methodWithMapNullableShortHandlerAsyncResult(handler);
  }

  public void methodWithMapNullableShortHandlerAsyncResult() {
    methodWithMapNullableShortHandlerAsyncResult(ar -> { });
  }

  public io.reactivex.Single<java.util.Map<java.lang.String,java.lang.Short>> rxMethodWithMapNullableShortHandlerAsyncResult() { 
    return AsyncResultSingle.toSingle($handler -> {
      methodWithMapNullableShortHandlerAsyncResult($handler);
    });
  }

  public java.util.Map<java.lang.String,java.lang.Short> methodWithMapNullableShortReturn() { 
    java.util.Map<java.lang.String,java.lang.Short> ret = delegate.methodWithMapNullableShortReturn();
    return ret;
  }

  public void methodWithMapNullableIntegerParam(java.util.Map<java.lang.String,java.lang.Integer> param) { 
    delegate.methodWithMapNullableIntegerParam(param);
  }

  public void methodWithMapNullableIntegerHandler(io.vertx.core.Handler<java.util.Map<java.lang.String,java.lang.Integer>> handler) { 
    delegate.methodWithMapNullableIntegerHandler(handler);
  }

  public void methodWithMapNullableIntegerHandlerAsyncResult(io.vertx.core.Handler<io.vertx.core.AsyncResult<java.util.Map<java.lang.String,java.lang.Integer>>> handler) { 
    delegate.methodWithMapNullableIntegerHandlerAsyncResult(handler);
  }

  public void methodWithMapNullableIntegerHandlerAsyncResult() {
    methodWithMapNullableIntegerHandlerAsyncResult(ar -> { });
  }

  public io.reactivex.Single<java.util.Map<java.lang.String,java.lang.Integer>> rxMethodWithMapNullableIntegerHandlerAsyncResult() { 
    return AsyncResultSingle.toSingle($handler -> {
      methodWithMapNullableIntegerHandlerAsyncResult($handler);
    });
  }

  public java.util.Map<java.lang.String,java.lang.Integer> methodWithMapNullableIntegerReturn() { 
    java.util.Map<java.lang.String,java.lang.Integer> ret = delegate.methodWithMapNullableIntegerReturn();
    return ret;
  }

  public void methodWithMapNullableLongParam(java.util.Map<java.lang.String,java.lang.Long> param) { 
    delegate.methodWithMapNullableLongParam(param);
  }

  public void methodWithMapNullableLongHandler(io.vertx.core.Handler<java.util.Map<java.lang.String,java.lang.Long>> handler) { 
    delegate.methodWithMapNullableLongHandler(handler);
  }

  public void methodWithMapNullableLongHandlerAsyncResult(io.vertx.core.Handler<io.vertx.core.AsyncResult<java.util.Map<java.lang.String,java.lang.Long>>> handler) { 
    delegate.methodWithMapNullableLongHandlerAsyncResult(handler);
  }

  public void methodWithMapNullableLongHandlerAsyncResult() {
    methodWithMapNullableLongHandlerAsyncResult(ar -> { });
  }

  public io.reactivex.Single<java.util.Map<java.lang.String,java.lang.Long>> rxMethodWithMapNullableLongHandlerAsyncResult() { 
    return AsyncResultSingle.toSingle($handler -> {
      methodWithMapNullableLongHandlerAsyncResult($handler);
    });
  }

  public java.util.Map<java.lang.String,java.lang.Long> methodWithMapNullableLongReturn() { 
    java.util.Map<java.lang.String,java.lang.Long> ret = delegate.methodWithMapNullableLongReturn();
    return ret;
  }

  public void methodWithMapNullableBooleanParam(java.util.Map<java.lang.String,java.lang.Boolean> param) { 
    delegate.methodWithMapNullableBooleanParam(param);
  }

  public void methodWithMapNullableBooleanHandler(io.vertx.core.Handler<java.util.Map<java.lang.String,java.lang.Boolean>> handler) { 
    delegate.methodWithMapNullableBooleanHandler(handler);
  }

  public void methodWithMapNullableBooleanHandlerAsyncResult(io.vertx.core.Handler<io.vertx.core.AsyncResult<java.util.Map<java.lang.String,java.lang.Boolean>>> handler) { 
    delegate.methodWithMapNullableBooleanHandlerAsyncResult(handler);
  }

  public void methodWithMapNullableBooleanHandlerAsyncResult() {
    methodWithMapNullableBooleanHandlerAsyncResult(ar -> { });
  }

  public io.reactivex.Single<java.util.Map<java.lang.String,java.lang.Boolean>> rxMethodWithMapNullableBooleanHandlerAsyncResult() { 
    return AsyncResultSingle.toSingle($handler -> {
      methodWithMapNullableBooleanHandlerAsyncResult($handler);
    });
  }

  public java.util.Map<java.lang.String,java.lang.Boolean> methodWithMapNullableBooleanReturn() { 
    java.util.Map<java.lang.String,java.lang.Boolean> ret = delegate.methodWithMapNullableBooleanReturn();
    return ret;
  }

  public void methodWithMapNullableFloatParam(java.util.Map<java.lang.String,java.lang.Float> param) { 
    delegate.methodWithMapNullableFloatParam(param);
  }

  public void methodWithMapNullableFloatHandler(io.vertx.core.Handler<java.util.Map<java.lang.String,java.lang.Float>> handler) { 
    delegate.methodWithMapNullableFloatHandler(handler);
  }

  public void methodWithMapNullableFloatHandlerAsyncResult(io.vertx.core.Handler<io.vertx.core.AsyncResult<java.util.Map<java.lang.String,java.lang.Float>>> handler) { 
    delegate.methodWithMapNullableFloatHandlerAsyncResult(handler);
  }

  public void methodWithMapNullableFloatHandlerAsyncResult() {
    methodWithMapNullableFloatHandlerAsyncResult(ar -> { });
  }

  public io.reactivex.Single<java.util.Map<java.lang.String,java.lang.Float>> rxMethodWithMapNullableFloatHandlerAsyncResult() { 
    return AsyncResultSingle.toSingle($handler -> {
      methodWithMapNullableFloatHandlerAsyncResult($handler);
    });
  }

  public java.util.Map<java.lang.String,java.lang.Float> methodWithMapNullableFloatReturn() { 
    java.util.Map<java.lang.String,java.lang.Float> ret = delegate.methodWithMapNullableFloatReturn();
    return ret;
  }

  public void methodWithMapNullableDoubleParam(java.util.Map<java.lang.String,java.lang.Double> param) { 
    delegate.methodWithMapNullableDoubleParam(param);
  }

  public void methodWithMapNullableDoubleHandler(io.vertx.core.Handler<java.util.Map<java.lang.String,java.lang.Double>> handler) { 
    delegate.methodWithMapNullableDoubleHandler(handler);
  }

  public void methodWithMapNullableDoubleHandlerAsyncResult(io.vertx.core.Handler<io.vertx.core.AsyncResult<java.util.Map<java.lang.String,java.lang.Double>>> handler) { 
    delegate.methodWithMapNullableDoubleHandlerAsyncResult(handler);
  }

  public void methodWithMapNullableDoubleHandlerAsyncResult() {
    methodWithMapNullableDoubleHandlerAsyncResult(ar -> { });
  }

  public io.reactivex.Single<java.util.Map<java.lang.String,java.lang.Double>> rxMethodWithMapNullableDoubleHandlerAsyncResult() { 
    return AsyncResultSingle.toSingle($handler -> {
      methodWithMapNullableDoubleHandlerAsyncResult($handler);
    });
  }

  public java.util.Map<java.lang.String,java.lang.Double> methodWithMapNullableDoubleReturn() { 
    java.util.Map<java.lang.String,java.lang.Double> ret = delegate.methodWithMapNullableDoubleReturn();
    return ret;
  }

  public void methodWithMapNullableStringParam(java.util.Map<java.lang.String,java.lang.String> param) { 
    delegate.methodWithMapNullableStringParam(param);
  }

  public void methodWithMapNullableStringHandler(io.vertx.core.Handler<java.util.Map<java.lang.String,java.lang.String>> handler) { 
    delegate.methodWithMapNullableStringHandler(handler);
  }

  public void methodWithMapNullableStringHandlerAsyncResult(io.vertx.core.Handler<io.vertx.core.AsyncResult<java.util.Map<java.lang.String,java.lang.String>>> handler) { 
    delegate.methodWithMapNullableStringHandlerAsyncResult(handler);
  }

  public void methodWithMapNullableStringHandlerAsyncResult() {
    methodWithMapNullableStringHandlerAsyncResult(ar -> { });
  }

  public io.reactivex.Single<java.util.Map<java.lang.String,java.lang.String>> rxMethodWithMapNullableStringHandlerAsyncResult() { 
    return AsyncResultSingle.toSingle($handler -> {
      methodWithMapNullableStringHandlerAsyncResult($handler);
    });
  }

  public java.util.Map<java.lang.String,java.lang.String> methodWithMapNullableStringReturn() { 
    java.util.Map<java.lang.String,java.lang.String> ret = delegate.methodWithMapNullableStringReturn();
    return ret;
  }

  public void methodWithMapNullableCharParam(java.util.Map<java.lang.String,java.lang.Character> param) { 
    delegate.methodWithMapNullableCharParam(param);
  }

  public void methodWithMapNullableCharHandler(io.vertx.core.Handler<java.util.Map<java.lang.String,java.lang.Character>> handler) { 
    delegate.methodWithMapNullableCharHandler(handler);
  }

  public void methodWithMapNullableCharHandlerAsyncResult(io.vertx.core.Handler<io.vertx.core.AsyncResult<java.util.Map<java.lang.String,java.lang.Character>>> handler) { 
    delegate.methodWithMapNullableCharHandlerAsyncResult(handler);
  }

  public void methodWithMapNullableCharHandlerAsyncResult() {
    methodWithMapNullableCharHandlerAsyncResult(ar -> { });
  }

  public io.reactivex.Single<java.util.Map<java.lang.String,java.lang.Character>> rxMethodWithMapNullableCharHandlerAsyncResult() { 
    return AsyncResultSingle.toSingle($handler -> {
      methodWithMapNullableCharHandlerAsyncResult($handler);
    });
  }

  public java.util.Map<java.lang.String,java.lang.Character> methodWithMapNullableCharReturn() { 
    java.util.Map<java.lang.String,java.lang.Character> ret = delegate.methodWithMapNullableCharReturn();
    return ret;
  }

  public void methodWithMapNullableJsonObjectParam(java.util.Map<java.lang.String,io.vertx.core.json.JsonObject> param) { 
    delegate.methodWithMapNullableJsonObjectParam(param);
  }

  public void methodWithMapNullableJsonObjectHandler(io.vertx.core.Handler<java.util.Map<java.lang.String,io.vertx.core.json.JsonObject>> handler) { 
    delegate.methodWithMapNullableJsonObjectHandler(handler);
  }

  public void methodWithMapNullableJsonObjectHandlerAsyncResult(io.vertx.core.Handler<io.vertx.core.AsyncResult<java.util.Map<java.lang.String,io.vertx.core.json.JsonObject>>> handler) { 
    delegate.methodWithMapNullableJsonObjectHandlerAsyncResult(handler);
  }

  public void methodWithMapNullableJsonObjectHandlerAsyncResult() {
    methodWithMapNullableJsonObjectHandlerAsyncResult(ar -> { });
  }

  public io.reactivex.Single<java.util.Map<java.lang.String,io.vertx.core.json.JsonObject>> rxMethodWithMapNullableJsonObjectHandlerAsyncResult() { 
    return AsyncResultSingle.toSingle($handler -> {
      methodWithMapNullableJsonObjectHandlerAsyncResult($handler);
    });
  }

  public java.util.Map<java.lang.String,io.vertx.core.json.JsonObject> methodWithMapNullableJsonObjectReturn() { 
    java.util.Map<java.lang.String,io.vertx.core.json.JsonObject> ret = delegate.methodWithMapNullableJsonObjectReturn();
    return ret;
  }

  public void methodWithMapNullableJsonArrayParam(java.util.Map<java.lang.String,io.vertx.core.json.JsonArray> param) { 
    delegate.methodWithMapNullableJsonArrayParam(param);
  }

  public void methodWithMapNullableJsonArrayHandler(io.vertx.core.Handler<java.util.Map<java.lang.String,io.vertx.core.json.JsonArray>> handler) { 
    delegate.methodWithMapNullableJsonArrayHandler(handler);
  }

  public void methodWithMapNullableJsonArrayHandlerAsyncResult(io.vertx.core.Handler<io.vertx.core.AsyncResult<java.util.Map<java.lang.String,io.vertx.core.json.JsonArray>>> handler) { 
    delegate.methodWithMapNullableJsonArrayHandlerAsyncResult(handler);
  }

  public void methodWithMapNullableJsonArrayHandlerAsyncResult() {
    methodWithMapNullableJsonArrayHandlerAsyncResult(ar -> { });
  }

  public io.reactivex.Single<java.util.Map<java.lang.String,io.vertx.core.json.JsonArray>> rxMethodWithMapNullableJsonArrayHandlerAsyncResult() { 
    return AsyncResultSingle.toSingle($handler -> {
      methodWithMapNullableJsonArrayHandlerAsyncResult($handler);
    });
  }

  public java.util.Map<java.lang.String,io.vertx.core.json.JsonArray> methodWithMapNullableJsonArrayReturn() { 
    java.util.Map<java.lang.String,io.vertx.core.json.JsonArray> ret = delegate.methodWithMapNullableJsonArrayReturn();
    return ret;
  }

  public void methodWithMapNullableApiParam(java.util.Map<java.lang.String,io.vertx.reactivex.codegen.testmodel.RefedInterface1> param) { 
    delegate.methodWithMapNullableApiParam(param.entrySet().stream().collect(Collectors.toMap(e -> e.getKey(), e -> e.getValue().getDelegate())));
  }

  public void methodWithNullableHandler(boolean expectNull, io.vertx.core.Handler<java.lang.String> handler) { 
    delegate.methodWithNullableHandler(expectNull, handler);
  }

  public void methodWithNullableHandlerAsyncResult(boolean expectNull, io.vertx.core.Handler<io.vertx.core.AsyncResult<java.lang.String>> handler) { 
    delegate.methodWithNullableHandlerAsyncResult(expectNull, handler);
  }

  public void methodWithNullableHandlerAsyncResult(boolean expectNull) {
    methodWithNullableHandlerAsyncResult(expectNull, ar -> { });
  }

  public io.reactivex.Single<java.lang.String> rxMethodWithNullableHandlerAsyncResult(boolean expectNull) { 
    return AsyncResultSingle.toSingle($handler -> {
      methodWithNullableHandlerAsyncResult(expectNull, $handler);
    });
  }

  public static NullableTCK newInstance(io.vertx.codegen.testmodel.NullableTCK arg) {
    return arg != null ? new NullableTCK(arg) : null;
  }

}
