/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.codegen.testmodel;

import io.vertx.reactivex.RxHelper;
import io.vertx.reactivex.ObservableHelper;
import io.vertx.reactivex.FlowableHelper;
import io.vertx.reactivex.impl.AsyncResultMaybe;
import io.vertx.reactivex.impl.AsyncResultSingle;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.WriteStreamObserver;
import io.vertx.reactivex.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.codegen.testmodel.RefedInterface2 original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.codegen.testmodel.RefedInterface2.class)
public interface RefedInterface2 {

  io.vertx.codegen.testmodel.RefedInterface2 getDelegate();

  public java.lang.String getString();

  public io.vertx.reactivex.codegen.testmodel.RefedInterface2 setString(java.lang.String str);

  public static RefedInterface2 newInstance(io.vertx.codegen.testmodel.RefedInterface2 arg) {
    return arg != null ? new RefedInterface2Impl(arg) : null;
  }

}

class RefedInterface2Impl implements RefedInterface2 {
  private final io.vertx.codegen.testmodel.RefedInterface2 delegate;
  
  public RefedInterface2Impl(io.vertx.codegen.testmodel.RefedInterface2 delegate) {
    this.delegate = delegate;
  }

  public RefedInterface2Impl(Object delegate) {
    this.delegate = (io.vertx.codegen.testmodel.RefedInterface2)delegate;
  }

  public io.vertx.codegen.testmodel.RefedInterface2 getDelegate() {
    return delegate;
  }

  public java.lang.String getString() { 
    java.lang.String ret = delegate.getString();
    return ret;
  }

  public io.vertx.reactivex.codegen.testmodel.RefedInterface2 setString(java.lang.String str) { 
    delegate.setString(str);
    return this;
  }

}
