/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.codegen.testmodel;

import io.vertx.reactivex.RxHelper;
import io.vertx.reactivex.ObservableHelper;
import io.vertx.reactivex.FlowableHelper;
import io.vertx.reactivex.impl.AsyncResultMaybe;
import io.vertx.reactivex.impl.AsyncResultSingle;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.WriteStreamObserver;
import io.vertx.reactivex.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.codegen.testmodel.TestInterface original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.codegen.testmodel.TestInterface.class)
public class TestInterface extends io.vertx.reactivex.codegen.testmodel.SuperInterface1 implements io.vertx.reactivex.codegen.testmodel.SuperInterface2 {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    TestInterface that = (TestInterface) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<TestInterface> __TYPE_ARG = new TypeArg<>(    obj -> new TestInterface((io.vertx.codegen.testmodel.TestInterface) obj),
    TestInterface::getDelegate
  );

  private final io.vertx.codegen.testmodel.TestInterface delegate;
  
  public TestInterface(io.vertx.codegen.testmodel.TestInterface delegate) {
    super(delegate);
    this.delegate = delegate;
  }

  public TestInterface(Object delegate) {
    super((io.vertx.codegen.testmodel.TestInterface)delegate);
    this.delegate = (io.vertx.codegen.testmodel.TestInterface)delegate;
  }

  public io.vertx.codegen.testmodel.TestInterface getDelegate() {
    return delegate;
  }

  private static final TypeArg<io.vertx.reactivex.codegen.testmodel.RefedInterface1> TYPE_ARG_0 = new TypeArg<io.vertx.reactivex.codegen.testmodel.RefedInterface1>(o1 -> io.vertx.reactivex.codegen.testmodel.RefedInterface1.newInstance((io.vertx.codegen.testmodel.RefedInterface1)o1), o1 -> o1.getDelegate());
  private static final TypeArg<io.vertx.reactivex.codegen.testmodel.RefedInterface1> TYPE_ARG_1 = new TypeArg<io.vertx.reactivex.codegen.testmodel.RefedInterface1>(o1 -> io.vertx.reactivex.codegen.testmodel.RefedInterface1.newInstance((io.vertx.codegen.testmodel.RefedInterface1)o1), o1 -> o1.getDelegate());

  public void otherSuperMethodWithBasicParams(byte b, short s, int i, long l, float f, double d, boolean bool, char ch, java.lang.String str) { 
    delegate.otherSuperMethodWithBasicParams(b, s, i, l, f, d, bool, ch, str);
  }

  public void methodWithBasicParams(byte b, short s, int i, long l, float f, double d, boolean bool, char ch, java.lang.String str) { 
    delegate.methodWithBasicParams(b, s, i, l, f, d, bool, ch, str);
  }

  public void methodWithBasicBoxedParams(java.lang.Byte b, java.lang.Short s, java.lang.Integer i, java.lang.Long l, java.lang.Float f, java.lang.Double d, java.lang.Boolean bool, java.lang.Character ch) { 
    delegate.methodWithBasicBoxedParams(b, s, i, l, f, d, bool, ch);
  }

  public void methodWithHandlerBasicTypes(io.vertx.core.Handler<java.lang.Byte> byteHandler, io.vertx.core.Handler<java.lang.Short> shortHandler, io.vertx.core.Handler<java.lang.Integer> intHandler, io.vertx.core.Handler<java.lang.Long> longHandler, io.vertx.core.Handler<java.lang.Float> floatHandler, io.vertx.core.Handler<java.lang.Double> doubleHandler, io.vertx.core.Handler<java.lang.Boolean> booleanHandler, io.vertx.core.Handler<java.lang.Character> charHandler, io.vertx.core.Handler<java.lang.String> stringHandler) { 
    delegate.methodWithHandlerBasicTypes(byteHandler, shortHandler, intHandler, longHandler, floatHandler, doubleHandler, booleanHandler, charHandler, stringHandler);
  }

  public io.vertx.core.Handler<java.lang.String> methodWithHandlerStringReturn(java.lang.String expected) { 
    io.vertx.core.Handler<java.lang.String> ret = delegate.methodWithHandlerStringReturn(expected);
    return ret;
  }

  public <T> io.vertx.core.Handler<T> methodWithHandlerGenericReturn(io.vertx.core.Handler<T> handler) { 
    io.vertx.core.Handler<T> ret = delegate.methodWithHandlerGenericReturn(handler);
    return ret;
  }

  public io.vertx.core.Handler<io.vertx.reactivex.codegen.testmodel.RefedInterface1> methodWithHandlerVertxGenReturn(java.lang.String expected) { 
    io.vertx.core.Handler<io.vertx.reactivex.codegen.testmodel.RefedInterface1> ret = new Handler<io.vertx.reactivex.codegen.testmodel.RefedInterface1>() {
      public void handle(io.vertx.reactivex.codegen.testmodel.RefedInterface1 event) {
          delegate.methodWithHandlerVertxGenReturn(expected).handle(event.getDelegate());
      }
    };
    return ret;
  }

  public void methodWithHandlerAsyncResultByte(boolean sendFailure, io.vertx.core.Handler<io.vertx.core.AsyncResult<java.lang.Byte>> handler) { 
    delegate.methodWithHandlerAsyncResultByte(sendFailure, handler);
  }

  public void methodWithHandlerAsyncResultByte(boolean sendFailure) {
    methodWithHandlerAsyncResultByte(sendFailure, ar -> { });
  }

  public io.reactivex.Single<java.lang.Byte> rxMethodWithHandlerAsyncResultByte(boolean sendFailure) { 
    return AsyncResultSingle.toSingle($handler -> {
      methodWithHandlerAsyncResultByte(sendFailure, $handler);
    });
  }

  public void methodWithHandlerAsyncResultShort(boolean sendFailure, io.vertx.core.Handler<io.vertx.core.AsyncResult<java.lang.Short>> handler) { 
    delegate.methodWithHandlerAsyncResultShort(sendFailure, handler);
  }

  public void methodWithHandlerAsyncResultShort(boolean sendFailure) {
    methodWithHandlerAsyncResultShort(sendFailure, ar -> { });
  }

  public io.reactivex.Single<java.lang.Short> rxMethodWithHandlerAsyncResultShort(boolean sendFailure) { 
    return AsyncResultSingle.toSingle($handler -> {
      methodWithHandlerAsyncResultShort(sendFailure, $handler);
    });
  }

  public void methodWithHandlerAsyncResultInteger(boolean sendFailure, io.vertx.core.Handler<io.vertx.core.AsyncResult<java.lang.Integer>> handler) { 
    delegate.methodWithHandlerAsyncResultInteger(sendFailure, handler);
  }

  public void methodWithHandlerAsyncResultInteger(boolean sendFailure) {
    methodWithHandlerAsyncResultInteger(sendFailure, ar -> { });
  }

  public io.reactivex.Single<java.lang.Integer> rxMethodWithHandlerAsyncResultInteger(boolean sendFailure) { 
    return AsyncResultSingle.toSingle($handler -> {
      methodWithHandlerAsyncResultInteger(sendFailure, $handler);
    });
  }

  public void methodWithHandlerAsyncResultLong(boolean sendFailure, io.vertx.core.Handler<io.vertx.core.AsyncResult<java.lang.Long>> handler) { 
    delegate.methodWithHandlerAsyncResultLong(sendFailure, handler);
  }

  public void methodWithHandlerAsyncResultLong(boolean sendFailure) {
    methodWithHandlerAsyncResultLong(sendFailure, ar -> { });
  }

  public io.reactivex.Single<java.lang.Long> rxMethodWithHandlerAsyncResultLong(boolean sendFailure) { 
    return AsyncResultSingle.toSingle($handler -> {
      methodWithHandlerAsyncResultLong(sendFailure, $handler);
    });
  }

  public void methodWithHandlerAsyncResultFloat(boolean sendFailure, io.vertx.core.Handler<io.vertx.core.AsyncResult<java.lang.Float>> handler) { 
    delegate.methodWithHandlerAsyncResultFloat(sendFailure, handler);
  }

  public void methodWithHandlerAsyncResultFloat(boolean sendFailure) {
    methodWithHandlerAsyncResultFloat(sendFailure, ar -> { });
  }

  public io.reactivex.Single<java.lang.Float> rxMethodWithHandlerAsyncResultFloat(boolean sendFailure) { 
    return AsyncResultSingle.toSingle($handler -> {
      methodWithHandlerAsyncResultFloat(sendFailure, $handler);
    });
  }

  public void methodWithHandlerAsyncResultDouble(boolean sendFailure, io.vertx.core.Handler<io.vertx.core.AsyncResult<java.lang.Double>> handler) { 
    delegate.methodWithHandlerAsyncResultDouble(sendFailure, handler);
  }

  public void methodWithHandlerAsyncResultDouble(boolean sendFailure) {
    methodWithHandlerAsyncResultDouble(sendFailure, ar -> { });
  }

  public io.reactivex.Single<java.lang.Double> rxMethodWithHandlerAsyncResultDouble(boolean sendFailure) { 
    return AsyncResultSingle.toSingle($handler -> {
      methodWithHandlerAsyncResultDouble(sendFailure, $handler);
    });
  }

  public void methodWithHandlerAsyncResultBoolean(boolean sendFailure, io.vertx.core.Handler<io.vertx.core.AsyncResult<java.lang.Boolean>> handler) { 
    delegate.methodWithHandlerAsyncResultBoolean(sendFailure, handler);
  }

  public void methodWithHandlerAsyncResultBoolean(boolean sendFailure) {
    methodWithHandlerAsyncResultBoolean(sendFailure, ar -> { });
  }

  public io.reactivex.Single<java.lang.Boolean> rxMethodWithHandlerAsyncResultBoolean(boolean sendFailure) { 
    return AsyncResultSingle.toSingle($handler -> {
      methodWithHandlerAsyncResultBoolean(sendFailure, $handler);
    });
  }

  public void methodWithHandlerAsyncResultCharacter(boolean sendFailure, io.vertx.core.Handler<io.vertx.core.AsyncResult<java.lang.Character>> handler) { 
    delegate.methodWithHandlerAsyncResultCharacter(sendFailure, handler);
  }

  public void methodWithHandlerAsyncResultCharacter(boolean sendFailure) {
    methodWithHandlerAsyncResultCharacter(sendFailure, ar -> { });
  }

  public io.reactivex.Single<java.lang.Character> rxMethodWithHandlerAsyncResultCharacter(boolean sendFailure) { 
    return AsyncResultSingle.toSingle($handler -> {
      methodWithHandlerAsyncResultCharacter(sendFailure, $handler);
    });
  }

  public void methodWithHandlerAsyncResultString(boolean sendFailure, io.vertx.core.Handler<io.vertx.core.AsyncResult<java.lang.String>> handler) { 
    delegate.methodWithHandlerAsyncResultString(sendFailure, handler);
  }

  public void methodWithHandlerAsyncResultString(boolean sendFailure) {
    methodWithHandlerAsyncResultString(sendFailure, ar -> { });
  }

  public io.reactivex.Single<java.lang.String> rxMethodWithHandlerAsyncResultString(boolean sendFailure) { 
    return AsyncResultSingle.toSingle($handler -> {
      methodWithHandlerAsyncResultString(sendFailure, $handler);
    });
  }

  public void methodWithHandlerAsyncResultDataObject(boolean sendFailure, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.codegen.testmodel.TestDataObject>> handler) { 
    delegate.methodWithHandlerAsyncResultDataObject(sendFailure, handler);
  }

  public void methodWithHandlerAsyncResultDataObject(boolean sendFailure) {
    methodWithHandlerAsyncResultDataObject(sendFailure, ar -> { });
  }

  public io.reactivex.Single<io.vertx.codegen.testmodel.TestDataObject> rxMethodWithHandlerAsyncResultDataObject(boolean sendFailure) { 
    return AsyncResultSingle.toSingle($handler -> {
      methodWithHandlerAsyncResultDataObject(sendFailure, $handler);
    });
  }

  public void methodWithHandlerAsyncResultStringDataObject(boolean sendFailure, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.codegen.testmodel.TestStringDataObject>> handler) { 
    delegate.methodWithHandlerAsyncResultStringDataObject(sendFailure, handler);
  }

  public void methodWithHandlerAsyncResultStringDataObject(boolean sendFailure) {
    methodWithHandlerAsyncResultStringDataObject(sendFailure, ar -> { });
  }

  public io.reactivex.Single<io.vertx.codegen.testmodel.TestStringDataObject> rxMethodWithHandlerAsyncResultStringDataObject(boolean sendFailure) { 
    return AsyncResultSingle.toSingle($handler -> {
      methodWithHandlerAsyncResultStringDataObject(sendFailure, $handler);
    });
  }

  public io.vertx.core.Handler<io.vertx.core.AsyncResult<java.lang.String>> methodWithHandlerAsyncResultStringReturn(java.lang.String expected, boolean fail) { 
    io.vertx.core.Handler<io.vertx.core.AsyncResult<java.lang.String>> ret = delegate.methodWithHandlerAsyncResultStringReturn(expected, fail);
    return ret;
  }

  public <T> io.vertx.core.Handler<io.vertx.core.AsyncResult<T>> methodWithHandlerAsyncResultGenericReturn(io.vertx.core.Handler<io.vertx.core.AsyncResult<T>> handler) { 
    io.vertx.core.Handler<io.vertx.core.AsyncResult<T>> ret = delegate.methodWithHandlerAsyncResultGenericReturn(handler);
    return ret;
  }

  public io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.codegen.testmodel.RefedInterface1>> methodWithHandlerAsyncResultVertxGenReturn(java.lang.String expected, boolean fail) { 
    io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.codegen.testmodel.RefedInterface1>> ret = new Handler<AsyncResult<io.vertx.reactivex.codegen.testmodel.RefedInterface1>>() {
      public void handle(AsyncResult<io.vertx.reactivex.codegen.testmodel.RefedInterface1> ar) {
        if (ar.succeeded()) {
          delegate.methodWithHandlerAsyncResultVertxGenReturn(expected, fail).handle(io.vertx.core.Future.succeededFuture(ar.result().getDelegate()));
        } else {
          delegate.methodWithHandlerAsyncResultVertxGenReturn(expected, fail).handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    };
    return ret;
  }

  public void methodWithUserTypes(io.vertx.reactivex.codegen.testmodel.RefedInterface1 refed) { 
    delegate.methodWithUserTypes(refed.getDelegate());
  }

  public java.lang.String methodWithOverloadedUserTypes(io.vertx.reactivex.codegen.testmodel.RefedInterface1 refed) { 
    java.lang.String ret = delegate.methodWithOverloadedUserTypes(refed.getDelegate());
    return ret;
  }

  public java.lang.String methodWithOverloadedUserTypes(io.vertx.reactivex.codegen.testmodel.RefedInterface2 refed) { 
    java.lang.String ret = delegate.methodWithOverloadedUserTypes(refed.getDelegate());
    return ret;
  }

  public void methodWithObjectParam(java.lang.String str, java.lang.Object obj) { 
    delegate.methodWithObjectParam(str, obj);
  }

  public void methodWithDataObjectParam(io.vertx.codegen.testmodel.TestDataObject dataObject) { 
    delegate.methodWithDataObjectParam(dataObject);
  }

  public void methodWithStringDataObjectParam(io.vertx.codegen.testmodel.TestStringDataObject dataObject) { 
    delegate.methodWithStringDataObjectParam(dataObject);
  }

  public void methodWithHandlerUserTypes(io.vertx.core.Handler<io.vertx.reactivex.codegen.testmodel.RefedInterface1> handler) { 
    delegate.methodWithHandlerUserTypes(new Handler<io.vertx.codegen.testmodel.RefedInterface1>() {
      public void handle(io.vertx.codegen.testmodel.RefedInterface1 event) {
        handler.handle(io.vertx.reactivex.codegen.testmodel.RefedInterface1.newInstance((io.vertx.codegen.testmodel.RefedInterface1)event));
      }
    });
  }

  public void methodWithHandlerAsyncResultUserTypes(io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.codegen.testmodel.RefedInterface1>> handler) { 
    delegate.methodWithHandlerAsyncResultUserTypes(new Handler<AsyncResult<io.vertx.codegen.testmodel.RefedInterface1>>() {
      public void handle(AsyncResult<io.vertx.codegen.testmodel.RefedInterface1> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.codegen.testmodel.RefedInterface1.newInstance((io.vertx.codegen.testmodel.RefedInterface1)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
  }

  public void methodWithHandlerAsyncResultUserTypes() {
    methodWithHandlerAsyncResultUserTypes(ar -> { });
  }

  public io.reactivex.Single<io.vertx.reactivex.codegen.testmodel.RefedInterface1> rxMethodWithHandlerAsyncResultUserTypes() { 
    return AsyncResultSingle.toSingle($handler -> {
      methodWithHandlerAsyncResultUserTypes($handler);
    });
  }

  public void methodWithConcreteHandlerUserTypeSubtype(io.vertx.reactivex.codegen.testmodel.ConcreteHandlerUserType handler) { 
    delegate.methodWithConcreteHandlerUserTypeSubtype(handler.getDelegate());
  }

  public void methodWithAbstractHandlerUserTypeSubtype(io.vertx.reactivex.codegen.testmodel.AbstractHandlerUserType handler) { 
    delegate.methodWithAbstractHandlerUserTypeSubtype(handler.getDelegate());
  }

  public void methodWithConcreteHandlerUserTypeSubtypeExtension(io.vertx.reactivex.codegen.testmodel.ConcreteHandlerUserTypeExtension handler) { 
    delegate.methodWithConcreteHandlerUserTypeSubtypeExtension(handler.getDelegate());
  }

  public void methodWithHandlerVoid(io.vertx.core.Handler<java.lang.Void> handler) { 
    delegate.methodWithHandlerVoid(handler);
  }

  public void methodWithHandlerAsyncResultVoid(boolean sendFailure, io.vertx.core.Handler<io.vertx.core.AsyncResult<java.lang.Void>> handler) { 
    delegate.methodWithHandlerAsyncResultVoid(sendFailure, handler);
  }

  public void methodWithHandlerAsyncResultVoid(boolean sendFailure) {
    methodWithHandlerAsyncResultVoid(sendFailure, ar -> { });
  }

  public io.reactivex.Completable rxMethodWithHandlerAsyncResultVoid(boolean sendFailure) { 
    return AsyncResultCompletable.toCompletable($handler -> {
      methodWithHandlerAsyncResultVoid(sendFailure, $handler);
    });
  }

  public void methodWithHandlerThrowable(io.vertx.core.Handler<java.lang.Throwable> handler) { 
    delegate.methodWithHandlerThrowable(handler);
  }

  public void methodWithHandlerDataObject(io.vertx.core.Handler<io.vertx.codegen.testmodel.TestDataObject> handler) { 
    delegate.methodWithHandlerDataObject(handler);
  }

  public void methodWithHandlerStringDataObject(io.vertx.core.Handler<io.vertx.codegen.testmodel.TestStringDataObject> handler) { 
    delegate.methodWithHandlerStringDataObject(handler);
  }

  public <U> void methodWithHandlerGenericUserType(U value, io.vertx.core.Handler<io.vertx.reactivex.codegen.testmodel.GenericRefedInterface<U>> handler) { 
    delegate.methodWithHandlerGenericUserType(value, new Handler<io.vertx.codegen.testmodel.GenericRefedInterface<U>>() {
      public void handle(io.vertx.codegen.testmodel.GenericRefedInterface<U> event) {
        handler.handle(io.vertx.reactivex.codegen.testmodel.GenericRefedInterface.newInstance((io.vertx.codegen.testmodel.GenericRefedInterface)event, TypeArg.unknown()));
      }
    });
  }

  public <U> void methodWithHandlerAsyncResultGenericUserType(U value, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.codegen.testmodel.GenericRefedInterface<U>>> handler) { 
    delegate.methodWithHandlerAsyncResultGenericUserType(value, new Handler<AsyncResult<io.vertx.codegen.testmodel.GenericRefedInterface<U>>>() {
      public void handle(AsyncResult<io.vertx.codegen.testmodel.GenericRefedInterface<U>> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.codegen.testmodel.GenericRefedInterface.newInstance((io.vertx.codegen.testmodel.GenericRefedInterface)ar.result(), TypeArg.unknown())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
  }

  public <U> void methodWithHandlerAsyncResultGenericUserType(U value) {
    methodWithHandlerAsyncResultGenericUserType(value, ar -> { });
  }

  public <U> io.reactivex.Single<io.vertx.reactivex.codegen.testmodel.GenericRefedInterface<U>> rxMethodWithHandlerAsyncResultGenericUserType(U value) { 
    return AsyncResultSingle.toSingle($handler -> {
      methodWithHandlerAsyncResultGenericUserType(value, $handler);
    });
  }

  public byte methodWithByteReturn() { 
    byte ret = delegate.methodWithByteReturn();
    return ret;
  }

  public short methodWithShortReturn() { 
    short ret = delegate.methodWithShortReturn();
    return ret;
  }

  public int methodWithIntReturn() { 
    int ret = delegate.methodWithIntReturn();
    return ret;
  }

  public long methodWithLongReturn() { 
    long ret = delegate.methodWithLongReturn();
    return ret;
  }

  public float methodWithFloatReturn() { 
    float ret = delegate.methodWithFloatReturn();
    return ret;
  }

  public double methodWithDoubleReturn() { 
    double ret = delegate.methodWithDoubleReturn();
    return ret;
  }

  public boolean methodWithBooleanReturn() { 
    boolean ret = delegate.methodWithBooleanReturn();
    return ret;
  }

  public char methodWithCharReturn() { 
    char ret = delegate.methodWithCharReturn();
    return ret;
  }

  public java.lang.String methodWithStringReturn() { 
    java.lang.String ret = delegate.methodWithStringReturn();
    return ret;
  }

  public io.vertx.reactivex.codegen.testmodel.RefedInterface1 methodWithVertxGenReturn() { 
    io.vertx.reactivex.codegen.testmodel.RefedInterface1 ret = io.vertx.reactivex.codegen.testmodel.RefedInterface1.newInstance((io.vertx.codegen.testmodel.RefedInterface1)delegate.methodWithVertxGenReturn());
    return ret;
  }

  public io.vertx.reactivex.codegen.testmodel.RefedInterface1 methodWithVertxGenNullReturn() { 
    io.vertx.reactivex.codegen.testmodel.RefedInterface1 ret = io.vertx.reactivex.codegen.testmodel.RefedInterface1.newInstance((io.vertx.codegen.testmodel.RefedInterface1)delegate.methodWithVertxGenNullReturn());
    return ret;
  }

  public io.vertx.reactivex.codegen.testmodel.RefedInterface2 methodWithAbstractVertxGenReturn() { 
    io.vertx.reactivex.codegen.testmodel.RefedInterface2 ret = io.vertx.reactivex.codegen.testmodel.RefedInterface2.newInstance((io.vertx.codegen.testmodel.RefedInterface2)delegate.methodWithAbstractVertxGenReturn());
    return ret;
  }

  public io.vertx.codegen.testmodel.TestDataObject methodWithDataObjectReturn() { 
    io.vertx.codegen.testmodel.TestDataObject ret = delegate.methodWithDataObjectReturn();
    return ret;
  }

  public io.vertx.codegen.testmodel.TestStringDataObject methodWithStringDataObjectReturn() { 
    io.vertx.codegen.testmodel.TestStringDataObject ret = delegate.methodWithStringDataObjectReturn();
    return ret;
  }

  public io.vertx.codegen.testmodel.TestDataObject methodWithDataObjectNullReturn() { 
    io.vertx.codegen.testmodel.TestDataObject ret = delegate.methodWithDataObjectNullReturn();
    return ret;
  }

  public <U> io.vertx.reactivex.codegen.testmodel.GenericRefedInterface<U> methodWithGenericUserTypeReturn(U value) { 
    io.vertx.reactivex.codegen.testmodel.GenericRefedInterface<U> ret = io.vertx.reactivex.codegen.testmodel.GenericRefedInterface.newInstance((io.vertx.codegen.testmodel.GenericRefedInterface)delegate.methodWithGenericUserTypeReturn(value), TypeArg.unknown());
    return ret;
  }

  public java.lang.String overloadedMethod(java.lang.String str, io.vertx.core.Handler<java.lang.String> handler) { 
    java.lang.String ret = delegate.overloadedMethod(str, handler);
    return ret;
  }

  public java.lang.String overloadedMethod(java.lang.String str, io.vertx.reactivex.codegen.testmodel.RefedInterface1 refed) { 
    java.lang.String ret = delegate.overloadedMethod(str, refed.getDelegate());
    return ret;
  }

  public java.lang.String overloadedMethod(java.lang.String str, io.vertx.reactivex.codegen.testmodel.RefedInterface1 refed, io.vertx.core.Handler<java.lang.String> handler) { 
    java.lang.String ret = delegate.overloadedMethod(str, refed.getDelegate(), handler);
    return ret;
  }

  public java.lang.String overloadedMethod(java.lang.String str, io.vertx.reactivex.codegen.testmodel.RefedInterface1 refed, long period, io.vertx.core.Handler<java.lang.String> handler) { 
    java.lang.String ret = delegate.overloadedMethod(str, refed.getDelegate(), period, handler);
    return ret;
  }

  public <U> U methodWithGenericReturn(java.lang.String type) { 
    U ret = (U) delegate.methodWithGenericReturn(type);
    return ret;
  }

  public <U> void methodWithGenericParam(java.lang.String type, U u) { 
    delegate.methodWithGenericParam(type, u);
  }

  public <U> void methodWithGenericHandler(java.lang.String type, io.vertx.core.Handler<U> handler) { 
    delegate.methodWithGenericHandler(type, handler);
  }

  public <U> void methodWithGenericHandlerAsyncResult(java.lang.String type, io.vertx.core.Handler<io.vertx.core.AsyncResult<U>> asyncResultHandler) { 
    delegate.methodWithGenericHandlerAsyncResult(type, asyncResultHandler);
  }

  public <U> void methodWithGenericHandlerAsyncResult(java.lang.String type) {
    methodWithGenericHandlerAsyncResult(type, ar -> { });
  }

  public <U> io.reactivex.Single<U> rxMethodWithGenericHandlerAsyncResult(java.lang.String type) { 
    return AsyncResultSingle.toSingle($handler -> {
      methodWithGenericHandlerAsyncResult(type, $handler);
    });
  }

  public io.vertx.reactivex.codegen.testmodel.TestInterface fluentMethod(java.lang.String str) { 
    delegate.fluentMethod(str);
    return this;
  }

  public static io.vertx.reactivex.codegen.testmodel.RefedInterface1 staticFactoryMethod(java.lang.String foo) { 
    io.vertx.reactivex.codegen.testmodel.RefedInterface1 ret = io.vertx.reactivex.codegen.testmodel.RefedInterface1.newInstance((io.vertx.codegen.testmodel.RefedInterface1)io.vertx.codegen.testmodel.TestInterface.staticFactoryMethod(foo));
    return ret;
  }

  public io.vertx.reactivex.codegen.testmodel.RefedInterface1 methodWithCachedReturn(java.lang.String foo) { 
    if (cached_0 != null) {
      return cached_0;
    }
    io.vertx.reactivex.codegen.testmodel.RefedInterface1 ret = io.vertx.reactivex.codegen.testmodel.RefedInterface1.newInstance((io.vertx.codegen.testmodel.RefedInterface1)delegate.methodWithCachedReturn(foo));
    cached_0 = ret;
    return ret;
  }

  public int methodWithCachedReturnPrimitive(int arg) { 
    if (cached_1 != null) {
      return cached_1;
    }
    int ret = delegate.methodWithCachedReturnPrimitive(arg);
    cached_1 = ret;
    return ret;
  }

  public java.util.List<io.vertx.reactivex.codegen.testmodel.RefedInterface1> methodWithCachedListReturn() { 
    if (cached_2 != null) {
      return cached_2;
    }
    java.util.List<io.vertx.reactivex.codegen.testmodel.RefedInterface1> ret = delegate.methodWithCachedListReturn().stream().map(elt -> io.vertx.reactivex.codegen.testmodel.RefedInterface1.newInstance((io.vertx.codegen.testmodel.RefedInterface1)elt)).collect(Collectors.toList());
    cached_2 = ret;
    return ret;
  }

  public io.vertx.core.json.JsonObject methodWithJsonObjectReturn() { 
    io.vertx.core.json.JsonObject ret = delegate.methodWithJsonObjectReturn();
    return ret;
  }

  public io.vertx.core.json.JsonObject methodWithNullJsonObjectReturn() { 
    io.vertx.core.json.JsonObject ret = delegate.methodWithNullJsonObjectReturn();
    return ret;
  }

  public io.vertx.core.json.JsonObject methodWithComplexJsonObjectReturn() { 
    io.vertx.core.json.JsonObject ret = delegate.methodWithComplexJsonObjectReturn();
    return ret;
  }

  public io.vertx.core.json.JsonArray methodWithJsonArrayReturn() { 
    io.vertx.core.json.JsonArray ret = delegate.methodWithJsonArrayReturn();
    return ret;
  }

  public io.vertx.core.json.JsonArray methodWithNullJsonArrayReturn() { 
    io.vertx.core.json.JsonArray ret = delegate.methodWithNullJsonArrayReturn();
    return ret;
  }

  public io.vertx.core.json.JsonArray methodWithComplexJsonArrayReturn() { 
    io.vertx.core.json.JsonArray ret = delegate.methodWithComplexJsonArrayReturn();
    return ret;
  }

  public void methodWithJsonParams(io.vertx.core.json.JsonObject jsonObject, io.vertx.core.json.JsonArray jsonArray) { 
    delegate.methodWithJsonParams(jsonObject, jsonArray);
  }

  public void methodWithNullJsonParams(io.vertx.core.json.JsonObject jsonObject, io.vertx.core.json.JsonArray jsonArray) { 
    delegate.methodWithNullJsonParams(jsonObject, jsonArray);
  }

  public void methodWithHandlerJson(io.vertx.core.Handler<io.vertx.core.json.JsonObject> jsonObjectHandler, io.vertx.core.Handler<io.vertx.core.json.JsonArray> jsonArrayHandler) { 
    delegate.methodWithHandlerJson(jsonObjectHandler, jsonArrayHandler);
  }

  public void methodWithHandlerComplexJson(io.vertx.core.Handler<io.vertx.core.json.JsonObject> jsonObjectHandler, io.vertx.core.Handler<io.vertx.core.json.JsonArray> jsonArrayHandler) { 
    delegate.methodWithHandlerComplexJson(jsonObjectHandler, jsonArrayHandler);
  }

  public void methodWithHandlerAsyncResultJsonObject(io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.core.json.JsonObject>> handler) { 
    delegate.methodWithHandlerAsyncResultJsonObject(handler);
  }

  public void methodWithHandlerAsyncResultJsonObject() {
    methodWithHandlerAsyncResultJsonObject(ar -> { });
  }

  public io.reactivex.Single<io.vertx.core.json.JsonObject> rxMethodWithHandlerAsyncResultJsonObject() { 
    return AsyncResultSingle.toSingle($handler -> {
      methodWithHandlerAsyncResultJsonObject($handler);
    });
  }

  public void methodWithHandlerAsyncResultNullJsonObject(io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.core.json.JsonObject>> handler) { 
    delegate.methodWithHandlerAsyncResultNullJsonObject(handler);
  }

  public void methodWithHandlerAsyncResultNullJsonObject() {
    methodWithHandlerAsyncResultNullJsonObject(ar -> { });
  }

  public io.reactivex.Maybe<io.vertx.core.json.JsonObject> rxMethodWithHandlerAsyncResultNullJsonObject() { 
    return AsyncResultMaybe.toMaybe($handler -> {
      methodWithHandlerAsyncResultNullJsonObject($handler);
    });
  }

  public void methodWithHandlerAsyncResultComplexJsonObject(io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.core.json.JsonObject>> handler) { 
    delegate.methodWithHandlerAsyncResultComplexJsonObject(handler);
  }

  public void methodWithHandlerAsyncResultComplexJsonObject() {
    methodWithHandlerAsyncResultComplexJsonObject(ar -> { });
  }

  public io.reactivex.Single<io.vertx.core.json.JsonObject> rxMethodWithHandlerAsyncResultComplexJsonObject() { 
    return AsyncResultSingle.toSingle($handler -> {
      methodWithHandlerAsyncResultComplexJsonObject($handler);
    });
  }

  public void methodWithHandlerAsyncResultJsonArray(io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.core.json.JsonArray>> handler) { 
    delegate.methodWithHandlerAsyncResultJsonArray(handler);
  }

  public void methodWithHandlerAsyncResultJsonArray() {
    methodWithHandlerAsyncResultJsonArray(ar -> { });
  }

  public io.reactivex.Single<io.vertx.core.json.JsonArray> rxMethodWithHandlerAsyncResultJsonArray() { 
    return AsyncResultSingle.toSingle($handler -> {
      methodWithHandlerAsyncResultJsonArray($handler);
    });
  }

  public void methodWithHandlerAsyncResultNullJsonArray(io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.core.json.JsonArray>> handler) { 
    delegate.methodWithHandlerAsyncResultNullJsonArray(handler);
  }

  public void methodWithHandlerAsyncResultNullJsonArray() {
    methodWithHandlerAsyncResultNullJsonArray(ar -> { });
  }

  public io.reactivex.Maybe<io.vertx.core.json.JsonArray> rxMethodWithHandlerAsyncResultNullJsonArray() { 
    return AsyncResultMaybe.toMaybe($handler -> {
      methodWithHandlerAsyncResultNullJsonArray($handler);
    });
  }

  public void methodWithHandlerAsyncResultComplexJsonArray(io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.core.json.JsonArray>> handler) { 
    delegate.methodWithHandlerAsyncResultComplexJsonArray(handler);
  }

  public void methodWithHandlerAsyncResultComplexJsonArray() {
    methodWithHandlerAsyncResultComplexJsonArray(ar -> { });
  }

  public io.reactivex.Single<io.vertx.core.json.JsonArray> rxMethodWithHandlerAsyncResultComplexJsonArray() { 
    return AsyncResultSingle.toSingle($handler -> {
      methodWithHandlerAsyncResultComplexJsonArray($handler);
    });
  }

  public java.lang.String methodWithEnumParam(java.lang.String strVal, io.vertx.codegen.testmodel.TestEnum weirdo) { 
    java.lang.String ret = delegate.methodWithEnumParam(strVal, weirdo);
    return ret;
  }

  public io.vertx.codegen.testmodel.TestEnum methodWithEnumReturn(java.lang.String strVal) { 
    io.vertx.codegen.testmodel.TestEnum ret = delegate.methodWithEnumReturn(strVal);
    return ret;
  }

  public java.lang.String methodWithGenEnumParam(java.lang.String strVal, io.vertx.codegen.testmodel.TestGenEnum weirdo) { 
    java.lang.String ret = delegate.methodWithGenEnumParam(strVal, weirdo);
    return ret;
  }

  public io.vertx.codegen.testmodel.TestGenEnum methodWithGenEnumReturn(java.lang.String strVal) { 
    io.vertx.codegen.testmodel.TestGenEnum ret = delegate.methodWithGenEnumReturn(strVal);
    return ret;
  }

  public java.lang.Throwable methodWithThrowableReturn(java.lang.String strVal) { 
    java.lang.Throwable ret = delegate.methodWithThrowableReturn(strVal);
    return ret;
  }

  public java.lang.String methodWithThrowableParam(java.lang.Throwable t) { 
    java.lang.String ret = delegate.methodWithThrowableParam(t);
    return ret;
  }

  public int superMethodOverloadedBySubclass(java.lang.String s) { 
    int ret = delegate.superMethodOverloadedBySubclass(s);
    return ret;
  }

  private io.vertx.reactivex.codegen.testmodel.RefedInterface1 cached_0;
  private java.lang.Integer cached_1;
  private java.util.List<io.vertx.reactivex.codegen.testmodel.RefedInterface1> cached_2;
  public static TestInterface newInstance(io.vertx.codegen.testmodel.TestInterface arg) {
    return arg != null ? new TestInterface(arg) : null;
  }

}
