/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.core.streams;

import io.vertx.reactivex.RxHelper;
import io.vertx.reactivex.ObservableHelper;
import io.vertx.reactivex.FlowableHelper;
import io.vertx.reactivex.impl.AsyncResultMaybe;
import io.vertx.reactivex.impl.AsyncResultSingle;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.WriteStreamObserver;
import io.vertx.reactivex.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;


@RxGen(io.vertx.core.streams.ReadStream.class)
public interface ReadStream<T> {

  io.vertx.core.streams.ReadStream getDelegate();

  io.reactivex.Observable<T> toObservable();

  io.reactivex.Flowable<T> toFlowable();

  public static <T> ReadStream<T> newInstance(io.vertx.core.streams.ReadStream arg) {
    return arg != null ? new ReadStreamImpl<T>(arg) : null;
  }

  public static <T> ReadStream<T> newInstance(io.vertx.core.streams.ReadStream arg, TypeArg<T> __typeArg_T) {
    return arg != null ? new ReadStreamImpl<T>(arg, __typeArg_T) : null;
  }

}

class ReadStreamImpl<T> implements ReadStream<T> {
  private final io.vertx.core.streams.ReadStream<T> delegate;
  public final TypeArg<T> __typeArg_0;
  
  public ReadStreamImpl(io.vertx.core.streams.ReadStream delegate) {
    this.delegate = delegate;
    this.__typeArg_0 = TypeArg.unknown();  }

  public ReadStreamImpl(Object delegate, TypeArg<T> typeArg_0) {
    this.delegate = (io.vertx.core.streams.ReadStream)delegate;
    this.__typeArg_0 = typeArg_0;
  }

  public io.vertx.core.streams.ReadStream getDelegate() {
    return delegate;
  }

  private io.reactivex.Observable<T> observable;
  private io.reactivex.Flowable<T> flowable;

  public synchronized io.reactivex.Observable<T> toObservable() {
    if (observable == null) {
      Function<T, T> conv = (Function<T, T>) __typeArg_0.wrap;
      observable = ObservableHelper.toObservable(delegate, conv);
    }
    return observable;
  }

  public synchronized io.reactivex.Flowable<T> toFlowable() {
    if (flowable == null) {
      Function<T, T> conv = (Function<T, T>) __typeArg_0.wrap;
      flowable = FlowableHelper.toFlowable(delegate, conv);
    }
    return flowable;
  }

}
