/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.core.streams;

import io.vertx.reactivex.RxHelper;
import io.vertx.reactivex.ObservableHelper;
import io.vertx.reactivex.FlowableHelper;
import io.vertx.reactivex.impl.AsyncResultMaybe;
import io.vertx.reactivex.impl.AsyncResultSingle;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.WriteStreamObserver;
import io.vertx.reactivex.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;


@RxGen(io.vertx.core.streams.WriteStream.class)
public interface WriteStream<T> {

  io.vertx.core.streams.WriteStream getDelegate();

  public static <T> WriteStream<T> newInstance(io.vertx.core.streams.WriteStream arg) {
    return arg != null ? new WriteStreamImpl<T>(arg) : null;
  }

  public static <T> WriteStream<T> newInstance(io.vertx.core.streams.WriteStream arg, TypeArg<T> __typeArg_T) {
    return arg != null ? new WriteStreamImpl<T>(arg, __typeArg_T) : null;
  }

}

class WriteStreamImpl<T> implements WriteStream<T> {
  private final io.vertx.core.streams.WriteStream<T> delegate;
  public final TypeArg<T> __typeArg_0;
  
  public WriteStreamImpl(io.vertx.core.streams.WriteStream delegate) {
    this.delegate = delegate;
    this.__typeArg_0 = TypeArg.unknown();  }

  public WriteStreamImpl(Object delegate, TypeArg<T> typeArg_0) {
    this.delegate = (io.vertx.core.streams.WriteStream)delegate;
    this.__typeArg_0 = typeArg_0;
  }

  public io.vertx.core.streams.WriteStream getDelegate() {
    return delegate;
  }

  private WriteStreamObserver<T> observer;
  private WriteStreamSubscriber<T> subscriber;

  public synchronized WriteStreamObserver<T> toObserver() {
    if (observer == null) {
      Function<T, T> conv = (Function<T, T>) __typeArg_0.unwrap;
      observer = RxHelper.toObserver(getDelegate(), conv);
    }
    return observer;
  }

  public synchronized WriteStreamSubscriber<T> toSubscriber() {
    if (subscriber == null) {
      Function<T, T> conv = (Function<T, T>) __typeArg_0.unwrap;
      subscriber = RxHelper.toSubscriber(getDelegate(), conv);
    }
    return subscriber;
  }

}
