/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.serviceproxy.clustered;

import com.jayway.awaitility.Awaitility;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.VertxOptions;
import io.vertx.core.eventbus.MessageCodec;
import io.vertx.core.eventbus.ReplyException;
import io.vertx.core.eventbus.ReplyFailure;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.serviceproxy.ServiceException;
import io.vertx.serviceproxy.clustered.LocalServiceProviderVerticle;
import io.vertx.serviceproxy.clustered.Service;
import io.vertx.serviceproxy.clustered.ServiceProviderVerticle;
import io.vertx.serviceproxy.testmodel.MyServiceException;
import io.vertx.serviceproxy.testmodel.MyServiceExceptionMessageCodec;
import io.vertx.serviceproxy.testmodel.SomeEnum;
import io.vertx.serviceproxy.testmodel.SomeVertxEnum;
import io.vertx.serviceproxy.testmodel.StringDataObject;
import io.vertx.serviceproxy.testmodel.TestDataObject;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.Test;

public class ClusteredTest {
    AtomicReference<Vertx> providerNode = new AtomicReference();
    AtomicReference<Vertx> consumerNode = new AtomicReference();

    @Before
    public void setUp() {
        VertxOptions options = new VertxOptions();
        options.getEventBusOptions().setHost("127.0.0.1");
        Vertx.clusteredVertx((VertxOptions)options, ar -> {
            Vertx vertx = (Vertx)ar.result();
            vertx.eventBus().registerDefaultCodec(MyServiceException.class, (MessageCodec)new MyServiceExceptionMessageCodec());
            this.providerNode.set(vertx);
            vertx.deployVerticle(ServiceProviderVerticle.class.getName());
            vertx.deployVerticle(LocalServiceProviderVerticle.class.getName());
        });
        Vertx.clusteredVertx((VertxOptions)options, ar -> {
            Vertx vertx = (Vertx)ar.result();
            vertx.eventBus().registerDefaultCodec(MyServiceException.class, (MessageCodec)new MyServiceExceptionMessageCodec());
            this.consumerNode.set(vertx);
        });
        Awaitility.await().atMost(10L, TimeUnit.SECONDS).until(() -> this.providerNode.get() != null);
        Awaitility.await().atMost(10L, TimeUnit.SECONDS).until(() -> this.consumerNode.get() != null);
    }

    @Test
    public void testHello() {
        AtomicReference result = new AtomicReference();
        Service service = Service.createProxy(this.consumerNode.get(), "my.service");
        service.hello("vert.x", (Handler<AsyncResult<String>>)((Handler)ar -> result.set(ar.result())));
        Awaitility.await().atMost(10L, TimeUnit.SECONDS).until(() -> "hello vert.x".equalsIgnoreCase((String)result.get()));
    }

    @Test
    public void testEnumAsParameter() {
        AtomicReference result = new AtomicReference();
        Service service = Service.createProxy(this.consumerNode.get(), "my.service");
        service.methodUsingEnum(SomeEnum.WIBBLE, (Handler<AsyncResult<Boolean>>)((Handler)ar -> result.set(ar.result())));
        Awaitility.await().atMost(10L, TimeUnit.SECONDS).until(() -> result.get() != null && (Boolean)result.get() != false);
    }

    @Test
    public void testEnumAsResult() {
        AtomicReference result = new AtomicReference();
        Service service = Service.createProxy(this.consumerNode.get(), "my.service");
        service.methodReturningEnum((Handler<AsyncResult<SomeEnum>>)((Handler)ar -> result.set(ar.result())));
        Awaitility.await().atMost(10L, TimeUnit.SECONDS).until(() -> result.get() == SomeEnum.WIBBLE);
    }

    @Test
    public void testVertxEnumAsResult() {
        AtomicReference result = new AtomicReference();
        Service service = Service.createProxy(this.consumerNode.get(), "my.service");
        service.methodReturningVertxEnum((Handler<AsyncResult<SomeVertxEnum>>)((Handler)ar -> result.set(ar.result())));
        Awaitility.await().atMost(10L, TimeUnit.SECONDS).until(() -> result.get() == SomeVertxEnum.BAR);
    }

    @Test
    public void testWithDataObject() {
        AtomicReference result = new AtomicReference();
        Service service = Service.createProxy(this.consumerNode.get(), "my.service");
        TestDataObject data = new TestDataObject().setBool(true).setNumber(25).setString("vert.x");
        service.methodWithDataObject(data, (Handler<AsyncResult<TestDataObject>>)((Handler)ar -> result.set(ar.result())));
        Awaitility.await().atMost(10L, TimeUnit.SECONDS).until(() -> result.get() != null);
        TestDataObject out = (TestDataObject)result.get();
        Assertions.assertThat((int)out.getNumber()).isEqualTo(25);
        Assertions.assertThat((boolean)out.isBool()).isTrue();
        Assertions.assertThat((String)out.getString()).isEqualTo((Object)"vert.x");
    }

    @Test
    public void testWithListOfDataObject() {
        AtomicReference result = new AtomicReference();
        Service service = Service.createProxy(this.consumerNode.get(), "my.service");
        TestDataObject data = new TestDataObject().setBool(true).setNumber(25).setString("vert.x");
        TestDataObject data2 = new TestDataObject().setBool(true).setNumber(26).setString("vert.x");
        service.methodWithListOfDataObject(Arrays.asList(data, data2), (Handler<AsyncResult<List<TestDataObject>>>)((Handler)ar -> {
            if (ar.failed()) {
                ar.cause().printStackTrace();
            }
            result.set(ar.result());
        }));
        Awaitility.await().atMost(10L, TimeUnit.SECONDS).until(() -> result.get() != null);
        List out = (List)result.get();
        Assertions.assertThat((int)((TestDataObject)out.get(0)).getNumber()).isEqualTo(25);
        Assertions.assertThat((boolean)((TestDataObject)out.get(0)).isBool()).isTrue();
        Assertions.assertThat((String)((TestDataObject)out.get(0)).getString()).isEqualTo((Object)"vert.x");
        Assertions.assertThat((int)((TestDataObject)out.get(1)).getNumber()).isEqualTo(26);
        Assertions.assertThat((boolean)((TestDataObject)out.get(1)).isBool()).isTrue();
        Assertions.assertThat((String)((TestDataObject)out.get(1)).getString()).isEqualTo((Object)"vert.x");
    }

    @Test
    public void testWithStringDataObject() {
        AtomicReference result = new AtomicReference();
        Service service = Service.createProxy(this.consumerNode.get(), "my.service");
        StringDataObject data = new StringDataObject().setValue("vert.x");
        service.methodWithStringDataObject(data, (Handler<AsyncResult<StringDataObject>>)((Handler)ar -> result.set(ar.result())));
        Awaitility.await().atMost(10L, TimeUnit.SECONDS).until(() -> result.get() != null);
        StringDataObject out = (StringDataObject)result.get();
        Assertions.assertThat((String)out.getValue()).isEqualTo((Object)"vert.x");
    }

    @Test
    public void testWithListOfStringDataObject() {
        AtomicReference result = new AtomicReference();
        Service service = Service.createProxy(this.consumerNode.get(), "my.service");
        StringDataObject data = new StringDataObject().setValue("vert.x-1");
        StringDataObject data2 = new StringDataObject().setValue("vert.x-2");
        service.methodWithListOfStringDataObject(Arrays.asList(data, data2), (Handler<AsyncResult<List<StringDataObject>>>)((Handler)ar -> {
            if (ar.failed()) {
                ar.cause().printStackTrace();
            }
            result.set(ar.result());
        }));
        Awaitility.await().atMost(10L, TimeUnit.SECONDS).until(() -> result.get() != null);
        List out = (List)result.get();
        Assertions.assertThat((String)((StringDataObject)out.get(0)).getValue()).isEqualTo((Object)"vert.x-1");
        Assertions.assertThat((String)((StringDataObject)out.get(1)).getValue()).isEqualTo((Object)"vert.x-2");
    }

    @Test
    public void testWithListOfJsonObject() {
        AtomicReference result = new AtomicReference();
        Service service = Service.createProxy(this.consumerNode.get(), "my.service");
        TestDataObject data = new TestDataObject().setBool(true).setNumber(25).setString("vert.x");
        TestDataObject data2 = new TestDataObject().setBool(true).setNumber(26).setString("vert.x");
        service.methodWithListOfJsonObject(Arrays.asList(data.toJson(), data2.toJson()), (Handler<AsyncResult<List<JsonObject>>>)((Handler)ar -> {
            if (ar.failed()) {
                ar.cause().printStackTrace();
            }
            result.set(ar.result());
        }));
        Awaitility.await().atMost(10L, TimeUnit.SECONDS).until(() -> result.get() != null);
        List out = (List)result.get();
        TestDataObject out0 = new TestDataObject((JsonObject)out.get(0));
        TestDataObject out1 = new TestDataObject((JsonObject)out.get(1));
        Assertions.assertThat((int)out0.getNumber()).isEqualTo(25);
        Assertions.assertThat((boolean)out0.isBool()).isTrue();
        Assertions.assertThat((String)out0.getString()).isEqualTo((Object)"vert.x");
        Assertions.assertThat((int)out1.getNumber()).isEqualTo(26);
        Assertions.assertThat((boolean)out1.isBool()).isTrue();
        Assertions.assertThat((String)out1.getString()).isEqualTo((Object)"vert.x");
    }

    @Test
    public void testWithJsonObject() {
        AtomicReference result = new AtomicReference();
        Service service = Service.createProxy(this.consumerNode.get(), "my.service");
        TestDataObject data = new TestDataObject().setBool(true).setNumber(25).setString("vert.x");
        service.methodWithJsonObject(data.toJson(), (Handler<AsyncResult<JsonObject>>)((Handler)ar -> result.set(new TestDataObject((JsonObject)ar.result()))));
        Awaitility.await().atMost(10L, TimeUnit.SECONDS).until(() -> result.get() != null);
        TestDataObject out = (TestDataObject)result.get();
        Assertions.assertThat((int)out.getNumber()).isEqualTo(25);
        Assertions.assertThat((boolean)out.isBool()).isTrue();
        Assertions.assertThat((String)out.getString()).isEqualTo((Object)"vert.x");
    }

    @Test
    public void testWithJsonArray() {
        AtomicReference result = new AtomicReference();
        Service service = Service.createProxy(this.consumerNode.get(), "my.service");
        TestDataObject data = new TestDataObject().setBool(true).setNumber(25).setString("vert.x");
        JsonArray array = new JsonArray();
        array.add((Object)"vert.x").add((Object)data.toJson());
        service.methodWithJsonArray(array, (Handler<AsyncResult<JsonArray>>)((Handler)ar -> result.set(ar.result())));
        Awaitility.await().atMost(10L, TimeUnit.SECONDS).until(() -> result.get() != null);
        TestDataObject out = new TestDataObject(((JsonArray)result.get()).getJsonObject(1));
        Assertions.assertThat((String)array.getString(0)).isEqualToIgnoringCase((CharSequence)"vert.x");
        Assertions.assertThat((int)out.getNumber()).isEqualTo(25);
        Assertions.assertThat((boolean)out.isBool()).isTrue();
        Assertions.assertThat((String)out.getString()).isEqualTo((Object)"vert.x");
    }

    @Test
    public void testWithFailingResult() {
        AtomicReference result = new AtomicReference();
        Service service = Service.createProxy(this.consumerNode.get(), "my.service");
        service.methodWthFailingResult("Fail", (Handler<AsyncResult<JsonObject>>)((Handler)ar -> {
            Assertions.assertThat((boolean)(ar.cause() instanceof ServiceException)).isTrue();
            Assertions.assertThat((int)((ServiceException)ar.cause()).failureCode()).isEqualTo(30);
            Assertions.assertThat((Iterable)((ServiceException)ar.cause()).getDebugInfo()).isEqualTo((Object)new JsonObject().put("test", (Object)"val"));
            result.set(ar.cause());
        }));
        Awaitility.await().atMost(10L, TimeUnit.SECONDS).until(() -> result.get() != null);
    }

    @Test
    public void testWithFailingResultServiceExceptionSubclass() {
        AtomicReference result = new AtomicReference();
        Service service = Service.createProxy(this.consumerNode.get(), "my.service");
        service.methodWthFailingResult("cluster Fail", (Handler<AsyncResult<JsonObject>>)((Handler)ar -> {
            Assertions.assertThat((boolean)(ar.cause() instanceof MyServiceException)).isTrue();
            Assertions.assertThat((int)((MyServiceException)((Object)((Object)ar.cause()))).failureCode()).isEqualTo(30);
            Assertions.assertThat((String)((MyServiceException)((Object)((Object)ar.cause()))).getExtra()).isEqualTo((Object)"some extra");
            result.set(ar.cause());
        }));
        Awaitility.await().atMost(10L, TimeUnit.SECONDS).until(() -> result.get() != null);
    }

    @Test
    public void testLocalServiceShouldBeUnreachable() {
        AtomicReference result = new AtomicReference();
        Service service = Service.createProxy(this.consumerNode.get(), "my.local.service");
        service.hello("vert.x", (Handler<AsyncResult<String>>)((Handler)ar -> {
            Assertions.assertThat((boolean)ar.succeeded()).isFalse().withFailMessage("Local service should not be accessible from a different node in the cluster", new Object[0]);
            Assertions.assertThat((Throwable)ar.cause()).isNotNull();
            Assertions.assertThat((Throwable)ar.cause()).isInstanceOf(ReplyException.class);
            ReplyException exception = (ReplyException)ar.cause();
            Assertions.assertThat((Comparable)exception.failureType()).isEqualTo((Object)ReplyFailure.NO_HANDLERS);
            result.set(ar.cause());
        }));
        Awaitility.await().atMost(10L, TimeUnit.SECONDS).until(() -> result.get() != null);
    }
}

