/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.serviceproxy.clustered;

import io.vertx.codegen.annotations.Fluent;
import io.vertx.codegen.annotations.ProxyGen;
import io.vertx.codegen.annotations.VertxGen;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.serviceproxy.clustered.ServiceVertxEBProxy;
import io.vertx.serviceproxy.testmodel.SomeEnum;
import io.vertx.serviceproxy.testmodel.SomeEnumWithCustomConstructor;
import io.vertx.serviceproxy.testmodel.SomeVertxEnum;
import io.vertx.serviceproxy.testmodel.StringDataObject;
import io.vertx.serviceproxy.testmodel.TestDataObject;
import java.util.List;

@ProxyGen
@VertxGen
public interface Service {
    public static Service createProxy(Vertx vertx, String address) {
        return new ServiceVertxEBProxy(vertx, address);
    }

    @Fluent
    public Service hello(String var1, Handler<AsyncResult<String>> var2);

    @Fluent
    public Service methodUsingEnum(SomeEnum var1, Handler<AsyncResult<Boolean>> var2);

    @Fluent
    public Service methodReturningEnum(Handler<AsyncResult<SomeEnum>> var1);

    @Fluent
    public Service methodReturningVertxEnum(Handler<AsyncResult<SomeVertxEnum>> var1);

    @Fluent
    public Service methodUsingCustomEnum(SomeEnumWithCustomConstructor var1, Handler<AsyncResult<Boolean>> var2);

    @Fluent
    public Service methodReturningCustomEnum(Handler<AsyncResult<SomeEnumWithCustomConstructor>> var1);

    @Fluent
    public Service methodWithJsonObject(JsonObject var1, Handler<AsyncResult<JsonObject>> var2);

    @Fluent
    public Service methodWithJsonArray(JsonArray var1, Handler<AsyncResult<JsonArray>> var2);

    @Fluent
    public Service methodWithList(List<String> var1, Handler<AsyncResult<List<String>>> var2);

    @Fluent
    public Service methodWithDataObject(TestDataObject var1, Handler<AsyncResult<TestDataObject>> var2);

    @Fluent
    public Service methodWithListOfDataObject(List<TestDataObject> var1, Handler<AsyncResult<List<TestDataObject>>> var2);

    @Fluent
    public Service methodWithStringDataObject(StringDataObject var1, Handler<AsyncResult<StringDataObject>> var2);

    @Fluent
    public Service methodWithListOfStringDataObject(List<StringDataObject> var1, Handler<AsyncResult<List<StringDataObject>>> var2);

    @Fluent
    public Service methodWithListOfJsonObject(List<JsonObject> var1, Handler<AsyncResult<List<JsonObject>>> var2);

    @Fluent
    public Service methodWthFailingResult(String var1, Handler<AsyncResult<JsonObject>> var2);
}

