/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.serviceproxy.clustered;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.serviceproxy.ServiceException;
import io.vertx.serviceproxy.clustered.Service;
import io.vertx.serviceproxy.testmodel.MyServiceException;
import io.vertx.serviceproxy.testmodel.SomeEnum;
import io.vertx.serviceproxy.testmodel.SomeEnumWithCustomConstructor;
import io.vertx.serviceproxy.testmodel.SomeVertxEnum;
import io.vertx.serviceproxy.testmodel.StringDataObject;
import io.vertx.serviceproxy.testmodel.TestDataObject;
import java.util.List;

public class ServiceProvider
implements Service {
    @Override
    public Service hello(String name, Handler<AsyncResult<String>> result) {
        result.handle((Object)Future.succeededFuture((Object)("hello " + name)));
        return this;
    }

    @Override
    public Service methodUsingEnum(SomeEnum e, Handler<AsyncResult<Boolean>> result) {
        if (e == SomeEnum.WIBBLE) {
            result.handle((Object)Future.succeededFuture((Object)true));
        } else {
            result.handle((Object)Future.succeededFuture((Object)false));
        }
        return this;
    }

    @Override
    public Service methodReturningEnum(Handler<AsyncResult<SomeEnum>> result) {
        result.handle((Object)Future.succeededFuture((Object)((Object)SomeEnum.WIBBLE)));
        return this;
    }

    @Override
    public Service methodReturningVertxEnum(Handler<AsyncResult<SomeVertxEnum>> result) {
        result.handle((Object)Future.succeededFuture((Object)((Object)SomeVertxEnum.BAR)));
        return this;
    }

    @Override
    public Service methodWithJsonObject(JsonObject json, Handler<AsyncResult<JsonObject>> result) {
        result.handle((Object)Future.succeededFuture((Object)json));
        return this;
    }

    @Override
    public Service methodWithJsonArray(JsonArray json, Handler<AsyncResult<JsonArray>> result) {
        result.handle((Object)Future.succeededFuture((Object)json));
        return this;
    }

    @Override
    public Service methodWithList(List<String> list, Handler<AsyncResult<List<String>>> result) {
        result.handle((Object)Future.succeededFuture(list));
        return this;
    }

    @Override
    public Service methodWithDataObject(TestDataObject data, Handler<AsyncResult<TestDataObject>> result) {
        result.handle((Object)Future.succeededFuture((Object)data));
        return this;
    }

    @Override
    public Service methodWithListOfDataObject(List<TestDataObject> list, Handler<AsyncResult<List<TestDataObject>>> result) {
        result.handle((Object)Future.succeededFuture(list));
        return this;
    }

    @Override
    public Service methodWithStringDataObject(StringDataObject data, Handler<AsyncResult<StringDataObject>> result) {
        result.handle((Object)Future.succeededFuture((Object)data));
        return this;
    }

    @Override
    public Service methodWithListOfStringDataObject(List<StringDataObject> list, Handler<AsyncResult<List<StringDataObject>>> result) {
        result.handle((Object)Future.succeededFuture(list));
        return this;
    }

    @Override
    public Service methodWithListOfJsonObject(List<JsonObject> list, Handler<AsyncResult<List<JsonObject>>> result) {
        result.handle((Object)Future.succeededFuture(list));
        return this;
    }

    @Override
    public Service methodWthFailingResult(String input, Handler<AsyncResult<JsonObject>> result) {
        if (input.equals("Fail")) {
            result.handle((Object)ServiceException.fail((int)30, (String)"failed!", (JsonObject)new JsonObject().put("test", (Object)"val")));
        } else {
            result.handle(MyServiceException.fail(30, "failed!", "some extra"));
        }
        return this;
    }

    @Override
    public Service methodUsingCustomEnum(SomeEnumWithCustomConstructor e, Handler<AsyncResult<Boolean>> result) {
        if (e == SomeEnumWithCustomConstructor.ITEST) {
            result.handle((Object)Future.succeededFuture((Object)true));
        } else {
            result.handle((Object)Future.succeededFuture((Object)false));
        }
        return this;
    }

    @Override
    public Service methodReturningCustomEnum(Handler<AsyncResult<SomeEnumWithCustomConstructor>> result) {
        result.handle((Object)Future.succeededFuture((Object)((Object)SomeEnumWithCustomConstructor.DEV)));
        return this;
    }
}

