/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.serviceproxy.clustered;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.eventbus.DeliveryOptions;
import io.vertx.core.eventbus.Message;
import io.vertx.core.eventbus.MessageCodec;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.serviceproxy.ProxyUtils;
import io.vertx.serviceproxy.ServiceException;
import io.vertx.serviceproxy.ServiceExceptionMessageCodec;
import io.vertx.serviceproxy.clustered.Service;
import io.vertx.serviceproxy.testmodel.Mappers;
import io.vertx.serviceproxy.testmodel.SomeEnum;
import io.vertx.serviceproxy.testmodel.SomeEnumWithCustomConstructor;
import io.vertx.serviceproxy.testmodel.SomeVertxEnum;
import io.vertx.serviceproxy.testmodel.StringDataObject;
import io.vertx.serviceproxy.testmodel.TestDataObject;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public class ServiceVertxEBProxy
implements Service {
    private Vertx _vertx;
    private String _address;
    private DeliveryOptions _options;
    private boolean closed;

    public ServiceVertxEBProxy(Vertx vertx, String address) {
        this(vertx, address, null);
    }

    public ServiceVertxEBProxy(Vertx vertx, String address, DeliveryOptions options) {
        this._vertx = vertx;
        this._address = address;
        this._options = options;
        try {
            this._vertx.eventBus().registerDefaultCodec(ServiceException.class, (MessageCodec)new ServiceExceptionMessageCodec());
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Override
    public Service hello(String name, Handler<AsyncResult<String>> result) {
        if (this.closed) {
            result.handle((Object)Future.failedFuture((Throwable)new IllegalStateException("Proxy is closed")));
            return this;
        }
        JsonObject _json = new JsonObject();
        _json.put("name", (Object)name);
        DeliveryOptions _deliveryOptions = this._options != null ? new DeliveryOptions(this._options) : new DeliveryOptions();
        _deliveryOptions.addHeader("action", "hello");
        _deliveryOptions.getHeaders().set("action", "hello");
        this._vertx.eventBus().request(this._address, (Object)_json, _deliveryOptions, res -> {
            if (res.failed()) {
                result.handle((Object)Future.failedFuture((Throwable)res.cause()));
            } else {
                result.handle((Object)Future.succeededFuture((Object)((Message)res.result()).body()));
            }
        });
        return this;
    }

    @Override
    public Service methodUsingEnum(SomeEnum e, Handler<AsyncResult<Boolean>> result) {
        if (this.closed) {
            result.handle((Object)Future.failedFuture((Throwable)new IllegalStateException("Proxy is closed")));
            return this;
        }
        JsonObject _json = new JsonObject();
        _json.put("e", (Object)(e == null ? null : e.name()));
        DeliveryOptions _deliveryOptions = this._options != null ? new DeliveryOptions(this._options) : new DeliveryOptions();
        _deliveryOptions.addHeader("action", "methodUsingEnum");
        _deliveryOptions.getHeaders().set("action", "methodUsingEnum");
        this._vertx.eventBus().request(this._address, (Object)_json, _deliveryOptions, res -> {
            if (res.failed()) {
                result.handle((Object)Future.failedFuture((Throwable)res.cause()));
            } else {
                result.handle((Object)Future.succeededFuture((Object)((Message)res.result()).body()));
            }
        });
        return this;
    }

    @Override
    public Service methodReturningEnum(Handler<AsyncResult<SomeEnum>> result) {
        if (this.closed) {
            result.handle((Object)Future.failedFuture((Throwable)new IllegalStateException("Proxy is closed")));
            return this;
        }
        JsonObject _json = new JsonObject();
        DeliveryOptions _deliveryOptions = this._options != null ? new DeliveryOptions(this._options) : new DeliveryOptions();
        _deliveryOptions.addHeader("action", "methodReturningEnum");
        _deliveryOptions.getHeaders().set("action", "methodReturningEnum");
        this._vertx.eventBus().request(this._address, (Object)_json, _deliveryOptions, res -> {
            if (res.failed()) {
                result.handle((Object)Future.failedFuture((Throwable)res.cause()));
            } else {
                result.handle((Object)Future.succeededFuture(((Message)res.result()).body() == null ? null : SomeEnum.valueOf((String)((Message)res.result()).body())));
            }
        });
        return this;
    }

    @Override
    public Service methodReturningVertxEnum(Handler<AsyncResult<SomeVertxEnum>> result) {
        if (this.closed) {
            result.handle((Object)Future.failedFuture((Throwable)new IllegalStateException("Proxy is closed")));
            return this;
        }
        JsonObject _json = new JsonObject();
        DeliveryOptions _deliveryOptions = this._options != null ? new DeliveryOptions(this._options) : new DeliveryOptions();
        _deliveryOptions.addHeader("action", "methodReturningVertxEnum");
        _deliveryOptions.getHeaders().set("action", "methodReturningVertxEnum");
        this._vertx.eventBus().request(this._address, (Object)_json, _deliveryOptions, res -> {
            if (res.failed()) {
                result.handle((Object)Future.failedFuture((Throwable)res.cause()));
            } else {
                result.handle((Object)Future.succeededFuture(((Message)res.result()).body() == null ? null : SomeVertxEnum.valueOf((String)((Message)res.result()).body())));
            }
        });
        return this;
    }

    @Override
    public Service methodUsingCustomEnum(SomeEnumWithCustomConstructor e, Handler<AsyncResult<Boolean>> result) {
        if (this.closed) {
            result.handle((Object)Future.failedFuture((Throwable)new IllegalStateException("Proxy is closed")));
            return this;
        }
        JsonObject _json = new JsonObject();
        _json.put("e", (Object)(e != null ? Mappers.serializeSomeEnumWithCustomConstructor(e) : null));
        DeliveryOptions _deliveryOptions = this._options != null ? new DeliveryOptions(this._options) : new DeliveryOptions();
        _deliveryOptions.addHeader("action", "methodUsingCustomEnum");
        _deliveryOptions.getHeaders().set("action", "methodUsingCustomEnum");
        this._vertx.eventBus().request(this._address, (Object)_json, _deliveryOptions, res -> {
            if (res.failed()) {
                result.handle((Object)Future.failedFuture((Throwable)res.cause()));
            } else {
                result.handle((Object)Future.succeededFuture((Object)((Message)res.result()).body()));
            }
        });
        return this;
    }

    @Override
    public Service methodReturningCustomEnum(Handler<AsyncResult<SomeEnumWithCustomConstructor>> result) {
        if (this.closed) {
            result.handle((Object)Future.failedFuture((Throwable)new IllegalStateException("Proxy is closed")));
            return this;
        }
        JsonObject _json = new JsonObject();
        DeliveryOptions _deliveryOptions = this._options != null ? new DeliveryOptions(this._options) : new DeliveryOptions();
        _deliveryOptions.addHeader("action", "methodReturningCustomEnum");
        _deliveryOptions.getHeaders().set("action", "methodReturningCustomEnum");
        this._vertx.eventBus().request(this._address, (Object)_json, _deliveryOptions, res -> {
            if (res.failed()) {
                result.handle((Object)Future.failedFuture((Throwable)res.cause()));
            } else {
                result.handle((Object)Future.succeededFuture(((Message)res.result()).body() != null ? Mappers.deserializeSomeEnumWithCustomConstructor((String)((Message)res.result()).body()) : null));
            }
        });
        return this;
    }

    @Override
    public Service methodWithJsonObject(JsonObject json, Handler<AsyncResult<JsonObject>> result) {
        if (this.closed) {
            result.handle((Object)Future.failedFuture((Throwable)new IllegalStateException("Proxy is closed")));
            return this;
        }
        JsonObject _json = new JsonObject();
        _json.put("json", (Object)json);
        DeliveryOptions _deliveryOptions = this._options != null ? new DeliveryOptions(this._options) : new DeliveryOptions();
        _deliveryOptions.addHeader("action", "methodWithJsonObject");
        _deliveryOptions.getHeaders().set("action", "methodWithJsonObject");
        this._vertx.eventBus().request(this._address, (Object)_json, _deliveryOptions, res -> {
            if (res.failed()) {
                result.handle((Object)Future.failedFuture((Throwable)res.cause()));
            } else {
                result.handle((Object)Future.succeededFuture((Object)((Message)res.result()).body()));
            }
        });
        return this;
    }

    @Override
    public Service methodWithJsonArray(JsonArray json, Handler<AsyncResult<JsonArray>> result) {
        if (this.closed) {
            result.handle((Object)Future.failedFuture((Throwable)new IllegalStateException("Proxy is closed")));
            return this;
        }
        JsonObject _json = new JsonObject();
        _json.put("json", (Object)json);
        DeliveryOptions _deliveryOptions = this._options != null ? new DeliveryOptions(this._options) : new DeliveryOptions();
        _deliveryOptions.addHeader("action", "methodWithJsonArray");
        _deliveryOptions.getHeaders().set("action", "methodWithJsonArray");
        this._vertx.eventBus().request(this._address, (Object)_json, _deliveryOptions, res -> {
            if (res.failed()) {
                result.handle((Object)Future.failedFuture((Throwable)res.cause()));
            } else {
                result.handle((Object)Future.succeededFuture((Object)((Message)res.result()).body()));
            }
        });
        return this;
    }

    @Override
    public Service methodWithList(List<String> list, Handler<AsyncResult<List<String>>> result) {
        if (this.closed) {
            result.handle((Object)Future.failedFuture((Throwable)new IllegalStateException("Proxy is closed")));
            return this;
        }
        JsonObject _json = new JsonObject();
        _json.put("list", (Object)new JsonArray(list));
        DeliveryOptions _deliveryOptions = this._options != null ? new DeliveryOptions(this._options) : new DeliveryOptions();
        _deliveryOptions.addHeader("action", "methodWithList");
        _deliveryOptions.getHeaders().set("action", "methodWithList");
        this._vertx.eventBus().request(this._address, (Object)_json, _deliveryOptions, res -> {
            if (res.failed()) {
                result.handle((Object)Future.failedFuture((Throwable)res.cause()));
            } else {
                result.handle((Object)Future.succeededFuture((Object)ProxyUtils.convertList((List)((JsonArray)((Message)res.result()).body()).getList())));
            }
        });
        return this;
    }

    @Override
    public Service methodWithDataObject(TestDataObject data, Handler<AsyncResult<TestDataObject>> result) {
        if (this.closed) {
            result.handle((Object)Future.failedFuture((Throwable)new IllegalStateException("Proxy is closed")));
            return this;
        }
        JsonObject _json = new JsonObject();
        _json.put("data", (Object)(data != null ? data.toJson() : null));
        DeliveryOptions _deliveryOptions = this._options != null ? new DeliveryOptions(this._options) : new DeliveryOptions();
        _deliveryOptions.addHeader("action", "methodWithDataObject");
        _deliveryOptions.getHeaders().set("action", "methodWithDataObject");
        this._vertx.eventBus().request(this._address, (Object)_json, _deliveryOptions, res -> {
            if (res.failed()) {
                result.handle((Object)Future.failedFuture((Throwable)res.cause()));
            } else {
                result.handle((Object)Future.succeededFuture((Object)(((Message)res.result()).body() != null ? new TestDataObject((JsonObject)((Message)res.result()).body()) : null)));
            }
        });
        return this;
    }

    @Override
    public Service methodWithListOfDataObject(List<TestDataObject> list, Handler<AsyncResult<List<TestDataObject>>> result) {
        if (this.closed) {
            result.handle((Object)Future.failedFuture((Throwable)new IllegalStateException("Proxy is closed")));
            return this;
        }
        JsonObject _json = new JsonObject();
        _json.put("list", (Object)new JsonArray(list == null ? Collections.emptyList() : list.stream().map(v -> v != null ? v.toJson() : null).collect(Collectors.toList())));
        DeliveryOptions _deliveryOptions = this._options != null ? new DeliveryOptions(this._options) : new DeliveryOptions();
        _deliveryOptions.addHeader("action", "methodWithListOfDataObject");
        _deliveryOptions.getHeaders().set("action", "methodWithListOfDataObject");
        this._vertx.eventBus().request(this._address, (Object)_json, _deliveryOptions, res -> {
            if (res.failed()) {
                result.handle((Object)Future.failedFuture((Throwable)res.cause()));
            } else {
                result.handle((Object)Future.succeededFuture(((JsonArray)((Message)res.result()).body()).stream().map(v -> v != null ? new TestDataObject((JsonObject)v) : null).collect(Collectors.toList())));
            }
        });
        return this;
    }

    @Override
    public Service methodWithStringDataObject(StringDataObject data, Handler<AsyncResult<StringDataObject>> result) {
        if (this.closed) {
            result.handle((Object)Future.failedFuture((Throwable)new IllegalStateException("Proxy is closed")));
            return this;
        }
        JsonObject _json = new JsonObject();
        _json.put("data", (Object)(data != null ? data.toJson() : null));
        DeliveryOptions _deliveryOptions = this._options != null ? new DeliveryOptions(this._options) : new DeliveryOptions();
        _deliveryOptions.addHeader("action", "methodWithStringDataObject");
        _deliveryOptions.getHeaders().set("action", "methodWithStringDataObject");
        this._vertx.eventBus().request(this._address, (Object)_json, _deliveryOptions, res -> {
            if (res.failed()) {
                result.handle((Object)Future.failedFuture((Throwable)res.cause()));
            } else {
                result.handle((Object)Future.succeededFuture((Object)(((Message)res.result()).body() != null ? new StringDataObject((String)((Message)res.result()).body()) : null)));
            }
        });
        return this;
    }

    @Override
    public Service methodWithListOfStringDataObject(List<StringDataObject> list, Handler<AsyncResult<List<StringDataObject>>> result) {
        if (this.closed) {
            result.handle((Object)Future.failedFuture((Throwable)new IllegalStateException("Proxy is closed")));
            return this;
        }
        JsonObject _json = new JsonObject();
        _json.put("list", (Object)new JsonArray(list == null ? Collections.emptyList() : list.stream().map(v -> v != null ? v.toJson() : null).collect(Collectors.toList())));
        DeliveryOptions _deliveryOptions = this._options != null ? new DeliveryOptions(this._options) : new DeliveryOptions();
        _deliveryOptions.addHeader("action", "methodWithListOfStringDataObject");
        _deliveryOptions.getHeaders().set("action", "methodWithListOfStringDataObject");
        this._vertx.eventBus().request(this._address, (Object)_json, _deliveryOptions, res -> {
            if (res.failed()) {
                result.handle((Object)Future.failedFuture((Throwable)res.cause()));
            } else {
                result.handle((Object)Future.succeededFuture(((JsonArray)((Message)res.result()).body()).stream().map(v -> v != null ? new StringDataObject((String)v) : null).collect(Collectors.toList())));
            }
        });
        return this;
    }

    @Override
    public Service methodWithListOfJsonObject(List<JsonObject> list, Handler<AsyncResult<List<JsonObject>>> result) {
        if (this.closed) {
            result.handle((Object)Future.failedFuture((Throwable)new IllegalStateException("Proxy is closed")));
            return this;
        }
        JsonObject _json = new JsonObject();
        _json.put("list", (Object)new JsonArray(list));
        DeliveryOptions _deliveryOptions = this._options != null ? new DeliveryOptions(this._options) : new DeliveryOptions();
        _deliveryOptions.addHeader("action", "methodWithListOfJsonObject");
        _deliveryOptions.getHeaders().set("action", "methodWithListOfJsonObject");
        this._vertx.eventBus().request(this._address, (Object)_json, _deliveryOptions, res -> {
            if (res.failed()) {
                result.handle((Object)Future.failedFuture((Throwable)res.cause()));
            } else {
                result.handle((Object)Future.succeededFuture((Object)ProxyUtils.convertList((List)((JsonArray)((Message)res.result()).body()).getList())));
            }
        });
        return this;
    }

    @Override
    public Service methodWthFailingResult(String input, Handler<AsyncResult<JsonObject>> result) {
        if (this.closed) {
            result.handle((Object)Future.failedFuture((Throwable)new IllegalStateException("Proxy is closed")));
            return this;
        }
        JsonObject _json = new JsonObject();
        _json.put("input", (Object)input);
        DeliveryOptions _deliveryOptions = this._options != null ? new DeliveryOptions(this._options) : new DeliveryOptions();
        _deliveryOptions.addHeader("action", "methodWthFailingResult");
        _deliveryOptions.getHeaders().set("action", "methodWthFailingResult");
        this._vertx.eventBus().request(this._address, (Object)_json, _deliveryOptions, res -> {
            if (res.failed()) {
                result.handle((Object)Future.failedFuture((Throwable)res.cause()));
            } else {
                result.handle((Object)Future.succeededFuture((Object)((Message)res.result()).body()));
            }
        });
        return this;
    }
}

