/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.serviceproxy.clustered;

import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.eventbus.Message;
import io.vertx.core.eventbus.MessageCodec;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.serviceproxy.HelperUtils;
import io.vertx.serviceproxy.ProxyHandler;
import io.vertx.serviceproxy.ServiceException;
import io.vertx.serviceproxy.ServiceExceptionMessageCodec;
import io.vertx.serviceproxy.clustered.Service;
import io.vertx.serviceproxy.testmodel.Mappers;
import io.vertx.serviceproxy.testmodel.SomeEnum;
import io.vertx.serviceproxy.testmodel.SomeEnumWithCustomConstructor;
import io.vertx.serviceproxy.testmodel.SomeVertxEnum;
import io.vertx.serviceproxy.testmodel.StringDataObject;
import io.vertx.serviceproxy.testmodel.TestDataObject;
import java.util.List;
import java.util.stream.Collectors;

public class ServiceVertxProxyHandler
extends ProxyHandler {
    public static final long DEFAULT_CONNECTION_TIMEOUT = 300L;
    private final Vertx vertx;
    private final Service service;
    private final long timerID;
    private long lastAccessed;
    private final long timeoutSeconds;
    private final boolean includeDebugInfo;

    public ServiceVertxProxyHandler(Vertx vertx, Service service) {
        this(vertx, service, 300L);
    }

    public ServiceVertxProxyHandler(Vertx vertx, Service service, long timeoutInSecond) {
        this(vertx, service, true, timeoutInSecond);
    }

    public ServiceVertxProxyHandler(Vertx vertx, Service service, boolean topLevel, long timeoutInSecond) {
        this(vertx, service, true, timeoutInSecond, false);
    }

    public ServiceVertxProxyHandler(Vertx vertx, Service service, boolean topLevel, long timeoutSeconds, boolean includeDebugInfo) {
        this.vertx = vertx;
        this.service = service;
        this.includeDebugInfo = includeDebugInfo;
        this.timeoutSeconds = timeoutSeconds;
        try {
            this.vertx.eventBus().registerDefaultCodec(ServiceException.class, (MessageCodec)new ServiceExceptionMessageCodec());
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        if (timeoutSeconds != -1L && !topLevel) {
            long period = timeoutSeconds * 1000L / 2L;
            if (period > 10000L) {
                period = 10000L;
            }
            this.timerID = vertx.setPeriodic(period, this::checkTimedOut);
        } else {
            this.timerID = -1L;
        }
        this.accessed();
    }

    private void checkTimedOut(long id) {
        long now = System.nanoTime();
        if (now - this.lastAccessed > this.timeoutSeconds * 1000000000L) {
            this.close();
        }
    }

    public void close() {
        if (this.timerID != -1L) {
            this.vertx.cancelTimer(this.timerID);
        }
        super.close();
    }

    private void accessed() {
        this.lastAccessed = System.nanoTime();
    }

    public void handle(Message<JsonObject> msg) {
        try {
            JsonObject json = (JsonObject)msg.body();
            String action = msg.headers().get("action");
            if (action == null) {
                throw new IllegalStateException("action not specified");
            }
            this.accessed();
            switch (action) {
                case "hello": {
                    this.service.hello((String)json.getValue("name"), (Handler<AsyncResult<String>>)HelperUtils.createHandler(msg, (boolean)this.includeDebugInfo));
                    break;
                }
                case "methodUsingEnum": {
                    this.service.methodUsingEnum(json.getString("e") == null ? null : SomeEnum.valueOf(json.getString("e")), (Handler<AsyncResult<Boolean>>)HelperUtils.createHandler(msg, (boolean)this.includeDebugInfo));
                    break;
                }
                case "methodReturningEnum": {
                    this.service.methodReturningEnum((Handler<AsyncResult<SomeEnum>>)HelperUtils.createHandler(msg, (boolean)this.includeDebugInfo));
                    break;
                }
                case "methodReturningVertxEnum": {
                    this.service.methodReturningVertxEnum((Handler<AsyncResult<SomeVertxEnum>>)HelperUtils.createHandler(msg, (boolean)this.includeDebugInfo));
                    break;
                }
                case "methodUsingCustomEnum": {
                    this.service.methodUsingCustomEnum(json.getString("e") != null ? Mappers.deserializeSomeEnumWithCustomConstructor(json.getString("e")) : null, (Handler<AsyncResult<Boolean>>)HelperUtils.createHandler(msg, (boolean)this.includeDebugInfo));
                    break;
                }
                case "methodReturningCustomEnum": {
                    this.service.methodReturningCustomEnum((Handler<AsyncResult<SomeEnumWithCustomConstructor>>)((Handler)res -> {
                        if (res.failed()) {
                            HelperUtils.manageFailure((Message)msg, (Throwable)res.cause(), (boolean)this.includeDebugInfo);
                        } else {
                            msg.reply(res.result() != null ? Mappers.serializeSomeEnumWithCustomConstructor((SomeEnumWithCustomConstructor)((Object)((Object)res.result()))) : null);
                        }
                    }));
                    break;
                }
                case "methodWithJsonObject": {
                    this.service.methodWithJsonObject((JsonObject)json.getValue("json"), (Handler<AsyncResult<JsonObject>>)HelperUtils.createHandler(msg, (boolean)this.includeDebugInfo));
                    break;
                }
                case "methodWithJsonArray": {
                    this.service.methodWithJsonArray((JsonArray)json.getValue("json"), (Handler<AsyncResult<JsonArray>>)HelperUtils.createHandler(msg, (boolean)this.includeDebugInfo));
                    break;
                }
                case "methodWithList": {
                    this.service.methodWithList(HelperUtils.convertList((List)json.getJsonArray("list").getList()), (Handler<AsyncResult<List<String>>>)HelperUtils.createListHandler(msg, (boolean)this.includeDebugInfo));
                    break;
                }
                case "methodWithDataObject": {
                    this.service.methodWithDataObject(json.getJsonObject("data") != null ? new TestDataObject(json.getJsonObject("data")) : null, (Handler<AsyncResult<TestDataObject>>)((Handler)res -> {
                        if (res.failed()) {
                            HelperUtils.manageFailure((Message)msg, (Throwable)res.cause(), (boolean)this.includeDebugInfo);
                        } else {
                            msg.reply(res.result() != null ? ((TestDataObject)res.result()).toJson() : null);
                        }
                    }));
                    break;
                }
                case "methodWithListOfDataObject": {
                    this.service.methodWithListOfDataObject(json.getJsonArray("list").stream().map(v -> v != null ? new TestDataObject((JsonObject)v) : null).collect(Collectors.toList()), (Handler<AsyncResult<List<TestDataObject>>>)((Handler)res -> {
                        if (res.failed()) {
                            HelperUtils.manageFailure((Message)msg, (Throwable)res.cause(), (boolean)this.includeDebugInfo);
                        } else {
                            msg.reply((Object)new JsonArray(((List)res.result()).stream().map(v -> v != null ? v.toJson() : null).collect(Collectors.toList())));
                        }
                    }));
                    break;
                }
                case "methodWithStringDataObject": {
                    this.service.methodWithStringDataObject(json.getValue("data") != null ? new StringDataObject((String)json.getValue("data")) : null, (Handler<AsyncResult<StringDataObject>>)((Handler)res -> {
                        if (res.failed()) {
                            HelperUtils.manageFailure((Message)msg, (Throwable)res.cause(), (boolean)this.includeDebugInfo);
                        } else {
                            msg.reply(res.result() != null ? ((StringDataObject)res.result()).toJson() : null);
                        }
                    }));
                    break;
                }
                case "methodWithListOfStringDataObject": {
                    this.service.methodWithListOfStringDataObject(json.getJsonArray("list").stream().map(v -> v != null ? new StringDataObject((String)v) : null).collect(Collectors.toList()), (Handler<AsyncResult<List<StringDataObject>>>)((Handler)res -> {
                        if (res.failed()) {
                            HelperUtils.manageFailure((Message)msg, (Throwable)res.cause(), (boolean)this.includeDebugInfo);
                        } else {
                            msg.reply((Object)new JsonArray(((List)res.result()).stream().map(v -> v != null ? v.toJson() : null).collect(Collectors.toList())));
                        }
                    }));
                    break;
                }
                case "methodWithListOfJsonObject": {
                    this.service.methodWithListOfJsonObject(HelperUtils.convertList((List)json.getJsonArray("list").getList()), (Handler<AsyncResult<List<JsonObject>>>)HelperUtils.createListHandler(msg, (boolean)this.includeDebugInfo));
                    break;
                }
                case "methodWthFailingResult": {
                    this.service.methodWthFailingResult((String)json.getValue("input"), (Handler<AsyncResult<JsonObject>>)HelperUtils.createHandler(msg, (boolean)this.includeDebugInfo));
                    break;
                }
                default: {
                    throw new IllegalStateException("Invalid action: " + action);
                }
            }
        }
        catch (Throwable t) {
            if (this.includeDebugInfo) {
                msg.reply((Object)new ServiceException(500, t.getMessage(), HelperUtils.generateDebugInfo((Throwable)t)));
            } else {
                msg.reply((Object)new ServiceException(500, t.getMessage()));
            }
            throw t;
        }
    }
}

