/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.serviceproxy.codegen;

import io.vertx.codegen.GenException;
import io.vertx.codegen.MethodInfo;
import io.vertx.codegen.MethodKind;
import io.vertx.codegen.ParamInfo;
import io.vertx.codegen.type.ClassKind;
import io.vertx.codegen.type.ParameterizedTypeInfo;
import io.vertx.codegen.type.TypeInfo;
import io.vertx.serviceproxy.codegen.future.FuturizedProxy;
import io.vertx.serviceproxy.codegen.proxytestapi.InvalidClose1;
import io.vertx.serviceproxy.codegen.proxytestapi.InvalidClose2;
import io.vertx.serviceproxy.codegen.proxytestapi.InvalidClose3;
import io.vertx.serviceproxy.codegen.proxytestapi.InvalidOverloaded;
import io.vertx.serviceproxy.codegen.proxytestapi.InvalidParams1;
import io.vertx.serviceproxy.codegen.proxytestapi.InvalidParams2;
import io.vertx.serviceproxy.codegen.proxytestapi.InvalidParams3;
import io.vertx.serviceproxy.codegen.proxytestapi.InvalidParams4;
import io.vertx.serviceproxy.codegen.proxytestapi.InvalidParamsDataObject;
import io.vertx.serviceproxy.codegen.proxytestapi.InvalidReturn1;
import io.vertx.serviceproxy.codegen.proxytestapi.InvalidReturn2;
import io.vertx.serviceproxy.codegen.proxytestapi.InvalidReturn3;
import io.vertx.serviceproxy.codegen.proxytestapi.ValidProxy;
import io.vertx.serviceproxy.codegen.proxytestapi.ValidProxyCloseWithFuture;
import io.vertx.serviceproxy.generator.model.ProxyMethodInfo;
import io.vertx.serviceproxy.generator.model.ProxyModel;
import io.vertx.serviceproxy.testmodel.Mappers;
import io.vertx.test.codegen.GeneratorHelper;
import java.time.ZonedDateTime;
import org.junit.Assert;
import org.junit.Test;

public class ProxyTest {
    public ProxyModel generateProxyModel(Class c, Class ... rest) throws Exception {
        return (ProxyModel)new GeneratorHelper().registerConverter(ZonedDateTime.class, Mappers.class, new String[]{"serializeZonedDateTime"}).registerConverter(ZonedDateTime.class, Mappers.class, new String[]{"deserializeZonedDateTime"}).generateClass(codegen -> (ProxyModel)codegen.getModel(c.getCanonicalName(), "proxy"), c, rest);
    }

    @Test
    public void testInvalidOverloaded() throws Exception {
        try {
            this.generateProxyModel(InvalidOverloaded.class, new Class[0]);
            Assert.fail((String)"Should throw exception");
        }
        catch (GenException genException) {
            // empty catch block
        }
    }

    @Test
    public void testInvalidParams1() throws Exception {
        try {
            this.generateProxyModel(InvalidParams1.class, new Class[0]);
            Assert.fail((String)"Should throw exception");
        }
        catch (GenException genException) {
            // empty catch block
        }
    }

    @Test
    public void testInvalidParams2() throws Exception {
        try {
            this.generateProxyModel(InvalidParams2.class, new Class[0]);
            Assert.fail((String)"Should throw exception");
        }
        catch (GenException genException) {
            // empty catch block
        }
    }

    @Test
    public void testInvalidParams3() throws Exception {
        try {
            this.generateProxyModel(InvalidParams3.class, new Class[0]);
            Assert.fail((String)"Should throw exception");
        }
        catch (GenException genException) {
            // empty catch block
        }
    }

    @Test
    public void testInvalidParams4() throws Exception {
        try {
            this.generateProxyModel(InvalidParams4.class, new Class[0]);
            Assert.fail((String)"Should throw exception");
        }
        catch (GenException genException) {
            // empty catch block
        }
    }

    @Test
    public void testInvalidParamsDataObject() throws Exception {
        try {
            this.generateProxyModel(InvalidParamsDataObject.class, new Class[0]);
            Assert.fail((String)"Should throw exception");
        }
        catch (GenException genException) {
            // empty catch block
        }
    }

    @Test
    public void testInvalidReturn1() throws Exception {
        try {
            this.generateProxyModel(InvalidReturn1.class, new Class[0]);
            Assert.fail((String)"Should throw exception");
        }
        catch (GenException genException) {
            // empty catch block
        }
    }

    @Test
    public void testInvalidReturn2() throws Exception {
        try {
            this.generateProxyModel(InvalidReturn2.class, new Class[0]);
            Assert.fail((String)"Should throw exception");
        }
        catch (GenException genException) {
            // empty catch block
        }
    }

    @Test
    public void testInvalidReturn3() throws Exception {
        try {
            this.generateProxyModel(InvalidReturn3.class, new Class[0]);
            Assert.fail((String)"Should throw exception");
        }
        catch (GenException genException) {
            // empty catch block
        }
    }

    @Test
    public void testValid() throws Exception {
        ProxyModel model = this.generateProxyModel(ValidProxy.class, new Class[0]);
        Assert.assertEquals((Object)ValidProxy.class.getName(), (Object)model.getIfaceFQCN());
        Assert.assertEquals((Object)ValidProxy.class.getSimpleName(), (Object)model.getIfaceSimpleName());
        Assert.assertTrue((boolean)model.getSuperTypes().isEmpty());
        Assert.assertEquals((long)52L, (long)model.getMethods().size());
        for (MethodInfo mi : model.getMethods()) {
            ProxyMethodInfo pmi = (ProxyMethodInfo)mi;
            if (pmi.getName().equals("ignored")) {
                Assert.assertTrue((boolean)pmi.isProxyIgnore());
            } else {
                Assert.assertFalse((boolean)pmi.isProxyIgnore());
            }
            if (pmi.getName().equals("closeIt")) {
                Assert.assertTrue((boolean)pmi.isProxyClose());
                continue;
            }
            Assert.assertFalse((boolean)pmi.isProxyClose());
        }
    }

    @Test
    public void testValidCloseWithFuture() throws Exception {
        ProxyModel model = this.generateProxyModel(ValidProxyCloseWithFuture.class, new Class[0]);
        Assert.assertEquals((long)1L, (long)model.getMethods().size());
        Assert.assertEquals((Object)MethodKind.CALLBACK, (Object)((MethodInfo)model.getMethods().get(0)).getKind());
        ParameterizedTypeInfo handlerType = (ParameterizedTypeInfo)((ParamInfo)((MethodInfo)model.getMethods().get(0)).getParams().get(0)).getType();
        ParameterizedTypeInfo asyncResultType = (ParameterizedTypeInfo)handlerType.getArgs().get(0);
        Assert.assertEquals((Object)ClassKind.VOID, (Object)((TypeInfo)asyncResultType.getArgs().get(0)).getKind());
    }

    @Test
    public void testInvalidClose1() throws Exception {
        try {
            this.generateProxyModel(InvalidClose1.class, new Class[0]);
            Assert.fail((String)"Should throw exception");
        }
        catch (GenException genException) {
            // empty catch block
        }
    }

    @Test
    public void testInvalidClose2() throws Exception {
        try {
            this.generateProxyModel(InvalidClose2.class, new Class[0]);
            Assert.fail((String)"Should throw exception");
        }
        catch (GenException genException) {
            // empty catch block
        }
    }

    @Test
    public void testInvalidClose3() throws Exception {
        try {
            this.generateProxyModel(InvalidClose3.class, new Class[0]);
            Assert.fail((String)"Should throw exception");
        }
        catch (GenException genException) {
            // empty catch block
        }
    }

    @Test
    public void testValidFuture() throws Exception {
        ProxyModel model = this.generateProxyModel(FuturizedProxy.class, new Class[0]);
    }
}

