/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.serviceproxy.test;

import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.eventbus.MessageConsumer;
import io.vertx.core.eventbus.ReplyException;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.auth.KeyStoreOptions;
import io.vertx.ext.auth.authentication.AuthenticationProvider;
import io.vertx.ext.auth.authorization.Authorization;
import io.vertx.ext.auth.authorization.AuthorizationProvider;
import io.vertx.ext.auth.authorization.PermissionBasedAuthorization;
import io.vertx.ext.auth.jwt.JWTAuth;
import io.vertx.ext.auth.jwt.JWTAuthOptions;
import io.vertx.ext.auth.jwt.authorization.JWTAuthorization;
import io.vertx.serviceproxy.AuthenticationInterceptor;
import io.vertx.serviceproxy.AuthorizationInterceptor;
import io.vertx.serviceproxy.ServiceBinder;
import io.vertx.serviceproxy.ServiceInterceptor;
import io.vertx.serviceproxy.ServiceProxyBuilder;
import io.vertx.serviceproxy.testmodel.OKService;
import io.vertx.serviceproxy.testmodel.OKServiceImpl;
import io.vertx.test.core.VertxTestBase;
import org.junit.Test;

public class SecureServiceBinderTest
extends VertxTestBase {
    private static final String SERVICE_ADDRESS = "someaddress";
    private static final String SERVICE_LOCAL_ADDRESS = "someaddress.local";
    private static final String JWT_VALID_TOKEN = "eyJ0eXAiOiJKV1QiLCJhbGciOiJIUzI1NiJ9.eyJzdWIiOiJQYXVsbyIsImV4cCI6MTc0NzA1NTMxMywiaWF0IjoxNDMxNjk1MzEzLCJwZXJtaXNzaW9ucyI6WyJyZWFkIiwid3JpdGUiLCJleGVjdXRlIl0sInJvbGVzIjpbImFkbWluIiwiZGV2ZWxvcGVyIiwidXNlciJdfQ.UdA6oYDn9s_k7uogFFg8jvKmq9RgITBnlq4xV6JGsCY";
    private ServiceProxyBuilder serviceProxyBuilder;
    private ServiceProxyBuilder localServiceProxyBuilder;
    private MessageConsumer<JsonObject> consumer;
    private MessageConsumer<JsonObject> localConsumer;
    private OKService proxy;
    private OKService localProxy;

    private JWTAuthOptions getJWTConfig() {
        return new JWTAuthOptions().setKeyStore(new KeyStoreOptions().setPath("keystore.jceks").setType("jceks").setPassword("secret"));
    }

    public void setUp() throws Exception {
        super.setUp();
        OKServiceImpl service = new OKServiceImpl();
        ServiceBinder serviceBinder = new ServiceBinder(this.vertx).setAddress(SERVICE_ADDRESS).addInterceptor((ServiceInterceptor)AuthenticationInterceptor.create((AuthenticationProvider)JWTAuth.create((Vertx)this.vertx, (JWTAuthOptions)this.getJWTConfig()))).addInterceptor((ServiceInterceptor)AuthorizationInterceptor.create((AuthorizationProvider)JWTAuthorization.create((String)"roles")).addAuthorization((Authorization)PermissionBasedAuthorization.create((String)"admin"))).addInterceptor((ServiceInterceptor)AuthorizationInterceptor.create((AuthorizationProvider)JWTAuthorization.create((String)"permissions")).addAuthorization((Authorization)PermissionBasedAuthorization.create((String)"write")));
        ServiceBinder localServiceBinder = new ServiceBinder(this.vertx).setAddress(SERVICE_LOCAL_ADDRESS).addInterceptor((ServiceInterceptor)AuthenticationInterceptor.create((AuthenticationProvider)JWTAuth.create((Vertx)this.vertx, (JWTAuthOptions)this.getJWTConfig()))).addInterceptor((ServiceInterceptor)AuthorizationInterceptor.create((AuthorizationProvider)JWTAuthorization.create((String)"roles")).addAuthorization((Authorization)PermissionBasedAuthorization.create((String)"admin"))).addInterceptor((ServiceInterceptor)AuthorizationInterceptor.create((AuthorizationProvider)JWTAuthorization.create((String)"permissions")).addAuthorization((Authorization)PermissionBasedAuthorization.create((String)"write")));
        this.consumer = serviceBinder.register(OKService.class, (Object)service);
        this.localConsumer = localServiceBinder.registerLocal(OKService.class, (Object)service);
        this.serviceProxyBuilder = new ServiceProxyBuilder(this.vertx).setAddress(SERVICE_ADDRESS);
        this.localServiceProxyBuilder = new ServiceProxyBuilder(this.vertx).setAddress(SERVICE_LOCAL_ADDRESS);
    }

    public void tearDown() throws Exception {
        this.consumer.unregister();
        this.localConsumer.unregister();
        super.tearDown();
    }

    @Test
    public void testWithToken() {
        this.serviceProxyBuilder.setToken(JWT_VALID_TOKEN);
        this.proxy = (OKService)this.serviceProxyBuilder.build(OKService.class);
        this.proxy.ok((Handler<AsyncResult<String>>)((Handler)res -> {
            this.assertFalse(res.failed());
            this.testComplete();
        }));
        this.await();
    }

    @Test
    public void testWithoutToken() {
        this.serviceProxyBuilder.setToken(null);
        this.proxy = (OKService)this.serviceProxyBuilder.build(OKService.class);
        this.proxy.ok((Handler<AsyncResult<String>>)((Handler)this::checkResult));
        this.await();
    }

    @Test
    public void testLocalWithToken() {
        this.localServiceProxyBuilder.setToken(JWT_VALID_TOKEN);
        this.localProxy = (OKService)this.localServiceProxyBuilder.build(OKService.class);
        this.localProxy.ok((Handler<AsyncResult<String>>)((Handler)res -> {
            this.assertFalse(res.failed());
            this.testComplete();
        }));
        this.await();
    }

    @Test
    public void testLocalWithoutToken() {
        this.localServiceProxyBuilder.setToken(null);
        this.localProxy = (OKService)this.localServiceProxyBuilder.build(OKService.class);
        this.localProxy.ok((Handler<AsyncResult<String>>)((Handler)this::checkResult));
        this.await();
    }

    private void checkResult(AsyncResult<String> res) {
        this.assertTrue(res.failed());
        ReplyException t = (ReplyException)res.cause();
        this.assertEquals(401L, t.failureCode());
        this.testComplete();
    }
}

