/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.serviceproxy.testmodel;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.eventbus.DeliveryOptions;
import io.vertx.core.eventbus.Message;
import io.vertx.core.eventbus.MessageCodec;
import io.vertx.core.json.JsonObject;
import io.vertx.serviceproxy.ServiceException;
import io.vertx.serviceproxy.ServiceExceptionMessageCodec;
import io.vertx.serviceproxy.testmodel.TestConnection;

public class TestConnectionVertxEBProxy
implements TestConnection {
    private Vertx _vertx;
    private String _address;
    private DeliveryOptions _options;
    private boolean closed;

    public TestConnectionVertxEBProxy(Vertx vertx, String address) {
        this(vertx, address, null);
    }

    public TestConnectionVertxEBProxy(Vertx vertx, String address, DeliveryOptions options) {
        this._vertx = vertx;
        this._address = address;
        this._options = options;
        try {
            this._vertx.eventBus().registerDefaultCodec(ServiceException.class, (MessageCodec)new ServiceExceptionMessageCodec());
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Override
    public TestConnection startTransaction(Handler<AsyncResult<String>> resultHandler) {
        if (this.closed) {
            resultHandler.handle((Object)Future.failedFuture((Throwable)new IllegalStateException("Proxy is closed")));
            return this;
        }
        JsonObject _json = new JsonObject();
        DeliveryOptions _deliveryOptions = this._options != null ? new DeliveryOptions(this._options) : new DeliveryOptions();
        _deliveryOptions.addHeader("action", "startTransaction");
        _deliveryOptions.getHeaders().set("action", "startTransaction");
        this._vertx.eventBus().request(this._address, (Object)_json, _deliveryOptions, res -> {
            if (res.failed()) {
                resultHandler.handle((Object)Future.failedFuture((Throwable)res.cause()));
            } else {
                resultHandler.handle((Object)Future.succeededFuture((Object)((Message)res.result()).body()));
            }
        });
        return this;
    }

    @Override
    public TestConnection insert(String name, JsonObject data, Handler<AsyncResult<String>> resultHandler) {
        if (this.closed) {
            resultHandler.handle((Object)Future.failedFuture((Throwable)new IllegalStateException("Proxy is closed")));
            return this;
        }
        JsonObject _json = new JsonObject();
        _json.put("name", (Object)name);
        _json.put("data", (Object)data);
        DeliveryOptions _deliveryOptions = this._options != null ? new DeliveryOptions(this._options) : new DeliveryOptions();
        _deliveryOptions.addHeader("action", "insert");
        _deliveryOptions.getHeaders().set("action", "insert");
        this._vertx.eventBus().request(this._address, (Object)_json, _deliveryOptions, res -> {
            if (res.failed()) {
                resultHandler.handle((Object)Future.failedFuture((Throwable)res.cause()));
            } else {
                resultHandler.handle((Object)Future.succeededFuture((Object)((Message)res.result()).body()));
            }
        });
        return this;
    }

    @Override
    public TestConnection commit(Handler<AsyncResult<String>> resultHandler) {
        if (this.closed) {
            resultHandler.handle((Object)Future.failedFuture((Throwable)new IllegalStateException("Proxy is closed")));
            return this;
        }
        JsonObject _json = new JsonObject();
        DeliveryOptions _deliveryOptions = this._options != null ? new DeliveryOptions(this._options) : new DeliveryOptions();
        _deliveryOptions.addHeader("action", "commit");
        _deliveryOptions.getHeaders().set("action", "commit");
        this._vertx.eventBus().request(this._address, (Object)_json, _deliveryOptions, res -> {
            if (res.failed()) {
                resultHandler.handle((Object)Future.failedFuture((Throwable)res.cause()));
            } else {
                resultHandler.handle((Object)Future.succeededFuture((Object)((Message)res.result()).body()));
            }
        });
        return this;
    }

    @Override
    public TestConnection rollback(Handler<AsyncResult<String>> resultHandler) {
        if (this.closed) {
            resultHandler.handle((Object)Future.failedFuture((Throwable)new IllegalStateException("Proxy is closed")));
            return this;
        }
        JsonObject _json = new JsonObject();
        DeliveryOptions _deliveryOptions = this._options != null ? new DeliveryOptions(this._options) : new DeliveryOptions();
        _deliveryOptions.addHeader("action", "rollback");
        _deliveryOptions.getHeaders().set("action", "rollback");
        this._vertx.eventBus().request(this._address, (Object)_json, _deliveryOptions, res -> {
            if (res.failed()) {
                resultHandler.handle((Object)Future.failedFuture((Throwable)res.cause()));
            } else {
                resultHandler.handle((Object)Future.succeededFuture((Object)((Message)res.result()).body()));
            }
        });
        return this;
    }

    @Override
    public void close() {
        if (this.closed) {
            throw new IllegalStateException("Proxy is closed");
        }
        this.closed = true;
        JsonObject _json = new JsonObject();
        DeliveryOptions _deliveryOptions = this._options != null ? new DeliveryOptions(this._options) : new DeliveryOptions();
        _deliveryOptions.addHeader("action", "close");
        _deliveryOptions.getHeaders().set("action", "close");
        this._vertx.eventBus().send(this._address, (Object)_json, _deliveryOptions);
    }
}

