/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.serviceproxy.testmodel;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.eventbus.DeliveryOptions;
import io.vertx.core.eventbus.Message;
import io.vertx.core.eventbus.MessageCodec;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.serviceproxy.ProxyUtils;
import io.vertx.serviceproxy.ServiceException;
import io.vertx.serviceproxy.ServiceExceptionMessageCodec;
import io.vertx.serviceproxy.testmodel.Mappers;
import io.vertx.serviceproxy.testmodel.SomeEnum;
import io.vertx.serviceproxy.testmodel.SomeEnumWithCustomConstructor;
import io.vertx.serviceproxy.testmodel.TestConnection;
import io.vertx.serviceproxy.testmodel.TestConnectionVertxEBProxy;
import io.vertx.serviceproxy.testmodel.TestDataObject;
import io.vertx.serviceproxy.testmodel.TestService;
import io.vertx.serviceproxy.testmodel.sub.TestSubConnection;
import io.vertx.serviceproxy.testmodel.sub.TestSubConnectionVertxEBProxy;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class TestServiceVertxEBProxy
implements TestService {
    private Vertx _vertx;
    private String _address;
    private DeliveryOptions _options;
    private boolean closed;

    public TestServiceVertxEBProxy(Vertx vertx, String address) {
        this(vertx, address, null);
    }

    public TestServiceVertxEBProxy(Vertx vertx, String address, DeliveryOptions options) {
        this._vertx = vertx;
        this._address = address;
        this._options = options;
        try {
            this._vertx.eventBus().registerDefaultCodec(ServiceException.class, (MessageCodec)new ServiceExceptionMessageCodec());
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Override
    public void longDeliverySuccess(Handler<AsyncResult<String>> resultHandler) {
        if (this.closed) {
            resultHandler.handle((Object)Future.failedFuture((Throwable)new IllegalStateException("Proxy is closed")));
            return;
        }
        JsonObject _json = new JsonObject();
        DeliveryOptions _deliveryOptions = this._options != null ? new DeliveryOptions(this._options) : new DeliveryOptions();
        _deliveryOptions.addHeader("action", "longDeliverySuccess");
        _deliveryOptions.getHeaders().set("action", "longDeliverySuccess");
        this._vertx.eventBus().request(this._address, (Object)_json, _deliveryOptions, res -> {
            if (res.failed()) {
                resultHandler.handle((Object)Future.failedFuture((Throwable)res.cause()));
            } else {
                resultHandler.handle((Object)Future.succeededFuture((Object)((Message)res.result()).body()));
            }
        });
    }

    @Override
    public void longDeliveryFailed(Handler<AsyncResult<String>> resultHandler) {
        if (this.closed) {
            resultHandler.handle((Object)Future.failedFuture((Throwable)new IllegalStateException("Proxy is closed")));
            return;
        }
        JsonObject _json = new JsonObject();
        DeliveryOptions _deliveryOptions = this._options != null ? new DeliveryOptions(this._options) : new DeliveryOptions();
        _deliveryOptions.addHeader("action", "longDeliveryFailed");
        _deliveryOptions.getHeaders().set("action", "longDeliveryFailed");
        this._vertx.eventBus().request(this._address, (Object)_json, _deliveryOptions, res -> {
            if (res.failed()) {
                resultHandler.handle((Object)Future.failedFuture((Throwable)res.cause()));
            } else {
                resultHandler.handle((Object)Future.succeededFuture((Object)((Message)res.result()).body()));
            }
        });
    }

    @Override
    public void createConnection(String str, Handler<AsyncResult<TestConnection>> resultHandler) {
        if (this.closed) {
            resultHandler.handle((Object)Future.failedFuture((Throwable)new IllegalStateException("Proxy is closed")));
            return;
        }
        JsonObject _json = new JsonObject();
        _json.put("str", (Object)str);
        DeliveryOptions _deliveryOptions = this._options != null ? new DeliveryOptions(this._options) : new DeliveryOptions();
        _deliveryOptions.addHeader("action", "createConnection");
        _deliveryOptions.getHeaders().set("action", "createConnection");
        this._vertx.eventBus().request(this._address, (Object)_json, _deliveryOptions, res -> {
            if (res.failed()) {
                resultHandler.handle((Object)Future.failedFuture((Throwable)res.cause()));
            } else {
                resultHandler.handle((Object)Future.succeededFuture((Object)new TestConnectionVertxEBProxy(this._vertx, ((Message)res.result()).headers().get("proxyaddr"))));
            }
        });
    }

    @Override
    public void createSubConnection(String str, Handler<AsyncResult<TestSubConnection>> resultHandler) {
        if (this.closed) {
            resultHandler.handle((Object)Future.failedFuture((Throwable)new IllegalStateException("Proxy is closed")));
            return;
        }
        JsonObject _json = new JsonObject();
        _json.put("str", (Object)str);
        DeliveryOptions _deliveryOptions = this._options != null ? new DeliveryOptions(this._options) : new DeliveryOptions();
        _deliveryOptions.addHeader("action", "createSubConnection");
        _deliveryOptions.getHeaders().set("action", "createSubConnection");
        this._vertx.eventBus().request(this._address, (Object)_json, _deliveryOptions, res -> {
            if (res.failed()) {
                resultHandler.handle((Object)Future.failedFuture((Throwable)res.cause()));
            } else {
                resultHandler.handle((Object)Future.succeededFuture((Object)new TestSubConnectionVertxEBProxy(this._vertx, ((Message)res.result()).headers().get("proxyaddr"))));
            }
        });
    }

    @Override
    public void noParams() {
        if (this.closed) {
            throw new IllegalStateException("Proxy is closed");
        }
        JsonObject _json = new JsonObject();
        DeliveryOptions _deliveryOptions = this._options != null ? new DeliveryOptions(this._options) : new DeliveryOptions();
        _deliveryOptions.addHeader("action", "noParams");
        _deliveryOptions.getHeaders().set("action", "noParams");
        this._vertx.eventBus().send(this._address, (Object)_json, _deliveryOptions);
    }

    @Override
    public void basicTypes(String str, byte b, short s, int i, long l, float f, double d, char c, boolean bool) {
        if (this.closed) {
            throw new IllegalStateException("Proxy is closed");
        }
        JsonObject _json = new JsonObject();
        _json.put("str", (Object)str);
        _json.put("b", (Object)b);
        _json.put("s", (Object)s);
        _json.put("i", (Object)i);
        _json.put("l", (Object)l);
        _json.put("f", (Object)Float.valueOf(f));
        _json.put("d", (Object)d);
        _json.put("c", (Object)c);
        _json.put("bool", (Object)bool);
        DeliveryOptions _deliveryOptions = this._options != null ? new DeliveryOptions(this._options) : new DeliveryOptions();
        _deliveryOptions.addHeader("action", "basicTypes");
        _deliveryOptions.getHeaders().set("action", "basicTypes");
        this._vertx.eventBus().send(this._address, (Object)_json, _deliveryOptions);
    }

    @Override
    public void basicBoxedTypes(String str, Byte b, Short s, Integer i, Long l, Float f, Double d, Character c, Boolean bool) {
        if (this.closed) {
            throw new IllegalStateException("Proxy is closed");
        }
        JsonObject _json = new JsonObject();
        _json.put("str", (Object)str);
        _json.put("b", (Object)b);
        _json.put("s", (Object)s);
        _json.put("i", (Object)i);
        _json.put("l", (Object)l);
        _json.put("f", (Object)f);
        _json.put("d", (Object)d);
        _json.put("c", c == null ? null : Integer.valueOf(c.charValue()));
        _json.put("bool", (Object)bool);
        DeliveryOptions _deliveryOptions = this._options != null ? new DeliveryOptions(this._options) : new DeliveryOptions();
        _deliveryOptions.addHeader("action", "basicBoxedTypes");
        _deliveryOptions.getHeaders().set("action", "basicBoxedTypes");
        this._vertx.eventBus().send(this._address, (Object)_json, _deliveryOptions);
    }

    @Override
    public void basicBoxedTypesNull(String str, Byte b, Short s, Integer i, Long l, Float f, Double d, Character c, Boolean bool) {
        if (this.closed) {
            throw new IllegalStateException("Proxy is closed");
        }
        JsonObject _json = new JsonObject();
        _json.put("str", (Object)str);
        _json.put("b", (Object)b);
        _json.put("s", (Object)s);
        _json.put("i", (Object)i);
        _json.put("l", (Object)l);
        _json.put("f", (Object)f);
        _json.put("d", (Object)d);
        _json.put("c", c == null ? null : Integer.valueOf(c.charValue()));
        _json.put("bool", (Object)bool);
        DeliveryOptions _deliveryOptions = this._options != null ? new DeliveryOptions(this._options) : new DeliveryOptions();
        _deliveryOptions.addHeader("action", "basicBoxedTypesNull");
        _deliveryOptions.getHeaders().set("action", "basicBoxedTypesNull");
        this._vertx.eventBus().send(this._address, (Object)_json, _deliveryOptions);
    }

    @Override
    public void jsonTypes(JsonObject jsonObject, JsonArray jsonArray) {
        if (this.closed) {
            throw new IllegalStateException("Proxy is closed");
        }
        JsonObject _json = new JsonObject();
        _json.put("jsonObject", (Object)jsonObject);
        _json.put("jsonArray", (Object)jsonArray);
        DeliveryOptions _deliveryOptions = this._options != null ? new DeliveryOptions(this._options) : new DeliveryOptions();
        _deliveryOptions.addHeader("action", "jsonTypes");
        _deliveryOptions.getHeaders().set("action", "jsonTypes");
        this._vertx.eventBus().send(this._address, (Object)_json, _deliveryOptions);
    }

    @Override
    public void jsonTypesNull(JsonObject jsonObject, JsonArray jsonArray) {
        if (this.closed) {
            throw new IllegalStateException("Proxy is closed");
        }
        JsonObject _json = new JsonObject();
        _json.put("jsonObject", (Object)jsonObject);
        _json.put("jsonArray", (Object)jsonArray);
        DeliveryOptions _deliveryOptions = this._options != null ? new DeliveryOptions(this._options) : new DeliveryOptions();
        _deliveryOptions.addHeader("action", "jsonTypesNull");
        _deliveryOptions.getHeaders().set("action", "jsonTypesNull");
        this._vertx.eventBus().send(this._address, (Object)_json, _deliveryOptions);
    }

    @Override
    public void enumType(SomeEnum someEnum) {
        if (this.closed) {
            throw new IllegalStateException("Proxy is closed");
        }
        JsonObject _json = new JsonObject();
        _json.put("someEnum", (Object)(someEnum == null ? null : someEnum.name()));
        DeliveryOptions _deliveryOptions = this._options != null ? new DeliveryOptions(this._options) : new DeliveryOptions();
        _deliveryOptions.addHeader("action", "enumType");
        _deliveryOptions.getHeaders().set("action", "enumType");
        this._vertx.eventBus().send(this._address, (Object)_json, _deliveryOptions);
    }

    @Override
    public void enumTypeNull(SomeEnum someEnum) {
        if (this.closed) {
            throw new IllegalStateException("Proxy is closed");
        }
        JsonObject _json = new JsonObject();
        _json.put("someEnum", (Object)(someEnum == null ? null : someEnum.name()));
        DeliveryOptions _deliveryOptions = this._options != null ? new DeliveryOptions(this._options) : new DeliveryOptions();
        _deliveryOptions.addHeader("action", "enumTypeNull");
        _deliveryOptions.getHeaders().set("action", "enumTypeNull");
        this._vertx.eventBus().send(this._address, (Object)_json, _deliveryOptions);
    }

    @Override
    public void enumTypeAsResult(Handler<AsyncResult<SomeEnum>> someEnum) {
        if (this.closed) {
            someEnum.handle((Object)Future.failedFuture((Throwable)new IllegalStateException("Proxy is closed")));
            return;
        }
        JsonObject _json = new JsonObject();
        DeliveryOptions _deliveryOptions = this._options != null ? new DeliveryOptions(this._options) : new DeliveryOptions();
        _deliveryOptions.addHeader("action", "enumTypeAsResult");
        _deliveryOptions.getHeaders().set("action", "enumTypeAsResult");
        this._vertx.eventBus().request(this._address, (Object)_json, _deliveryOptions, res -> {
            if (res.failed()) {
                someEnum.handle((Object)Future.failedFuture((Throwable)res.cause()));
            } else {
                someEnum.handle((Object)Future.succeededFuture(((Message)res.result()).body() == null ? null : SomeEnum.valueOf((String)((Message)res.result()).body())));
            }
        });
    }

    @Override
    public void enumTypeAsResultNull(Handler<AsyncResult<SomeEnum>> someEnum) {
        if (this.closed) {
            someEnum.handle((Object)Future.failedFuture((Throwable)new IllegalStateException("Proxy is closed")));
            return;
        }
        JsonObject _json = new JsonObject();
        DeliveryOptions _deliveryOptions = this._options != null ? new DeliveryOptions(this._options) : new DeliveryOptions();
        _deliveryOptions.addHeader("action", "enumTypeAsResultNull");
        _deliveryOptions.getHeaders().set("action", "enumTypeAsResultNull");
        this._vertx.eventBus().request(this._address, (Object)_json, _deliveryOptions, res -> {
            if (res.failed()) {
                someEnum.handle((Object)Future.failedFuture((Throwable)res.cause()));
            } else {
                someEnum.handle((Object)Future.succeededFuture(((Message)res.result()).body() == null ? null : SomeEnum.valueOf((String)((Message)res.result()).body())));
            }
        });
    }

    @Override
    public void enumCustomType(SomeEnumWithCustomConstructor someEnum) {
        if (this.closed) {
            throw new IllegalStateException("Proxy is closed");
        }
        JsonObject _json = new JsonObject();
        _json.put("someEnum", (Object)(someEnum != null ? Mappers.serializeSomeEnumWithCustomConstructor(someEnum) : null));
        DeliveryOptions _deliveryOptions = this._options != null ? new DeliveryOptions(this._options) : new DeliveryOptions();
        _deliveryOptions.addHeader("action", "enumCustomType");
        _deliveryOptions.getHeaders().set("action", "enumCustomType");
        this._vertx.eventBus().send(this._address, (Object)_json, _deliveryOptions);
    }

    @Override
    public void enumCustomTypeNull(SomeEnumWithCustomConstructor someEnum) {
        if (this.closed) {
            throw new IllegalStateException("Proxy is closed");
        }
        JsonObject _json = new JsonObject();
        _json.put("someEnum", (Object)(someEnum != null ? Mappers.serializeSomeEnumWithCustomConstructor(someEnum) : null));
        DeliveryOptions _deliveryOptions = this._options != null ? new DeliveryOptions(this._options) : new DeliveryOptions();
        _deliveryOptions.addHeader("action", "enumCustomTypeNull");
        _deliveryOptions.getHeaders().set("action", "enumCustomTypeNull");
        this._vertx.eventBus().send(this._address, (Object)_json, _deliveryOptions);
    }

    @Override
    public void enumCustomTypeAsResult(Handler<AsyncResult<SomeEnumWithCustomConstructor>> someEnum) {
        if (this.closed) {
            someEnum.handle((Object)Future.failedFuture((Throwable)new IllegalStateException("Proxy is closed")));
            return;
        }
        JsonObject _json = new JsonObject();
        DeliveryOptions _deliveryOptions = this._options != null ? new DeliveryOptions(this._options) : new DeliveryOptions();
        _deliveryOptions.addHeader("action", "enumCustomTypeAsResult");
        _deliveryOptions.getHeaders().set("action", "enumCustomTypeAsResult");
        this._vertx.eventBus().request(this._address, (Object)_json, _deliveryOptions, res -> {
            if (res.failed()) {
                someEnum.handle((Object)Future.failedFuture((Throwable)res.cause()));
            } else {
                someEnum.handle((Object)Future.succeededFuture(((Message)res.result()).body() != null ? Mappers.deserializeSomeEnumWithCustomConstructor((String)((Message)res.result()).body()) : null));
            }
        });
    }

    @Override
    public void enumCustomTypeAsResultNull(Handler<AsyncResult<SomeEnumWithCustomConstructor>> someEnum) {
        if (this.closed) {
            someEnum.handle((Object)Future.failedFuture((Throwable)new IllegalStateException("Proxy is closed")));
            return;
        }
        JsonObject _json = new JsonObject();
        DeliveryOptions _deliveryOptions = this._options != null ? new DeliveryOptions(this._options) : new DeliveryOptions();
        _deliveryOptions.addHeader("action", "enumCustomTypeAsResultNull");
        _deliveryOptions.getHeaders().set("action", "enumCustomTypeAsResultNull");
        this._vertx.eventBus().request(this._address, (Object)_json, _deliveryOptions, res -> {
            if (res.failed()) {
                someEnum.handle((Object)Future.failedFuture((Throwable)res.cause()));
            } else {
                someEnum.handle((Object)Future.succeededFuture(((Message)res.result()).body() != null ? Mappers.deserializeSomeEnumWithCustomConstructor((String)((Message)res.result()).body()) : null));
            }
        });
    }

    @Override
    public void dataObjectType(TestDataObject options) {
        if (this.closed) {
            throw new IllegalStateException("Proxy is closed");
        }
        JsonObject _json = new JsonObject();
        _json.put("options", (Object)(options != null ? options.toJson() : null));
        DeliveryOptions _deliveryOptions = this._options != null ? new DeliveryOptions(this._options) : new DeliveryOptions();
        _deliveryOptions.addHeader("action", "dataObjectType");
        _deliveryOptions.getHeaders().set("action", "dataObjectType");
        this._vertx.eventBus().send(this._address, (Object)_json, _deliveryOptions);
    }

    @Override
    public void listdataObjectType(List<TestDataObject> list) {
        if (this.closed) {
            throw new IllegalStateException("Proxy is closed");
        }
        JsonObject _json = new JsonObject();
        _json.put("list", (Object)new JsonArray(list == null ? Collections.emptyList() : list.stream().map(v -> v != null ? v.toJson() : null).collect(Collectors.toList())));
        DeliveryOptions _deliveryOptions = this._options != null ? new DeliveryOptions(this._options) : new DeliveryOptions();
        _deliveryOptions.addHeader("action", "listdataObjectType");
        _deliveryOptions.getHeaders().set("action", "listdataObjectType");
        this._vertx.eventBus().send(this._address, (Object)_json, _deliveryOptions);
    }

    @Override
    public void setdataObjectType(Set<TestDataObject> set) {
        if (this.closed) {
            throw new IllegalStateException("Proxy is closed");
        }
        JsonObject _json = new JsonObject();
        _json.put("set", (Object)new JsonArray(set == null ? Collections.emptyList() : set.stream().map(v -> v != null ? v.toJson() : null).collect(Collectors.toList())));
        DeliveryOptions _deliveryOptions = this._options != null ? new DeliveryOptions(this._options) : new DeliveryOptions();
        _deliveryOptions.addHeader("action", "setdataObjectType");
        _deliveryOptions.getHeaders().set("action", "setdataObjectType");
        this._vertx.eventBus().send(this._address, (Object)_json, _deliveryOptions);
    }

    @Override
    public void dataObjectTypeNull(TestDataObject options) {
        if (this.closed) {
            throw new IllegalStateException("Proxy is closed");
        }
        JsonObject _json = new JsonObject();
        _json.put("options", (Object)(options != null ? options.toJson() : null));
        DeliveryOptions _deliveryOptions = this._options != null ? new DeliveryOptions(this._options) : new DeliveryOptions();
        _deliveryOptions.addHeader("action", "dataObjectTypeNull");
        _deliveryOptions.getHeaders().set("action", "dataObjectTypeNull");
        this._vertx.eventBus().send(this._address, (Object)_json, _deliveryOptions);
    }

    @Override
    public void dateTimeType(ZonedDateTime dateTime) {
        if (this.closed) {
            throw new IllegalStateException("Proxy is closed");
        }
        JsonObject _json = new JsonObject();
        _json.put("dateTime", (Object)(dateTime != null ? Mappers.serializeZonedDateTime(dateTime) : null));
        DeliveryOptions _deliveryOptions = this._options != null ? new DeliveryOptions(this._options) : new DeliveryOptions();
        _deliveryOptions.addHeader("action", "dateTimeType");
        _deliveryOptions.getHeaders().set("action", "dateTimeType");
        this._vertx.eventBus().send(this._address, (Object)_json, _deliveryOptions);
    }

    @Override
    public void listDateTimeType(List<ZonedDateTime> list) {
        if (this.closed) {
            throw new IllegalStateException("Proxy is closed");
        }
        JsonObject _json = new JsonObject();
        _json.put("list", (Object)new JsonArray(list == null ? Collections.emptyList() : list.stream().map(v -> v != null ? Mappers.serializeZonedDateTime(v) : null).collect(Collectors.toList())));
        DeliveryOptions _deliveryOptions = this._options != null ? new DeliveryOptions(this._options) : new DeliveryOptions();
        _deliveryOptions.addHeader("action", "listDateTimeType");
        _deliveryOptions.getHeaders().set("action", "listDateTimeType");
        this._vertx.eventBus().send(this._address, (Object)_json, _deliveryOptions);
    }

    @Override
    public void setDateTimeType(Set<ZonedDateTime> set) {
        if (this.closed) {
            throw new IllegalStateException("Proxy is closed");
        }
        JsonObject _json = new JsonObject();
        _json.put("set", (Object)new JsonArray(set == null ? Collections.emptyList() : set.stream().map(v -> v != null ? Mappers.serializeZonedDateTime(v) : null).collect(Collectors.toList())));
        DeliveryOptions _deliveryOptions = this._options != null ? new DeliveryOptions(this._options) : new DeliveryOptions();
        _deliveryOptions.addHeader("action", "setDateTimeType");
        _deliveryOptions.getHeaders().set("action", "setDateTimeType");
        this._vertx.eventBus().send(this._address, (Object)_json, _deliveryOptions);
    }

    @Override
    public void mapDateTimeType(Map<String, ZonedDateTime> map) {
        if (this.closed) {
            throw new IllegalStateException("Proxy is closed");
        }
        JsonObject _json = new JsonObject();
        _json.put("map", (Object)new JsonObject(map == null ? Collections.emptyMap() : map.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> e.getValue() != null ? Mappers.serializeZonedDateTime((ZonedDateTime)e.getValue()) : null))));
        DeliveryOptions _deliveryOptions = this._options != null ? new DeliveryOptions(this._options) : new DeliveryOptions();
        _deliveryOptions.addHeader("action", "mapDateTimeType");
        _deliveryOptions.getHeaders().set("action", "mapDateTimeType");
        this._vertx.eventBus().send(this._address, (Object)_json, _deliveryOptions);
    }

    @Override
    public void listdataObjectTypeHavingNullValues(List<TestDataObject> list) {
        if (this.closed) {
            throw new IllegalStateException("Proxy is closed");
        }
        JsonObject _json = new JsonObject();
        _json.put("list", (Object)new JsonArray(list == null ? Collections.emptyList() : list.stream().map(v -> v != null ? v.toJson() : null).collect(Collectors.toList())));
        DeliveryOptions _deliveryOptions = this._options != null ? new DeliveryOptions(this._options) : new DeliveryOptions();
        _deliveryOptions.addHeader("action", "listdataObjectTypeHavingNullValues");
        _deliveryOptions.getHeaders().set("action", "listdataObjectTypeHavingNullValues");
        this._vertx.eventBus().send(this._address, (Object)_json, _deliveryOptions);
    }

    @Override
    public void setdataObjectTypeHavingNullValues(Set<TestDataObject> set) {
        if (this.closed) {
            throw new IllegalStateException("Proxy is closed");
        }
        JsonObject _json = new JsonObject();
        _json.put("set", (Object)new JsonArray(set == null ? Collections.emptyList() : set.stream().map(v -> v != null ? v.toJson() : null).collect(Collectors.toList())));
        DeliveryOptions _deliveryOptions = this._options != null ? new DeliveryOptions(this._options) : new DeliveryOptions();
        _deliveryOptions.addHeader("action", "setdataObjectTypeHavingNullValues");
        _deliveryOptions.getHeaders().set("action", "setdataObjectTypeHavingNullValues");
        this._vertx.eventBus().send(this._address, (Object)_json, _deliveryOptions);
    }

    @Override
    public void listdataObjectTypeNull(List<TestDataObject> list) {
        if (this.closed) {
            throw new IllegalStateException("Proxy is closed");
        }
        JsonObject _json = new JsonObject();
        _json.put("list", (Object)new JsonArray(list == null ? Collections.emptyList() : list.stream().map(v -> v != null ? v.toJson() : null).collect(Collectors.toList())));
        DeliveryOptions _deliveryOptions = this._options != null ? new DeliveryOptions(this._options) : new DeliveryOptions();
        _deliveryOptions.addHeader("action", "listdataObjectTypeNull");
        _deliveryOptions.getHeaders().set("action", "listdataObjectTypeNull");
        this._vertx.eventBus().send(this._address, (Object)_json, _deliveryOptions);
    }

    @Override
    public void setdataObjectTypeNull(Set<TestDataObject> set) {
        if (this.closed) {
            throw new IllegalStateException("Proxy is closed");
        }
        JsonObject _json = new JsonObject();
        _json.put("set", (Object)new JsonArray(set == null ? Collections.emptyList() : set.stream().map(v -> v != null ? v.toJson() : null).collect(Collectors.toList())));
        DeliveryOptions _deliveryOptions = this._options != null ? new DeliveryOptions(this._options) : new DeliveryOptions();
        _deliveryOptions.addHeader("action", "setdataObjectTypeNull");
        _deliveryOptions.getHeaders().set("action", "setdataObjectTypeNull");
        this._vertx.eventBus().send(this._address, (Object)_json, _deliveryOptions);
    }

    @Override
    public void mapDataObjectType(Map<String, TestDataObject> map) {
        if (this.closed) {
            throw new IllegalStateException("Proxy is closed");
        }
        JsonObject _json = new JsonObject();
        _json.put("map", (Object)new JsonObject(map == null ? Collections.emptyMap() : map.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> e.getValue() != null ? ((TestDataObject)e.getValue()).toJson() : null))));
        DeliveryOptions _deliveryOptions = this._options != null ? new DeliveryOptions(this._options) : new DeliveryOptions();
        _deliveryOptions.addHeader("action", "mapDataObjectType");
        _deliveryOptions.getHeaders().set("action", "mapDataObjectType");
        this._vertx.eventBus().send(this._address, (Object)_json, _deliveryOptions);
    }

    @Override
    public void listParams(List<String> listString, List<Byte> listByte, List<Short> listShort, List<Integer> listInt, List<Long> listLong, List<JsonObject> listJsonObject, List<JsonArray> listJsonArray, List<TestDataObject> listDataObject) {
        if (this.closed) {
            throw new IllegalStateException("Proxy is closed");
        }
        JsonObject _json = new JsonObject();
        _json.put("listString", (Object)new JsonArray(listString));
        _json.put("listByte", (Object)new JsonArray(listByte));
        _json.put("listShort", (Object)new JsonArray(listShort));
        _json.put("listInt", (Object)new JsonArray(listInt));
        _json.put("listLong", (Object)new JsonArray(listLong));
        _json.put("listJsonObject", (Object)new JsonArray(listJsonObject));
        _json.put("listJsonArray", (Object)new JsonArray(listJsonArray));
        _json.put("listDataObject", (Object)new JsonArray(listDataObject == null ? Collections.emptyList() : listDataObject.stream().map(v -> v != null ? v.toJson() : null).collect(Collectors.toList())));
        DeliveryOptions _deliveryOptions = this._options != null ? new DeliveryOptions(this._options) : new DeliveryOptions();
        _deliveryOptions.addHeader("action", "listParams");
        _deliveryOptions.getHeaders().set("action", "listParams");
        this._vertx.eventBus().send(this._address, (Object)_json, _deliveryOptions);
    }

    @Override
    public void setParams(Set<String> setString, Set<Byte> setByte, Set<Short> setShort, Set<Integer> setInt, Set<Long> setLong, Set<JsonObject> setJsonObject, Set<JsonArray> setJsonArray, Set<TestDataObject> setDataObject) {
        if (this.closed) {
            throw new IllegalStateException("Proxy is closed");
        }
        JsonObject _json = new JsonObject();
        _json.put("setString", (Object)new JsonArray(new ArrayList<String>(setString)));
        _json.put("setByte", (Object)new JsonArray(new ArrayList<Byte>(setByte)));
        _json.put("setShort", (Object)new JsonArray(new ArrayList<Short>(setShort)));
        _json.put("setInt", (Object)new JsonArray(new ArrayList<Integer>(setInt)));
        _json.put("setLong", (Object)new JsonArray(new ArrayList<Long>(setLong)));
        _json.put("setJsonObject", (Object)new JsonArray(new ArrayList<JsonObject>(setJsonObject)));
        _json.put("setJsonArray", (Object)new JsonArray(new ArrayList<JsonArray>(setJsonArray)));
        _json.put("setDataObject", (Object)new JsonArray(setDataObject == null ? Collections.emptyList() : setDataObject.stream().map(v -> v != null ? v.toJson() : null).collect(Collectors.toList())));
        DeliveryOptions _deliveryOptions = this._options != null ? new DeliveryOptions(this._options) : new DeliveryOptions();
        _deliveryOptions.addHeader("action", "setParams");
        _deliveryOptions.getHeaders().set("action", "setParams");
        this._vertx.eventBus().send(this._address, (Object)_json, _deliveryOptions);
    }

    @Override
    public void mapParams(Map<String, String> mapString, Map<String, Byte> mapByte, Map<String, Short> mapShort, Map<String, Integer> mapInt, Map<String, Long> mapLong, Map<String, JsonObject> mapJsonObject, Map<String, JsonArray> mapJsonArray) {
        if (this.closed) {
            throw new IllegalStateException("Proxy is closed");
        }
        JsonObject _json = new JsonObject();
        _json.put("mapString", (Object)new JsonObject(ProxyUtils.convertMap(mapString)));
        _json.put("mapByte", (Object)new JsonObject(ProxyUtils.convertMap(mapByte)));
        _json.put("mapShort", (Object)new JsonObject(ProxyUtils.convertMap(mapShort)));
        _json.put("mapInt", (Object)new JsonObject(ProxyUtils.convertMap(mapInt)));
        _json.put("mapLong", (Object)new JsonObject(ProxyUtils.convertMap(mapLong)));
        _json.put("mapJsonObject", (Object)new JsonObject(ProxyUtils.convertMap(mapJsonObject)));
        _json.put("mapJsonArray", (Object)new JsonObject(ProxyUtils.convertMap(mapJsonArray)));
        DeliveryOptions _deliveryOptions = this._options != null ? new DeliveryOptions(this._options) : new DeliveryOptions();
        _deliveryOptions.addHeader("action", "mapParams");
        _deliveryOptions.getHeaders().set("action", "mapParams");
        this._vertx.eventBus().send(this._address, (Object)_json, _deliveryOptions);
    }

    @Override
    public void stringHandler(Handler<AsyncResult<String>> resultHandler) {
        if (this.closed) {
            resultHandler.handle((Object)Future.failedFuture((Throwable)new IllegalStateException("Proxy is closed")));
            return;
        }
        JsonObject _json = new JsonObject();
        DeliveryOptions _deliveryOptions = this._options != null ? new DeliveryOptions(this._options) : new DeliveryOptions();
        _deliveryOptions.addHeader("action", "stringHandler");
        _deliveryOptions.getHeaders().set("action", "stringHandler");
        this._vertx.eventBus().request(this._address, (Object)_json, _deliveryOptions, res -> {
            if (res.failed()) {
                resultHandler.handle((Object)Future.failedFuture((Throwable)res.cause()));
            } else {
                resultHandler.handle((Object)Future.succeededFuture((Object)((Message)res.result()).body()));
            }
        });
    }

    @Override
    public void stringNullHandler(Handler<AsyncResult<String>> resultHandler) {
        if (this.closed) {
            resultHandler.handle((Object)Future.failedFuture((Throwable)new IllegalStateException("Proxy is closed")));
            return;
        }
        JsonObject _json = new JsonObject();
        DeliveryOptions _deliveryOptions = this._options != null ? new DeliveryOptions(this._options) : new DeliveryOptions();
        _deliveryOptions.addHeader("action", "stringNullHandler");
        _deliveryOptions.getHeaders().set("action", "stringNullHandler");
        this._vertx.eventBus().request(this._address, (Object)_json, _deliveryOptions, res -> {
            if (res.failed()) {
                resultHandler.handle((Object)Future.failedFuture((Throwable)res.cause()));
            } else {
                resultHandler.handle((Object)Future.succeededFuture((Object)((Message)res.result()).body()));
            }
        });
    }

    @Override
    public void byteHandler(Handler<AsyncResult<Byte>> resultHandler) {
        if (this.closed) {
            resultHandler.handle((Object)Future.failedFuture((Throwable)new IllegalStateException("Proxy is closed")));
            return;
        }
        JsonObject _json = new JsonObject();
        DeliveryOptions _deliveryOptions = this._options != null ? new DeliveryOptions(this._options) : new DeliveryOptions();
        _deliveryOptions.addHeader("action", "byteHandler");
        _deliveryOptions.getHeaders().set("action", "byteHandler");
        this._vertx.eventBus().request(this._address, (Object)_json, _deliveryOptions, res -> {
            if (res.failed()) {
                resultHandler.handle((Object)Future.failedFuture((Throwable)res.cause()));
            } else {
                resultHandler.handle((Object)Future.succeededFuture((Object)((Message)res.result()).body()));
            }
        });
    }

    @Override
    public void byteNullHandler(Handler<AsyncResult<Byte>> resultHandler) {
        if (this.closed) {
            resultHandler.handle((Object)Future.failedFuture((Throwable)new IllegalStateException("Proxy is closed")));
            return;
        }
        JsonObject _json = new JsonObject();
        DeliveryOptions _deliveryOptions = this._options != null ? new DeliveryOptions(this._options) : new DeliveryOptions();
        _deliveryOptions.addHeader("action", "byteNullHandler");
        _deliveryOptions.getHeaders().set("action", "byteNullHandler");
        this._vertx.eventBus().request(this._address, (Object)_json, _deliveryOptions, res -> {
            if (res.failed()) {
                resultHandler.handle((Object)Future.failedFuture((Throwable)res.cause()));
            } else {
                resultHandler.handle((Object)Future.succeededFuture((Object)((Message)res.result()).body()));
            }
        });
    }

    @Override
    public void shortHandler(Handler<AsyncResult<Short>> resultHandler) {
        if (this.closed) {
            resultHandler.handle((Object)Future.failedFuture((Throwable)new IllegalStateException("Proxy is closed")));
            return;
        }
        JsonObject _json = new JsonObject();
        DeliveryOptions _deliveryOptions = this._options != null ? new DeliveryOptions(this._options) : new DeliveryOptions();
        _deliveryOptions.addHeader("action", "shortHandler");
        _deliveryOptions.getHeaders().set("action", "shortHandler");
        this._vertx.eventBus().request(this._address, (Object)_json, _deliveryOptions, res -> {
            if (res.failed()) {
                resultHandler.handle((Object)Future.failedFuture((Throwable)res.cause()));
            } else {
                resultHandler.handle((Object)Future.succeededFuture((Object)((Message)res.result()).body()));
            }
        });
    }

    @Override
    public void shortNullHandler(Handler<AsyncResult<Short>> resultHandler) {
        if (this.closed) {
            resultHandler.handle((Object)Future.failedFuture((Throwable)new IllegalStateException("Proxy is closed")));
            return;
        }
        JsonObject _json = new JsonObject();
        DeliveryOptions _deliveryOptions = this._options != null ? new DeliveryOptions(this._options) : new DeliveryOptions();
        _deliveryOptions.addHeader("action", "shortNullHandler");
        _deliveryOptions.getHeaders().set("action", "shortNullHandler");
        this._vertx.eventBus().request(this._address, (Object)_json, _deliveryOptions, res -> {
            if (res.failed()) {
                resultHandler.handle((Object)Future.failedFuture((Throwable)res.cause()));
            } else {
                resultHandler.handle((Object)Future.succeededFuture((Object)((Message)res.result()).body()));
            }
        });
    }

    @Override
    public void intHandler(Handler<AsyncResult<Integer>> resultHandler) {
        if (this.closed) {
            resultHandler.handle((Object)Future.failedFuture((Throwable)new IllegalStateException("Proxy is closed")));
            return;
        }
        JsonObject _json = new JsonObject();
        DeliveryOptions _deliveryOptions = this._options != null ? new DeliveryOptions(this._options) : new DeliveryOptions();
        _deliveryOptions.addHeader("action", "intHandler");
        _deliveryOptions.getHeaders().set("action", "intHandler");
        this._vertx.eventBus().request(this._address, (Object)_json, _deliveryOptions, res -> {
            if (res.failed()) {
                resultHandler.handle((Object)Future.failedFuture((Throwable)res.cause()));
            } else {
                resultHandler.handle((Object)Future.succeededFuture((Object)((Message)res.result()).body()));
            }
        });
    }

    @Override
    public void intNullHandler(Handler<AsyncResult<Integer>> resultHandler) {
        if (this.closed) {
            resultHandler.handle((Object)Future.failedFuture((Throwable)new IllegalStateException("Proxy is closed")));
            return;
        }
        JsonObject _json = new JsonObject();
        DeliveryOptions _deliveryOptions = this._options != null ? new DeliveryOptions(this._options) : new DeliveryOptions();
        _deliveryOptions.addHeader("action", "intNullHandler");
        _deliveryOptions.getHeaders().set("action", "intNullHandler");
        this._vertx.eventBus().request(this._address, (Object)_json, _deliveryOptions, res -> {
            if (res.failed()) {
                resultHandler.handle((Object)Future.failedFuture((Throwable)res.cause()));
            } else {
                resultHandler.handle((Object)Future.succeededFuture((Object)((Message)res.result()).body()));
            }
        });
    }

    @Override
    public void longHandler(Handler<AsyncResult<Long>> resultHandler) {
        if (this.closed) {
            resultHandler.handle((Object)Future.failedFuture((Throwable)new IllegalStateException("Proxy is closed")));
            return;
        }
        JsonObject _json = new JsonObject();
        DeliveryOptions _deliveryOptions = this._options != null ? new DeliveryOptions(this._options) : new DeliveryOptions();
        _deliveryOptions.addHeader("action", "longHandler");
        _deliveryOptions.getHeaders().set("action", "longHandler");
        this._vertx.eventBus().request(this._address, (Object)_json, _deliveryOptions, res -> {
            if (res.failed()) {
                resultHandler.handle((Object)Future.failedFuture((Throwable)res.cause()));
            } else {
                resultHandler.handle((Object)Future.succeededFuture((Object)((Message)res.result()).body()));
            }
        });
    }

    @Override
    public void longNullHandler(Handler<AsyncResult<Long>> resultHandler) {
        if (this.closed) {
            resultHandler.handle((Object)Future.failedFuture((Throwable)new IllegalStateException("Proxy is closed")));
            return;
        }
        JsonObject _json = new JsonObject();
        DeliveryOptions _deliveryOptions = this._options != null ? new DeliveryOptions(this._options) : new DeliveryOptions();
        _deliveryOptions.addHeader("action", "longNullHandler");
        _deliveryOptions.getHeaders().set("action", "longNullHandler");
        this._vertx.eventBus().request(this._address, (Object)_json, _deliveryOptions, res -> {
            if (res.failed()) {
                resultHandler.handle((Object)Future.failedFuture((Throwable)res.cause()));
            } else {
                resultHandler.handle((Object)Future.succeededFuture((Object)((Message)res.result()).body()));
            }
        });
    }

    @Override
    public void floatHandler(Handler<AsyncResult<Float>> resultHandler) {
        if (this.closed) {
            resultHandler.handle((Object)Future.failedFuture((Throwable)new IllegalStateException("Proxy is closed")));
            return;
        }
        JsonObject _json = new JsonObject();
        DeliveryOptions _deliveryOptions = this._options != null ? new DeliveryOptions(this._options) : new DeliveryOptions();
        _deliveryOptions.addHeader("action", "floatHandler");
        _deliveryOptions.getHeaders().set("action", "floatHandler");
        this._vertx.eventBus().request(this._address, (Object)_json, _deliveryOptions, res -> {
            if (res.failed()) {
                resultHandler.handle((Object)Future.failedFuture((Throwable)res.cause()));
            } else {
                resultHandler.handle((Object)Future.succeededFuture((Object)((Message)res.result()).body()));
            }
        });
    }

    @Override
    public void floatNullHandler(Handler<AsyncResult<Float>> resultHandler) {
        if (this.closed) {
            resultHandler.handle((Object)Future.failedFuture((Throwable)new IllegalStateException("Proxy is closed")));
            return;
        }
        JsonObject _json = new JsonObject();
        DeliveryOptions _deliveryOptions = this._options != null ? new DeliveryOptions(this._options) : new DeliveryOptions();
        _deliveryOptions.addHeader("action", "floatNullHandler");
        _deliveryOptions.getHeaders().set("action", "floatNullHandler");
        this._vertx.eventBus().request(this._address, (Object)_json, _deliveryOptions, res -> {
            if (res.failed()) {
                resultHandler.handle((Object)Future.failedFuture((Throwable)res.cause()));
            } else {
                resultHandler.handle((Object)Future.succeededFuture((Object)((Message)res.result()).body()));
            }
        });
    }

    @Override
    public void doubleHandler(Handler<AsyncResult<Double>> resultHandler) {
        if (this.closed) {
            resultHandler.handle((Object)Future.failedFuture((Throwable)new IllegalStateException("Proxy is closed")));
            return;
        }
        JsonObject _json = new JsonObject();
        DeliveryOptions _deliveryOptions = this._options != null ? new DeliveryOptions(this._options) : new DeliveryOptions();
        _deliveryOptions.addHeader("action", "doubleHandler");
        _deliveryOptions.getHeaders().set("action", "doubleHandler");
        this._vertx.eventBus().request(this._address, (Object)_json, _deliveryOptions, res -> {
            if (res.failed()) {
                resultHandler.handle((Object)Future.failedFuture((Throwable)res.cause()));
            } else {
                resultHandler.handle((Object)Future.succeededFuture((Object)((Message)res.result()).body()));
            }
        });
    }

    @Override
    public void doubleNullHandler(Handler<AsyncResult<Double>> resultHandler) {
        if (this.closed) {
            resultHandler.handle((Object)Future.failedFuture((Throwable)new IllegalStateException("Proxy is closed")));
            return;
        }
        JsonObject _json = new JsonObject();
        DeliveryOptions _deliveryOptions = this._options != null ? new DeliveryOptions(this._options) : new DeliveryOptions();
        _deliveryOptions.addHeader("action", "doubleNullHandler");
        _deliveryOptions.getHeaders().set("action", "doubleNullHandler");
        this._vertx.eventBus().request(this._address, (Object)_json, _deliveryOptions, res -> {
            if (res.failed()) {
                resultHandler.handle((Object)Future.failedFuture((Throwable)res.cause()));
            } else {
                resultHandler.handle((Object)Future.succeededFuture((Object)((Message)res.result()).body()));
            }
        });
    }

    @Override
    public void charHandler(Handler<AsyncResult<Character>> resultHandler) {
        if (this.closed) {
            resultHandler.handle((Object)Future.failedFuture((Throwable)new IllegalStateException("Proxy is closed")));
            return;
        }
        JsonObject _json = new JsonObject();
        DeliveryOptions _deliveryOptions = this._options != null ? new DeliveryOptions(this._options) : new DeliveryOptions();
        _deliveryOptions.addHeader("action", "charHandler");
        _deliveryOptions.getHeaders().set("action", "charHandler");
        this._vertx.eventBus().request(this._address, (Object)_json, _deliveryOptions, res -> {
            if (res.failed()) {
                resultHandler.handle((Object)Future.failedFuture((Throwable)res.cause()));
            } else {
                resultHandler.handle((Object)Future.succeededFuture((Object)((Message)res.result()).body()));
            }
        });
    }

    @Override
    public void charNullHandler(Handler<AsyncResult<Character>> resultHandler) {
        if (this.closed) {
            resultHandler.handle((Object)Future.failedFuture((Throwable)new IllegalStateException("Proxy is closed")));
            return;
        }
        JsonObject _json = new JsonObject();
        DeliveryOptions _deliveryOptions = this._options != null ? new DeliveryOptions(this._options) : new DeliveryOptions();
        _deliveryOptions.addHeader("action", "charNullHandler");
        _deliveryOptions.getHeaders().set("action", "charNullHandler");
        this._vertx.eventBus().request(this._address, (Object)_json, _deliveryOptions, res -> {
            if (res.failed()) {
                resultHandler.handle((Object)Future.failedFuture((Throwable)res.cause()));
            } else {
                resultHandler.handle((Object)Future.succeededFuture((Object)((Message)res.result()).body()));
            }
        });
    }

    @Override
    public void booleanHandler(Handler<AsyncResult<Boolean>> resultHandler) {
        if (this.closed) {
            resultHandler.handle((Object)Future.failedFuture((Throwable)new IllegalStateException("Proxy is closed")));
            return;
        }
        JsonObject _json = new JsonObject();
        DeliveryOptions _deliveryOptions = this._options != null ? new DeliveryOptions(this._options) : new DeliveryOptions();
        _deliveryOptions.addHeader("action", "booleanHandler");
        _deliveryOptions.getHeaders().set("action", "booleanHandler");
        this._vertx.eventBus().request(this._address, (Object)_json, _deliveryOptions, res -> {
            if (res.failed()) {
                resultHandler.handle((Object)Future.failedFuture((Throwable)res.cause()));
            } else {
                resultHandler.handle((Object)Future.succeededFuture((Object)((Message)res.result()).body()));
            }
        });
    }

    @Override
    public void booleanNullHandler(Handler<AsyncResult<Boolean>> resultHandler) {
        if (this.closed) {
            resultHandler.handle((Object)Future.failedFuture((Throwable)new IllegalStateException("Proxy is closed")));
            return;
        }
        JsonObject _json = new JsonObject();
        DeliveryOptions _deliveryOptions = this._options != null ? new DeliveryOptions(this._options) : new DeliveryOptions();
        _deliveryOptions.addHeader("action", "booleanNullHandler");
        _deliveryOptions.getHeaders().set("action", "booleanNullHandler");
        this._vertx.eventBus().request(this._address, (Object)_json, _deliveryOptions, res -> {
            if (res.failed()) {
                resultHandler.handle((Object)Future.failedFuture((Throwable)res.cause()));
            } else {
                resultHandler.handle((Object)Future.succeededFuture((Object)((Message)res.result()).body()));
            }
        });
    }

    @Override
    public void jsonObjectHandler(Handler<AsyncResult<JsonObject>> resultHandler) {
        if (this.closed) {
            resultHandler.handle((Object)Future.failedFuture((Throwable)new IllegalStateException("Proxy is closed")));
            return;
        }
        JsonObject _json = new JsonObject();
        DeliveryOptions _deliveryOptions = this._options != null ? new DeliveryOptions(this._options) : new DeliveryOptions();
        _deliveryOptions.addHeader("action", "jsonObjectHandler");
        _deliveryOptions.getHeaders().set("action", "jsonObjectHandler");
        this._vertx.eventBus().request(this._address, (Object)_json, _deliveryOptions, res -> {
            if (res.failed()) {
                resultHandler.handle((Object)Future.failedFuture((Throwable)res.cause()));
            } else {
                resultHandler.handle((Object)Future.succeededFuture((Object)((Message)res.result()).body()));
            }
        });
    }

    @Override
    public void jsonObjectNullHandler(Handler<AsyncResult<JsonObject>> resultHandler) {
        if (this.closed) {
            resultHandler.handle((Object)Future.failedFuture((Throwable)new IllegalStateException("Proxy is closed")));
            return;
        }
        JsonObject _json = new JsonObject();
        DeliveryOptions _deliveryOptions = this._options != null ? new DeliveryOptions(this._options) : new DeliveryOptions();
        _deliveryOptions.addHeader("action", "jsonObjectNullHandler");
        _deliveryOptions.getHeaders().set("action", "jsonObjectNullHandler");
        this._vertx.eventBus().request(this._address, (Object)_json, _deliveryOptions, res -> {
            if (res.failed()) {
                resultHandler.handle((Object)Future.failedFuture((Throwable)res.cause()));
            } else {
                resultHandler.handle((Object)Future.succeededFuture((Object)((Message)res.result()).body()));
            }
        });
    }

    @Override
    public void jsonArrayHandler(Handler<AsyncResult<JsonArray>> resultHandler) {
        if (this.closed) {
            resultHandler.handle((Object)Future.failedFuture((Throwable)new IllegalStateException("Proxy is closed")));
            return;
        }
        JsonObject _json = new JsonObject();
        DeliveryOptions _deliveryOptions = this._options != null ? new DeliveryOptions(this._options) : new DeliveryOptions();
        _deliveryOptions.addHeader("action", "jsonArrayHandler");
        _deliveryOptions.getHeaders().set("action", "jsonArrayHandler");
        this._vertx.eventBus().request(this._address, (Object)_json, _deliveryOptions, res -> {
            if (res.failed()) {
                resultHandler.handle((Object)Future.failedFuture((Throwable)res.cause()));
            } else {
                resultHandler.handle((Object)Future.succeededFuture((Object)((Message)res.result()).body()));
            }
        });
    }

    @Override
    public void jsonArrayNullHandler(Handler<AsyncResult<JsonArray>> resultHandler) {
        if (this.closed) {
            resultHandler.handle((Object)Future.failedFuture((Throwable)new IllegalStateException("Proxy is closed")));
            return;
        }
        JsonObject _json = new JsonObject();
        DeliveryOptions _deliveryOptions = this._options != null ? new DeliveryOptions(this._options) : new DeliveryOptions();
        _deliveryOptions.addHeader("action", "jsonArrayNullHandler");
        _deliveryOptions.getHeaders().set("action", "jsonArrayNullHandler");
        this._vertx.eventBus().request(this._address, (Object)_json, _deliveryOptions, res -> {
            if (res.failed()) {
                resultHandler.handle((Object)Future.failedFuture((Throwable)res.cause()));
            } else {
                resultHandler.handle((Object)Future.succeededFuture((Object)((Message)res.result()).body()));
            }
        });
    }

    @Override
    public void dataObjectHandler(Handler<AsyncResult<TestDataObject>> resultHandler) {
        if (this.closed) {
            resultHandler.handle((Object)Future.failedFuture((Throwable)new IllegalStateException("Proxy is closed")));
            return;
        }
        JsonObject _json = new JsonObject();
        DeliveryOptions _deliveryOptions = this._options != null ? new DeliveryOptions(this._options) : new DeliveryOptions();
        _deliveryOptions.addHeader("action", "dataObjectHandler");
        _deliveryOptions.getHeaders().set("action", "dataObjectHandler");
        this._vertx.eventBus().request(this._address, (Object)_json, _deliveryOptions, res -> {
            if (res.failed()) {
                resultHandler.handle((Object)Future.failedFuture((Throwable)res.cause()));
            } else {
                resultHandler.handle((Object)Future.succeededFuture((Object)(((Message)res.result()).body() != null ? new TestDataObject((JsonObject)((Message)res.result()).body()) : null)));
            }
        });
    }

    @Override
    public void dataObjectNullHandler(Handler<AsyncResult<TestDataObject>> resultHandler) {
        if (this.closed) {
            resultHandler.handle((Object)Future.failedFuture((Throwable)new IllegalStateException("Proxy is closed")));
            return;
        }
        JsonObject _json = new JsonObject();
        DeliveryOptions _deliveryOptions = this._options != null ? new DeliveryOptions(this._options) : new DeliveryOptions();
        _deliveryOptions.addHeader("action", "dataObjectNullHandler");
        _deliveryOptions.getHeaders().set("action", "dataObjectNullHandler");
        this._vertx.eventBus().request(this._address, (Object)_json, _deliveryOptions, res -> {
            if (res.failed()) {
                resultHandler.handle((Object)Future.failedFuture((Throwable)res.cause()));
            } else {
                resultHandler.handle((Object)Future.succeededFuture((Object)(((Message)res.result()).body() != null ? new TestDataObject((JsonObject)((Message)res.result()).body()) : null)));
            }
        });
    }

    @Override
    public void voidHandler(Handler<AsyncResult<Void>> resultHandler) {
        if (this.closed) {
            resultHandler.handle((Object)Future.failedFuture((Throwable)new IllegalStateException("Proxy is closed")));
            return;
        }
        JsonObject _json = new JsonObject();
        DeliveryOptions _deliveryOptions = this._options != null ? new DeliveryOptions(this._options) : new DeliveryOptions();
        _deliveryOptions.addHeader("action", "voidHandler");
        _deliveryOptions.getHeaders().set("action", "voidHandler");
        this._vertx.eventBus().request(this._address, (Object)_json, _deliveryOptions, res -> {
            if (res.failed()) {
                resultHandler.handle((Object)Future.failedFuture((Throwable)res.cause()));
            } else {
                resultHandler.handle((Object)Future.succeededFuture((Object)((Message)res.result()).body()));
            }
        });
    }

    @Override
    public TestService fluentMethod(String str, Handler<AsyncResult<String>> resultHandler) {
        if (this.closed) {
            resultHandler.handle((Object)Future.failedFuture((Throwable)new IllegalStateException("Proxy is closed")));
            return this;
        }
        JsonObject _json = new JsonObject();
        _json.put("str", (Object)str);
        DeliveryOptions _deliveryOptions = this._options != null ? new DeliveryOptions(this._options) : new DeliveryOptions();
        _deliveryOptions.addHeader("action", "fluentMethod");
        _deliveryOptions.getHeaders().set("action", "fluentMethod");
        this._vertx.eventBus().request(this._address, (Object)_json, _deliveryOptions, res -> {
            if (res.failed()) {
                resultHandler.handle((Object)Future.failedFuture((Throwable)res.cause()));
            } else {
                resultHandler.handle((Object)Future.succeededFuture((Object)((Message)res.result()).body()));
            }
        });
        return this;
    }

    @Override
    public TestService fluentNoParams() {
        if (this.closed) {
            throw new IllegalStateException("Proxy is closed");
        }
        JsonObject _json = new JsonObject();
        DeliveryOptions _deliveryOptions = this._options != null ? new DeliveryOptions(this._options) : new DeliveryOptions();
        _deliveryOptions.addHeader("action", "fluentNoParams");
        _deliveryOptions.getHeaders().set("action", "fluentNoParams");
        this._vertx.eventBus().send(this._address, (Object)_json, _deliveryOptions);
        return this;
    }

    @Override
    public void failingMethod(Handler<AsyncResult<JsonObject>> resultHandler) {
        if (this.closed) {
            resultHandler.handle((Object)Future.failedFuture((Throwable)new IllegalStateException("Proxy is closed")));
            return;
        }
        JsonObject _json = new JsonObject();
        DeliveryOptions _deliveryOptions = this._options != null ? new DeliveryOptions(this._options) : new DeliveryOptions();
        _deliveryOptions.addHeader("action", "failingMethod");
        _deliveryOptions.getHeaders().set("action", "failingMethod");
        this._vertx.eventBus().request(this._address, (Object)_json, _deliveryOptions, res -> {
            if (res.failed()) {
                resultHandler.handle((Object)Future.failedFuture((Throwable)res.cause()));
            } else {
                resultHandler.handle((Object)Future.succeededFuture((Object)((Message)res.result()).body()));
            }
        });
    }

    @Override
    public void invokeWithMessage(JsonObject object, String str, int i, char chr, SomeEnum senum, Handler<AsyncResult<String>> resultHandler) {
        if (this.closed) {
            resultHandler.handle((Object)Future.failedFuture((Throwable)new IllegalStateException("Proxy is closed")));
            return;
        }
        JsonObject _json = new JsonObject();
        _json.put("object", (Object)object);
        _json.put("str", (Object)str);
        _json.put("i", (Object)i);
        _json.put("chr", (Object)chr);
        _json.put("senum", (Object)(senum == null ? null : senum.name()));
        DeliveryOptions _deliveryOptions = this._options != null ? new DeliveryOptions(this._options) : new DeliveryOptions();
        _deliveryOptions.addHeader("action", "invokeWithMessage");
        _deliveryOptions.getHeaders().set("action", "invokeWithMessage");
        this._vertx.eventBus().request(this._address, (Object)_json, _deliveryOptions, res -> {
            if (res.failed()) {
                resultHandler.handle((Object)Future.failedFuture((Throwable)res.cause()));
            } else {
                resultHandler.handle((Object)Future.succeededFuture((Object)((Message)res.result()).body()));
            }
        });
    }

    @Override
    public void listStringHandler(Handler<AsyncResult<List<String>>> resultHandler) {
        if (this.closed) {
            resultHandler.handle((Object)Future.failedFuture((Throwable)new IllegalStateException("Proxy is closed")));
            return;
        }
        JsonObject _json = new JsonObject();
        DeliveryOptions _deliveryOptions = this._options != null ? new DeliveryOptions(this._options) : new DeliveryOptions();
        _deliveryOptions.addHeader("action", "listStringHandler");
        _deliveryOptions.getHeaders().set("action", "listStringHandler");
        this._vertx.eventBus().request(this._address, (Object)_json, _deliveryOptions, res -> {
            if (res.failed()) {
                resultHandler.handle((Object)Future.failedFuture((Throwable)res.cause()));
            } else {
                resultHandler.handle((Object)Future.succeededFuture((Object)ProxyUtils.convertList((List)((JsonArray)((Message)res.result()).body()).getList())));
            }
        });
    }

    @Override
    public void listByteHandler(Handler<AsyncResult<List<Byte>>> resultHandler) {
        if (this.closed) {
            resultHandler.handle((Object)Future.failedFuture((Throwable)new IllegalStateException("Proxy is closed")));
            return;
        }
        JsonObject _json = new JsonObject();
        DeliveryOptions _deliveryOptions = this._options != null ? new DeliveryOptions(this._options) : new DeliveryOptions();
        _deliveryOptions.addHeader("action", "listByteHandler");
        _deliveryOptions.getHeaders().set("action", "listByteHandler");
        this._vertx.eventBus().request(this._address, (Object)_json, _deliveryOptions, res -> {
            if (res.failed()) {
                resultHandler.handle((Object)Future.failedFuture((Throwable)res.cause()));
            } else {
                resultHandler.handle((Object)Future.succeededFuture((Object)ProxyUtils.convertList((List)((JsonArray)((Message)res.result()).body()).getList())));
            }
        });
    }

    @Override
    public void listShortHandler(Handler<AsyncResult<List<Short>>> resultHandler) {
        if (this.closed) {
            resultHandler.handle((Object)Future.failedFuture((Throwable)new IllegalStateException("Proxy is closed")));
            return;
        }
        JsonObject _json = new JsonObject();
        DeliveryOptions _deliveryOptions = this._options != null ? new DeliveryOptions(this._options) : new DeliveryOptions();
        _deliveryOptions.addHeader("action", "listShortHandler");
        _deliveryOptions.getHeaders().set("action", "listShortHandler");
        this._vertx.eventBus().request(this._address, (Object)_json, _deliveryOptions, res -> {
            if (res.failed()) {
                resultHandler.handle((Object)Future.failedFuture((Throwable)res.cause()));
            } else {
                resultHandler.handle((Object)Future.succeededFuture((Object)ProxyUtils.convertList((List)((JsonArray)((Message)res.result()).body()).getList())));
            }
        });
    }

    @Override
    public void listIntHandler(Handler<AsyncResult<List<Integer>>> resultHandler) {
        if (this.closed) {
            resultHandler.handle((Object)Future.failedFuture((Throwable)new IllegalStateException("Proxy is closed")));
            return;
        }
        JsonObject _json = new JsonObject();
        DeliveryOptions _deliveryOptions = this._options != null ? new DeliveryOptions(this._options) : new DeliveryOptions();
        _deliveryOptions.addHeader("action", "listIntHandler");
        _deliveryOptions.getHeaders().set("action", "listIntHandler");
        this._vertx.eventBus().request(this._address, (Object)_json, _deliveryOptions, res -> {
            if (res.failed()) {
                resultHandler.handle((Object)Future.failedFuture((Throwable)res.cause()));
            } else {
                resultHandler.handle((Object)Future.succeededFuture((Object)ProxyUtils.convertList((List)((JsonArray)((Message)res.result()).body()).getList())));
            }
        });
    }

    @Override
    public void listLongHandler(Handler<AsyncResult<List<Long>>> resultHandler) {
        if (this.closed) {
            resultHandler.handle((Object)Future.failedFuture((Throwable)new IllegalStateException("Proxy is closed")));
            return;
        }
        JsonObject _json = new JsonObject();
        DeliveryOptions _deliveryOptions = this._options != null ? new DeliveryOptions(this._options) : new DeliveryOptions();
        _deliveryOptions.addHeader("action", "listLongHandler");
        _deliveryOptions.getHeaders().set("action", "listLongHandler");
        this._vertx.eventBus().request(this._address, (Object)_json, _deliveryOptions, res -> {
            if (res.failed()) {
                resultHandler.handle((Object)Future.failedFuture((Throwable)res.cause()));
            } else {
                resultHandler.handle((Object)Future.succeededFuture((Object)ProxyUtils.convertList((List)((JsonArray)((Message)res.result()).body()).getList())));
            }
        });
    }

    @Override
    public void listFloatHandler(Handler<AsyncResult<List<Float>>> resultHandler) {
        if (this.closed) {
            resultHandler.handle((Object)Future.failedFuture((Throwable)new IllegalStateException("Proxy is closed")));
            return;
        }
        JsonObject _json = new JsonObject();
        DeliveryOptions _deliveryOptions = this._options != null ? new DeliveryOptions(this._options) : new DeliveryOptions();
        _deliveryOptions.addHeader("action", "listFloatHandler");
        _deliveryOptions.getHeaders().set("action", "listFloatHandler");
        this._vertx.eventBus().request(this._address, (Object)_json, _deliveryOptions, res -> {
            if (res.failed()) {
                resultHandler.handle((Object)Future.failedFuture((Throwable)res.cause()));
            } else {
                resultHandler.handle((Object)Future.succeededFuture((Object)ProxyUtils.convertList((List)((JsonArray)((Message)res.result()).body()).getList())));
            }
        });
    }

    @Override
    public void listDoubleHandler(Handler<AsyncResult<List<Double>>> resultHandler) {
        if (this.closed) {
            resultHandler.handle((Object)Future.failedFuture((Throwable)new IllegalStateException("Proxy is closed")));
            return;
        }
        JsonObject _json = new JsonObject();
        DeliveryOptions _deliveryOptions = this._options != null ? new DeliveryOptions(this._options) : new DeliveryOptions();
        _deliveryOptions.addHeader("action", "listDoubleHandler");
        _deliveryOptions.getHeaders().set("action", "listDoubleHandler");
        this._vertx.eventBus().request(this._address, (Object)_json, _deliveryOptions, res -> {
            if (res.failed()) {
                resultHandler.handle((Object)Future.failedFuture((Throwable)res.cause()));
            } else {
                resultHandler.handle((Object)Future.succeededFuture((Object)ProxyUtils.convertList((List)((JsonArray)((Message)res.result()).body()).getList())));
            }
        });
    }

    @Override
    public void listCharHandler(Handler<AsyncResult<List<Character>>> resultHandler) {
        if (this.closed) {
            resultHandler.handle((Object)Future.failedFuture((Throwable)new IllegalStateException("Proxy is closed")));
            return;
        }
        JsonObject _json = new JsonObject();
        DeliveryOptions _deliveryOptions = this._options != null ? new DeliveryOptions(this._options) : new DeliveryOptions();
        _deliveryOptions.addHeader("action", "listCharHandler");
        _deliveryOptions.getHeaders().set("action", "listCharHandler");
        this._vertx.eventBus().request(this._address, (Object)_json, _deliveryOptions, res -> {
            if (res.failed()) {
                resultHandler.handle((Object)Future.failedFuture((Throwable)res.cause()));
            } else {
                resultHandler.handle((Object)Future.succeededFuture((Object)ProxyUtils.convertToListChar((JsonArray)((JsonArray)((Message)res.result()).body()))));
            }
        });
    }

    @Override
    public void listBoolHandler(Handler<AsyncResult<List<Boolean>>> resultHandler) {
        if (this.closed) {
            resultHandler.handle((Object)Future.failedFuture((Throwable)new IllegalStateException("Proxy is closed")));
            return;
        }
        JsonObject _json = new JsonObject();
        DeliveryOptions _deliveryOptions = this._options != null ? new DeliveryOptions(this._options) : new DeliveryOptions();
        _deliveryOptions.addHeader("action", "listBoolHandler");
        _deliveryOptions.getHeaders().set("action", "listBoolHandler");
        this._vertx.eventBus().request(this._address, (Object)_json, _deliveryOptions, res -> {
            if (res.failed()) {
                resultHandler.handle((Object)Future.failedFuture((Throwable)res.cause()));
            } else {
                resultHandler.handle((Object)Future.succeededFuture((Object)ProxyUtils.convertList((List)((JsonArray)((Message)res.result()).body()).getList())));
            }
        });
    }

    @Override
    public void listJsonObjectHandler(Handler<AsyncResult<List<JsonObject>>> resultHandler) {
        if (this.closed) {
            resultHandler.handle((Object)Future.failedFuture((Throwable)new IllegalStateException("Proxy is closed")));
            return;
        }
        JsonObject _json = new JsonObject();
        DeliveryOptions _deliveryOptions = this._options != null ? new DeliveryOptions(this._options) : new DeliveryOptions();
        _deliveryOptions.addHeader("action", "listJsonObjectHandler");
        _deliveryOptions.getHeaders().set("action", "listJsonObjectHandler");
        this._vertx.eventBus().request(this._address, (Object)_json, _deliveryOptions, res -> {
            if (res.failed()) {
                resultHandler.handle((Object)Future.failedFuture((Throwable)res.cause()));
            } else {
                resultHandler.handle((Object)Future.succeededFuture((Object)ProxyUtils.convertList((List)((JsonArray)((Message)res.result()).body()).getList())));
            }
        });
    }

    @Override
    public void listJsonArrayHandler(Handler<AsyncResult<List<JsonArray>>> resultHandler) {
        if (this.closed) {
            resultHandler.handle((Object)Future.failedFuture((Throwable)new IllegalStateException("Proxy is closed")));
            return;
        }
        JsonObject _json = new JsonObject();
        DeliveryOptions _deliveryOptions = this._options != null ? new DeliveryOptions(this._options) : new DeliveryOptions();
        _deliveryOptions.addHeader("action", "listJsonArrayHandler");
        _deliveryOptions.getHeaders().set("action", "listJsonArrayHandler");
        this._vertx.eventBus().request(this._address, (Object)_json, _deliveryOptions, res -> {
            if (res.failed()) {
                resultHandler.handle((Object)Future.failedFuture((Throwable)res.cause()));
            } else {
                resultHandler.handle((Object)Future.succeededFuture((Object)ProxyUtils.convertList((List)((JsonArray)((Message)res.result()).body()).getList())));
            }
        });
    }

    @Override
    public void listDataObjectHandler(Handler<AsyncResult<List<TestDataObject>>> resultHandler) {
        if (this.closed) {
            resultHandler.handle((Object)Future.failedFuture((Throwable)new IllegalStateException("Proxy is closed")));
            return;
        }
        JsonObject _json = new JsonObject();
        DeliveryOptions _deliveryOptions = this._options != null ? new DeliveryOptions(this._options) : new DeliveryOptions();
        _deliveryOptions.addHeader("action", "listDataObjectHandler");
        _deliveryOptions.getHeaders().set("action", "listDataObjectHandler");
        this._vertx.eventBus().request(this._address, (Object)_json, _deliveryOptions, res -> {
            if (res.failed()) {
                resultHandler.handle((Object)Future.failedFuture((Throwable)res.cause()));
            } else {
                resultHandler.handle((Object)Future.succeededFuture(((JsonArray)((Message)res.result()).body()).stream().map(v -> v != null ? new TestDataObject((JsonObject)v) : null).collect(Collectors.toList())));
            }
        });
    }

    @Override
    public void setStringHandler(Handler<AsyncResult<Set<String>>> resultHandler) {
        if (this.closed) {
            resultHandler.handle((Object)Future.failedFuture((Throwable)new IllegalStateException("Proxy is closed")));
            return;
        }
        JsonObject _json = new JsonObject();
        DeliveryOptions _deliveryOptions = this._options != null ? new DeliveryOptions(this._options) : new DeliveryOptions();
        _deliveryOptions.addHeader("action", "setStringHandler");
        _deliveryOptions.getHeaders().set("action", "setStringHandler");
        this._vertx.eventBus().request(this._address, (Object)_json, _deliveryOptions, res -> {
            if (res.failed()) {
                resultHandler.handle((Object)Future.failedFuture((Throwable)res.cause()));
            } else {
                resultHandler.handle((Object)Future.succeededFuture((Object)ProxyUtils.convertSet((List)((JsonArray)((Message)res.result()).body()).getList())));
            }
        });
    }

    @Override
    public void setByteHandler(Handler<AsyncResult<Set<Byte>>> resultHandler) {
        if (this.closed) {
            resultHandler.handle((Object)Future.failedFuture((Throwable)new IllegalStateException("Proxy is closed")));
            return;
        }
        JsonObject _json = new JsonObject();
        DeliveryOptions _deliveryOptions = this._options != null ? new DeliveryOptions(this._options) : new DeliveryOptions();
        _deliveryOptions.addHeader("action", "setByteHandler");
        _deliveryOptions.getHeaders().set("action", "setByteHandler");
        this._vertx.eventBus().request(this._address, (Object)_json, _deliveryOptions, res -> {
            if (res.failed()) {
                resultHandler.handle((Object)Future.failedFuture((Throwable)res.cause()));
            } else {
                resultHandler.handle((Object)Future.succeededFuture((Object)ProxyUtils.convertSet((List)((JsonArray)((Message)res.result()).body()).getList())));
            }
        });
    }

    @Override
    public void setShortHandler(Handler<AsyncResult<Set<Short>>> resultHandler) {
        if (this.closed) {
            resultHandler.handle((Object)Future.failedFuture((Throwable)new IllegalStateException("Proxy is closed")));
            return;
        }
        JsonObject _json = new JsonObject();
        DeliveryOptions _deliveryOptions = this._options != null ? new DeliveryOptions(this._options) : new DeliveryOptions();
        _deliveryOptions.addHeader("action", "setShortHandler");
        _deliveryOptions.getHeaders().set("action", "setShortHandler");
        this._vertx.eventBus().request(this._address, (Object)_json, _deliveryOptions, res -> {
            if (res.failed()) {
                resultHandler.handle((Object)Future.failedFuture((Throwable)res.cause()));
            } else {
                resultHandler.handle((Object)Future.succeededFuture((Object)ProxyUtils.convertSet((List)((JsonArray)((Message)res.result()).body()).getList())));
            }
        });
    }

    @Override
    public void setIntHandler(Handler<AsyncResult<Set<Integer>>> resultHandler) {
        if (this.closed) {
            resultHandler.handle((Object)Future.failedFuture((Throwable)new IllegalStateException("Proxy is closed")));
            return;
        }
        JsonObject _json = new JsonObject();
        DeliveryOptions _deliveryOptions = this._options != null ? new DeliveryOptions(this._options) : new DeliveryOptions();
        _deliveryOptions.addHeader("action", "setIntHandler");
        _deliveryOptions.getHeaders().set("action", "setIntHandler");
        this._vertx.eventBus().request(this._address, (Object)_json, _deliveryOptions, res -> {
            if (res.failed()) {
                resultHandler.handle((Object)Future.failedFuture((Throwable)res.cause()));
            } else {
                resultHandler.handle((Object)Future.succeededFuture((Object)ProxyUtils.convertSet((List)((JsonArray)((Message)res.result()).body()).getList())));
            }
        });
    }

    @Override
    public void setLongHandler(Handler<AsyncResult<Set<Long>>> resultHandler) {
        if (this.closed) {
            resultHandler.handle((Object)Future.failedFuture((Throwable)new IllegalStateException("Proxy is closed")));
            return;
        }
        JsonObject _json = new JsonObject();
        DeliveryOptions _deliveryOptions = this._options != null ? new DeliveryOptions(this._options) : new DeliveryOptions();
        _deliveryOptions.addHeader("action", "setLongHandler");
        _deliveryOptions.getHeaders().set("action", "setLongHandler");
        this._vertx.eventBus().request(this._address, (Object)_json, _deliveryOptions, res -> {
            if (res.failed()) {
                resultHandler.handle((Object)Future.failedFuture((Throwable)res.cause()));
            } else {
                resultHandler.handle((Object)Future.succeededFuture((Object)ProxyUtils.convertSet((List)((JsonArray)((Message)res.result()).body()).getList())));
            }
        });
    }

    @Override
    public void setFloatHandler(Handler<AsyncResult<Set<Float>>> resultHandler) {
        if (this.closed) {
            resultHandler.handle((Object)Future.failedFuture((Throwable)new IllegalStateException("Proxy is closed")));
            return;
        }
        JsonObject _json = new JsonObject();
        DeliveryOptions _deliveryOptions = this._options != null ? new DeliveryOptions(this._options) : new DeliveryOptions();
        _deliveryOptions.addHeader("action", "setFloatHandler");
        _deliveryOptions.getHeaders().set("action", "setFloatHandler");
        this._vertx.eventBus().request(this._address, (Object)_json, _deliveryOptions, res -> {
            if (res.failed()) {
                resultHandler.handle((Object)Future.failedFuture((Throwable)res.cause()));
            } else {
                resultHandler.handle((Object)Future.succeededFuture((Object)ProxyUtils.convertSet((List)((JsonArray)((Message)res.result()).body()).getList())));
            }
        });
    }

    @Override
    public void setDoubleHandler(Handler<AsyncResult<Set<Double>>> resultHandler) {
        if (this.closed) {
            resultHandler.handle((Object)Future.failedFuture((Throwable)new IllegalStateException("Proxy is closed")));
            return;
        }
        JsonObject _json = new JsonObject();
        DeliveryOptions _deliveryOptions = this._options != null ? new DeliveryOptions(this._options) : new DeliveryOptions();
        _deliveryOptions.addHeader("action", "setDoubleHandler");
        _deliveryOptions.getHeaders().set("action", "setDoubleHandler");
        this._vertx.eventBus().request(this._address, (Object)_json, _deliveryOptions, res -> {
            if (res.failed()) {
                resultHandler.handle((Object)Future.failedFuture((Throwable)res.cause()));
            } else {
                resultHandler.handle((Object)Future.succeededFuture((Object)ProxyUtils.convertSet((List)((JsonArray)((Message)res.result()).body()).getList())));
            }
        });
    }

    @Override
    public void setCharHandler(Handler<AsyncResult<Set<Character>>> resultHandler) {
        if (this.closed) {
            resultHandler.handle((Object)Future.failedFuture((Throwable)new IllegalStateException("Proxy is closed")));
            return;
        }
        JsonObject _json = new JsonObject();
        DeliveryOptions _deliveryOptions = this._options != null ? new DeliveryOptions(this._options) : new DeliveryOptions();
        _deliveryOptions.addHeader("action", "setCharHandler");
        _deliveryOptions.getHeaders().set("action", "setCharHandler");
        this._vertx.eventBus().request(this._address, (Object)_json, _deliveryOptions, res -> {
            if (res.failed()) {
                resultHandler.handle((Object)Future.failedFuture((Throwable)res.cause()));
            } else {
                resultHandler.handle((Object)Future.succeededFuture((Object)ProxyUtils.convertToSetChar((JsonArray)((JsonArray)((Message)res.result()).body()))));
            }
        });
    }

    @Override
    public void setBoolHandler(Handler<AsyncResult<Set<Boolean>>> resultHandler) {
        if (this.closed) {
            resultHandler.handle((Object)Future.failedFuture((Throwable)new IllegalStateException("Proxy is closed")));
            return;
        }
        JsonObject _json = new JsonObject();
        DeliveryOptions _deliveryOptions = this._options != null ? new DeliveryOptions(this._options) : new DeliveryOptions();
        _deliveryOptions.addHeader("action", "setBoolHandler");
        _deliveryOptions.getHeaders().set("action", "setBoolHandler");
        this._vertx.eventBus().request(this._address, (Object)_json, _deliveryOptions, res -> {
            if (res.failed()) {
                resultHandler.handle((Object)Future.failedFuture((Throwable)res.cause()));
            } else {
                resultHandler.handle((Object)Future.succeededFuture((Object)ProxyUtils.convertSet((List)((JsonArray)((Message)res.result()).body()).getList())));
            }
        });
    }

    @Override
    public void mapStringHandler(Handler<AsyncResult<Map<String, String>>> resultHandler) {
        if (this.closed) {
            resultHandler.handle((Object)Future.failedFuture((Throwable)new IllegalStateException("Proxy is closed")));
            return;
        }
        JsonObject _json = new JsonObject();
        DeliveryOptions _deliveryOptions = this._options != null ? new DeliveryOptions(this._options) : new DeliveryOptions();
        _deliveryOptions.addHeader("action", "mapStringHandler");
        _deliveryOptions.getHeaders().set("action", "mapStringHandler");
        this._vertx.eventBus().request(this._address, (Object)_json, _deliveryOptions, res -> {
            if (res.failed()) {
                resultHandler.handle((Object)Future.failedFuture((Throwable)res.cause()));
            } else {
                resultHandler.handle((Object)Future.succeededFuture((Object)ProxyUtils.convertMap((Map)((JsonObject)((Message)res.result()).body()).getMap())));
            }
        });
    }

    @Override
    public void mapByteHandler(Handler<AsyncResult<Map<String, Byte>>> resultHandler) {
        if (this.closed) {
            resultHandler.handle((Object)Future.failedFuture((Throwable)new IllegalStateException("Proxy is closed")));
            return;
        }
        JsonObject _json = new JsonObject();
        DeliveryOptions _deliveryOptions = this._options != null ? new DeliveryOptions(this._options) : new DeliveryOptions();
        _deliveryOptions.addHeader("action", "mapByteHandler");
        _deliveryOptions.getHeaders().set("action", "mapByteHandler");
        this._vertx.eventBus().request(this._address, (Object)_json, _deliveryOptions, res -> {
            if (res.failed()) {
                resultHandler.handle((Object)Future.failedFuture((Throwable)res.cause()));
            } else {
                resultHandler.handle((Object)Future.succeededFuture((Object)ProxyUtils.convertMap((Map)((JsonObject)((Message)res.result()).body()).getMap())));
            }
        });
    }

    @Override
    public void mapShortHandler(Handler<AsyncResult<Map<String, Short>>> resultHandler) {
        if (this.closed) {
            resultHandler.handle((Object)Future.failedFuture((Throwable)new IllegalStateException("Proxy is closed")));
            return;
        }
        JsonObject _json = new JsonObject();
        DeliveryOptions _deliveryOptions = this._options != null ? new DeliveryOptions(this._options) : new DeliveryOptions();
        _deliveryOptions.addHeader("action", "mapShortHandler");
        _deliveryOptions.getHeaders().set("action", "mapShortHandler");
        this._vertx.eventBus().request(this._address, (Object)_json, _deliveryOptions, res -> {
            if (res.failed()) {
                resultHandler.handle((Object)Future.failedFuture((Throwable)res.cause()));
            } else {
                resultHandler.handle((Object)Future.succeededFuture((Object)ProxyUtils.convertMap((Map)((JsonObject)((Message)res.result()).body()).getMap())));
            }
        });
    }

    @Override
    public void mapIntHandler(Handler<AsyncResult<Map<String, Integer>>> resultHandler) {
        if (this.closed) {
            resultHandler.handle((Object)Future.failedFuture((Throwable)new IllegalStateException("Proxy is closed")));
            return;
        }
        JsonObject _json = new JsonObject();
        DeliveryOptions _deliveryOptions = this._options != null ? new DeliveryOptions(this._options) : new DeliveryOptions();
        _deliveryOptions.addHeader("action", "mapIntHandler");
        _deliveryOptions.getHeaders().set("action", "mapIntHandler");
        this._vertx.eventBus().request(this._address, (Object)_json, _deliveryOptions, res -> {
            if (res.failed()) {
                resultHandler.handle((Object)Future.failedFuture((Throwable)res.cause()));
            } else {
                resultHandler.handle((Object)Future.succeededFuture((Object)ProxyUtils.convertMap((Map)((JsonObject)((Message)res.result()).body()).getMap())));
            }
        });
    }

    @Override
    public void mapLongHandler(Handler<AsyncResult<Map<String, Long>>> resultHandler) {
        if (this.closed) {
            resultHandler.handle((Object)Future.failedFuture((Throwable)new IllegalStateException("Proxy is closed")));
            return;
        }
        JsonObject _json = new JsonObject();
        DeliveryOptions _deliveryOptions = this._options != null ? new DeliveryOptions(this._options) : new DeliveryOptions();
        _deliveryOptions.addHeader("action", "mapLongHandler");
        _deliveryOptions.getHeaders().set("action", "mapLongHandler");
        this._vertx.eventBus().request(this._address, (Object)_json, _deliveryOptions, res -> {
            if (res.failed()) {
                resultHandler.handle((Object)Future.failedFuture((Throwable)res.cause()));
            } else {
                resultHandler.handle((Object)Future.succeededFuture((Object)ProxyUtils.convertMap((Map)((JsonObject)((Message)res.result()).body()).getMap())));
            }
        });
    }

    @Override
    public void mapFloatHandler(Handler<AsyncResult<Map<String, Float>>> resultHandler) {
        if (this.closed) {
            resultHandler.handle((Object)Future.failedFuture((Throwable)new IllegalStateException("Proxy is closed")));
            return;
        }
        JsonObject _json = new JsonObject();
        DeliveryOptions _deliveryOptions = this._options != null ? new DeliveryOptions(this._options) : new DeliveryOptions();
        _deliveryOptions.addHeader("action", "mapFloatHandler");
        _deliveryOptions.getHeaders().set("action", "mapFloatHandler");
        this._vertx.eventBus().request(this._address, (Object)_json, _deliveryOptions, res -> {
            if (res.failed()) {
                resultHandler.handle((Object)Future.failedFuture((Throwable)res.cause()));
            } else {
                resultHandler.handle((Object)Future.succeededFuture((Object)ProxyUtils.convertMap((Map)((JsonObject)((Message)res.result()).body()).getMap())));
            }
        });
    }

    @Override
    public void mapDoubleHandler(Handler<AsyncResult<Map<String, Double>>> resultHandler) {
        if (this.closed) {
            resultHandler.handle((Object)Future.failedFuture((Throwable)new IllegalStateException("Proxy is closed")));
            return;
        }
        JsonObject _json = new JsonObject();
        DeliveryOptions _deliveryOptions = this._options != null ? new DeliveryOptions(this._options) : new DeliveryOptions();
        _deliveryOptions.addHeader("action", "mapDoubleHandler");
        _deliveryOptions.getHeaders().set("action", "mapDoubleHandler");
        this._vertx.eventBus().request(this._address, (Object)_json, _deliveryOptions, res -> {
            if (res.failed()) {
                resultHandler.handle((Object)Future.failedFuture((Throwable)res.cause()));
            } else {
                resultHandler.handle((Object)Future.succeededFuture((Object)ProxyUtils.convertMap((Map)((JsonObject)((Message)res.result()).body()).getMap())));
            }
        });
    }

    @Override
    public void mapCharHandler(Handler<AsyncResult<Map<String, Character>>> resultHandler) {
        if (this.closed) {
            resultHandler.handle((Object)Future.failedFuture((Throwable)new IllegalStateException("Proxy is closed")));
            return;
        }
        JsonObject _json = new JsonObject();
        DeliveryOptions _deliveryOptions = this._options != null ? new DeliveryOptions(this._options) : new DeliveryOptions();
        _deliveryOptions.addHeader("action", "mapCharHandler");
        _deliveryOptions.getHeaders().set("action", "mapCharHandler");
        this._vertx.eventBus().request(this._address, (Object)_json, _deliveryOptions, res -> {
            if (res.failed()) {
                resultHandler.handle((Object)Future.failedFuture((Throwable)res.cause()));
            } else {
                resultHandler.handle((Object)Future.succeededFuture((Object)ProxyUtils.convertToMapChar((JsonObject)((JsonObject)((Message)res.result()).body()))));
            }
        });
    }

    @Override
    public void mapBoolHandler(Handler<AsyncResult<Map<String, Boolean>>> resultHandler) {
        if (this.closed) {
            resultHandler.handle((Object)Future.failedFuture((Throwable)new IllegalStateException("Proxy is closed")));
            return;
        }
        JsonObject _json = new JsonObject();
        DeliveryOptions _deliveryOptions = this._options != null ? new DeliveryOptions(this._options) : new DeliveryOptions();
        _deliveryOptions.addHeader("action", "mapBoolHandler");
        _deliveryOptions.getHeaders().set("action", "mapBoolHandler");
        this._vertx.eventBus().request(this._address, (Object)_json, _deliveryOptions, res -> {
            if (res.failed()) {
                resultHandler.handle((Object)Future.failedFuture((Throwable)res.cause()));
            } else {
                resultHandler.handle((Object)Future.succeededFuture((Object)ProxyUtils.convertMap((Map)((JsonObject)((Message)res.result()).body()).getMap())));
            }
        });
    }

    @Override
    public void setJsonObjectHandler(Handler<AsyncResult<Set<JsonObject>>> resultHandler) {
        if (this.closed) {
            resultHandler.handle((Object)Future.failedFuture((Throwable)new IllegalStateException("Proxy is closed")));
            return;
        }
        JsonObject _json = new JsonObject();
        DeliveryOptions _deliveryOptions = this._options != null ? new DeliveryOptions(this._options) : new DeliveryOptions();
        _deliveryOptions.addHeader("action", "setJsonObjectHandler");
        _deliveryOptions.getHeaders().set("action", "setJsonObjectHandler");
        this._vertx.eventBus().request(this._address, (Object)_json, _deliveryOptions, res -> {
            if (res.failed()) {
                resultHandler.handle((Object)Future.failedFuture((Throwable)res.cause()));
            } else {
                resultHandler.handle((Object)Future.succeededFuture((Object)ProxyUtils.convertSet((List)((JsonArray)((Message)res.result()).body()).getList())));
            }
        });
    }

    @Override
    public void mapJsonObjectHandler(Handler<AsyncResult<Map<String, JsonObject>>> resultHandler) {
        if (this.closed) {
            resultHandler.handle((Object)Future.failedFuture((Throwable)new IllegalStateException("Proxy is closed")));
            return;
        }
        JsonObject _json = new JsonObject();
        DeliveryOptions _deliveryOptions = this._options != null ? new DeliveryOptions(this._options) : new DeliveryOptions();
        _deliveryOptions.addHeader("action", "mapJsonObjectHandler");
        _deliveryOptions.getHeaders().set("action", "mapJsonObjectHandler");
        this._vertx.eventBus().request(this._address, (Object)_json, _deliveryOptions, res -> {
            if (res.failed()) {
                resultHandler.handle((Object)Future.failedFuture((Throwable)res.cause()));
            } else {
                resultHandler.handle((Object)Future.succeededFuture((Object)ProxyUtils.convertMap((Map)((JsonObject)((Message)res.result()).body()).getMap())));
            }
        });
    }

    @Override
    public void setJsonArrayHandler(Handler<AsyncResult<Set<JsonArray>>> resultHandler) {
        if (this.closed) {
            resultHandler.handle((Object)Future.failedFuture((Throwable)new IllegalStateException("Proxy is closed")));
            return;
        }
        JsonObject _json = new JsonObject();
        DeliveryOptions _deliveryOptions = this._options != null ? new DeliveryOptions(this._options) : new DeliveryOptions();
        _deliveryOptions.addHeader("action", "setJsonArrayHandler");
        _deliveryOptions.getHeaders().set("action", "setJsonArrayHandler");
        this._vertx.eventBus().request(this._address, (Object)_json, _deliveryOptions, res -> {
            if (res.failed()) {
                resultHandler.handle((Object)Future.failedFuture((Throwable)res.cause()));
            } else {
                resultHandler.handle((Object)Future.succeededFuture((Object)ProxyUtils.convertSet((List)((JsonArray)((Message)res.result()).body()).getList())));
            }
        });
    }

    @Override
    public void mapJsonArrayHandler(Handler<AsyncResult<Map<String, JsonArray>>> resultHandler) {
        if (this.closed) {
            resultHandler.handle((Object)Future.failedFuture((Throwable)new IllegalStateException("Proxy is closed")));
            return;
        }
        JsonObject _json = new JsonObject();
        DeliveryOptions _deliveryOptions = this._options != null ? new DeliveryOptions(this._options) : new DeliveryOptions();
        _deliveryOptions.addHeader("action", "mapJsonArrayHandler");
        _deliveryOptions.getHeaders().set("action", "mapJsonArrayHandler");
        this._vertx.eventBus().request(this._address, (Object)_json, _deliveryOptions, res -> {
            if (res.failed()) {
                resultHandler.handle((Object)Future.failedFuture((Throwable)res.cause()));
            } else {
                resultHandler.handle((Object)Future.succeededFuture((Object)ProxyUtils.convertMap((Map)((JsonObject)((Message)res.result()).body()).getMap())));
            }
        });
    }

    @Override
    public void setDataObjectHandler(Handler<AsyncResult<Set<TestDataObject>>> resultHandler) {
        if (this.closed) {
            resultHandler.handle((Object)Future.failedFuture((Throwable)new IllegalStateException("Proxy is closed")));
            return;
        }
        JsonObject _json = new JsonObject();
        DeliveryOptions _deliveryOptions = this._options != null ? new DeliveryOptions(this._options) : new DeliveryOptions();
        _deliveryOptions.addHeader("action", "setDataObjectHandler");
        _deliveryOptions.getHeaders().set("action", "setDataObjectHandler");
        this._vertx.eventBus().request(this._address, (Object)_json, _deliveryOptions, res -> {
            if (res.failed()) {
                resultHandler.handle((Object)Future.failedFuture((Throwable)res.cause()));
            } else {
                resultHandler.handle((Object)Future.succeededFuture(((JsonArray)((Message)res.result()).body()).stream().map(v -> v != null ? new TestDataObject((JsonObject)v) : null).collect(Collectors.toSet())));
            }
        });
    }

    @Override
    public void mapDataObject(Handler<AsyncResult<Map<String, TestDataObject>>> resultHandler) {
        if (this.closed) {
            resultHandler.handle((Object)Future.failedFuture((Throwable)new IllegalStateException("Proxy is closed")));
            return;
        }
        JsonObject _json = new JsonObject();
        DeliveryOptions _deliveryOptions = this._options != null ? new DeliveryOptions(this._options) : new DeliveryOptions();
        _deliveryOptions.addHeader("action", "mapDataObject");
        _deliveryOptions.getHeaders().set("action", "mapDataObject");
        this._vertx.eventBus().request(this._address, (Object)_json, _deliveryOptions, res -> {
            if (res.failed()) {
                resultHandler.handle((Object)Future.failedFuture((Throwable)res.cause()));
            } else {
                resultHandler.handle((Object)Future.succeededFuture(((JsonObject)((Message)res.result()).body()).stream().collect(Collectors.toMap(Map.Entry::getKey, e -> e.getValue() != null ? new TestDataObject((JsonObject)e.getValue()) : null))));
            }
        });
    }

    @Override
    public void failingCall(String value, Handler<AsyncResult<JsonObject>> resultHandler) {
        if (this.closed) {
            resultHandler.handle((Object)Future.failedFuture((Throwable)new IllegalStateException("Proxy is closed")));
            return;
        }
        JsonObject _json = new JsonObject();
        _json.put("value", (Object)value);
        DeliveryOptions _deliveryOptions = this._options != null ? new DeliveryOptions(this._options) : new DeliveryOptions();
        _deliveryOptions.addHeader("action", "failingCall");
        _deliveryOptions.getHeaders().set("action", "failingCall");
        this._vertx.eventBus().request(this._address, (Object)_json, _deliveryOptions, res -> {
            if (res.failed()) {
                resultHandler.handle((Object)Future.failedFuture((Throwable)res.cause()));
            } else {
                resultHandler.handle((Object)Future.succeededFuture((Object)((Message)res.result()).body()));
            }
        });
    }

    @Override
    public void listDataObjectContainingNullHandler(Handler<AsyncResult<List<TestDataObject>>> resultHandler) {
        if (this.closed) {
            resultHandler.handle((Object)Future.failedFuture((Throwable)new IllegalStateException("Proxy is closed")));
            return;
        }
        JsonObject _json = new JsonObject();
        DeliveryOptions _deliveryOptions = this._options != null ? new DeliveryOptions(this._options) : new DeliveryOptions();
        _deliveryOptions.addHeader("action", "listDataObjectContainingNullHandler");
        _deliveryOptions.getHeaders().set("action", "listDataObjectContainingNullHandler");
        this._vertx.eventBus().request(this._address, (Object)_json, _deliveryOptions, res -> {
            if (res.failed()) {
                resultHandler.handle((Object)Future.failedFuture((Throwable)res.cause()));
            } else {
                resultHandler.handle((Object)Future.succeededFuture(((JsonArray)((Message)res.result()).body()).stream().map(v -> v != null ? new TestDataObject((JsonObject)v) : null).collect(Collectors.toList())));
            }
        });
    }

    @Override
    public void setDataObjectContainingNullHandler(Handler<AsyncResult<Set<TestDataObject>>> resultHandler) {
        if (this.closed) {
            resultHandler.handle((Object)Future.failedFuture((Throwable)new IllegalStateException("Proxy is closed")));
            return;
        }
        JsonObject _json = new JsonObject();
        DeliveryOptions _deliveryOptions = this._options != null ? new DeliveryOptions(this._options) : new DeliveryOptions();
        _deliveryOptions.addHeader("action", "setDataObjectContainingNullHandler");
        _deliveryOptions.getHeaders().set("action", "setDataObjectContainingNullHandler");
        this._vertx.eventBus().request(this._address, (Object)_json, _deliveryOptions, res -> {
            if (res.failed()) {
                resultHandler.handle((Object)Future.failedFuture((Throwable)res.cause()));
            } else {
                resultHandler.handle((Object)Future.succeededFuture(((JsonArray)((Message)res.result()).body()).stream().map(v -> v != null ? new TestDataObject((JsonObject)v) : null).collect(Collectors.toSet())));
            }
        });
    }

    @Override
    public void zonedDateTimeHandler(Handler<AsyncResult<ZonedDateTime>> resultHandler) {
        if (this.closed) {
            resultHandler.handle((Object)Future.failedFuture((Throwable)new IllegalStateException("Proxy is closed")));
            return;
        }
        JsonObject _json = new JsonObject();
        DeliveryOptions _deliveryOptions = this._options != null ? new DeliveryOptions(this._options) : new DeliveryOptions();
        _deliveryOptions.addHeader("action", "zonedDateTimeHandler");
        _deliveryOptions.getHeaders().set("action", "zonedDateTimeHandler");
        this._vertx.eventBus().request(this._address, (Object)_json, _deliveryOptions, res -> {
            if (res.failed()) {
                resultHandler.handle((Object)Future.failedFuture((Throwable)res.cause()));
            } else {
                resultHandler.handle((Object)Future.succeededFuture(((Message)res.result()).body() != null ? Mappers.deserializeZonedDateTime((String)((Message)res.result()).body()) : null));
            }
        });
    }

    @Override
    public void listZonedDateTimeHandler(Handler<AsyncResult<List<ZonedDateTime>>> resultHandler) {
        if (this.closed) {
            resultHandler.handle((Object)Future.failedFuture((Throwable)new IllegalStateException("Proxy is closed")));
            return;
        }
        JsonObject _json = new JsonObject();
        DeliveryOptions _deliveryOptions = this._options != null ? new DeliveryOptions(this._options) : new DeliveryOptions();
        _deliveryOptions.addHeader("action", "listZonedDateTimeHandler");
        _deliveryOptions.getHeaders().set("action", "listZonedDateTimeHandler");
        this._vertx.eventBus().request(this._address, (Object)_json, _deliveryOptions, res -> {
            if (res.failed()) {
                resultHandler.handle((Object)Future.failedFuture((Throwable)res.cause()));
            } else {
                resultHandler.handle((Object)Future.succeededFuture(((JsonArray)((Message)res.result()).body()).stream().map(v -> v != null ? Mappers.deserializeZonedDateTime((String)v) : null).collect(Collectors.toList())));
            }
        });
    }

    @Override
    public void setZonedDateTimeHandler(Handler<AsyncResult<Set<ZonedDateTime>>> resultHandler) {
        if (this.closed) {
            resultHandler.handle((Object)Future.failedFuture((Throwable)new IllegalStateException("Proxy is closed")));
            return;
        }
        JsonObject _json = new JsonObject();
        DeliveryOptions _deliveryOptions = this._options != null ? new DeliveryOptions(this._options) : new DeliveryOptions();
        _deliveryOptions.addHeader("action", "setZonedDateTimeHandler");
        _deliveryOptions.getHeaders().set("action", "setZonedDateTimeHandler");
        this._vertx.eventBus().request(this._address, (Object)_json, _deliveryOptions, res -> {
            if (res.failed()) {
                resultHandler.handle((Object)Future.failedFuture((Throwable)res.cause()));
            } else {
                resultHandler.handle((Object)Future.succeededFuture(((JsonArray)((Message)res.result()).body()).stream().map(v -> v != null ? Mappers.deserializeZonedDateTime((String)v) : null).collect(Collectors.toSet())));
            }
        });
    }

    @Override
    public void mapZonedDateTimeHandler(Handler<AsyncResult<Map<String, ZonedDateTime>>> resultHandler) {
        if (this.closed) {
            resultHandler.handle((Object)Future.failedFuture((Throwable)new IllegalStateException("Proxy is closed")));
            return;
        }
        JsonObject _json = new JsonObject();
        DeliveryOptions _deliveryOptions = this._options != null ? new DeliveryOptions(this._options) : new DeliveryOptions();
        _deliveryOptions.addHeader("action", "mapZonedDateTimeHandler");
        _deliveryOptions.getHeaders().set("action", "mapZonedDateTimeHandler");
        this._vertx.eventBus().request(this._address, (Object)_json, _deliveryOptions, res -> {
            if (res.failed()) {
                resultHandler.handle((Object)Future.failedFuture((Throwable)res.cause()));
            } else {
                resultHandler.handle((Object)Future.succeededFuture(((JsonObject)((Message)res.result()).body()).stream().collect(Collectors.toMap(Map.Entry::getKey, e -> e.getValue() != null ? Mappers.deserializeZonedDateTime((String)e.getValue()) : null))));
            }
        });
    }

    @Override
    public void ignoredMethod() {
    }
}

