/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.serviceproxy.testmodel.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.VertxException;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.serviceproxy.ServiceException;
import io.vertx.serviceproxy.testmodel.MyServiceException;
import io.vertx.serviceproxy.testmodel.SomeEnum;
import io.vertx.serviceproxy.testmodel.SomeEnumWithCustomConstructor;
import io.vertx.serviceproxy.testmodel.TestConnection;
import io.vertx.serviceproxy.testmodel.TestDataObject;
import io.vertx.serviceproxy.testmodel.TestService;
import io.vertx.serviceproxy.testmodel.impl.TestConnectionImpl;
import io.vertx.serviceproxy.testmodel.impl.TestSubConnectionImpl;
import io.vertx.serviceproxy.testmodel.sub.TestSubConnection;
import java.time.ZonedDateTime;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.junit.Assert;

public class TestServiceImpl
implements TestService {
    private final Vertx vertx;

    public TestServiceImpl(Vertx vertx) throws Exception {
        this.vertx = vertx;
    }

    @Override
    public void createConnection(String str, Handler<AsyncResult<TestConnection>> resultHandler) {
        resultHandler.handle((Object)Future.succeededFuture((Object)new TestConnectionImpl(this.vertx, str)));
    }

    @Override
    public void createSubConnection(String str, Handler<AsyncResult<TestSubConnection>> resultHandler) {
        resultHandler.handle((Object)Future.succeededFuture((Object)new TestSubConnectionImpl(this.vertx, str)));
    }

    @Override
    public void noParams() {
        this.vertx.eventBus().send("testaddress", (Object)"ok");
    }

    @Override
    public void basicTypes(String str, byte b, short s, int i, long l, float f, double d, char c, boolean bool) {
        Assert.assertEquals((Object)"foo", (Object)str);
        Assert.assertEquals((long)123L, (long)b);
        Assert.assertEquals((long)1234L, (long)s);
        Assert.assertEquals((long)12345L, (long)i);
        Assert.assertEquals((long)123456L, (long)l);
        Assert.assertEquals((long)12345L, (long)i);
        Assert.assertEquals((float)12.34f, (float)f, (float)0.0f);
        Assert.assertEquals((double)12.3456, (double)d, (double)0.0);
        Assert.assertEquals((long)88L, (long)c);
        Assert.assertEquals((Object)true, (Object)bool);
        this.vertx.eventBus().send("testaddress", (Object)"ok");
    }

    @Override
    public void basicBoxedTypes(String str, Byte b, Short s, Integer i, Long l, Float f, Double d, Character c, Boolean bool) {
        this.basicTypes(str, b, s, i, l, f.floatValue(), d, c.charValue(), bool);
    }

    @Override
    public void basicBoxedTypesNull(String str, Byte b, Short s, Integer i, Long l, Float f, Double d, Character c, Boolean bool) {
        Assert.assertNull((Object)str);
        Assert.assertNull((Object)b);
        Assert.assertNull((Object)s);
        Assert.assertNull((Object)i);
        Assert.assertNull((Object)l);
        Assert.assertNull((Object)f);
        Assert.assertNull((Object)d);
        Assert.assertNull((Object)c);
        Assert.assertNull((Object)bool);
        this.vertx.eventBus().send("testaddress", (Object)"ok");
    }

    @Override
    public void jsonTypes(JsonObject jsonObject, JsonArray jsonArray) {
        Assert.assertEquals((Object)"bar", (Object)jsonObject.getString("foo"));
        Assert.assertEquals((Object)"wibble", (Object)jsonArray.getString(0));
        this.vertx.eventBus().send("testaddress", (Object)"ok");
    }

    @Override
    public void jsonTypesNull(JsonObject jsonObject, JsonArray jsonArray) {
        Assert.assertNull((Object)jsonObject);
        Assert.assertNull((Object)jsonArray);
        this.vertx.eventBus().send("testaddress", (Object)"ok");
    }

    @Override
    public void enumType(SomeEnum someEnum) {
        Assert.assertEquals((Object)((Object)SomeEnum.WIBBLE), (Object)((Object)someEnum));
        this.vertx.eventBus().send("testaddress", (Object)"ok");
    }

    @Override
    public void enumTypeNull(SomeEnum someEnum) {
        Assert.assertNull((Object)((Object)someEnum));
        this.vertx.eventBus().send("testaddress", (Object)"ok");
    }

    @Override
    public void enumTypeAsResult(Handler<AsyncResult<SomeEnum>> handler) {
        handler.handle((Object)Future.succeededFuture((Object)((Object)SomeEnum.WIBBLE)));
    }

    @Override
    public void enumTypeAsResultNull(Handler<AsyncResult<SomeEnum>> handler) {
        handler.handle((Object)Future.succeededFuture(null));
    }

    @Override
    public void enumCustomType(SomeEnumWithCustomConstructor someEnum) {
        Assert.assertEquals((Object)((Object)SomeEnumWithCustomConstructor.ITEST), (Object)((Object)someEnum));
        this.vertx.eventBus().send("testaddress", (Object)"ok");
    }

    @Override
    public void enumCustomTypeNull(SomeEnumWithCustomConstructor someEnum) {
        Assert.assertNull((Object)((Object)someEnum));
        this.vertx.eventBus().send("testaddress", (Object)"ok");
    }

    @Override
    public void enumCustomTypeAsResult(Handler<AsyncResult<SomeEnumWithCustomConstructor>> handler) {
        handler.handle((Object)Future.succeededFuture((Object)((Object)SomeEnumWithCustomConstructor.ITEST)));
    }

    @Override
    public void enumCustomTypeAsResultNull(Handler<AsyncResult<SomeEnumWithCustomConstructor>> handler) {
        handler.handle((Object)Future.succeededFuture(null));
    }

    @Override
    public void dataObjectType(TestDataObject options) {
        Assert.assertEquals((Object)new TestDataObject().setString("foo").setNumber(123).setBool(true), (Object)options);
        this.vertx.eventBus().send("testaddress", (Object)"ok");
    }

    @Override
    public void listdataObjectType(List<TestDataObject> list) {
        Assert.assertEquals((long)2L, (long)list.size());
        Assert.assertEquals((Object)new TestDataObject().setString("foo").setNumber(123).setBool(true), (Object)list.get(0));
        Assert.assertEquals((Object)new TestDataObject().setString("bar").setNumber(456).setBool(false), (Object)list.get(1));
        this.vertx.eventBus().send("testaddress", (Object)"ok");
    }

    @Override
    public void setdataObjectType(Set<TestDataObject> set) {
        Set setJson = set.stream().map(d -> d.toJson()).collect(Collectors.toSet());
        Assert.assertEquals((long)2L, (long)setJson.size());
        Assert.assertTrue((boolean)setJson.contains(new JsonObject().put("number", (Object)123).put("string", (Object)"String foo").put("bool", (Object)true)));
        Assert.assertTrue((boolean)setJson.contains(new JsonObject().put("number", (Object)456).put("string", (Object)"String bar").put("bool", (Object)false)));
        this.vertx.eventBus().send("testaddress", (Object)"ok");
    }

    @Override
    public void dataObjectTypeNull(TestDataObject options) {
        Assert.assertNull((Object)options);
        this.vertx.eventBus().send("testaddress", (Object)"ok");
    }

    @Override
    public void dateTimeType(ZonedDateTime dateTime) {
        Assert.assertEquals((Object)ZonedDateTime.parse("2019-03-25T17:08:31.069+01:00[Europe/Rome]"), (Object)dateTime);
        this.vertx.eventBus().send("testaddress", (Object)"ok");
    }

    @Override
    public void listDateTimeType(List<ZonedDateTime> list) {
        Assert.assertEquals((long)2L, (long)list.size());
        Assert.assertEquals((Object)ZonedDateTime.parse("2019-03-25T17:08:31.069+01:00[Europe/Rome]"), (Object)list.get(0));
        Assert.assertEquals((Object)ZonedDateTime.parse("2019-03-25T17:08:31.069+01:00[Europe/Rome]").plusHours(1L), (Object)list.get(1));
        this.vertx.eventBus().send("testaddress", (Object)"ok");
    }

    @Override
    public void setDateTimeType(Set<ZonedDateTime> set) {
        Assert.assertEquals((long)2L, (long)set.size());
        Assert.assertTrue((boolean)set.contains(ZonedDateTime.parse("2019-03-25T17:08:31.069+01:00[Europe/Rome]")));
        Assert.assertTrue((boolean)set.contains(ZonedDateTime.parse("2019-03-25T17:08:31.069+01:00[Europe/Rome]").plusHours(1L)));
        this.vertx.eventBus().send("testaddress", (Object)"ok");
    }

    @Override
    public void mapDateTimeType(Map<String, ZonedDateTime> map) {
        HashMap<String, ZonedDateTime> expected = new HashMap<String, ZonedDateTime>();
        expected.put("date1", ZonedDateTime.parse("2019-03-25T17:08:31.069+01:00[Europe/Rome]"));
        expected.put("date2", ZonedDateTime.parse("2019-03-25T17:08:31.069+01:00[Europe/Rome]").plusHours(1L));
        Assert.assertEquals(expected, map);
        this.vertx.eventBus().send("testaddress", (Object)"ok");
    }

    @Override
    public void listdataObjectTypeHavingNullValues(List<TestDataObject> list) {
        Assert.assertEquals((long)3L, (long)list.size());
        Assert.assertEquals((Object)new TestDataObject().setString("foo").setNumber(123).setBool(true), (Object)list.get(0));
        Assert.assertNull((Object)list.get(1));
        Assert.assertEquals((Object)new TestDataObject().setString("bar").setNumber(456).setBool(false), (Object)list.get(2));
        this.vertx.eventBus().send("testaddress", (Object)"ok");
    }

    @Override
    public void setdataObjectTypeHavingNullValues(Set<TestDataObject> set) {
        Set setJson = set.stream().map(d -> null == d ? null : d.toJson()).collect(Collectors.toSet());
        Assert.assertEquals((long)3L, (long)setJson.size());
        Assert.assertTrue((boolean)setJson.contains(new JsonObject().put("number", (Object)123).put("string", (Object)"String foo").put("bool", (Object)true)));
        Assert.assertTrue((boolean)setJson.contains(new JsonObject().put("number", (Object)456).put("string", (Object)"String bar").put("bool", (Object)false)));
        Assert.assertTrue((boolean)setJson.contains(null));
        this.vertx.eventBus().send("testaddress", (Object)"ok");
    }

    @Override
    public void listParams(List<String> listString, List<Byte> listByte, List<Short> listShort, List<Integer> listInt, List<Long> listLong, List<JsonObject> listJsonObject, List<JsonArray> listJsonArray, List<TestDataObject> listDataObject) {
        Assert.assertEquals((Object)"foo", (Object)listString.get(0));
        Assert.assertEquals((Object)"bar", (Object)listString.get(1));
        Assert.assertEquals((long)12L, (long)listByte.get(0).byteValue());
        Assert.assertEquals((long)13L, (long)listByte.get(1).byteValue());
        Assert.assertEquals((long)123L, (long)listShort.get(0).shortValue());
        Assert.assertEquals((long)134L, (long)listShort.get(1).shortValue());
        Assert.assertEquals((long)1234L, (long)listInt.get(0).intValue());
        Assert.assertEquals((long)1235L, (long)listInt.get(1).intValue());
        Assert.assertEquals((long)12345L, (long)listLong.get(0));
        Assert.assertEquals((long)12346L, (long)listLong.get(1));
        Assert.assertEquals((Object)new JsonObject().put("foo", (Object)"bar"), (Object)listJsonObject.get(0));
        Assert.assertEquals((Object)new JsonObject().put("blah", (Object)"eek"), (Object)listJsonObject.get(1));
        Assert.assertEquals((Object)new JsonArray().add((Object)"foo"), (Object)listJsonArray.get(0));
        Assert.assertEquals((Object)new JsonArray().add((Object)"blah"), (Object)listJsonArray.get(1));
        Assert.assertEquals((Object)new JsonObject().put("number", (Object)1).put("string", (Object)"String 1").put("bool", (Object)false), (Object)listDataObject.get(0).toJson());
        Assert.assertEquals((Object)new JsonObject().put("number", (Object)2).put("string", (Object)"String 2").put("bool", (Object)true), (Object)listDataObject.get(1).toJson());
        this.vertx.eventBus().send("testaddress", (Object)"ok");
    }

    @Override
    public void setParams(Set<String> setString, Set<Byte> setByte, Set<Short> setShort, Set<Integer> setInt, Set<Long> setLong, Set<JsonObject> setJsonObject, Set<JsonArray> setJsonArray, Set<TestDataObject> setDataObject) {
        Assert.assertEquals((long)2L, (long)setString.size());
        Assert.assertTrue((boolean)setString.contains("foo"));
        Assert.assertTrue((boolean)setString.contains("bar"));
        Assert.assertEquals((long)2L, (long)setByte.size());
        Assert.assertTrue((boolean)setByte.contains((byte)12));
        Assert.assertTrue((boolean)setByte.contains((byte)13));
        Assert.assertEquals((long)2L, (long)setShort.size());
        Assert.assertTrue((boolean)setShort.contains((short)123));
        Assert.assertTrue((boolean)setShort.contains((short)134));
        Assert.assertEquals((long)2L, (long)setInt.size());
        Assert.assertTrue((boolean)setInt.contains(1234));
        Assert.assertTrue((boolean)setInt.contains(1235));
        Assert.assertEquals((long)2L, (long)setLong.size());
        Assert.assertTrue((boolean)setLong.contains(12345L));
        Assert.assertTrue((boolean)setLong.contains(12346L));
        Assert.assertEquals((long)2L, (long)setJsonObject.size());
        Assert.assertTrue((boolean)setJsonObject.contains(new JsonObject().put("foo", (Object)"bar")));
        Assert.assertTrue((boolean)setJsonObject.contains(new JsonObject().put("blah", (Object)"eek")));
        Assert.assertEquals((long)2L, (long)setJsonArray.size());
        Assert.assertTrue((boolean)setJsonArray.contains(new JsonArray().add((Object)"foo")));
        Assert.assertTrue((boolean)setJsonArray.contains(new JsonArray().add((Object)"blah")));
        Assert.assertEquals((long)2L, (long)setDataObject.size());
        Set setDataObjectJson = setDataObject.stream().map(d -> d.toJson()).collect(Collectors.toSet());
        Assert.assertTrue((boolean)setDataObjectJson.contains(new JsonObject().put("number", (Object)1).put("string", (Object)"String 1").put("bool", (Object)false)));
        Assert.assertTrue((boolean)setDataObjectJson.contains(new JsonObject().put("number", (Object)2).put("string", (Object)"String 2").put("bool", (Object)true)));
        this.vertx.eventBus().send("testaddress", (Object)"ok");
    }

    @Override
    public void mapParams(Map<String, String> mapString, Map<String, Byte> mapByte, Map<String, Short> mapShort, Map<String, Integer> mapInt, Map<String, Long> mapLong, Map<String, JsonObject> mapJsonObject, Map<String, JsonArray> mapJsonArray) {
        Assert.assertEquals((Object)"foo", (Object)mapString.get("eek"));
        Assert.assertEquals((Object)"bar", (Object)mapString.get("wob"));
        Assert.assertEquals((long)12L, (long)mapByte.get("eek").byteValue());
        Assert.assertEquals((long)13L, (long)mapByte.get("wob").byteValue());
        Assert.assertEquals((long)123L, (long)mapShort.get("eek").shortValue());
        Assert.assertEquals((long)134L, (long)mapShort.get("wob").shortValue());
        Assert.assertEquals((long)1234L, (long)mapInt.get("eek").intValue());
        Assert.assertEquals((long)1235L, (long)mapInt.get("wob").intValue());
        Assert.assertEquals((long)12345L, (long)mapLong.get("eek"));
        Assert.assertEquals((long)12356L, (long)mapLong.get("wob"));
        Assert.assertEquals((Object)new JsonObject().put("foo", (Object)"bar"), (Object)mapJsonObject.get("eek"));
        Assert.assertEquals((Object)new JsonObject().put("blah", (Object)"eek"), (Object)mapJsonObject.get("wob"));
        Assert.assertEquals((Object)new JsonArray().add((Object)"foo"), (Object)mapJsonArray.get("eek"));
        Assert.assertEquals((Object)new JsonArray().add((Object)"blah"), (Object)mapJsonArray.get("wob"));
        this.vertx.eventBus().send("testaddress", (Object)"ok");
    }

    @Override
    public void stringHandler(Handler<AsyncResult<String>> resultHandler) {
        resultHandler.handle((Object)Future.succeededFuture((Object)"foobar"));
    }

    @Override
    public void stringNullHandler(Handler<AsyncResult<String>> resultHandler) {
        resultHandler.handle((Object)Future.succeededFuture(null));
    }

    @Override
    public void byteHandler(Handler<AsyncResult<Byte>> resultHandler) {
        resultHandler.handle((Object)Future.succeededFuture((Object)123));
    }

    @Override
    public void byteNullHandler(Handler<AsyncResult<Byte>> resultHandler) {
        resultHandler.handle((Object)Future.succeededFuture(null));
    }

    @Override
    public void shortHandler(Handler<AsyncResult<Short>> resultHandler) {
        resultHandler.handle((Object)Future.succeededFuture((Object)1234));
    }

    @Override
    public void shortNullHandler(Handler<AsyncResult<Short>> resultHandler) {
        resultHandler.handle((Object)Future.succeededFuture(null));
    }

    @Override
    public void intHandler(Handler<AsyncResult<Integer>> resultHandler) {
        resultHandler.handle((Object)Future.succeededFuture((Object)12345));
    }

    @Override
    public void intNullHandler(Handler<AsyncResult<Integer>> resultHandler) {
        resultHandler.handle((Object)Future.succeededFuture(null));
    }

    @Override
    public void longHandler(Handler<AsyncResult<Long>> resultHandler) {
        resultHandler.handle((Object)Future.succeededFuture((Object)123456L));
    }

    @Override
    public void longNullHandler(Handler<AsyncResult<Long>> resultHandler) {
        resultHandler.handle((Object)Future.succeededFuture(null));
    }

    @Override
    public void floatHandler(Handler<AsyncResult<Float>> resultHandler) {
        resultHandler.handle((Object)Future.succeededFuture((Object)Float.valueOf(12.34f)));
    }

    @Override
    public void floatNullHandler(Handler<AsyncResult<Float>> resultHandler) {
        resultHandler.handle((Object)Future.succeededFuture(null));
    }

    @Override
    public void doubleHandler(Handler<AsyncResult<Double>> resultHandler) {
        resultHandler.handle((Object)Future.succeededFuture((Object)12.3456));
    }

    @Override
    public void doubleNullHandler(Handler<AsyncResult<Double>> resultHandler) {
        resultHandler.handle((Object)Future.succeededFuture(null));
    }

    @Override
    public void charHandler(Handler<AsyncResult<Character>> resultHandler) {
        resultHandler.handle((Object)Future.succeededFuture((Object)Character.valueOf('X')));
    }

    @Override
    public void charNullHandler(Handler<AsyncResult<Character>> resultHandler) {
        resultHandler.handle((Object)Future.succeededFuture(null));
    }

    @Override
    public void booleanHandler(Handler<AsyncResult<Boolean>> resultHandler) {
        resultHandler.handle((Object)Future.succeededFuture((Object)true));
    }

    @Override
    public void booleanNullHandler(Handler<AsyncResult<Boolean>> resultHandler) {
        resultHandler.handle((Object)Future.succeededFuture(null));
    }

    @Override
    public void jsonObjectHandler(Handler<AsyncResult<JsonObject>> resultHandler) {
        resultHandler.handle((Object)Future.succeededFuture((Object)new JsonObject().put("blah", (Object)"wibble")));
    }

    @Override
    public void jsonObjectNullHandler(Handler<AsyncResult<JsonObject>> resultHandler) {
        resultHandler.handle((Object)Future.succeededFuture(null));
    }

    @Override
    public void jsonArrayHandler(Handler<AsyncResult<JsonArray>> resultHandler) {
        resultHandler.handle((Object)Future.succeededFuture((Object)new JsonArray().add((Object)"blurrg")));
    }

    @Override
    public void jsonArrayNullHandler(Handler<AsyncResult<JsonArray>> resultHandler) {
        resultHandler.handle((Object)Future.succeededFuture(null));
    }

    @Override
    public void dataObjectHandler(Handler<AsyncResult<TestDataObject>> resultHandler) {
        resultHandler.handle((Object)Future.succeededFuture((Object)new TestDataObject().setString("foo").setNumber(123).setBool(true)));
    }

    @Override
    public void dataObjectNullHandler(Handler<AsyncResult<TestDataObject>> resultHandler) {
        resultHandler.handle((Object)Future.succeededFuture(null));
    }

    @Override
    public void voidHandler(Handler<AsyncResult<Void>> resultHandler) {
        resultHandler.handle((Object)Future.succeededFuture((Object)null));
    }

    @Override
    public TestService fluentMethod(String str, Handler<AsyncResult<String>> resultHandler) {
        Assert.assertEquals((Object)"foo", (Object)str);
        resultHandler.handle((Object)Future.succeededFuture((Object)"bar"));
        return this;
    }

    @Override
    public TestService fluentNoParams() {
        this.vertx.eventBus().send("fluentReceived", (Object)"ok");
        return this;
    }

    @Override
    public void failingMethod(Handler<AsyncResult<JsonObject>> resultHandler) {
        resultHandler.handle((Object)Future.failedFuture((Throwable)new VertxException("wibble")));
    }

    @Override
    public void invokeWithMessage(JsonObject object, String str, int i, char chr, SomeEnum senum, Handler<AsyncResult<String>> resultHandler) {
        Assert.assertEquals((Object)"bar", (Object)object.getString("foo"));
        Assert.assertEquals((Object)"blah", (Object)str);
        Assert.assertEquals((long)1234L, (long)i);
        Assert.assertEquals((long)88L, (long)chr);
        Assert.assertEquals((Object)((Object)SomeEnum.BAR), (Object)((Object)senum));
        resultHandler.handle((Object)Future.succeededFuture((Object)"goats"));
    }

    @Override
    public void listStringHandler(Handler<AsyncResult<List<String>>> resultHandler) {
        List<String> list = Arrays.asList("foo", "bar", "wibble");
        resultHandler.handle((Object)Future.succeededFuture(list));
    }

    @Override
    public void listByteHandler(Handler<AsyncResult<List<Byte>>> resultHandler) {
        List<Byte> list = Arrays.asList((byte)1, (byte)2, (byte)3);
        resultHandler.handle((Object)Future.succeededFuture(list));
    }

    @Override
    public void listShortHandler(Handler<AsyncResult<List<Short>>> resultHandler) {
        List<Short> list = Arrays.asList((short)11, (short)12, (short)13);
        resultHandler.handle((Object)Future.succeededFuture(list));
    }

    @Override
    public void listIntHandler(Handler<AsyncResult<List<Integer>>> resultHandler) {
        List<Integer> list = Arrays.asList(100, 101, 102);
        resultHandler.handle((Object)Future.succeededFuture(list));
    }

    @Override
    public void listLongHandler(Handler<AsyncResult<List<Long>>> resultHandler) {
        List<Long> list = Arrays.asList(1000L, 1001L, 1002L);
        resultHandler.handle((Object)Future.succeededFuture(list));
    }

    @Override
    public void listFloatHandler(Handler<AsyncResult<List<Float>>> resultHandler) {
        List<Float> list = Arrays.asList(Float.valueOf(1.1f), Float.valueOf(1.2f), Float.valueOf(1.3f));
        resultHandler.handle((Object)Future.succeededFuture(list));
    }

    @Override
    public void listDoubleHandler(Handler<AsyncResult<List<Double>>> resultHandler) {
        List<Double> list = Arrays.asList(1.11, 1.12, 1.13);
        resultHandler.handle((Object)Future.succeededFuture(list));
    }

    @Override
    public void listCharHandler(Handler<AsyncResult<List<Character>>> resultHandler) {
        List<Character> list = Arrays.asList(Character.valueOf('X'), Character.valueOf('Y'), Character.valueOf('Z'));
        resultHandler.handle((Object)Future.succeededFuture(list));
    }

    @Override
    public void listBoolHandler(Handler<AsyncResult<List<Boolean>>> resultHandler) {
        List<Boolean> list = Arrays.asList(true, false, true);
        resultHandler.handle((Object)Future.succeededFuture(list));
    }

    @Override
    public void listJsonObjectHandler(Handler<AsyncResult<List<JsonObject>>> resultHandler) {
        List<JsonObject> list = Arrays.asList(new JsonObject().put("a", (Object)"foo"), new JsonObject().put("b", (Object)"bar"), new JsonObject().put("c", (Object)"wibble"));
        resultHandler.handle((Object)Future.succeededFuture(list));
    }

    @Override
    public void listJsonArrayHandler(Handler<AsyncResult<List<JsonArray>>> resultHandler) {
        List<JsonArray> list = Arrays.asList(new JsonArray().add((Object)"foo"), new JsonArray().add((Object)"bar"), new JsonArray().add((Object)"wibble"));
        resultHandler.handle((Object)Future.succeededFuture(list));
    }

    @Override
    public void setStringHandler(Handler<AsyncResult<Set<String>>> resultHandler) {
        LinkedHashSet<String> set = new LinkedHashSet<String>(Arrays.asList("foo", "bar", "wibble"));
        resultHandler.handle((Object)Future.succeededFuture(set));
    }

    @Override
    public void setByteHandler(Handler<AsyncResult<Set<Byte>>> resultHandler) {
        LinkedHashSet<Byte> set = new LinkedHashSet<Byte>(Arrays.asList((byte)1, (byte)2, (byte)3));
        resultHandler.handle((Object)Future.succeededFuture(set));
    }

    @Override
    public void setShortHandler(Handler<AsyncResult<Set<Short>>> resultHandler) {
        LinkedHashSet<Short> set = new LinkedHashSet<Short>(Arrays.asList((short)11, (short)12, (short)13));
        resultHandler.handle((Object)Future.succeededFuture(set));
    }

    @Override
    public void setIntHandler(Handler<AsyncResult<Set<Integer>>> resultHandler) {
        LinkedHashSet<Integer> set = new LinkedHashSet<Integer>(Arrays.asList(100, 101, 102));
        resultHandler.handle((Object)Future.succeededFuture(set));
    }

    @Override
    public void setLongHandler(Handler<AsyncResult<Set<Long>>> resultHandler) {
        LinkedHashSet<Long> set = new LinkedHashSet<Long>(Arrays.asList(1000L, 1001L, 1002L));
        resultHandler.handle((Object)Future.succeededFuture(set));
    }

    @Override
    public void setFloatHandler(Handler<AsyncResult<Set<Float>>> resultHandler) {
        LinkedHashSet<Float> set = new LinkedHashSet<Float>(Arrays.asList(Float.valueOf(1.1f), Float.valueOf(1.2f), Float.valueOf(1.3f)));
        resultHandler.handle((Object)Future.succeededFuture(set));
    }

    @Override
    public void setDoubleHandler(Handler<AsyncResult<Set<Double>>> resultHandler) {
        LinkedHashSet<Double> set = new LinkedHashSet<Double>(Arrays.asList(1.11, 1.12, 1.13));
        resultHandler.handle((Object)Future.succeededFuture(set));
    }

    @Override
    public void setCharHandler(Handler<AsyncResult<Set<Character>>> resultHandler) {
        LinkedHashSet<Character> set = new LinkedHashSet<Character>(Arrays.asList(Character.valueOf('X'), Character.valueOf('Y'), Character.valueOf('Z')));
        resultHandler.handle((Object)Future.succeededFuture(set));
    }

    @Override
    public void setBoolHandler(Handler<AsyncResult<Set<Boolean>>> resultHandler) {
        LinkedHashSet<Boolean> set = new LinkedHashSet<Boolean>(Arrays.asList(true, false, true));
        resultHandler.handle((Object)Future.succeededFuture(set));
    }

    @Override
    public void mapStringHandler(Handler<AsyncResult<Map<String, String>>> resultHandler) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("1", "foo");
        map.put("2", "bar");
        map.put("3", "wibble");
        resultHandler.handle((Object)Future.succeededFuture(map));
    }

    @Override
    public void mapByteHandler(Handler<AsyncResult<Map<String, Byte>>> resultHandler) {
        HashMap<String, Byte> map = new HashMap<String, Byte>();
        map.put("1", (byte)1);
        map.put("2", (byte)2);
        map.put("3", (byte)3);
        resultHandler.handle((Object)Future.succeededFuture(map));
    }

    @Override
    public void mapShortHandler(Handler<AsyncResult<Map<String, Short>>> resultHandler) {
        HashMap<String, Short> map = new HashMap<String, Short>();
        map.put("1", (short)11);
        map.put("2", (short)12);
        map.put("3", (short)13);
        resultHandler.handle((Object)Future.succeededFuture(map));
    }

    @Override
    public void mapIntHandler(Handler<AsyncResult<Map<String, Integer>>> resultHandler) {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        map.put("1", 100);
        map.put("2", 101);
        map.put("3", 102);
        resultHandler.handle((Object)Future.succeededFuture(map));
    }

    @Override
    public void mapLongHandler(Handler<AsyncResult<Map<String, Long>>> resultHandler) {
        HashMap<String, Long> map = new HashMap<String, Long>();
        map.put("1", 1000L);
        map.put("2", 1001L);
        map.put("3", 1002L);
        resultHandler.handle((Object)Future.succeededFuture(map));
    }

    @Override
    public void mapFloatHandler(Handler<AsyncResult<Map<String, Float>>> resultHandler) {
        HashMap<String, Float> map = new HashMap<String, Float>();
        map.put("1", Float.valueOf(1.1f));
        map.put("2", Float.valueOf(1.2f));
        map.put("3", Float.valueOf(1.3f));
        resultHandler.handle((Object)Future.succeededFuture(map));
    }

    @Override
    public void mapDoubleHandler(Handler<AsyncResult<Map<String, Double>>> resultHandler) {
        HashMap<String, Double> map = new HashMap<String, Double>();
        map.put("1", 1.11);
        map.put("2", 1.12);
        map.put("3", 1.13);
        resultHandler.handle((Object)Future.succeededFuture(map));
    }

    @Override
    public void mapCharHandler(Handler<AsyncResult<Map<String, Character>>> resultHandler) {
        HashMap<String, Character> map = new HashMap<String, Character>();
        map.put("1", Character.valueOf('X'));
        map.put("2", Character.valueOf('Y'));
        map.put("3", Character.valueOf('Z'));
        resultHandler.handle((Object)Future.succeededFuture(map));
    }

    @Override
    public void mapBoolHandler(Handler<AsyncResult<Map<String, Boolean>>> resultHandler) {
        HashMap<String, Boolean> map = new HashMap<String, Boolean>();
        map.put("1", true);
        map.put("2", false);
        map.put("3", true);
        resultHandler.handle((Object)Future.succeededFuture(map));
    }

    @Override
    public void setJsonObjectHandler(Handler<AsyncResult<Set<JsonObject>>> resultHandler) {
        LinkedHashSet<JsonObject> set = new LinkedHashSet<JsonObject>(Arrays.asList(new JsonObject().put("a", (Object)"foo"), new JsonObject().put("b", (Object)"bar"), new JsonObject().put("c", (Object)"wibble")));
        resultHandler.handle((Object)Future.succeededFuture(set));
    }

    @Override
    public void mapJsonObjectHandler(Handler<AsyncResult<Map<String, JsonObject>>> resultHandler) {
        HashMap<String, JsonObject> map = new HashMap<String, JsonObject>();
        map.put("1", new JsonObject().put("a", (Object)"foo"));
        map.put("2", new JsonObject().put("b", (Object)"bar"));
        map.put("3", new JsonObject().put("c", (Object)"wibble"));
        resultHandler.handle((Object)Future.succeededFuture(map));
    }

    @Override
    public void setJsonArrayHandler(Handler<AsyncResult<Set<JsonArray>>> resultHandler) {
        LinkedHashSet<JsonArray> set = new LinkedHashSet<JsonArray>(Arrays.asList(new JsonArray().add((Object)"foo"), new JsonArray().add((Object)"bar"), new JsonArray().add((Object)"wibble")));
        resultHandler.handle((Object)Future.succeededFuture(set));
    }

    @Override
    public void mapJsonArrayHandler(Handler<AsyncResult<Map<String, JsonArray>>> resultHandler) {
        HashMap<String, JsonArray> map = new HashMap<String, JsonArray>();
        map.put("1", new JsonArray().add((Object)"foo"));
        map.put("2", new JsonArray().add((Object)"bar"));
        map.put("3", new JsonArray().add((Object)"wibble"));
        resultHandler.handle((Object)Future.succeededFuture(map));
    }

    @Override
    public void ignoredMethod() {
        this.vertx.eventBus().send("testaddress", (Object)"called");
    }

    @Override
    public void listDataObjectHandler(Handler<AsyncResult<List<TestDataObject>>> resultHandler) {
        List<TestDataObject> list = Arrays.asList(new TestDataObject().setNumber(1).setString("String 1").setBool(false), new TestDataObject().setNumber(2).setString("String 2").setBool(true));
        resultHandler.handle((Object)Future.succeededFuture(list));
    }

    @Override
    public void setDataObjectHandler(Handler<AsyncResult<Set<TestDataObject>>> resultHandler) {
        LinkedHashSet<TestDataObject> set = new LinkedHashSet<TestDataObject>(Arrays.asList(new TestDataObject().setNumber(1).setString("String 1").setBool(false), new TestDataObject().setNumber(2).setString("String 2").setBool(true)));
        resultHandler.handle((Object)Future.succeededFuture(set));
    }

    @Override
    public void mapDataObject(Handler<AsyncResult<Map<String, TestDataObject>>> resultHandler) {
        HashMap<String, TestDataObject> map = new HashMap<String, TestDataObject>();
        map.put("do1", new TestDataObject().setNumber(1).setString("String 1").setBool(false));
        map.put("do2", new TestDataObject().setNumber(2).setString("String 2").setBool(true));
        resultHandler.handle((Object)Future.succeededFuture(map));
    }

    @Override
    public void longDeliverySuccess(Handler<AsyncResult<String>> resultHandler) {
        this.vertx.setTimer(10000L, tid -> resultHandler.handle((Object)Future.succeededFuture((Object)"blah")));
    }

    @Override
    public void longDeliveryFailed(Handler<AsyncResult<String>> resultHandler) {
        this.vertx.setTimer(30000L, tid -> resultHandler.handle((Object)Future.succeededFuture((Object)"blah")));
    }

    @Override
    public void failingCall(String value, Handler<AsyncResult<JsonObject>> resultHandler) {
        if (value.equals("Fail")) {
            resultHandler.handle((Object)ServiceException.fail((int)25, (String)"Call has failed", (JsonObject)new JsonObject().put("test", (Object)"val")));
        } else if (value.equals("Fail subclass")) {
            resultHandler.handle(MyServiceException.fail(25, "Call has failed", "some extra"));
        } else if (value.equals("Fail with cause")) {
            resultHandler.handle((Object)Future.failedFuture((Throwable)new IllegalArgumentException("Failed!").fillInStackTrace()));
        } else {
            resultHandler.handle((Object)Future.succeededFuture((Object)new JsonObject()));
        }
    }

    @Override
    public void listDataObjectContainingNullHandler(Handler<AsyncResult<List<TestDataObject>>> resultHandler) {
        List<TestDataObject> list = Arrays.asList(new TestDataObject().setNumber(1).setString("String 1").setBool(false), null, new TestDataObject().setNumber(2).setString("String 2").setBool(true));
        resultHandler.handle((Object)Future.succeededFuture(list));
    }

    @Override
    public void setDataObjectContainingNullHandler(Handler<AsyncResult<Set<TestDataObject>>> resultHandler) {
        LinkedHashSet<TestDataObject> set = new LinkedHashSet<TestDataObject>(Arrays.asList(new TestDataObject().setNumber(1).setString("String 1").setBool(false), null, new TestDataObject().setNumber(2).setString("String 2").setBool(true)));
        resultHandler.handle((Object)Future.succeededFuture(set));
    }

    @Override
    public void zonedDateTimeHandler(Handler<AsyncResult<ZonedDateTime>> resultHandler) {
        resultHandler.handle((Object)Future.succeededFuture((Object)ZonedDateTime.parse("2019-03-25T17:08:31.069+01:00[Europe/Rome]")));
    }

    @Override
    public void listZonedDateTimeHandler(Handler<AsyncResult<List<ZonedDateTime>>> resultHandler) {
        resultHandler.handle((Object)Future.succeededFuture(Arrays.asList(ZonedDateTime.parse("2019-03-25T17:08:31.069+01:00[Europe/Rome]"), ZonedDateTime.parse("2019-03-25T17:08:31.069+01:00[Europe/Rome]").plusHours(1L))));
    }

    @Override
    public void setZonedDateTimeHandler(Handler<AsyncResult<Set<ZonedDateTime>>> resultHandler) {
        resultHandler.handle((Object)Future.succeededFuture(new HashSet<ZonedDateTime>(Arrays.asList(ZonedDateTime.parse("2019-03-25T17:08:31.069+01:00[Europe/Rome]"), ZonedDateTime.parse("2019-03-25T17:08:31.069+01:00[Europe/Rome]").plusHours(1L)))));
    }

    @Override
    public void mapZonedDateTimeHandler(Handler<AsyncResult<Map<String, ZonedDateTime>>> resultHandler) {
        HashMap<String, ZonedDateTime> zonedDateTimeMap = new HashMap<String, ZonedDateTime>();
        zonedDateTimeMap.put("date1", ZonedDateTime.parse("2019-03-25T17:08:31.069+01:00[Europe/Rome]"));
        zonedDateTimeMap.put("date2", ZonedDateTime.parse("2019-03-25T17:08:31.069+01:00[Europe/Rome]").plusHours(1L));
        resultHandler.handle((Object)Future.succeededFuture(zonedDateTimeMap));
    }

    @Override
    public void listdataObjectTypeNull(List<TestDataObject> list) {
        Assert.assertTrue((boolean)list.isEmpty());
        this.vertx.eventBus().send("testaddress", (Object)"ok");
    }

    @Override
    public void setdataObjectTypeNull(Set<TestDataObject> set) {
        Assert.assertTrue((boolean)set.isEmpty());
        this.vertx.eventBus().send("testaddress", (Object)"ok");
    }

    @Override
    public void mapDataObjectType(Map<String, TestDataObject> map) {
        HashMap<String, TestDataObject> expected = new HashMap<String, TestDataObject>();
        expected.put("do1", new TestDataObject().setNumber(1).setString("String 1").setBool(false));
        expected.put("do2", new TestDataObject().setNumber(2).setString("String 2").setBool(true));
        Assert.assertEquals(expected, map);
        this.vertx.eventBus().send("testaddress", (Object)"ok");
    }
}

