/*
* Copyright 2014 Red Hat, Inc.
*
* Red Hat licenses this file to you under the Apache License, version 2.0
* (the "License"); you may not use this file except in compliance with the
* License. You may obtain a copy of the License at:
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
* WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
* License for the specific language governing permissions and limitations
* under the License.
*/

package io.vertx.serviceproxy.clustered;

import io.vertx.core.eventbus.DeliveryOptions;
import io.vertx.core.Vertx;
import io.vertx.core.Future;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.function.Function;
import io.vertx.serviceproxy.ServiceException;
import io.vertx.serviceproxy.ServiceExceptionMessageCodec;
import io.vertx.serviceproxy.ProxyUtils;

import io.vertx.serviceproxy.testmodel.SomeEnum;
import io.vertx.serviceproxy.testmodel.SomeVertxEnum;
import io.vertx.serviceproxy.clustered.Service;
import io.vertx.core.Vertx;
import io.vertx.serviceproxy.testmodel.SomeEnumWithCustomConstructor;
import java.util.List;
import io.vertx.serviceproxy.testmodel.TestDataObject;
import io.vertx.serviceproxy.testmodel.StringDataObject;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
/*
  Generated Proxy code - DO NOT EDIT
  @author Roger the Robot
*/

@SuppressWarnings({"unchecked", "rawtypes"})
public class ServiceVertxEBProxy implements Service {
  private Vertx _vertx;
  private String _address;
  private DeliveryOptions _options;
  private boolean closed;

  public ServiceVertxEBProxy(Vertx vertx, String address) {
    this(vertx, address, null);
  }

  public ServiceVertxEBProxy(Vertx vertx, String address, DeliveryOptions options) {
    this._vertx = vertx;
    this._address = address;
    this._options = options;
    try {
      this._vertx.eventBus().registerDefaultCodec(ServiceException.class, new ServiceExceptionMessageCodec());
    } catch (IllegalStateException ex) {
    }
  }

  @Override
  public Service hello(String name, Handler<AsyncResult<String>> result){
    if (closed) {
      result.handle(Future.failedFuture(new IllegalStateException("Proxy is closed")));
      return this;
    }
    JsonObject _json = new JsonObject();
    _json.put("name", name);

    DeliveryOptions _deliveryOptions = (_options != null) ? new DeliveryOptions(_options) : new DeliveryOptions();
    _deliveryOptions.addHeader("action", "hello");
    _deliveryOptions.getHeaders().set("action", "hello");
    _vertx.eventBus().<String>request(_address, _json, _deliveryOptions, res -> {
      if (res.failed()) {
        result.handle(Future.failedFuture(res.cause()));
      } else {
        result.handle(Future.succeededFuture(res.result().body()));
      }
    });
    return this;
  }
  @Override
  public Service methodUsingEnum(SomeEnum e, Handler<AsyncResult<Boolean>> result){
    if (closed) {
      result.handle(Future.failedFuture(new IllegalStateException("Proxy is closed")));
      return this;
    }
    JsonObject _json = new JsonObject();
    _json.put("e", e == null ? null : e.name());

    DeliveryOptions _deliveryOptions = (_options != null) ? new DeliveryOptions(_options) : new DeliveryOptions();
    _deliveryOptions.addHeader("action", "methodUsingEnum");
    _deliveryOptions.getHeaders().set("action", "methodUsingEnum");
    _vertx.eventBus().<Boolean>request(_address, _json, _deliveryOptions, res -> {
      if (res.failed()) {
        result.handle(Future.failedFuture(res.cause()));
      } else {
        result.handle(Future.succeededFuture(res.result().body()));
      }
    });
    return this;
  }
  @Override
  public Service methodReturningEnum(Handler<AsyncResult<SomeEnum>> result){
    if (closed) {
      result.handle(Future.failedFuture(new IllegalStateException("Proxy is closed")));
      return this;
    }
    JsonObject _json = new JsonObject();

    DeliveryOptions _deliveryOptions = (_options != null) ? new DeliveryOptions(_options) : new DeliveryOptions();
    _deliveryOptions.addHeader("action", "methodReturningEnum");
    _deliveryOptions.getHeaders().set("action", "methodReturningEnum");
    _vertx.eventBus().<String>request(_address, _json, _deliveryOptions, res -> {
      if (res.failed()) {
        result.handle(Future.failedFuture(res.cause()));
      } else {
        result.handle(Future.succeededFuture(res.result().body() == null ? null : SomeEnum.valueOf(res.result().body())));
      }
    });
    return this;
  }
  @Override
  public Service methodReturningVertxEnum(Handler<AsyncResult<SomeVertxEnum>> result){
    if (closed) {
      result.handle(Future.failedFuture(new IllegalStateException("Proxy is closed")));
      return this;
    }
    JsonObject _json = new JsonObject();

    DeliveryOptions _deliveryOptions = (_options != null) ? new DeliveryOptions(_options) : new DeliveryOptions();
    _deliveryOptions.addHeader("action", "methodReturningVertxEnum");
    _deliveryOptions.getHeaders().set("action", "methodReturningVertxEnum");
    _vertx.eventBus().<String>request(_address, _json, _deliveryOptions, res -> {
      if (res.failed()) {
        result.handle(Future.failedFuture(res.cause()));
      } else {
        result.handle(Future.succeededFuture(res.result().body() == null ? null : SomeVertxEnum.valueOf(res.result().body())));
      }
    });
    return this;
  }
  @Override
  public Service methodUsingCustomEnum(SomeEnumWithCustomConstructor e, Handler<AsyncResult<Boolean>> result){
    if (closed) {
      result.handle(Future.failedFuture(new IllegalStateException("Proxy is closed")));
      return this;
    }
    JsonObject _json = new JsonObject();
    _json.put("e", e != null ? io.vertx.serviceproxy.testmodel.Mappers.serializeSomeEnumWithCustomConstructor(e) : null);

    DeliveryOptions _deliveryOptions = (_options != null) ? new DeliveryOptions(_options) : new DeliveryOptions();
    _deliveryOptions.addHeader("action", "methodUsingCustomEnum");
    _deliveryOptions.getHeaders().set("action", "methodUsingCustomEnum");
    _vertx.eventBus().<Boolean>request(_address, _json, _deliveryOptions, res -> {
      if (res.failed()) {
        result.handle(Future.failedFuture(res.cause()));
      } else {
        result.handle(Future.succeededFuture(res.result().body()));
      }
    });
    return this;
  }
  @Override
  public Service methodReturningCustomEnum(Handler<AsyncResult<SomeEnumWithCustomConstructor>> result){
    if (closed) {
      result.handle(Future.failedFuture(new IllegalStateException("Proxy is closed")));
      return this;
    }
    JsonObject _json = new JsonObject();

    DeliveryOptions _deliveryOptions = (_options != null) ? new DeliveryOptions(_options) : new DeliveryOptions();
    _deliveryOptions.addHeader("action", "methodReturningCustomEnum");
    _deliveryOptions.getHeaders().set("action", "methodReturningCustomEnum");
    _vertx.eventBus().<String>request(_address, _json, _deliveryOptions, res -> {
      if (res.failed()) {
        result.handle(Future.failedFuture(res.cause()));
      } else {
        result.handle(Future.succeededFuture(res.result().body() != null ? io.vertx.serviceproxy.testmodel.Mappers.deserializeSomeEnumWithCustomConstructor((String)res.result().body()) : null));
      }
    });
    return this;
  }
  @Override
  public Service methodWithJsonObject(JsonObject json, Handler<AsyncResult<JsonObject>> result){
    if (closed) {
      result.handle(Future.failedFuture(new IllegalStateException("Proxy is closed")));
      return this;
    }
    JsonObject _json = new JsonObject();
    _json.put("json", json);

    DeliveryOptions _deliveryOptions = (_options != null) ? new DeliveryOptions(_options) : new DeliveryOptions();
    _deliveryOptions.addHeader("action", "methodWithJsonObject");
    _deliveryOptions.getHeaders().set("action", "methodWithJsonObject");
    _vertx.eventBus().<JsonObject>request(_address, _json, _deliveryOptions, res -> {
      if (res.failed()) {
        result.handle(Future.failedFuture(res.cause()));
      } else {
        result.handle(Future.succeededFuture(res.result().body()));
      }
    });
    return this;
  }
  @Override
  public Service methodWithJsonArray(JsonArray json, Handler<AsyncResult<JsonArray>> result){
    if (closed) {
      result.handle(Future.failedFuture(new IllegalStateException("Proxy is closed")));
      return this;
    }
    JsonObject _json = new JsonObject();
    _json.put("json", json);

    DeliveryOptions _deliveryOptions = (_options != null) ? new DeliveryOptions(_options) : new DeliveryOptions();
    _deliveryOptions.addHeader("action", "methodWithJsonArray");
    _deliveryOptions.getHeaders().set("action", "methodWithJsonArray");
    _vertx.eventBus().<JsonArray>request(_address, _json, _deliveryOptions, res -> {
      if (res.failed()) {
        result.handle(Future.failedFuture(res.cause()));
      } else {
        result.handle(Future.succeededFuture(res.result().body()));
      }
    });
    return this;
  }
  @Override
  public Service methodWithList(List<String> list, Handler<AsyncResult<List<String>>> result){
    if (closed) {
      result.handle(Future.failedFuture(new IllegalStateException("Proxy is closed")));
      return this;
    }
    JsonObject _json = new JsonObject();
    _json.put("list", new JsonArray(list));

    DeliveryOptions _deliveryOptions = (_options != null) ? new DeliveryOptions(_options) : new DeliveryOptions();
    _deliveryOptions.addHeader("action", "methodWithList");
    _deliveryOptions.getHeaders().set("action", "methodWithList");
    _vertx.eventBus().<JsonArray>request(_address, _json, _deliveryOptions, res -> {
      if (res.failed()) {
        result.handle(Future.failedFuture(res.cause()));
      } else {
        result.handle(Future.succeededFuture(ProxyUtils.convertList(res.result().body().getList())));
      }
    });
    return this;
  }
  @Override
  public Service methodWithDataObject(TestDataObject data, Handler<AsyncResult<TestDataObject>> result){
    if (closed) {
      result.handle(Future.failedFuture(new IllegalStateException("Proxy is closed")));
      return this;
    }
    JsonObject _json = new JsonObject();
    _json.put("data", data != null ? data.toJson() : null);

    DeliveryOptions _deliveryOptions = (_options != null) ? new DeliveryOptions(_options) : new DeliveryOptions();
    _deliveryOptions.addHeader("action", "methodWithDataObject");
    _deliveryOptions.getHeaders().set("action", "methodWithDataObject");
    _vertx.eventBus().<JsonObject>request(_address, _json, _deliveryOptions, res -> {
      if (res.failed()) {
        result.handle(Future.failedFuture(res.cause()));
      } else {
        result.handle(Future.succeededFuture(res.result().body() != null ? new io.vertx.serviceproxy.testmodel.TestDataObject((JsonObject)res.result().body()) : null));
      }
    });
    return this;
  }
  @Override
  public Service methodWithListOfDataObject(List<TestDataObject> list, Handler<AsyncResult<List<TestDataObject>>> result){
    if (closed) {
      result.handle(Future.failedFuture(new IllegalStateException("Proxy is closed")));
      return this;
    }
    JsonObject _json = new JsonObject();
    _json.put("list", new JsonArray(list == null ? java.util.Collections.emptyList() : list.stream().map(v -> v != null ? v.toJson() : null).collect(Collectors.toList())));

    DeliveryOptions _deliveryOptions = (_options != null) ? new DeliveryOptions(_options) : new DeliveryOptions();
    _deliveryOptions.addHeader("action", "methodWithListOfDataObject");
    _deliveryOptions.getHeaders().set("action", "methodWithListOfDataObject");
    _vertx.eventBus().<JsonArray>request(_address, _json, _deliveryOptions, res -> {
      if (res.failed()) {
        result.handle(Future.failedFuture(res.cause()));
      } else {
        result.handle(Future.succeededFuture(res.result().body().stream()
          .map(v -> v != null ? new io.vertx.serviceproxy.testmodel.TestDataObject((JsonObject)v) : null)
          .collect(Collectors.toList())));
      }
    });
    return this;
  }
  @Override
  public Service methodWithStringDataObject(StringDataObject data, Handler<AsyncResult<StringDataObject>> result){
    if (closed) {
      result.handle(Future.failedFuture(new IllegalStateException("Proxy is closed")));
      return this;
    }
    JsonObject _json = new JsonObject();
    _json.put("data", data != null ? data.toJson() : null);

    DeliveryOptions _deliveryOptions = (_options != null) ? new DeliveryOptions(_options) : new DeliveryOptions();
    _deliveryOptions.addHeader("action", "methodWithStringDataObject");
    _deliveryOptions.getHeaders().set("action", "methodWithStringDataObject");
    _vertx.eventBus().<String>request(_address, _json, _deliveryOptions, res -> {
      if (res.failed()) {
        result.handle(Future.failedFuture(res.cause()));
      } else {
        result.handle(Future.succeededFuture(res.result().body() != null ? new io.vertx.serviceproxy.testmodel.StringDataObject((String)res.result().body()) : null));
      }
    });
    return this;
  }
  @Override
  public Service methodWithListOfStringDataObject(List<StringDataObject> list, Handler<AsyncResult<List<StringDataObject>>> result){
    if (closed) {
      result.handle(Future.failedFuture(new IllegalStateException("Proxy is closed")));
      return this;
    }
    JsonObject _json = new JsonObject();
    _json.put("list", new JsonArray(list == null ? java.util.Collections.emptyList() : list.stream().map(v -> v != null ? v.toJson() : null).collect(Collectors.toList())));

    DeliveryOptions _deliveryOptions = (_options != null) ? new DeliveryOptions(_options) : new DeliveryOptions();
    _deliveryOptions.addHeader("action", "methodWithListOfStringDataObject");
    _deliveryOptions.getHeaders().set("action", "methodWithListOfStringDataObject");
    _vertx.eventBus().<JsonArray>request(_address, _json, _deliveryOptions, res -> {
      if (res.failed()) {
        result.handle(Future.failedFuture(res.cause()));
      } else {
        result.handle(Future.succeededFuture(res.result().body().stream()
          .map(v -> v != null ? new io.vertx.serviceproxy.testmodel.StringDataObject((String)v) : null)
          .collect(Collectors.toList())));
      }
    });
    return this;
  }
  @Override
  public Service methodWithListOfJsonObject(List<JsonObject> list, Handler<AsyncResult<List<JsonObject>>> result){
    if (closed) {
      result.handle(Future.failedFuture(new IllegalStateException("Proxy is closed")));
      return this;
    }
    JsonObject _json = new JsonObject();
    _json.put("list", new JsonArray(list));

    DeliveryOptions _deliveryOptions = (_options != null) ? new DeliveryOptions(_options) : new DeliveryOptions();
    _deliveryOptions.addHeader("action", "methodWithListOfJsonObject");
    _deliveryOptions.getHeaders().set("action", "methodWithListOfJsonObject");
    _vertx.eventBus().<JsonArray>request(_address, _json, _deliveryOptions, res -> {
      if (res.failed()) {
        result.handle(Future.failedFuture(res.cause()));
      } else {
        result.handle(Future.succeededFuture(ProxyUtils.convertList(res.result().body().getList())));
      }
    });
    return this;
  }
  @Override
  public Service methodWthFailingResult(String input, Handler<AsyncResult<JsonObject>> result){
    if (closed) {
      result.handle(Future.failedFuture(new IllegalStateException("Proxy is closed")));
      return this;
    }
    JsonObject _json = new JsonObject();
    _json.put("input", input);

    DeliveryOptions _deliveryOptions = (_options != null) ? new DeliveryOptions(_options) : new DeliveryOptions();
    _deliveryOptions.addHeader("action", "methodWthFailingResult");
    _deliveryOptions.getHeaders().set("action", "methodWthFailingResult");
    _vertx.eventBus().<JsonObject>request(_address, _json, _deliveryOptions, res -> {
      if (res.failed()) {
        result.handle(Future.failedFuture(res.cause()));
      } else {
        result.handle(Future.succeededFuture(res.result().body()));
      }
    });
    return this;
  }
}
