/*
* Copyright 2014 Red Hat, Inc.
*
* Red Hat licenses this file to you under the Apache License, version 2.0
* (the "License"); you may not use this file except in compliance with the
* License. You may obtain a copy of the License at:
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
* WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
* License for the specific language governing permissions and limitations
* under the License.
*/

package io.vertx.serviceproxy.testmodel;

import io.vertx.core.eventbus.DeliveryOptions;
import io.vertx.core.Vertx;
import io.vertx.core.Future;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.function.Function;
import io.vertx.serviceproxy.ServiceException;
import io.vertx.serviceproxy.ServiceExceptionMessageCodec;
import io.vertx.serviceproxy.ProxyUtils;

import io.vertx.serviceproxy.testmodel.TestService;
import io.vertx.serviceproxy.testmodel.SomeEnum;
import io.vertx.core.eventbus.DeliveryOptions;
import java.time.ZonedDateTime;
import io.vertx.serviceproxy.testmodel.TestConnection;
import io.vertx.serviceproxy.testmodel.SomeEnumWithCustomConstructor;
import java.util.Map;
import io.vertx.core.AsyncResult;
import io.vertx.serviceproxy.testmodel.sub.TestSubConnection;
import io.vertx.core.Vertx;
import java.util.Set;
import io.vertx.serviceproxy.testmodel.TestDataObject;
import java.util.List;
import io.vertx.core.Handler;
import io.vertx.serviceproxy.testmodel.sub.TestSubConnectionVertxEBProxy;
/*
  Generated Proxy code - DO NOT EDIT
  @author Roger the Robot
*/

@SuppressWarnings({"unchecked", "rawtypes"})
public class TestServiceVertxEBProxy implements TestService {
  private Vertx _vertx;
  private String _address;
  private DeliveryOptions _options;
  private boolean closed;

  public TestServiceVertxEBProxy(Vertx vertx, String address) {
    this(vertx, address, null);
  }

  public TestServiceVertxEBProxy(Vertx vertx, String address, DeliveryOptions options) {
    this._vertx = vertx;
    this._address = address;
    this._options = options;
    try {
      this._vertx.eventBus().registerDefaultCodec(ServiceException.class, new ServiceExceptionMessageCodec());
    } catch (IllegalStateException ex) {
    }
  }

  @Override
  public void longDeliverySuccess(Handler<AsyncResult<String>> resultHandler){
    if (closed) {
      resultHandler.handle(Future.failedFuture(new IllegalStateException("Proxy is closed")));
      return;
    }
    JsonObject _json = new JsonObject();

    DeliveryOptions _deliveryOptions = (_options != null) ? new DeliveryOptions(_options) : new DeliveryOptions();
    _deliveryOptions.addHeader("action", "longDeliverySuccess");
    _deliveryOptions.getHeaders().set("action", "longDeliverySuccess");
    _vertx.eventBus().<String>request(_address, _json, _deliveryOptions, res -> {
      if (res.failed()) {
        resultHandler.handle(Future.failedFuture(res.cause()));
      } else {
        resultHandler.handle(Future.succeededFuture(res.result().body()));
      }
    });
  }
  @Override
  public void longDeliveryFailed(Handler<AsyncResult<String>> resultHandler){
    if (closed) {
      resultHandler.handle(Future.failedFuture(new IllegalStateException("Proxy is closed")));
      return;
    }
    JsonObject _json = new JsonObject();

    DeliveryOptions _deliveryOptions = (_options != null) ? new DeliveryOptions(_options) : new DeliveryOptions();
    _deliveryOptions.addHeader("action", "longDeliveryFailed");
    _deliveryOptions.getHeaders().set("action", "longDeliveryFailed");
    _vertx.eventBus().<String>request(_address, _json, _deliveryOptions, res -> {
      if (res.failed()) {
        resultHandler.handle(Future.failedFuture(res.cause()));
      } else {
        resultHandler.handle(Future.succeededFuture(res.result().body()));
      }
    });
  }
  @Override
  public void createConnection(String str, Handler<AsyncResult<TestConnection>> resultHandler){
    if (closed) {
      resultHandler.handle(Future.failedFuture(new IllegalStateException("Proxy is closed")));
      return;
    }
    JsonObject _json = new JsonObject();
    _json.put("str", str);

    DeliveryOptions _deliveryOptions = (_options != null) ? new DeliveryOptions(_options) : new DeliveryOptions();
    _deliveryOptions.addHeader("action", "createConnection");
    _deliveryOptions.getHeaders().set("action", "createConnection");
    _vertx.eventBus().<TestConnection>request(_address, _json, _deliveryOptions, res -> {
      if (res.failed()) {
        resultHandler.handle(Future.failedFuture(res.cause()));
      } else {
        resultHandler.handle(Future.succeededFuture(new TestConnectionVertxEBProxy(_vertx, res.result().headers().get("proxyaddr"))));
      }
    });
  }
  @Override
  public void createSubConnection(String str, Handler<AsyncResult<TestSubConnection>> resultHandler){
    if (closed) {
      resultHandler.handle(Future.failedFuture(new IllegalStateException("Proxy is closed")));
      return;
    }
    JsonObject _json = new JsonObject();
    _json.put("str", str);

    DeliveryOptions _deliveryOptions = (_options != null) ? new DeliveryOptions(_options) : new DeliveryOptions();
    _deliveryOptions.addHeader("action", "createSubConnection");
    _deliveryOptions.getHeaders().set("action", "createSubConnection");
    _vertx.eventBus().<TestSubConnection>request(_address, _json, _deliveryOptions, res -> {
      if (res.failed()) {
        resultHandler.handle(Future.failedFuture(res.cause()));
      } else {
        resultHandler.handle(Future.succeededFuture(new TestSubConnectionVertxEBProxy(_vertx, res.result().headers().get("proxyaddr"))));
      }
    });
  }
  @Override
  public void noParams(){
    if (closed) throw new IllegalStateException("Proxy is closed");
    JsonObject _json = new JsonObject();

    DeliveryOptions _deliveryOptions = (_options != null) ? new DeliveryOptions(_options) : new DeliveryOptions();
    _deliveryOptions.addHeader("action", "noParams");
    _deliveryOptions.getHeaders().set("action", "noParams");
    _vertx.eventBus().send(_address, _json, _deliveryOptions);
  }
  @Override
  public void basicTypes(String str, byte b, short s, int i, long l, float f, double d, char c, boolean bool){
    if (closed) throw new IllegalStateException("Proxy is closed");
    JsonObject _json = new JsonObject();
    _json.put("str", str);
    _json.put("b", b);
    _json.put("s", s);
    _json.put("i", i);
    _json.put("l", l);
    _json.put("f", f);
    _json.put("d", d);
    _json.put("c", (int)c);
    _json.put("bool", bool);

    DeliveryOptions _deliveryOptions = (_options != null) ? new DeliveryOptions(_options) : new DeliveryOptions();
    _deliveryOptions.addHeader("action", "basicTypes");
    _deliveryOptions.getHeaders().set("action", "basicTypes");
    _vertx.eventBus().send(_address, _json, _deliveryOptions);
  }
  @Override
  public void basicBoxedTypes(String str, Byte b, Short s, Integer i, Long l, Float f, Double d, Character c, Boolean bool){
    if (closed) throw new IllegalStateException("Proxy is closed");
    JsonObject _json = new JsonObject();
    _json.put("str", str);
    _json.put("b", b);
    _json.put("s", s);
    _json.put("i", i);
    _json.put("l", l);
    _json.put("f", f);
    _json.put("d", d);
    _json.put("c", c == null ? null : (int)c);
    _json.put("bool", bool);

    DeliveryOptions _deliveryOptions = (_options != null) ? new DeliveryOptions(_options) : new DeliveryOptions();
    _deliveryOptions.addHeader("action", "basicBoxedTypes");
    _deliveryOptions.getHeaders().set("action", "basicBoxedTypes");
    _vertx.eventBus().send(_address, _json, _deliveryOptions);
  }
  @Override
  public void basicBoxedTypesNull(String str, Byte b, Short s, Integer i, Long l, Float f, Double d, Character c, Boolean bool){
    if (closed) throw new IllegalStateException("Proxy is closed");
    JsonObject _json = new JsonObject();
    _json.put("str", str);
    _json.put("b", b);
    _json.put("s", s);
    _json.put("i", i);
    _json.put("l", l);
    _json.put("f", f);
    _json.put("d", d);
    _json.put("c", c == null ? null : (int)c);
    _json.put("bool", bool);

    DeliveryOptions _deliveryOptions = (_options != null) ? new DeliveryOptions(_options) : new DeliveryOptions();
    _deliveryOptions.addHeader("action", "basicBoxedTypesNull");
    _deliveryOptions.getHeaders().set("action", "basicBoxedTypesNull");
    _vertx.eventBus().send(_address, _json, _deliveryOptions);
  }
  @Override
  public void jsonTypes(JsonObject jsonObject, JsonArray jsonArray){
    if (closed) throw new IllegalStateException("Proxy is closed");
    JsonObject _json = new JsonObject();
    _json.put("jsonObject", jsonObject);
    _json.put("jsonArray", jsonArray);

    DeliveryOptions _deliveryOptions = (_options != null) ? new DeliveryOptions(_options) : new DeliveryOptions();
    _deliveryOptions.addHeader("action", "jsonTypes");
    _deliveryOptions.getHeaders().set("action", "jsonTypes");
    _vertx.eventBus().send(_address, _json, _deliveryOptions);
  }
  @Override
  public void jsonTypesNull(JsonObject jsonObject, JsonArray jsonArray){
    if (closed) throw new IllegalStateException("Proxy is closed");
    JsonObject _json = new JsonObject();
    _json.put("jsonObject", jsonObject);
    _json.put("jsonArray", jsonArray);

    DeliveryOptions _deliveryOptions = (_options != null) ? new DeliveryOptions(_options) : new DeliveryOptions();
    _deliveryOptions.addHeader("action", "jsonTypesNull");
    _deliveryOptions.getHeaders().set("action", "jsonTypesNull");
    _vertx.eventBus().send(_address, _json, _deliveryOptions);
  }
  @Override
  public void enumType(SomeEnum someEnum){
    if (closed) throw new IllegalStateException("Proxy is closed");
    JsonObject _json = new JsonObject();
    _json.put("someEnum", someEnum == null ? null : someEnum.name());

    DeliveryOptions _deliveryOptions = (_options != null) ? new DeliveryOptions(_options) : new DeliveryOptions();
    _deliveryOptions.addHeader("action", "enumType");
    _deliveryOptions.getHeaders().set("action", "enumType");
    _vertx.eventBus().send(_address, _json, _deliveryOptions);
  }
  @Override
  public void enumTypeNull(SomeEnum someEnum){
    if (closed) throw new IllegalStateException("Proxy is closed");
    JsonObject _json = new JsonObject();
    _json.put("someEnum", someEnum == null ? null : someEnum.name());

    DeliveryOptions _deliveryOptions = (_options != null) ? new DeliveryOptions(_options) : new DeliveryOptions();
    _deliveryOptions.addHeader("action", "enumTypeNull");
    _deliveryOptions.getHeaders().set("action", "enumTypeNull");
    _vertx.eventBus().send(_address, _json, _deliveryOptions);
  }
  @Override
  public void enumTypeAsResult(Handler<AsyncResult<SomeEnum>> someEnum){
    if (closed) {
      someEnum.handle(Future.failedFuture(new IllegalStateException("Proxy is closed")));
      return;
    }
    JsonObject _json = new JsonObject();

    DeliveryOptions _deliveryOptions = (_options != null) ? new DeliveryOptions(_options) : new DeliveryOptions();
    _deliveryOptions.addHeader("action", "enumTypeAsResult");
    _deliveryOptions.getHeaders().set("action", "enumTypeAsResult");
    _vertx.eventBus().<String>request(_address, _json, _deliveryOptions, res -> {
      if (res.failed()) {
        someEnum.handle(Future.failedFuture(res.cause()));
      } else {
        someEnum.handle(Future.succeededFuture(res.result().body() == null ? null : SomeEnum.valueOf(res.result().body())));
      }
    });
  }
  @Override
  public void enumTypeAsResultNull(Handler<AsyncResult<SomeEnum>> someEnum){
    if (closed) {
      someEnum.handle(Future.failedFuture(new IllegalStateException("Proxy is closed")));
      return;
    }
    JsonObject _json = new JsonObject();

    DeliveryOptions _deliveryOptions = (_options != null) ? new DeliveryOptions(_options) : new DeliveryOptions();
    _deliveryOptions.addHeader("action", "enumTypeAsResultNull");
    _deliveryOptions.getHeaders().set("action", "enumTypeAsResultNull");
    _vertx.eventBus().<String>request(_address, _json, _deliveryOptions, res -> {
      if (res.failed()) {
        someEnum.handle(Future.failedFuture(res.cause()));
      } else {
        someEnum.handle(Future.succeededFuture(res.result().body() == null ? null : SomeEnum.valueOf(res.result().body())));
      }
    });
  }
  @Override
  public void enumCustomType(SomeEnumWithCustomConstructor someEnum){
    if (closed) throw new IllegalStateException("Proxy is closed");
    JsonObject _json = new JsonObject();
    _json.put("someEnum", someEnum != null ? io.vertx.serviceproxy.testmodel.Mappers.serializeSomeEnumWithCustomConstructor(someEnum) : null);

    DeliveryOptions _deliveryOptions = (_options != null) ? new DeliveryOptions(_options) : new DeliveryOptions();
    _deliveryOptions.addHeader("action", "enumCustomType");
    _deliveryOptions.getHeaders().set("action", "enumCustomType");
    _vertx.eventBus().send(_address, _json, _deliveryOptions);
  }
  @Override
  public void enumCustomTypeNull(SomeEnumWithCustomConstructor someEnum){
    if (closed) throw new IllegalStateException("Proxy is closed");
    JsonObject _json = new JsonObject();
    _json.put("someEnum", someEnum != null ? io.vertx.serviceproxy.testmodel.Mappers.serializeSomeEnumWithCustomConstructor(someEnum) : null);

    DeliveryOptions _deliveryOptions = (_options != null) ? new DeliveryOptions(_options) : new DeliveryOptions();
    _deliveryOptions.addHeader("action", "enumCustomTypeNull");
    _deliveryOptions.getHeaders().set("action", "enumCustomTypeNull");
    _vertx.eventBus().send(_address, _json, _deliveryOptions);
  }
  @Override
  public void enumCustomTypeAsResult(Handler<AsyncResult<SomeEnumWithCustomConstructor>> someEnum){
    if (closed) {
      someEnum.handle(Future.failedFuture(new IllegalStateException("Proxy is closed")));
      return;
    }
    JsonObject _json = new JsonObject();

    DeliveryOptions _deliveryOptions = (_options != null) ? new DeliveryOptions(_options) : new DeliveryOptions();
    _deliveryOptions.addHeader("action", "enumCustomTypeAsResult");
    _deliveryOptions.getHeaders().set("action", "enumCustomTypeAsResult");
    _vertx.eventBus().<String>request(_address, _json, _deliveryOptions, res -> {
      if (res.failed()) {
        someEnum.handle(Future.failedFuture(res.cause()));
      } else {
        someEnum.handle(Future.succeededFuture(res.result().body() != null ? io.vertx.serviceproxy.testmodel.Mappers.deserializeSomeEnumWithCustomConstructor((String)res.result().body()) : null));
      }
    });
  }
  @Override
  public void enumCustomTypeAsResultNull(Handler<AsyncResult<SomeEnumWithCustomConstructor>> someEnum){
    if (closed) {
      someEnum.handle(Future.failedFuture(new IllegalStateException("Proxy is closed")));
      return;
    }
    JsonObject _json = new JsonObject();

    DeliveryOptions _deliveryOptions = (_options != null) ? new DeliveryOptions(_options) : new DeliveryOptions();
    _deliveryOptions.addHeader("action", "enumCustomTypeAsResultNull");
    _deliveryOptions.getHeaders().set("action", "enumCustomTypeAsResultNull");
    _vertx.eventBus().<String>request(_address, _json, _deliveryOptions, res -> {
      if (res.failed()) {
        someEnum.handle(Future.failedFuture(res.cause()));
      } else {
        someEnum.handle(Future.succeededFuture(res.result().body() != null ? io.vertx.serviceproxy.testmodel.Mappers.deserializeSomeEnumWithCustomConstructor((String)res.result().body()) : null));
      }
    });
  }
  @Override
  public void dataObjectType(TestDataObject options){
    if (closed) throw new IllegalStateException("Proxy is closed");
    JsonObject _json = new JsonObject();
    _json.put("options", options != null ? options.toJson() : null);

    DeliveryOptions _deliveryOptions = (_options != null) ? new DeliveryOptions(_options) : new DeliveryOptions();
    _deliveryOptions.addHeader("action", "dataObjectType");
    _deliveryOptions.getHeaders().set("action", "dataObjectType");
    _vertx.eventBus().send(_address, _json, _deliveryOptions);
  }
  @Override
  public void listdataObjectType(List<TestDataObject> list){
    if (closed) throw new IllegalStateException("Proxy is closed");
    JsonObject _json = new JsonObject();
    _json.put("list", new JsonArray(list == null ? java.util.Collections.emptyList() : list.stream().map(v -> v != null ? v.toJson() : null).collect(Collectors.toList())));

    DeliveryOptions _deliveryOptions = (_options != null) ? new DeliveryOptions(_options) : new DeliveryOptions();
    _deliveryOptions.addHeader("action", "listdataObjectType");
    _deliveryOptions.getHeaders().set("action", "listdataObjectType");
    _vertx.eventBus().send(_address, _json, _deliveryOptions);
  }
  @Override
  public void setdataObjectType(Set<TestDataObject> set){
    if (closed) throw new IllegalStateException("Proxy is closed");
    JsonObject _json = new JsonObject();
    _json.put("set", new JsonArray(set == null ? java.util.Collections.emptyList() : set.stream().map(v -> v != null ? v.toJson() : null).collect(Collectors.toList())));

    DeliveryOptions _deliveryOptions = (_options != null) ? new DeliveryOptions(_options) : new DeliveryOptions();
    _deliveryOptions.addHeader("action", "setdataObjectType");
    _deliveryOptions.getHeaders().set("action", "setdataObjectType");
    _vertx.eventBus().send(_address, _json, _deliveryOptions);
  }
  @Override
  public void dataObjectTypeNull(TestDataObject options){
    if (closed) throw new IllegalStateException("Proxy is closed");
    JsonObject _json = new JsonObject();
    _json.put("options", options != null ? options.toJson() : null);

    DeliveryOptions _deliveryOptions = (_options != null) ? new DeliveryOptions(_options) : new DeliveryOptions();
    _deliveryOptions.addHeader("action", "dataObjectTypeNull");
    _deliveryOptions.getHeaders().set("action", "dataObjectTypeNull");
    _vertx.eventBus().send(_address, _json, _deliveryOptions);
  }
  @Override
  public void dateTimeType(ZonedDateTime dateTime){
    if (closed) throw new IllegalStateException("Proxy is closed");
    JsonObject _json = new JsonObject();
    _json.put("dateTime", dateTime != null ? io.vertx.serviceproxy.testmodel.Mappers.serializeZonedDateTime(dateTime) : null);

    DeliveryOptions _deliveryOptions = (_options != null) ? new DeliveryOptions(_options) : new DeliveryOptions();
    _deliveryOptions.addHeader("action", "dateTimeType");
    _deliveryOptions.getHeaders().set("action", "dateTimeType");
    _vertx.eventBus().send(_address, _json, _deliveryOptions);
  }
  @Override
  public void listDateTimeType(List<ZonedDateTime> list){
    if (closed) throw new IllegalStateException("Proxy is closed");
    JsonObject _json = new JsonObject();
    _json.put("list", new JsonArray(list == null ? java.util.Collections.emptyList() : list.stream().map(v -> v != null ? io.vertx.serviceproxy.testmodel.Mappers.serializeZonedDateTime(v) : null).collect(Collectors.toList())));

    DeliveryOptions _deliveryOptions = (_options != null) ? new DeliveryOptions(_options) : new DeliveryOptions();
    _deliveryOptions.addHeader("action", "listDateTimeType");
    _deliveryOptions.getHeaders().set("action", "listDateTimeType");
    _vertx.eventBus().send(_address, _json, _deliveryOptions);
  }
  @Override
  public void setDateTimeType(Set<ZonedDateTime> set){
    if (closed) throw new IllegalStateException("Proxy is closed");
    JsonObject _json = new JsonObject();
    _json.put("set", new JsonArray(set == null ? java.util.Collections.emptyList() : set.stream().map(v -> v != null ? io.vertx.serviceproxy.testmodel.Mappers.serializeZonedDateTime(v) : null).collect(Collectors.toList())));

    DeliveryOptions _deliveryOptions = (_options != null) ? new DeliveryOptions(_options) : new DeliveryOptions();
    _deliveryOptions.addHeader("action", "setDateTimeType");
    _deliveryOptions.getHeaders().set("action", "setDateTimeType");
    _vertx.eventBus().send(_address, _json, _deliveryOptions);
  }
  @Override
  public void mapDateTimeType(Map<String,ZonedDateTime> map){
    if (closed) throw new IllegalStateException("Proxy is closed");
    JsonObject _json = new JsonObject();
    _json.put("map", new JsonObject(map == null ? java.util.Collections.emptyMap() : map.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> e.getValue() != null ? io.vertx.serviceproxy.testmodel.Mappers.serializeZonedDateTime(e.getValue()) : null))));

    DeliveryOptions _deliveryOptions = (_options != null) ? new DeliveryOptions(_options) : new DeliveryOptions();
    _deliveryOptions.addHeader("action", "mapDateTimeType");
    _deliveryOptions.getHeaders().set("action", "mapDateTimeType");
    _vertx.eventBus().send(_address, _json, _deliveryOptions);
  }
  @Override
  public void listdataObjectTypeHavingNullValues(List<TestDataObject> list){
    if (closed) throw new IllegalStateException("Proxy is closed");
    JsonObject _json = new JsonObject();
    _json.put("list", new JsonArray(list == null ? java.util.Collections.emptyList() : list.stream().map(v -> v != null ? v.toJson() : null).collect(Collectors.toList())));

    DeliveryOptions _deliveryOptions = (_options != null) ? new DeliveryOptions(_options) : new DeliveryOptions();
    _deliveryOptions.addHeader("action", "listdataObjectTypeHavingNullValues");
    _deliveryOptions.getHeaders().set("action", "listdataObjectTypeHavingNullValues");
    _vertx.eventBus().send(_address, _json, _deliveryOptions);
  }
  @Override
  public void setdataObjectTypeHavingNullValues(Set<TestDataObject> set){
    if (closed) throw new IllegalStateException("Proxy is closed");
    JsonObject _json = new JsonObject();
    _json.put("set", new JsonArray(set == null ? java.util.Collections.emptyList() : set.stream().map(v -> v != null ? v.toJson() : null).collect(Collectors.toList())));

    DeliveryOptions _deliveryOptions = (_options != null) ? new DeliveryOptions(_options) : new DeliveryOptions();
    _deliveryOptions.addHeader("action", "setdataObjectTypeHavingNullValues");
    _deliveryOptions.getHeaders().set("action", "setdataObjectTypeHavingNullValues");
    _vertx.eventBus().send(_address, _json, _deliveryOptions);
  }
  @Override
  public void listdataObjectTypeNull(List<TestDataObject> list){
    if (closed) throw new IllegalStateException("Proxy is closed");
    JsonObject _json = new JsonObject();
    _json.put("list", new JsonArray(list == null ? java.util.Collections.emptyList() : list.stream().map(v -> v != null ? v.toJson() : null).collect(Collectors.toList())));

    DeliveryOptions _deliveryOptions = (_options != null) ? new DeliveryOptions(_options) : new DeliveryOptions();
    _deliveryOptions.addHeader("action", "listdataObjectTypeNull");
    _deliveryOptions.getHeaders().set("action", "listdataObjectTypeNull");
    _vertx.eventBus().send(_address, _json, _deliveryOptions);
  }
  @Override
  public void setdataObjectTypeNull(Set<TestDataObject> set){
    if (closed) throw new IllegalStateException("Proxy is closed");
    JsonObject _json = new JsonObject();
    _json.put("set", new JsonArray(set == null ? java.util.Collections.emptyList() : set.stream().map(v -> v != null ? v.toJson() : null).collect(Collectors.toList())));

    DeliveryOptions _deliveryOptions = (_options != null) ? new DeliveryOptions(_options) : new DeliveryOptions();
    _deliveryOptions.addHeader("action", "setdataObjectTypeNull");
    _deliveryOptions.getHeaders().set("action", "setdataObjectTypeNull");
    _vertx.eventBus().send(_address, _json, _deliveryOptions);
  }
  @Override
  public void mapDataObjectType(Map<String,TestDataObject> map){
    if (closed) throw new IllegalStateException("Proxy is closed");
    JsonObject _json = new JsonObject();
    _json.put("map", new JsonObject(map == null ? java.util.Collections.emptyMap() : map.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> e.getValue() != null ? e.getValue().toJson() : null))));

    DeliveryOptions _deliveryOptions = (_options != null) ? new DeliveryOptions(_options) : new DeliveryOptions();
    _deliveryOptions.addHeader("action", "mapDataObjectType");
    _deliveryOptions.getHeaders().set("action", "mapDataObjectType");
    _vertx.eventBus().send(_address, _json, _deliveryOptions);
  }
  @Override
  public void listParams(List<String> listString, List<Byte> listByte, List<Short> listShort, List<Integer> listInt, List<Long> listLong, List<JsonObject> listJsonObject, List<JsonArray> listJsonArray, List<TestDataObject> listDataObject){
    if (closed) throw new IllegalStateException("Proxy is closed");
    JsonObject _json = new JsonObject();
    _json.put("listString", new JsonArray(listString));
    _json.put("listByte", new JsonArray(listByte));
    _json.put("listShort", new JsonArray(listShort));
    _json.put("listInt", new JsonArray(listInt));
    _json.put("listLong", new JsonArray(listLong));
    _json.put("listJsonObject", new JsonArray(listJsonObject));
    _json.put("listJsonArray", new JsonArray(listJsonArray));
    _json.put("listDataObject", new JsonArray(listDataObject == null ? java.util.Collections.emptyList() : listDataObject.stream().map(v -> v != null ? v.toJson() : null).collect(Collectors.toList())));

    DeliveryOptions _deliveryOptions = (_options != null) ? new DeliveryOptions(_options) : new DeliveryOptions();
    _deliveryOptions.addHeader("action", "listParams");
    _deliveryOptions.getHeaders().set("action", "listParams");
    _vertx.eventBus().send(_address, _json, _deliveryOptions);
  }
  @Override
  public void setParams(Set<String> setString, Set<Byte> setByte, Set<Short> setShort, Set<Integer> setInt, Set<Long> setLong, Set<JsonObject> setJsonObject, Set<JsonArray> setJsonArray, Set<TestDataObject> setDataObject){
    if (closed) throw new IllegalStateException("Proxy is closed");
    JsonObject _json = new JsonObject();
    _json.put("setString", new JsonArray(new ArrayList<>(setString)));
    _json.put("setByte", new JsonArray(new ArrayList<>(setByte)));
    _json.put("setShort", new JsonArray(new ArrayList<>(setShort)));
    _json.put("setInt", new JsonArray(new ArrayList<>(setInt)));
    _json.put("setLong", new JsonArray(new ArrayList<>(setLong)));
    _json.put("setJsonObject", new JsonArray(new ArrayList<>(setJsonObject)));
    _json.put("setJsonArray", new JsonArray(new ArrayList<>(setJsonArray)));
    _json.put("setDataObject", new JsonArray(setDataObject == null ? java.util.Collections.emptyList() : setDataObject.stream().map(v -> v != null ? v.toJson() : null).collect(Collectors.toList())));

    DeliveryOptions _deliveryOptions = (_options != null) ? new DeliveryOptions(_options) : new DeliveryOptions();
    _deliveryOptions.addHeader("action", "setParams");
    _deliveryOptions.getHeaders().set("action", "setParams");
    _vertx.eventBus().send(_address, _json, _deliveryOptions);
  }
  @Override
  public void mapParams(Map<String,String> mapString, Map<String,Byte> mapByte, Map<String,Short> mapShort, Map<String,Integer> mapInt, Map<String,Long> mapLong, Map<String,JsonObject> mapJsonObject, Map<String,JsonArray> mapJsonArray){
    if (closed) throw new IllegalStateException("Proxy is closed");
    JsonObject _json = new JsonObject();
    _json.put("mapString", new JsonObject(ProxyUtils.convertMap(mapString)));
    _json.put("mapByte", new JsonObject(ProxyUtils.convertMap(mapByte)));
    _json.put("mapShort", new JsonObject(ProxyUtils.convertMap(mapShort)));
    _json.put("mapInt", new JsonObject(ProxyUtils.convertMap(mapInt)));
    _json.put("mapLong", new JsonObject(ProxyUtils.convertMap(mapLong)));
    _json.put("mapJsonObject", new JsonObject(ProxyUtils.convertMap(mapJsonObject)));
    _json.put("mapJsonArray", new JsonObject(ProxyUtils.convertMap(mapJsonArray)));

    DeliveryOptions _deliveryOptions = (_options != null) ? new DeliveryOptions(_options) : new DeliveryOptions();
    _deliveryOptions.addHeader("action", "mapParams");
    _deliveryOptions.getHeaders().set("action", "mapParams");
    _vertx.eventBus().send(_address, _json, _deliveryOptions);
  }
  @Override
  public void stringHandler(Handler<AsyncResult<String>> resultHandler){
    if (closed) {
      resultHandler.handle(Future.failedFuture(new IllegalStateException("Proxy is closed")));
      return;
    }
    JsonObject _json = new JsonObject();

    DeliveryOptions _deliveryOptions = (_options != null) ? new DeliveryOptions(_options) : new DeliveryOptions();
    _deliveryOptions.addHeader("action", "stringHandler");
    _deliveryOptions.getHeaders().set("action", "stringHandler");
    _vertx.eventBus().<String>request(_address, _json, _deliveryOptions, res -> {
      if (res.failed()) {
        resultHandler.handle(Future.failedFuture(res.cause()));
      } else {
        resultHandler.handle(Future.succeededFuture(res.result().body()));
      }
    });
  }
  @Override
  public void stringNullHandler(Handler<AsyncResult<String>> resultHandler){
    if (closed) {
      resultHandler.handle(Future.failedFuture(new IllegalStateException("Proxy is closed")));
      return;
    }
    JsonObject _json = new JsonObject();

    DeliveryOptions _deliveryOptions = (_options != null) ? new DeliveryOptions(_options) : new DeliveryOptions();
    _deliveryOptions.addHeader("action", "stringNullHandler");
    _deliveryOptions.getHeaders().set("action", "stringNullHandler");
    _vertx.eventBus().<String>request(_address, _json, _deliveryOptions, res -> {
      if (res.failed()) {
        resultHandler.handle(Future.failedFuture(res.cause()));
      } else {
        resultHandler.handle(Future.succeededFuture(res.result().body()));
      }
    });
  }
  @Override
  public void byteHandler(Handler<AsyncResult<Byte>> resultHandler){
    if (closed) {
      resultHandler.handle(Future.failedFuture(new IllegalStateException("Proxy is closed")));
      return;
    }
    JsonObject _json = new JsonObject();

    DeliveryOptions _deliveryOptions = (_options != null) ? new DeliveryOptions(_options) : new DeliveryOptions();
    _deliveryOptions.addHeader("action", "byteHandler");
    _deliveryOptions.getHeaders().set("action", "byteHandler");
    _vertx.eventBus().<Byte>request(_address, _json, _deliveryOptions, res -> {
      if (res.failed()) {
        resultHandler.handle(Future.failedFuture(res.cause()));
      } else {
        resultHandler.handle(Future.succeededFuture(res.result().body()));
      }
    });
  }
  @Override
  public void byteNullHandler(Handler<AsyncResult<Byte>> resultHandler){
    if (closed) {
      resultHandler.handle(Future.failedFuture(new IllegalStateException("Proxy is closed")));
      return;
    }
    JsonObject _json = new JsonObject();

    DeliveryOptions _deliveryOptions = (_options != null) ? new DeliveryOptions(_options) : new DeliveryOptions();
    _deliveryOptions.addHeader("action", "byteNullHandler");
    _deliveryOptions.getHeaders().set("action", "byteNullHandler");
    _vertx.eventBus().<Byte>request(_address, _json, _deliveryOptions, res -> {
      if (res.failed()) {
        resultHandler.handle(Future.failedFuture(res.cause()));
      } else {
        resultHandler.handle(Future.succeededFuture(res.result().body()));
      }
    });
  }
  @Override
  public void shortHandler(Handler<AsyncResult<Short>> resultHandler){
    if (closed) {
      resultHandler.handle(Future.failedFuture(new IllegalStateException("Proxy is closed")));
      return;
    }
    JsonObject _json = new JsonObject();

    DeliveryOptions _deliveryOptions = (_options != null) ? new DeliveryOptions(_options) : new DeliveryOptions();
    _deliveryOptions.addHeader("action", "shortHandler");
    _deliveryOptions.getHeaders().set("action", "shortHandler");
    _vertx.eventBus().<Short>request(_address, _json, _deliveryOptions, res -> {
      if (res.failed()) {
        resultHandler.handle(Future.failedFuture(res.cause()));
      } else {
        resultHandler.handle(Future.succeededFuture(res.result().body()));
      }
    });
  }
  @Override
  public void shortNullHandler(Handler<AsyncResult<Short>> resultHandler){
    if (closed) {
      resultHandler.handle(Future.failedFuture(new IllegalStateException("Proxy is closed")));
      return;
    }
    JsonObject _json = new JsonObject();

    DeliveryOptions _deliveryOptions = (_options != null) ? new DeliveryOptions(_options) : new DeliveryOptions();
    _deliveryOptions.addHeader("action", "shortNullHandler");
    _deliveryOptions.getHeaders().set("action", "shortNullHandler");
    _vertx.eventBus().<Short>request(_address, _json, _deliveryOptions, res -> {
      if (res.failed()) {
        resultHandler.handle(Future.failedFuture(res.cause()));
      } else {
        resultHandler.handle(Future.succeededFuture(res.result().body()));
      }
    });
  }
  @Override
  public void intHandler(Handler<AsyncResult<Integer>> resultHandler){
    if (closed) {
      resultHandler.handle(Future.failedFuture(new IllegalStateException("Proxy is closed")));
      return;
    }
    JsonObject _json = new JsonObject();

    DeliveryOptions _deliveryOptions = (_options != null) ? new DeliveryOptions(_options) : new DeliveryOptions();
    _deliveryOptions.addHeader("action", "intHandler");
    _deliveryOptions.getHeaders().set("action", "intHandler");
    _vertx.eventBus().<Integer>request(_address, _json, _deliveryOptions, res -> {
      if (res.failed()) {
        resultHandler.handle(Future.failedFuture(res.cause()));
      } else {
        resultHandler.handle(Future.succeededFuture(res.result().body()));
      }
    });
  }
  @Override
  public void intNullHandler(Handler<AsyncResult<Integer>> resultHandler){
    if (closed) {
      resultHandler.handle(Future.failedFuture(new IllegalStateException("Proxy is closed")));
      return;
    }
    JsonObject _json = new JsonObject();

    DeliveryOptions _deliveryOptions = (_options != null) ? new DeliveryOptions(_options) : new DeliveryOptions();
    _deliveryOptions.addHeader("action", "intNullHandler");
    _deliveryOptions.getHeaders().set("action", "intNullHandler");
    _vertx.eventBus().<Integer>request(_address, _json, _deliveryOptions, res -> {
      if (res.failed()) {
        resultHandler.handle(Future.failedFuture(res.cause()));
      } else {
        resultHandler.handle(Future.succeededFuture(res.result().body()));
      }
    });
  }
  @Override
  public void longHandler(Handler<AsyncResult<Long>> resultHandler){
    if (closed) {
      resultHandler.handle(Future.failedFuture(new IllegalStateException("Proxy is closed")));
      return;
    }
    JsonObject _json = new JsonObject();

    DeliveryOptions _deliveryOptions = (_options != null) ? new DeliveryOptions(_options) : new DeliveryOptions();
    _deliveryOptions.addHeader("action", "longHandler");
    _deliveryOptions.getHeaders().set("action", "longHandler");
    _vertx.eventBus().<Long>request(_address, _json, _deliveryOptions, res -> {
      if (res.failed()) {
        resultHandler.handle(Future.failedFuture(res.cause()));
      } else {
        resultHandler.handle(Future.succeededFuture(res.result().body()));
      }
    });
  }
  @Override
  public void longNullHandler(Handler<AsyncResult<Long>> resultHandler){
    if (closed) {
      resultHandler.handle(Future.failedFuture(new IllegalStateException("Proxy is closed")));
      return;
    }
    JsonObject _json = new JsonObject();

    DeliveryOptions _deliveryOptions = (_options != null) ? new DeliveryOptions(_options) : new DeliveryOptions();
    _deliveryOptions.addHeader("action", "longNullHandler");
    _deliveryOptions.getHeaders().set("action", "longNullHandler");
    _vertx.eventBus().<Long>request(_address, _json, _deliveryOptions, res -> {
      if (res.failed()) {
        resultHandler.handle(Future.failedFuture(res.cause()));
      } else {
        resultHandler.handle(Future.succeededFuture(res.result().body()));
      }
    });
  }
  @Override
  public void floatHandler(Handler<AsyncResult<Float>> resultHandler){
    if (closed) {
      resultHandler.handle(Future.failedFuture(new IllegalStateException("Proxy is closed")));
      return;
    }
    JsonObject _json = new JsonObject();

    DeliveryOptions _deliveryOptions = (_options != null) ? new DeliveryOptions(_options) : new DeliveryOptions();
    _deliveryOptions.addHeader("action", "floatHandler");
    _deliveryOptions.getHeaders().set("action", "floatHandler");
    _vertx.eventBus().<Float>request(_address, _json, _deliveryOptions, res -> {
      if (res.failed()) {
        resultHandler.handle(Future.failedFuture(res.cause()));
      } else {
        resultHandler.handle(Future.succeededFuture(res.result().body()));
      }
    });
  }
  @Override
  public void floatNullHandler(Handler<AsyncResult<Float>> resultHandler){
    if (closed) {
      resultHandler.handle(Future.failedFuture(new IllegalStateException("Proxy is closed")));
      return;
    }
    JsonObject _json = new JsonObject();

    DeliveryOptions _deliveryOptions = (_options != null) ? new DeliveryOptions(_options) : new DeliveryOptions();
    _deliveryOptions.addHeader("action", "floatNullHandler");
    _deliveryOptions.getHeaders().set("action", "floatNullHandler");
    _vertx.eventBus().<Float>request(_address, _json, _deliveryOptions, res -> {
      if (res.failed()) {
        resultHandler.handle(Future.failedFuture(res.cause()));
      } else {
        resultHandler.handle(Future.succeededFuture(res.result().body()));
      }
    });
  }
  @Override
  public void doubleHandler(Handler<AsyncResult<Double>> resultHandler){
    if (closed) {
      resultHandler.handle(Future.failedFuture(new IllegalStateException("Proxy is closed")));
      return;
    }
    JsonObject _json = new JsonObject();

    DeliveryOptions _deliveryOptions = (_options != null) ? new DeliveryOptions(_options) : new DeliveryOptions();
    _deliveryOptions.addHeader("action", "doubleHandler");
    _deliveryOptions.getHeaders().set("action", "doubleHandler");
    _vertx.eventBus().<Double>request(_address, _json, _deliveryOptions, res -> {
      if (res.failed()) {
        resultHandler.handle(Future.failedFuture(res.cause()));
      } else {
        resultHandler.handle(Future.succeededFuture(res.result().body()));
      }
    });
  }
  @Override
  public void doubleNullHandler(Handler<AsyncResult<Double>> resultHandler){
    if (closed) {
      resultHandler.handle(Future.failedFuture(new IllegalStateException("Proxy is closed")));
      return;
    }
    JsonObject _json = new JsonObject();

    DeliveryOptions _deliveryOptions = (_options != null) ? new DeliveryOptions(_options) : new DeliveryOptions();
    _deliveryOptions.addHeader("action", "doubleNullHandler");
    _deliveryOptions.getHeaders().set("action", "doubleNullHandler");
    _vertx.eventBus().<Double>request(_address, _json, _deliveryOptions, res -> {
      if (res.failed()) {
        resultHandler.handle(Future.failedFuture(res.cause()));
      } else {
        resultHandler.handle(Future.succeededFuture(res.result().body()));
      }
    });
  }
  @Override
  public void charHandler(Handler<AsyncResult<Character>> resultHandler){
    if (closed) {
      resultHandler.handle(Future.failedFuture(new IllegalStateException("Proxy is closed")));
      return;
    }
    JsonObject _json = new JsonObject();

    DeliveryOptions _deliveryOptions = (_options != null) ? new DeliveryOptions(_options) : new DeliveryOptions();
    _deliveryOptions.addHeader("action", "charHandler");
    _deliveryOptions.getHeaders().set("action", "charHandler");
    _vertx.eventBus().<Character>request(_address, _json, _deliveryOptions, res -> {
      if (res.failed()) {
        resultHandler.handle(Future.failedFuture(res.cause()));
      } else {
        resultHandler.handle(Future.succeededFuture(res.result().body()));
      }
    });
  }
  @Override
  public void charNullHandler(Handler<AsyncResult<Character>> resultHandler){
    if (closed) {
      resultHandler.handle(Future.failedFuture(new IllegalStateException("Proxy is closed")));
      return;
    }
    JsonObject _json = new JsonObject();

    DeliveryOptions _deliveryOptions = (_options != null) ? new DeliveryOptions(_options) : new DeliveryOptions();
    _deliveryOptions.addHeader("action", "charNullHandler");
    _deliveryOptions.getHeaders().set("action", "charNullHandler");
    _vertx.eventBus().<Character>request(_address, _json, _deliveryOptions, res -> {
      if (res.failed()) {
        resultHandler.handle(Future.failedFuture(res.cause()));
      } else {
        resultHandler.handle(Future.succeededFuture(res.result().body()));
      }
    });
  }
  @Override
  public void booleanHandler(Handler<AsyncResult<Boolean>> resultHandler){
    if (closed) {
      resultHandler.handle(Future.failedFuture(new IllegalStateException("Proxy is closed")));
      return;
    }
    JsonObject _json = new JsonObject();

    DeliveryOptions _deliveryOptions = (_options != null) ? new DeliveryOptions(_options) : new DeliveryOptions();
    _deliveryOptions.addHeader("action", "booleanHandler");
    _deliveryOptions.getHeaders().set("action", "booleanHandler");
    _vertx.eventBus().<Boolean>request(_address, _json, _deliveryOptions, res -> {
      if (res.failed()) {
        resultHandler.handle(Future.failedFuture(res.cause()));
      } else {
        resultHandler.handle(Future.succeededFuture(res.result().body()));
      }
    });
  }
  @Override
  public void booleanNullHandler(Handler<AsyncResult<Boolean>> resultHandler){
    if (closed) {
      resultHandler.handle(Future.failedFuture(new IllegalStateException("Proxy is closed")));
      return;
    }
    JsonObject _json = new JsonObject();

    DeliveryOptions _deliveryOptions = (_options != null) ? new DeliveryOptions(_options) : new DeliveryOptions();
    _deliveryOptions.addHeader("action", "booleanNullHandler");
    _deliveryOptions.getHeaders().set("action", "booleanNullHandler");
    _vertx.eventBus().<Boolean>request(_address, _json, _deliveryOptions, res -> {
      if (res.failed()) {
        resultHandler.handle(Future.failedFuture(res.cause()));
      } else {
        resultHandler.handle(Future.succeededFuture(res.result().body()));
      }
    });
  }
  @Override
  public void jsonObjectHandler(Handler<AsyncResult<JsonObject>> resultHandler){
    if (closed) {
      resultHandler.handle(Future.failedFuture(new IllegalStateException("Proxy is closed")));
      return;
    }
    JsonObject _json = new JsonObject();

    DeliveryOptions _deliveryOptions = (_options != null) ? new DeliveryOptions(_options) : new DeliveryOptions();
    _deliveryOptions.addHeader("action", "jsonObjectHandler");
    _deliveryOptions.getHeaders().set("action", "jsonObjectHandler");
    _vertx.eventBus().<JsonObject>request(_address, _json, _deliveryOptions, res -> {
      if (res.failed()) {
        resultHandler.handle(Future.failedFuture(res.cause()));
      } else {
        resultHandler.handle(Future.succeededFuture(res.result().body()));
      }
    });
  }
  @Override
  public void jsonObjectNullHandler(Handler<AsyncResult<JsonObject>> resultHandler){
    if (closed) {
      resultHandler.handle(Future.failedFuture(new IllegalStateException("Proxy is closed")));
      return;
    }
    JsonObject _json = new JsonObject();

    DeliveryOptions _deliveryOptions = (_options != null) ? new DeliveryOptions(_options) : new DeliveryOptions();
    _deliveryOptions.addHeader("action", "jsonObjectNullHandler");
    _deliveryOptions.getHeaders().set("action", "jsonObjectNullHandler");
    _vertx.eventBus().<JsonObject>request(_address, _json, _deliveryOptions, res -> {
      if (res.failed()) {
        resultHandler.handle(Future.failedFuture(res.cause()));
      } else {
        resultHandler.handle(Future.succeededFuture(res.result().body()));
      }
    });
  }
  @Override
  public void jsonArrayHandler(Handler<AsyncResult<JsonArray>> resultHandler){
    if (closed) {
      resultHandler.handle(Future.failedFuture(new IllegalStateException("Proxy is closed")));
      return;
    }
    JsonObject _json = new JsonObject();

    DeliveryOptions _deliveryOptions = (_options != null) ? new DeliveryOptions(_options) : new DeliveryOptions();
    _deliveryOptions.addHeader("action", "jsonArrayHandler");
    _deliveryOptions.getHeaders().set("action", "jsonArrayHandler");
    _vertx.eventBus().<JsonArray>request(_address, _json, _deliveryOptions, res -> {
      if (res.failed()) {
        resultHandler.handle(Future.failedFuture(res.cause()));
      } else {
        resultHandler.handle(Future.succeededFuture(res.result().body()));
      }
    });
  }
  @Override
  public void jsonArrayNullHandler(Handler<AsyncResult<JsonArray>> resultHandler){
    if (closed) {
      resultHandler.handle(Future.failedFuture(new IllegalStateException("Proxy is closed")));
      return;
    }
    JsonObject _json = new JsonObject();

    DeliveryOptions _deliveryOptions = (_options != null) ? new DeliveryOptions(_options) : new DeliveryOptions();
    _deliveryOptions.addHeader("action", "jsonArrayNullHandler");
    _deliveryOptions.getHeaders().set("action", "jsonArrayNullHandler");
    _vertx.eventBus().<JsonArray>request(_address, _json, _deliveryOptions, res -> {
      if (res.failed()) {
        resultHandler.handle(Future.failedFuture(res.cause()));
      } else {
        resultHandler.handle(Future.succeededFuture(res.result().body()));
      }
    });
  }
  @Override
  public void dataObjectHandler(Handler<AsyncResult<TestDataObject>> resultHandler){
    if (closed) {
      resultHandler.handle(Future.failedFuture(new IllegalStateException("Proxy is closed")));
      return;
    }
    JsonObject _json = new JsonObject();

    DeliveryOptions _deliveryOptions = (_options != null) ? new DeliveryOptions(_options) : new DeliveryOptions();
    _deliveryOptions.addHeader("action", "dataObjectHandler");
    _deliveryOptions.getHeaders().set("action", "dataObjectHandler");
    _vertx.eventBus().<JsonObject>request(_address, _json, _deliveryOptions, res -> {
      if (res.failed()) {
        resultHandler.handle(Future.failedFuture(res.cause()));
      } else {
        resultHandler.handle(Future.succeededFuture(res.result().body() != null ? new io.vertx.serviceproxy.testmodel.TestDataObject((JsonObject)res.result().body()) : null));
      }
    });
  }
  @Override
  public void dataObjectNullHandler(Handler<AsyncResult<TestDataObject>> resultHandler){
    if (closed) {
      resultHandler.handle(Future.failedFuture(new IllegalStateException("Proxy is closed")));
      return;
    }
    JsonObject _json = new JsonObject();

    DeliveryOptions _deliveryOptions = (_options != null) ? new DeliveryOptions(_options) : new DeliveryOptions();
    _deliveryOptions.addHeader("action", "dataObjectNullHandler");
    _deliveryOptions.getHeaders().set("action", "dataObjectNullHandler");
    _vertx.eventBus().<JsonObject>request(_address, _json, _deliveryOptions, res -> {
      if (res.failed()) {
        resultHandler.handle(Future.failedFuture(res.cause()));
      } else {
        resultHandler.handle(Future.succeededFuture(res.result().body() != null ? new io.vertx.serviceproxy.testmodel.TestDataObject((JsonObject)res.result().body()) : null));
      }
    });
  }
  @Override
  public void voidHandler(Handler<AsyncResult<Void>> resultHandler){
    if (closed) {
      resultHandler.handle(Future.failedFuture(new IllegalStateException("Proxy is closed")));
      return;
    }
    JsonObject _json = new JsonObject();

    DeliveryOptions _deliveryOptions = (_options != null) ? new DeliveryOptions(_options) : new DeliveryOptions();
    _deliveryOptions.addHeader("action", "voidHandler");
    _deliveryOptions.getHeaders().set("action", "voidHandler");
    _vertx.eventBus().<Void>request(_address, _json, _deliveryOptions, res -> {
      if (res.failed()) {
        resultHandler.handle(Future.failedFuture(res.cause()));
      } else {
        resultHandler.handle(Future.succeededFuture(res.result().body()));
      }
    });
  }
  @Override
  public TestService fluentMethod(String str, Handler<AsyncResult<String>> resultHandler){
    if (closed) {
      resultHandler.handle(Future.failedFuture(new IllegalStateException("Proxy is closed")));
      return this;
    }
    JsonObject _json = new JsonObject();
    _json.put("str", str);

    DeliveryOptions _deliveryOptions = (_options != null) ? new DeliveryOptions(_options) : new DeliveryOptions();
    _deliveryOptions.addHeader("action", "fluentMethod");
    _deliveryOptions.getHeaders().set("action", "fluentMethod");
    _vertx.eventBus().<String>request(_address, _json, _deliveryOptions, res -> {
      if (res.failed()) {
        resultHandler.handle(Future.failedFuture(res.cause()));
      } else {
        resultHandler.handle(Future.succeededFuture(res.result().body()));
      }
    });
    return this;
  }
  @Override
  public TestService fluentNoParams(){
    if (closed) throw new IllegalStateException("Proxy is closed");
    JsonObject _json = new JsonObject();

    DeliveryOptions _deliveryOptions = (_options != null) ? new DeliveryOptions(_options) : new DeliveryOptions();
    _deliveryOptions.addHeader("action", "fluentNoParams");
    _deliveryOptions.getHeaders().set("action", "fluentNoParams");
    _vertx.eventBus().send(_address, _json, _deliveryOptions);
    return this;
  }
  @Override
  public void failingMethod(Handler<AsyncResult<JsonObject>> resultHandler){
    if (closed) {
      resultHandler.handle(Future.failedFuture(new IllegalStateException("Proxy is closed")));
      return;
    }
    JsonObject _json = new JsonObject();

    DeliveryOptions _deliveryOptions = (_options != null) ? new DeliveryOptions(_options) : new DeliveryOptions();
    _deliveryOptions.addHeader("action", "failingMethod");
    _deliveryOptions.getHeaders().set("action", "failingMethod");
    _vertx.eventBus().<JsonObject>request(_address, _json, _deliveryOptions, res -> {
      if (res.failed()) {
        resultHandler.handle(Future.failedFuture(res.cause()));
      } else {
        resultHandler.handle(Future.succeededFuture(res.result().body()));
      }
    });
  }
  @Override
  public void invokeWithMessage(JsonObject object, String str, int i, char chr, SomeEnum senum, Handler<AsyncResult<String>> resultHandler){
    if (closed) {
      resultHandler.handle(Future.failedFuture(new IllegalStateException("Proxy is closed")));
      return;
    }
    JsonObject _json = new JsonObject();
    _json.put("object", object);
    _json.put("str", str);
    _json.put("i", i);
    _json.put("chr", (int)chr);
    _json.put("senum", senum == null ? null : senum.name());

    DeliveryOptions _deliveryOptions = (_options != null) ? new DeliveryOptions(_options) : new DeliveryOptions();
    _deliveryOptions.addHeader("action", "invokeWithMessage");
    _deliveryOptions.getHeaders().set("action", "invokeWithMessage");
    _vertx.eventBus().<String>request(_address, _json, _deliveryOptions, res -> {
      if (res.failed()) {
        resultHandler.handle(Future.failedFuture(res.cause()));
      } else {
        resultHandler.handle(Future.succeededFuture(res.result().body()));
      }
    });
  }
  @Override
  public void listStringHandler(Handler<AsyncResult<List<String>>> resultHandler){
    if (closed) {
      resultHandler.handle(Future.failedFuture(new IllegalStateException("Proxy is closed")));
      return;
    }
    JsonObject _json = new JsonObject();

    DeliveryOptions _deliveryOptions = (_options != null) ? new DeliveryOptions(_options) : new DeliveryOptions();
    _deliveryOptions.addHeader("action", "listStringHandler");
    _deliveryOptions.getHeaders().set("action", "listStringHandler");
    _vertx.eventBus().<JsonArray>request(_address, _json, _deliveryOptions, res -> {
      if (res.failed()) {
        resultHandler.handle(Future.failedFuture(res.cause()));
      } else {
        resultHandler.handle(Future.succeededFuture(ProxyUtils.convertList(res.result().body().getList())));
      }
    });
  }
  @Override
  public void listByteHandler(Handler<AsyncResult<List<Byte>>> resultHandler){
    if (closed) {
      resultHandler.handle(Future.failedFuture(new IllegalStateException("Proxy is closed")));
      return;
    }
    JsonObject _json = new JsonObject();

    DeliveryOptions _deliveryOptions = (_options != null) ? new DeliveryOptions(_options) : new DeliveryOptions();
    _deliveryOptions.addHeader("action", "listByteHandler");
    _deliveryOptions.getHeaders().set("action", "listByteHandler");
    _vertx.eventBus().<JsonArray>request(_address, _json, _deliveryOptions, res -> {
      if (res.failed()) {
        resultHandler.handle(Future.failedFuture(res.cause()));
      } else {
        resultHandler.handle(Future.succeededFuture(ProxyUtils.convertList(res.result().body().getList())));
      }
    });
  }
  @Override
  public void listShortHandler(Handler<AsyncResult<List<Short>>> resultHandler){
    if (closed) {
      resultHandler.handle(Future.failedFuture(new IllegalStateException("Proxy is closed")));
      return;
    }
    JsonObject _json = new JsonObject();

    DeliveryOptions _deliveryOptions = (_options != null) ? new DeliveryOptions(_options) : new DeliveryOptions();
    _deliveryOptions.addHeader("action", "listShortHandler");
    _deliveryOptions.getHeaders().set("action", "listShortHandler");
    _vertx.eventBus().<JsonArray>request(_address, _json, _deliveryOptions, res -> {
      if (res.failed()) {
        resultHandler.handle(Future.failedFuture(res.cause()));
      } else {
        resultHandler.handle(Future.succeededFuture(ProxyUtils.convertList(res.result().body().getList())));
      }
    });
  }
  @Override
  public void listIntHandler(Handler<AsyncResult<List<Integer>>> resultHandler){
    if (closed) {
      resultHandler.handle(Future.failedFuture(new IllegalStateException("Proxy is closed")));
      return;
    }
    JsonObject _json = new JsonObject();

    DeliveryOptions _deliveryOptions = (_options != null) ? new DeliveryOptions(_options) : new DeliveryOptions();
    _deliveryOptions.addHeader("action", "listIntHandler");
    _deliveryOptions.getHeaders().set("action", "listIntHandler");
    _vertx.eventBus().<JsonArray>request(_address, _json, _deliveryOptions, res -> {
      if (res.failed()) {
        resultHandler.handle(Future.failedFuture(res.cause()));
      } else {
        resultHandler.handle(Future.succeededFuture(ProxyUtils.convertList(res.result().body().getList())));
      }
    });
  }
  @Override
  public void listLongHandler(Handler<AsyncResult<List<Long>>> resultHandler){
    if (closed) {
      resultHandler.handle(Future.failedFuture(new IllegalStateException("Proxy is closed")));
      return;
    }
    JsonObject _json = new JsonObject();

    DeliveryOptions _deliveryOptions = (_options != null) ? new DeliveryOptions(_options) : new DeliveryOptions();
    _deliveryOptions.addHeader("action", "listLongHandler");
    _deliveryOptions.getHeaders().set("action", "listLongHandler");
    _vertx.eventBus().<JsonArray>request(_address, _json, _deliveryOptions, res -> {
      if (res.failed()) {
        resultHandler.handle(Future.failedFuture(res.cause()));
      } else {
        resultHandler.handle(Future.succeededFuture(ProxyUtils.convertList(res.result().body().getList())));
      }
    });
  }
  @Override
  public void listFloatHandler(Handler<AsyncResult<List<Float>>> resultHandler){
    if (closed) {
      resultHandler.handle(Future.failedFuture(new IllegalStateException("Proxy is closed")));
      return;
    }
    JsonObject _json = new JsonObject();

    DeliveryOptions _deliveryOptions = (_options != null) ? new DeliveryOptions(_options) : new DeliveryOptions();
    _deliveryOptions.addHeader("action", "listFloatHandler");
    _deliveryOptions.getHeaders().set("action", "listFloatHandler");
    _vertx.eventBus().<JsonArray>request(_address, _json, _deliveryOptions, res -> {
      if (res.failed()) {
        resultHandler.handle(Future.failedFuture(res.cause()));
      } else {
        resultHandler.handle(Future.succeededFuture(ProxyUtils.convertList(res.result().body().getList())));
      }
    });
  }
  @Override
  public void listDoubleHandler(Handler<AsyncResult<List<Double>>> resultHandler){
    if (closed) {
      resultHandler.handle(Future.failedFuture(new IllegalStateException("Proxy is closed")));
      return;
    }
    JsonObject _json = new JsonObject();

    DeliveryOptions _deliveryOptions = (_options != null) ? new DeliveryOptions(_options) : new DeliveryOptions();
    _deliveryOptions.addHeader("action", "listDoubleHandler");
    _deliveryOptions.getHeaders().set("action", "listDoubleHandler");
    _vertx.eventBus().<JsonArray>request(_address, _json, _deliveryOptions, res -> {
      if (res.failed()) {
        resultHandler.handle(Future.failedFuture(res.cause()));
      } else {
        resultHandler.handle(Future.succeededFuture(ProxyUtils.convertList(res.result().body().getList())));
      }
    });
  }
  @Override
  public void listCharHandler(Handler<AsyncResult<List<Character>>> resultHandler){
    if (closed) {
      resultHandler.handle(Future.failedFuture(new IllegalStateException("Proxy is closed")));
      return;
    }
    JsonObject _json = new JsonObject();

    DeliveryOptions _deliveryOptions = (_options != null) ? new DeliveryOptions(_options) : new DeliveryOptions();
    _deliveryOptions.addHeader("action", "listCharHandler");
    _deliveryOptions.getHeaders().set("action", "listCharHandler");
    _vertx.eventBus().<JsonArray>request(_address, _json, _deliveryOptions, res -> {
      if (res.failed()) {
        resultHandler.handle(Future.failedFuture(res.cause()));
      } else {
        resultHandler.handle(Future.succeededFuture(ProxyUtils.convertToListChar(res.result().body())));
      }
    });
  }
  @Override
  public void listBoolHandler(Handler<AsyncResult<List<Boolean>>> resultHandler){
    if (closed) {
      resultHandler.handle(Future.failedFuture(new IllegalStateException("Proxy is closed")));
      return;
    }
    JsonObject _json = new JsonObject();

    DeliveryOptions _deliveryOptions = (_options != null) ? new DeliveryOptions(_options) : new DeliveryOptions();
    _deliveryOptions.addHeader("action", "listBoolHandler");
    _deliveryOptions.getHeaders().set("action", "listBoolHandler");
    _vertx.eventBus().<JsonArray>request(_address, _json, _deliveryOptions, res -> {
      if (res.failed()) {
        resultHandler.handle(Future.failedFuture(res.cause()));
      } else {
        resultHandler.handle(Future.succeededFuture(ProxyUtils.convertList(res.result().body().getList())));
      }
    });
  }
  @Override
  public void listJsonObjectHandler(Handler<AsyncResult<List<JsonObject>>> resultHandler){
    if (closed) {
      resultHandler.handle(Future.failedFuture(new IllegalStateException("Proxy is closed")));
      return;
    }
    JsonObject _json = new JsonObject();

    DeliveryOptions _deliveryOptions = (_options != null) ? new DeliveryOptions(_options) : new DeliveryOptions();
    _deliveryOptions.addHeader("action", "listJsonObjectHandler");
    _deliveryOptions.getHeaders().set("action", "listJsonObjectHandler");
    _vertx.eventBus().<JsonArray>request(_address, _json, _deliveryOptions, res -> {
      if (res.failed()) {
        resultHandler.handle(Future.failedFuture(res.cause()));
      } else {
        resultHandler.handle(Future.succeededFuture(ProxyUtils.convertList(res.result().body().getList())));
      }
    });
  }
  @Override
  public void listJsonArrayHandler(Handler<AsyncResult<List<JsonArray>>> resultHandler){
    if (closed) {
      resultHandler.handle(Future.failedFuture(new IllegalStateException("Proxy is closed")));
      return;
    }
    JsonObject _json = new JsonObject();

    DeliveryOptions _deliveryOptions = (_options != null) ? new DeliveryOptions(_options) : new DeliveryOptions();
    _deliveryOptions.addHeader("action", "listJsonArrayHandler");
    _deliveryOptions.getHeaders().set("action", "listJsonArrayHandler");
    _vertx.eventBus().<JsonArray>request(_address, _json, _deliveryOptions, res -> {
      if (res.failed()) {
        resultHandler.handle(Future.failedFuture(res.cause()));
      } else {
        resultHandler.handle(Future.succeededFuture(ProxyUtils.convertList(res.result().body().getList())));
      }
    });
  }
  @Override
  public void listDataObjectHandler(Handler<AsyncResult<List<TestDataObject>>> resultHandler){
    if (closed) {
      resultHandler.handle(Future.failedFuture(new IllegalStateException("Proxy is closed")));
      return;
    }
    JsonObject _json = new JsonObject();

    DeliveryOptions _deliveryOptions = (_options != null) ? new DeliveryOptions(_options) : new DeliveryOptions();
    _deliveryOptions.addHeader("action", "listDataObjectHandler");
    _deliveryOptions.getHeaders().set("action", "listDataObjectHandler");
    _vertx.eventBus().<JsonArray>request(_address, _json, _deliveryOptions, res -> {
      if (res.failed()) {
        resultHandler.handle(Future.failedFuture(res.cause()));
      } else {
        resultHandler.handle(Future.succeededFuture(res.result().body().stream()
          .map(v -> v != null ? new io.vertx.serviceproxy.testmodel.TestDataObject((JsonObject)v) : null)
          .collect(Collectors.toList())));
      }
    });
  }
  @Override
  public void setStringHandler(Handler<AsyncResult<Set<String>>> resultHandler){
    if (closed) {
      resultHandler.handle(Future.failedFuture(new IllegalStateException("Proxy is closed")));
      return;
    }
    JsonObject _json = new JsonObject();

    DeliveryOptions _deliveryOptions = (_options != null) ? new DeliveryOptions(_options) : new DeliveryOptions();
    _deliveryOptions.addHeader("action", "setStringHandler");
    _deliveryOptions.getHeaders().set("action", "setStringHandler");
    _vertx.eventBus().<JsonArray>request(_address, _json, _deliveryOptions, res -> {
      if (res.failed()) {
        resultHandler.handle(Future.failedFuture(res.cause()));
      } else {
        resultHandler.handle(Future.succeededFuture(ProxyUtils.convertSet(res.result().body().getList())));
      }
    });
  }
  @Override
  public void setByteHandler(Handler<AsyncResult<Set<Byte>>> resultHandler){
    if (closed) {
      resultHandler.handle(Future.failedFuture(new IllegalStateException("Proxy is closed")));
      return;
    }
    JsonObject _json = new JsonObject();

    DeliveryOptions _deliveryOptions = (_options != null) ? new DeliveryOptions(_options) : new DeliveryOptions();
    _deliveryOptions.addHeader("action", "setByteHandler");
    _deliveryOptions.getHeaders().set("action", "setByteHandler");
    _vertx.eventBus().<JsonArray>request(_address, _json, _deliveryOptions, res -> {
      if (res.failed()) {
        resultHandler.handle(Future.failedFuture(res.cause()));
      } else {
        resultHandler.handle(Future.succeededFuture(ProxyUtils.convertSet(res.result().body().getList())));
      }
    });
  }
  @Override
  public void setShortHandler(Handler<AsyncResult<Set<Short>>> resultHandler){
    if (closed) {
      resultHandler.handle(Future.failedFuture(new IllegalStateException("Proxy is closed")));
      return;
    }
    JsonObject _json = new JsonObject();

    DeliveryOptions _deliveryOptions = (_options != null) ? new DeliveryOptions(_options) : new DeliveryOptions();
    _deliveryOptions.addHeader("action", "setShortHandler");
    _deliveryOptions.getHeaders().set("action", "setShortHandler");
    _vertx.eventBus().<JsonArray>request(_address, _json, _deliveryOptions, res -> {
      if (res.failed()) {
        resultHandler.handle(Future.failedFuture(res.cause()));
      } else {
        resultHandler.handle(Future.succeededFuture(ProxyUtils.convertSet(res.result().body().getList())));
      }
    });
  }
  @Override
  public void setIntHandler(Handler<AsyncResult<Set<Integer>>> resultHandler){
    if (closed) {
      resultHandler.handle(Future.failedFuture(new IllegalStateException("Proxy is closed")));
      return;
    }
    JsonObject _json = new JsonObject();

    DeliveryOptions _deliveryOptions = (_options != null) ? new DeliveryOptions(_options) : new DeliveryOptions();
    _deliveryOptions.addHeader("action", "setIntHandler");
    _deliveryOptions.getHeaders().set("action", "setIntHandler");
    _vertx.eventBus().<JsonArray>request(_address, _json, _deliveryOptions, res -> {
      if (res.failed()) {
        resultHandler.handle(Future.failedFuture(res.cause()));
      } else {
        resultHandler.handle(Future.succeededFuture(ProxyUtils.convertSet(res.result().body().getList())));
      }
    });
  }
  @Override
  public void setLongHandler(Handler<AsyncResult<Set<Long>>> resultHandler){
    if (closed) {
      resultHandler.handle(Future.failedFuture(new IllegalStateException("Proxy is closed")));
      return;
    }
    JsonObject _json = new JsonObject();

    DeliveryOptions _deliveryOptions = (_options != null) ? new DeliveryOptions(_options) : new DeliveryOptions();
    _deliveryOptions.addHeader("action", "setLongHandler");
    _deliveryOptions.getHeaders().set("action", "setLongHandler");
    _vertx.eventBus().<JsonArray>request(_address, _json, _deliveryOptions, res -> {
      if (res.failed()) {
        resultHandler.handle(Future.failedFuture(res.cause()));
      } else {
        resultHandler.handle(Future.succeededFuture(ProxyUtils.convertSet(res.result().body().getList())));
      }
    });
  }
  @Override
  public void setFloatHandler(Handler<AsyncResult<Set<Float>>> resultHandler){
    if (closed) {
      resultHandler.handle(Future.failedFuture(new IllegalStateException("Proxy is closed")));
      return;
    }
    JsonObject _json = new JsonObject();

    DeliveryOptions _deliveryOptions = (_options != null) ? new DeliveryOptions(_options) : new DeliveryOptions();
    _deliveryOptions.addHeader("action", "setFloatHandler");
    _deliveryOptions.getHeaders().set("action", "setFloatHandler");
    _vertx.eventBus().<JsonArray>request(_address, _json, _deliveryOptions, res -> {
      if (res.failed()) {
        resultHandler.handle(Future.failedFuture(res.cause()));
      } else {
        resultHandler.handle(Future.succeededFuture(ProxyUtils.convertSet(res.result().body().getList())));
      }
    });
  }
  @Override
  public void setDoubleHandler(Handler<AsyncResult<Set<Double>>> resultHandler){
    if (closed) {
      resultHandler.handle(Future.failedFuture(new IllegalStateException("Proxy is closed")));
      return;
    }
    JsonObject _json = new JsonObject();

    DeliveryOptions _deliveryOptions = (_options != null) ? new DeliveryOptions(_options) : new DeliveryOptions();
    _deliveryOptions.addHeader("action", "setDoubleHandler");
    _deliveryOptions.getHeaders().set("action", "setDoubleHandler");
    _vertx.eventBus().<JsonArray>request(_address, _json, _deliveryOptions, res -> {
      if (res.failed()) {
        resultHandler.handle(Future.failedFuture(res.cause()));
      } else {
        resultHandler.handle(Future.succeededFuture(ProxyUtils.convertSet(res.result().body().getList())));
      }
    });
  }
  @Override
  public void setCharHandler(Handler<AsyncResult<Set<Character>>> resultHandler){
    if (closed) {
      resultHandler.handle(Future.failedFuture(new IllegalStateException("Proxy is closed")));
      return;
    }
    JsonObject _json = new JsonObject();

    DeliveryOptions _deliveryOptions = (_options != null) ? new DeliveryOptions(_options) : new DeliveryOptions();
    _deliveryOptions.addHeader("action", "setCharHandler");
    _deliveryOptions.getHeaders().set("action", "setCharHandler");
    _vertx.eventBus().<JsonArray>request(_address, _json, _deliveryOptions, res -> {
      if (res.failed()) {
        resultHandler.handle(Future.failedFuture(res.cause()));
      } else {
        resultHandler.handle(Future.succeededFuture(ProxyUtils.convertToSetChar(res.result().body())));
      }
    });
  }
  @Override
  public void setBoolHandler(Handler<AsyncResult<Set<Boolean>>> resultHandler){
    if (closed) {
      resultHandler.handle(Future.failedFuture(new IllegalStateException("Proxy is closed")));
      return;
    }
    JsonObject _json = new JsonObject();

    DeliveryOptions _deliveryOptions = (_options != null) ? new DeliveryOptions(_options) : new DeliveryOptions();
    _deliveryOptions.addHeader("action", "setBoolHandler");
    _deliveryOptions.getHeaders().set("action", "setBoolHandler");
    _vertx.eventBus().<JsonArray>request(_address, _json, _deliveryOptions, res -> {
      if (res.failed()) {
        resultHandler.handle(Future.failedFuture(res.cause()));
      } else {
        resultHandler.handle(Future.succeededFuture(ProxyUtils.convertSet(res.result().body().getList())));
      }
    });
  }
  @Override
  public void mapStringHandler(Handler<AsyncResult<Map<String,String>>> resultHandler){
    if (closed) {
      resultHandler.handle(Future.failedFuture(new IllegalStateException("Proxy is closed")));
      return;
    }
    JsonObject _json = new JsonObject();

    DeliveryOptions _deliveryOptions = (_options != null) ? new DeliveryOptions(_options) : new DeliveryOptions();
    _deliveryOptions.addHeader("action", "mapStringHandler");
    _deliveryOptions.getHeaders().set("action", "mapStringHandler");
    _vertx.eventBus().<JsonObject>request(_address, _json, _deliveryOptions, res -> {
      if (res.failed()) {
        resultHandler.handle(Future.failedFuture(res.cause()));
      } else {
        resultHandler.handle(Future.succeededFuture(ProxyUtils.convertMap(res.result().body().getMap())));
      }
    });
  }
  @Override
  public void mapByteHandler(Handler<AsyncResult<Map<String,Byte>>> resultHandler){
    if (closed) {
      resultHandler.handle(Future.failedFuture(new IllegalStateException("Proxy is closed")));
      return;
    }
    JsonObject _json = new JsonObject();

    DeliveryOptions _deliveryOptions = (_options != null) ? new DeliveryOptions(_options) : new DeliveryOptions();
    _deliveryOptions.addHeader("action", "mapByteHandler");
    _deliveryOptions.getHeaders().set("action", "mapByteHandler");
    _vertx.eventBus().<JsonObject>request(_address, _json, _deliveryOptions, res -> {
      if (res.failed()) {
        resultHandler.handle(Future.failedFuture(res.cause()));
      } else {
        resultHandler.handle(Future.succeededFuture(ProxyUtils.convertMap(res.result().body().getMap())));
      }
    });
  }
  @Override
  public void mapShortHandler(Handler<AsyncResult<Map<String,Short>>> resultHandler){
    if (closed) {
      resultHandler.handle(Future.failedFuture(new IllegalStateException("Proxy is closed")));
      return;
    }
    JsonObject _json = new JsonObject();

    DeliveryOptions _deliveryOptions = (_options != null) ? new DeliveryOptions(_options) : new DeliveryOptions();
    _deliveryOptions.addHeader("action", "mapShortHandler");
    _deliveryOptions.getHeaders().set("action", "mapShortHandler");
    _vertx.eventBus().<JsonObject>request(_address, _json, _deliveryOptions, res -> {
      if (res.failed()) {
        resultHandler.handle(Future.failedFuture(res.cause()));
      } else {
        resultHandler.handle(Future.succeededFuture(ProxyUtils.convertMap(res.result().body().getMap())));
      }
    });
  }
  @Override
  public void mapIntHandler(Handler<AsyncResult<Map<String,Integer>>> resultHandler){
    if (closed) {
      resultHandler.handle(Future.failedFuture(new IllegalStateException("Proxy is closed")));
      return;
    }
    JsonObject _json = new JsonObject();

    DeliveryOptions _deliveryOptions = (_options != null) ? new DeliveryOptions(_options) : new DeliveryOptions();
    _deliveryOptions.addHeader("action", "mapIntHandler");
    _deliveryOptions.getHeaders().set("action", "mapIntHandler");
    _vertx.eventBus().<JsonObject>request(_address, _json, _deliveryOptions, res -> {
      if (res.failed()) {
        resultHandler.handle(Future.failedFuture(res.cause()));
      } else {
        resultHandler.handle(Future.succeededFuture(ProxyUtils.convertMap(res.result().body().getMap())));
      }
    });
  }
  @Override
  public void mapLongHandler(Handler<AsyncResult<Map<String,Long>>> resultHandler){
    if (closed) {
      resultHandler.handle(Future.failedFuture(new IllegalStateException("Proxy is closed")));
      return;
    }
    JsonObject _json = new JsonObject();

    DeliveryOptions _deliveryOptions = (_options != null) ? new DeliveryOptions(_options) : new DeliveryOptions();
    _deliveryOptions.addHeader("action", "mapLongHandler");
    _deliveryOptions.getHeaders().set("action", "mapLongHandler");
    _vertx.eventBus().<JsonObject>request(_address, _json, _deliveryOptions, res -> {
      if (res.failed()) {
        resultHandler.handle(Future.failedFuture(res.cause()));
      } else {
        resultHandler.handle(Future.succeededFuture(ProxyUtils.convertMap(res.result().body().getMap())));
      }
    });
  }
  @Override
  public void mapFloatHandler(Handler<AsyncResult<Map<String,Float>>> resultHandler){
    if (closed) {
      resultHandler.handle(Future.failedFuture(new IllegalStateException("Proxy is closed")));
      return;
    }
    JsonObject _json = new JsonObject();

    DeliveryOptions _deliveryOptions = (_options != null) ? new DeliveryOptions(_options) : new DeliveryOptions();
    _deliveryOptions.addHeader("action", "mapFloatHandler");
    _deliveryOptions.getHeaders().set("action", "mapFloatHandler");
    _vertx.eventBus().<JsonObject>request(_address, _json, _deliveryOptions, res -> {
      if (res.failed()) {
        resultHandler.handle(Future.failedFuture(res.cause()));
      } else {
        resultHandler.handle(Future.succeededFuture(ProxyUtils.convertMap(res.result().body().getMap())));
      }
    });
  }
  @Override
  public void mapDoubleHandler(Handler<AsyncResult<Map<String,Double>>> resultHandler){
    if (closed) {
      resultHandler.handle(Future.failedFuture(new IllegalStateException("Proxy is closed")));
      return;
    }
    JsonObject _json = new JsonObject();

    DeliveryOptions _deliveryOptions = (_options != null) ? new DeliveryOptions(_options) : new DeliveryOptions();
    _deliveryOptions.addHeader("action", "mapDoubleHandler");
    _deliveryOptions.getHeaders().set("action", "mapDoubleHandler");
    _vertx.eventBus().<JsonObject>request(_address, _json, _deliveryOptions, res -> {
      if (res.failed()) {
        resultHandler.handle(Future.failedFuture(res.cause()));
      } else {
        resultHandler.handle(Future.succeededFuture(ProxyUtils.convertMap(res.result().body().getMap())));
      }
    });
  }
  @Override
  public void mapCharHandler(Handler<AsyncResult<Map<String,Character>>> resultHandler){
    if (closed) {
      resultHandler.handle(Future.failedFuture(new IllegalStateException("Proxy is closed")));
      return;
    }
    JsonObject _json = new JsonObject();

    DeliveryOptions _deliveryOptions = (_options != null) ? new DeliveryOptions(_options) : new DeliveryOptions();
    _deliveryOptions.addHeader("action", "mapCharHandler");
    _deliveryOptions.getHeaders().set("action", "mapCharHandler");
    _vertx.eventBus().<JsonObject>request(_address, _json, _deliveryOptions, res -> {
      if (res.failed()) {
        resultHandler.handle(Future.failedFuture(res.cause()));
      } else {
        resultHandler.handle(Future.succeededFuture(ProxyUtils.convertToMapChar(res.result().body())));
      }
    });
  }
  @Override
  public void mapBoolHandler(Handler<AsyncResult<Map<String,Boolean>>> resultHandler){
    if (closed) {
      resultHandler.handle(Future.failedFuture(new IllegalStateException("Proxy is closed")));
      return;
    }
    JsonObject _json = new JsonObject();

    DeliveryOptions _deliveryOptions = (_options != null) ? new DeliveryOptions(_options) : new DeliveryOptions();
    _deliveryOptions.addHeader("action", "mapBoolHandler");
    _deliveryOptions.getHeaders().set("action", "mapBoolHandler");
    _vertx.eventBus().<JsonObject>request(_address, _json, _deliveryOptions, res -> {
      if (res.failed()) {
        resultHandler.handle(Future.failedFuture(res.cause()));
      } else {
        resultHandler.handle(Future.succeededFuture(ProxyUtils.convertMap(res.result().body().getMap())));
      }
    });
  }
  @Override
  public void setJsonObjectHandler(Handler<AsyncResult<Set<JsonObject>>> resultHandler){
    if (closed) {
      resultHandler.handle(Future.failedFuture(new IllegalStateException("Proxy is closed")));
      return;
    }
    JsonObject _json = new JsonObject();

    DeliveryOptions _deliveryOptions = (_options != null) ? new DeliveryOptions(_options) : new DeliveryOptions();
    _deliveryOptions.addHeader("action", "setJsonObjectHandler");
    _deliveryOptions.getHeaders().set("action", "setJsonObjectHandler");
    _vertx.eventBus().<JsonArray>request(_address, _json, _deliveryOptions, res -> {
      if (res.failed()) {
        resultHandler.handle(Future.failedFuture(res.cause()));
      } else {
        resultHandler.handle(Future.succeededFuture(ProxyUtils.convertSet(res.result().body().getList())));
      }
    });
  }
  @Override
  public void mapJsonObjectHandler(Handler<AsyncResult<Map<String,JsonObject>>> resultHandler){
    if (closed) {
      resultHandler.handle(Future.failedFuture(new IllegalStateException("Proxy is closed")));
      return;
    }
    JsonObject _json = new JsonObject();

    DeliveryOptions _deliveryOptions = (_options != null) ? new DeliveryOptions(_options) : new DeliveryOptions();
    _deliveryOptions.addHeader("action", "mapJsonObjectHandler");
    _deliveryOptions.getHeaders().set("action", "mapJsonObjectHandler");
    _vertx.eventBus().<JsonObject>request(_address, _json, _deliveryOptions, res -> {
      if (res.failed()) {
        resultHandler.handle(Future.failedFuture(res.cause()));
      } else {
        resultHandler.handle(Future.succeededFuture(ProxyUtils.convertMap(res.result().body().getMap())));
      }
    });
  }
  @Override
  public void setJsonArrayHandler(Handler<AsyncResult<Set<JsonArray>>> resultHandler){
    if (closed) {
      resultHandler.handle(Future.failedFuture(new IllegalStateException("Proxy is closed")));
      return;
    }
    JsonObject _json = new JsonObject();

    DeliveryOptions _deliveryOptions = (_options != null) ? new DeliveryOptions(_options) : new DeliveryOptions();
    _deliveryOptions.addHeader("action", "setJsonArrayHandler");
    _deliveryOptions.getHeaders().set("action", "setJsonArrayHandler");
    _vertx.eventBus().<JsonArray>request(_address, _json, _deliveryOptions, res -> {
      if (res.failed()) {
        resultHandler.handle(Future.failedFuture(res.cause()));
      } else {
        resultHandler.handle(Future.succeededFuture(ProxyUtils.convertSet(res.result().body().getList())));
      }
    });
  }
  @Override
  public void mapJsonArrayHandler(Handler<AsyncResult<Map<String,JsonArray>>> resultHandler){
    if (closed) {
      resultHandler.handle(Future.failedFuture(new IllegalStateException("Proxy is closed")));
      return;
    }
    JsonObject _json = new JsonObject();

    DeliveryOptions _deliveryOptions = (_options != null) ? new DeliveryOptions(_options) : new DeliveryOptions();
    _deliveryOptions.addHeader("action", "mapJsonArrayHandler");
    _deliveryOptions.getHeaders().set("action", "mapJsonArrayHandler");
    _vertx.eventBus().<JsonObject>request(_address, _json, _deliveryOptions, res -> {
      if (res.failed()) {
        resultHandler.handle(Future.failedFuture(res.cause()));
      } else {
        resultHandler.handle(Future.succeededFuture(ProxyUtils.convertMap(res.result().body().getMap())));
      }
    });
  }
  @Override
  public void setDataObjectHandler(Handler<AsyncResult<Set<TestDataObject>>> resultHandler){
    if (closed) {
      resultHandler.handle(Future.failedFuture(new IllegalStateException("Proxy is closed")));
      return;
    }
    JsonObject _json = new JsonObject();

    DeliveryOptions _deliveryOptions = (_options != null) ? new DeliveryOptions(_options) : new DeliveryOptions();
    _deliveryOptions.addHeader("action", "setDataObjectHandler");
    _deliveryOptions.getHeaders().set("action", "setDataObjectHandler");
    _vertx.eventBus().<JsonArray>request(_address, _json, _deliveryOptions, res -> {
      if (res.failed()) {
        resultHandler.handle(Future.failedFuture(res.cause()));
      } else {
        resultHandler.handle(Future.succeededFuture(res.result().body().stream()
          .map(v -> v != null ? new io.vertx.serviceproxy.testmodel.TestDataObject((JsonObject)v) : null)
          .collect(Collectors.toSet())));
      }
    });
  }
  @Override
  public void mapDataObject(Handler<AsyncResult<Map<String,TestDataObject>>> resultHandler){
    if (closed) {
      resultHandler.handle(Future.failedFuture(new IllegalStateException("Proxy is closed")));
      return;
    }
    JsonObject _json = new JsonObject();

    DeliveryOptions _deliveryOptions = (_options != null) ? new DeliveryOptions(_options) : new DeliveryOptions();
    _deliveryOptions.addHeader("action", "mapDataObject");
    _deliveryOptions.getHeaders().set("action", "mapDataObject");
    _vertx.eventBus().<JsonObject>request(_address, _json, _deliveryOptions, res -> {
      if (res.failed()) {
        resultHandler.handle(Future.failedFuture(res.cause()));
      } else {
        resultHandler.handle(Future.succeededFuture(res.result().body().stream()
          .collect(Collectors.toMap(Map.Entry::getKey, e -> e.getValue() != null ? new io.vertx.serviceproxy.testmodel.TestDataObject((JsonObject)e.getValue()) : null))));
      }
    });
  }
  @Override
  public void failingCall(String value, Handler<AsyncResult<JsonObject>> resultHandler){
    if (closed) {
      resultHandler.handle(Future.failedFuture(new IllegalStateException("Proxy is closed")));
      return;
    }
    JsonObject _json = new JsonObject();
    _json.put("value", value);

    DeliveryOptions _deliveryOptions = (_options != null) ? new DeliveryOptions(_options) : new DeliveryOptions();
    _deliveryOptions.addHeader("action", "failingCall");
    _deliveryOptions.getHeaders().set("action", "failingCall");
    _vertx.eventBus().<JsonObject>request(_address, _json, _deliveryOptions, res -> {
      if (res.failed()) {
        resultHandler.handle(Future.failedFuture(res.cause()));
      } else {
        resultHandler.handle(Future.succeededFuture(res.result().body()));
      }
    });
  }
  @Override
  public void listDataObjectContainingNullHandler(Handler<AsyncResult<List<TestDataObject>>> resultHandler){
    if (closed) {
      resultHandler.handle(Future.failedFuture(new IllegalStateException("Proxy is closed")));
      return;
    }
    JsonObject _json = new JsonObject();

    DeliveryOptions _deliveryOptions = (_options != null) ? new DeliveryOptions(_options) : new DeliveryOptions();
    _deliveryOptions.addHeader("action", "listDataObjectContainingNullHandler");
    _deliveryOptions.getHeaders().set("action", "listDataObjectContainingNullHandler");
    _vertx.eventBus().<JsonArray>request(_address, _json, _deliveryOptions, res -> {
      if (res.failed()) {
        resultHandler.handle(Future.failedFuture(res.cause()));
      } else {
        resultHandler.handle(Future.succeededFuture(res.result().body().stream()
          .map(v -> v != null ? new io.vertx.serviceproxy.testmodel.TestDataObject((JsonObject)v) : null)
          .collect(Collectors.toList())));
      }
    });
  }
  @Override
  public void setDataObjectContainingNullHandler(Handler<AsyncResult<Set<TestDataObject>>> resultHandler){
    if (closed) {
      resultHandler.handle(Future.failedFuture(new IllegalStateException("Proxy is closed")));
      return;
    }
    JsonObject _json = new JsonObject();

    DeliveryOptions _deliveryOptions = (_options != null) ? new DeliveryOptions(_options) : new DeliveryOptions();
    _deliveryOptions.addHeader("action", "setDataObjectContainingNullHandler");
    _deliveryOptions.getHeaders().set("action", "setDataObjectContainingNullHandler");
    _vertx.eventBus().<JsonArray>request(_address, _json, _deliveryOptions, res -> {
      if (res.failed()) {
        resultHandler.handle(Future.failedFuture(res.cause()));
      } else {
        resultHandler.handle(Future.succeededFuture(res.result().body().stream()
          .map(v -> v != null ? new io.vertx.serviceproxy.testmodel.TestDataObject((JsonObject)v) : null)
          .collect(Collectors.toSet())));
      }
    });
  }
  @Override
  public void zonedDateTimeHandler(Handler<AsyncResult<ZonedDateTime>> resultHandler){
    if (closed) {
      resultHandler.handle(Future.failedFuture(new IllegalStateException("Proxy is closed")));
      return;
    }
    JsonObject _json = new JsonObject();

    DeliveryOptions _deliveryOptions = (_options != null) ? new DeliveryOptions(_options) : new DeliveryOptions();
    _deliveryOptions.addHeader("action", "zonedDateTimeHandler");
    _deliveryOptions.getHeaders().set("action", "zonedDateTimeHandler");
    _vertx.eventBus().<String>request(_address, _json, _deliveryOptions, res -> {
      if (res.failed()) {
        resultHandler.handle(Future.failedFuture(res.cause()));
      } else {
        resultHandler.handle(Future.succeededFuture(res.result().body() != null ? io.vertx.serviceproxy.testmodel.Mappers.deserializeZonedDateTime((String)res.result().body()) : null));
      }
    });
  }
  @Override
  public void listZonedDateTimeHandler(Handler<AsyncResult<List<ZonedDateTime>>> resultHandler){
    if (closed) {
      resultHandler.handle(Future.failedFuture(new IllegalStateException("Proxy is closed")));
      return;
    }
    JsonObject _json = new JsonObject();

    DeliveryOptions _deliveryOptions = (_options != null) ? new DeliveryOptions(_options) : new DeliveryOptions();
    _deliveryOptions.addHeader("action", "listZonedDateTimeHandler");
    _deliveryOptions.getHeaders().set("action", "listZonedDateTimeHandler");
    _vertx.eventBus().<JsonArray>request(_address, _json, _deliveryOptions, res -> {
      if (res.failed()) {
        resultHandler.handle(Future.failedFuture(res.cause()));
      } else {
        resultHandler.handle(Future.succeededFuture(res.result().body().stream()
          .map(v -> v != null ? io.vertx.serviceproxy.testmodel.Mappers.deserializeZonedDateTime((String)v) : null)
          .collect(Collectors.toList())));
      }
    });
  }
  @Override
  public void setZonedDateTimeHandler(Handler<AsyncResult<Set<ZonedDateTime>>> resultHandler){
    if (closed) {
      resultHandler.handle(Future.failedFuture(new IllegalStateException("Proxy is closed")));
      return;
    }
    JsonObject _json = new JsonObject();

    DeliveryOptions _deliveryOptions = (_options != null) ? new DeliveryOptions(_options) : new DeliveryOptions();
    _deliveryOptions.addHeader("action", "setZonedDateTimeHandler");
    _deliveryOptions.getHeaders().set("action", "setZonedDateTimeHandler");
    _vertx.eventBus().<JsonArray>request(_address, _json, _deliveryOptions, res -> {
      if (res.failed()) {
        resultHandler.handle(Future.failedFuture(res.cause()));
      } else {
        resultHandler.handle(Future.succeededFuture(res.result().body().stream()
          .map(v -> v != null ? io.vertx.serviceproxy.testmodel.Mappers.deserializeZonedDateTime((String)v) : null)
          .collect(Collectors.toSet())));
      }
    });
  }
  @Override
  public void mapZonedDateTimeHandler(Handler<AsyncResult<Map<String,ZonedDateTime>>> resultHandler){
    if (closed) {
      resultHandler.handle(Future.failedFuture(new IllegalStateException("Proxy is closed")));
      return;
    }
    JsonObject _json = new JsonObject();

    DeliveryOptions _deliveryOptions = (_options != null) ? new DeliveryOptions(_options) : new DeliveryOptions();
    _deliveryOptions.addHeader("action", "mapZonedDateTimeHandler");
    _deliveryOptions.getHeaders().set("action", "mapZonedDateTimeHandler");
    _vertx.eventBus().<JsonObject>request(_address, _json, _deliveryOptions, res -> {
      if (res.failed()) {
        resultHandler.handle(Future.failedFuture(res.cause()));
      } else {
        resultHandler.handle(Future.succeededFuture(res.result().body().stream()
          .collect(Collectors.toMap(Map.Entry::getKey, e -> e.getValue() != null ? io.vertx.serviceproxy.testmodel.Mappers.deserializeZonedDateTime((String)e.getValue()) : null))));
      }
    });
  }
  @Override
  public void ignoredMethod(){
  }
}
