/*
* Copyright 2014 Red Hat, Inc.
*
* Red Hat licenses this file to you under the Apache License, version 2.0
* (the "License"); you may not use this file except in compliance with the
* License. You may obtain a copy of the License at:
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
* WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
* License for the specific language governing permissions and limitations
* under the License.
*/

package io.vertx.serviceproxy.testmodel;

import io.vertx.serviceproxy.testmodel.TestService;
import io.vertx.core.Vertx;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.eventbus.EventBus;
import io.vertx.core.eventbus.Message;
import io.vertx.core.eventbus.MessageConsumer;
import io.vertx.core.eventbus.DeliveryOptions;
import io.vertx.core.eventbus.ReplyException;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import java.util.Collection;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import io.vertx.serviceproxy.ProxyHandler;
import io.vertx.serviceproxy.ServiceException;
import io.vertx.serviceproxy.ServiceExceptionMessageCodec;
import io.vertx.serviceproxy.HelperUtils;
import io.vertx.serviceproxy.ServiceBinder;

import io.vertx.serviceproxy.testmodel.TestService;
import io.vertx.serviceproxy.testmodel.SomeEnum;
import io.vertx.core.eventbus.DeliveryOptions;
import java.time.ZonedDateTime;
import io.vertx.serviceproxy.testmodel.TestConnection;
import io.vertx.serviceproxy.testmodel.SomeEnumWithCustomConstructor;
import java.util.Map;
import io.vertx.core.AsyncResult;
import io.vertx.serviceproxy.testmodel.sub.TestSubConnection;
import io.vertx.core.Vertx;
import java.util.Set;
import io.vertx.serviceproxy.testmodel.TestDataObject;
import java.util.List;
import io.vertx.core.Handler;
import io.vertx.serviceproxy.testmodel.sub.TestSubConnectionVertxEBProxy;
/*
  Generated Proxy code - DO NOT EDIT
  @author Roger the Robot
*/

@SuppressWarnings({"unchecked", "rawtypes"})
public class TestServiceVertxProxyHandler extends ProxyHandler {

  public static final long DEFAULT_CONNECTION_TIMEOUT = 5 * 60; // 5 minutes 
  private final Vertx vertx;
  private final TestService service;
  private final long timerID;
  private long lastAccessed;
  private final long timeoutSeconds;
  private final boolean includeDebugInfo;

  public TestServiceVertxProxyHandler(Vertx vertx, TestService service){
    this(vertx, service, DEFAULT_CONNECTION_TIMEOUT);
  }

  public TestServiceVertxProxyHandler(Vertx vertx, TestService service, long timeoutInSecond){
    this(vertx, service, true, timeoutInSecond);
  }

  public TestServiceVertxProxyHandler(Vertx vertx, TestService service, boolean topLevel, long timeoutInSecond){
    this(vertx, service, true, timeoutInSecond, false);
  }

  public TestServiceVertxProxyHandler(Vertx vertx, TestService service, boolean topLevel, long timeoutSeconds, boolean includeDebugInfo) {
      this.vertx = vertx;
      this.service = service;
      this.includeDebugInfo = includeDebugInfo;
      this.timeoutSeconds = timeoutSeconds;
      try {
        this.vertx.eventBus().registerDefaultCodec(ServiceException.class,
            new ServiceExceptionMessageCodec());
      } catch (IllegalStateException ex) {}
      if (timeoutSeconds != -1 && !topLevel) {
        long period = timeoutSeconds * 1000 / 2;
        if (period > 10000) {
          period = 10000;
        }
        this.timerID = vertx.setPeriodic(period, this::checkTimedOut);
      } else {
        this.timerID = -1;
      }
      accessed();
    }


  private void checkTimedOut(long id) {
    long now = System.nanoTime();
    if (now - lastAccessed > timeoutSeconds * 1000000000) {
      close();
    }
  }

    @Override
    public void close() {
      if (timerID != -1) {
        vertx.cancelTimer(timerID);
      }
      super.close();
    }

    private void accessed() {
      this.lastAccessed = System.nanoTime();
    }

  public void handle(Message<JsonObject> msg) {
    try{
      JsonObject json = msg.body();
      String action = msg.headers().get("action");
      if (action == null) throw new IllegalStateException("action not specified");
      accessed();
      switch (action) {
        case "longDeliverySuccess": {
          service.longDeliverySuccess(HelperUtils.createHandler(msg, includeDebugInfo));
          break;
        }
        case "longDeliveryFailed": {
          service.longDeliveryFailed(HelperUtils.createHandler(msg, includeDebugInfo));
          break;
        }
        case "createConnection": {
          service.createConnection((java.lang.String)json.getValue("str"),
                        res -> {
                        if (res.failed()) {
                          HelperUtils.manageFailure(msg, res.cause(), includeDebugInfo);
                        } else {
                          String proxyAddress = UUID.randomUUID().toString();
                          new ServiceBinder(vertx).setAddress(proxyAddress).setTopLevel(false).setTimeoutSeconds(timeoutSeconds).register(TestConnection.class, res.result());
                          msg.reply(null, new DeliveryOptions().addHeader("proxyaddr", proxyAddress));
                        }
                      });
          break;
        }
        case "createSubConnection": {
          service.createSubConnection((java.lang.String)json.getValue("str"),
                        res -> {
                        if (res.failed()) {
                          HelperUtils.manageFailure(msg, res.cause(), includeDebugInfo);
                        } else {
                          String proxyAddress = UUID.randomUUID().toString();
                          new ServiceBinder(vertx).setAddress(proxyAddress).setTopLevel(false).setTimeoutSeconds(timeoutSeconds).register(TestSubConnection.class, res.result());
                          msg.reply(null, new DeliveryOptions().addHeader("proxyaddr", proxyAddress));
                        }
                      });
          break;
        }
        case "noParams": {
          service.noParams();
          break;
        }
        case "basicTypes": {
          service.basicTypes((java.lang.String)json.getValue("str"),
                        json.getValue("b") == null ? null : (json.getLong("b").byteValue()),
                        json.getValue("s") == null ? null : (json.getLong("s").shortValue()),
                        json.getValue("i") == null ? null : (json.getLong("i").intValue()),
                        json.getValue("l") == null ? null : (json.getLong("l").longValue()),
                        json.getValue("f") == null ? null : (json.getDouble("f").floatValue()),
                        json.getValue("d") == null ? null : (json.getDouble("d").doubleValue()),
                        json.getInteger("c") == null ? null : (char)(int)(json.getInteger("c")),
                        (boolean)json.getValue("bool"));
          break;
        }
        case "basicBoxedTypes": {
          service.basicBoxedTypes((java.lang.String)json.getValue("str"),
                        json.getValue("b") == null ? null : (json.getLong("b").byteValue()),
                        json.getValue("s") == null ? null : (json.getLong("s").shortValue()),
                        json.getValue("i") == null ? null : (json.getLong("i").intValue()),
                        json.getValue("l") == null ? null : (json.getLong("l").longValue()),
                        json.getValue("f") == null ? null : (json.getDouble("f").floatValue()),
                        json.getValue("d") == null ? null : (json.getDouble("d").doubleValue()),
                        json.getInteger("c") == null ? null : (char)(int)(json.getInteger("c")),
                        (java.lang.Boolean)json.getValue("bool"));
          break;
        }
        case "basicBoxedTypesNull": {
          service.basicBoxedTypesNull((java.lang.String)json.getValue("str"),
                        json.getValue("b") == null ? null : (json.getLong("b").byteValue()),
                        json.getValue("s") == null ? null : (json.getLong("s").shortValue()),
                        json.getValue("i") == null ? null : (json.getLong("i").intValue()),
                        json.getValue("l") == null ? null : (json.getLong("l").longValue()),
                        json.getValue("f") == null ? null : (json.getDouble("f").floatValue()),
                        json.getValue("d") == null ? null : (json.getDouble("d").doubleValue()),
                        json.getInteger("c") == null ? null : (char)(int)(json.getInteger("c")),
                        (java.lang.Boolean)json.getValue("bool"));
          break;
        }
        case "jsonTypes": {
          service.jsonTypes((io.vertx.core.json.JsonObject)json.getValue("jsonObject"),
                        (io.vertx.core.json.JsonArray)json.getValue("jsonArray"));
          break;
        }
        case "jsonTypesNull": {
          service.jsonTypesNull((io.vertx.core.json.JsonObject)json.getValue("jsonObject"),
                        (io.vertx.core.json.JsonArray)json.getValue("jsonArray"));
          break;
        }
        case "enumType": {
          service.enumType(json.getString("someEnum") == null ? null : io.vertx.serviceproxy.testmodel.SomeEnum.valueOf(json.getString("someEnum")));
          break;
        }
        case "enumTypeNull": {
          service.enumTypeNull(json.getString("someEnum") == null ? null : io.vertx.serviceproxy.testmodel.SomeEnum.valueOf(json.getString("someEnum")));
          break;
        }
        case "enumTypeAsResult": {
          service.enumTypeAsResult(HelperUtils.createHandler(msg, includeDebugInfo));
          break;
        }
        case "enumTypeAsResultNull": {
          service.enumTypeAsResultNull(HelperUtils.createHandler(msg, includeDebugInfo));
          break;
        }
        case "enumCustomType": {
          service.enumCustomType(json.getString("someEnum") != null ? io.vertx.serviceproxy.testmodel.Mappers.deserializeSomeEnumWithCustomConstructor((String)json.getString("someEnum")) : null);
          break;
        }
        case "enumCustomTypeNull": {
          service.enumCustomTypeNull(json.getString("someEnum") != null ? io.vertx.serviceproxy.testmodel.Mappers.deserializeSomeEnumWithCustomConstructor((String)json.getString("someEnum")) : null);
          break;
        }
        case "enumCustomTypeAsResult": {
          service.enumCustomTypeAsResult(res -> {
                        if (res.failed()) {
                          HelperUtils.manageFailure(msg, res.cause(), includeDebugInfo);
                        } else {
                          msg.reply(res.result() != null ? io.vertx.serviceproxy.testmodel.Mappers.serializeSomeEnumWithCustomConstructor(res.result()) : null);
                        }
                     });
          break;
        }
        case "enumCustomTypeAsResultNull": {
          service.enumCustomTypeAsResultNull(res -> {
                        if (res.failed()) {
                          HelperUtils.manageFailure(msg, res.cause(), includeDebugInfo);
                        } else {
                          msg.reply(res.result() != null ? io.vertx.serviceproxy.testmodel.Mappers.serializeSomeEnumWithCustomConstructor(res.result()) : null);
                        }
                     });
          break;
        }
        case "dataObjectType": {
          service.dataObjectType(json.getJsonObject("options") != null ? new io.vertx.serviceproxy.testmodel.TestDataObject((JsonObject)json.getJsonObject("options")) : null);
          break;
        }
        case "listdataObjectType": {
          service.listdataObjectType(json.getJsonArray("list").stream().map(v -> v != null ? new io.vertx.serviceproxy.testmodel.TestDataObject((JsonObject)v) : null).collect(Collectors.toList()));
          break;
        }
        case "setdataObjectType": {
          service.setdataObjectType(json.getJsonArray("set").stream().map(v -> v != null ? new io.vertx.serviceproxy.testmodel.TestDataObject((JsonObject)v) : null).collect(Collectors.toSet()));
          break;
        }
        case "dataObjectTypeNull": {
          service.dataObjectTypeNull(json.getJsonObject("options") != null ? new io.vertx.serviceproxy.testmodel.TestDataObject((JsonObject)json.getJsonObject("options")) : null);
          break;
        }
        case "dateTimeType": {
          service.dateTimeType(json.getValue("dateTime") != null ? io.vertx.serviceproxy.testmodel.Mappers.deserializeZonedDateTime((String)json.getValue("dateTime")) : null);
          break;
        }
        case "listDateTimeType": {
          service.listDateTimeType(json.getJsonArray("list").stream().map(v -> v != null ? io.vertx.serviceproxy.testmodel.Mappers.deserializeZonedDateTime((String)v) : null).collect(Collectors.toList()));
          break;
        }
        case "setDateTimeType": {
          service.setDateTimeType(json.getJsonArray("set").stream().map(v -> v != null ? io.vertx.serviceproxy.testmodel.Mappers.deserializeZonedDateTime((String)v) : null).collect(Collectors.toSet()));
          break;
        }
        case "mapDateTimeType": {
          service.mapDateTimeType(json.getJsonObject("map").stream().collect(Collectors.toMap(Map.Entry::getKey, e -> e.getValue() != null ? io.vertx.serviceproxy.testmodel.Mappers.deserializeZonedDateTime((String)e.getValue()) : null)));
          break;
        }
        case "listdataObjectTypeHavingNullValues": {
          service.listdataObjectTypeHavingNullValues(json.getJsonArray("list").stream().map(v -> v != null ? new io.vertx.serviceproxy.testmodel.TestDataObject((JsonObject)v) : null).collect(Collectors.toList()));
          break;
        }
        case "setdataObjectTypeHavingNullValues": {
          service.setdataObjectTypeHavingNullValues(json.getJsonArray("set").stream().map(v -> v != null ? new io.vertx.serviceproxy.testmodel.TestDataObject((JsonObject)v) : null).collect(Collectors.toSet()));
          break;
        }
        case "listdataObjectTypeNull": {
          service.listdataObjectTypeNull(json.getJsonArray("list").stream().map(v -> v != null ? new io.vertx.serviceproxy.testmodel.TestDataObject((JsonObject)v) : null).collect(Collectors.toList()));
          break;
        }
        case "setdataObjectTypeNull": {
          service.setdataObjectTypeNull(json.getJsonArray("set").stream().map(v -> v != null ? new io.vertx.serviceproxy.testmodel.TestDataObject((JsonObject)v) : null).collect(Collectors.toSet()));
          break;
        }
        case "mapDataObjectType": {
          service.mapDataObjectType(json.getJsonObject("map").stream().collect(Collectors.toMap(Map.Entry::getKey, e -> e.getValue() != null ? new io.vertx.serviceproxy.testmodel.TestDataObject((JsonObject)e.getValue()) : null)));
          break;
        }
        case "listParams": {
          service.listParams(HelperUtils.convertList(json.getJsonArray("listString").getList()),
                        json.getJsonArray("listByte").stream().map(o -> ((Number)o).byteValue()).collect(Collectors.toList()),
                        json.getJsonArray("listShort").stream().map(o -> ((Number)o).shortValue()).collect(Collectors.toList()),
                        json.getJsonArray("listInt").stream().map(o -> ((Number)o).intValue()).collect(Collectors.toList()),
                        json.getJsonArray("listLong").stream().map(o -> ((Number)o).longValue()).collect(Collectors.toList()),
                        HelperUtils.convertList(json.getJsonArray("listJsonObject").getList()),
                        HelperUtils.convertList(json.getJsonArray("listJsonArray").getList()),
                        json.getJsonArray("listDataObject").stream().map(v -> v != null ? new io.vertx.serviceproxy.testmodel.TestDataObject((JsonObject)v) : null).collect(Collectors.toList()));
          break;
        }
        case "setParams": {
          service.setParams(HelperUtils.convertSet(json.getJsonArray("setString").getList()),
                        json.getJsonArray("setByte").stream().map(o -> ((Number)o).byteValue()).collect(Collectors.toSet()),
                        json.getJsonArray("setShort").stream().map(o -> ((Number)o).shortValue()).collect(Collectors.toSet()),
                        json.getJsonArray("setInt").stream().map(o -> ((Number)o).intValue()).collect(Collectors.toSet()),
                        json.getJsonArray("setLong").stream().map(o -> ((Number)o).longValue()).collect(Collectors.toSet()),
                        HelperUtils.convertSet(json.getJsonArray("setJsonObject").getList()),
                        HelperUtils.convertSet(json.getJsonArray("setJsonArray").getList()),
                        json.getJsonArray("setDataObject").stream().map(v -> v != null ? new io.vertx.serviceproxy.testmodel.TestDataObject((JsonObject)v) : null).collect(Collectors.toSet()));
          break;
        }
        case "mapParams": {
          service.mapParams(HelperUtils.convertMap(json.getJsonObject("mapString").getMap()),
                        json.getJsonObject("mapByte").getMap().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((java.lang.Number)entry.getValue()).byteValue())),
                        json.getJsonObject("mapShort").getMap().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((java.lang.Number)entry.getValue()).shortValue())),
                        json.getJsonObject("mapInt").getMap().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((java.lang.Number)entry.getValue()).intValue())),
                        json.getJsonObject("mapLong").getMap().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((java.lang.Number)entry.getValue()).longValue())),
                        HelperUtils.convertMap(json.getJsonObject("mapJsonObject").getMap()),
                        HelperUtils.convertMap(json.getJsonObject("mapJsonArray").getMap()));
          break;
        }
        case "stringHandler": {
          service.stringHandler(HelperUtils.createHandler(msg, includeDebugInfo));
          break;
        }
        case "stringNullHandler": {
          service.stringNullHandler(HelperUtils.createHandler(msg, includeDebugInfo));
          break;
        }
        case "byteHandler": {
          service.byteHandler(HelperUtils.createHandler(msg, includeDebugInfo));
          break;
        }
        case "byteNullHandler": {
          service.byteNullHandler(HelperUtils.createHandler(msg, includeDebugInfo));
          break;
        }
        case "shortHandler": {
          service.shortHandler(HelperUtils.createHandler(msg, includeDebugInfo));
          break;
        }
        case "shortNullHandler": {
          service.shortNullHandler(HelperUtils.createHandler(msg, includeDebugInfo));
          break;
        }
        case "intHandler": {
          service.intHandler(HelperUtils.createHandler(msg, includeDebugInfo));
          break;
        }
        case "intNullHandler": {
          service.intNullHandler(HelperUtils.createHandler(msg, includeDebugInfo));
          break;
        }
        case "longHandler": {
          service.longHandler(HelperUtils.createHandler(msg, includeDebugInfo));
          break;
        }
        case "longNullHandler": {
          service.longNullHandler(HelperUtils.createHandler(msg, includeDebugInfo));
          break;
        }
        case "floatHandler": {
          service.floatHandler(HelperUtils.createHandler(msg, includeDebugInfo));
          break;
        }
        case "floatNullHandler": {
          service.floatNullHandler(HelperUtils.createHandler(msg, includeDebugInfo));
          break;
        }
        case "doubleHandler": {
          service.doubleHandler(HelperUtils.createHandler(msg, includeDebugInfo));
          break;
        }
        case "doubleNullHandler": {
          service.doubleNullHandler(HelperUtils.createHandler(msg, includeDebugInfo));
          break;
        }
        case "charHandler": {
          service.charHandler(HelperUtils.createHandler(msg, includeDebugInfo));
          break;
        }
        case "charNullHandler": {
          service.charNullHandler(HelperUtils.createHandler(msg, includeDebugInfo));
          break;
        }
        case "booleanHandler": {
          service.booleanHandler(HelperUtils.createHandler(msg, includeDebugInfo));
          break;
        }
        case "booleanNullHandler": {
          service.booleanNullHandler(HelperUtils.createHandler(msg, includeDebugInfo));
          break;
        }
        case "jsonObjectHandler": {
          service.jsonObjectHandler(HelperUtils.createHandler(msg, includeDebugInfo));
          break;
        }
        case "jsonObjectNullHandler": {
          service.jsonObjectNullHandler(HelperUtils.createHandler(msg, includeDebugInfo));
          break;
        }
        case "jsonArrayHandler": {
          service.jsonArrayHandler(HelperUtils.createHandler(msg, includeDebugInfo));
          break;
        }
        case "jsonArrayNullHandler": {
          service.jsonArrayNullHandler(HelperUtils.createHandler(msg, includeDebugInfo));
          break;
        }
        case "dataObjectHandler": {
          service.dataObjectHandler(res -> {
                        if (res.failed()) {
                          HelperUtils.manageFailure(msg, res.cause(), includeDebugInfo);
                        } else {
                          msg.reply(res.result() != null ? res.result().toJson() : null);
                        }
                     });
          break;
        }
        case "dataObjectNullHandler": {
          service.dataObjectNullHandler(res -> {
                        if (res.failed()) {
                          HelperUtils.manageFailure(msg, res.cause(), includeDebugInfo);
                        } else {
                          msg.reply(res.result() != null ? res.result().toJson() : null);
                        }
                     });
          break;
        }
        case "voidHandler": {
          service.voidHandler(HelperUtils.createHandler(msg, includeDebugInfo));
          break;
        }
        case "fluentMethod": {
          service.fluentMethod((java.lang.String)json.getValue("str"),
                        HelperUtils.createHandler(msg, includeDebugInfo));
          break;
        }
        case "fluentNoParams": {
          service.fluentNoParams();
          break;
        }
        case "failingMethod": {
          service.failingMethod(HelperUtils.createHandler(msg, includeDebugInfo));
          break;
        }
        case "invokeWithMessage": {
          service.invokeWithMessage((io.vertx.core.json.JsonObject)json.getValue("object"),
                        (java.lang.String)json.getValue("str"),
                        json.getValue("i") == null ? null : (json.getLong("i").intValue()),
                        json.getInteger("chr") == null ? null : (char)(int)(json.getInteger("chr")),
                        json.getString("senum") == null ? null : io.vertx.serviceproxy.testmodel.SomeEnum.valueOf(json.getString("senum")),
                        HelperUtils.createHandler(msg, includeDebugInfo));
          break;
        }
        case "listStringHandler": {
          service.listStringHandler(HelperUtils.createListHandler(msg, includeDebugInfo));
          break;
        }
        case "listByteHandler": {
          service.listByteHandler(HelperUtils.createListHandler(msg, includeDebugInfo));
          break;
        }
        case "listShortHandler": {
          service.listShortHandler(HelperUtils.createListHandler(msg, includeDebugInfo));
          break;
        }
        case "listIntHandler": {
          service.listIntHandler(HelperUtils.createListHandler(msg, includeDebugInfo));
          break;
        }
        case "listLongHandler": {
          service.listLongHandler(HelperUtils.createListHandler(msg, includeDebugInfo));
          break;
        }
        case "listFloatHandler": {
          service.listFloatHandler(HelperUtils.createListHandler(msg, includeDebugInfo));
          break;
        }
        case "listDoubleHandler": {
          service.listDoubleHandler(HelperUtils.createListHandler(msg, includeDebugInfo));
          break;
        }
        case "listCharHandler": {
          service.listCharHandler(HelperUtils.createListCharHandler(msg, includeDebugInfo));
          break;
        }
        case "listBoolHandler": {
          service.listBoolHandler(HelperUtils.createListHandler(msg, includeDebugInfo));
          break;
        }
        case "listJsonObjectHandler": {
          service.listJsonObjectHandler(HelperUtils.createListHandler(msg, includeDebugInfo));
          break;
        }
        case "listJsonArrayHandler": {
          service.listJsonArrayHandler(HelperUtils.createListHandler(msg, includeDebugInfo));
          break;
        }
        case "listDataObjectHandler": {
          service.listDataObjectHandler(res -> {
                        if (res.failed()) {
                          HelperUtils.manageFailure(msg, res.cause(), includeDebugInfo);
                        } else {
                          msg.reply(new JsonArray(res.result().stream().map(v -> v != null ? v.toJson() : null).collect(Collectors.toList())));
                        }
                     });
          break;
        }
        case "setStringHandler": {
          service.setStringHandler(HelperUtils.createSetHandler(msg, includeDebugInfo));
          break;
        }
        case "setByteHandler": {
          service.setByteHandler(HelperUtils.createSetHandler(msg, includeDebugInfo));
          break;
        }
        case "setShortHandler": {
          service.setShortHandler(HelperUtils.createSetHandler(msg, includeDebugInfo));
          break;
        }
        case "setIntHandler": {
          service.setIntHandler(HelperUtils.createSetHandler(msg, includeDebugInfo));
          break;
        }
        case "setLongHandler": {
          service.setLongHandler(HelperUtils.createSetHandler(msg, includeDebugInfo));
          break;
        }
        case "setFloatHandler": {
          service.setFloatHandler(HelperUtils.createSetHandler(msg, includeDebugInfo));
          break;
        }
        case "setDoubleHandler": {
          service.setDoubleHandler(HelperUtils.createSetHandler(msg, includeDebugInfo));
          break;
        }
        case "setCharHandler": {
          service.setCharHandler(HelperUtils.createSetCharHandler(msg, includeDebugInfo));
          break;
        }
        case "setBoolHandler": {
          service.setBoolHandler(HelperUtils.createSetHandler(msg, includeDebugInfo));
          break;
        }
        case "mapStringHandler": {
          service.mapStringHandler(HelperUtils.createMapHandler(msg, includeDebugInfo));
          break;
        }
        case "mapByteHandler": {
          service.mapByteHandler(HelperUtils.createMapHandler(msg, includeDebugInfo));
          break;
        }
        case "mapShortHandler": {
          service.mapShortHandler(HelperUtils.createMapHandler(msg, includeDebugInfo));
          break;
        }
        case "mapIntHandler": {
          service.mapIntHandler(HelperUtils.createMapHandler(msg, includeDebugInfo));
          break;
        }
        case "mapLongHandler": {
          service.mapLongHandler(HelperUtils.createMapHandler(msg, includeDebugInfo));
          break;
        }
        case "mapFloatHandler": {
          service.mapFloatHandler(HelperUtils.createMapHandler(msg, includeDebugInfo));
          break;
        }
        case "mapDoubleHandler": {
          service.mapDoubleHandler(HelperUtils.createMapHandler(msg, includeDebugInfo));
          break;
        }
        case "mapCharHandler": {
          service.mapCharHandler(HelperUtils.createMapCharHandler(msg, includeDebugInfo));
          break;
        }
        case "mapBoolHandler": {
          service.mapBoolHandler(HelperUtils.createMapHandler(msg, includeDebugInfo));
          break;
        }
        case "setJsonObjectHandler": {
          service.setJsonObjectHandler(HelperUtils.createSetHandler(msg, includeDebugInfo));
          break;
        }
        case "mapJsonObjectHandler": {
          service.mapJsonObjectHandler(HelperUtils.createMapHandler(msg, includeDebugInfo));
          break;
        }
        case "setJsonArrayHandler": {
          service.setJsonArrayHandler(HelperUtils.createSetHandler(msg, includeDebugInfo));
          break;
        }
        case "mapJsonArrayHandler": {
          service.mapJsonArrayHandler(HelperUtils.createMapHandler(msg, includeDebugInfo));
          break;
        }
        case "setDataObjectHandler": {
          service.setDataObjectHandler(res -> {
                        if (res.failed()) {
                          HelperUtils.manageFailure(msg, res.cause(), includeDebugInfo);
                        } else {
                          msg.reply(new JsonArray(res.result().stream().map(v -> v != null ? v.toJson() : null).collect(Collectors.toList())));
                        }
                     });
          break;
        }
        case "mapDataObject": {
          service.mapDataObject(res -> {
                        if (res.failed()) {
                          if (res.cause() instanceof ServiceException) {
                            msg.reply(res.cause());
                          } else {
                            msg.reply(new ServiceException(-1, res.cause().getMessage()));
                          }
                        } else {
                          msg.reply(new JsonObject(res.result().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> e.getValue() != null ? e.getValue().toJson() : null))));
                        }
                     });
          break;
        }
        case "failingCall": {
          service.failingCall((java.lang.String)json.getValue("value"),
                        HelperUtils.createHandler(msg, includeDebugInfo));
          break;
        }
        case "listDataObjectContainingNullHandler": {
          service.listDataObjectContainingNullHandler(res -> {
                        if (res.failed()) {
                          HelperUtils.manageFailure(msg, res.cause(), includeDebugInfo);
                        } else {
                          msg.reply(new JsonArray(res.result().stream().map(v -> v != null ? v.toJson() : null).collect(Collectors.toList())));
                        }
                     });
          break;
        }
        case "setDataObjectContainingNullHandler": {
          service.setDataObjectContainingNullHandler(res -> {
                        if (res.failed()) {
                          HelperUtils.manageFailure(msg, res.cause(), includeDebugInfo);
                        } else {
                          msg.reply(new JsonArray(res.result().stream().map(v -> v != null ? v.toJson() : null).collect(Collectors.toList())));
                        }
                     });
          break;
        }
        case "zonedDateTimeHandler": {
          service.zonedDateTimeHandler(res -> {
                        if (res.failed()) {
                          HelperUtils.manageFailure(msg, res.cause(), includeDebugInfo);
                        } else {
                          msg.reply(res.result() != null ? io.vertx.serviceproxy.testmodel.Mappers.serializeZonedDateTime(res.result()) : null);
                        }
                     });
          break;
        }
        case "listZonedDateTimeHandler": {
          service.listZonedDateTimeHandler(res -> {
                        if (res.failed()) {
                          HelperUtils.manageFailure(msg, res.cause(), includeDebugInfo);
                        } else {
                          msg.reply(new JsonArray(res.result().stream().map(v -> v != null ? io.vertx.serviceproxy.testmodel.Mappers.serializeZonedDateTime(v) : null).collect(Collectors.toList())));
                        }
                     });
          break;
        }
        case "setZonedDateTimeHandler": {
          service.setZonedDateTimeHandler(res -> {
                        if (res.failed()) {
                          HelperUtils.manageFailure(msg, res.cause(), includeDebugInfo);
                        } else {
                          msg.reply(new JsonArray(res.result().stream().map(v -> v != null ? io.vertx.serviceproxy.testmodel.Mappers.serializeZonedDateTime(v) : null).collect(Collectors.toList())));
                        }
                     });
          break;
        }
        case "mapZonedDateTimeHandler": {
          service.mapZonedDateTimeHandler(res -> {
                        if (res.failed()) {
                          if (res.cause() instanceof ServiceException) {
                            msg.reply(res.cause());
                          } else {
                            msg.reply(new ServiceException(-1, res.cause().getMessage()));
                          }
                        } else {
                          msg.reply(new JsonObject(res.result().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> e.getValue() != null ? io.vertx.serviceproxy.testmodel.Mappers.serializeZonedDateTime(e.getValue()) : null))));
                        }
                     });
          break;
        }
        case "ignoredMethod": {
          service.ignoredMethod();
          break;
        }
        default: throw new IllegalStateException("Invalid action: " + action);
      }
    } catch (Throwable t) {
      if (includeDebugInfo) msg.reply(new ServiceException(500, t.getMessage(), HelperUtils.generateDebugInfo(t)));
      else msg.reply(new ServiceException(500, t.getMessage()));
      throw t;
    }
  }
}