/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.serviceproxy.tests;

import io.vertx.core.eventbus.MessageConsumer;
import io.vertx.core.json.JsonObject;
import io.vertx.serviceproxy.ServiceBinder;
import io.vertx.serviceproxy.tests.testmodel2.FuturizedTestService;
import io.vertx.test.core.VertxTestBase;
import java.net.URI;
import org.junit.Test;

public class FuturizedServiceProxyTest
extends VertxTestBase {
    public static final String SERVICE_ADDRESS = "someaddress";
    public static final String SERVICE_WITH_DEBUG_ADDRESS = "someaddressdebug";
    public static final String SERVICE_LOCAL_ADDRESS = "someaddress.local";
    public static final String TEST_ADDRESS = "testaddress";
    MessageConsumer<JsonObject> consumer;
    MessageConsumer<JsonObject> localConsumer;
    MessageConsumer<JsonObject> consumerWithDebugEnabled;
    FuturizedTestService service;
    FuturizedTestService localService;
    FuturizedTestService proxy;
    FuturizedTestService localProxy;
    FuturizedTestService proxyWithDebug;
    URI uri1;
    URI uri2;

    public void setUp() throws Exception {
        super.setUp();
        this.uri1 = new URI("http://foo.com");
        this.uri2 = new URI("http://bar.com");
        this.service = FuturizedTestService.create(this.vertx);
        this.localService = FuturizedTestService.create(this.vertx);
        this.consumer = new ServiceBinder(this.vertx).setAddress(SERVICE_ADDRESS).register(FuturizedTestService.class, (Object)this.service);
        this.consumerWithDebugEnabled = new ServiceBinder(this.vertx).setAddress(SERVICE_WITH_DEBUG_ADDRESS).setIncludeDebugInfo(true).register(FuturizedTestService.class, (Object)this.service);
        this.localConsumer = new ServiceBinder(this.vertx).setAddress(SERVICE_LOCAL_ADDRESS).registerLocal(FuturizedTestService.class, (Object)this.localService);
        this.proxy = FuturizedTestService.createProxy(this.vertx, SERVICE_ADDRESS);
        this.localProxy = FuturizedTestService.createProxy(this.vertx, SERVICE_LOCAL_ADDRESS);
        this.proxyWithDebug = FuturizedTestService.createProxy(this.vertx, SERVICE_WITH_DEBUG_ADDRESS);
        this.vertx.eventBus().consumer(TEST_ADDRESS).handler(msg -> {
            this.assertEquals("ok", msg.body());
            this.testComplete();
        });
    }

    public void tearDown() throws Exception {
        this.consumer.unregister();
        this.localConsumer.unregister();
        super.tearDown();
    }

    @Test
    public void testStringHandler() {
        this.proxy.ok().onSuccess(res -> {
            this.assertEquals("foobar", res);
            this.testComplete();
        });
        this.await();
    }
}

