/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.serviceproxy.tests;

import io.vertx.core.eventbus.MessageConsumer;
import io.vertx.core.json.JsonObject;
import io.vertx.serviceproxy.ServiceBinder;
import io.vertx.serviceproxy.ServiceProxyBuilder;
import io.vertx.serviceproxy.tests.testmodel.OKService;
import io.vertx.serviceproxy.tests.testmodel.OKServiceImpl;
import io.vertx.test.core.VertxTestBase;
import org.junit.Test;

public class ServiceBinderTest
extends VertxTestBase {
    private static final String SERVICE_ADDRESS = "someaddress";
    private static final String SERVICE_LOCAL_ADDRESS = "someaddress.local";
    private MessageConsumer<JsonObject> consumer;
    private MessageConsumer<JsonObject> localConsumer;
    private OKService proxy;
    private OKService localProxy;

    public void setUp() throws Exception {
        super.setUp();
        OKServiceImpl service = new OKServiceImpl();
        ServiceBinder serviceBinder = new ServiceBinder(this.vertx).setAddress(SERVICE_ADDRESS);
        ServiceBinder serviceLocalBinder = new ServiceBinder(this.vertx).setAddress(SERVICE_LOCAL_ADDRESS);
        ServiceProxyBuilder serviceProxyBuilder = new ServiceProxyBuilder(this.vertx).setAddress(SERVICE_ADDRESS);
        ServiceProxyBuilder serviceLocalProxyBuilder = new ServiceProxyBuilder(this.vertx).setAddress(SERVICE_LOCAL_ADDRESS);
        this.consumer = serviceBinder.register(OKService.class, (Object)service);
        this.localConsumer = serviceLocalBinder.registerLocal(OKService.class, (Object)service);
        this.proxy = (OKService)serviceProxyBuilder.build(OKService.class);
        this.localProxy = (OKService)serviceLocalProxyBuilder.build(OKService.class);
    }

    public void tearDown() throws Exception {
        this.consumer.unregister();
        this.localConsumer.unregister();
        super.tearDown();
    }

    @Test
    public void testFactory() {
        this.proxy.ok().onComplete(res -> {
            this.assertFalse(res.failed());
            this.testComplete();
        });
        this.await();
    }

    @Test
    public void testLocalFactory() {
        this.localProxy.ok().onComplete(res -> {
            this.assertFalse(res.failed());
            this.testComplete();
        });
        this.await();
    }
}

