/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.serviceproxy.tests;

import io.vertx.core.eventbus.DeliveryOptions;
import io.vertx.core.eventbus.MessageCodec;
import io.vertx.core.eventbus.MessageConsumer;
import io.vertx.core.eventbus.ReplyException;
import io.vertx.core.eventbus.ReplyFailure;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.serviceproxy.ServiceBinder;
import io.vertx.serviceproxy.ServiceException;
import io.vertx.serviceproxy.tests.testmodel.MyServiceException;
import io.vertx.serviceproxy.tests.testmodel.MyServiceExceptionMessageCodec;
import io.vertx.serviceproxy.tests.testmodel.SomeEnum;
import io.vertx.serviceproxy.tests.testmodel.SomeEnumWithCustomConstructor;
import io.vertx.serviceproxy.tests.testmodel.TestDataObject;
import io.vertx.serviceproxy.tests.testmodel.TestService;
import io.vertx.test.core.VertxTestBase;
import java.net.URI;
import java.time.ZonedDateTime;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.junit.Test;

public class ServiceProxyTest
extends VertxTestBase {
    public static final String SERVICE_ADDRESS = "someaddress";
    public static final String SERVICE_WITH_DEBUG_ADDRESS = "someaddressdebug";
    public static final String SERVICE_LOCAL_ADDRESS = "someaddress.local";
    public static final String TEST_ADDRESS = "testaddress";
    MessageConsumer<JsonObject> consumer;
    MessageConsumer<JsonObject> localConsumer;
    MessageConsumer<JsonObject> consumerWithDebugEnabled;
    TestService service;
    TestService localService;
    TestService proxy;
    TestService localProxy;
    TestService proxyWithDebug;
    URI uri1;
    URI uri2;

    public void setUp() throws Exception {
        super.setUp();
        this.uri1 = new URI("http://foo.com");
        this.uri2 = new URI("http://bar.com");
        this.service = TestService.create(this.vertx);
        this.localService = TestService.create(this.vertx);
        this.consumer = new ServiceBinder(this.vertx).setAddress(SERVICE_ADDRESS).register(TestService.class, (Object)this.service);
        this.consumerWithDebugEnabled = new ServiceBinder(this.vertx).setAddress(SERVICE_WITH_DEBUG_ADDRESS).setIncludeDebugInfo(true).register(TestService.class, (Object)this.service);
        this.localConsumer = new ServiceBinder(this.vertx).setAddress(SERVICE_LOCAL_ADDRESS).registerLocal(TestService.class, (Object)this.localService);
        this.proxy = TestService.createProxy(this.vertx, SERVICE_ADDRESS);
        this.localProxy = TestService.createProxy(this.vertx, SERVICE_LOCAL_ADDRESS);
        this.proxyWithDebug = TestService.createProxy(this.vertx, SERVICE_WITH_DEBUG_ADDRESS);
        this.vertx.eventBus().consumer(TEST_ADDRESS).handler(msg -> {
            this.assertEquals("ok", msg.body());
            this.testComplete();
        });
    }

    public void tearDown() throws Exception {
        this.consumer.unregister();
        this.localConsumer.unregister();
        super.tearDown();
    }

    @Test
    public void testErrorHandling() {
        this.proxy.failingCall("Fail").onComplete(handler -> {
            this.assertTrue(handler.cause() instanceof ServiceException);
            this.assertEquals("Call has failed", handler.cause().getMessage());
            this.assertEquals(25L, ((ServiceException)handler.cause()).failureCode());
            this.assertEquals(new JsonObject().put("test", (Object)"val"), ((ServiceException)handler.cause()).getDebugInfo());
            this.testComplete();
        });
        this.await();
    }

    @Test
    public void testErrorHandlingServiceExceptionSubclass() {
        this.vertx.eventBus().registerDefaultCodec(MyServiceException.class, (MessageCodec)new MyServiceExceptionMessageCodec());
        this.proxy.failingCall("Fail subclass").onComplete(handler -> {
            this.assertTrue(handler.cause() instanceof MyServiceException);
            this.assertEquals("Call has failed", handler.cause().getMessage());
            this.assertEquals(25L, ((MyServiceException)((Object)((Object)handler.cause()))).failureCode());
            this.assertEquals("some extra", ((MyServiceException)((Object)((Object)handler.cause()))).getExtra());
            this.testComplete();
        });
        this.await();
    }

    @Test
    public void testCauseErrorHandling() {
        this.proxyWithDebug.failingCall("Fail with cause").onComplete(handler -> {
            this.assertTrue(handler.cause() instanceof ServiceException);
            ServiceException cause = (ServiceException)handler.cause();
            this.assertEquals("Failed!", handler.cause().getMessage());
            this.assertEquals(IllegalArgumentException.class.getCanonicalName(), cause.getDebugInfo().getString("causeName"));
            this.assertEquals("Failed!", cause.getDebugInfo().getString("causeMessage"));
            this.assertFalse(cause.getDebugInfo().getJsonArray("causeStackTrace").isEmpty());
            this.testComplete();
        });
        this.await();
    }

    @Test
    public void testNoParams() {
        this.proxy.noParams();
        this.await();
    }

    @Test
    public void testBasicTypes() {
        this.proxy.basicTypes("foo", (byte)123, (short)1234, 12345, 123456L, 12.34f, 12.3456, 'X', true);
        this.await();
    }

    @Test
    public void testBasicBoxedTypes() {
        this.proxy.basicBoxedTypes("foo", (byte)123, (short)1234, 12345, 123456L, Float.valueOf(12.34f), 12.3456, Character.valueOf('X'), true);
        this.await();
    }

    @Test
    public void testBasicBoxedTypesNull() {
        this.proxy.basicBoxedTypesNull(null, null, null, null, null, null, null, null, null);
        this.await();
    }

    @Test
    public void testJsonTypes() {
        this.proxy.jsonTypes(new JsonObject().put("foo", (Object)"bar"), new JsonArray().add((Object)"wibble"));
        this.await();
    }

    @Test
    public void testJsonTypesNull() {
        this.proxy.jsonTypesNull(null, null);
        this.await();
    }

    @Test
    public void testEnumType() {
        this.proxy.enumType(SomeEnum.WIBBLE);
        this.await();
    }

    @Test
    public void testEnumTypeNull() {
        this.proxy.enumTypeNull(null);
        this.await();
    }

    @Test
    public void testEnumTypeAsResult() {
        this.proxy.enumTypeAsResult().onComplete(ar -> {
            if (ar.failed()) {
                this.fail("Failure not expected");
            } else {
                this.assertEquals(ar.result(), (Object)SomeEnum.WIBBLE);
            }
            this.testComplete();
        });
        this.await();
    }

    @Test
    public void testEnumTypeAsResultWithNull() {
        this.proxy.enumTypeAsResultNull().onComplete(ar -> {
            if (ar.failed()) {
                this.fail("Failure not expected");
            } else {
                this.assertNull(ar.result());
            }
            this.testComplete();
        });
        this.await();
    }

    @Test
    public void testCustomEnumType() {
        this.proxy.enumCustomType(SomeEnumWithCustomConstructor.ITEST);
        this.await();
    }

    @Test
    public void testCustomEnumTypeNull() {
        this.proxy.enumCustomTypeNull(null);
        this.await();
    }

    @Test
    public void testCustomEnumTypeAsResult() {
        this.proxy.enumCustomTypeAsResult().onComplete(ar -> {
            if (ar.failed()) {
                this.fail("Failure not expected");
            } else {
                this.assertEquals(ar.result(), (Object)SomeEnumWithCustomConstructor.ITEST);
            }
            this.testComplete();
        });
        this.await();
    }

    @Test
    public void testCustomEnumTypeAsResultWithNull() {
        this.proxy.enumCustomTypeAsResultNull().onComplete(ar -> {
            if (ar.failed()) {
                this.fail("Failure not expected");
            } else {
                this.assertNull(ar.result());
            }
            this.testComplete();
        });
        this.await();
    }

    @Test
    public void testDataObjectType() {
        this.proxy.dataObjectType(new TestDataObject().setString("foo").setNumber(123).setBool(true));
        this.await();
    }

    @Test
    public void testListdataObjectType() {
        List<TestDataObject> testDataList = Arrays.asList(new TestDataObject().setString("foo").setNumber(123).setBool(true), new TestDataObject().setString("bar").setNumber(456).setBool(false));
        this.proxy.listdataObjectType(testDataList);
        this.await();
    }

    @Test
    public void testSetdataObjectType() {
        HashSet<TestDataObject> testDataSet = new HashSet<TestDataObject>(Arrays.asList(new TestDataObject().setString("String foo").setNumber(123).setBool(true), new TestDataObject().setString("String bar").setNumber(456).setBool(false)));
        this.proxy.setdataObjectType(testDataSet);
        this.await();
    }

    @Test
    public void testMapdataObjectType() {
        HashMap<String, TestDataObject> map = new HashMap<String, TestDataObject>();
        map.put("do1", new TestDataObject().setNumber(1).setString("String 1").setBool(false));
        map.put("do2", new TestDataObject().setNumber(2).setString("String 2").setBool(true));
        this.proxy.mapDataObjectType(map);
        this.await();
    }

    @Test
    public void testDateTimeType() {
        this.proxy.dateTimeType(ZonedDateTime.parse("2019-03-25T17:08:31.069+01:00[Europe/Rome]"));
        this.await();
    }

    @Test
    public void testListDateTimeType() {
        this.proxy.listDateTimeType(Arrays.asList(ZonedDateTime.parse("2019-03-25T17:08:31.069+01:00[Europe/Rome]"), ZonedDateTime.parse("2019-03-25T17:08:31.069+01:00[Europe/Rome]").plusHours(1L)));
        this.await();
    }

    @Test
    public void testSetDateTimeType() {
        this.proxy.setDateTimeType(new HashSet<ZonedDateTime>(Arrays.asList(ZonedDateTime.parse("2019-03-25T17:08:31.069+01:00[Europe/Rome]"), ZonedDateTime.parse("2019-03-25T17:08:31.069+01:00[Europe/Rome]").plusHours(1L))));
        this.await();
    }

    @Test
    public void testMapDateTimeType() {
        HashMap<String, ZonedDateTime> expected = new HashMap<String, ZonedDateTime>();
        expected.put("date1", ZonedDateTime.parse("2019-03-25T17:08:31.069+01:00[Europe/Rome]"));
        expected.put("date2", ZonedDateTime.parse("2019-03-25T17:08:31.069+01:00[Europe/Rome]").plusHours(1L));
        this.proxy.mapDateTimeType(expected);
        this.await();
    }

    @Test
    public void testDataObjectTypeNull() {
        this.proxy.dataObjectTypeNull(null);
        this.await();
    }

    @Test
    public void testlistdataObjectTypeHavingNullValues() {
        List<TestDataObject> testDataList = Arrays.asList(new TestDataObject().setString("foo").setNumber(123).setBool(true), null, new TestDataObject().setString("bar").setNumber(456).setBool(false));
        this.proxy.listdataObjectTypeHavingNullValues(testDataList);
        this.await();
    }

    @Test
    public void testListDataObjectTypeNull() {
        this.proxy.listdataObjectTypeNull(null);
        this.await();
    }

    @Test
    public void testSetdataObjectTypeHavingNullValues() {
        HashSet<TestDataObject> testDataSet = new HashSet<TestDataObject>(Arrays.asList(new TestDataObject().setString("String foo").setNumber(123).setBool(true), null, new TestDataObject().setString("String bar").setNumber(456).setBool(false)));
        this.proxy.setdataObjectTypeHavingNullValues(testDataSet);
        this.await();
    }

    @Test
    public void testSetDataObjectTypeNull() {
        this.proxy.setdataObjectTypeNull(null);
        this.await();
    }

    @Test
    public void testListTypes() {
        this.proxy.listParams(Arrays.asList("foo", "bar"), Arrays.asList((byte)12, (byte)13), Arrays.asList((short)123, (short)134), Arrays.asList(1234, 1235), Arrays.asList(12345L, 12346L), Arrays.asList(new JsonObject().put("foo", (Object)"bar"), new JsonObject().put("blah", (Object)"eek")), Arrays.asList(new JsonArray().add((Object)"foo"), new JsonArray().add((Object)"blah")), Arrays.asList(new TestDataObject().setNumber(1).setString("String 1").setBool(false), new TestDataObject().setNumber(2).setString("String 2").setBool(true)));
        this.await();
    }

    @Test
    public void testSetTypes() {
        this.proxy.setParams(new HashSet<String>(Arrays.asList("foo", "bar")), new HashSet<Byte>(Arrays.asList((byte)12, (byte)13)), new HashSet<Short>(Arrays.asList((short)123, (short)134)), new HashSet<Integer>(Arrays.asList(1234, 1235)), new HashSet<Long>(Arrays.asList(12345L, 12346L)), new HashSet<JsonObject>(Arrays.asList(new JsonObject().put("foo", (Object)"bar"), new JsonObject().put("blah", (Object)"eek"))), new HashSet<JsonArray>(Arrays.asList(new JsonArray().add((Object)"foo"), new JsonArray().add((Object)"blah"))), new HashSet<TestDataObject>(Arrays.asList(new TestDataObject().setNumber(1).setString("String 1").setBool(false), new TestDataObject().setNumber(2).setString("String 2").setBool(true))));
        this.await();
    }

    @Test
    public void testMapTypes() {
        this.proxy.mapParams((Map<String, String>)new HashMap<String, String>(){
            {
                this.put("eek", "foo");
                this.put("wob", "bar");
            }
        }, (Map<String, Byte>)new HashMap<String, Byte>(){
            {
                this.put("eek", (byte)12);
                this.put("wob", (byte)13);
            }
        }, (Map<String, Short>)new HashMap<String, Short>(){
            {
                this.put("eek", (short)123);
                this.put("wob", (short)134);
            }
        }, (Map<String, Integer>)new HashMap<String, Integer>(){
            {
                this.put("eek", 1234);
                this.put("wob", 1235);
            }
        }, (Map<String, Long>)new HashMap<String, Long>(){
            {
                this.put("eek", 12345L);
                this.put("wob", 12356L);
            }
        }, (Map<String, JsonObject>)new HashMap<String, JsonObject>(){
            {
                this.put("eek", new JsonObject().put("foo", (Object)"bar"));
                this.put("wob", new JsonObject().put("blah", (Object)"eek"));
            }
        }, (Map<String, JsonArray>)new HashMap<String, JsonArray>(){
            {
                this.put("eek", new JsonArray().add((Object)"foo"));
                this.put("wob", new JsonArray().add((Object)"blah"));
            }
        });
        this.await();
    }

    @Test
    public void testStringHandler() {
        this.proxy.stringHandler().onComplete(this.onSuccess(res -> {
            this.assertEquals("foobar", res);
            this.testComplete();
        }));
        this.await();
    }

    @Test
    public void testStringNullHandler() {
        this.proxy.stringNullHandler().onComplete(this.onSuccess(res -> {
            this.assertNull(res);
            this.testComplete();
        }));
        this.await();
    }

    @Test
    public void testByteHandler() {
        this.proxy.byteHandler().onComplete(this.onSuccess(res -> {
            this.assertEquals((byte)123, res);
            this.testComplete();
        }));
        this.await();
    }

    @Test
    public void testByteNullHandler() {
        this.proxy.byteNullHandler().onComplete(this.onSuccess(res -> {
            this.assertNull(res);
            this.testComplete();
        }));
        this.await();
    }

    @Test
    public void testShortHandler() {
        this.proxy.shortHandler().onComplete(this.onSuccess(res -> {
            this.assertEquals((short)1234, res);
            this.testComplete();
        }));
        this.await();
    }

    @Test
    public void testShortNullHandler() {
        this.proxy.shortNullHandler().onComplete(this.onSuccess(res -> {
            this.assertNull(res);
            this.testComplete();
        }));
        this.await();
    }

    @Test
    public void testIntHandler() {
        this.proxy.intHandler().onComplete(this.onSuccess(res -> {
            this.assertEquals(12345, res);
            this.testComplete();
        }));
        this.await();
    }

    @Test
    public void testIntNullHandler() {
        this.proxy.intNullHandler().onComplete(this.onSuccess(res -> {
            this.assertNull(res);
            this.testComplete();
        }));
        this.await();
    }

    @Test
    public void testLongHandler() {
        this.proxy.longHandler().onComplete(this.onSuccess(res -> {
            this.assertEquals(123456L, res);
            this.testComplete();
        }));
        this.await();
    }

    @Test
    public void testLongNullHandler() {
        this.proxy.longNullHandler().onComplete(this.onSuccess(res -> {
            this.assertNull(res);
            this.testComplete();
        }));
        this.await();
    }

    @Test
    public void testFloatHandler() {
        this.proxy.floatHandler().onComplete(this.onSuccess(res -> {
            this.assertEquals(Float.valueOf(12.34f), res);
            this.testComplete();
        }));
        this.await();
    }

    @Test
    public void testFloatNullHandler() {
        this.proxy.floatNullHandler().onComplete(this.onSuccess(res -> {
            this.assertNull(res);
            this.testComplete();
        }));
        this.await();
    }

    @Test
    public void testDoubleHandler() {
        this.proxy.doubleHandler().onComplete(this.onSuccess(res -> {
            this.assertEquals(12.3456, res);
            this.testComplete();
        }));
        this.await();
    }

    @Test
    public void testDoubleNullHandler() {
        this.proxy.doubleNullHandler().onComplete(this.onSuccess(res -> {
            this.assertNull(res);
            this.testComplete();
        }));
        this.await();
    }

    @Test
    public void testCharHandler() {
        this.proxy.charHandler().onComplete(this.onSuccess(res -> {
            this.assertEquals(Character.valueOf('X'), res);
            this.testComplete();
        }));
        this.await();
    }

    @Test
    public void testCharNullHandler() {
        this.proxy.charNullHandler().onComplete(this.onSuccess(res -> {
            this.assertNull(res);
            this.testComplete();
        }));
        this.await();
    }

    @Test
    public void testBooleanHandler() {
        this.proxy.booleanHandler().onComplete(this.onSuccess(res -> {
            this.assertEquals(true, res);
            this.testComplete();
        }));
        this.await();
    }

    @Test
    public void testBooleanNullHandler() {
        this.proxy.booleanNullHandler().onComplete(this.onSuccess(res -> {
            this.assertNull(res);
            this.testComplete();
        }));
        this.await();
    }

    @Test
    public void testJsonObjectHandler() {
        this.proxy.jsonObjectHandler().onComplete(this.onSuccess(res -> {
            this.assertEquals("wibble", res.getString("blah"));
            this.testComplete();
        }));
        this.await();
    }

    @Test
    public void testJsonObjectNullHandler() {
        this.proxy.jsonObjectNullHandler().onComplete(this.onSuccess(res -> {
            this.assertNull(res);
            this.testComplete();
        }));
        this.await();
    }

    @Test
    public void testJsonArrayHandler() {
        this.proxy.jsonArrayHandler().onComplete(this.onSuccess(res -> {
            this.assertEquals("blurrg", res.getString(0));
            this.testComplete();
        }));
        this.await();
    }

    @Test
    public void testJsonArrayNullHandler() {
        this.proxy.jsonArrayNullHandler().onComplete(this.onSuccess(res -> {
            this.assertNull(res);
            this.testComplete();
        }));
        this.await();
    }

    @Test
    public void testDataObjectHandler() {
        this.proxy.dataObjectHandler().onComplete(this.onSuccess(res -> {
            this.assertEquals(new TestDataObject().setString("foo").setNumber(123).setBool(true), res);
            this.testComplete();
        }));
        this.await();
    }

    @Test
    public void testDataObjectNullHandler() {
        this.proxy.dataObjectNullHandler().onComplete(this.onSuccess(res -> {
            this.assertNull(res);
            this.testComplete();
        }));
        this.await();
    }

    @Test
    public void testVoidHandler() {
        this.proxy.voidHandler().onComplete(this.onSuccess(res -> {
            this.assertNull(res);
            this.testComplete();
        }));
        this.await();
    }

    @Test
    public void testFailingMethod() {
        this.proxy.failingMethod().onComplete(this.onFailure(t -> {
            this.assertTrue(t instanceof ReplyException);
            ServiceException se = (ServiceException)((Object)t);
            this.assertEquals(ReplyFailure.RECIPIENT_FAILURE, se.failureType());
            this.assertEquals("wibble", se.getMessage());
            this.assertTrue(se.getDebugInfo().isEmpty());
            this.testComplete();
        }));
        this.await();
    }

    @Test
    public void testCallWithMessage() {
        JsonObject message = new JsonObject();
        message.put("object", (Object)new JsonObject().put("foo", (Object)"bar"));
        message.put("str", (Object)"blah");
        message.put("i", (Object)1234);
        message.put("chr", (Object)88);
        message.put("senum", (Object)SomeEnum.BAR.toString());
        this.vertx.eventBus().request(SERVICE_ADDRESS, (Object)message, new DeliveryOptions().addHeader("action", "invokeWithMessage")).onComplete(this.onSuccess(res -> {
            this.assertEquals("goats", res.body());
            this.testComplete();
        }));
        this.await();
    }

    @Test
    public void testCallWithMessageInvalidAction() {
        JsonObject message = new JsonObject();
        message.put("object", (Object)new JsonObject().put("foo", (Object)"bar"));
        message.put("str", (Object)"blah");
        message.put("i", (Object)1234);
        this.vertx.eventBus().request(SERVICE_WITH_DEBUG_ADDRESS, (Object)message, new DeliveryOptions().addHeader("action", "yourmum").setSendTimeout(500L)).onComplete(this.onFailure(t -> {
            this.assertTrue(t instanceof ServiceException);
            ServiceException se = (ServiceException)((Object)t);
            this.assertEquals(ReplyFailure.RECIPIENT_FAILURE, se.failureType());
            this.assertEquals(IllegalStateException.class.getCanonicalName(), se.getDebugInfo().getString("causeName"));
            this.testComplete();
        }));
        this.await();
    }

    @Test
    public void testCallWithMessageParamWrongType() {
        JsonObject message = new JsonObject();
        message.put("object", (Object)new JsonObject().put("foo", (Object)"bar"));
        message.put("str", (Object)76523);
        message.put("i", (Object)1234);
        message.put("char", (Object)88);
        message.put("enum", (Object)SomeEnum.BAR.toString());
        this.vertx.eventBus().request(SERVICE_WITH_DEBUG_ADDRESS, (Object)message, new DeliveryOptions().addHeader("action", "invokeWithMessage").setSendTimeout(500L)).onComplete(this.onFailure(t -> {
            this.assertTrue(t instanceof ServiceException);
            ServiceException se = (ServiceException)((Object)t);
            this.assertEquals(ReplyFailure.RECIPIENT_FAILURE, se.failureType());
            this.assertEquals(ClassCastException.class.getCanonicalName(), se.getDebugInfo().getString("causeName"));
            this.assertFalse(se.getDebugInfo().getJsonArray("causeStackTrace").isEmpty());
            this.testComplete();
        }));
        this.await();
    }

    @Test
    public void testListStringHandler() {
        this.proxy.listStringHandler().onComplete(this.onSuccess(list -> {
            this.assertEquals("foo", list.get(0));
            this.assertEquals("bar", list.get(1));
            this.assertEquals("wibble", list.get(2));
            this.testComplete();
        }));
        this.await();
    }

    @Test
    public void testListByteHandler() {
        this.proxy.listByteHandler().onComplete(this.onSuccess(list -> {
            this.assertEquals((byte)1, list.get(0));
            this.assertEquals((byte)2, list.get(1));
            this.assertEquals((byte)3, list.get(2));
            this.testComplete();
        }));
        this.await();
    }

    @Test
    public void testListShortHandler() {
        this.proxy.listShortHandler().onComplete(this.onSuccess(list -> {
            this.assertEquals((short)11, list.get(0));
            this.assertEquals((short)12, list.get(1));
            this.assertEquals((short)13, list.get(2));
            this.testComplete();
        }));
        this.await();
    }

    @Test
    public void testListIntHandler() {
        this.proxy.listIntHandler().onComplete(this.onSuccess(list -> {
            this.assertEquals(100L, ((Integer)list.get(0)).intValue());
            this.assertEquals(101L, ((Integer)list.get(1)).intValue());
            this.assertEquals(102L, ((Integer)list.get(2)).intValue());
            this.testComplete();
        }));
        this.await();
    }

    @Test
    public void testListLongHandler() {
        this.proxy.listLongHandler().onComplete(this.onSuccess(list -> {
            this.assertEquals(1000L, (Long)list.get(0));
            this.assertEquals(1001L, (Long)list.get(1));
            this.assertEquals(1002L, (Long)list.get(2));
            this.testComplete();
        }));
        this.await();
    }

    @Test
    public void testListFloatHandler() {
        this.proxy.listFloatHandler().onComplete(this.onSuccess(list -> {
            this.assertEquals(1.1f, ((Float)list.get(0)).floatValue(), 0.0);
            this.assertEquals(1.2f, ((Float)list.get(1)).floatValue(), 0.0);
            this.assertEquals(1.3f, ((Float)list.get(2)).floatValue(), 0.0);
            this.testComplete();
        }));
        this.await();
    }

    @Test
    public void testListDoubleHandler() {
        this.proxy.listDoubleHandler().onComplete(this.onSuccess(list -> {
            this.assertEquals(1.11, (Double)list.get(0), 0.0);
            this.assertEquals(1.12, (Double)list.get(1), 0.0);
            this.assertEquals(1.13, (Double)list.get(2), 0.0);
            this.testComplete();
        }));
        this.await();
    }

    @Test
    public void testListCharHandler() {
        this.proxy.listCharHandler().onComplete(this.onSuccess(list -> {
            this.assertEquals(88L, ((Character)list.get(0)).charValue());
            this.assertEquals(89L, ((Character)list.get(1)).charValue());
            this.assertEquals(90L, ((Character)list.get(2)).charValue());
            this.testComplete();
        }));
        this.await();
    }

    @Test
    public void testListBoolHandler() {
        this.proxy.listBoolHandler().onComplete(this.onSuccess(list -> {
            this.assertEquals(true, list.get(0));
            this.assertEquals(false, list.get(1));
            this.assertEquals(true, list.get(2));
            this.testComplete();
        }));
        this.await();
    }

    @Test
    public void testListJsonObjectHandler() {
        this.proxy.listJsonObjectHandler().onComplete(this.onSuccess(list -> {
            this.assertEquals("foo", ((JsonObject)list.get(0)).getString("a"));
            this.assertEquals("bar", ((JsonObject)list.get(1)).getString("b"));
            this.assertEquals("wibble", ((JsonObject)list.get(2)).getString("c"));
            this.testComplete();
        }));
        this.await();
    }

    @Test
    public void testListJsonArrayHandler() {
        this.proxy.listJsonArrayHandler().onComplete(this.onSuccess(list -> {
            this.assertEquals("foo", ((JsonArray)list.get(0)).getString(0));
            this.assertEquals("bar", ((JsonArray)list.get(1)).getString(0));
            this.assertEquals("wibble", ((JsonArray)list.get(2)).getString(0));
            this.testComplete();
        }));
        this.await();
    }

    @Test
    public void testSetStringHandler() {
        this.proxy.setStringHandler().onComplete(this.onSuccess(set -> {
            this.assertTrue(set.contains("foo"));
            this.assertTrue(set.contains("bar"));
            this.assertTrue(set.contains("wibble"));
            this.testComplete();
        }));
        this.await();
    }

    @Test
    public void testSetByteHandler() {
        this.proxy.setByteHandler().onComplete(this.onSuccess(set -> {
            this.assertTrue(set.contains((byte)1));
            this.assertTrue(set.contains((byte)2));
            this.assertTrue(set.contains((byte)3));
            this.testComplete();
        }));
        this.await();
    }

    @Test
    public void testSetShortHandler() {
        this.proxy.setShortHandler().onComplete(this.onSuccess(set -> {
            this.assertTrue(set.contains((short)11));
            this.assertTrue(set.contains((short)12));
            this.assertTrue(set.contains((short)13));
            this.testComplete();
        }));
        this.await();
    }

    @Test
    public void testSetIntHandler() {
        this.proxy.setIntHandler().onComplete(this.onSuccess(set -> {
            this.assertTrue(set.contains(100));
            this.assertTrue(set.contains(101));
            this.assertTrue(set.contains(102));
            this.testComplete();
        }));
        this.await();
    }

    @Test
    public void testSetLongHandler() {
        this.proxy.setLongHandler().onComplete(this.onSuccess(set -> {
            this.assertTrue(set.contains(1000L));
            this.assertTrue(set.contains(1001L));
            this.assertTrue(set.contains(1002L));
            this.testComplete();
        }));
        this.await();
    }

    @Test
    public void testSetFloatHandler() {
        this.proxy.setFloatHandler().onComplete(this.onSuccess(set -> {
            this.assertTrue(set.contains(Float.valueOf(1.1f)));
            this.assertTrue(set.contains(Float.valueOf(1.2f)));
            this.assertTrue(set.contains(Float.valueOf(1.3f)));
            this.testComplete();
        }));
        this.await();
    }

    @Test
    public void testSetDoubleHandler() {
        this.proxy.setDoubleHandler().onComplete(this.onSuccess(set -> {
            this.assertTrue(set.contains(1.11));
            this.assertTrue(set.contains(1.12));
            this.assertTrue(set.contains(1.13));
            this.testComplete();
        }));
        this.await();
    }

    @Test
    public void testSetCharHandler() {
        this.proxy.setCharHandler().onComplete(this.onSuccess(set -> {
            this.assertTrue(set.contains(Character.valueOf('X')));
            this.assertTrue(set.contains(Character.valueOf('Y')));
            this.assertTrue(set.contains(Character.valueOf('Z')));
            this.testComplete();
        }));
        this.await();
    }

    @Test
    public void testSetBoolHandler() {
        this.proxy.setBoolHandler().onComplete(this.onSuccess(set -> {
            this.assertTrue(set.contains(true));
            this.assertTrue(set.contains(false));
            this.testComplete();
        }));
        this.await();
    }

    @Test
    public void testMapStringHandler() {
        HashMap<String, String> expected = new HashMap<String, String>();
        expected.put("1", "foo");
        expected.put("2", "bar");
        expected.put("3", "wibble");
        this.proxy.mapStringHandler().onComplete(this.onSuccess(map -> {
            this.assertEquals(expected, map);
            this.testComplete();
        }));
        this.await();
    }

    @Test
    public void testMapByteHandler() {
        HashMap<String, Byte> expected = new HashMap<String, Byte>();
        expected.put("1", (byte)1);
        expected.put("2", (byte)2);
        expected.put("3", (byte)3);
        this.proxy.mapByteHandler().onComplete(this.onSuccess(map -> {
            this.assertEquals(expected, map);
            this.testComplete();
        }));
        this.await();
    }

    @Test
    public void testMapShortHandler() {
        HashMap<String, Short> expected = new HashMap<String, Short>();
        expected.put("1", (short)11);
        expected.put("2", (short)12);
        expected.put("3", (short)13);
        this.proxy.mapShortHandler().onComplete(this.onSuccess(map -> {
            this.assertEquals(expected, map);
            this.testComplete();
        }));
        this.await();
    }

    @Test
    public void testMapIntHandler() {
        HashMap<String, Integer> expected = new HashMap<String, Integer>();
        expected.put("1", 100);
        expected.put("2", 101);
        expected.put("3", 102);
        this.proxy.mapIntHandler().onComplete(this.onSuccess(map -> {
            this.assertEquals(expected, map);
            this.testComplete();
        }));
        this.await();
    }

    @Test
    public void testMapLongHandler() {
        HashMap<String, Long> expected = new HashMap<String, Long>();
        expected.put("1", 1000L);
        expected.put("2", 1001L);
        expected.put("3", 1002L);
        this.proxy.mapLongHandler().onComplete(this.onSuccess(map -> {
            this.assertEquals(expected, map);
            this.testComplete();
        }));
        this.await();
    }

    @Test
    public void testMapFloatHandler() {
        HashMap<String, Float> expected = new HashMap<String, Float>();
        expected.put("1", Float.valueOf(1.1f));
        expected.put("2", Float.valueOf(1.2f));
        expected.put("3", Float.valueOf(1.3f));
        this.proxy.mapFloatHandler().onComplete(this.onSuccess(map -> {
            this.assertEquals(expected, map);
            this.testComplete();
        }));
        this.await();
    }

    @Test
    public void testMapDoubleHandler() {
        HashMap<String, Double> expected = new HashMap<String, Double>();
        expected.put("1", 1.11);
        expected.put("2", 1.12);
        expected.put("3", 1.13);
        this.proxy.mapDoubleHandler().onComplete(this.onSuccess(map -> {
            this.assertEquals(expected, map);
            this.testComplete();
        }));
        this.await();
    }

    @Test
    public void testMapCharHandler() {
        HashMap<String, Character> expected = new HashMap<String, Character>();
        expected.put("1", Character.valueOf('X'));
        expected.put("2", Character.valueOf('Y'));
        expected.put("3", Character.valueOf('Z'));
        this.proxy.mapCharHandler().onComplete(this.onSuccess(map -> {
            this.assertEquals(expected, map);
            this.testComplete();
        }));
        this.await();
    }

    @Test
    public void testMapBoolHandler() {
        HashMap<String, Boolean> expected = new HashMap<String, Boolean>();
        expected.put("1", true);
        expected.put("2", false);
        expected.put("3", true);
        this.proxy.mapBoolHandler().onComplete(this.onSuccess(map -> {
            this.assertEquals(expected, map);
            this.testComplete();
        }));
        this.await();
    }

    @Test
    public void testSetJsonObjectHandler() {
        this.proxy.setJsonObjectHandler().onComplete(this.onSuccess(set -> {
            this.assertTrue(set.contains(new JsonObject().put("a", (Object)"foo")));
            this.assertTrue(set.contains(new JsonObject().put("b", (Object)"bar")));
            this.assertTrue(set.contains(new JsonObject().put("c", (Object)"wibble")));
            this.testComplete();
        }));
        this.await();
    }

    @Test
    public void testMapJsonObjectHandler() {
        HashMap<String, JsonObject> expected = new HashMap<String, JsonObject>();
        expected.put("1", new JsonObject().put("a", (Object)"foo"));
        expected.put("2", new JsonObject().put("b", (Object)"bar"));
        expected.put("3", new JsonObject().put("c", (Object)"wibble"));
        this.proxy.mapJsonObjectHandler().onComplete(this.onSuccess(map -> {
            this.assertEquals(expected, map);
            this.testComplete();
        }));
        this.await();
    }

    @Test
    public void setSetJsonArrayHandler() {
        this.proxy.setJsonArrayHandler().onComplete(this.onSuccess(set -> {
            this.assertTrue(set.contains(new JsonArray().add((Object)"foo")));
            this.assertTrue(set.contains(new JsonArray().add((Object)"bar")));
            this.assertTrue(set.contains(new JsonArray().add((Object)"wibble")));
            this.testComplete();
        }));
        this.await();
    }

    @Test
    public void testMapJsonArrayHandler() {
        HashMap<String, JsonArray> expected = new HashMap<String, JsonArray>();
        expected.put("1", new JsonArray().add((Object)"foo"));
        expected.put("2", new JsonArray().add((Object)"bar"));
        expected.put("3", new JsonArray().add((Object)"wibble"));
        this.proxy.mapJsonArrayHandler().onComplete(this.onSuccess(map -> {
            this.assertEquals(expected, map);
            this.testComplete();
        }));
        this.await();
    }

    @Test
    public void testListDataObjectHandler() {
        this.proxy.listDataObjectHandler().onComplete(this.onSuccess(list -> {
            this.assertEquals(1L, ((TestDataObject)list.get(0)).getNumber());
            this.assertEquals("String 1", ((TestDataObject)list.get(0)).getString());
            this.assertEquals(false, ((TestDataObject)list.get(0)).isBool());
            this.assertEquals(2L, ((TestDataObject)list.get(1)).getNumber());
            this.assertEquals("String 2", ((TestDataObject)list.get(1)).getString());
            this.assertEquals(true, ((TestDataObject)list.get(1)).isBool());
            this.testComplete();
        }));
        this.await();
    }

    @Test
    public void testSetDataObjectHandler() {
        this.proxy.setDataObjectHandler().onComplete(this.onSuccess(set -> {
            Set setJson = set.stream().map(d -> d.toJson()).collect(Collectors.toSet());
            this.assertEquals(2L, setJson.size());
            this.assertTrue(setJson.contains(new JsonObject().put("number", (Object)1).put("string", (Object)"String 1").put("bool", (Object)false)));
            this.assertTrue(setJson.contains(new JsonObject().put("number", (Object)2).put("string", (Object)"String 2").put("bool", (Object)true)));
            this.testComplete();
        }));
        this.await();
    }

    @Test
    public void testMapDataObjectHandler() {
        HashMap<String, TestDataObject> expected = new HashMap<String, TestDataObject>();
        expected.put("do1", new TestDataObject().setNumber(1).setString("String 1").setBool(false));
        expected.put("do2", new TestDataObject().setNumber(2).setString("String 2").setBool(true));
        this.proxy.mapDataObject().onComplete(this.onSuccess(map -> {
            this.assertEquals(expected, map);
            this.testComplete();
        }));
        this.await();
    }

    @Test
    public void testDateTimeHandler() {
        this.proxy.zonedDateTimeHandler().onComplete(this.onSuccess(dateTime -> {
            this.assertEquals(ZonedDateTime.parse("2019-03-25T17:08:31.069+01:00[Europe/Rome]"), dateTime);
            this.testComplete();
        }));
        this.await();
    }

    @Test
    public void testListDateTimeHandler() {
        this.proxy.listZonedDateTimeHandler().onComplete(this.onSuccess(list -> {
            this.assertEquals(Arrays.asList(ZonedDateTime.parse("2019-03-25T17:08:31.069+01:00[Europe/Rome]"), ZonedDateTime.parse("2019-03-25T17:08:31.069+01:00[Europe/Rome]").plusHours(1L)), list);
            this.testComplete();
        }));
        this.await();
    }

    @Test
    public void testSetDateTimeHandler() {
        this.proxy.setZonedDateTimeHandler().onComplete(this.onSuccess(set -> {
            this.assertEquals(new HashSet<ZonedDateTime>(Arrays.asList(ZonedDateTime.parse("2019-03-25T17:08:31.069+01:00[Europe/Rome]"), ZonedDateTime.parse("2019-03-25T17:08:31.069+01:00[Europe/Rome]").plusHours(1L))), set);
            this.testComplete();
        }));
        this.await();
    }

    @Test
    public void testMapDateTimeHandler() {
        HashMap<String, ZonedDateTime> expected = new HashMap<String, ZonedDateTime>();
        expected.put("date1", ZonedDateTime.parse("2019-03-25T17:08:31.069+01:00[Europe/Rome]"));
        expected.put("date2", ZonedDateTime.parse("2019-03-25T17:08:31.069+01:00[Europe/Rome]").plusHours(1L));
        this.proxy.mapZonedDateTimeHandler().onComplete(this.onSuccess(map -> {
            this.assertEquals(expected, map);
            this.testComplete();
        }));
        this.await();
    }

    @Test
    public void testProxyIgnore() {
        this.proxy.ignoredMethod();
        this.vertx.setTimer(500L, id -> this.testComplete());
        this.await();
    }

    @Test
    public void testConnection() {
        this.proxy.createConnection("foo").onComplete(this.onSuccess(conn -> {
            conn.startTransaction().onComplete(this.onSuccess(res -> this.assertEquals("foo", res)));
            conn.insert("blah", new JsonObject()).onComplete(this.onSuccess(res -> this.assertEquals("foo", res)));
            conn.commit().onComplete(this.onSuccess(res -> this.assertEquals("foo", res)));
            this.vertx.eventBus().consumer("closeCalled").handler(msg -> {
                this.assertEquals("blah", msg.body());
                this.testComplete();
            });
            conn.close();
            conn.startTransaction().onComplete(this.onFailure(cause -> {
                this.assertNotNull(cause);
                this.assertEquals("Proxy is closed", cause.getMessage());
            }));
        }));
        this.await();
    }

    @Test
    public void testConnectionTimeout() {
        this.consumer.unregister();
        this.consumer = new ServiceBinder(this.vertx).setAddress(SERVICE_ADDRESS).setTimeoutSeconds(2L).register(TestService.class, (Object)this.service);
        this.checkConnection(this.proxy, 2L);
        this.await();
    }

    @Test
    public void testLocalServiceConnectionTimeout() {
        this.localConsumer.unregister();
        this.localConsumer = new ServiceBinder(this.vertx).setAddress(SERVICE_LOCAL_ADDRESS).setTimeoutSeconds(2L).register(TestService.class, (Object)this.localService);
        this.checkConnection(this.localProxy, 2L);
        this.await();
    }

    @Test
    public void testLongDelivery1() {
        TestService proxyLong = TestService.createProxyLongDelivery(this.vertx, SERVICE_ADDRESS);
        proxyLong.longDeliverySuccess().onComplete(this.onSuccess(str -> {
            this.assertEquals("blah", str);
            this.testComplete();
        }));
        this.await();
    }

    @Test
    public void testLongDelivery2() {
        TestService proxyLong = TestService.createProxyLongDelivery(this.vertx, SERVICE_ADDRESS);
        proxyLong.longDeliveryFailed().onComplete(this.onFailure(t -> {
            this.assertNotNull(t);
            this.assertTrue(t instanceof ReplyException);
            this.assertFalse(t instanceof ServiceException);
            ReplyException re = (ReplyException)((Object)t);
            this.assertEquals(ReplyFailure.TIMEOUT, re.failureType());
            this.testComplete();
        }));
        this.await();
    }

    @Test
    public void testWithInitialHeader1() {
        DeliveryOptions options = new DeliveryOptions();
        options.addHeader("any", "thing");
        TestService p = TestService.createProxyWithOptions(this.vertx, SERVICE_ADDRESS, options);
        p.jsonObjectNullHandler().onComplete(this.onSuccess(json -> this.assertNull(json)));
        p.jsonObjectHandler().onComplete(this.onSuccess(json -> {
            this.assertNotNull(json);
            this.testComplete();
        }));
        this.await();
    }

    @Test
    public void testWithInitialHeader2() {
        DeliveryOptions options = new DeliveryOptions();
        options.addHeader("action", "failingMethod");
        TestService p = TestService.createProxyWithOptions(this.vertx, SERVICE_ADDRESS, options);
        p.jsonObjectNullHandler().onComplete(this.onSuccess(json -> this.assertNull(json)));
        p.jsonObjectHandler().onComplete(this.onSuccess(json -> {
            this.assertNotNull(json);
            this.testComplete();
        }));
        this.await();
    }

    @Test
    public void testUnregisteringTheService() {
        this.proxy.booleanHandler().onComplete(ar -> this.consumer.unregister().onComplete(ar1 -> {
            if (ar1.failed()) {
                this.fail(ar1.cause());
            } else {
                this.testComplete();
            }
        }));
        this.await();
        AtomicReference caughtError = new AtomicReference();
        this.proxy.booleanHandler().onComplete(ar -> caughtError.set(ar.cause()));
        ServiceProxyTest.assertWaitUntil(() -> caughtError.get() != null);
    }

    @Test
    public void testAListContainingNullValues() {
        this.proxy.listDataObjectContainingNullHandler().onComplete(this.onSuccess(list -> {
            this.assertEquals(1L, ((TestDataObject)list.get(0)).getNumber());
            this.assertEquals("String 1", ((TestDataObject)list.get(0)).getString());
            this.assertEquals(false, ((TestDataObject)list.get(0)).isBool());
            this.assertNull(list.get(1));
            this.assertEquals(2L, ((TestDataObject)list.get(2)).getNumber());
            this.assertEquals("String 2", ((TestDataObject)list.get(2)).getString());
            this.assertEquals(true, ((TestDataObject)list.get(2)).isBool());
            this.testComplete();
        }));
        this.await();
    }

    @Test
    public void testASetContainingNullValues() {
        this.proxy.setDataObjectContainingNullHandler().onComplete(this.onSuccess(set -> {
            AtomicInteger countNull = new AtomicInteger();
            AtomicInteger countNotNull = new AtomicInteger();
            set.forEach(t -> {
                if (t == null) {
                    countNull.incrementAndGet();
                } else {
                    countNotNull.incrementAndGet();
                }
            });
            this.assertEquals(2L, countNotNull.get());
            this.assertEquals(1L, countNull.get());
            this.testComplete();
        }));
        this.await();
    }

    @Test
    public void testLocalServiceFromLocalSender() {
        this.localProxy.noParams();
        this.await();
    }

    private void checkConnection(TestService proxy, long timeoutSeconds) {
        proxy.createConnection("foo").onComplete(this.onSuccess(conn -> {
            long start = System.nanoTime();
            conn.startTransaction().onComplete(this.onSuccess(res -> {
                this.assertEquals("foo", res);
                this.vertx.eventBus().consumer("closeCalled").handler(msg -> {
                    this.assertEquals("blah", msg.body());
                    long duration = System.nanoTime() - start;
                    this.assertTrue(String.valueOf(duration), duration >= TimeUnit.SECONDS.toNanos(timeoutSeconds));
                    conn.startTransaction().onComplete(this.onFailure(this::checkCause));
                });
            }));
        }));
    }

    private void checkCause(Throwable cause) {
        this.assertNotNull(cause);
        this.assertTrue(cause instanceof ReplyException);
        this.assertFalse(cause instanceof ServiceException);
        ReplyException re = (ReplyException)cause;
        this.assertEquals(ReplyFailure.NO_HANDLERS, re.failureType());
        this.testComplete();
    }
}

