/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.serviceproxy.tests.clustered;

import io.vertx.core.Vertx;
import io.vertx.core.VertxOptions;
import io.vertx.core.eventbus.MessageCodec;
import io.vertx.core.eventbus.ReplyException;
import io.vertx.core.eventbus.ReplyFailure;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.core.spi.cluster.ClusterManager;
import io.vertx.serviceproxy.ServiceException;
import io.vertx.serviceproxy.tests.clustered.LocalServiceProviderVerticle;
import io.vertx.serviceproxy.tests.clustered.Service;
import io.vertx.serviceproxy.tests.clustered.ServiceProviderVerticle;
import io.vertx.serviceproxy.tests.testmodel.MyServiceException;
import io.vertx.serviceproxy.tests.testmodel.MyServiceExceptionMessageCodec;
import io.vertx.serviceproxy.tests.testmodel.SomeEnum;
import io.vertx.serviceproxy.tests.testmodel.SomeVertxEnum;
import io.vertx.serviceproxy.tests.testmodel.StringDataObject;
import io.vertx.serviceproxy.tests.testmodel.TestDataObject;
import io.vertx.test.fakecluster.FakeClusterManager;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.assertj.core.api.Assertions;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ClusteredTest {
    private Vertx producerNode;
    private Vertx consumerNode;

    @Before
    public void setUp() throws Exception {
        VertxOptions options = new VertxOptions();
        options.getEventBusOptions().setHost("127.0.0.1");
        this.producerNode = (Vertx)Vertx.builder().with(options).withClusterManager((ClusterManager)new FakeClusterManager()).buildClustered().await(20L, TimeUnit.SECONDS);
        this.producerNode.eventBus().registerDefaultCodec(MyServiceException.class, (MessageCodec)new MyServiceExceptionMessageCodec());
        this.producerNode.deployVerticle(ServiceProviderVerticle.class.getName());
        this.producerNode.deployVerticle(LocalServiceProviderVerticle.class.getName());
        this.consumerNode = (Vertx)Vertx.builder().with(options).withClusterManager((ClusterManager)new FakeClusterManager()).buildClustered().await(20L, TimeUnit.SECONDS);
        this.consumerNode.eventBus().registerDefaultCodec(MyServiceException.class, (MessageCodec)new MyServiceExceptionMessageCodec());
    }

    @Test
    public void testHello() throws Exception {
        Service service = Service.createProxy(this.consumerNode, "my.service");
        String res = (String)service.hello("vert.x").await(20L, TimeUnit.SECONDS);
        Assert.assertEquals((Object)"hello vert.x", (Object)res);
    }

    @Test
    public void testEnumAsParameter() throws Exception {
        Service service = Service.createProxy(this.consumerNode, "my.service");
        Boolean res = (Boolean)service.methodUsingEnum(SomeEnum.WIBBLE).await(20L, TimeUnit.SECONDS);
        Assert.assertNotNull((Object)res);
        Assert.assertTrue((boolean)res);
    }

    @Test
    public void testEnumAsResult() throws Exception {
        AtomicReference result = new AtomicReference();
        Service service = Service.createProxy(this.consumerNode, "my.service");
        SomeEnum res = (SomeEnum)((Object)service.methodReturningEnum().await(20L, TimeUnit.SECONDS));
        Assert.assertEquals((Object)((Object)SomeEnum.WIBBLE), (Object)((Object)res));
    }

    @Test
    public void testVertxEnumAsResult() throws Exception {
        Service service = Service.createProxy(this.consumerNode, "my.service");
        SomeVertxEnum res = (SomeVertxEnum)((Object)service.methodReturningVertxEnum().await(20L, TimeUnit.SECONDS));
        Assert.assertEquals((Object)((Object)SomeVertxEnum.BAR), (Object)((Object)res));
    }

    @Test
    public void testWithDataObject() throws Exception {
        Service service = Service.createProxy(this.consumerNode, "my.service");
        TestDataObject data = new TestDataObject().setBool(true).setNumber(25).setString("vert.x");
        TestDataObject out = (TestDataObject)service.methodWithDataObject(data).await(20L, TimeUnit.SECONDS);
        Assertions.assertThat((int)out.getNumber()).isEqualTo(25);
        Assertions.assertThat((boolean)out.isBool()).isTrue();
        Assertions.assertThat((String)out.getString()).isEqualTo((Object)"vert.x");
    }

    @Test
    public void testWithListOfDataObject() throws Exception {
        Service service = Service.createProxy(this.consumerNode, "my.service");
        TestDataObject data = new TestDataObject().setBool(true).setNumber(25).setString("vert.x");
        TestDataObject data2 = new TestDataObject().setBool(true).setNumber(26).setString("vert.x");
        List out = (List)service.methodWithListOfDataObject(Arrays.asList(data, data2)).await(20L, TimeUnit.SECONDS);
        Assertions.assertThat((int)((TestDataObject)out.get(0)).getNumber()).isEqualTo(25);
        Assertions.assertThat((boolean)((TestDataObject)out.get(0)).isBool()).isTrue();
        Assertions.assertThat((String)((TestDataObject)out.get(0)).getString()).isEqualTo((Object)"vert.x");
        Assertions.assertThat((int)((TestDataObject)out.get(1)).getNumber()).isEqualTo(26);
        Assertions.assertThat((boolean)((TestDataObject)out.get(1)).isBool()).isTrue();
        Assertions.assertThat((String)((TestDataObject)out.get(1)).getString()).isEqualTo((Object)"vert.x");
    }

    @Test
    public void testWithStringDataObject() throws Exception {
        Service service = Service.createProxy(this.consumerNode, "my.service");
        StringDataObject data = new StringDataObject().setValue("vert.x");
        StringDataObject out = (StringDataObject)service.methodWithStringDataObject(data).await(20L, TimeUnit.SECONDS);
        Assertions.assertThat((String)out.getValue()).isEqualTo((Object)"vert.x");
    }

    @Test
    public void testWithListOfStringDataObject() throws Exception {
        Service service = Service.createProxy(this.consumerNode, "my.service");
        StringDataObject data = new StringDataObject().setValue("vert.x-1");
        StringDataObject data2 = new StringDataObject().setValue("vert.x-2");
        List out = (List)service.methodWithListOfStringDataObject(Arrays.asList(data, data2)).await(20L, TimeUnit.SECONDS);
        Assertions.assertThat((String)((StringDataObject)out.get(0)).getValue()).isEqualTo((Object)"vert.x-1");
        Assertions.assertThat((String)((StringDataObject)out.get(1)).getValue()).isEqualTo((Object)"vert.x-2");
    }

    @Test
    public void testWithListOfJsonObject() throws Exception {
        Service service = Service.createProxy(this.consumerNode, "my.service");
        TestDataObject data = new TestDataObject().setBool(true).setNumber(25).setString("vert.x");
        TestDataObject data2 = new TestDataObject().setBool(true).setNumber(26).setString("vert.x");
        List out = (List)service.methodWithListOfJsonObject(Arrays.asList(data.toJson(), data2.toJson())).await(20L, TimeUnit.SECONDS);
        TestDataObject out0 = new TestDataObject((JsonObject)out.get(0));
        TestDataObject out1 = new TestDataObject((JsonObject)out.get(1));
        Assertions.assertThat((int)out0.getNumber()).isEqualTo(25);
        Assertions.assertThat((boolean)out0.isBool()).isTrue();
        Assertions.assertThat((String)out0.getString()).isEqualTo((Object)"vert.x");
        Assertions.assertThat((int)out1.getNumber()).isEqualTo(26);
        Assertions.assertThat((boolean)out1.isBool()).isTrue();
        Assertions.assertThat((String)out1.getString()).isEqualTo((Object)"vert.x");
    }

    @Test
    public void testWithJsonObject() throws Exception {
        Service service = Service.createProxy(this.consumerNode, "my.service");
        TestDataObject data = new TestDataObject().setBool(true).setNumber(25).setString("vert.x");
        TestDataObject out = new TestDataObject((JsonObject)service.methodWithJsonObject(data.toJson()).await(20L, TimeUnit.SECONDS));
        Assertions.assertThat((int)out.getNumber()).isEqualTo(25);
        Assertions.assertThat((boolean)out.isBool()).isTrue();
        Assertions.assertThat((String)out.getString()).isEqualTo((Object)"vert.x");
    }

    @Test
    public void testWithJsonArray() throws Exception {
        Service service = Service.createProxy(this.consumerNode, "my.service");
        TestDataObject data = new TestDataObject().setBool(true).setNumber(25).setString("vert.x");
        JsonArray array = new JsonArray();
        array.add((Object)"vert.x").add((Object)data.toJson());
        TestDataObject out = new TestDataObject(((JsonArray)service.methodWithJsonArray(array).await(20L, TimeUnit.SECONDS)).getJsonObject(1));
        Assertions.assertThat((String)array.getString(0)).isEqualToIgnoringCase((CharSequence)"vert.x");
        Assertions.assertThat((int)out.getNumber()).isEqualTo(25);
        Assertions.assertThat((boolean)out.isBool()).isTrue();
        Assertions.assertThat((String)out.getString()).isEqualTo((Object)"vert.x");
    }

    @Test
    public void testWithFailingResult() throws Exception {
        Service service = Service.createProxy(this.consumerNode, "my.service");
        try {
            service.methodWthFailingResult("Fail").await(20L, TimeUnit.SECONDS);
            Assert.fail();
        }
        catch (ServiceException cause) {
            Assertions.assertThat((int)cause.failureCode()).isEqualTo(30);
            Assertions.assertThat((Iterable)cause.getDebugInfo()).isEqualTo((Object)new JsonObject().put("test", (Object)"val"));
        }
    }

    @Test
    public void testWithFailingResultServiceExceptionSubclass() throws Exception {
        Service service = Service.createProxy(this.consumerNode, "my.service");
        try {
            service.methodWthFailingResult("cluster Fail").await(20L, TimeUnit.SECONDS);
            Assert.fail();
        }
        catch (MyServiceException cause) {
            Assertions.assertThat((int)cause.failureCode()).isEqualTo(30);
            Assertions.assertThat((String)cause.getExtra()).isEqualTo((Object)"some extra");
        }
    }

    @Test
    public void testLocalServiceShouldBeUnreachable() throws Exception {
        Service service = Service.createProxy(this.consumerNode, "my.local.service");
        try {
            service.hello("vert.x").await(20L, TimeUnit.SECONDS);
        }
        catch (ReplyException cause) {
            Assertions.assertThat((Comparable)cause.failureType()).isEqualTo((Object)ReplyFailure.NO_HANDLERS);
        }
    }
}

