/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.serviceproxy.tests.clustered;

import io.vertx.core.Future;
import io.vertx.core.Vertx;
import io.vertx.core.eventbus.DeliveryOptions;
import io.vertx.core.eventbus.MessageCodec;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.serviceproxy.ProxyUtils;
import io.vertx.serviceproxy.ServiceException;
import io.vertx.serviceproxy.ServiceExceptionMessageCodec;
import io.vertx.serviceproxy.tests.clustered.Service;
import io.vertx.serviceproxy.tests.testmodel.Mappers;
import io.vertx.serviceproxy.tests.testmodel.SomeEnum;
import io.vertx.serviceproxy.tests.testmodel.SomeEnumWithCustomConstructor;
import io.vertx.serviceproxy.tests.testmodel.SomeVertxEnum;
import io.vertx.serviceproxy.tests.testmodel.StringDataObject;
import io.vertx.serviceproxy.tests.testmodel.TestDataObject;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public class ServiceVertxEBProxy
implements Service {
    private Vertx _vertx;
    private String _address;
    private DeliveryOptions _options;
    private boolean closed;

    public ServiceVertxEBProxy(Vertx vertx, String address) {
        this(vertx, address, null);
    }

    public ServiceVertxEBProxy(Vertx vertx, String address, DeliveryOptions options) {
        this._vertx = vertx;
        this._address = address;
        this._options = options;
        try {
            this._vertx.eventBus().registerDefaultCodec(ServiceException.class, (MessageCodec)new ServiceExceptionMessageCodec());
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Override
    public Future<String> hello(String name) {
        if (this.closed) {
            return Future.failedFuture((String)"Proxy is closed");
        }
        JsonObject _json = new JsonObject();
        _json.put("name", (Object)name);
        DeliveryOptions _deliveryOptions = this._options != null ? new DeliveryOptions(this._options) : new DeliveryOptions();
        _deliveryOptions.addHeader("action", "hello");
        _deliveryOptions.getHeaders().set("action", "hello");
        return this._vertx.eventBus().request(this._address, (Object)_json, _deliveryOptions).map(msg -> (String)msg.body());
    }

    @Override
    public Future<Boolean> methodUsingEnum(SomeEnum e) {
        if (this.closed) {
            return Future.failedFuture((String)"Proxy is closed");
        }
        JsonObject _json = new JsonObject();
        _json.put("e", (Object)(e == null ? null : e.name()));
        DeliveryOptions _deliveryOptions = this._options != null ? new DeliveryOptions(this._options) : new DeliveryOptions();
        _deliveryOptions.addHeader("action", "methodUsingEnum");
        _deliveryOptions.getHeaders().set("action", "methodUsingEnum");
        return this._vertx.eventBus().request(this._address, (Object)_json, _deliveryOptions).map(msg -> (Boolean)msg.body());
    }

    @Override
    public Future<SomeEnum> methodReturningEnum() {
        if (this.closed) {
            return Future.failedFuture((String)"Proxy is closed");
        }
        JsonObject _json = new JsonObject();
        DeliveryOptions _deliveryOptions = this._options != null ? new DeliveryOptions(this._options) : new DeliveryOptions();
        _deliveryOptions.addHeader("action", "methodReturningEnum");
        _deliveryOptions.getHeaders().set("action", "methodReturningEnum");
        return this._vertx.eventBus().request(this._address, (Object)_json, _deliveryOptions).map(msg -> msg.body() == null ? null : SomeEnum.valueOf((String)msg.body()));
    }

    @Override
    public Future<SomeVertxEnum> methodReturningVertxEnum() {
        if (this.closed) {
            return Future.failedFuture((String)"Proxy is closed");
        }
        JsonObject _json = new JsonObject();
        DeliveryOptions _deliveryOptions = this._options != null ? new DeliveryOptions(this._options) : new DeliveryOptions();
        _deliveryOptions.addHeader("action", "methodReturningVertxEnum");
        _deliveryOptions.getHeaders().set("action", "methodReturningVertxEnum");
        return this._vertx.eventBus().request(this._address, (Object)_json, _deliveryOptions).map(msg -> msg.body() == null ? null : SomeVertxEnum.valueOf((String)msg.body()));
    }

    @Override
    public Future<Boolean> methodUsingCustomEnum(SomeEnumWithCustomConstructor e) {
        if (this.closed) {
            return Future.failedFuture((String)"Proxy is closed");
        }
        JsonObject _json = new JsonObject();
        _json.put("e", (Object)(e != null ? Mappers.serializeSomeEnumWithCustomConstructor(e) : null));
        DeliveryOptions _deliveryOptions = this._options != null ? new DeliveryOptions(this._options) : new DeliveryOptions();
        _deliveryOptions.addHeader("action", "methodUsingCustomEnum");
        _deliveryOptions.getHeaders().set("action", "methodUsingCustomEnum");
        return this._vertx.eventBus().request(this._address, (Object)_json, _deliveryOptions).map(msg -> (Boolean)msg.body());
    }

    @Override
    public Future<SomeEnumWithCustomConstructor> methodReturningCustomEnum() {
        if (this.closed) {
            return Future.failedFuture((String)"Proxy is closed");
        }
        JsonObject _json = new JsonObject();
        DeliveryOptions _deliveryOptions = this._options != null ? new DeliveryOptions(this._options) : new DeliveryOptions();
        _deliveryOptions.addHeader("action", "methodReturningCustomEnum");
        _deliveryOptions.getHeaders().set("action", "methodReturningCustomEnum");
        return this._vertx.eventBus().request(this._address, (Object)_json, _deliveryOptions).map(msg -> msg.body() != null ? Mappers.deserializeSomeEnumWithCustomConstructor((String)msg.body()) : null);
    }

    @Override
    public Future<JsonObject> methodWithJsonObject(JsonObject json) {
        if (this.closed) {
            return Future.failedFuture((String)"Proxy is closed");
        }
        JsonObject _json = new JsonObject();
        _json.put("json", (Object)json);
        DeliveryOptions _deliveryOptions = this._options != null ? new DeliveryOptions(this._options) : new DeliveryOptions();
        _deliveryOptions.addHeader("action", "methodWithJsonObject");
        _deliveryOptions.getHeaders().set("action", "methodWithJsonObject");
        return this._vertx.eventBus().request(this._address, (Object)_json, _deliveryOptions).map(msg -> (JsonObject)msg.body());
    }

    @Override
    public Future<JsonArray> methodWithJsonArray(JsonArray json) {
        if (this.closed) {
            return Future.failedFuture((String)"Proxy is closed");
        }
        JsonObject _json = new JsonObject();
        _json.put("json", (Object)json);
        DeliveryOptions _deliveryOptions = this._options != null ? new DeliveryOptions(this._options) : new DeliveryOptions();
        _deliveryOptions.addHeader("action", "methodWithJsonArray");
        _deliveryOptions.getHeaders().set("action", "methodWithJsonArray");
        return this._vertx.eventBus().request(this._address, (Object)_json, _deliveryOptions).map(msg -> (JsonArray)msg.body());
    }

    @Override
    public Future<List<String>> methodWithList(List<String> list) {
        if (this.closed) {
            return Future.failedFuture((String)"Proxy is closed");
        }
        JsonObject _json = new JsonObject();
        _json.put("list", (Object)new JsonArray(list));
        DeliveryOptions _deliveryOptions = this._options != null ? new DeliveryOptions(this._options) : new DeliveryOptions();
        _deliveryOptions.addHeader("action", "methodWithList");
        _deliveryOptions.getHeaders().set("action", "methodWithList");
        return this._vertx.eventBus().request(this._address, (Object)_json, _deliveryOptions).map(msg -> ProxyUtils.convertList((List)((JsonArray)msg.body()).getList()));
    }

    @Override
    public Future<TestDataObject> methodWithDataObject(TestDataObject data) {
        if (this.closed) {
            return Future.failedFuture((String)"Proxy is closed");
        }
        JsonObject _json = new JsonObject();
        _json.put("data", (Object)(data != null ? data.toJson() : null));
        DeliveryOptions _deliveryOptions = this._options != null ? new DeliveryOptions(this._options) : new DeliveryOptions();
        _deliveryOptions.addHeader("action", "methodWithDataObject");
        _deliveryOptions.getHeaders().set("action", "methodWithDataObject");
        return this._vertx.eventBus().request(this._address, (Object)_json, _deliveryOptions).map(msg -> msg.body() != null ? new TestDataObject((JsonObject)msg.body()) : null);
    }

    @Override
    public Future<List<TestDataObject>> methodWithListOfDataObject(List<TestDataObject> list) {
        if (this.closed) {
            return Future.failedFuture((String)"Proxy is closed");
        }
        JsonObject _json = new JsonObject();
        _json.put("list", (Object)new JsonArray(list == null ? Collections.emptyList() : list.stream().map(v -> v != null ? v.toJson() : null).collect(Collectors.toList())));
        DeliveryOptions _deliveryOptions = this._options != null ? new DeliveryOptions(this._options) : new DeliveryOptions();
        _deliveryOptions.addHeader("action", "methodWithListOfDataObject");
        _deliveryOptions.getHeaders().set("action", "methodWithListOfDataObject");
        return this._vertx.eventBus().request(this._address, (Object)_json, _deliveryOptions).map(msg -> ((JsonArray)msg.body()).stream().map(v -> v != null ? new TestDataObject((JsonObject)v) : null).collect(Collectors.toList()));
    }

    @Override
    public Future<StringDataObject> methodWithStringDataObject(StringDataObject data) {
        if (this.closed) {
            return Future.failedFuture((String)"Proxy is closed");
        }
        JsonObject _json = new JsonObject();
        _json.put("data", (Object)(data != null ? data.toJson() : null));
        DeliveryOptions _deliveryOptions = this._options != null ? new DeliveryOptions(this._options) : new DeliveryOptions();
        _deliveryOptions.addHeader("action", "methodWithStringDataObject");
        _deliveryOptions.getHeaders().set("action", "methodWithStringDataObject");
        return this._vertx.eventBus().request(this._address, (Object)_json, _deliveryOptions).map(msg -> msg.body() != null ? new StringDataObject((String)msg.body()) : null);
    }

    @Override
    public Future<List<StringDataObject>> methodWithListOfStringDataObject(List<StringDataObject> list) {
        if (this.closed) {
            return Future.failedFuture((String)"Proxy is closed");
        }
        JsonObject _json = new JsonObject();
        _json.put("list", (Object)new JsonArray(list == null ? Collections.emptyList() : list.stream().map(v -> v != null ? v.toJson() : null).collect(Collectors.toList())));
        DeliveryOptions _deliveryOptions = this._options != null ? new DeliveryOptions(this._options) : new DeliveryOptions();
        _deliveryOptions.addHeader("action", "methodWithListOfStringDataObject");
        _deliveryOptions.getHeaders().set("action", "methodWithListOfStringDataObject");
        return this._vertx.eventBus().request(this._address, (Object)_json, _deliveryOptions).map(msg -> ((JsonArray)msg.body()).stream().map(v -> v != null ? new StringDataObject((String)v) : null).collect(Collectors.toList()));
    }

    @Override
    public Future<List<JsonObject>> methodWithListOfJsonObject(List<JsonObject> list) {
        if (this.closed) {
            return Future.failedFuture((String)"Proxy is closed");
        }
        JsonObject _json = new JsonObject();
        _json.put("list", (Object)new JsonArray(list));
        DeliveryOptions _deliveryOptions = this._options != null ? new DeliveryOptions(this._options) : new DeliveryOptions();
        _deliveryOptions.addHeader("action", "methodWithListOfJsonObject");
        _deliveryOptions.getHeaders().set("action", "methodWithListOfJsonObject");
        return this._vertx.eventBus().request(this._address, (Object)_json, _deliveryOptions).map(msg -> ProxyUtils.convertList((List)((JsonArray)msg.body()).getList()));
    }

    @Override
    public Future<JsonObject> methodWthFailingResult(String input) {
        if (this.closed) {
            return Future.failedFuture((String)"Proxy is closed");
        }
        JsonObject _json = new JsonObject();
        _json.put("input", (Object)input);
        DeliveryOptions _deliveryOptions = this._options != null ? new DeliveryOptions(this._options) : new DeliveryOptions();
        _deliveryOptions.addHeader("action", "methodWthFailingResult");
        _deliveryOptions.getHeaders().set("action", "methodWthFailingResult");
        return this._vertx.eventBus().request(this._address, (Object)_json, _deliveryOptions).map(msg -> (JsonObject)msg.body());
    }
}

