/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.serviceproxy.tests.codegen.proxytestapi;

import io.vertx.core.Future;
import io.vertx.core.Vertx;
import io.vertx.core.eventbus.DeliveryOptions;
import io.vertx.core.eventbus.MessageCodec;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.serviceproxy.ProxyUtils;
import io.vertx.serviceproxy.ServiceException;
import io.vertx.serviceproxy.ServiceExceptionMessageCodec;
import io.vertx.serviceproxy.tests.codegen.proxytestapi.ProxyConnection;
import io.vertx.serviceproxy.tests.codegen.proxytestapi.ProxyConnectionVertxEBProxy;
import io.vertx.serviceproxy.tests.codegen.proxytestapi.ProxyDataObject;
import io.vertx.serviceproxy.tests.codegen.proxytestapi.ProxyDataObjectWithParent;
import io.vertx.serviceproxy.tests.codegen.proxytestapi.ProxyDataObjectWithParentOverride;
import io.vertx.serviceproxy.tests.codegen.proxytestapi.SomeEnum;
import io.vertx.serviceproxy.tests.codegen.proxytestapi.ValidProxy;
import io.vertx.serviceproxy.tests.testmodel.Mappers;
import io.vertx.serviceproxy.tests.testmodel.SomeEnumWithCustomConstructor;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class ValidProxyVertxEBProxy
implements ValidProxy {
    private Vertx _vertx;
    private String _address;
    private DeliveryOptions _options;
    private boolean closed;

    public ValidProxyVertxEBProxy(Vertx vertx, String address) {
        this(vertx, address, null);
    }

    public ValidProxyVertxEBProxy(Vertx vertx, String address, DeliveryOptions options) {
        this._vertx = vertx;
        this._address = address;
        this._options = options;
        try {
            this._vertx.eventBus().registerDefaultCodec(ServiceException.class, (MessageCodec)new ServiceExceptionMessageCodec());
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Override
    public void basicTypes(String str, byte b, short s, int i, long l, float f, double d, char c, boolean bool) {
        if (this.closed) {
            throw new IllegalStateException("Proxy is closed");
        }
        JsonObject _json = new JsonObject();
        _json.put("str", (Object)str);
        _json.put("b", (Object)b);
        _json.put("s", (Object)s);
        _json.put("i", (Object)i);
        _json.put("l", (Object)l);
        _json.put("f", (Object)Float.valueOf(f));
        _json.put("d", (Object)d);
        _json.put("c", (Object)c);
        _json.put("bool", (Object)bool);
        DeliveryOptions _deliveryOptions = this._options != null ? new DeliveryOptions(this._options) : new DeliveryOptions();
        _deliveryOptions.addHeader("action", "basicTypes");
        _deliveryOptions.getHeaders().set("action", "basicTypes");
        this._vertx.eventBus().send(this._address, (Object)_json, _deliveryOptions);
    }

    @Override
    public void basicBoxedTypes(String str, Byte b, Short s, Integer i, Long l, Float f, Double d, Character c, Boolean bool) {
        if (this.closed) {
            throw new IllegalStateException("Proxy is closed");
        }
        JsonObject _json = new JsonObject();
        _json.put("str", (Object)str);
        _json.put("b", (Object)b);
        _json.put("s", (Object)s);
        _json.put("i", (Object)i);
        _json.put("l", (Object)l);
        _json.put("f", (Object)f);
        _json.put("d", (Object)d);
        _json.put("c", c == null ? null : Integer.valueOf(c.charValue()));
        _json.put("bool", (Object)bool);
        DeliveryOptions _deliveryOptions = this._options != null ? new DeliveryOptions(this._options) : new DeliveryOptions();
        _deliveryOptions.addHeader("action", "basicBoxedTypes");
        _deliveryOptions.getHeaders().set("action", "basicBoxedTypes");
        this._vertx.eventBus().send(this._address, (Object)_json, _deliveryOptions);
    }

    @Override
    public void jsonTypes(JsonObject jsonObject, JsonArray jsonArray) {
        if (this.closed) {
            throw new IllegalStateException("Proxy is closed");
        }
        JsonObject _json = new JsonObject();
        _json.put("jsonObject", (Object)jsonObject);
        _json.put("jsonArray", (Object)jsonArray);
        DeliveryOptions _deliveryOptions = this._options != null ? new DeliveryOptions(this._options) : new DeliveryOptions();
        _deliveryOptions.addHeader("action", "jsonTypes");
        _deliveryOptions.getHeaders().set("action", "jsonTypes");
        this._vertx.eventBus().send(this._address, (Object)_json, _deliveryOptions);
    }

    @Override
    public void methodWithListParams(List<String> listString, List<Byte> listByte, List<Short> listShort, List<Integer> listInt, List<Long> listLong, List<JsonObject> listJsonObject, List<JsonArray> listJsonArray) {
        if (this.closed) {
            throw new IllegalStateException("Proxy is closed");
        }
        JsonObject _json = new JsonObject();
        _json.put("listString", (Object)new JsonArray(listString));
        _json.put("listByte", (Object)new JsonArray(listByte));
        _json.put("listShort", (Object)new JsonArray(listShort));
        _json.put("listInt", (Object)new JsonArray(listInt));
        _json.put("listLong", (Object)new JsonArray(listLong));
        _json.put("listJsonObject", (Object)new JsonArray(listJsonObject));
        _json.put("listJsonArray", (Object)new JsonArray(listJsonArray));
        DeliveryOptions _deliveryOptions = this._options != null ? new DeliveryOptions(this._options) : new DeliveryOptions();
        _deliveryOptions.addHeader("action", "methodWithListParams");
        _deliveryOptions.getHeaders().set("action", "methodWithListParams");
        this._vertx.eventBus().send(this._address, (Object)_json, _deliveryOptions);
    }

    @Override
    public void methodWithSetParams(Set<String> setString, Set<Byte> setByte, Set<Short> setShort, Set<Integer> setInt, Set<Long> setLong, Set<JsonObject> setJsonObject, Set<JsonArray> setJsonArray) {
        if (this.closed) {
            throw new IllegalStateException("Proxy is closed");
        }
        JsonObject _json = new JsonObject();
        _json.put("setString", (Object)new JsonArray(new ArrayList<String>(setString)));
        _json.put("setByte", (Object)new JsonArray(new ArrayList<Byte>(setByte)));
        _json.put("setShort", (Object)new JsonArray(new ArrayList<Short>(setShort)));
        _json.put("setInt", (Object)new JsonArray(new ArrayList<Integer>(setInt)));
        _json.put("setLong", (Object)new JsonArray(new ArrayList<Long>(setLong)));
        _json.put("setJsonObject", (Object)new JsonArray(new ArrayList<JsonObject>(setJsonObject)));
        _json.put("setJsonArray", (Object)new JsonArray(new ArrayList<JsonArray>(setJsonArray)));
        DeliveryOptions _deliveryOptions = this._options != null ? new DeliveryOptions(this._options) : new DeliveryOptions();
        _deliveryOptions.addHeader("action", "methodWithSetParams");
        _deliveryOptions.getHeaders().set("action", "methodWithSetParams");
        this._vertx.eventBus().send(this._address, (Object)_json, _deliveryOptions);
    }

    @Override
    public void methodWithMapParams(Map<String, String> mapString, Map<String, Byte> mapByte, Map<String, Short> mapShort, Map<String, Integer> mapInt, Map<String, Long> mapLong, Map<String, JsonObject> mapJsonObject, Map<String, JsonArray> mapJsonArray) {
        if (this.closed) {
            throw new IllegalStateException("Proxy is closed");
        }
        JsonObject _json = new JsonObject();
        _json.put("mapString", (Object)new JsonObject(ProxyUtils.convertMap(mapString)));
        _json.put("mapByte", (Object)new JsonObject(ProxyUtils.convertMap(mapByte)));
        _json.put("mapShort", (Object)new JsonObject(ProxyUtils.convertMap(mapShort)));
        _json.put("mapInt", (Object)new JsonObject(ProxyUtils.convertMap(mapInt)));
        _json.put("mapLong", (Object)new JsonObject(ProxyUtils.convertMap(mapLong)));
        _json.put("mapJsonObject", (Object)new JsonObject(ProxyUtils.convertMap(mapJsonObject)));
        _json.put("mapJsonArray", (Object)new JsonObject(ProxyUtils.convertMap(mapJsonArray)));
        DeliveryOptions _deliveryOptions = this._options != null ? new DeliveryOptions(this._options) : new DeliveryOptions();
        _deliveryOptions.addHeader("action", "methodWithMapParams");
        _deliveryOptions.getHeaders().set("action", "methodWithMapParams");
        this._vertx.eventBus().send(this._address, (Object)_json, _deliveryOptions);
    }

    @Override
    public void enumType(SomeEnum someEnum) {
        if (this.closed) {
            throw new IllegalStateException("Proxy is closed");
        }
        JsonObject _json = new JsonObject();
        _json.put("someEnum", (Object)(someEnum == null ? null : someEnum.name()));
        DeliveryOptions _deliveryOptions = this._options != null ? new DeliveryOptions(this._options) : new DeliveryOptions();
        _deliveryOptions.addHeader("action", "enumType");
        _deliveryOptions.getHeaders().set("action", "enumType");
        this._vertx.eventBus().send(this._address, (Object)_json, _deliveryOptions);
    }

    @Override
    public void enumWithCustomConstructorType(SomeEnumWithCustomConstructor someCustomEnum) {
        if (this.closed) {
            throw new IllegalStateException("Proxy is closed");
        }
        JsonObject _json = new JsonObject();
        _json.put("someCustomEnum", (Object)(someCustomEnum != null ? Mappers.serializeSomeEnumWithCustomConstructor(someCustomEnum) : null));
        DeliveryOptions _deliveryOptions = this._options != null ? new DeliveryOptions(this._options) : new DeliveryOptions();
        _deliveryOptions.addHeader("action", "enumWithCustomConstructorType");
        _deliveryOptions.getHeaders().set("action", "enumWithCustomConstructorType");
        this._vertx.eventBus().send(this._address, (Object)_json, _deliveryOptions);
    }

    @Override
    public void dataObjectType(ProxyDataObject dataObject) {
        if (this.closed) {
            throw new IllegalStateException("Proxy is closed");
        }
        JsonObject _json = new JsonObject();
        _json.put("dataObject", (Object)(dataObject != null ? dataObject.toJson() : null));
        DeliveryOptions _deliveryOptions = this._options != null ? new DeliveryOptions(this._options) : new DeliveryOptions();
        _deliveryOptions.addHeader("action", "dataObjectType");
        _deliveryOptions.getHeaders().set("action", "dataObjectType");
        this._vertx.eventBus().send(this._address, (Object)_json, _deliveryOptions);
    }

    @Override
    public void methodMapper(ZonedDateTime dateTime) {
        if (this.closed) {
            throw new IllegalStateException("Proxy is closed");
        }
        JsonObject _json = new JsonObject();
        _json.put("dateTime", (Object)(dateTime != null ? Mappers.serializeZonedDateTime(dateTime) : null));
        DeliveryOptions _deliveryOptions = this._options != null ? new DeliveryOptions(this._options) : new DeliveryOptions();
        _deliveryOptions.addHeader("action", "methodMapper");
        _deliveryOptions.getHeaders().set("action", "methodMapper");
        this._vertx.eventBus().send(this._address, (Object)_json, _deliveryOptions);
    }

    @Override
    public void dataObjectWithParentType(ProxyDataObjectWithParent dataObject) {
        if (this.closed) {
            throw new IllegalStateException("Proxy is closed");
        }
        JsonObject _json = new JsonObject();
        _json.put("dataObject", (Object)(dataObject != null ? dataObject.toJson() : null));
        DeliveryOptions _deliveryOptions = this._options != null ? new DeliveryOptions(this._options) : new DeliveryOptions();
        _deliveryOptions.addHeader("action", "dataObjectWithParentType");
        _deliveryOptions.getHeaders().set("action", "dataObjectWithParentType");
        this._vertx.eventBus().send(this._address, (Object)_json, _deliveryOptions);
    }

    @Override
    public void dataObjectWithParentAndOverride(ProxyDataObjectWithParentOverride dataObject) {
        if (this.closed) {
            throw new IllegalStateException("Proxy is closed");
        }
        JsonObject _json = new JsonObject();
        _json.put("dataObject", (Object)(dataObject != null ? dataObject.toJson() : null));
        DeliveryOptions _deliveryOptions = this._options != null ? new DeliveryOptions(this._options) : new DeliveryOptions();
        _deliveryOptions.addHeader("action", "dataObjectWithParentAndOverride");
        _deliveryOptions.getHeaders().set("action", "dataObjectWithParentAndOverride");
        this._vertx.eventBus().send(this._address, (Object)_json, _deliveryOptions);
    }

    @Override
    public Future<String> handler0() {
        if (this.closed) {
            return Future.failedFuture((String)"Proxy is closed");
        }
        JsonObject _json = new JsonObject();
        DeliveryOptions _deliveryOptions = this._options != null ? new DeliveryOptions(this._options) : new DeliveryOptions();
        _deliveryOptions.addHeader("action", "handler0");
        _deliveryOptions.getHeaders().set("action", "handler0");
        return this._vertx.eventBus().request(this._address, (Object)_json, _deliveryOptions).map(msg -> (String)msg.body());
    }

    @Override
    public Future<Byte> handler1() {
        if (this.closed) {
            return Future.failedFuture((String)"Proxy is closed");
        }
        JsonObject _json = new JsonObject();
        DeliveryOptions _deliveryOptions = this._options != null ? new DeliveryOptions(this._options) : new DeliveryOptions();
        _deliveryOptions.addHeader("action", "handler1");
        _deliveryOptions.getHeaders().set("action", "handler1");
        return this._vertx.eventBus().request(this._address, (Object)_json, _deliveryOptions).map(msg -> (Byte)msg.body());
    }

    @Override
    public Future<Short> handler2() {
        if (this.closed) {
            return Future.failedFuture((String)"Proxy is closed");
        }
        JsonObject _json = new JsonObject();
        DeliveryOptions _deliveryOptions = this._options != null ? new DeliveryOptions(this._options) : new DeliveryOptions();
        _deliveryOptions.addHeader("action", "handler2");
        _deliveryOptions.getHeaders().set("action", "handler2");
        return this._vertx.eventBus().request(this._address, (Object)_json, _deliveryOptions).map(msg -> (Short)msg.body());
    }

    @Override
    public Future<Integer> handler3() {
        if (this.closed) {
            return Future.failedFuture((String)"Proxy is closed");
        }
        JsonObject _json = new JsonObject();
        DeliveryOptions _deliveryOptions = this._options != null ? new DeliveryOptions(this._options) : new DeliveryOptions();
        _deliveryOptions.addHeader("action", "handler3");
        _deliveryOptions.getHeaders().set("action", "handler3");
        return this._vertx.eventBus().request(this._address, (Object)_json, _deliveryOptions).map(msg -> (Integer)msg.body());
    }

    @Override
    public Future<Long> handler4() {
        if (this.closed) {
            return Future.failedFuture((String)"Proxy is closed");
        }
        JsonObject _json = new JsonObject();
        DeliveryOptions _deliveryOptions = this._options != null ? new DeliveryOptions(this._options) : new DeliveryOptions();
        _deliveryOptions.addHeader("action", "handler4");
        _deliveryOptions.getHeaders().set("action", "handler4");
        return this._vertx.eventBus().request(this._address, (Object)_json, _deliveryOptions).map(msg -> (Long)msg.body());
    }

    @Override
    public Future<Float> handler5() {
        if (this.closed) {
            return Future.failedFuture((String)"Proxy is closed");
        }
        JsonObject _json = new JsonObject();
        DeliveryOptions _deliveryOptions = this._options != null ? new DeliveryOptions(this._options) : new DeliveryOptions();
        _deliveryOptions.addHeader("action", "handler5");
        _deliveryOptions.getHeaders().set("action", "handler5");
        return this._vertx.eventBus().request(this._address, (Object)_json, _deliveryOptions).map(msg -> (Float)msg.body());
    }

    @Override
    public Future<Double> handler6() {
        if (this.closed) {
            return Future.failedFuture((String)"Proxy is closed");
        }
        JsonObject _json = new JsonObject();
        DeliveryOptions _deliveryOptions = this._options != null ? new DeliveryOptions(this._options) : new DeliveryOptions();
        _deliveryOptions.addHeader("action", "handler6");
        _deliveryOptions.getHeaders().set("action", "handler6");
        return this._vertx.eventBus().request(this._address, (Object)_json, _deliveryOptions).map(msg -> (Double)msg.body());
    }

    @Override
    public Future<Character> handler7() {
        if (this.closed) {
            return Future.failedFuture((String)"Proxy is closed");
        }
        JsonObject _json = new JsonObject();
        DeliveryOptions _deliveryOptions = this._options != null ? new DeliveryOptions(this._options) : new DeliveryOptions();
        _deliveryOptions.addHeader("action", "handler7");
        _deliveryOptions.getHeaders().set("action", "handler7");
        return this._vertx.eventBus().request(this._address, (Object)_json, _deliveryOptions).map(msg -> (Character)msg.body());
    }

    @Override
    public Future<Boolean> handler8() {
        if (this.closed) {
            return Future.failedFuture((String)"Proxy is closed");
        }
        JsonObject _json = new JsonObject();
        DeliveryOptions _deliveryOptions = this._options != null ? new DeliveryOptions(this._options) : new DeliveryOptions();
        _deliveryOptions.addHeader("action", "handler8");
        _deliveryOptions.getHeaders().set("action", "handler8");
        return this._vertx.eventBus().request(this._address, (Object)_json, _deliveryOptions).map(msg -> (Boolean)msg.body());
    }

    @Override
    public Future<JsonObject> handler9() {
        if (this.closed) {
            return Future.failedFuture((String)"Proxy is closed");
        }
        JsonObject _json = new JsonObject();
        DeliveryOptions _deliveryOptions = this._options != null ? new DeliveryOptions(this._options) : new DeliveryOptions();
        _deliveryOptions.addHeader("action", "handler9");
        _deliveryOptions.getHeaders().set("action", "handler9");
        return this._vertx.eventBus().request(this._address, (Object)_json, _deliveryOptions).map(msg -> (JsonObject)msg.body());
    }

    @Override
    public Future<JsonArray> handler10() {
        if (this.closed) {
            return Future.failedFuture((String)"Proxy is closed");
        }
        JsonObject _json = new JsonObject();
        DeliveryOptions _deliveryOptions = this._options != null ? new DeliveryOptions(this._options) : new DeliveryOptions();
        _deliveryOptions.addHeader("action", "handler10");
        _deliveryOptions.getHeaders().set("action", "handler10");
        return this._vertx.eventBus().request(this._address, (Object)_json, _deliveryOptions).map(msg -> (JsonArray)msg.body());
    }

    @Override
    public Future<ProxyDataObject> handler11() {
        if (this.closed) {
            return Future.failedFuture((String)"Proxy is closed");
        }
        JsonObject _json = new JsonObject();
        DeliveryOptions _deliveryOptions = this._options != null ? new DeliveryOptions(this._options) : new DeliveryOptions();
        _deliveryOptions.addHeader("action", "handler11");
        _deliveryOptions.getHeaders().set("action", "handler11");
        return this._vertx.eventBus().request(this._address, (Object)_json, _deliveryOptions).map(msg -> msg.body() != null ? new ProxyDataObject((JsonObject)msg.body()) : null);
    }

    @Override
    public Future<List<String>> handler12() {
        if (this.closed) {
            return Future.failedFuture((String)"Proxy is closed");
        }
        JsonObject _json = new JsonObject();
        DeliveryOptions _deliveryOptions = this._options != null ? new DeliveryOptions(this._options) : new DeliveryOptions();
        _deliveryOptions.addHeader("action", "handler12");
        _deliveryOptions.getHeaders().set("action", "handler12");
        return this._vertx.eventBus().request(this._address, (Object)_json, _deliveryOptions).map(msg -> ProxyUtils.convertList((List)((JsonArray)msg.body()).getList()));
    }

    @Override
    public Future<List<Byte>> handler13() {
        if (this.closed) {
            return Future.failedFuture((String)"Proxy is closed");
        }
        JsonObject _json = new JsonObject();
        DeliveryOptions _deliveryOptions = this._options != null ? new DeliveryOptions(this._options) : new DeliveryOptions();
        _deliveryOptions.addHeader("action", "handler13");
        _deliveryOptions.getHeaders().set("action", "handler13");
        return this._vertx.eventBus().request(this._address, (Object)_json, _deliveryOptions).map(msg -> ProxyUtils.convertList((List)((JsonArray)msg.body()).getList()));
    }

    @Override
    public Future<List<Short>> handler14() {
        if (this.closed) {
            return Future.failedFuture((String)"Proxy is closed");
        }
        JsonObject _json = new JsonObject();
        DeliveryOptions _deliveryOptions = this._options != null ? new DeliveryOptions(this._options) : new DeliveryOptions();
        _deliveryOptions.addHeader("action", "handler14");
        _deliveryOptions.getHeaders().set("action", "handler14");
        return this._vertx.eventBus().request(this._address, (Object)_json, _deliveryOptions).map(msg -> ProxyUtils.convertList((List)((JsonArray)msg.body()).getList()));
    }

    @Override
    public Future<List<Integer>> handler15() {
        if (this.closed) {
            return Future.failedFuture((String)"Proxy is closed");
        }
        JsonObject _json = new JsonObject();
        DeliveryOptions _deliveryOptions = this._options != null ? new DeliveryOptions(this._options) : new DeliveryOptions();
        _deliveryOptions.addHeader("action", "handler15");
        _deliveryOptions.getHeaders().set("action", "handler15");
        return this._vertx.eventBus().request(this._address, (Object)_json, _deliveryOptions).map(msg -> ProxyUtils.convertList((List)((JsonArray)msg.body()).getList()));
    }

    @Override
    public Future<List<Long>> handler16() {
        if (this.closed) {
            return Future.failedFuture((String)"Proxy is closed");
        }
        JsonObject _json = new JsonObject();
        DeliveryOptions _deliveryOptions = this._options != null ? new DeliveryOptions(this._options) : new DeliveryOptions();
        _deliveryOptions.addHeader("action", "handler16");
        _deliveryOptions.getHeaders().set("action", "handler16");
        return this._vertx.eventBus().request(this._address, (Object)_json, _deliveryOptions).map(msg -> ProxyUtils.convertList((List)((JsonArray)msg.body()).getList()));
    }

    @Override
    public Future<List<Float>> handler17() {
        if (this.closed) {
            return Future.failedFuture((String)"Proxy is closed");
        }
        JsonObject _json = new JsonObject();
        DeliveryOptions _deliveryOptions = this._options != null ? new DeliveryOptions(this._options) : new DeliveryOptions();
        _deliveryOptions.addHeader("action", "handler17");
        _deliveryOptions.getHeaders().set("action", "handler17");
        return this._vertx.eventBus().request(this._address, (Object)_json, _deliveryOptions).map(msg -> ProxyUtils.convertList((List)((JsonArray)msg.body()).getList()));
    }

    @Override
    public Future<List<Double>> handler18() {
        if (this.closed) {
            return Future.failedFuture((String)"Proxy is closed");
        }
        JsonObject _json = new JsonObject();
        DeliveryOptions _deliveryOptions = this._options != null ? new DeliveryOptions(this._options) : new DeliveryOptions();
        _deliveryOptions.addHeader("action", "handler18");
        _deliveryOptions.getHeaders().set("action", "handler18");
        return this._vertx.eventBus().request(this._address, (Object)_json, _deliveryOptions).map(msg -> ProxyUtils.convertList((List)((JsonArray)msg.body()).getList()));
    }

    @Override
    public Future<List<Character>> handler19() {
        if (this.closed) {
            return Future.failedFuture((String)"Proxy is closed");
        }
        JsonObject _json = new JsonObject();
        DeliveryOptions _deliveryOptions = this._options != null ? new DeliveryOptions(this._options) : new DeliveryOptions();
        _deliveryOptions.addHeader("action", "handler19");
        _deliveryOptions.getHeaders().set("action", "handler19");
        return this._vertx.eventBus().request(this._address, (Object)_json, _deliveryOptions).map(msg -> ProxyUtils.convertToListChar((JsonArray)((JsonArray)msg.body())));
    }

    @Override
    public Future<List<Boolean>> handler20() {
        if (this.closed) {
            return Future.failedFuture((String)"Proxy is closed");
        }
        JsonObject _json = new JsonObject();
        DeliveryOptions _deliveryOptions = this._options != null ? new DeliveryOptions(this._options) : new DeliveryOptions();
        _deliveryOptions.addHeader("action", "handler20");
        _deliveryOptions.getHeaders().set("action", "handler20");
        return this._vertx.eventBus().request(this._address, (Object)_json, _deliveryOptions).map(msg -> ProxyUtils.convertList((List)((JsonArray)msg.body()).getList()));
    }

    @Override
    public Future<List<JsonObject>> handler21() {
        if (this.closed) {
            return Future.failedFuture((String)"Proxy is closed");
        }
        JsonObject _json = new JsonObject();
        DeliveryOptions _deliveryOptions = this._options != null ? new DeliveryOptions(this._options) : new DeliveryOptions();
        _deliveryOptions.addHeader("action", "handler21");
        _deliveryOptions.getHeaders().set("action", "handler21");
        return this._vertx.eventBus().request(this._address, (Object)_json, _deliveryOptions).map(msg -> ProxyUtils.convertList((List)((JsonArray)msg.body()).getList()));
    }

    @Override
    public Future<List<JsonArray>> handler22() {
        if (this.closed) {
            return Future.failedFuture((String)"Proxy is closed");
        }
        JsonObject _json = new JsonObject();
        DeliveryOptions _deliveryOptions = this._options != null ? new DeliveryOptions(this._options) : new DeliveryOptions();
        _deliveryOptions.addHeader("action", "handler22");
        _deliveryOptions.getHeaders().set("action", "handler22");
        return this._vertx.eventBus().request(this._address, (Object)_json, _deliveryOptions).map(msg -> ProxyUtils.convertList((List)((JsonArray)msg.body()).getList()));
    }

    @Override
    public Future<Set<String>> handler24() {
        if (this.closed) {
            return Future.failedFuture((String)"Proxy is closed");
        }
        JsonObject _json = new JsonObject();
        DeliveryOptions _deliveryOptions = this._options != null ? new DeliveryOptions(this._options) : new DeliveryOptions();
        _deliveryOptions.addHeader("action", "handler24");
        _deliveryOptions.getHeaders().set("action", "handler24");
        return this._vertx.eventBus().request(this._address, (Object)_json, _deliveryOptions).map(msg -> ProxyUtils.convertSet((List)((JsonArray)msg.body()).getList()));
    }

    @Override
    public Future<Set<Byte>> handler25() {
        if (this.closed) {
            return Future.failedFuture((String)"Proxy is closed");
        }
        JsonObject _json = new JsonObject();
        DeliveryOptions _deliveryOptions = this._options != null ? new DeliveryOptions(this._options) : new DeliveryOptions();
        _deliveryOptions.addHeader("action", "handler25");
        _deliveryOptions.getHeaders().set("action", "handler25");
        return this._vertx.eventBus().request(this._address, (Object)_json, _deliveryOptions).map(msg -> ProxyUtils.convertSet((List)((JsonArray)msg.body()).getList()));
    }

    @Override
    public Future<Set<Short>> handler26() {
        if (this.closed) {
            return Future.failedFuture((String)"Proxy is closed");
        }
        JsonObject _json = new JsonObject();
        DeliveryOptions _deliveryOptions = this._options != null ? new DeliveryOptions(this._options) : new DeliveryOptions();
        _deliveryOptions.addHeader("action", "handler26");
        _deliveryOptions.getHeaders().set("action", "handler26");
        return this._vertx.eventBus().request(this._address, (Object)_json, _deliveryOptions).map(msg -> ProxyUtils.convertSet((List)((JsonArray)msg.body()).getList()));
    }

    @Override
    public Future<Set<Integer>> handler27() {
        if (this.closed) {
            return Future.failedFuture((String)"Proxy is closed");
        }
        JsonObject _json = new JsonObject();
        DeliveryOptions _deliveryOptions = this._options != null ? new DeliveryOptions(this._options) : new DeliveryOptions();
        _deliveryOptions.addHeader("action", "handler27");
        _deliveryOptions.getHeaders().set("action", "handler27");
        return this._vertx.eventBus().request(this._address, (Object)_json, _deliveryOptions).map(msg -> ProxyUtils.convertSet((List)((JsonArray)msg.body()).getList()));
    }

    @Override
    public Future<Set<Long>> handler28() {
        if (this.closed) {
            return Future.failedFuture((String)"Proxy is closed");
        }
        JsonObject _json = new JsonObject();
        DeliveryOptions _deliveryOptions = this._options != null ? new DeliveryOptions(this._options) : new DeliveryOptions();
        _deliveryOptions.addHeader("action", "handler28");
        _deliveryOptions.getHeaders().set("action", "handler28");
        return this._vertx.eventBus().request(this._address, (Object)_json, _deliveryOptions).map(msg -> ProxyUtils.convertSet((List)((JsonArray)msg.body()).getList()));
    }

    @Override
    public Future<Set<Float>> handler29() {
        if (this.closed) {
            return Future.failedFuture((String)"Proxy is closed");
        }
        JsonObject _json = new JsonObject();
        DeliveryOptions _deliveryOptions = this._options != null ? new DeliveryOptions(this._options) : new DeliveryOptions();
        _deliveryOptions.addHeader("action", "handler29");
        _deliveryOptions.getHeaders().set("action", "handler29");
        return this._vertx.eventBus().request(this._address, (Object)_json, _deliveryOptions).map(msg -> ProxyUtils.convertSet((List)((JsonArray)msg.body()).getList()));
    }

    @Override
    public Future<Set<Double>> handler30() {
        if (this.closed) {
            return Future.failedFuture((String)"Proxy is closed");
        }
        JsonObject _json = new JsonObject();
        DeliveryOptions _deliveryOptions = this._options != null ? new DeliveryOptions(this._options) : new DeliveryOptions();
        _deliveryOptions.addHeader("action", "handler30");
        _deliveryOptions.getHeaders().set("action", "handler30");
        return this._vertx.eventBus().request(this._address, (Object)_json, _deliveryOptions).map(msg -> ProxyUtils.convertSet((List)((JsonArray)msg.body()).getList()));
    }

    @Override
    public Future<Set<Character>> handler31() {
        if (this.closed) {
            return Future.failedFuture((String)"Proxy is closed");
        }
        JsonObject _json = new JsonObject();
        DeliveryOptions _deliveryOptions = this._options != null ? new DeliveryOptions(this._options) : new DeliveryOptions();
        _deliveryOptions.addHeader("action", "handler31");
        _deliveryOptions.getHeaders().set("action", "handler31");
        return this._vertx.eventBus().request(this._address, (Object)_json, _deliveryOptions).map(msg -> ProxyUtils.convertToSetChar((JsonArray)((JsonArray)msg.body())));
    }

    @Override
    public Future<Set<Boolean>> handler32() {
        if (this.closed) {
            return Future.failedFuture((String)"Proxy is closed");
        }
        JsonObject _json = new JsonObject();
        DeliveryOptions _deliveryOptions = this._options != null ? new DeliveryOptions(this._options) : new DeliveryOptions();
        _deliveryOptions.addHeader("action", "handler32");
        _deliveryOptions.getHeaders().set("action", "handler32");
        return this._vertx.eventBus().request(this._address, (Object)_json, _deliveryOptions).map(msg -> ProxyUtils.convertSet((List)((JsonArray)msg.body()).getList()));
    }

    @Override
    public Future<Set<JsonObject>> handler33() {
        if (this.closed) {
            return Future.failedFuture((String)"Proxy is closed");
        }
        JsonObject _json = new JsonObject();
        DeliveryOptions _deliveryOptions = this._options != null ? new DeliveryOptions(this._options) : new DeliveryOptions();
        _deliveryOptions.addHeader("action", "handler33");
        _deliveryOptions.getHeaders().set("action", "handler33");
        return this._vertx.eventBus().request(this._address, (Object)_json, _deliveryOptions).map(msg -> ProxyUtils.convertSet((List)((JsonArray)msg.body()).getList()));
    }

    @Override
    public Future<Set<JsonArray>> handler34() {
        if (this.closed) {
            return Future.failedFuture((String)"Proxy is closed");
        }
        JsonObject _json = new JsonObject();
        DeliveryOptions _deliveryOptions = this._options != null ? new DeliveryOptions(this._options) : new DeliveryOptions();
        _deliveryOptions.addHeader("action", "handler34");
        _deliveryOptions.getHeaders().set("action", "handler34");
        return this._vertx.eventBus().request(this._address, (Object)_json, _deliveryOptions).map(msg -> ProxyUtils.convertSet((List)((JsonArray)msg.body()).getList()));
    }

    @Override
    public Future<ZonedDateTime> handler35() {
        if (this.closed) {
            return Future.failedFuture((String)"Proxy is closed");
        }
        JsonObject _json = new JsonObject();
        DeliveryOptions _deliveryOptions = this._options != null ? new DeliveryOptions(this._options) : new DeliveryOptions();
        _deliveryOptions.addHeader("action", "handler35");
        _deliveryOptions.getHeaders().set("action", "handler35");
        return this._vertx.eventBus().request(this._address, (Object)_json, _deliveryOptions).map(msg -> msg.body() != null ? Mappers.deserializeZonedDateTime((String)msg.body()) : null);
    }

    @Override
    public Future<List<ZonedDateTime>> handler36() {
        if (this.closed) {
            return Future.failedFuture((String)"Proxy is closed");
        }
        JsonObject _json = new JsonObject();
        DeliveryOptions _deliveryOptions = this._options != null ? new DeliveryOptions(this._options) : new DeliveryOptions();
        _deliveryOptions.addHeader("action", "handler36");
        _deliveryOptions.getHeaders().set("action", "handler36");
        return this._vertx.eventBus().request(this._address, (Object)_json, _deliveryOptions).map(msg -> ((JsonArray)msg.body()).stream().map(v -> v != null ? Mappers.deserializeZonedDateTime((String)v) : null).collect(Collectors.toList()));
    }

    @Override
    public Future<Set<ZonedDateTime>> handler37() {
        if (this.closed) {
            return Future.failedFuture((String)"Proxy is closed");
        }
        JsonObject _json = new JsonObject();
        DeliveryOptions _deliveryOptions = this._options != null ? new DeliveryOptions(this._options) : new DeliveryOptions();
        _deliveryOptions.addHeader("action", "handler37");
        _deliveryOptions.getHeaders().set("action", "handler37");
        return this._vertx.eventBus().request(this._address, (Object)_json, _deliveryOptions).map(msg -> ((JsonArray)msg.body()).stream().map(v -> v != null ? Mappers.deserializeZonedDateTime((String)v) : null).collect(Collectors.toSet()));
    }

    @Override
    public void ignored() {
    }

    @Override
    public void closeIt() {
        if (this.closed) {
            throw new IllegalStateException("Proxy is closed");
        }
        this.closed = true;
        JsonObject _json = new JsonObject();
        DeliveryOptions _deliveryOptions = this._options != null ? new DeliveryOptions(this._options) : new DeliveryOptions();
        _deliveryOptions.addHeader("action", "closeIt");
        _deliveryOptions.getHeaders().set("action", "closeIt");
        this._vertx.eventBus().send(this._address, (Object)_json, _deliveryOptions);
    }

    @Override
    public Future<ProxyConnection> connection(String foo) {
        if (this.closed) {
            return Future.failedFuture((String)"Proxy is closed");
        }
        JsonObject _json = new JsonObject();
        _json.put("foo", (Object)foo);
        DeliveryOptions _deliveryOptions = this._options != null ? new DeliveryOptions(this._options) : new DeliveryOptions();
        _deliveryOptions.addHeader("action", "connection");
        _deliveryOptions.getHeaders().set("action", "connection");
        return this._vertx.eventBus().request(this._address, (Object)_json, _deliveryOptions).map(msg -> new ProxyConnectionVertxEBProxy(this._vertx, msg.headers().get("proxyaddr")));
    }
}

