/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.serviceproxy.tests.codegen.proxytestapi;

import io.vertx.core.Vertx;
import io.vertx.core.eventbus.DeliveryOptions;
import io.vertx.core.eventbus.Message;
import io.vertx.core.eventbus.MessageCodec;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.serviceproxy.HelperUtils;
import io.vertx.serviceproxy.ProxyHandler;
import io.vertx.serviceproxy.ServiceBinder;
import io.vertx.serviceproxy.ServiceException;
import io.vertx.serviceproxy.ServiceExceptionMessageCodec;
import io.vertx.serviceproxy.tests.codegen.proxytestapi.ProxyConnection;
import io.vertx.serviceproxy.tests.codegen.proxytestapi.ProxyDataObject;
import io.vertx.serviceproxy.tests.codegen.proxytestapi.ProxyDataObjectWithParent;
import io.vertx.serviceproxy.tests.codegen.proxytestapi.ProxyDataObjectWithParentOverride;
import io.vertx.serviceproxy.tests.codegen.proxytestapi.SomeEnum;
import io.vertx.serviceproxy.tests.codegen.proxytestapi.ValidProxy;
import io.vertx.serviceproxy.tests.testmodel.Mappers;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;

public class ValidProxyVertxProxyHandler
extends ProxyHandler {
    public static final long DEFAULT_CONNECTION_TIMEOUT = 300L;
    private final Vertx vertx;
    private final ValidProxy service;
    private final long timerID;
    private long lastAccessed;
    private final long timeoutSeconds;
    private final boolean includeDebugInfo;

    public ValidProxyVertxProxyHandler(Vertx vertx, ValidProxy service) {
        this(vertx, service, 300L);
    }

    public ValidProxyVertxProxyHandler(Vertx vertx, ValidProxy service, long timeoutInSecond) {
        this(vertx, service, true, timeoutInSecond);
    }

    public ValidProxyVertxProxyHandler(Vertx vertx, ValidProxy service, boolean topLevel, long timeoutInSecond) {
        this(vertx, service, true, timeoutInSecond, false);
    }

    public ValidProxyVertxProxyHandler(Vertx vertx, ValidProxy service, boolean topLevel, long timeoutSeconds, boolean includeDebugInfo) {
        this.vertx = vertx;
        this.service = service;
        this.includeDebugInfo = includeDebugInfo;
        this.timeoutSeconds = timeoutSeconds;
        try {
            this.vertx.eventBus().registerDefaultCodec(ServiceException.class, (MessageCodec)new ServiceExceptionMessageCodec());
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        if (timeoutSeconds != -1L && !topLevel) {
            long period = timeoutSeconds * 1000L / 2L;
            if (period > 10000L) {
                period = 10000L;
            }
            this.timerID = vertx.setPeriodic(period, this::checkTimedOut);
        } else {
            this.timerID = -1L;
        }
        this.accessed();
    }

    private void checkTimedOut(long id) {
        long now = System.nanoTime();
        if (now - this.lastAccessed > this.timeoutSeconds * 1000000000L) {
            this.service.closeIt();
            this.close();
        }
    }

    public void close() {
        if (this.timerID != -1L) {
            this.vertx.cancelTimer(this.timerID);
        }
        super.close();
    }

    private void accessed() {
        this.lastAccessed = System.nanoTime();
    }

    public void handle(Message<JsonObject> msg) {
        try {
            JsonObject json = (JsonObject)msg.body();
            String action = msg.headers().get("action");
            if (action == null) {
                throw new IllegalStateException("action not specified");
            }
            this.accessed();
            switch (action) {
                case "basicTypes": {
                    this.service.basicTypes((String)json.getValue("str"), json.getValue("b") == null ? null : Byte.valueOf(json.getLong("b").byteValue()), json.getValue("s") == null ? null : Short.valueOf(json.getLong("s").shortValue()), json.getValue("i") == null ? null : Integer.valueOf(json.getLong("i").intValue()), json.getValue("l") == null ? null : Long.valueOf(json.getLong("l")), (json.getValue("f") == null ? null : Float.valueOf(json.getDouble("f").floatValue())).floatValue(), json.getValue("d") == null ? null : Double.valueOf(json.getDouble("d")), (json.getInteger("c") == null ? null : Character.valueOf((char)json.getInteger("c").intValue())).charValue(), (Boolean)json.getValue("bool"));
                    break;
                }
                case "basicBoxedTypes": {
                    this.service.basicBoxedTypes((String)json.getValue("str"), json.getValue("b") == null ? null : Byte.valueOf(json.getLong("b").byteValue()), json.getValue("s") == null ? null : Short.valueOf(json.getLong("s").shortValue()), json.getValue("i") == null ? null : Integer.valueOf(json.getLong("i").intValue()), json.getValue("l") == null ? null : Long.valueOf(json.getLong("l")), json.getValue("f") == null ? null : Float.valueOf(json.getDouble("f").floatValue()), json.getValue("d") == null ? null : Double.valueOf(json.getDouble("d")), json.getInteger("c") == null ? null : Character.valueOf((char)json.getInteger("c").intValue()), (Boolean)json.getValue("bool"));
                    break;
                }
                case "jsonTypes": {
                    this.service.jsonTypes((JsonObject)json.getValue("jsonObject"), (JsonArray)json.getValue("jsonArray"));
                    break;
                }
                case "methodWithListParams": {
                    this.service.methodWithListParams(HelperUtils.convertList((List)json.getJsonArray("listString").getList()), json.getJsonArray("listByte").stream().map(o -> ((Number)o).byteValue()).collect(Collectors.toList()), json.getJsonArray("listShort").stream().map(o -> ((Number)o).shortValue()).collect(Collectors.toList()), json.getJsonArray("listInt").stream().map(o -> ((Number)o).intValue()).collect(Collectors.toList()), json.getJsonArray("listLong").stream().map(o -> ((Number)o).longValue()).collect(Collectors.toList()), HelperUtils.convertList((List)json.getJsonArray("listJsonObject").getList()), HelperUtils.convertList((List)json.getJsonArray("listJsonArray").getList()));
                    break;
                }
                case "methodWithSetParams": {
                    this.service.methodWithSetParams(HelperUtils.convertSet((List)json.getJsonArray("setString").getList()), json.getJsonArray("setByte").stream().map(o -> ((Number)o).byteValue()).collect(Collectors.toSet()), json.getJsonArray("setShort").stream().map(o -> ((Number)o).shortValue()).collect(Collectors.toSet()), json.getJsonArray("setInt").stream().map(o -> ((Number)o).intValue()).collect(Collectors.toSet()), json.getJsonArray("setLong").stream().map(o -> ((Number)o).longValue()).collect(Collectors.toSet()), HelperUtils.convertSet((List)json.getJsonArray("setJsonObject").getList()), HelperUtils.convertSet((List)json.getJsonArray("setJsonArray").getList()));
                    break;
                }
                case "methodWithMapParams": {
                    this.service.methodWithMapParams(HelperUtils.convertMap((Map)json.getJsonObject("mapString").getMap()), json.getJsonObject("mapByte").getMap().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((Number)entry.getValue()).byteValue())), json.getJsonObject("mapShort").getMap().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((Number)entry.getValue()).shortValue())), json.getJsonObject("mapInt").getMap().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((Number)entry.getValue()).intValue())), json.getJsonObject("mapLong").getMap().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((Number)entry.getValue()).longValue())), HelperUtils.convertMap((Map)json.getJsonObject("mapJsonObject").getMap()), HelperUtils.convertMap((Map)json.getJsonObject("mapJsonArray").getMap()));
                    break;
                }
                case "enumType": {
                    this.service.enumType(json.getString("someEnum") == null ? null : SomeEnum.valueOf(json.getString("someEnum")));
                    break;
                }
                case "enumWithCustomConstructorType": {
                    this.service.enumWithCustomConstructorType(json.getString("someCustomEnum") != null ? Mappers.deserializeSomeEnumWithCustomConstructor(json.getString("someCustomEnum")) : null);
                    break;
                }
                case "dataObjectType": {
                    this.service.dataObjectType(json.getJsonObject("dataObject") != null ? new ProxyDataObject(json.getJsonObject("dataObject")) : null);
                    break;
                }
                case "methodMapper": {
                    this.service.methodMapper(json.getValue("dateTime") != null ? Mappers.deserializeZonedDateTime((String)json.getValue("dateTime")) : null);
                    break;
                }
                case "dataObjectWithParentType": {
                    this.service.dataObjectWithParentType(json.getJsonObject("dataObject") != null ? new ProxyDataObjectWithParent(json.getJsonObject("dataObject")) : null);
                    break;
                }
                case "dataObjectWithParentAndOverride": {
                    this.service.dataObjectWithParentAndOverride(json.getJsonObject("dataObject") != null ? new ProxyDataObjectWithParentOverride(json.getJsonObject("dataObject")) : null);
                    break;
                }
                case "handler0": {
                    this.service.handler0().onComplete(HelperUtils.createHandler(msg, (boolean)this.includeDebugInfo));
                    break;
                }
                case "handler1": {
                    this.service.handler1().onComplete(HelperUtils.createHandler(msg, (boolean)this.includeDebugInfo));
                    break;
                }
                case "handler2": {
                    this.service.handler2().onComplete(HelperUtils.createHandler(msg, (boolean)this.includeDebugInfo));
                    break;
                }
                case "handler3": {
                    this.service.handler3().onComplete(HelperUtils.createHandler(msg, (boolean)this.includeDebugInfo));
                    break;
                }
                case "handler4": {
                    this.service.handler4().onComplete(HelperUtils.createHandler(msg, (boolean)this.includeDebugInfo));
                    break;
                }
                case "handler5": {
                    this.service.handler5().onComplete(HelperUtils.createHandler(msg, (boolean)this.includeDebugInfo));
                    break;
                }
                case "handler6": {
                    this.service.handler6().onComplete(HelperUtils.createHandler(msg, (boolean)this.includeDebugInfo));
                    break;
                }
                case "handler7": {
                    this.service.handler7().onComplete(HelperUtils.createHandler(msg, (boolean)this.includeDebugInfo));
                    break;
                }
                case "handler8": {
                    this.service.handler8().onComplete(HelperUtils.createHandler(msg, (boolean)this.includeDebugInfo));
                    break;
                }
                case "handler9": {
                    this.service.handler9().onComplete(HelperUtils.createHandler(msg, (boolean)this.includeDebugInfo));
                    break;
                }
                case "handler10": {
                    this.service.handler10().onComplete(HelperUtils.createHandler(msg, (boolean)this.includeDebugInfo));
                    break;
                }
                case "handler11": {
                    this.service.handler11().onComplete(res -> {
                        if (res.failed()) {
                            HelperUtils.manageFailure((Message)msg, (Throwable)res.cause(), (boolean)this.includeDebugInfo);
                        } else {
                            msg.reply(res.result() != null ? ((ProxyDataObject)res.result()).toJson() : null);
                        }
                    });
                    break;
                }
                case "handler12": {
                    this.service.handler12().onComplete(HelperUtils.createListHandler(msg, (boolean)this.includeDebugInfo));
                    break;
                }
                case "handler13": {
                    this.service.handler13().onComplete(HelperUtils.createListHandler(msg, (boolean)this.includeDebugInfo));
                    break;
                }
                case "handler14": {
                    this.service.handler14().onComplete(HelperUtils.createListHandler(msg, (boolean)this.includeDebugInfo));
                    break;
                }
                case "handler15": {
                    this.service.handler15().onComplete(HelperUtils.createListHandler(msg, (boolean)this.includeDebugInfo));
                    break;
                }
                case "handler16": {
                    this.service.handler16().onComplete(HelperUtils.createListHandler(msg, (boolean)this.includeDebugInfo));
                    break;
                }
                case "handler17": {
                    this.service.handler17().onComplete(HelperUtils.createListHandler(msg, (boolean)this.includeDebugInfo));
                    break;
                }
                case "handler18": {
                    this.service.handler18().onComplete(HelperUtils.createListHandler(msg, (boolean)this.includeDebugInfo));
                    break;
                }
                case "handler19": {
                    this.service.handler19().onComplete(HelperUtils.createListCharHandler(msg, (boolean)this.includeDebugInfo));
                    break;
                }
                case "handler20": {
                    this.service.handler20().onComplete(HelperUtils.createListHandler(msg, (boolean)this.includeDebugInfo));
                    break;
                }
                case "handler21": {
                    this.service.handler21().onComplete(HelperUtils.createListHandler(msg, (boolean)this.includeDebugInfo));
                    break;
                }
                case "handler22": {
                    this.service.handler22().onComplete(HelperUtils.createListHandler(msg, (boolean)this.includeDebugInfo));
                    break;
                }
                case "handler24": {
                    this.service.handler24().onComplete(HelperUtils.createSetHandler(msg, (boolean)this.includeDebugInfo));
                    break;
                }
                case "handler25": {
                    this.service.handler25().onComplete(HelperUtils.createSetHandler(msg, (boolean)this.includeDebugInfo));
                    break;
                }
                case "handler26": {
                    this.service.handler26().onComplete(HelperUtils.createSetHandler(msg, (boolean)this.includeDebugInfo));
                    break;
                }
                case "handler27": {
                    this.service.handler27().onComplete(HelperUtils.createSetHandler(msg, (boolean)this.includeDebugInfo));
                    break;
                }
                case "handler28": {
                    this.service.handler28().onComplete(HelperUtils.createSetHandler(msg, (boolean)this.includeDebugInfo));
                    break;
                }
                case "handler29": {
                    this.service.handler29().onComplete(HelperUtils.createSetHandler(msg, (boolean)this.includeDebugInfo));
                    break;
                }
                case "handler30": {
                    this.service.handler30().onComplete(HelperUtils.createSetHandler(msg, (boolean)this.includeDebugInfo));
                    break;
                }
                case "handler31": {
                    this.service.handler31().onComplete(HelperUtils.createSetCharHandler(msg, (boolean)this.includeDebugInfo));
                    break;
                }
                case "handler32": {
                    this.service.handler32().onComplete(HelperUtils.createSetHandler(msg, (boolean)this.includeDebugInfo));
                    break;
                }
                case "handler33": {
                    this.service.handler33().onComplete(HelperUtils.createSetHandler(msg, (boolean)this.includeDebugInfo));
                    break;
                }
                case "handler34": {
                    this.service.handler34().onComplete(HelperUtils.createSetHandler(msg, (boolean)this.includeDebugInfo));
                    break;
                }
                case "handler35": {
                    this.service.handler35().onComplete(res -> {
                        if (res.failed()) {
                            HelperUtils.manageFailure((Message)msg, (Throwable)res.cause(), (boolean)this.includeDebugInfo);
                        } else {
                            msg.reply(res.result() != null ? Mappers.serializeZonedDateTime((ZonedDateTime)res.result()) : null);
                        }
                    });
                    break;
                }
                case "handler36": {
                    this.service.handler36().onComplete(res -> {
                        if (res.failed()) {
                            HelperUtils.manageFailure((Message)msg, (Throwable)res.cause(), (boolean)this.includeDebugInfo);
                        } else {
                            msg.reply((Object)new JsonArray(((List)res.result()).stream().map(v -> v != null ? Mappers.serializeZonedDateTime(v) : null).collect(Collectors.toList())));
                        }
                    });
                    break;
                }
                case "handler37": {
                    this.service.handler37().onComplete(res -> {
                        if (res.failed()) {
                            HelperUtils.manageFailure((Message)msg, (Throwable)res.cause(), (boolean)this.includeDebugInfo);
                        } else {
                            msg.reply((Object)new JsonArray(((Set)res.result()).stream().map(v -> v != null ? Mappers.serializeZonedDateTime(v) : null).collect(Collectors.toList())));
                        }
                    });
                    break;
                }
                case "ignored": {
                    this.service.ignored();
                    break;
                }
                case "closeIt": {
                    this.service.closeIt();
                    this.close();
                    break;
                }
                case "connection": {
                    this.service.connection((String)json.getValue("foo")).onComplete(res -> {
                        if (res.failed()) {
                            HelperUtils.manageFailure((Message)msg, (Throwable)res.cause(), (boolean)this.includeDebugInfo);
                        } else {
                            String proxyAddress = UUID.randomUUID().toString();
                            new ServiceBinder(this.vertx).setAddress(proxyAddress).setTopLevel(false).setTimeoutSeconds(this.timeoutSeconds).register(ProxyConnection.class, (Object)((ProxyConnection)res.result()));
                            msg.reply(null, new DeliveryOptions().addHeader("proxyaddr", proxyAddress));
                        }
                    });
                    break;
                }
                default: {
                    throw new IllegalStateException("Invalid action: " + action);
                }
            }
        }
        catch (Throwable t) {
            if (this.includeDebugInfo) {
                msg.reply((Object)new ServiceException(500, t.getMessage(), HelperUtils.generateDebugInfo((Throwable)t)));
            } else {
                msg.reply((Object)new ServiceException(500, t.getMessage()));
            }
            throw t;
        }
    }
}

